// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/firestore/v1/firestore.proto

package firestore

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The type of change.
type TargetChange_TargetChangeType int32

const (
	// No change has occurred. Used only to send an updated `resume_token`.
	TargetChange_NO_CHANGE TargetChange_TargetChangeType = 0
	// The targets have been added.
	TargetChange_ADD TargetChange_TargetChangeType = 1
	// The targets have been removed.
	TargetChange_REMOVE TargetChange_TargetChangeType = 2
	// The targets reflect all changes committed before the targets were added
	// to the stream.
	//
	// This will be sent after or with a `read_time` that is greater than or
	// equal to the time at which the targets were added.
	//
	// Listeners can wait for this change if read-after-write semantics
	// are desired.
	TargetChange_CURRENT TargetChange_TargetChangeType = 3
	// The targets have been reset, and a new initial state for the targets
	// will be returned in subsequent changes.
	//
	// After the initial state is complete, `CURRENT` will be returned even
	// if the target was previously indicated to be `CURRENT`.
	TargetChange_RESET TargetChange_TargetChangeType = 4
)

var TargetChange_TargetChangeType_name = map[int32]string{
	0: "NO_CHANGE",
	1: "ADD",
	2: "REMOVE",
	3: "CURRENT",
	4: "RESET",
}

var TargetChange_TargetChangeType_value = map[string]int32{
	"NO_CHANGE": 0,
	"ADD":       1,
	"REMOVE":    2,
	"CURRENT":   3,
	"RESET":     4,
}

func (x TargetChange_TargetChangeType) String() string {
	return proto.EnumName(TargetChange_TargetChangeType_name, int32(x))
}

func (TargetChange_TargetChangeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{20, 0}
}

// The request for [Firestore.GetDocument][google.firestore.v1.Firestore.GetDocument].
type GetDocumentRequest struct {
	// The resource name of the Document to get. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If the document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,2,opt,name=mask,proto3" json:"mask,omitempty"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are valid to be assigned to ConsistencySelector:
	//	*GetDocumentRequest_Transaction
	//	*GetDocumentRequest_ReadTime
	ConsistencySelector  isGetDocumentRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *GetDocumentRequest) Reset()         { *m = GetDocumentRequest{} }
func (m *GetDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*GetDocumentRequest) ProtoMessage()    {}
func (*GetDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{0}
}

func (m *GetDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDocumentRequest.Unmarshal(m, b)
}
func (m *GetDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDocumentRequest.Marshal(b, m, deterministic)
}
func (m *GetDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDocumentRequest.Merge(m, src)
}
func (m *GetDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_GetDocumentRequest.Size(m)
}
func (m *GetDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDocumentRequest proto.InternalMessageInfo

func (m *GetDocumentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetDocumentRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

type isGetDocumentRequest_ConsistencySelector interface {
	isGetDocumentRequest_ConsistencySelector()
}

type GetDocumentRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,3,opt,name=transaction,proto3,oneof"`
}

type GetDocumentRequest_ReadTime struct {
	ReadTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*GetDocumentRequest_Transaction) isGetDocumentRequest_ConsistencySelector() {}

func (*GetDocumentRequest_ReadTime) isGetDocumentRequest_ConsistencySelector() {}

func (m *GetDocumentRequest) GetConsistencySelector() isGetDocumentRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (m *GetDocumentRequest) GetTransaction() []byte {
	if x, ok := m.GetConsistencySelector().(*GetDocumentRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *GetDocumentRequest) GetReadTime() *timestamp.Timestamp {
	if x, ok := m.GetConsistencySelector().(*GetDocumentRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GetDocumentRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GetDocumentRequest_Transaction)(nil),
		(*GetDocumentRequest_ReadTime)(nil),
	}
}

// The request for [Firestore.ListDocuments][google.firestore.v1.Firestore.ListDocuments].
type ListDocumentsRequest struct {
	// The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The collection ID, relative to `parent`, to list. For example: `chatrooms`
	// or `messages`.
	CollectionId string `protobuf:"bytes,2,opt,name=collection_id,json=collectionId,proto3" json:"collection_id,omitempty"`
	// The maximum number of documents to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `next_page_token` value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The order to sort results by. For example: `priority desc, name`.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If a document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,7,opt,name=mask,proto3" json:"mask,omitempty"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are valid to be assigned to ConsistencySelector:
	//	*ListDocumentsRequest_Transaction
	//	*ListDocumentsRequest_ReadTime
	ConsistencySelector isListDocumentsRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
	// If the list should show missing documents. A missing document is a
	// document that does not exist but has sub-documents. These documents will
	// be returned with a key but will not have fields, [Document.create_time][google.firestore.v1.Document.create_time],
	// or [Document.update_time][google.firestore.v1.Document.update_time] set.
	//
	// Requests with `show_missing` may not specify `where` or
	// `order_by`.
	ShowMissing          bool     `protobuf:"varint,12,opt,name=show_missing,json=showMissing,proto3" json:"show_missing,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDocumentsRequest) Reset()         { *m = ListDocumentsRequest{} }
func (m *ListDocumentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDocumentsRequest) ProtoMessage()    {}
func (*ListDocumentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{1}
}

func (m *ListDocumentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDocumentsRequest.Unmarshal(m, b)
}
func (m *ListDocumentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDocumentsRequest.Marshal(b, m, deterministic)
}
func (m *ListDocumentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDocumentsRequest.Merge(m, src)
}
func (m *ListDocumentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDocumentsRequest.Size(m)
}
func (m *ListDocumentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDocumentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDocumentsRequest proto.InternalMessageInfo

func (m *ListDocumentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDocumentsRequest) GetCollectionId() string {
	if m != nil {
		return m.CollectionId
	}
	return ""
}

func (m *ListDocumentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDocumentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDocumentsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListDocumentsRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

type isListDocumentsRequest_ConsistencySelector interface {
	isListDocumentsRequest_ConsistencySelector()
}

type ListDocumentsRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,8,opt,name=transaction,proto3,oneof"`
}

type ListDocumentsRequest_ReadTime struct {
	ReadTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*ListDocumentsRequest_Transaction) isListDocumentsRequest_ConsistencySelector() {}

func (*ListDocumentsRequest_ReadTime) isListDocumentsRequest_ConsistencySelector() {}

func (m *ListDocumentsRequest) GetConsistencySelector() isListDocumentsRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (m *ListDocumentsRequest) GetTransaction() []byte {
	if x, ok := m.GetConsistencySelector().(*ListDocumentsRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *ListDocumentsRequest) GetReadTime() *timestamp.Timestamp {
	if x, ok := m.GetConsistencySelector().(*ListDocumentsRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

func (m *ListDocumentsRequest) GetShowMissing() bool {
	if m != nil {
		return m.ShowMissing
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ListDocumentsRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ListDocumentsRequest_Transaction)(nil),
		(*ListDocumentsRequest_ReadTime)(nil),
	}
}

// The response for [Firestore.ListDocuments][google.firestore.v1.Firestore.ListDocuments].
type ListDocumentsResponse struct {
	// The Documents found.
	Documents []*Document `protobuf:"bytes,1,rep,name=documents,proto3" json:"documents,omitempty"`
	// The next page token.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDocumentsResponse) Reset()         { *m = ListDocumentsResponse{} }
func (m *ListDocumentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDocumentsResponse) ProtoMessage()    {}
func (*ListDocumentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{2}
}

func (m *ListDocumentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDocumentsResponse.Unmarshal(m, b)
}
func (m *ListDocumentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDocumentsResponse.Marshal(b, m, deterministic)
}
func (m *ListDocumentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDocumentsResponse.Merge(m, src)
}
func (m *ListDocumentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDocumentsResponse.Size(m)
}
func (m *ListDocumentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDocumentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDocumentsResponse proto.InternalMessageInfo

func (m *ListDocumentsResponse) GetDocuments() []*Document {
	if m != nil {
		return m.Documents
	}
	return nil
}

func (m *ListDocumentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [Firestore.CreateDocument][google.firestore.v1.Firestore.CreateDocument].
type CreateDocumentRequest struct {
	// The parent resource. For example:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/chatrooms/{chatroom_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The collection ID, relative to `parent`, to list. For example: `chatrooms`.
	CollectionId string `protobuf:"bytes,2,opt,name=collection_id,json=collectionId,proto3" json:"collection_id,omitempty"`
	// The client-assigned document ID to use for this document.
	//
	// Optional. If not specified, an ID will be assigned by the service.
	DocumentId string `protobuf:"bytes,3,opt,name=document_id,json=documentId,proto3" json:"document_id,omitempty"`
	// The document to create. `name` must not be set.
	Document *Document `protobuf:"bytes,4,opt,name=document,proto3" json:"document,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If the document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask                 *DocumentMask `protobuf:"bytes,5,opt,name=mask,proto3" json:"mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateDocumentRequest) Reset()         { *m = CreateDocumentRequest{} }
func (m *CreateDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDocumentRequest) ProtoMessage()    {}
func (*CreateDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{3}
}

func (m *CreateDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDocumentRequest.Unmarshal(m, b)
}
func (m *CreateDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDocumentRequest.Marshal(b, m, deterministic)
}
func (m *CreateDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDocumentRequest.Merge(m, src)
}
func (m *CreateDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDocumentRequest.Size(m)
}
func (m *CreateDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDocumentRequest proto.InternalMessageInfo

func (m *CreateDocumentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDocumentRequest) GetCollectionId() string {
	if m != nil {
		return m.CollectionId
	}
	return ""
}

func (m *CreateDocumentRequest) GetDocumentId() string {
	if m != nil {
		return m.DocumentId
	}
	return ""
}

func (m *CreateDocumentRequest) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *CreateDocumentRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

// The request for [Firestore.UpdateDocument][google.firestore.v1.Firestore.UpdateDocument].
type UpdateDocumentRequest struct {
	// The updated document.
	// Creates the document if it does not already exist.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The fields to update.
	// None of the field paths in the mask may contain a reserved name.
	//
	// If the document exists on the server and has fields not referenced in the
	// mask, they are left unchanged.
	// Fields referenced in the mask, but not present in the input document, are
	// deleted from the document on the server.
	UpdateMask *DocumentMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If the document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,3,opt,name=mask,proto3" json:"mask,omitempty"`
	// An optional precondition on the document.
	// The request will fail if this is set and not met by the target document.
	CurrentDocument      *Precondition `protobuf:"bytes,4,opt,name=current_document,json=currentDocument,proto3" json:"current_document,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *UpdateDocumentRequest) Reset()         { *m = UpdateDocumentRequest{} }
func (m *UpdateDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDocumentRequest) ProtoMessage()    {}
func (*UpdateDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{4}
}

func (m *UpdateDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDocumentRequest.Unmarshal(m, b)
}
func (m *UpdateDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDocumentRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDocumentRequest.Merge(m, src)
}
func (m *UpdateDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDocumentRequest.Size(m)
}
func (m *UpdateDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDocumentRequest proto.InternalMessageInfo

func (m *UpdateDocumentRequest) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *UpdateDocumentRequest) GetUpdateMask() *DocumentMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateDocumentRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

func (m *UpdateDocumentRequest) GetCurrentDocument() *Precondition {
	if m != nil {
		return m.CurrentDocument
	}
	return nil
}

// The request for [Firestore.DeleteDocument][google.firestore.v1.Firestore.DeleteDocument].
type DeleteDocumentRequest struct {
	// The resource name of the Document to delete. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional precondition on the document.
	// The request will fail if this is set and not met by the target document.
	CurrentDocument      *Precondition `protobuf:"bytes,2,opt,name=current_document,json=currentDocument,proto3" json:"current_document,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DeleteDocumentRequest) Reset()         { *m = DeleteDocumentRequest{} }
func (m *DeleteDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDocumentRequest) ProtoMessage()    {}
func (*DeleteDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{5}
}

func (m *DeleteDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDocumentRequest.Unmarshal(m, b)
}
func (m *DeleteDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDocumentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDocumentRequest.Merge(m, src)
}
func (m *DeleteDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDocumentRequest.Size(m)
}
func (m *DeleteDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDocumentRequest proto.InternalMessageInfo

func (m *DeleteDocumentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteDocumentRequest) GetCurrentDocument() *Precondition {
	if m != nil {
		return m.CurrentDocument
	}
	return nil
}

// The request for [Firestore.BatchGetDocuments][google.firestore.v1.Firestore.BatchGetDocuments].
type BatchGetDocumentsRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The names of the documents to retrieve. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// The request will fail if any of the document is not a child resource of the
	// given `database`. Duplicate names will be elided.
	Documents []string `protobuf:"bytes,2,rep,name=documents,proto3" json:"documents,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If a document has a field that is not present in this mask, that field will
	// not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,3,opt,name=mask,proto3" json:"mask,omitempty"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are valid to be assigned to ConsistencySelector:
	//	*BatchGetDocumentsRequest_Transaction
	//	*BatchGetDocumentsRequest_NewTransaction
	//	*BatchGetDocumentsRequest_ReadTime
	ConsistencySelector  isBatchGetDocumentsRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *BatchGetDocumentsRequest) Reset()         { *m = BatchGetDocumentsRequest{} }
func (m *BatchGetDocumentsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchGetDocumentsRequest) ProtoMessage()    {}
func (*BatchGetDocumentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{6}
}

func (m *BatchGetDocumentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchGetDocumentsRequest.Unmarshal(m, b)
}
func (m *BatchGetDocumentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchGetDocumentsRequest.Marshal(b, m, deterministic)
}
func (m *BatchGetDocumentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetDocumentsRequest.Merge(m, src)
}
func (m *BatchGetDocumentsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchGetDocumentsRequest.Size(m)
}
func (m *BatchGetDocumentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetDocumentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetDocumentsRequest proto.InternalMessageInfo

func (m *BatchGetDocumentsRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *BatchGetDocumentsRequest) GetDocuments() []string {
	if m != nil {
		return m.Documents
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

type isBatchGetDocumentsRequest_ConsistencySelector interface {
	isBatchGetDocumentsRequest_ConsistencySelector()
}

type BatchGetDocumentsRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,4,opt,name=transaction,proto3,oneof"`
}

type BatchGetDocumentsRequest_NewTransaction struct {
	NewTransaction *TransactionOptions `protobuf:"bytes,5,opt,name=new_transaction,json=newTransaction,proto3,oneof"`
}

type BatchGetDocumentsRequest_ReadTime struct {
	ReadTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*BatchGetDocumentsRequest_Transaction) isBatchGetDocumentsRequest_ConsistencySelector() {}

func (*BatchGetDocumentsRequest_NewTransaction) isBatchGetDocumentsRequest_ConsistencySelector() {}

func (*BatchGetDocumentsRequest_ReadTime) isBatchGetDocumentsRequest_ConsistencySelector() {}

func (m *BatchGetDocumentsRequest) GetConsistencySelector() isBatchGetDocumentsRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetTransaction() []byte {
	if x, ok := m.GetConsistencySelector().(*BatchGetDocumentsRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetNewTransaction() *TransactionOptions {
	if x, ok := m.GetConsistencySelector().(*BatchGetDocumentsRequest_NewTransaction); ok {
		return x.NewTransaction
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetReadTime() *timestamp.Timestamp {
	if x, ok := m.GetConsistencySelector().(*BatchGetDocumentsRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BatchGetDocumentsRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BatchGetDocumentsRequest_Transaction)(nil),
		(*BatchGetDocumentsRequest_NewTransaction)(nil),
		(*BatchGetDocumentsRequest_ReadTime)(nil),
	}
}

// The streamed response for [Firestore.BatchGetDocuments][google.firestore.v1.Firestore.BatchGetDocuments].
type BatchGetDocumentsResponse struct {
	// A single result.
	// This can be empty if the server is just returning a transaction.
	//
	// Types that are valid to be assigned to Result:
	//	*BatchGetDocumentsResponse_Found
	//	*BatchGetDocumentsResponse_Missing
	Result isBatchGetDocumentsResponse_Result `protobuf_oneof:"result"`
	// The transaction that was started as part of this request.
	// Will only be set in the first response, and only if
	// [BatchGetDocumentsRequest.new_transaction][google.firestore.v1.BatchGetDocumentsRequest.new_transaction] was set in the request.
	Transaction []byte `protobuf:"bytes,3,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// The time at which the document was read.
	// This may be monotically increasing, in this case the previous documents in
	// the result stream are guaranteed not to have changed between their
	// read_time and this one.
	ReadTime             *timestamp.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *BatchGetDocumentsResponse) Reset()         { *m = BatchGetDocumentsResponse{} }
func (m *BatchGetDocumentsResponse) String() string { return proto.CompactTextString(m) }
func (*BatchGetDocumentsResponse) ProtoMessage()    {}
func (*BatchGetDocumentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{7}
}

func (m *BatchGetDocumentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchGetDocumentsResponse.Unmarshal(m, b)
}
func (m *BatchGetDocumentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchGetDocumentsResponse.Marshal(b, m, deterministic)
}
func (m *BatchGetDocumentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetDocumentsResponse.Merge(m, src)
}
func (m *BatchGetDocumentsResponse) XXX_Size() int {
	return xxx_messageInfo_BatchGetDocumentsResponse.Size(m)
}
func (m *BatchGetDocumentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetDocumentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetDocumentsResponse proto.InternalMessageInfo

type isBatchGetDocumentsResponse_Result interface {
	isBatchGetDocumentsResponse_Result()
}

type BatchGetDocumentsResponse_Found struct {
	Found *Document `protobuf:"bytes,1,opt,name=found,proto3,oneof"`
}

type BatchGetDocumentsResponse_Missing struct {
	Missing string `protobuf:"bytes,2,opt,name=missing,proto3,oneof"`
}

func (*BatchGetDocumentsResponse_Found) isBatchGetDocumentsResponse_Result() {}

func (*BatchGetDocumentsResponse_Missing) isBatchGetDocumentsResponse_Result() {}

func (m *BatchGetDocumentsResponse) GetResult() isBatchGetDocumentsResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *BatchGetDocumentsResponse) GetFound() *Document {
	if x, ok := m.GetResult().(*BatchGetDocumentsResponse_Found); ok {
		return x.Found
	}
	return nil
}

func (m *BatchGetDocumentsResponse) GetMissing() string {
	if x, ok := m.GetResult().(*BatchGetDocumentsResponse_Missing); ok {
		return x.Missing
	}
	return ""
}

func (m *BatchGetDocumentsResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *BatchGetDocumentsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BatchGetDocumentsResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BatchGetDocumentsResponse_Found)(nil),
		(*BatchGetDocumentsResponse_Missing)(nil),
	}
}

// The request for [Firestore.BeginTransaction][google.firestore.v1.Firestore.BeginTransaction].
type BeginTransactionRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The options for the transaction.
	// Defaults to a read-write transaction.
	Options              *TransactionOptions `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *BeginTransactionRequest) Reset()         { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()    {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{8}
}

func (m *BeginTransactionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginTransactionRequest.Unmarshal(m, b)
}
func (m *BeginTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginTransactionRequest.Marshal(b, m, deterministic)
}
func (m *BeginTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginTransactionRequest.Merge(m, src)
}
func (m *BeginTransactionRequest) XXX_Size() int {
	return xxx_messageInfo_BeginTransactionRequest.Size(m)
}
func (m *BeginTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BeginTransactionRequest proto.InternalMessageInfo

func (m *BeginTransactionRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *BeginTransactionRequest) GetOptions() *TransactionOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// The response for [Firestore.BeginTransaction][google.firestore.v1.Firestore.BeginTransaction].
type BeginTransactionResponse struct {
	// The transaction that was started.
	Transaction          []byte   `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginTransactionResponse) Reset()         { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()    {}
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{9}
}

func (m *BeginTransactionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginTransactionResponse.Unmarshal(m, b)
}
func (m *BeginTransactionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginTransactionResponse.Marshal(b, m, deterministic)
}
func (m *BeginTransactionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginTransactionResponse.Merge(m, src)
}
func (m *BeginTransactionResponse) XXX_Size() int {
	return xxx_messageInfo_BeginTransactionResponse.Size(m)
}
func (m *BeginTransactionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginTransactionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BeginTransactionResponse proto.InternalMessageInfo

func (m *BeginTransactionResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for [Firestore.Commit][google.firestore.v1.Firestore.Commit].
type CommitRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The writes to apply.
	//
	// Always executed atomically and in order.
	Writes []*Write `protobuf:"bytes,2,rep,name=writes,proto3" json:"writes,omitempty"`
	// If set, applies all writes in this transaction, and commits it.
	Transaction          []byte   `protobuf:"bytes,3,opt,name=transaction,proto3" json:"transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitRequest) Reset()         { *m = CommitRequest{} }
func (m *CommitRequest) String() string { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()    {}
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{10}
}

func (m *CommitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitRequest.Unmarshal(m, b)
}
func (m *CommitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitRequest.Marshal(b, m, deterministic)
}
func (m *CommitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitRequest.Merge(m, src)
}
func (m *CommitRequest) XXX_Size() int {
	return xxx_messageInfo_CommitRequest.Size(m)
}
func (m *CommitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitRequest proto.InternalMessageInfo

func (m *CommitRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *CommitRequest) GetWrites() []*Write {
	if m != nil {
		return m.Writes
	}
	return nil
}

func (m *CommitRequest) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The response for [Firestore.Commit][google.firestore.v1.Firestore.Commit].
type CommitResponse struct {
	// The result of applying the writes.
	//
	// This i-th write result corresponds to the i-th write in the
	// request.
	WriteResults []*WriteResult `protobuf:"bytes,1,rep,name=write_results,json=writeResults,proto3" json:"write_results,omitempty"`
	// The time at which the commit occurred.
	CommitTime           *timestamp.Timestamp `protobuf:"bytes,2,opt,name=commit_time,json=commitTime,proto3" json:"commit_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{11}
}

func (m *CommitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitResponse.Unmarshal(m, b)
}
func (m *CommitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitResponse.Marshal(b, m, deterministic)
}
func (m *CommitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResponse.Merge(m, src)
}
func (m *CommitResponse) XXX_Size() int {
	return xxx_messageInfo_CommitResponse.Size(m)
}
func (m *CommitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResponse proto.InternalMessageInfo

func (m *CommitResponse) GetWriteResults() []*WriteResult {
	if m != nil {
		return m.WriteResults
	}
	return nil
}

func (m *CommitResponse) GetCommitTime() *timestamp.Timestamp {
	if m != nil {
		return m.CommitTime
	}
	return nil
}

// The request for [Firestore.Rollback][google.firestore.v1.Firestore.Rollback].
type RollbackRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The transaction to roll back.
	Transaction          []byte   `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackRequest) Reset()         { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()    {}
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{12}
}

func (m *RollbackRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackRequest.Unmarshal(m, b)
}
func (m *RollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackRequest.Marshal(b, m, deterministic)
}
func (m *RollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackRequest.Merge(m, src)
}
func (m *RollbackRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackRequest.Size(m)
}
func (m *RollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackRequest proto.InternalMessageInfo

func (m *RollbackRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *RollbackRequest) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery].
type RunQueryRequest struct {
	// The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The query to run.
	//
	// Types that are valid to be assigned to QueryType:
	//	*RunQueryRequest_StructuredQuery
	QueryType isRunQueryRequest_QueryType `protobuf_oneof:"query_type"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are valid to be assigned to ConsistencySelector:
	//	*RunQueryRequest_Transaction
	//	*RunQueryRequest_NewTransaction
	//	*RunQueryRequest_ReadTime
	ConsistencySelector  isRunQueryRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *RunQueryRequest) Reset()         { *m = RunQueryRequest{} }
func (m *RunQueryRequest) String() string { return proto.CompactTextString(m) }
func (*RunQueryRequest) ProtoMessage()    {}
func (*RunQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{13}
}

func (m *RunQueryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunQueryRequest.Unmarshal(m, b)
}
func (m *RunQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunQueryRequest.Marshal(b, m, deterministic)
}
func (m *RunQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunQueryRequest.Merge(m, src)
}
func (m *RunQueryRequest) XXX_Size() int {
	return xxx_messageInfo_RunQueryRequest.Size(m)
}
func (m *RunQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunQueryRequest proto.InternalMessageInfo

func (m *RunQueryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isRunQueryRequest_QueryType interface {
	isRunQueryRequest_QueryType()
}

type RunQueryRequest_StructuredQuery struct {
	StructuredQuery *StructuredQuery `protobuf:"bytes,2,opt,name=structured_query,json=structuredQuery,proto3,oneof"`
}

func (*RunQueryRequest_StructuredQuery) isRunQueryRequest_QueryType() {}

func (m *RunQueryRequest) GetQueryType() isRunQueryRequest_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (m *RunQueryRequest) GetStructuredQuery() *StructuredQuery {
	if x, ok := m.GetQueryType().(*RunQueryRequest_StructuredQuery); ok {
		return x.StructuredQuery
	}
	return nil
}

type isRunQueryRequest_ConsistencySelector interface {
	isRunQueryRequest_ConsistencySelector()
}

type RunQueryRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,5,opt,name=transaction,proto3,oneof"`
}

type RunQueryRequest_NewTransaction struct {
	NewTransaction *TransactionOptions `protobuf:"bytes,6,opt,name=new_transaction,json=newTransaction,proto3,oneof"`
}

type RunQueryRequest_ReadTime struct {
	ReadTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*RunQueryRequest_Transaction) isRunQueryRequest_ConsistencySelector() {}

func (*RunQueryRequest_NewTransaction) isRunQueryRequest_ConsistencySelector() {}

func (*RunQueryRequest_ReadTime) isRunQueryRequest_ConsistencySelector() {}

func (m *RunQueryRequest) GetConsistencySelector() isRunQueryRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (m *RunQueryRequest) GetTransaction() []byte {
	if x, ok := m.GetConsistencySelector().(*RunQueryRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *RunQueryRequest) GetNewTransaction() *TransactionOptions {
	if x, ok := m.GetConsistencySelector().(*RunQueryRequest_NewTransaction); ok {
		return x.NewTransaction
	}
	return nil
}

func (m *RunQueryRequest) GetReadTime() *timestamp.Timestamp {
	if x, ok := m.GetConsistencySelector().(*RunQueryRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RunQueryRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RunQueryRequest_StructuredQuery)(nil),
		(*RunQueryRequest_Transaction)(nil),
		(*RunQueryRequest_NewTransaction)(nil),
		(*RunQueryRequest_ReadTime)(nil),
	}
}

// The response for [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery].
type RunQueryResponse struct {
	// The transaction that was started as part of this request.
	// Can only be set in the first response, and only if
	// [RunQueryRequest.new_transaction][google.firestore.v1.RunQueryRequest.new_transaction] was set in the request.
	// If set, no other fields will be set in this response.
	Transaction []byte `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// A query result.
	// Not set when reporting partial progress.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The time at which the document was read. This may be monotonically
	// increasing; in this case, the previous documents in the result stream are
	// guaranteed not to have changed between their `read_time` and this one.
	//
	// If the query returns no results, a response with `read_time` and no
	// `document` will be sent, and this represents the time at which the query
	// was run.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// The number of results that have been skipped due to an offset between
	// the last response and the current response.
	SkippedResults       int32    `protobuf:"varint,4,opt,name=skipped_results,json=skippedResults,proto3" json:"skipped_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunQueryResponse) Reset()         { *m = RunQueryResponse{} }
func (m *RunQueryResponse) String() string { return proto.CompactTextString(m) }
func (*RunQueryResponse) ProtoMessage()    {}
func (*RunQueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{14}
}

func (m *RunQueryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunQueryResponse.Unmarshal(m, b)
}
func (m *RunQueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunQueryResponse.Marshal(b, m, deterministic)
}
func (m *RunQueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunQueryResponse.Merge(m, src)
}
func (m *RunQueryResponse) XXX_Size() int {
	return xxx_messageInfo_RunQueryResponse.Size(m)
}
func (m *RunQueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RunQueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RunQueryResponse proto.InternalMessageInfo

func (m *RunQueryResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *RunQueryResponse) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *RunQueryResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *RunQueryResponse) GetSkippedResults() int32 {
	if m != nil {
		return m.SkippedResults
	}
	return 0
}

// The request for [Firestore.Write][google.firestore.v1.Firestore.Write].
//
// The first request creates a stream, or resumes an existing one from a token.
//
// When creating a new stream, the server replies with a response containing
// only an ID and a token, to use in the next request.
//
// When resuming a stream, the server first streams any responses later than the
// given token, then a response containing only an up-to-date token, to use in
// the next request.
type WriteRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	// This is only required in the first message.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The ID of the write stream to resume.
	// This may only be set in the first message. When left empty, a new write
	// stream will be created.
	StreamId string `protobuf:"bytes,2,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// The writes to apply.
	//
	// Always executed atomically and in order.
	// This must be empty on the first request.
	// This may be empty on the last request.
	// This must not be empty on all other requests.
	Writes []*Write `protobuf:"bytes,3,rep,name=writes,proto3" json:"writes,omitempty"`
	// A stream token that was previously sent by the server.
	//
	// The client should set this field to the token from the most recent
	// [WriteResponse][google.firestore.v1.WriteResponse] it has received. This acknowledges that the client has
	// received responses up to this token. After sending this token, earlier
	// tokens may not be used anymore.
	//
	// The server may close the stream if there are too many unacknowledged
	// responses.
	//
	// Leave this field unset when creating a new stream. To resume a stream at
	// a specific point, set this field and the `stream_id` field.
	//
	// Leave this field unset when creating a new stream.
	StreamToken []byte `protobuf:"bytes,4,opt,name=stream_token,json=streamToken,proto3" json:"stream_token,omitempty"`
	// Labels associated with this write request.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *WriteRequest) Reset()         { *m = WriteRequest{} }
func (m *WriteRequest) String() string { return proto.CompactTextString(m) }
func (*WriteRequest) ProtoMessage()    {}
func (*WriteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{15}
}

func (m *WriteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteRequest.Unmarshal(m, b)
}
func (m *WriteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteRequest.Marshal(b, m, deterministic)
}
func (m *WriteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteRequest.Merge(m, src)
}
func (m *WriteRequest) XXX_Size() int {
	return xxx_messageInfo_WriteRequest.Size(m)
}
func (m *WriteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteRequest proto.InternalMessageInfo

func (m *WriteRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *WriteRequest) GetStreamId() string {
	if m != nil {
		return m.StreamId
	}
	return ""
}

func (m *WriteRequest) GetWrites() []*Write {
	if m != nil {
		return m.Writes
	}
	return nil
}

func (m *WriteRequest) GetStreamToken() []byte {
	if m != nil {
		return m.StreamToken
	}
	return nil
}

func (m *WriteRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// The response for [Firestore.Write][google.firestore.v1.Firestore.Write].
type WriteResponse struct {
	// The ID of the stream.
	// Only set on the first message, when a new stream was created.
	StreamId string `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// A token that represents the position of this response in the stream.
	// This can be used by a client to resume the stream at this point.
	//
	// This field is always set.
	StreamToken []byte `protobuf:"bytes,2,opt,name=stream_token,json=streamToken,proto3" json:"stream_token,omitempty"`
	// The result of applying the writes.
	//
	// This i-th write result corresponds to the i-th write in the
	// request.
	WriteResults []*WriteResult `protobuf:"bytes,3,rep,name=write_results,json=writeResults,proto3" json:"write_results,omitempty"`
	// The time at which the commit occurred.
	CommitTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=commit_time,json=commitTime,proto3" json:"commit_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *WriteResponse) Reset()         { *m = WriteResponse{} }
func (m *WriteResponse) String() string { return proto.CompactTextString(m) }
func (*WriteResponse) ProtoMessage()    {}
func (*WriteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{16}
}

func (m *WriteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteResponse.Unmarshal(m, b)
}
func (m *WriteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteResponse.Marshal(b, m, deterministic)
}
func (m *WriteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteResponse.Merge(m, src)
}
func (m *WriteResponse) XXX_Size() int {
	return xxx_messageInfo_WriteResponse.Size(m)
}
func (m *WriteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WriteResponse proto.InternalMessageInfo

func (m *WriteResponse) GetStreamId() string {
	if m != nil {
		return m.StreamId
	}
	return ""
}

func (m *WriteResponse) GetStreamToken() []byte {
	if m != nil {
		return m.StreamToken
	}
	return nil
}

func (m *WriteResponse) GetWriteResults() []*WriteResult {
	if m != nil {
		return m.WriteResults
	}
	return nil
}

func (m *WriteResponse) GetCommitTime() *timestamp.Timestamp {
	if m != nil {
		return m.CommitTime
	}
	return nil
}

// A request for [Firestore.Listen][google.firestore.v1.Firestore.Listen]
type ListenRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The supported target changes.
	//
	// Types that are valid to be assigned to TargetChange:
	//	*ListenRequest_AddTarget
	//	*ListenRequest_RemoveTarget
	TargetChange isListenRequest_TargetChange `protobuf_oneof:"target_change"`
	// Labels associated with this target change.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListenRequest) Reset()         { *m = ListenRequest{} }
func (m *ListenRequest) String() string { return proto.CompactTextString(m) }
func (*ListenRequest) ProtoMessage()    {}
func (*ListenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{17}
}

func (m *ListenRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListenRequest.Unmarshal(m, b)
}
func (m *ListenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListenRequest.Marshal(b, m, deterministic)
}
func (m *ListenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListenRequest.Merge(m, src)
}
func (m *ListenRequest) XXX_Size() int {
	return xxx_messageInfo_ListenRequest.Size(m)
}
func (m *ListenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListenRequest proto.InternalMessageInfo

func (m *ListenRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

type isListenRequest_TargetChange interface {
	isListenRequest_TargetChange()
}

type ListenRequest_AddTarget struct {
	AddTarget *Target `protobuf:"bytes,2,opt,name=add_target,json=addTarget,proto3,oneof"`
}

type ListenRequest_RemoveTarget struct {
	RemoveTarget int32 `protobuf:"varint,3,opt,name=remove_target,json=removeTarget,proto3,oneof"`
}

func (*ListenRequest_AddTarget) isListenRequest_TargetChange() {}

func (*ListenRequest_RemoveTarget) isListenRequest_TargetChange() {}

func (m *ListenRequest) GetTargetChange() isListenRequest_TargetChange {
	if m != nil {
		return m.TargetChange
	}
	return nil
}

func (m *ListenRequest) GetAddTarget() *Target {
	if x, ok := m.GetTargetChange().(*ListenRequest_AddTarget); ok {
		return x.AddTarget
	}
	return nil
}

func (m *ListenRequest) GetRemoveTarget() int32 {
	if x, ok := m.GetTargetChange().(*ListenRequest_RemoveTarget); ok {
		return x.RemoveTarget
	}
	return 0
}

func (m *ListenRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ListenRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ListenRequest_AddTarget)(nil),
		(*ListenRequest_RemoveTarget)(nil),
	}
}

// The response for [Firestore.Listen][google.firestore.v1.Firestore.Listen].
type ListenResponse struct {
	// The supported responses.
	//
	// Types that are valid to be assigned to ResponseType:
	//	*ListenResponse_TargetChange
	//	*ListenResponse_DocumentChange
	//	*ListenResponse_DocumentDelete
	//	*ListenResponse_DocumentRemove
	//	*ListenResponse_Filter
	ResponseType         isListenResponse_ResponseType `protobuf_oneof:"response_type"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ListenResponse) Reset()         { *m = ListenResponse{} }
func (m *ListenResponse) String() string { return proto.CompactTextString(m) }
func (*ListenResponse) ProtoMessage()    {}
func (*ListenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{18}
}

func (m *ListenResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListenResponse.Unmarshal(m, b)
}
func (m *ListenResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListenResponse.Marshal(b, m, deterministic)
}
func (m *ListenResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListenResponse.Merge(m, src)
}
func (m *ListenResponse) XXX_Size() int {
	return xxx_messageInfo_ListenResponse.Size(m)
}
func (m *ListenResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListenResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListenResponse proto.InternalMessageInfo

type isListenResponse_ResponseType interface {
	isListenResponse_ResponseType()
}

type ListenResponse_TargetChange struct {
	TargetChange *TargetChange `protobuf:"bytes,2,opt,name=target_change,json=targetChange,proto3,oneof"`
}

type ListenResponse_DocumentChange struct {
	DocumentChange *DocumentChange `protobuf:"bytes,3,opt,name=document_change,json=documentChange,proto3,oneof"`
}

type ListenResponse_DocumentDelete struct {
	DocumentDelete *DocumentDelete `protobuf:"bytes,4,opt,name=document_delete,json=documentDelete,proto3,oneof"`
}

type ListenResponse_DocumentRemove struct {
	DocumentRemove *DocumentRemove `protobuf:"bytes,6,opt,name=document_remove,json=documentRemove,proto3,oneof"`
}

type ListenResponse_Filter struct {
	Filter *ExistenceFilter `protobuf:"bytes,5,opt,name=filter,proto3,oneof"`
}

func (*ListenResponse_TargetChange) isListenResponse_ResponseType() {}

func (*ListenResponse_DocumentChange) isListenResponse_ResponseType() {}

func (*ListenResponse_DocumentDelete) isListenResponse_ResponseType() {}

func (*ListenResponse_DocumentRemove) isListenResponse_ResponseType() {}

func (*ListenResponse_Filter) isListenResponse_ResponseType() {}

func (m *ListenResponse) GetResponseType() isListenResponse_ResponseType {
	if m != nil {
		return m.ResponseType
	}
	return nil
}

func (m *ListenResponse) GetTargetChange() *TargetChange {
	if x, ok := m.GetResponseType().(*ListenResponse_TargetChange); ok {
		return x.TargetChange
	}
	return nil
}

func (m *ListenResponse) GetDocumentChange() *DocumentChange {
	if x, ok := m.GetResponseType().(*ListenResponse_DocumentChange); ok {
		return x.DocumentChange
	}
	return nil
}

func (m *ListenResponse) GetDocumentDelete() *DocumentDelete {
	if x, ok := m.GetResponseType().(*ListenResponse_DocumentDelete); ok {
		return x.DocumentDelete
	}
	return nil
}

func (m *ListenResponse) GetDocumentRemove() *DocumentRemove {
	if x, ok := m.GetResponseType().(*ListenResponse_DocumentRemove); ok {
		return x.DocumentRemove
	}
	return nil
}

func (m *ListenResponse) GetFilter() *ExistenceFilter {
	if x, ok := m.GetResponseType().(*ListenResponse_Filter); ok {
		return x.Filter
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ListenResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ListenResponse_TargetChange)(nil),
		(*ListenResponse_DocumentChange)(nil),
		(*ListenResponse_DocumentDelete)(nil),
		(*ListenResponse_DocumentRemove)(nil),
		(*ListenResponse_Filter)(nil),
	}
}

// A specification of a set of documents to listen to.
type Target struct {
	// The type of target to listen to.
	//
	// Types that are valid to be assigned to TargetType:
	//	*Target_Query
	//	*Target_Documents
	TargetType isTarget_TargetType `protobuf_oneof:"target_type"`
	// When to start listening.
	//
	// If not specified, all matching Documents are returned before any
	// subsequent changes.
	//
	// Types that are valid to be assigned to ResumeType:
	//	*Target_ResumeToken
	//	*Target_ReadTime
	ResumeType isTarget_ResumeType `protobuf_oneof:"resume_type"`
	// The target ID that identifies the target on the stream. Must be a positive
	// number and non-zero.
	TargetId int32 `protobuf:"varint,5,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// If the target should be removed once it is current and consistent.
	Once                 bool     `protobuf:"varint,6,opt,name=once,proto3" json:"once,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Target) Reset()         { *m = Target{} }
func (m *Target) String() string { return proto.CompactTextString(m) }
func (*Target) ProtoMessage()    {}
func (*Target) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{19}
}

func (m *Target) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Target.Unmarshal(m, b)
}
func (m *Target) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Target.Marshal(b, m, deterministic)
}
func (m *Target) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Target.Merge(m, src)
}
func (m *Target) XXX_Size() int {
	return xxx_messageInfo_Target.Size(m)
}
func (m *Target) XXX_DiscardUnknown() {
	xxx_messageInfo_Target.DiscardUnknown(m)
}

var xxx_messageInfo_Target proto.InternalMessageInfo

type isTarget_TargetType interface {
	isTarget_TargetType()
}

type Target_Query struct {
	Query *Target_QueryTarget `protobuf:"bytes,2,opt,name=query,proto3,oneof"`
}

type Target_Documents struct {
	Documents *Target_DocumentsTarget `protobuf:"bytes,3,opt,name=documents,proto3,oneof"`
}

func (*Target_Query) isTarget_TargetType() {}

func (*Target_Documents) isTarget_TargetType() {}

func (m *Target) GetTargetType() isTarget_TargetType {
	if m != nil {
		return m.TargetType
	}
	return nil
}

func (m *Target) GetQuery() *Target_QueryTarget {
	if x, ok := m.GetTargetType().(*Target_Query); ok {
		return x.Query
	}
	return nil
}

func (m *Target) GetDocuments() *Target_DocumentsTarget {
	if x, ok := m.GetTargetType().(*Target_Documents); ok {
		return x.Documents
	}
	return nil
}

type isTarget_ResumeType interface {
	isTarget_ResumeType()
}

type Target_ResumeToken struct {
	ResumeToken []byte `protobuf:"bytes,4,opt,name=resume_token,json=resumeToken,proto3,oneof"`
}

type Target_ReadTime struct {
	ReadTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*Target_ResumeToken) isTarget_ResumeType() {}

func (*Target_ReadTime) isTarget_ResumeType() {}

func (m *Target) GetResumeType() isTarget_ResumeType {
	if m != nil {
		return m.ResumeType
	}
	return nil
}

func (m *Target) GetResumeToken() []byte {
	if x, ok := m.GetResumeType().(*Target_ResumeToken); ok {
		return x.ResumeToken
	}
	return nil
}

func (m *Target) GetReadTime() *timestamp.Timestamp {
	if x, ok := m.GetResumeType().(*Target_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

func (m *Target) GetTargetId() int32 {
	if m != nil {
		return m.TargetId
	}
	return 0
}

func (m *Target) GetOnce() bool {
	if m != nil {
		return m.Once
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Target) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Target_Query)(nil),
		(*Target_Documents)(nil),
		(*Target_ResumeToken)(nil),
		(*Target_ReadTime)(nil),
	}
}

// A target specified by a set of documents names.
type Target_DocumentsTarget struct {
	// The names of the documents to retrieve. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// The request will fail if any of the document is not a child resource of
	// the given `database`. Duplicate names will be elided.
	Documents            []string `protobuf:"bytes,2,rep,name=documents,proto3" json:"documents,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Target_DocumentsTarget) Reset()         { *m = Target_DocumentsTarget{} }
func (m *Target_DocumentsTarget) String() string { return proto.CompactTextString(m) }
func (*Target_DocumentsTarget) ProtoMessage()    {}
func (*Target_DocumentsTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{19, 0}
}

func (m *Target_DocumentsTarget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Target_DocumentsTarget.Unmarshal(m, b)
}
func (m *Target_DocumentsTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Target_DocumentsTarget.Marshal(b, m, deterministic)
}
func (m *Target_DocumentsTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Target_DocumentsTarget.Merge(m, src)
}
func (m *Target_DocumentsTarget) XXX_Size() int {
	return xxx_messageInfo_Target_DocumentsTarget.Size(m)
}
func (m *Target_DocumentsTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_Target_DocumentsTarget.DiscardUnknown(m)
}

var xxx_messageInfo_Target_DocumentsTarget proto.InternalMessageInfo

func (m *Target_DocumentsTarget) GetDocuments() []string {
	if m != nil {
		return m.Documents
	}
	return nil
}

// A target specified by a query.
type Target_QueryTarget struct {
	// The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The query to run.
	//
	// Types that are valid to be assigned to QueryType:
	//	*Target_QueryTarget_StructuredQuery
	QueryType            isTarget_QueryTarget_QueryType `protobuf_oneof:"query_type"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *Target_QueryTarget) Reset()         { *m = Target_QueryTarget{} }
func (m *Target_QueryTarget) String() string { return proto.CompactTextString(m) }
func (*Target_QueryTarget) ProtoMessage()    {}
func (*Target_QueryTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{19, 1}
}

func (m *Target_QueryTarget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Target_QueryTarget.Unmarshal(m, b)
}
func (m *Target_QueryTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Target_QueryTarget.Marshal(b, m, deterministic)
}
func (m *Target_QueryTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Target_QueryTarget.Merge(m, src)
}
func (m *Target_QueryTarget) XXX_Size() int {
	return xxx_messageInfo_Target_QueryTarget.Size(m)
}
func (m *Target_QueryTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_Target_QueryTarget.DiscardUnknown(m)
}

var xxx_messageInfo_Target_QueryTarget proto.InternalMessageInfo

func (m *Target_QueryTarget) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isTarget_QueryTarget_QueryType interface {
	isTarget_QueryTarget_QueryType()
}

type Target_QueryTarget_StructuredQuery struct {
	StructuredQuery *StructuredQuery `protobuf:"bytes,2,opt,name=structured_query,json=structuredQuery,proto3,oneof"`
}

func (*Target_QueryTarget_StructuredQuery) isTarget_QueryTarget_QueryType() {}

func (m *Target_QueryTarget) GetQueryType() isTarget_QueryTarget_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (m *Target_QueryTarget) GetStructuredQuery() *StructuredQuery {
	if x, ok := m.GetQueryType().(*Target_QueryTarget_StructuredQuery); ok {
		return x.StructuredQuery
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Target_QueryTarget) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Target_QueryTarget_StructuredQuery)(nil),
	}
}

// Targets being watched have changed.
type TargetChange struct {
	// The type of change that occurred.
	TargetChangeType TargetChange_TargetChangeType `protobuf:"varint,1,opt,name=target_change_type,json=targetChangeType,proto3,enum=google.firestore.v1.TargetChange_TargetChangeType" json:"target_change_type,omitempty"`
	// The target IDs of targets that have changed.
	//
	// If empty, the change applies to all targets.
	//
	// The order of the target IDs is not defined.
	TargetIds []int32 `protobuf:"varint,2,rep,packed,name=target_ids,json=targetIds,proto3" json:"target_ids,omitempty"`
	// The error that resulted in this change, if applicable.
	Cause *status.Status `protobuf:"bytes,3,opt,name=cause,proto3" json:"cause,omitempty"`
	// A token that can be used to resume the stream for the given `target_ids`,
	// or all targets if `target_ids` is empty.
	//
	// Not set on every target change.
	ResumeToken []byte `protobuf:"bytes,4,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// The consistent `read_time` for the given `target_ids` (omitted when the
	// target_ids are not at a consistent snapshot).
	//
	// The stream is guaranteed to send a `read_time` with `target_ids` empty
	// whenever the entire stream reaches a new consistent snapshot. ADD,
	// CURRENT, and RESET messages are guaranteed to (eventually) result in a
	// new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
	//
	// For a given stream, `read_time` is guaranteed to be monotonically
	// increasing.
	ReadTime             *timestamp.Timestamp `protobuf:"bytes,6,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TargetChange) Reset()         { *m = TargetChange{} }
func (m *TargetChange) String() string { return proto.CompactTextString(m) }
func (*TargetChange) ProtoMessage()    {}
func (*TargetChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{20}
}

func (m *TargetChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetChange.Unmarshal(m, b)
}
func (m *TargetChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetChange.Marshal(b, m, deterministic)
}
func (m *TargetChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetChange.Merge(m, src)
}
func (m *TargetChange) XXX_Size() int {
	return xxx_messageInfo_TargetChange.Size(m)
}
func (m *TargetChange) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetChange.DiscardUnknown(m)
}

var xxx_messageInfo_TargetChange proto.InternalMessageInfo

func (m *TargetChange) GetTargetChangeType() TargetChange_TargetChangeType {
	if m != nil {
		return m.TargetChangeType
	}
	return TargetChange_NO_CHANGE
}

func (m *TargetChange) GetTargetIds() []int32 {
	if m != nil {
		return m.TargetIds
	}
	return nil
}

func (m *TargetChange) GetCause() *status.Status {
	if m != nil {
		return m.Cause
	}
	return nil
}

func (m *TargetChange) GetResumeToken() []byte {
	if m != nil {
		return m.ResumeToken
	}
	return nil
}

func (m *TargetChange) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

// The request for [Firestore.ListCollectionIds][google.firestore.v1.Firestore.ListCollectionIds].
type ListCollectionIdsRequest struct {
	// The parent document. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token. Must be a value from
	// [ListCollectionIdsResponse][google.firestore.v1.ListCollectionIdsResponse].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCollectionIdsRequest) Reset()         { *m = ListCollectionIdsRequest{} }
func (m *ListCollectionIdsRequest) String() string { return proto.CompactTextString(m) }
func (*ListCollectionIdsRequest) ProtoMessage()    {}
func (*ListCollectionIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{21}
}

func (m *ListCollectionIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCollectionIdsRequest.Unmarshal(m, b)
}
func (m *ListCollectionIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCollectionIdsRequest.Marshal(b, m, deterministic)
}
func (m *ListCollectionIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCollectionIdsRequest.Merge(m, src)
}
func (m *ListCollectionIdsRequest) XXX_Size() int {
	return xxx_messageInfo_ListCollectionIdsRequest.Size(m)
}
func (m *ListCollectionIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCollectionIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCollectionIdsRequest proto.InternalMessageInfo

func (m *ListCollectionIdsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCollectionIdsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCollectionIdsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response from [Firestore.ListCollectionIds][google.firestore.v1.Firestore.ListCollectionIds].
type ListCollectionIdsResponse struct {
	// The collection ids.
	CollectionIds []string `protobuf:"bytes,1,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// A page token that may be used to continue the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCollectionIdsResponse) Reset()         { *m = ListCollectionIdsResponse{} }
func (m *ListCollectionIdsResponse) String() string { return proto.CompactTextString(m) }
func (*ListCollectionIdsResponse) ProtoMessage()    {}
func (*ListCollectionIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f56aaf8ee76b5544, []int{22}
}

func (m *ListCollectionIdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCollectionIdsResponse.Unmarshal(m, b)
}
func (m *ListCollectionIdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCollectionIdsResponse.Marshal(b, m, deterministic)
}
func (m *ListCollectionIdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCollectionIdsResponse.Merge(m, src)
}
func (m *ListCollectionIdsResponse) XXX_Size() int {
	return xxx_messageInfo_ListCollectionIdsResponse.Size(m)
}
func (m *ListCollectionIdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCollectionIdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCollectionIdsResponse proto.InternalMessageInfo

func (m *ListCollectionIdsResponse) GetCollectionIds() []string {
	if m != nil {
		return m.CollectionIds
	}
	return nil
}

func (m *ListCollectionIdsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.firestore.v1.TargetChange_TargetChangeType", TargetChange_TargetChangeType_name, TargetChange_TargetChangeType_value)
	proto.RegisterType((*GetDocumentRequest)(nil), "google.firestore.v1.GetDocumentRequest")
	proto.RegisterType((*ListDocumentsRequest)(nil), "google.firestore.v1.ListDocumentsRequest")
	proto.RegisterType((*ListDocumentsResponse)(nil), "google.firestore.v1.ListDocumentsResponse")
	proto.RegisterType((*CreateDocumentRequest)(nil), "google.firestore.v1.CreateDocumentRequest")
	proto.RegisterType((*UpdateDocumentRequest)(nil), "google.firestore.v1.UpdateDocumentRequest")
	proto.RegisterType((*DeleteDocumentRequest)(nil), "google.firestore.v1.DeleteDocumentRequest")
	proto.RegisterType((*BatchGetDocumentsRequest)(nil), "google.firestore.v1.BatchGetDocumentsRequest")
	proto.RegisterType((*BatchGetDocumentsResponse)(nil), "google.firestore.v1.BatchGetDocumentsResponse")
	proto.RegisterType((*BeginTransactionRequest)(nil), "google.firestore.v1.BeginTransactionRequest")
	proto.RegisterType((*BeginTransactionResponse)(nil), "google.firestore.v1.BeginTransactionResponse")
	proto.RegisterType((*CommitRequest)(nil), "google.firestore.v1.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "google.firestore.v1.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "google.firestore.v1.RollbackRequest")
	proto.RegisterType((*RunQueryRequest)(nil), "google.firestore.v1.RunQueryRequest")
	proto.RegisterType((*RunQueryResponse)(nil), "google.firestore.v1.RunQueryResponse")
	proto.RegisterType((*WriteRequest)(nil), "google.firestore.v1.WriteRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.firestore.v1.WriteRequest.LabelsEntry")
	proto.RegisterType((*WriteResponse)(nil), "google.firestore.v1.WriteResponse")
	proto.RegisterType((*ListenRequest)(nil), "google.firestore.v1.ListenRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.firestore.v1.ListenRequest.LabelsEntry")
	proto.RegisterType((*ListenResponse)(nil), "google.firestore.v1.ListenResponse")
	proto.RegisterType((*Target)(nil), "google.firestore.v1.Target")
	proto.RegisterType((*Target_DocumentsTarget)(nil), "google.firestore.v1.Target.DocumentsTarget")
	proto.RegisterType((*Target_QueryTarget)(nil), "google.firestore.v1.Target.QueryTarget")
	proto.RegisterType((*TargetChange)(nil), "google.firestore.v1.TargetChange")
	proto.RegisterType((*ListCollectionIdsRequest)(nil), "google.firestore.v1.ListCollectionIdsRequest")
	proto.RegisterType((*ListCollectionIdsResponse)(nil), "google.firestore.v1.ListCollectionIdsResponse")
}

func init() {
	proto.RegisterFile("google/firestore/v1/firestore.proto", fileDescriptor_f56aaf8ee76b5544)
}

var fileDescriptor_f56aaf8ee76b5544 = []byte{
	// 2247 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0xdd, 0x8f, 0x1b, 0x57,
	0x15, 0xf7, 0x1d, 0x7f, 0xac, 0x7d, 0xfc, 0xb1, 0xee, 0xa5, 0x49, 0x1c, 0xa7, 0x51, 0x37, 0x13,
	0x42, 0x16, 0xd3, 0xd8, 0xc9, 0xa2, 0x40, 0xe2, 0xa4, 0x34, 0xfb, 0xe1, 0xc4, 0xa1, 0xf9, 0xea,
	0xec, 0x36, 0xa0, 0x2a, 0x92, 0x99, 0x9d, 0xb9, 0xeb, 0x9d, 0xae, 0x3d, 0x33, 0x9d, 0x19, 0xef,
	0xc6, 0x2d, 0xfb, 0x00, 0x48, 0xbc, 0x20, 0xe8, 0x03, 0x15, 0x42, 0xea, 0x0b, 0x42, 0x3c, 0x54,
	0xbc, 0x20, 0xf1, 0x86, 0xc4, 0x5f, 0xd0, 0x37, 0xa8, 0xe8, 0x2b, 0x2f, 0x20, 0xfe, 0x08, 0x90,
	0x40, 0x73, 0xef, 0x9d, 0xf1, 0xcc, 0x78, 0xfc, 0xb5, 0x89, 0x78, 0xf3, 0x3d, 0x73, 0xee, 0xb9,
	0xbf, 0xf3, 0x79, 0xcf, 0x3d, 0x86, 0x8b, 0x5d, 0xc3, 0xe8, 0xf6, 0x48, 0x63, 0x4f, 0xb3, 0x88,
	0xed, 0x18, 0x16, 0x69, 0x1c, 0x5e, 0x1b, 0x2d, 0xea, 0xa6, 0x65, 0x38, 0x06, 0xfe, 0x0a, 0x63,
	0xaa, 0x8f, 0xe8, 0x87, 0xd7, 0xaa, 0xaf, 0xf1, 0x9d, 0xb2, 0xa9, 0x35, 0x64, 0x5d, 0x37, 0x1c,
	0xd9, 0xd1, 0x0c, 0xdd, 0x66, 0x5b, 0xaa, 0x2b, 0x71, 0x72, 0x15, 0xa3, 0xdf, 0x37, 0x74, 0xce,
	0x21, 0xc6, 0x71, 0xa8, 0x86, 0x32, 0xe8, 0x13, 0xdd, 0xe1, 0x3c, 0xaf, 0xc7, 0xf1, 0x7c, 0x30,
	0x20, 0xd6, 0x70, 0x1a, 0xc3, 0x91, 0xa5, 0x39, 0x1c, 0x7a, 0xf5, 0x1c, 0x67, 0xa0, 0xab, 0xdd,
	0xc1, 0x5e, 0x83, 0xf4, 0x4d, 0x27, 0xba, 0xdb, 0xff, 0xe8, 0x68, 0x7d, 0x62, 0x3b, 0x72, 0xdf,
	0xe4, 0x0c, 0x67, 0x38, 0x83, 0x65, 0x2a, 0x0d, 0xdb, 0x91, 0x9d, 0x81, 0x1d, 0xf9, 0xe0, 0x2a,
	0xaf, 0xf4, 0x34, 0x1f, 0xb1, 0xf8, 0x25, 0x02, 0x7c, 0x8f, 0x38, 0x5b, 0x5c, 0x0f, 0x89, 0x7c,
	0x30, 0x20, 0xb6, 0x83, 0x31, 0xa4, 0x74, 0xb9, 0x4f, 0x2a, 0x68, 0x05, 0xad, 0xe6, 0x24, 0xfa,
	0x1b, 0x5f, 0x87, 0x54, 0x5f, 0xb6, 0x0f, 0x2a, 0xc2, 0x0a, 0x5a, 0xcd, 0xaf, 0x5d, 0xa8, 0xc7,
	0x18, 0xb9, 0xee, 0xc9, 0x79, 0x28, 0xdb, 0x07, 0x12, 0x65, 0xc7, 0x22, 0xe4, 0x1d, 0x4b, 0xd6,
	0x6d, 0x59, 0x71, 0xed, 0x5d, 0x49, 0xae, 0xa0, 0xd5, 0x42, 0x3b, 0x21, 0x05, 0x89, 0xf8, 0x26,
	0xe4, 0x2c, 0x22, 0xab, 0x1d, 0x57, 0x9f, 0x4a, 0x9a, 0xca, 0xaf, 0x7a, 0xf2, 0x3d, 0x65, 0xeb,
	0x3b, 0x9e, 0xb2, 0xed, 0x84, 0x94, 0x75, 0xd9, 0x5d, 0xc2, 0xc6, 0x69, 0x78, 0x55, 0x31, 0x74,
	0x5b, 0xb3, 0x1d, 0xa2, 0x2b, 0xc3, 0x8e, 0x4d, 0x7a, 0x44, 0x71, 0x0c, 0x4b, 0xfc, 0xb7, 0x00,
	0xaf, 0x3e, 0xd0, 0x6c, 0x5f, 0x33, 0xdb, 0x53, 0xed, 0x34, 0x64, 0x4c, 0xd9, 0x22, 0xba, 0xc3,
	0x95, 0xe3, 0x2b, 0x7c, 0x11, 0x8a, 0x8a, 0xd1, 0x73, 0x77, 0x6b, 0x86, 0xde, 0xd1, 0x54, 0xaa,
	0x67, 0x4e, 0x2a, 0x8c, 0x88, 0xf7, 0x55, 0x7c, 0x0e, 0x72, 0xa6, 0xdc, 0x25, 0x1d, 0x5b, 0xfb,
	0x90, 0x50, 0x55, 0xd2, 0x52, 0xd6, 0x25, 0x6c, 0x6b, 0x1f, 0x12, 0x7c, 0x1e, 0x80, 0x7e, 0x74,
	0x8c, 0x03, 0xa2, 0x57, 0x52, 0x74, 0x3b, 0x65, 0xdf, 0x71, 0x09, 0xf8, 0x2c, 0x64, 0x0d, 0x4b,
	0x25, 0x56, 0x67, 0x77, 0x58, 0xc9, 0xd0, 0x8f, 0x4b, 0x74, 0xbd, 0x31, 0xf4, 0x4d, 0xbb, 0xf4,
	0x42, 0xa6, 0xcd, 0xce, 0x34, 0x2d, 0x2c, 0x62, 0x5a, 0x7c, 0x01, 0x0a, 0xf6, 0xbe, 0x71, 0xd4,
	0xe9, 0x6b, 0xb6, 0xad, 0xe9, 0xdd, 0x4a, 0x61, 0x05, 0xad, 0x66, 0xa5, 0xbc, 0x4b, 0x7b, 0xc8,
	0x48, 0x13, 0xad, 0xff, 0x43, 0x38, 0x15, 0x31, 0xbe, 0x6d, 0x1a, 0xba, 0x4d, 0xf0, 0x2d, 0xc8,
	0x79, 0x39, 0x63, 0x57, 0xd0, 0x4a, 0x72, 0x35, 0xbf, 0x76, 0x7e, 0xaa, 0xba, 0xd2, 0x88, 0x1f,
	0x7f, 0x0d, 0x96, 0x75, 0xf2, 0xdc, 0xe9, 0x04, 0xac, 0xcc, 0x9c, 0x54, 0x74, 0xc9, 0x4f, 0x3c,
	0x4b, 0x8b, 0xff, 0x42, 0x70, 0x6a, 0xd3, 0x22, 0xb2, 0x43, 0xa2, 0x71, 0xfd, 0x42, 0xce, 0x7f,
	0x1d, 0xf2, 0x1e, 0x16, 0x97, 0x25, 0x49, 0x59, 0xc0, 0x23, 0xdd, 0x57, 0xf1, 0x4d, 0xc8, 0x7a,
	0x2b, 0xea, 0xfe, 0x99, 0xba, 0xf9, 0xec, 0x7e, 0x04, 0xa4, 0x17, 0x8a, 0x00, 0xf1, 0x53, 0x01,
	0x4e, 0xbd, 0x6b, 0xaa, 0x31, 0x9a, 0x06, 0xb1, 0xa0, 0xc5, 0xb0, 0x6c, 0x40, 0x7e, 0x40, 0x65,
	0x76, 0x16, 0xcb, 0x77, 0x60, 0xbb, 0xdc, 0xdf, 0xbe, 0x3e, 0xc9, 0xc5, 0x22, 0xfa, 0x01, 0x94,
	0x95, 0x81, 0xe5, 0xba, 0xa4, 0x13, 0xb1, 0x64, 0xbc, 0x88, 0x27, 0x16, 0x51, 0x0c, 0x5d, 0xd5,
	0x5c, 0x0f, 0x49, 0xcb, 0x7c, 0xab, 0x27, 0x57, 0x1c, 0xc2, 0xa9, 0x2d, 0xd2, 0x23, 0xe3, 0xc6,
	0x89, 0x2b, 0x6f, 0x71, 0x47, 0x0b, 0x27, 0x3e, 0xfa, 0x4b, 0x01, 0x2a, 0x1b, 0xb2, 0xa3, 0xec,
	0x07, 0x8a, 0xab, 0x5f, 0x82, 0xaa, 0x90, 0x55, 0x65, 0x47, 0xde, 0x95, 0x6d, 0x0f, 0x82, 0xbf,
	0xc6, 0xaf, 0x05, 0x13, 0x44, 0x58, 0x49, 0xba, 0x35, 0x64, 0x94, 0x01, 0x27, 0x34, 0x6b, 0xa4,
	0x50, 0xa4, 0xe2, 0x0a, 0x85, 0xe4, 0x26, 0xd7, 0x51, 0x27, 0xc8, 0xc7, 0x82, 0xf1, 0x72, 0xec,
	0x29, 0x3b, 0x23, 0xbe, 0xc7, 0x26, 0xbd, 0x49, 0xdb, 0x09, 0xa9, 0xa4, 0x93, 0xa3, 0x9d, 0x49,
	0xc5, 0x67, 0xe9, 0xa5, 0xd4, 0xf5, 0x2f, 0x10, 0x9c, 0x8d, 0x31, 0x2c, 0x2f, 0x2f, 0xd7, 0x21,
	0xbd, 0x67, 0x0c, 0x74, 0x75, 0xae, 0x90, 0x6f, 0x27, 0x24, 0xc6, 0x8d, 0xab, 0xb0, 0xe4, 0x15,
	0x39, 0x9a, 0xf8, 0xed, 0x84, 0xe4, 0x11, 0xf0, 0x4a, 0xcc, 0xfd, 0x15, 0xb6, 0xdc, 0xb7, 0x83,
	0x5a, 0xa6, 0x66, 0x69, 0x19, 0xd0, 0x31, 0x0b, 0x19, 0x8b, 0xd8, 0x83, 0x9e, 0x23, 0x3e, 0x87,
	0x33, 0x1b, 0xa4, 0xab, 0xe9, 0x01, 0xe3, 0xcd, 0x13, 0x2c, 0xeb, 0xb0, 0x64, 0x30, 0xe3, 0xf3,
	0x50, 0x9d, 0xd7, 0x57, 0x92, 0xb7, 0x4f, 0xbc, 0x0d, 0x95, 0xf1, 0x93, 0xb9, 0x35, 0x23, 0xaa,
	0xa3, 0x31, 0xd5, 0xc5, 0x1f, 0x21, 0x28, 0x6e, 0x1a, 0xfd, 0xbe, 0xe6, 0xcc, 0x03, 0x77, 0x0d,
	0x32, 0xb4, 0xd7, 0x61, 0x81, 0x1d, 0xb0, 0x52, 0x08, 0xed, 0xf7, 0x5c, 0x16, 0x89, 0x73, 0xce,
	0x36, 0xbf, 0xf8, 0x09, 0x82, 0x92, 0x87, 0x81, 0x03, 0x6f, 0x41, 0x91, 0x6e, 0xef, 0x30, 0xf3,
	0x7a, 0x37, 0xcd, 0xca, 0x94, 0xf3, 0x28, 0xa3, 0x54, 0x38, 0x1a, 0x2d, 0x6c, 0x7c, 0x0b, 0xf2,
	0x0a, 0x15, 0xcc, 0x5c, 0x2b, 0xcc, 0x74, 0x2d, 0x30, 0x76, 0x97, 0x20, 0x3e, 0x86, 0x65, 0xc9,
	0xe8, 0xf5, 0x76, 0x65, 0xe5, 0x60, 0x1e, 0xdb, 0x44, 0xf4, 0x14, 0xc6, 0xf5, 0xfc, 0x9b, 0x00,
	0xcb, 0xd2, 0x40, 0x7f, 0xc7, 0x6d, 0x27, 0x67, 0xdd, 0x67, 0xef, 0x40, 0xd9, 0x76, 0xac, 0x81,
	0xe2, 0x0c, 0x2c, 0xa2, 0x76, 0x68, 0x07, 0xca, 0xe1, 0x7f, 0x35, 0xd6, 0x06, 0xdb, 0x3e, 0x33,
	0x15, 0xdf, 0x4e, 0x48, 0xcb, 0x76, 0x98, 0x14, 0xad, 0x21, 0x69, 0x5a, 0x43, 0xd0, 0xcc, 0x1a,
	0x92, 0x59, 0xac, 0x86, 0xa0, 0x17, 0xad, 0x21, 0x28, 0x90, 0x5f, 0x05, 0x00, 0xaa, 0x7a, 0xc7,
	0x19, 0x9a, 0x93, 0x2b, 0xca, 0x5f, 0x10, 0x94, 0x47, 0x76, 0x8d, 0x0f, 0xfd, 0x71, 0x77, 0xbc,
	0xc8, 0x05, 0x1b, 0x2a, 0x18, 0xc9, 0xf9, 0x0b, 0x06, 0xbe, 0x0c, 0xcb, 0xf6, 0x81, 0x66, 0x9a,
	0x44, 0xf5, 0x23, 0x3b, 0x45, 0x9b, 0xd0, 0x12, 0x27, 0xf3, 0xc8, 0x15, 0x7f, 0x23, 0x40, 0x81,
	0xc7, 0xf5, 0xec, 0xd0, 0x3b, 0x07, 0x39, 0xdb, 0xb1, 0x88, 0xdc, 0x1f, 0x35, 0x3e, 0x59, 0x46,
	0xb8, 0xaf, 0x06, 0x72, 0x36, 0x39, 0x77, 0xce, 0xba, 0x8d, 0x23, 0x13, 0x38, 0x6a, 0x85, 0x0b,
	0x52, 0x9e, 0xd1, 0x58, 0x33, 0xdc, 0x82, 0x4c, 0x4f, 0xde, 0x25, 0x3d, 0xbb, 0x92, 0xa6, 0x62,
	0xaf, 0x4c, 0x4b, 0x4d, 0xaa, 0x42, 0xfd, 0x01, 0xe5, 0x6f, 0xe9, 0x8e, 0x35, 0x94, 0xf8, 0xe6,
	0xea, 0x4d, 0xc8, 0x07, 0xc8, 0xb8, 0x0c, 0xc9, 0x03, 0x32, 0xe4, 0x0a, 0xba, 0x3f, 0xf1, 0xab,
	0x90, 0x3e, 0x94, 0x7b, 0x03, 0xc2, 0xf5, 0x62, 0x8b, 0xa6, 0x70, 0x03, 0xb9, 0x17, 0x49, 0xd1,
	0x4b, 0x7d, 0xe6, 0xf3, 0x90, 0x1d, 0x50, 0xc4, 0x0e, 0x51, 0x9d, 0x84, 0x38, 0x9d, 0x22, 0x55,
	0x27, 0xf9, 0x32, 0xaa, 0x4e, 0x6a, 0xa1, 0xaa, 0xf3, 0x3b, 0x01, 0x8a, 0x0f, 0x68, 0x88, 0xcf,
	0xe3, 0xf9, 0xdb, 0x00, 0xb2, 0xaa, 0x76, 0x1c, 0xd9, 0xea, 0x12, 0xaf, 0xdb, 0x39, 0x17, 0x9f,
	0xaa, 0x94, 0xa5, 0x9d, 0x90, 0x72, 0xb2, 0xaa, 0xb2, 0x05, 0xbe, 0x04, 0x45, 0x8b, 0xf4, 0x8d,
	0x43, 0xe2, 0x09, 0xa0, 0x0f, 0xa2, 0x76, 0x42, 0x2a, 0x30, 0x32, 0x67, 0xbb, 0xeb, 0xbb, 0x3a,
	0x45, 0xed, 0x51, 0x8f, 0x3d, 0x20, 0x04, 0xfa, 0x25, 0xfb, 0x7a, 0x63, 0x19, 0x8a, 0x0c, 0x62,
	0x47, 0xd9, 0x97, 0xf5, 0x2e, 0x11, 0x3f, 0x4d, 0x42, 0xc9, 0x3b, 0x91, 0x7b, 0xbf, 0x1d, 0xe1,
	0x99, 0xda, 0xfc, 0x31, 0xd5, 0x36, 0x29, 0xa3, 0xab, 0xb0, 0x13, 0x58, 0xe3, 0x47, 0xb0, 0xec,
	0xbf, 0x13, 0xb8, 0x2c, 0x96, 0xe4, 0x17, 0xa7, 0x16, 0x08, 0x5f, 0x5a, 0x49, 0x0d, 0x51, 0x42,
	0xf2, 0x54, 0xda, 0xcf, 0xf2, 0xa0, 0x98, 0x2e, 0x8f, 0xb5, 0xbe, 0x41, 0x79, 0x8c, 0x12, 0x92,
	0xc7, 0x3c, 0xc5, 0xab, 0xf4, 0x74, 0x79, 0x12, 0x65, 0x0d, 0xca, 0x63, 0x14, 0xfc, 0x1d, 0xc8,
	0xec, 0x69, 0x3d, 0x87, 0x58, 0xbc, 0x61, 0x8c, 0xbf, 0x62, 0x5a, 0xcf, 0x59, 0xe5, 0x25, 0x77,
	0x29, 0x6f, 0x3b, 0x21, 0xf1, 0x5d, 0xae, 0x77, 0x2c, 0xee, 0x05, 0x5a, 0xa9, 0xc5, 0xff, 0x26,
	0x21, 0xc3, 0x83, 0xe7, 0x2d, 0x48, 0x07, 0x6f, 0xaf, 0xcb, 0x53, 0xbc, 0x51, 0xa7, 0x15, 0xdc,
	0x0f, 0x54, 0xb6, 0x0f, 0xbf, 0x1d, 0xec, 0xa7, 0x99, 0x1b, 0xbe, 0x31, 0x4d, 0x88, 0xdf, 0x53,
	0x8e, 0x22, 0x7e, 0xd4, 0x7e, 0x5f, 0x84, 0x82, 0x9b, 0xdb, 0xfd, 0xe0, 0x1b, 0x9f, 0x5e, 0x82,
	0x8c, 0xca, 0xca, 0x40, 0xe8, 0xc2, 0xca, 0x2f, 0x72, 0x61, 0xb9, 0x15, 0x88, 0xc7, 0xa0, 0xa6,
	0x52, 0x63, 0xa6, 0xa5, 0x2c, 0x23, 0xdc, 0x57, 0xdd, 0x47, 0x8b, 0xa1, 0x2b, 0xcc, 0x57, 0x59,
	0x89, 0xfe, 0xae, 0x36, 0x60, 0x39, 0x02, 0x78, 0xfa, 0x03, 0xa2, 0xfa, 0x53, 0x04, 0xf9, 0x80,
	0x9d, 0xfe, 0x8f, 0x0d, 0x44, 0xe4, 0x36, 0x2e, 0x42, 0x9e, 0xab, 0xea, 0x2d, 0x3d, 0xcb, 0xba,
	0x11, 0xf0, 0x4f, 0x01, 0x0a, 0xc1, 0x1c, 0xc3, 0x3f, 0x00, 0x1c, 0xca, 0x4e, 0xca, 0x46, 0x31,
	0x97, 0xd6, 0xd6, 0x66, 0xa6, 0x68, 0x68, 0xb1, 0x33, 0x34, 0x89, 0x54, 0x76, 0x22, 0x14, 0x7c,
	0x1e, 0xc0, 0xb7, 0x3d, 0x33, 0x5c, 0x5a, 0xca, 0x79, 0xc6, 0xb7, 0xf1, 0x2a, 0xa4, 0x15, 0x79,
	0x60, 0x7b, 0xa9, 0x8c, 0xbd, 0x33, 0x2d, 0x53, 0xa9, 0x6f, 0xd3, 0x51, 0x9b, 0xc4, 0x18, 0xdc,
	0x9b, 0x62, 0x3c, 0x48, 0xc2, 0x21, 0x12, 0x6a, 0x00, 0x32, 0xf3, 0x37, 0x00, 0xe2, 0x23, 0x28,
	0x47, 0x55, 0xc1, 0x45, 0xc8, 0x3d, 0x7a, 0xdc, 0xd9, 0x6c, 0xaf, 0x3f, 0xba, 0xd7, 0x2a, 0x27,
	0xf0, 0x12, 0x24, 0xd7, 0xb7, 0xb6, 0xca, 0x08, 0x03, 0x64, 0xa4, 0xd6, 0xc3, 0xc7, 0x4f, 0x5b,
	0x65, 0x01, 0xe7, 0x61, 0x69, 0xf3, 0x5d, 0x49, 0x6a, 0x3d, 0xda, 0x29, 0x27, 0x71, 0x0e, 0xd2,
	0x52, 0x6b, 0xbb, 0xb5, 0x53, 0x4e, 0x89, 0x3a, 0x54, 0xdc, 0x32, 0xb8, 0x19, 0x18, 0x73, 0xcc,
	0x1c, 0x94, 0x85, 0x66, 0x60, 0xc2, 0xd4, 0x19, 0x58, 0x32, 0x32, 0x03, 0x13, 0xdf, 0x87, 0xb3,
	0x31, 0xe7, 0xf1, 0x0a, 0x7c, 0x09, 0x4a, 0xa1, 0x21, 0x0c, 0x6b, 0xdb, 0x73, 0x52, 0x31, 0x38,
	0x85, 0x99, 0x7b, 0x0a, 0xb4, 0xf6, 0x1f, 0x0c, 0xb9, 0xbb, 0x5e, 0x44, 0xe0, 0x8f, 0x11, 0xe4,
	0x03, 0x4f, 0x46, 0x1c, 0x5f, 0x49, 0xc6, 0x47, 0xa1, 0xd5, 0xe9, 0x5d, 0x9d, 0x78, 0xe3, 0xc7,
	0x5f, 0xfc, 0xe3, 0x97, 0xc2, 0x1a, 0xbe, 0xda, 0x38, 0xbc, 0xd6, 0xf8, 0x48, 0x97, 0xfb, 0xe4,
	0x4d, 0xd3, 0x32, 0xde, 0x27, 0x8a, 0x63, 0x37, 0x6a, 0x0d, 0xef, 0xa6, 0xa5, 0xbf, 0xbd, 0x24,
	0x6c, 0xd4, 0x1a, 0xb5, 0xda, 0x31, 0xfe, 0x23, 0x62, 0x57, 0xb5, 0x9f, 0xc0, 0xf8, 0xeb, 0x13,
	0x6f, 0xc6, 0xe8, 0x08, 0xa1, 0x5a, 0x9b, 0x87, 0x95, 0xd9, 0x55, 0xfc, 0x2e, 0x85, 0xb8, 0x85,
	0x37, 0x28, 0x44, 0xe6, 0xc5, 0x39, 0x41, 0x36, 0x3e, 0x0a, 0x79, 0xe4, 0x18, 0xff, 0xc1, 0x7d,
	0x6c, 0x85, 0x46, 0x6b, 0x38, 0x1e, 0x4a, 0xec, 0xfc, 0x6d, 0x96, 0x31, 0x25, 0x8a, 0xf4, 0x81,
	0x78, 0x67, 0x31, 0xa4, 0xe3, 0x38, 0x9b, 0xa3, 0x66, 0xfb, 0x33, 0x04, 0xa5, 0xf0, 0x88, 0x6c,
	0x02, 0xe2, 0xd8, 0x39, 0xda, 0x2c, 0xc4, 0x6f, 0x53, 0xc4, 0xad, 0xb5, 0x9b, 0x14, 0xb1, 0xff,
	0x77, 0xc0, 0x02, 0x71, 0x10, 0x80, 0xfa, 0x0b, 0x04, 0xa5, 0xf0, 0xc0, 0x6a, 0x02, 0xd4, 0xd8,
	0xa9, 0x56, 0xf5, 0xf4, 0x58, 0x09, 0x69, 0xf5, 0x4d, 0x67, 0xe8, 0x85, 0x68, 0x6d, 0xf1, 0x10,
	0xfd, 0x13, 0x82, 0x57, 0xc6, 0x86, 0x2d, 0x38, 0xbe, 0x57, 0x9f, 0x34, 0xed, 0xaa, 0xd6, 0xe7,
	0x65, 0xe7, 0xe1, 0xba, 0x49, 0xe1, 0xbe, 0x29, 0xde, 0x60, 0x26, 0xe5, 0xf0, 0x26, 0x40, 0x3e,
	0x1e, 0x61, 0x6e, 0xee, 0x72, 0x91, 0x4d, 0x54, 0xbb, 0x8a, 0xf0, 0x9f, 0x11, 0x94, 0xa3, 0x93,
	0x0d, 0xfc, 0x46, 0x3c, 0x96, 0xf8, 0xd1, 0x4b, 0xf5, 0xca, 0x9c, 0xdc, 0x1c, 0x38, 0x8f, 0x05,
	0x1e, 0xbd, 0x8b, 0x00, 0x8f, 0x48, 0x6c, 0xa2, 0x1a, 0xfe, 0x04, 0x41, 0x86, 0x4d, 0x35, 0xb0,
	0x18, 0x9f, 0x60, 0xc1, 0xb1, 0x4b, 0xf5, 0xe2, 0x54, 0x1e, 0x0e, 0x70, 0x9d, 0x02, 0xbc, 0x25,
	0x7e, 0x6b, 0x51, 0x80, 0xec, 0x81, 0xe1, 0xc2, 0xfa, 0x39, 0x82, 0xac, 0x37, 0xd6, 0xc0, 0xf1,
	0xad, 0x40, 0x64, 0xea, 0x31, 0x31, 0x2c, 0x4f, 0xec, 0x67, 0x8b, 0x1f, 0xe0, 0xe2, 0xf9, 0xbb,
	0x8b, 0x87, 0x3f, 0xde, 0x27, 0xe1, 0x09, 0xcf, 0x4c, 0xaa, 0x97, 0x66, 0x70, 0x71, 0x63, 0xfd,
	0x04, 0x51, 0x7c, 0xc7, 0xdc, 0x5a, 0x73, 0x16, 0xa3, 0xe3, 0xa6, 0xc5, 0x05, 0x35, 0x51, 0xed,
	0xbd, 0x3b, 0xe2, 0xad, 0xc5, 0x6b, 0x6e, 0x50, 0xc2, 0x55, 0xe4, 0x06, 0x42, 0x9a, 0x3e, 0x16,
	0xf1, 0x85, 0x99, 0x6f, 0xe4, 0xaa, 0x38, 0xf5, 0xad, 0xc9, 0x14, 0xbb, 0x43, 0xf5, 0x6a, 0x8a,
	0xd7, 0x17, 0xb5, 0x3b, 0x7d, 0xa5, 0x36, 0x51, 0x6d, 0x15, 0x5d, 0x45, 0xf8, 0xd7, 0x08, 0x32,
	0xec, 0x05, 0x35, 0x21, 0x3e, 0x43, 0x0f, 0xba, 0x09, 0xf1, 0x19, 0x7e, 0x82, 0x9d, 0x3c, 0x3e,
	0x7b, 0x54, 0x8e, 0x07, 0xed, 0x67, 0x02, 0xbc, 0x32, 0xd6, 0x65, 0x4c, 0xa8, 0x5a, 0x93, 0xba,
	0x9f, 0x6a, 0x7d, 0x5e, 0x76, 0x8e, 0xfd, 0x57, 0x2c, 0x5c, 0x3e, 0x46, 0xe2, 0x5b, 0x8b, 0xc5,
	0x4b, 0x2f, 0x2a, 0xd2, 0x0d, 0x9c, 0xfb, 0xe2, 0xd6, 0x09, 0x02, 0x27, 0x4e, 0x54, 0xf5, 0xf0,
	0xf3, 0xf5, 0xca, 0x48, 0x07, 0xa6, 0x94, 0x6c, 0x6a, 0x76, 0x5d, 0x31, 0xfa, 0x7f, 0x5d, 0xff,
	0xfe, 0xbe, 0xe3, 0x98, 0x76, 0xb3, 0xd1, 0x38, 0x3a, 0x3a, 0x8a, 0x7c, 0x6c, 0xc8, 0x03, 0x67,
	0xbf, 0xa1, 0xf4, 0x8c, 0x81, 0x7a, 0xc5, 0xec, 0xc9, 0xce, 0x9e, 0x61, 0xf5, 0xdf, 0x98, 0xc5,
	0xee, 0xc2, 0xa3, 0x27, 0x6d, 0x7c, 0x86, 0xe0, 0x8c, 0x62, 0xf4, 0xe3, 0xcc, 0xb8, 0x51, 0xf2,
	0xfb, 0xb2, 0x27, 0x6e, 0x4d, 0x78, 0x82, 0xde, 0xbb, 0xcd, 0xd9, 0xba, 0x46, 0x4f, 0xd6, 0xbb,
	0x75, 0xc3, 0xea, 0x36, 0xba, 0x44, 0xa7, 0x15, 0xa3, 0x31, 0x3a, 0x27, 0xf4, 0xbf, 0xf9, 0x2d,
	0x7f, 0xf1, 0x5b, 0x21, 0x75, 0x6f, 0xf3, 0xee, 0xf6, 0xef, 0x85, 0xb3, 0xf7, 0x98, 0x94, 0x4d,
	0x17, 0x74, 0xdd, 0x3f, 0xa4, 0xfe, 0xf4, 0xda, 0xe7, 0xde, 0xb7, 0x67, 0xf4, 0xdb, 0x33, 0xff,
	0xdb, 0xb3, 0xa7, 0xd7, 0x76, 0x33, 0xf4, 0x9c, 0x6f, 0xfe, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x41,
	0x4a, 0xcf, 0xa9, 0x5d, 0x20, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FirestoreClient is the client API for Firestore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FirestoreClient interface {
	// Gets a single document.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Lists documents.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Creates a new document.
	CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Updates or inserts a document.
	UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Deletes a document.
	DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets multiple documents.
	//
	// Documents returned by this method are not guaranteed to be returned in the
	// same order that they were requested.
	BatchGetDocuments(ctx context.Context, in *BatchGetDocumentsRequest, opts ...grpc.CallOption) (Firestore_BatchGetDocumentsClient, error)
	// Starts a new transaction.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error)
	// Commits a transaction, while optionally updating documents.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Runs a query.
	RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (Firestore_RunQueryClient, error)
	// Streams batches of document updates and deletes, in order.
	Write(ctx context.Context, opts ...grpc.CallOption) (Firestore_WriteClient, error)
	// Listens to changes.
	Listen(ctx context.Context, opts ...grpc.CallOption) (Firestore_ListenClient, error)
	// Lists all the collection IDs underneath a document.
	ListCollectionIds(ctx context.Context, in *ListCollectionIdsRequest, opts ...grpc.CallOption) (*ListCollectionIdsResponse, error)
}

type firestoreClient struct {
	cc *grpc.ClientConn
}

func NewFirestoreClient(cc *grpc.ClientConn) FirestoreClient {
	return &firestoreClient{cc}
}

func (c *firestoreClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/GetDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/ListDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/CreateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/UpdateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/DeleteDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) BatchGetDocuments(ctx context.Context, in *BatchGetDocumentsRequest, opts ...grpc.CallOption) (Firestore_BatchGetDocumentsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Firestore_serviceDesc.Streams[0], "/google.firestore.v1.Firestore/BatchGetDocuments", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreBatchGetDocumentsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Firestore_BatchGetDocumentsClient interface {
	Recv() (*BatchGetDocumentsResponse, error)
	grpc.ClientStream
}

type firestoreBatchGetDocumentsClient struct {
	grpc.ClientStream
}

func (x *firestoreBatchGetDocumentsClient) Recv() (*BatchGetDocumentsResponse, error) {
	m := new(BatchGetDocumentsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error) {
	out := new(BeginTransactionResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/BeginTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/Commit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/Rollback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (Firestore_RunQueryClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Firestore_serviceDesc.Streams[1], "/google.firestore.v1.Firestore/RunQuery", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreRunQueryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Firestore_RunQueryClient interface {
	Recv() (*RunQueryResponse, error)
	grpc.ClientStream
}

type firestoreRunQueryClient struct {
	grpc.ClientStream
}

func (x *firestoreRunQueryClient) Recv() (*RunQueryResponse, error) {
	m := new(RunQueryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) Write(ctx context.Context, opts ...grpc.CallOption) (Firestore_WriteClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Firestore_serviceDesc.Streams[2], "/google.firestore.v1.Firestore/Write", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreWriteClient{stream}
	return x, nil
}

type Firestore_WriteClient interface {
	Send(*WriteRequest) error
	Recv() (*WriteResponse, error)
	grpc.ClientStream
}

type firestoreWriteClient struct {
	grpc.ClientStream
}

func (x *firestoreWriteClient) Send(m *WriteRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *firestoreWriteClient) Recv() (*WriteResponse, error) {
	m := new(WriteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) Listen(ctx context.Context, opts ...grpc.CallOption) (Firestore_ListenClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Firestore_serviceDesc.Streams[3], "/google.firestore.v1.Firestore/Listen", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreListenClient{stream}
	return x, nil
}

type Firestore_ListenClient interface {
	Send(*ListenRequest) error
	Recv() (*ListenResponse, error)
	grpc.ClientStream
}

type firestoreListenClient struct {
	grpc.ClientStream
}

func (x *firestoreListenClient) Send(m *ListenRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *firestoreListenClient) Recv() (*ListenResponse, error) {
	m := new(ListenResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) ListCollectionIds(ctx context.Context, in *ListCollectionIdsRequest, opts ...grpc.CallOption) (*ListCollectionIdsResponse, error) {
	out := new(ListCollectionIdsResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/ListCollectionIds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirestoreServer is the server API for Firestore service.
type FirestoreServer interface {
	// Gets a single document.
	GetDocument(context.Context, *GetDocumentRequest) (*Document, error)
	// Lists documents.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Creates a new document.
	CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error)
	// Updates or inserts a document.
	UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error)
	// Deletes a document.
	DeleteDocument(context.Context, *DeleteDocumentRequest) (*empty.Empty, error)
	// Gets multiple documents.
	//
	// Documents returned by this method are not guaranteed to be returned in the
	// same order that they were requested.
	BatchGetDocuments(*BatchGetDocumentsRequest, Firestore_BatchGetDocumentsServer) error
	// Starts a new transaction.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error)
	// Commits a transaction, while optionally updating documents.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(context.Context, *RollbackRequest) (*empty.Empty, error)
	// Runs a query.
	RunQuery(*RunQueryRequest, Firestore_RunQueryServer) error
	// Streams batches of document updates and deletes, in order.
	Write(Firestore_WriteServer) error
	// Listens to changes.
	Listen(Firestore_ListenServer) error
	// Lists all the collection IDs underneath a document.
	ListCollectionIds(context.Context, *ListCollectionIdsRequest) (*ListCollectionIdsResponse, error)
}

func RegisterFirestoreServer(s *grpc.Server, srv FirestoreServer) {
	s.RegisterService(&_Firestore_serviceDesc, srv)
}

func _Firestore_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/GetDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/ListDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_CreateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).CreateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/CreateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).CreateDocument(ctx, req.(*CreateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_UpdateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).UpdateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/UpdateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).UpdateDocument(ctx, req.(*UpdateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_DeleteDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).DeleteDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/DeleteDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).DeleteDocument(ctx, req.(*DeleteDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_BatchGetDocuments_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BatchGetDocumentsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FirestoreServer).BatchGetDocuments(m, &firestoreBatchGetDocumentsServer{stream})
}

type Firestore_BatchGetDocumentsServer interface {
	Send(*BatchGetDocumentsResponse) error
	grpc.ServerStream
}

type firestoreBatchGetDocumentsServer struct {
	grpc.ServerStream
}

func (x *firestoreBatchGetDocumentsServer) Send(m *BatchGetDocumentsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Firestore_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_RunQuery_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RunQueryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FirestoreServer).RunQuery(m, &firestoreRunQueryServer{stream})
}

type Firestore_RunQueryServer interface {
	Send(*RunQueryResponse) error
	grpc.ServerStream
}

type firestoreRunQueryServer struct {
	grpc.ServerStream
}

func (x *firestoreRunQueryServer) Send(m *RunQueryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Firestore_Write_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FirestoreServer).Write(&firestoreWriteServer{stream})
}

type Firestore_WriteServer interface {
	Send(*WriteResponse) error
	Recv() (*WriteRequest, error)
	grpc.ServerStream
}

type firestoreWriteServer struct {
	grpc.ServerStream
}

func (x *firestoreWriteServer) Send(m *WriteResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *firestoreWriteServer) Recv() (*WriteRequest, error) {
	m := new(WriteRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Firestore_Listen_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FirestoreServer).Listen(&firestoreListenServer{stream})
}

type Firestore_ListenServer interface {
	Send(*ListenResponse) error
	Recv() (*ListenRequest, error)
	grpc.ServerStream
}

type firestoreListenServer struct {
	grpc.ServerStream
}

func (x *firestoreListenServer) Send(m *ListenResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *firestoreListenServer) Recv() (*ListenRequest, error) {
	m := new(ListenRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Firestore_ListCollectionIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCollectionIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).ListCollectionIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/ListCollectionIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).ListCollectionIds(ctx, req.(*ListCollectionIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Firestore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.firestore.v1.Firestore",
	HandlerType: (*FirestoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDocument",
			Handler:    _Firestore_GetDocument_Handler,
		},
		{
			MethodName: "ListDocuments",
			Handler:    _Firestore_ListDocuments_Handler,
		},
		{
			MethodName: "CreateDocument",
			Handler:    _Firestore_CreateDocument_Handler,
		},
		{
			MethodName: "UpdateDocument",
			Handler:    _Firestore_UpdateDocument_Handler,
		},
		{
			MethodName: "DeleteDocument",
			Handler:    _Firestore_DeleteDocument_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Firestore_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Firestore_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Firestore_Rollback_Handler,
		},
		{
			MethodName: "ListCollectionIds",
			Handler:    _Firestore_ListCollectionIds_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "BatchGetDocuments",
			Handler:       _Firestore_BatchGetDocuments_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RunQuery",
			Handler:       _Firestore_RunQuery_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Write",
			Handler:       _Firestore_Write_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Listen",
			Handler:       _Firestore_Listen_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/firestore/v1/firestore.proto",
}
