package supportapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/support/mgmt/2019-05-01-preview/support"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result support.OperationsListResult, err error)
}

var _ OperationsClientAPI = (*support.OperationsClient)(nil)

// ServicesClientAPI contains the set of methods on the ServicesClient type.
type ServicesClientAPI interface {
	Get(ctx context.Context, serviceName string) (result support.Service, err error)
	List(ctx context.Context) (result support.ServicesListResult, err error)
}

var _ ServicesClientAPI = (*support.ServicesClient)(nil)

// ProblemClassificationsClientAPI contains the set of methods on the ProblemClassificationsClient type.
type ProblemClassificationsClientAPI interface {
	Get(ctx context.Context, serviceName string, problemClassificationName string) (result support.ProblemClassification, err error)
	List(ctx context.Context, serviceName string) (result support.ProblemClassificationsListResult, err error)
}

var _ ProblemClassificationsClientAPI = (*support.ProblemClassificationsClient)(nil)

// TicketsClientAPI contains the set of methods on the TicketsClient type.
type TicketsClientAPI interface {
	CheckNameAvailability(ctx context.Context, checkNameAvailabilityInput support.CheckNameAvailabilityInput) (result support.CheckNameAvailabilityOutput, err error)
	Create(ctx context.Context, supportTicketName string, createSupportTicketParameters support.TicketDetails) (result support.TicketsCreateFuture, err error)
	Get(ctx context.Context, supportTicketName string) (result support.TicketDetails, err error)
	List(ctx context.Context, top *int32, filter string) (result support.TicketsListResultPage, err error)
	ListComplete(ctx context.Context, top *int32, filter string) (result support.TicketsListResultIterator, err error)
	Update(ctx context.Context, supportTicketName string, updateSupportTicket support.UpdateSupportTicket) (result support.TicketDetails, err error)
}

var _ TicketsClientAPI = (*support.TicketsClient)(nil)

// CommunicationsClientAPI contains the set of methods on the CommunicationsClient type.
type CommunicationsClientAPI interface {
	CheckNameAvailability(ctx context.Context, supportTicketName string, checkNameAvailabilityInput support.CheckNameAvailabilityInput) (result support.CheckNameAvailabilityOutput, err error)
	Create(ctx context.Context, supportTicketName string, communicationName string, createCommunicationParameters support.CommunicationDetails) (result support.CommunicationsCreateFuture, err error)
	Get(ctx context.Context, supportTicketName string, communicationName string) (result support.CommunicationDetails, err error)
	List(ctx context.Context, supportTicketName string, top *int32, filter string) (result support.CommunicationsListResultPage, err error)
	ListComplete(ctx context.Context, supportTicketName string, top *int32, filter string) (result support.CommunicationsListResultIterator, err error)
}

var _ CommunicationsClientAPI = (*support.CommunicationsClient)(nil)
