// +build !ignore_autogenerated

/*
Copyright 2019 Red Hat Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by controller-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BackupStorageConfig) DeepCopyInto(out *BackupStorageConfig) {
	*out = *in
	if in.CredsSecretRef != nil {
		in, out := &in.CredsSecretRef, &out.CredsSecretRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.S3CustomCABundle != nil {
		in, out := &in.S3CustomCABundle, &out.S3CustomCABundle
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BackupStorageConfig.
func (in *BackupStorageConfig) DeepCopy() *BackupStorageConfig {
	if in == nil {
		return nil
	}
	out := new(BackupStorageConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Condition) DeepCopyInto(out *Condition) {
	*out = *in
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Condition.
func (in *Condition) DeepCopy() *Condition {
	if in == nil {
		return nil
	}
	out := new(Condition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Conditions) DeepCopyInto(out *Conditions) {
	*out = *in
	if in.List != nil {
		in, out := &in.List, &out.List
		*out = make([]Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Conditions.
func (in *Conditions) DeepCopy() *Conditions {
	if in == nil {
		return nil
	}
	out := new(Conditions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectImageMigration) DeepCopyInto(out *DirectImageMigration) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectImageMigration.
func (in *DirectImageMigration) DeepCopy() *DirectImageMigration {
	if in == nil {
		return nil
	}
	out := new(DirectImageMigration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DirectImageMigration) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectImageMigrationList) DeepCopyInto(out *DirectImageMigrationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DirectImageMigration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectImageMigrationList.
func (in *DirectImageMigrationList) DeepCopy() *DirectImageMigrationList {
	if in == nil {
		return nil
	}
	out := new(DirectImageMigrationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DirectImageMigrationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectImageMigrationSpec) DeepCopyInto(out *DirectImageMigrationSpec) {
	*out = *in
	if in.SrcMigClusterRef != nil {
		in, out := &in.SrcMigClusterRef, &out.SrcMigClusterRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.DestMigClusterRef != nil {
		in, out := &in.DestMigClusterRef, &out.DestMigClusterRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectImageMigrationSpec.
func (in *DirectImageMigrationSpec) DeepCopy() *DirectImageMigrationSpec {
	if in == nil {
		return nil
	}
	out := new(DirectImageMigrationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectImageMigrationStatus) DeepCopyInto(out *DirectImageMigrationStatus) {
	*out = *in
	in.Conditions.DeepCopyInto(&out.Conditions)
	if in.StartTimestamp != nil {
		in, out := &in.StartTimestamp, &out.StartTimestamp
		*out = (*in).DeepCopy()
	}
	if in.Errors != nil {
		in, out := &in.Errors, &out.Errors
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.NewISs != nil {
		in, out := &in.NewISs, &out.NewISs
		*out = make([]*ImageStreamListItem, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(ImageStreamListItem)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.SuccessfulISs != nil {
		in, out := &in.SuccessfulISs, &out.SuccessfulISs
		*out = make([]*ImageStreamListItem, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(ImageStreamListItem)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.DeletedISs != nil {
		in, out := &in.DeletedISs, &out.DeletedISs
		*out = make([]*ImageStreamListItem, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(ImageStreamListItem)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.FailedISs != nil {
		in, out := &in.FailedISs, &out.FailedISs
		*out = make([]*ImageStreamListItem, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(ImageStreamListItem)
				(*in).DeepCopyInto(*out)
			}
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectImageMigrationStatus.
func (in *DirectImageMigrationStatus) DeepCopy() *DirectImageMigrationStatus {
	if in == nil {
		return nil
	}
	out := new(DirectImageMigrationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectImageStreamMigration) DeepCopyInto(out *DirectImageStreamMigration) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectImageStreamMigration.
func (in *DirectImageStreamMigration) DeepCopy() *DirectImageStreamMigration {
	if in == nil {
		return nil
	}
	out := new(DirectImageStreamMigration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DirectImageStreamMigration) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectImageStreamMigrationList) DeepCopyInto(out *DirectImageStreamMigrationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DirectImageStreamMigration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectImageStreamMigrationList.
func (in *DirectImageStreamMigrationList) DeepCopy() *DirectImageStreamMigrationList {
	if in == nil {
		return nil
	}
	out := new(DirectImageStreamMigrationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DirectImageStreamMigrationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectImageStreamMigrationSpec) DeepCopyInto(out *DirectImageStreamMigrationSpec) {
	*out = *in
	if in.SrcMigClusterRef != nil {
		in, out := &in.SrcMigClusterRef, &out.SrcMigClusterRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.DestMigClusterRef != nil {
		in, out := &in.DestMigClusterRef, &out.DestMigClusterRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.ImageStreamRef != nil {
		in, out := &in.ImageStreamRef, &out.ImageStreamRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectImageStreamMigrationSpec.
func (in *DirectImageStreamMigrationSpec) DeepCopy() *DirectImageStreamMigrationSpec {
	if in == nil {
		return nil
	}
	out := new(DirectImageStreamMigrationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectImageStreamMigrationStatus) DeepCopyInto(out *DirectImageStreamMigrationStatus) {
	*out = *in
	in.Conditions.DeepCopyInto(&out.Conditions)
	if in.StartTimestamp != nil {
		in, out := &in.StartTimestamp, &out.StartTimestamp
		*out = (*in).DeepCopy()
	}
	if in.Errors != nil {
		in, out := &in.Errors, &out.Errors
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectImageStreamMigrationStatus.
func (in *DirectImageStreamMigrationStatus) DeepCopy() *DirectImageStreamMigrationStatus {
	if in == nil {
		return nil
	}
	out := new(DirectImageStreamMigrationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectVolumeMigration) DeepCopyInto(out *DirectVolumeMigration) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectVolumeMigration.
func (in *DirectVolumeMigration) DeepCopy() *DirectVolumeMigration {
	if in == nil {
		return nil
	}
	out := new(DirectVolumeMigration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DirectVolumeMigration) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectVolumeMigrationList) DeepCopyInto(out *DirectVolumeMigrationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DirectVolumeMigration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectVolumeMigrationList.
func (in *DirectVolumeMigrationList) DeepCopy() *DirectVolumeMigrationList {
	if in == nil {
		return nil
	}
	out := new(DirectVolumeMigrationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DirectVolumeMigrationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectVolumeMigrationProgress) DeepCopyInto(out *DirectVolumeMigrationProgress) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectVolumeMigrationProgress.
func (in *DirectVolumeMigrationProgress) DeepCopy() *DirectVolumeMigrationProgress {
	if in == nil {
		return nil
	}
	out := new(DirectVolumeMigrationProgress)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DirectVolumeMigrationProgress) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectVolumeMigrationProgressList) DeepCopyInto(out *DirectVolumeMigrationProgressList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DirectVolumeMigrationProgress, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectVolumeMigrationProgressList.
func (in *DirectVolumeMigrationProgressList) DeepCopy() *DirectVolumeMigrationProgressList {
	if in == nil {
		return nil
	}
	out := new(DirectVolumeMigrationProgressList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DirectVolumeMigrationProgressList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectVolumeMigrationProgressSpec) DeepCopyInto(out *DirectVolumeMigrationProgressSpec) {
	*out = *in
	if in.ClusterRef != nil {
		in, out := &in.ClusterRef, &out.ClusterRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.PodRef != nil {
		in, out := &in.PodRef, &out.PodRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.PodSelector != nil {
		in, out := &in.PodSelector, &out.PodSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectVolumeMigrationProgressSpec.
func (in *DirectVolumeMigrationProgressSpec) DeepCopy() *DirectVolumeMigrationProgressSpec {
	if in == nil {
		return nil
	}
	out := new(DirectVolumeMigrationProgressSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectVolumeMigrationProgressStatus) DeepCopyInto(out *DirectVolumeMigrationProgressStatus) {
	*out = *in
	in.Conditions.DeepCopyInto(&out.Conditions)
	in.RsyncPodStatus.DeepCopyInto(&out.RsyncPodStatus)
	if in.RsyncPodStatuses != nil {
		in, out := &in.RsyncPodStatuses, &out.RsyncPodStatuses
		*out = make([]RsyncPodStatus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.RsyncElapsedTime != nil {
		in, out := &in.RsyncElapsedTime, &out.RsyncElapsedTime
		*out = new(metav1.Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectVolumeMigrationProgressStatus.
func (in *DirectVolumeMigrationProgressStatus) DeepCopy() *DirectVolumeMigrationProgressStatus {
	if in == nil {
		return nil
	}
	out := new(DirectVolumeMigrationProgressStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectVolumeMigrationSpec) DeepCopyInto(out *DirectVolumeMigrationSpec) {
	*out = *in
	if in.SrcMigClusterRef != nil {
		in, out := &in.SrcMigClusterRef, &out.SrcMigClusterRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.DestMigClusterRef != nil {
		in, out := &in.DestMigClusterRef, &out.DestMigClusterRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.PersistentVolumeClaims != nil {
		in, out := &in.PersistentVolumeClaims, &out.PersistentVolumeClaims
		*out = make([]PVCToMigrate, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectVolumeMigrationSpec.
func (in *DirectVolumeMigrationSpec) DeepCopy() *DirectVolumeMigrationSpec {
	if in == nil {
		return nil
	}
	out := new(DirectVolumeMigrationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DirectVolumeMigrationStatus) DeepCopyInto(out *DirectVolumeMigrationStatus) {
	*out = *in
	in.Conditions.DeepCopyInto(&out.Conditions)
	if in.StartTimestamp != nil {
		in, out := &in.StartTimestamp, &out.StartTimestamp
		*out = (*in).DeepCopy()
	}
	if in.Errors != nil {
		in, out := &in.Errors, &out.Errors
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SuccessfulPods != nil {
		in, out := &in.SuccessfulPods, &out.SuccessfulPods
		*out = make([]*PodProgress, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(PodProgress)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.FailedPods != nil {
		in, out := &in.FailedPods, &out.FailedPods
		*out = make([]*PodProgress, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(PodProgress)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.RunningPods != nil {
		in, out := &in.RunningPods, &out.RunningPods
		*out = make([]*PodProgress, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(PodProgress)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.PendingPods != nil {
		in, out := &in.PendingPods, &out.PendingPods
		*out = make([]*PodProgress, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(PodProgress)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.RsyncOperations != nil {
		in, out := &in.RsyncOperations, &out.RsyncOperations
		*out = make([]*RsyncOperation, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(RsyncOperation)
				(*in).DeepCopyInto(*out)
			}
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DirectVolumeMigrationStatus.
func (in *DirectVolumeMigrationStatus) DeepCopy() *DirectVolumeMigrationStatus {
	if in == nil {
		return nil
	}
	out := new(DirectVolumeMigrationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageStreamListItem) DeepCopyInto(out *ImageStreamListItem) {
	*out = *in
	if in.ObjectReference != nil {
		in, out := &in.ObjectReference, &out.ObjectReference
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.DirectMigration != nil {
		in, out := &in.DirectMigration, &out.DirectMigration
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.Errors != nil {
		in, out := &in.Errors, &out.Errors
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageStreamListItem.
func (in *ImageStreamListItem) DeepCopy() *ImageStreamListItem {
	if in == nil {
		return nil
	}
	out := new(ImageStreamListItem)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Incompatible) DeepCopyInto(out *Incompatible) {
	*out = *in
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = make([]IncompatibleNamespace, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Incompatible.
func (in *Incompatible) DeepCopy() *Incompatible {
	if in == nil {
		return nil
	}
	out := new(Incompatible)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IncompatibleGVK) DeepCopyInto(out *IncompatibleGVK) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IncompatibleGVK.
func (in *IncompatibleGVK) DeepCopy() *IncompatibleGVK {
	if in == nil {
		return nil
	}
	out := new(IncompatibleGVK)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IncompatibleNamespace) DeepCopyInto(out *IncompatibleNamespace) {
	*out = *in
	if in.GVKs != nil {
		in, out := &in.GVKs, &out.GVKs
		*out = make([]IncompatibleGVK, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IncompatibleNamespace.
func (in *IncompatibleNamespace) DeepCopy() *IncompatibleNamespace {
	if in == nil {
		return nil
	}
	out := new(IncompatibleNamespace)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigAnalytic) DeepCopyInto(out *MigAnalytic) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigAnalytic.
func (in *MigAnalytic) DeepCopy() *MigAnalytic {
	if in == nil {
		return nil
	}
	out := new(MigAnalytic)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigAnalytic) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigAnalyticList) DeepCopyInto(out *MigAnalyticList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MigAnalytic, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigAnalyticList.
func (in *MigAnalyticList) DeepCopy() *MigAnalyticList {
	if in == nil {
		return nil
	}
	out := new(MigAnalyticList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigAnalyticList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigAnalyticNSImage) DeepCopyInto(out *MigAnalyticNSImage) {
	*out = *in
	out.Size = in.Size.DeepCopy()
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigAnalyticNSImage.
func (in *MigAnalyticNSImage) DeepCopy() *MigAnalyticNSImage {
	if in == nil {
		return nil
	}
	out := new(MigAnalyticNSImage)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigAnalyticNSResource) DeepCopyInto(out *MigAnalyticNSResource) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigAnalyticNSResource.
func (in *MigAnalyticNSResource) DeepCopy() *MigAnalyticNSResource {
	if in == nil {
		return nil
	}
	out := new(MigAnalyticNSResource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigAnalyticNamespace) DeepCopyInto(out *MigAnalyticNamespace) {
	*out = *in
	out.PVCapacity = in.PVCapacity.DeepCopy()
	out.ImageSizeTotal = in.ImageSizeTotal.DeepCopy()
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]MigAnalyticNSImage, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.K8SResources != nil {
		in, out := &in.K8SResources, &out.K8SResources
		*out = make([]MigAnalyticNSResource, len(*in))
		copy(*out, *in)
	}
	if in.PersistentVolumes != nil {
		in, out := &in.PersistentVolumes, &out.PersistentVolumes
		*out = make([]MigAnalyticPersistentVolumeClaim, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ExcludedK8SResources != nil {
		in, out := &in.ExcludedK8SResources, &out.ExcludedK8SResources
		*out = make([]MigAnalyticNSResource, len(*in))
		copy(*out, *in)
	}
	if in.IncompatibleK8SResources != nil {
		in, out := &in.IncompatibleK8SResources, &out.IncompatibleK8SResources
		*out = make([]MigAnalyticNSResource, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigAnalyticNamespace.
func (in *MigAnalyticNamespace) DeepCopy() *MigAnalyticNamespace {
	if in == nil {
		return nil
	}
	out := new(MigAnalyticNamespace)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigAnalyticPersistentVolumeClaim) DeepCopyInto(out *MigAnalyticPersistentVolumeClaim) {
	*out = *in
	out.RequestedCapacity = in.RequestedCapacity.DeepCopy()
	out.ActualCapacity = in.ActualCapacity.DeepCopy()
	out.ProposedCapacity = in.ProposedCapacity.DeepCopy()
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigAnalyticPersistentVolumeClaim.
func (in *MigAnalyticPersistentVolumeClaim) DeepCopy() *MigAnalyticPersistentVolumeClaim {
	if in == nil {
		return nil
	}
	out := new(MigAnalyticPersistentVolumeClaim)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigAnalyticPlan) DeepCopyInto(out *MigAnalyticPlan) {
	*out = *in
	out.PVCapacity = in.PVCapacity.DeepCopy()
	out.ImageSizeTotal = in.ImageSizeTotal.DeepCopy()
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = make([]MigAnalyticNamespace, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigAnalyticPlan.
func (in *MigAnalyticPlan) DeepCopy() *MigAnalyticPlan {
	if in == nil {
		return nil
	}
	out := new(MigAnalyticPlan)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigAnalyticSpec) DeepCopyInto(out *MigAnalyticSpec) {
	*out = *in
	if in.MigPlanRef != nil {
		in, out := &in.MigPlanRef, &out.MigPlanRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigAnalyticSpec.
func (in *MigAnalyticSpec) DeepCopy() *MigAnalyticSpec {
	if in == nil {
		return nil
	}
	out := new(MigAnalyticSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigAnalyticStatus) DeepCopyInto(out *MigAnalyticStatus) {
	*out = *in
	in.Conditions.DeepCopyInto(&out.Conditions)
	in.Analytics.DeepCopyInto(&out.Analytics)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigAnalyticStatus.
func (in *MigAnalyticStatus) DeepCopy() *MigAnalyticStatus {
	if in == nil {
		return nil
	}
	out := new(MigAnalyticStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigCluster) DeepCopyInto(out *MigCluster) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigCluster.
func (in *MigCluster) DeepCopy() *MigCluster {
	if in == nil {
		return nil
	}
	out := new(MigCluster)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigCluster) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigClusterList) DeepCopyInto(out *MigClusterList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MigCluster, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigClusterList.
func (in *MigClusterList) DeepCopy() *MigClusterList {
	if in == nil {
		return nil
	}
	out := new(MigClusterList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigClusterList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigClusterSpec) DeepCopyInto(out *MigClusterSpec) {
	*out = *in
	if in.ServiceAccountSecretRef != nil {
		in, out := &in.ServiceAccountSecretRef, &out.ServiceAccountSecretRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.CABundle != nil {
		in, out := &in.CABundle, &out.CABundle
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	if in.RestartRestic != nil {
		in, out := &in.RestartRestic, &out.RestartRestic
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigClusterSpec.
func (in *MigClusterSpec) DeepCopy() *MigClusterSpec {
	if in == nil {
		return nil
	}
	out := new(MigClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigClusterStatus) DeepCopyInto(out *MigClusterStatus) {
	*out = *in
	in.Conditions.DeepCopyInto(&out.Conditions)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigClusterStatus.
func (in *MigClusterStatus) DeepCopy() *MigClusterStatus {
	if in == nil {
		return nil
	}
	out := new(MigClusterStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigHook) DeepCopyInto(out *MigHook) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigHook.
func (in *MigHook) DeepCopy() *MigHook {
	if in == nil {
		return nil
	}
	out := new(MigHook)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigHook) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigHookList) DeepCopyInto(out *MigHookList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MigHook, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigHookList.
func (in *MigHookList) DeepCopy() *MigHookList {
	if in == nil {
		return nil
	}
	out := new(MigHookList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigHookList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigHookSpec) DeepCopyInto(out *MigHookSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigHookSpec.
func (in *MigHookSpec) DeepCopy() *MigHookSpec {
	if in == nil {
		return nil
	}
	out := new(MigHookSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigHookStatus) DeepCopyInto(out *MigHookStatus) {
	*out = *in
	in.Conditions.DeepCopyInto(&out.Conditions)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigHookStatus.
func (in *MigHookStatus) DeepCopy() *MigHookStatus {
	if in == nil {
		return nil
	}
	out := new(MigHookStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigMigration) DeepCopyInto(out *MigMigration) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigMigration.
func (in *MigMigration) DeepCopy() *MigMigration {
	if in == nil {
		return nil
	}
	out := new(MigMigration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigMigration) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigMigrationList) DeepCopyInto(out *MigMigrationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MigMigration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigMigrationList.
func (in *MigMigrationList) DeepCopy() *MigMigrationList {
	if in == nil {
		return nil
	}
	out := new(MigMigrationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigMigrationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigMigrationSpec) DeepCopyInto(out *MigMigrationSpec) {
	*out = *in
	if in.MigPlanRef != nil {
		in, out := &in.MigPlanRef, &out.MigPlanRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigMigrationSpec.
func (in *MigMigrationSpec) DeepCopy() *MigMigrationSpec {
	if in == nil {
		return nil
	}
	out := new(MigMigrationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigMigrationStatus) DeepCopyInto(out *MigMigrationStatus) {
	*out = *in
	in.Conditions.DeepCopyInto(&out.Conditions)
	in.UnhealthyResources.DeepCopyInto(&out.UnhealthyResources)
	if in.StartTimestamp != nil {
		in, out := &in.StartTimestamp, &out.StartTimestamp
		*out = (*in).DeepCopy()
	}
	if in.Pipeline != nil {
		in, out := &in.Pipeline, &out.Pipeline
		*out = make([]*Step, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Step)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.Errors != nil {
		in, out := &in.Errors, &out.Errors
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigMigrationStatus.
func (in *MigMigrationStatus) DeepCopy() *MigMigrationStatus {
	if in == nil {
		return nil
	}
	out := new(MigMigrationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigPlan) DeepCopyInto(out *MigPlan) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigPlan.
func (in *MigPlan) DeepCopy() *MigPlan {
	if in == nil {
		return nil
	}
	out := new(MigPlan)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigPlan) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigPlanHook) DeepCopyInto(out *MigPlanHook) {
	*out = *in
	if in.Reference != nil {
		in, out := &in.Reference, &out.Reference
		*out = new(v1.ObjectReference)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigPlanHook.
func (in *MigPlanHook) DeepCopy() *MigPlanHook {
	if in == nil {
		return nil
	}
	out := new(MigPlanHook)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigPlanList) DeepCopyInto(out *MigPlanList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MigPlan, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigPlanList.
func (in *MigPlanList) DeepCopy() *MigPlanList {
	if in == nil {
		return nil
	}
	out := new(MigPlanList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigPlanList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigPlanSpec) DeepCopyInto(out *MigPlanSpec) {
	*out = *in
	in.PersistentVolumes.DeepCopyInto(&out.PersistentVolumes)
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SrcMigClusterRef != nil {
		in, out := &in.SrcMigClusterRef, &out.SrcMigClusterRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.DestMigClusterRef != nil {
		in, out := &in.DestMigClusterRef, &out.DestMigClusterRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.MigStorageRef != nil {
		in, out := &in.MigStorageRef, &out.MigStorageRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.Hooks != nil {
		in, out := &in.Hooks, &out.Hooks
		*out = make([]MigPlanHook, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigPlanSpec.
func (in *MigPlanSpec) DeepCopy() *MigPlanSpec {
	if in == nil {
		return nil
	}
	out := new(MigPlanSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigPlanStatus) DeepCopyInto(out *MigPlanStatus) {
	*out = *in
	in.UnhealthyResources.DeepCopyInto(&out.UnhealthyResources)
	in.Conditions.DeepCopyInto(&out.Conditions)
	in.Incompatible.DeepCopyInto(&out.Incompatible)
	if in.ExcludedResources != nil {
		in, out := &in.ExcludedResources, &out.ExcludedResources
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SrcStorageClasses != nil {
		in, out := &in.SrcStorageClasses, &out.SrcStorageClasses
		*out = make([]StorageClass, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DestStorageClasses != nil {
		in, out := &in.DestStorageClasses, &out.DestStorageClasses
		*out = make([]StorageClass, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigPlanStatus.
func (in *MigPlanStatus) DeepCopy() *MigPlanStatus {
	if in == nil {
		return nil
	}
	out := new(MigPlanStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigStorage) DeepCopyInto(out *MigStorage) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigStorage.
func (in *MigStorage) DeepCopy() *MigStorage {
	if in == nil {
		return nil
	}
	out := new(MigStorage)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigStorage) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigStorageList) DeepCopyInto(out *MigStorageList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MigStorage, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigStorageList.
func (in *MigStorageList) DeepCopy() *MigStorageList {
	if in == nil {
		return nil
	}
	out := new(MigStorageList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MigStorageList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigStorageSpec) DeepCopyInto(out *MigStorageSpec) {
	*out = *in
	in.BackupStorageConfig.DeepCopyInto(&out.BackupStorageConfig)
	in.VolumeSnapshotConfig.DeepCopyInto(&out.VolumeSnapshotConfig)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigStorageSpec.
func (in *MigStorageSpec) DeepCopy() *MigStorageSpec {
	if in == nil {
		return nil
	}
	out := new(MigStorageSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigStorageStatus) DeepCopyInto(out *MigStorageStatus) {
	*out = *in
	in.Conditions.DeepCopyInto(&out.Conditions)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigStorageStatus.
func (in *MigStorageStatus) DeepCopy() *MigStorageStatus {
	if in == nil {
		return nil
	}
	out := new(MigStorageStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PV) DeepCopyInto(out *PV) {
	*out = *in
	out.Capacity = in.Capacity.DeepCopy()
	in.Supported.DeepCopyInto(&out.Supported)
	out.Selection = in.Selection
	in.PVC.DeepCopyInto(&out.PVC)
	if in.NFS != nil {
		in, out := &in.NFS, &out.NFS
		*out = new(v1.NFSVolumeSource)
		**out = **in
	}
	out.ProposedCapacity = in.ProposedCapacity.DeepCopy()
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PV.
func (in *PV) DeepCopy() *PV {
	if in == nil {
		return nil
	}
	out := new(PV)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PVC) DeepCopyInto(out *PVC) {
	*out = *in
	if in.AccessModes != nil {
		in, out := &in.AccessModes, &out.AccessModes
		*out = make([]v1.PersistentVolumeAccessMode, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PVC.
func (in *PVC) DeepCopy() *PVC {
	if in == nil {
		return nil
	}
	out := new(PVC)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PVCToMigrate) DeepCopyInto(out *PVCToMigrate) {
	*out = *in
	if in.ObjectReference != nil {
		in, out := &in.ObjectReference, &out.ObjectReference
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.TargetAccessModes != nil {
		in, out := &in.TargetAccessModes, &out.TargetAccessModes
		*out = make([]v1.PersistentVolumeAccessMode, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PVCToMigrate.
func (in *PVCToMigrate) DeepCopy() *PVCToMigrate {
	if in == nil {
		return nil
	}
	out := new(PVCToMigrate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PersistentVolumes) DeepCopyInto(out *PersistentVolumes) {
	*out = *in
	if in.List != nil {
		in, out := &in.List, &out.List
		*out = make([]PV, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.index != nil {
		in, out := &in.index, &out.index
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PersistentVolumes.
func (in *PersistentVolumes) DeepCopy() *PersistentVolumes {
	if in == nil {
		return nil
	}
	out := new(PersistentVolumes)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PlanResources) DeepCopyInto(out *PlanResources) {
	*out = *in
	if in.MigPlan != nil {
		in, out := &in.MigPlan, &out.MigPlan
		*out = new(MigPlan)
		(*in).DeepCopyInto(*out)
	}
	if in.MigStorage != nil {
		in, out := &in.MigStorage, &out.MigStorage
		*out = new(MigStorage)
		(*in).DeepCopyInto(*out)
	}
	if in.SrcMigCluster != nil {
		in, out := &in.SrcMigCluster, &out.SrcMigCluster
		*out = new(MigCluster)
		(*in).DeepCopyInto(*out)
	}
	if in.DestMigCluster != nil {
		in, out := &in.DestMigCluster, &out.DestMigCluster
		*out = new(MigCluster)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PlanResources.
func (in *PlanResources) DeepCopy() *PlanResources {
	if in == nil {
		return nil
	}
	out := new(PlanResources)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodProgress) DeepCopyInto(out *PodProgress) {
	*out = *in
	if in.ObjectReference != nil {
		in, out := &in.ObjectReference, &out.ObjectReference
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.PVCReference != nil {
		in, out := &in.PVCReference, &out.PVCReference
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.TotalElapsedTime != nil {
		in, out := &in.TotalElapsedTime, &out.TotalElapsedTime
		*out = new(metav1.Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodProgress.
func (in *PodProgress) DeepCopy() *PodProgress {
	if in == nil {
		return nil
	}
	out := new(PodProgress)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RsyncOperation) DeepCopyInto(out *RsyncOperation) {
	*out = *in
	if in.PVCReference != nil {
		in, out := &in.PVCReference, &out.PVCReference
		*out = new(v1.ObjectReference)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RsyncOperation.
func (in *RsyncOperation) DeepCopy() *RsyncOperation {
	if in == nil {
		return nil
	}
	out := new(RsyncOperation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RsyncPodStatus) DeepCopyInto(out *RsyncPodStatus) {
	*out = *in
	if in.ExitCode != nil {
		in, out := &in.ExitCode, &out.ExitCode
		*out = new(int32)
		**out = **in
	}
	if in.ContainerElapsedTime != nil {
		in, out := &in.ContainerElapsedTime, &out.ContainerElapsedTime
		*out = new(metav1.Duration)
		**out = **in
	}
	if in.CreationTimestamp != nil {
		in, out := &in.CreationTimestamp, &out.CreationTimestamp
		*out = (*in).DeepCopy()
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RsyncPodStatus.
func (in *RsyncPodStatus) DeepCopy() *RsyncPodStatus {
	if in == nil {
		return nil
	}
	out := new(RsyncPodStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Selection) DeepCopyInto(out *Selection) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Selection.
func (in *Selection) DeepCopy() *Selection {
	if in == nil {
		return nil
	}
	out := new(Selection)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Step) DeepCopyInto(out *Step) {
	*out = *in
	in.Timed.DeepCopyInto(&out.Timed)
	if in.Progress != nil {
		in, out := &in.Progress, &out.Progress
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Step.
func (in *Step) DeepCopy() *Step {
	if in == nil {
		return nil
	}
	out := new(Step)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StorageClass) DeepCopyInto(out *StorageClass) {
	*out = *in
	if in.AccessModes != nil {
		in, out := &in.AccessModes, &out.AccessModes
		*out = make([]v1.PersistentVolumeAccessMode, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StorageClass.
func (in *StorageClass) DeepCopy() *StorageClass {
	if in == nil {
		return nil
	}
	out := new(StorageClass)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Supported) DeepCopyInto(out *Supported) {
	*out = *in
	if in.Actions != nil {
		in, out := &in.Actions, &out.Actions
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.CopyMethods != nil {
		in, out := &in.CopyMethods, &out.CopyMethods
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Supported.
func (in *Supported) DeepCopy() *Supported {
	if in == nil {
		return nil
	}
	out := new(Supported)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Timed) DeepCopyInto(out *Timed) {
	*out = *in
	if in.Started != nil {
		in, out := &in.Started, &out.Started
		*out = (*in).DeepCopy()
	}
	if in.Completed != nil {
		in, out := &in.Completed, &out.Completed
		*out = (*in).DeepCopy()
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Timed.
func (in *Timed) DeepCopy() *Timed {
	if in == nil {
		return nil
	}
	out := new(Timed)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UnhealthyNamespace) DeepCopyInto(out *UnhealthyNamespace) {
	*out = *in
	if in.Workloads != nil {
		in, out := &in.Workloads, &out.Workloads
		*out = make([]Workload, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UnhealthyNamespace.
func (in *UnhealthyNamespace) DeepCopy() *UnhealthyNamespace {
	if in == nil {
		return nil
	}
	out := new(UnhealthyNamespace)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UnhealthyResources) DeepCopyInto(out *UnhealthyResources) {
	*out = *in
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = make([]UnhealthyNamespace, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UnhealthyResources.
func (in *UnhealthyResources) DeepCopy() *UnhealthyResources {
	if in == nil {
		return nil
	}
	out := new(UnhealthyResources)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VolumeSnapshotConfig) DeepCopyInto(out *VolumeSnapshotConfig) {
	*out = *in
	if in.CredsSecretRef != nil {
		in, out := &in.CredsSecretRef, &out.CredsSecretRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VolumeSnapshotConfig.
func (in *VolumeSnapshotConfig) DeepCopy() *VolumeSnapshotConfig {
	if in == nil {
		return nil
	}
	out := new(VolumeSnapshotConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Workload) DeepCopyInto(out *Workload) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Workload.
func (in *Workload) DeepCopy() *Workload {
	if in == nil {
		return nil
	}
	out := new(Workload)
	in.DeepCopyInto(out)
	return out
}
