package account

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// DataLakeAnalyticsAccountState enumerates the values for data lake analytics account state.
type DataLakeAnalyticsAccountState string

const (
	// Active ...
	Active DataLakeAnalyticsAccountState = "active"
	// Suspended ...
	Suspended DataLakeAnalyticsAccountState = "suspended"
)

// PossibleDataLakeAnalyticsAccountStateValues returns an array of possible values for the DataLakeAnalyticsAccountState const type.
func PossibleDataLakeAnalyticsAccountStateValues() []DataLakeAnalyticsAccountState {
	return []DataLakeAnalyticsAccountState{Active, Suspended}
}

// DataLakeAnalyticsAccountStatus enumerates the values for data lake analytics account status.
type DataLakeAnalyticsAccountStatus string

const (
	// Creating ...
	Creating DataLakeAnalyticsAccountStatus = "Creating"
	// Deleted ...
	Deleted DataLakeAnalyticsAccountStatus = "Deleted"
	// Deleting ...
	Deleting DataLakeAnalyticsAccountStatus = "Deleting"
	// Failed ...
	Failed DataLakeAnalyticsAccountStatus = "Failed"
	// Patching ...
	Patching DataLakeAnalyticsAccountStatus = "Patching"
	// Resuming ...
	Resuming DataLakeAnalyticsAccountStatus = "Resuming"
	// Running ...
	Running DataLakeAnalyticsAccountStatus = "Running"
	// Succeeded ...
	Succeeded DataLakeAnalyticsAccountStatus = "Succeeded"
	// Suspending ...
	Suspending DataLakeAnalyticsAccountStatus = "Suspending"
)

// PossibleDataLakeAnalyticsAccountStatusValues returns an array of possible values for the DataLakeAnalyticsAccountStatus const type.
func PossibleDataLakeAnalyticsAccountStatusValues() []DataLakeAnalyticsAccountStatus {
	return []DataLakeAnalyticsAccountStatus{Creating, Deleted, Deleting, Failed, Patching, Resuming, Running, Succeeded, Suspending}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded}
}
