package streamanalytics

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/streamanalytics/mgmt/2020-03-01/streamanalytics"

// AvroSerialization describes how data from an input is serialized or how data is serialized when written
// to an output in Avro format.
type AvroSerialization struct {
	// Properties - The properties that are associated with the Avro serialization type. Required on PUT (CreateOrReplace) requests.
	Properties interface{} `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeSerialization', 'TypeAvro', 'TypeJSON', 'TypeCsv', 'TypeParquet'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroSerialization.
func (as AvroSerialization) MarshalJSON() ([]byte, error) {
	as.Type = TypeAvro
	objectMap := make(map[string]interface{})
	if as.Properties != nil {
		objectMap["properties"] = as.Properties
	}
	if as.Type != "" {
		objectMap["type"] = as.Type
	}
	return json.Marshal(objectMap)
}

// AsAvroSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return &as, true
}

// AsJSONSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return nil, false
}

// AsCsvSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return nil, false
}

// AsParquetSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsParquetSerialization() (*ParquetSerialization, bool) {
	return nil, false
}

// AsSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsSerialization() (*Serialization, bool) {
	return nil, false
}

// AsBasicSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsBasicSerialization() (BasicSerialization, bool) {
	return &as, true
}

// AzureDataLakeStoreOutputDataSource describes an Azure Data Lake Store output data source.
type AzureDataLakeStoreOutputDataSource struct {
	// AzureDataLakeStoreOutputDataSourceProperties - The properties that are associated with an Azure Data Lake Store output. Required on PUT (CreateOrReplace) requests.
	*AzureDataLakeStoreOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) MarshalJSON() ([]byte, error) {
	adlsods.Type = TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts
	objectMap := make(map[string]interface{})
	if adlsods.AzureDataLakeStoreOutputDataSourceProperties != nil {
		objectMap["properties"] = adlsods.AzureDataLakeStoreOutputDataSourceProperties
	}
	if adlsods.Type != "" {
		objectMap["type"] = adlsods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return &adlsods, true
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &adlsods, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreOutputDataSource struct.
func (adlsods *AzureDataLakeStoreOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureDataLakeStoreOutputDataSourceProperties AzureDataLakeStoreOutputDataSourceProperties
				err = json.Unmarshal(*v, &azureDataLakeStoreOutputDataSourceProperties)
				if err != nil {
					return err
				}
				adlsods.AzureDataLakeStoreOutputDataSourceProperties = &azureDataLakeStoreOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsods.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreOutputDataSourceProperties the properties that are associated with an Azure Data Lake
// Store.
type AzureDataLakeStoreOutputDataSourceProperties struct {
	// AccountName - The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`
	// TenantID - The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
	TenantID *string `json:"tenantId,omitempty"`
	// FilePathPrefix - The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
	FilePathPrefix *string `json:"filePathPrefix,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
	// RefreshToken - A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// TokenUserPrincipalName - The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
	// TokenUserDisplayName - The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserDisplayName *string `json:"tokenUserDisplayName,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBinding the binding to an Azure Machine Learning web service.
type AzureMachineLearningWebServiceFunctionBinding struct {
	// AzureMachineLearningWebServiceFunctionBindingProperties - The binding properties associated with an Azure Machine learning web service.
	*AzureMachineLearningWebServiceFunctionBindingProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicFunctionBindingTypeFunctionBinding', 'TypeBasicFunctionBindingTypeMicrosoftStreamAnalyticsJavascriptUdf', 'TypeBasicFunctionBindingTypeMicrosoftMachineLearningWebService'
	Type TypeBasicFunctionBinding `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) MarshalJSON() ([]byte, error) {
	amlwsfb.Type = TypeBasicFunctionBindingTypeMicrosoftMachineLearningWebService
	objectMap := make(map[string]interface{})
	if amlwsfb.AzureMachineLearningWebServiceFunctionBindingProperties != nil {
		objectMap["properties"] = amlwsfb.AzureMachineLearningWebServiceFunctionBindingProperties
	}
	if amlwsfb.Type != "" {
		objectMap["type"] = amlwsfb.Type
	}
	return json.Marshal(objectMap)
}

// AsJavaScriptFunctionBinding is the BasicFunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool) {
	return nil, false
}

// AsAzureMachineLearningWebServiceFunctionBinding is the BasicFunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool) {
	return &amlwsfb, true
}

// AsFunctionBinding is the BasicFunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsFunctionBinding() (*FunctionBinding, bool) {
	return nil, false
}

// AsBasicFunctionBinding is the BasicFunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsBasicFunctionBinding() (BasicFunctionBinding, bool) {
	return &amlwsfb, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMachineLearningWebServiceFunctionBinding struct.
func (amlwsfb *AzureMachineLearningWebServiceFunctionBinding) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureMachineLearningWebServiceFunctionBindingProperties AzureMachineLearningWebServiceFunctionBindingProperties
				err = json.Unmarshal(*v, &azureMachineLearningWebServiceFunctionBindingProperties)
				if err != nil {
					return err
				}
				amlwsfb.AzureMachineLearningWebServiceFunctionBindingProperties = &azureMachineLearningWebServiceFunctionBindingProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicFunctionBinding
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amlwsfb.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMachineLearningWebServiceFunctionBindingProperties the binding properties associated with an Azure
// Machine learning web service.
type AzureMachineLearningWebServiceFunctionBindingProperties struct {
	// Endpoint - The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
	Endpoint *string `json:"endpoint,omitempty"`
	// APIKey - The API key used to authenticate with Request-Response endpoint.
	APIKey *string `json:"apiKey,omitempty"`
	// Inputs - The inputs for the Azure Machine Learning web service endpoint.
	Inputs *AzureMachineLearningWebServiceInputs `json:"inputs,omitempty"`
	// Outputs - A list of outputs from the Azure Machine Learning web service endpoint execution.
	Outputs *[]AzureMachineLearningWebServiceOutputColumn `json:"outputs,omitempty"`
	// BatchSize - Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
	BatchSize *int32 `json:"batchSize,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBindingRetrievalProperties the binding retrieval properties
// associated with an Azure Machine learning web service.
type AzureMachineLearningWebServiceFunctionBindingRetrievalProperties struct {
	// ExecuteEndpoint - The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
	ExecuteEndpoint *string `json:"executeEndpoint,omitempty"`
	// UdfType - The function type. Possible values include: 'UdfTypeScalar'
	UdfType UdfType `json:"udfType,omitempty"`
}

// AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters the parameters needed to
// retrieve the default function definition for an Azure Machine Learning web service function.
type AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters struct {
	// AzureMachineLearningWebServiceFunctionBindingRetrievalProperties - The binding retrieval properties associated with an Azure Machine learning web service.
	*AzureMachineLearningWebServiceFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
	// BindingType - Possible values include: 'BindingTypeFunctionRetrieveDefaultDefinitionParameters', 'BindingTypeMicrosoftMachineLearningWebService', 'BindingTypeMicrosoftStreamAnalyticsJavascriptUdf'
	BindingType BindingType `json:"bindingType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	amlwsfrddp.BindingType = BindingTypeMicrosoftMachineLearningWebService
	objectMap := make(map[string]interface{})
	if amlwsfrddp.AzureMachineLearningWebServiceFunctionBindingRetrievalProperties != nil {
		objectMap["bindingRetrievalProperties"] = amlwsfrddp.AzureMachineLearningWebServiceFunctionBindingRetrievalProperties
	}
	if amlwsfrddp.BindingType != "" {
		objectMap["bindingType"] = amlwsfrddp.BindingType
	}
	return json.Marshal(objectMap)
}

// AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &amlwsfrddp, true
}

// AsJavaScriptFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsFunctionRetrieveDefaultDefinitionParameters() (*FunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsBasicFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsBasicFunctionRetrieveDefaultDefinitionParameters() (BasicFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &amlwsfrddp, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters struct.
func (amlwsfrddp *AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bindingRetrievalProperties":
			if v != nil {
				var azureMachineLearningWebServiceFunctionBindingRetrievalProperties AzureMachineLearningWebServiceFunctionBindingRetrievalProperties
				err = json.Unmarshal(*v, &azureMachineLearningWebServiceFunctionBindingRetrievalProperties)
				if err != nil {
					return err
				}
				amlwsfrddp.AzureMachineLearningWebServiceFunctionBindingRetrievalProperties = &azureMachineLearningWebServiceFunctionBindingRetrievalProperties
			}
		case "bindingType":
			if v != nil {
				var bindingType BindingType
				err = json.Unmarshal(*v, &bindingType)
				if err != nil {
					return err
				}
				amlwsfrddp.BindingType = bindingType
			}
		}
	}

	return nil
}

// AzureMachineLearningWebServiceInputColumn describes an input column for the Azure Machine Learning web
// service endpoint.
type AzureMachineLearningWebServiceInputColumn struct {
	// Name - The name of the input column.
	Name *string `json:"name,omitempty"`
	// DataType - The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
	DataType *string `json:"dataType,omitempty"`
	// MapTo - The zero based index of the function parameter this input maps to.
	MapTo *int32 `json:"mapTo,omitempty"`
}

// AzureMachineLearningWebServiceInputs the inputs for the Azure Machine Learning web service endpoint.
type AzureMachineLearningWebServiceInputs struct {
	// Name - The name of the input. This is the name provided while authoring the endpoint.
	Name *string `json:"name,omitempty"`
	// ColumnNames - A list of input columns for the Azure Machine Learning web service endpoint.
	ColumnNames *[]AzureMachineLearningWebServiceInputColumn `json:"columnNames,omitempty"`
}

// AzureMachineLearningWebServiceOutputColumn describes an output column for the Azure Machine Learning web
// service endpoint.
type AzureMachineLearningWebServiceOutputColumn struct {
	// Name - The name of the output column.
	Name *string `json:"name,omitempty"`
	// DataType - The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
	DataType *string `json:"dataType,omitempty"`
}

// AzureSQLDatabaseDataSourceProperties the properties that are associated with an Azure SQL database data
// source.
type AzureSQLDatabaseDataSourceProperties struct {
	// Server - The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`
	// Database - The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`
	// User - The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
	// Password - The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`
	// Table - The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
	// MaxBatchCount - Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
	MaxBatchCount *float64 `json:"maxBatchCount,omitempty"`
	// MaxWriterCount - Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
	MaxWriterCount *float64 `json:"maxWriterCount,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
}

// AzureSQLDatabaseOutputDataSource describes an Azure SQL database output data source.
type AzureSQLDatabaseOutputDataSource struct {
	// AzureSQLDatabaseOutputDataSourceProperties - The properties that are associated with an Azure SQL database output. Required on PUT (CreateOrReplace) requests.
	*AzureSQLDatabaseOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) MarshalJSON() ([]byte, error) {
	asdods.Type = TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase
	objectMap := make(map[string]interface{})
	if asdods.AzureSQLDatabaseOutputDataSourceProperties != nil {
		objectMap["properties"] = asdods.AzureSQLDatabaseOutputDataSourceProperties
	}
	if asdods.Type != "" {
		objectMap["type"] = asdods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return &asdods, true
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &asdods, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDatabaseOutputDataSource struct.
func (asdods *AzureSQLDatabaseOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureSQLDatabaseOutputDataSourceProperties AzureSQLDatabaseOutputDataSourceProperties
				err = json.Unmarshal(*v, &azureSQLDatabaseOutputDataSourceProperties)
				if err != nil {
					return err
				}
				asdods.AzureSQLDatabaseOutputDataSourceProperties = &azureSQLDatabaseOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asdods.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSQLDatabaseOutputDataSourceProperties the properties that are associated with an Azure SQL database
// output.
type AzureSQLDatabaseOutputDataSourceProperties struct {
	// Server - The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`
	// Database - The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`
	// User - The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
	// Password - The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`
	// Table - The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
	// MaxBatchCount - Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
	MaxBatchCount *float64 `json:"maxBatchCount,omitempty"`
	// MaxWriterCount - Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
	MaxWriterCount *float64 `json:"maxWriterCount,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
}

// AzureSQLReferenceInputDataSource describes an Azure SQL database reference input data source.
type AzureSQLReferenceInputDataSource struct {
	// AzureSQLReferenceInputDataSourceProperties - The properties that are associated with SQL DB input containing reference data. Required on PUT (CreateOrReplace) requests.
	*AzureSQLReferenceInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource', 'TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicReferenceInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLReferenceInputDataSource.
func (asrids AzureSQLReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	asrids.Type = TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase
	objectMap := make(map[string]interface{})
	if asrids.AzureSQLReferenceInputDataSourceProperties != nil {
		objectMap["properties"] = asrids.AzureSQLReferenceInputDataSourceProperties
	}
	if asrids.Type != "" {
		objectMap["type"] = asrids.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureSQLReferenceInputDataSource is the BasicReferenceInputDataSource implementation for AzureSQLReferenceInputDataSource.
func (asrids AzureSQLReferenceInputDataSource) AsAzureSQLReferenceInputDataSource() (*AzureSQLReferenceInputDataSource, bool) {
	return &asrids, true
}

// AsBlobReferenceInputDataSource is the BasicReferenceInputDataSource implementation for AzureSQLReferenceInputDataSource.
func (asrids AzureSQLReferenceInputDataSource) AsBlobReferenceInputDataSource() (*BlobReferenceInputDataSource, bool) {
	return nil, false
}

// AsReferenceInputDataSource is the BasicReferenceInputDataSource implementation for AzureSQLReferenceInputDataSource.
func (asrids AzureSQLReferenceInputDataSource) AsReferenceInputDataSource() (*ReferenceInputDataSource, bool) {
	return nil, false
}

// AsBasicReferenceInputDataSource is the BasicReferenceInputDataSource implementation for AzureSQLReferenceInputDataSource.
func (asrids AzureSQLReferenceInputDataSource) AsBasicReferenceInputDataSource() (BasicReferenceInputDataSource, bool) {
	return &asrids, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLReferenceInputDataSource struct.
func (asrids *AzureSQLReferenceInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureSQLReferenceInputDataSourceProperties AzureSQLReferenceInputDataSourceProperties
				err = json.Unmarshal(*v, &azureSQLReferenceInputDataSourceProperties)
				if err != nil {
					return err
				}
				asrids.AzureSQLReferenceInputDataSourceProperties = &azureSQLReferenceInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicReferenceInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asrids.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSQLReferenceInputDataSourceProperties the properties that are associated with SQL DB input
// containing reference data. Required on PUT (CreateOrReplace) requests.
type AzureSQLReferenceInputDataSourceProperties struct {
	// Server - This element is associated with the datasource element. This is the name of the server that contains the database that will be written to.
	Server *string `json:"server,omitempty"`
	// Database - This element is associated with the datasource element. This is the name of the database that output will be written to.
	Database *string `json:"database,omitempty"`
	// User - This element is associated with the datasource element. This is the user name that will be used to connect to the SQL Database instance.
	User *string `json:"user,omitempty"`
	// Password - This element is associated with the datasource element. This is the password that will be used to connect to the SQL Database instance.
	Password *string `json:"password,omitempty"`
	// Table - This element is associated with the datasource element. The name of the table in the Azure SQL database..
	Table *string `json:"table,omitempty"`
	// RefreshType - Indicates the type of data refresh option. Possible values include: 'RefreshTypeStatic', 'RefreshTypeRefreshPeriodicallyWithFull', 'RefreshTypeRefreshPeriodicallyWithDelta'
	RefreshType RefreshType `json:"refreshType,omitempty"`
	// RefreshRate - This element is associated with the datasource element. This indicates how frequently the data will be fetched from the database. It is of DateTime format.
	RefreshRate *string `json:"refreshRate,omitempty"`
	// FullSnapshotQuery - This element is associated with the datasource element. This query is used to fetch data from the sql database.
	FullSnapshotQuery *string `json:"fullSnapshotQuery,omitempty"`
	// DeltaSnapshotQuery - This element is associated with the datasource element. This query is used to fetch incremental changes from the SQL database. To use this option, we recommend using temporal tables in Azure SQL Database.
	DeltaSnapshotQuery *string `json:"deltaSnapshotQuery,omitempty"`
}

// AzureSynapseDataSourceProperties the properties that are associated with an Azure SQL database data
// source.
type AzureSynapseDataSourceProperties struct {
	// Server - The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`
	// Database - The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`
	// Table - The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
	// User - The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
	// Password - The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`
}

// AzureSynapseOutputDataSource describes an Azure Synapse output data source.
type AzureSynapseOutputDataSource struct {
	// AzureSynapseOutputDataSourceProperties - The properties that are associated with an Azure Synapse output. Required on PUT (CreateOrReplace) requests.
	*AzureSynapseOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) MarshalJSON() ([]byte, error) {
	asods.Type = TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse
	objectMap := make(map[string]interface{})
	if asods.AzureSynapseOutputDataSourceProperties != nil {
		objectMap["properties"] = asods.AzureSynapseOutputDataSourceProperties
	}
	if asods.Type != "" {
		objectMap["type"] = asods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return &asods, true
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for AzureSynapseOutputDataSource.
func (asods AzureSynapseOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &asods, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSynapseOutputDataSource struct.
func (asods *AzureSynapseOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureSynapseOutputDataSourceProperties AzureSynapseOutputDataSourceProperties
				err = json.Unmarshal(*v, &azureSynapseOutputDataSourceProperties)
				if err != nil {
					return err
				}
				asods.AzureSynapseOutputDataSourceProperties = &azureSynapseOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asods.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSynapseOutputDataSourceProperties the properties that are associated with an Azure Synapse output.
type AzureSynapseOutputDataSourceProperties struct {
	// Server - The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`
	// Database - The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`
	// Table - The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
	// User - The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
	// Password - The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`
}

// AzureTableOutputDataSource describes an Azure Table output data source.
type AzureTableOutputDataSource struct {
	// AzureTableOutputDataSourceProperties - The properties that are associated with an Azure Table output. Required on PUT (CreateOrReplace) requests.
	*AzureTableOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) MarshalJSON() ([]byte, error) {
	atods.Type = TypeBasicOutputDataSourceTypeMicrosoftStorageTable
	objectMap := make(map[string]interface{})
	if atods.AzureTableOutputDataSourceProperties != nil {
		objectMap["properties"] = atods.AzureTableOutputDataSourceProperties
	}
	if atods.Type != "" {
		objectMap["type"] = atods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return &atods, true
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &atods, true
}

// UnmarshalJSON is the custom unmarshaler for AzureTableOutputDataSource struct.
func (atods *AzureTableOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureTableOutputDataSourceProperties AzureTableOutputDataSourceProperties
				err = json.Unmarshal(*v, &azureTableOutputDataSourceProperties)
				if err != nil {
					return err
				}
				atods.AzureTableOutputDataSourceProperties = &azureTableOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atods.Type = typeVar
			}
		}
	}

	return nil
}

// AzureTableOutputDataSourceProperties the properties that are associated with an Azure Table output.
type AzureTableOutputDataSourceProperties struct {
	// AccountName - The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`
	// AccountKey - The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`
	// Table - The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
	// PartitionKey - This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
	PartitionKey *string `json:"partitionKey,omitempty"`
	// RowKey - This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
	RowKey *string `json:"rowKey,omitempty"`
	// ColumnsToRemove - If specified, each item in the array is the name of a column to remove (if present) from output event entities.
	ColumnsToRemove *[]string `json:"columnsToRemove,omitempty"`
	// BatchSize - The number of rows to write to the Azure Table at a time.
	BatchSize *int32 `json:"batchSize,omitempty"`
}

// BlobDataSourceProperties the properties that are associated with a blob data source.
type BlobDataSourceProperties struct {
	// StorageAccounts - A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Container - The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`
	// PathPattern - The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
	PathPattern *string `json:"pathPattern,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// BlobOutputDataSource describes a blob output data source.
type BlobOutputDataSource struct {
	// BlobOutputDataSourceProperties - The properties that are associated with a blob output. Required on PUT (CreateOrReplace) requests.
	*BlobOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobOutputDataSource.
func (bods BlobOutputDataSource) MarshalJSON() ([]byte, error) {
	bods.Type = TypeBasicOutputDataSourceTypeMicrosoftStorageBlob
	objectMap := make(map[string]interface{})
	if bods.BlobOutputDataSourceProperties != nil {
		objectMap["properties"] = bods.BlobOutputDataSourceProperties
	}
	if bods.Type != "" {
		objectMap["type"] = bods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return &bods, true
}

// AsOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &bods, true
}

// UnmarshalJSON is the custom unmarshaler for BlobOutputDataSource struct.
func (bods *BlobOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobOutputDataSourceProperties BlobOutputDataSourceProperties
				err = json.Unmarshal(*v, &blobOutputDataSourceProperties)
				if err != nil {
					return err
				}
				bods.BlobOutputDataSourceProperties = &blobOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bods.Type = typeVar
			}
		}
	}

	return nil
}

// BlobOutputDataSourceProperties the properties that are associated with a blob output.
type BlobOutputDataSourceProperties struct {
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
	// StorageAccounts - A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Container - The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`
	// PathPattern - The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
	PathPattern *string `json:"pathPattern,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// BlobReferenceInputDataSource describes a blob input data source that contains reference data.
type BlobReferenceInputDataSource struct {
	// BlobReferenceInputDataSourceProperties - The properties that are associated with a blob input containing reference data. Required on PUT (CreateOrReplace) requests.
	*BlobReferenceInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource', 'TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicReferenceInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	brids.Type = TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob
	objectMap := make(map[string]interface{})
	if brids.BlobReferenceInputDataSourceProperties != nil {
		objectMap["properties"] = brids.BlobReferenceInputDataSourceProperties
	}
	if brids.Type != "" {
		objectMap["type"] = brids.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureSQLReferenceInputDataSource is the BasicReferenceInputDataSource implementation for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) AsAzureSQLReferenceInputDataSource() (*AzureSQLReferenceInputDataSource, bool) {
	return nil, false
}

// AsBlobReferenceInputDataSource is the BasicReferenceInputDataSource implementation for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) AsBlobReferenceInputDataSource() (*BlobReferenceInputDataSource, bool) {
	return &brids, true
}

// AsReferenceInputDataSource is the BasicReferenceInputDataSource implementation for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) AsReferenceInputDataSource() (*ReferenceInputDataSource, bool) {
	return nil, false
}

// AsBasicReferenceInputDataSource is the BasicReferenceInputDataSource implementation for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) AsBasicReferenceInputDataSource() (BasicReferenceInputDataSource, bool) {
	return &brids, true
}

// UnmarshalJSON is the custom unmarshaler for BlobReferenceInputDataSource struct.
func (brids *BlobReferenceInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobReferenceInputDataSourceProperties BlobReferenceInputDataSourceProperties
				err = json.Unmarshal(*v, &blobReferenceInputDataSourceProperties)
				if err != nil {
					return err
				}
				brids.BlobReferenceInputDataSourceProperties = &blobReferenceInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicReferenceInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				brids.Type = typeVar
			}
		}
	}

	return nil
}

// BlobReferenceInputDataSourceProperties the properties that are associated with a blob input containing
// reference data.
type BlobReferenceInputDataSourceProperties struct {
	// StorageAccounts - A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Container - The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`
	// PathPattern - The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
	PathPattern *string `json:"pathPattern,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// BlobStreamInputDataSource describes a blob input data source that contains stream data.
type BlobStreamInputDataSource struct {
	// BlobStreamInputDataSourceProperties - The properties that are associated with a blob input containing stream data. Required on PUT (CreateOrReplace) requests.
	*BlobStreamInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicStreamInputDataSourceTypeStreamInputDataSource', 'TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs', 'TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicStreamInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) MarshalJSON() ([]byte, error) {
	bsids.Type = TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob
	objectMap := make(map[string]interface{})
	if bsids.BlobStreamInputDataSourceProperties != nil {
		objectMap["properties"] = bsids.BlobStreamInputDataSourceProperties
	}
	if bsids.Type != "" {
		objectMap["type"] = bsids.Type
	}
	return json.Marshal(objectMap)
}

// AsIoTHubStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubV2StreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsEventHubV2StreamInputDataSource() (*EventHubV2StreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return nil, false
}

// AsBlobStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return &bsids, true
}

// AsStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsStreamInputDataSource() (*StreamInputDataSource, bool) {
	return nil, false
}

// AsBasicStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsBasicStreamInputDataSource() (BasicStreamInputDataSource, bool) {
	return &bsids, true
}

// UnmarshalJSON is the custom unmarshaler for BlobStreamInputDataSource struct.
func (bsids *BlobStreamInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobStreamInputDataSourceProperties BlobStreamInputDataSourceProperties
				err = json.Unmarshal(*v, &blobStreamInputDataSourceProperties)
				if err != nil {
					return err
				}
				bsids.BlobStreamInputDataSourceProperties = &blobStreamInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStreamInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsids.Type = typeVar
			}
		}
	}

	return nil
}

// BlobStreamInputDataSourceProperties the properties that are associated with a blob input containing
// stream data.
type BlobStreamInputDataSourceProperties struct {
	// SourcePartitionCount - The partition count of the blob input data source. Range 1 - 256.
	SourcePartitionCount *int32 `json:"sourcePartitionCount,omitempty"`
	// StorageAccounts - A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Container - The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`
	// PathPattern - The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
	PathPattern *string `json:"pathPattern,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// Cluster a Stream Analytics Cluster object
type Cluster struct {
	autorest.Response `json:"-"`
	Sku               *ClusterSku `json:"sku,omitempty"`
	// Etag - READ-ONLY; The current entity tag for the cluster. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// ClusterProperties - The properties associated with a Stream Analytics cluster.
	*ClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ClusterSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterInfo the properties associated with a Stream Analytics cluster.
type ClusterInfo struct {
	// ID - The resource id of cluster.
	ID *string `json:"id,omitempty"`
}

// ClusterJob a streaming job.
type ClusterJob struct {
	// ID - READ-ONLY; Resource ID of the streaming job.
	ID *string `json:"id,omitempty"`
	// StreamingUnits - READ-ONLY; The number of streaming units that are used by the streaming job.
	StreamingUnits *int32 `json:"streamingUnits,omitempty"`
	// JobState - Possible values include: 'JobStateCreated', 'JobStateStarting', 'JobStateRunning', 'JobStateStopping', 'JobStateStopped', 'JobStateDeleting', 'JobStateFailed', 'JobStateDegraded', 'JobStateRestarting', 'JobStateScaling'
	JobState JobState `json:"jobState,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterJob.
func (cj ClusterJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cj.JobState != "" {
		objectMap["jobState"] = cj.JobState
	}
	return json.Marshal(objectMap)
}

// ClusterJobListResult a list of streaming jobs. Populated by a List operation.
type ClusterJobListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of streaming jobs.
	Value *[]ClusterJob `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to fetch the next set of streaming jobs.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterJobListResult.
func (cjlr ClusterJobListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ClusterJobListResultIterator provides access to a complete listing of ClusterJob values.
type ClusterJobListResultIterator struct {
	i    int
	page ClusterJobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterJobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterJobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterJobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterJobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterJobListResultIterator) Response() ClusterJobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterJobListResultIterator) Value() ClusterJob {
	if !iter.page.NotDone() {
		return ClusterJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterJobListResultIterator type.
func NewClusterJobListResultIterator(page ClusterJobListResultPage) ClusterJobListResultIterator {
	return ClusterJobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cjlr ClusterJobListResult) IsEmpty() bool {
	return cjlr.Value == nil || len(*cjlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cjlr ClusterJobListResult) hasNextLink() bool {
	return cjlr.NextLink != nil && len(*cjlr.NextLink) != 0
}

// clusterJobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjlr ClusterJobListResult) clusterJobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cjlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjlr.NextLink)))
}

// ClusterJobListResultPage contains a page of ClusterJob values.
type ClusterJobListResultPage struct {
	fn   func(context.Context, ClusterJobListResult) (ClusterJobListResult, error)
	cjlr ClusterJobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterJobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterJobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cjlr)
		if err != nil {
			return err
		}
		page.cjlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterJobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterJobListResultPage) NotDone() bool {
	return !page.cjlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterJobListResultPage) Response() ClusterJobListResult {
	return page.cjlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterJobListResultPage) Values() []ClusterJob {
	if page.cjlr.IsEmpty() {
		return nil
	}
	return *page.cjlr.Value
}

// Creates a new instance of the ClusterJobListResultPage type.
func NewClusterJobListResultPage(cur ClusterJobListResult, getNextPage func(context.Context, ClusterJobListResult) (ClusterJobListResult, error)) ClusterJobListResultPage {
	return ClusterJobListResultPage{
		fn:   getNextPage,
		cjlr: cur,
	}
}

// ClusterListResult a list of clusters populated by a 'list' operation.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of clusters.
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to fetch the next set of clusters.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterListResult.
func (clr ClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ClusterListResultIterator provides access to a complete listing of Cluster values.
type ClusterListResultIterator struct {
	i    int
	page ClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListResultIterator) Response() ClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListResultIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListResultIterator type.
func NewClusterListResultIterator(page ClusterListResultPage) ClusterListResultIterator {
	return ClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ClusterListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr ClusterListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// clusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ClusterListResult) clusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ClusterListResultPage contains a page of Cluster values.
type ClusterListResultPage struct {
	fn  func(context.Context, ClusterListResult) (ClusterListResult, error)
	clr ClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListResultPage) Response() ClusterListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListResultPage) Values() []Cluster {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ClusterListResultPage type.
func NewClusterListResultPage(cur ClusterListResult, getNextPage func(context.Context, ClusterListResult) (ClusterListResult, error)) ClusterListResultPage {
	return ClusterListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// ClusterProperties the properties associated with a Stream Analytics cluster.
type ClusterProperties struct {
	// CreatedDate - READ-ONLY; The date this cluster was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ClusterID - READ-ONLY; Unique identifier for the cluster.
	ClusterID *string `json:"clusterId,omitempty"`
	// ProvisioningState - Possible values include: 'ClusterProvisioningStateSucceeded', 'ClusterProvisioningStateFailed', 'ClusterProvisioningStateCanceled', 'ClusterProvisioningStateInProgress'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// CapacityAllocated - READ-ONLY; Represents the number of streaming units currently being used on the cluster.
	CapacityAllocated *int32 `json:"capacityAllocated,omitempty"`
	// CapacityAssigned - READ-ONLY; Represents the sum of the SUs of all streaming jobs associated with the cluster. If all of the jobs were running, this would be the capacity allocated.
	CapacityAssigned *int32 `json:"capacityAssigned,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ProvisioningState != "" {
		objectMap["provisioningState"] = cp.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateOrUpdateFuture.Result.
func (future *ClustersCreateOrUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.ClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.ClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.ClustersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClusterSku the SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT
// (CreateOrUpdate) requests.
type ClusterSku struct {
	// Name - Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests. Possible values include: 'ClusterSkuNameDefault'
	Name ClusterSkuName `json:"name,omitempty"`
	// Capacity - Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate) requests.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateFuture.Result.
func (future *ClustersUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Compression describes how input data is compressed
type Compression struct {
	// Type - Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests. Possible values include: 'CompressionTypeNone', 'CompressionTypeGZip', 'CompressionTypeDeflate'
	Type CompressionType `json:"type,omitempty"`
}

// CsvSerialization describes how data from an input is serialized or how data is serialized when written
// to an output in CSV format.
type CsvSerialization struct {
	// CsvSerializationProperties - The properties that are associated with the CSV serialization type. Required on PUT (CreateOrReplace) requests.
	*CsvSerializationProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeSerialization', 'TypeAvro', 'TypeJSON', 'TypeCsv', 'TypeParquet'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CsvSerialization.
func (cs CsvSerialization) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCsv
	objectMap := make(map[string]interface{})
	if cs.CsvSerializationProperties != nil {
		objectMap["properties"] = cs.CsvSerializationProperties
	}
	if cs.Type != "" {
		objectMap["type"] = cs.Type
	}
	return json.Marshal(objectMap)
}

// AsAvroSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return nil, false
}

// AsJSONSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return nil, false
}

// AsCsvSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return &cs, true
}

// AsParquetSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsParquetSerialization() (*ParquetSerialization, bool) {
	return nil, false
}

// AsSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsSerialization() (*Serialization, bool) {
	return nil, false
}

// AsBasicSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsBasicSerialization() (BasicSerialization, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for CsvSerialization struct.
func (cs *CsvSerialization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var csvSerializationProperties CsvSerializationProperties
				err = json.Unmarshal(*v, &csvSerializationProperties)
				if err != nil {
					return err
				}
				cs.CsvSerializationProperties = &csvSerializationProperties
			}
		case "type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = typeVar
			}
		}
	}

	return nil
}

// CsvSerializationProperties the properties that are associated with the CSV serialization type.
type CsvSerializationProperties struct {
	// FieldDelimiter - Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
	FieldDelimiter *string `json:"fieldDelimiter,omitempty"`
	// Encoding - Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests. Possible values include: 'EncodingUTF8'
	Encoding Encoding `json:"encoding,omitempty"`
}

// DiagnosticCondition condition applicable to the resource, or to the job overall, that warrant customer
// attention.
type DiagnosticCondition struct {
	// Since - READ-ONLY; The UTC timestamp of when the condition started. Customers should be able to find a corresponding event in the ops log around this time.
	Since *string `json:"since,omitempty"`
	// Code - READ-ONLY; The opaque diagnostic code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The human-readable message describing the condition in detail. Localized in the Accept-Language of the client request.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticCondition.
func (dc DiagnosticCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Diagnostics describes conditions applicable to the Input, Output, or the job overall, that warrant
// customer attention.
type Diagnostics struct {
	// Conditions - READ-ONLY; A collection of zero or more conditions applicable to the resource, or to the job overall, that warrant customer attention.
	Conditions *[]DiagnosticCondition `json:"conditions,omitempty"`
}

// MarshalJSON is the custom marshaler for Diagnostics.
func (d Diagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DocumentDbOutputDataSource describes a DocumentDB output data source.
type DocumentDbOutputDataSource struct {
	// DocumentDbOutputDataSourceProperties - The properties that are associated with a DocumentDB output. Required on PUT (CreateOrReplace) requests.
	*DocumentDbOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) MarshalJSON() ([]byte, error) {
	ddods.Type = TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB
	objectMap := make(map[string]interface{})
	if ddods.DocumentDbOutputDataSourceProperties != nil {
		objectMap["properties"] = ddods.DocumentDbOutputDataSourceProperties
	}
	if ddods.Type != "" {
		objectMap["type"] = ddods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return &ddods, true
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &ddods, true
}

// UnmarshalJSON is the custom unmarshaler for DocumentDbOutputDataSource struct.
func (ddods *DocumentDbOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var documentDbOutputDataSourceProperties DocumentDbOutputDataSourceProperties
				err = json.Unmarshal(*v, &documentDbOutputDataSourceProperties)
				if err != nil {
					return err
				}
				ddods.DocumentDbOutputDataSourceProperties = &documentDbOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ddods.Type = typeVar
			}
		}
	}

	return nil
}

// DocumentDbOutputDataSourceProperties the properties that are associated with a DocumentDB output.
type DocumentDbOutputDataSourceProperties struct {
	// AccountID - The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
	AccountID *string `json:"accountId,omitempty"`
	// AccountKey - The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`
	// Database - The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`
	// CollectionNamePattern - The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
	CollectionNamePattern *string `json:"collectionNamePattern,omitempty"`
	// PartitionKey - The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
	PartitionKey *string `json:"partitionKey,omitempty"`
	// DocumentID - The name of the field in output events used to specify the primary key which insert or update operations are based on.
	DocumentID *string `json:"documentId,omitempty"`
}

// Error common error representation.
type Error struct {
	// Error - Error definition properties.
	Error *ErrorError `json:"error,omitempty"`
}

// ErrorDetails common error details representation.
type ErrorDetails struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Target - Error target.
	Target *string `json:"target,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
}

// ErrorError error definition properties.
type ErrorError struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
	// Target - Error target.
	Target *string `json:"target,omitempty"`
	// Details - Error details.
	Details *[]ErrorDetails `json:"details,omitempty"`
}

// ErrorResponse describes the error that occurred.
type ErrorResponse struct {
	// Code - READ-ONLY; Error code associated with the error that occurred.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Describes the error in detail.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EventHubDataSourceProperties the common properties that are associated with Event Hub data sources.
type EventHubDataSourceProperties struct {
	// EventHubName - The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
}

// EventHubOutputDataSource describes an Event Hub output data source.
type EventHubOutputDataSource struct {
	// EventHubOutputDataSourceProperties - The properties that are associated with an Event Hub output. Required on PUT (CreateOrReplace) requests.
	*EventHubOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) MarshalJSON() ([]byte, error) {
	ehods.Type = TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub
	objectMap := make(map[string]interface{})
	if ehods.EventHubOutputDataSourceProperties != nil {
		objectMap["properties"] = ehods.EventHubOutputDataSourceProperties
	}
	if ehods.Type != "" {
		objectMap["type"] = ehods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return &ehods, true
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &ehods, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubOutputDataSource struct.
func (ehods *EventHubOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubOutputDataSourceProperties EventHubOutputDataSourceProperties
				err = json.Unmarshal(*v, &eventHubOutputDataSourceProperties)
				if err != nil {
					return err
				}
				ehods.EventHubOutputDataSourceProperties = &eventHubOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehods.Type = typeVar
			}
		}
	}

	return nil
}

// EventHubOutputDataSourceProperties the properties that are associated with an Event Hub output.
type EventHubOutputDataSourceProperties struct {
	// PartitionKey - The key/column that is used to determine to which partition to send event data.
	PartitionKey *string `json:"partitionKey,omitempty"`
	// PropertyColumns - The properties associated with this Event Hub output.
	PropertyColumns *[]string `json:"propertyColumns,omitempty"`
	// EventHubName - The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
}

// EventHubStreamInputDataSource describes an Event Hub input data source that contains stream data.
type EventHubStreamInputDataSource struct {
	// EventHubStreamInputDataSourceProperties - The properties that are associated with an Event Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	*EventHubStreamInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicStreamInputDataSourceTypeStreamInputDataSource', 'TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs', 'TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicStreamInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	ehsids.Type = TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub
	objectMap := make(map[string]interface{})
	if ehsids.EventHubStreamInputDataSourceProperties != nil {
		objectMap["properties"] = ehsids.EventHubStreamInputDataSourceProperties
	}
	if ehsids.Type != "" {
		objectMap["type"] = ehsids.Type
	}
	return json.Marshal(objectMap)
}

// AsIoTHubStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubV2StreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsEventHubV2StreamInputDataSource() (*EventHubV2StreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return &ehsids, true
}

// AsBlobStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return nil, false
}

// AsStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsStreamInputDataSource() (*StreamInputDataSource, bool) {
	return nil, false
}

// AsBasicStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsBasicStreamInputDataSource() (BasicStreamInputDataSource, bool) {
	return &ehsids, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubStreamInputDataSource struct.
func (ehsids *EventHubStreamInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubStreamInputDataSourceProperties EventHubStreamInputDataSourceProperties
				err = json.Unmarshal(*v, &eventHubStreamInputDataSourceProperties)
				if err != nil {
					return err
				}
				ehsids.EventHubStreamInputDataSourceProperties = &eventHubStreamInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStreamInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehsids.Type = typeVar
			}
		}
	}

	return nil
}

// EventHubStreamInputDataSourceProperties the properties that are associated with a Event Hub input
// containing stream data.
type EventHubStreamInputDataSourceProperties struct {
	// ConsumerGroupName - The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// EventHubName - The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
}

// EventHubV2OutputDataSource describes an Event Hub output data source.
type EventHubV2OutputDataSource struct {
	// EventHubOutputDataSourceProperties - The properties that are associated with an Event Hub output. Required on PUT (CreateOrReplace) requests.
	*EventHubOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) MarshalJSON() ([]byte, error) {
	ehvods.Type = TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub
	objectMap := make(map[string]interface{})
	if ehvods.EventHubOutputDataSourceProperties != nil {
		objectMap["properties"] = ehvods.EventHubOutputDataSourceProperties
	}
	if ehvods.Type != "" {
		objectMap["type"] = ehvods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return &ehvods, true
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for EventHubV2OutputDataSource.
func (ehvods EventHubV2OutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &ehvods, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubV2OutputDataSource struct.
func (ehvods *EventHubV2OutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubOutputDataSourceProperties EventHubOutputDataSourceProperties
				err = json.Unmarshal(*v, &eventHubOutputDataSourceProperties)
				if err != nil {
					return err
				}
				ehvods.EventHubOutputDataSourceProperties = &eventHubOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehvods.Type = typeVar
			}
		}
	}

	return nil
}

// EventHubV2StreamInputDataSource describes an Event Hub input data source that contains stream data.
type EventHubV2StreamInputDataSource struct {
	// EventHubStreamInputDataSourceProperties - The properties that are associated with an Event Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	*EventHubStreamInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicStreamInputDataSourceTypeStreamInputDataSource', 'TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs', 'TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicStreamInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubV2StreamInputDataSource.
func (ehvsids EventHubV2StreamInputDataSource) MarshalJSON() ([]byte, error) {
	ehvsids.Type = TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub
	objectMap := make(map[string]interface{})
	if ehvsids.EventHubStreamInputDataSourceProperties != nil {
		objectMap["properties"] = ehvsids.EventHubStreamInputDataSourceProperties
	}
	if ehvsids.Type != "" {
		objectMap["type"] = ehvsids.Type
	}
	return json.Marshal(objectMap)
}

// AsIoTHubStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubV2StreamInputDataSource.
func (ehvsids EventHubV2StreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubV2StreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubV2StreamInputDataSource.
func (ehvsids EventHubV2StreamInputDataSource) AsEventHubV2StreamInputDataSource() (*EventHubV2StreamInputDataSource, bool) {
	return &ehvsids, true
}

// AsEventHubStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubV2StreamInputDataSource.
func (ehvsids EventHubV2StreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return nil, false
}

// AsBlobStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubV2StreamInputDataSource.
func (ehvsids EventHubV2StreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return nil, false
}

// AsStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubV2StreamInputDataSource.
func (ehvsids EventHubV2StreamInputDataSource) AsStreamInputDataSource() (*StreamInputDataSource, bool) {
	return nil, false
}

// AsBasicStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubV2StreamInputDataSource.
func (ehvsids EventHubV2StreamInputDataSource) AsBasicStreamInputDataSource() (BasicStreamInputDataSource, bool) {
	return &ehvsids, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubV2StreamInputDataSource struct.
func (ehvsids *EventHubV2StreamInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubStreamInputDataSourceProperties EventHubStreamInputDataSourceProperties
				err = json.Unmarshal(*v, &eventHubStreamInputDataSourceProperties)
				if err != nil {
					return err
				}
				ehvsids.EventHubStreamInputDataSourceProperties = &eventHubStreamInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStreamInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehvsids.Type = typeVar
			}
		}
	}

	return nil
}

// Function a function object, containing all information associated with the named function. All functions
// are contained under a streaming job.
type Function struct {
	autorest.Response `json:"-"`
	// Properties - The properties that are associated with a function.
	Properties BasicFunctionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Function.
func (f Function) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = f.Properties
	if f.Name != nil {
		objectMap["name"] = f.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Function struct.
func (f *Function) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicFunctionProperties(*v)
				if err != nil {
					return err
				}
				f.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				f.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				f.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicFunctionBinding the physical binding of the function. For example, in the Azure Machine Learning web service’s
// case, this describes the endpoint.
type BasicFunctionBinding interface {
	AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool)
	AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool)
	AsFunctionBinding() (*FunctionBinding, bool)
}

// FunctionBinding the physical binding of the function. For example, in the Azure Machine Learning web
// service’s case, this describes the endpoint.
type FunctionBinding struct {
	// Type - Possible values include: 'TypeBasicFunctionBindingTypeFunctionBinding', 'TypeBasicFunctionBindingTypeMicrosoftStreamAnalyticsJavascriptUdf', 'TypeBasicFunctionBindingTypeMicrosoftMachineLearningWebService'
	Type TypeBasicFunctionBinding `json:"type,omitempty"`
}

func unmarshalBasicFunctionBinding(body []byte) (BasicFunctionBinding, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicFunctionBindingTypeMicrosoftStreamAnalyticsJavascriptUdf):
		var jsfb JavaScriptFunctionBinding
		err := json.Unmarshal(body, &jsfb)
		return jsfb, err
	case string(TypeBasicFunctionBindingTypeMicrosoftMachineLearningWebService):
		var amlwsfb AzureMachineLearningWebServiceFunctionBinding
		err := json.Unmarshal(body, &amlwsfb)
		return amlwsfb, err
	default:
		var fb FunctionBinding
		err := json.Unmarshal(body, &fb)
		return fb, err
	}
}
func unmarshalBasicFunctionBindingArray(body []byte) ([]BasicFunctionBinding, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fbArray := make([]BasicFunctionBinding, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fb, err := unmarshalBasicFunctionBinding(*rawMessage)
		if err != nil {
			return nil, err
		}
		fbArray[index] = fb
	}
	return fbArray, nil
}

// MarshalJSON is the custom marshaler for FunctionBinding.
func (fb FunctionBinding) MarshalJSON() ([]byte, error) {
	fb.Type = TypeBasicFunctionBindingTypeFunctionBinding
	objectMap := make(map[string]interface{})
	if fb.Type != "" {
		objectMap["type"] = fb.Type
	}
	return json.Marshal(objectMap)
}

// AsJavaScriptFunctionBinding is the BasicFunctionBinding implementation for FunctionBinding.
func (fb FunctionBinding) AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool) {
	return nil, false
}

// AsAzureMachineLearningWebServiceFunctionBinding is the BasicFunctionBinding implementation for FunctionBinding.
func (fb FunctionBinding) AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool) {
	return nil, false
}

// AsFunctionBinding is the BasicFunctionBinding implementation for FunctionBinding.
func (fb FunctionBinding) AsFunctionBinding() (*FunctionBinding, bool) {
	return &fb, true
}

// AsBasicFunctionBinding is the BasicFunctionBinding implementation for FunctionBinding.
func (fb FunctionBinding) AsBasicFunctionBinding() (BasicFunctionBinding, bool) {
	return &fb, true
}

// FunctionInput describes one input parameter of a function.
type FunctionInput struct {
	// DataType - The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
	DataType *string `json:"dataType,omitempty"`
	// IsConfigurationParameter - A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
	IsConfigurationParameter *bool `json:"isConfigurationParameter,omitempty"`
}

// FunctionListResult object containing a list of functions under a streaming job.
type FunctionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of functions under a streaming job. Populated by a 'List' operation.
	Value *[]Function `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FunctionListResult.
func (flr FunctionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FunctionListResultIterator provides access to a complete listing of Function values.
type FunctionListResultIterator struct {
	i    int
	page FunctionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FunctionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FunctionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FunctionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FunctionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FunctionListResultIterator) Response() FunctionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FunctionListResultIterator) Value() Function {
	if !iter.page.NotDone() {
		return Function{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FunctionListResultIterator type.
func NewFunctionListResultIterator(page FunctionListResultPage) FunctionListResultIterator {
	return FunctionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (flr FunctionListResult) IsEmpty() bool {
	return flr.Value == nil || len(*flr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (flr FunctionListResult) hasNextLink() bool {
	return flr.NextLink != nil && len(*flr.NextLink) != 0
}

// functionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (flr FunctionListResult) functionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !flr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(flr.NextLink)))
}

// FunctionListResultPage contains a page of Function values.
type FunctionListResultPage struct {
	fn  func(context.Context, FunctionListResult) (FunctionListResult, error)
	flr FunctionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FunctionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FunctionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.flr)
		if err != nil {
			return err
		}
		page.flr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FunctionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FunctionListResultPage) NotDone() bool {
	return !page.flr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FunctionListResultPage) Response() FunctionListResult {
	return page.flr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FunctionListResultPage) Values() []Function {
	if page.flr.IsEmpty() {
		return nil
	}
	return *page.flr.Value
}

// Creates a new instance of the FunctionListResultPage type.
func NewFunctionListResultPage(cur FunctionListResult, getNextPage func(context.Context, FunctionListResult) (FunctionListResult, error)) FunctionListResultPage {
	return FunctionListResultPage{
		fn:  getNextPage,
		flr: cur,
	}
}

// FunctionOutput describes the output of a function.
type FunctionOutput struct {
	// DataType - The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
	DataType *string `json:"dataType,omitempty"`
}

// BasicFunctionProperties the properties that are associated with a function.
type BasicFunctionProperties interface {
	AsScalarFunctionProperties() (*ScalarFunctionProperties, bool)
	AsFunctionProperties() (*FunctionProperties, bool)
}

// FunctionProperties the properties that are associated with a function.
type FunctionProperties struct {
	// Etag - READ-ONLY; The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Type - Possible values include: 'TypeBasicFunctionPropertiesTypeFunctionProperties', 'TypeBasicFunctionPropertiesTypeScalar'
	Type TypeBasicFunctionProperties `json:"type,omitempty"`
}

func unmarshalBasicFunctionProperties(body []byte) (BasicFunctionProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicFunctionPropertiesTypeScalar):
		var sfp ScalarFunctionProperties
		err := json.Unmarshal(body, &sfp)
		return sfp, err
	default:
		var fp FunctionProperties
		err := json.Unmarshal(body, &fp)
		return fp, err
	}
}
func unmarshalBasicFunctionPropertiesArray(body []byte) ([]BasicFunctionProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fpArray := make([]BasicFunctionProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fp, err := unmarshalBasicFunctionProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		fpArray[index] = fp
	}
	return fpArray, nil
}

// MarshalJSON is the custom marshaler for FunctionProperties.
func (fp FunctionProperties) MarshalJSON() ([]byte, error) {
	fp.Type = TypeBasicFunctionPropertiesTypeFunctionProperties
	objectMap := make(map[string]interface{})
	if fp.Type != "" {
		objectMap["type"] = fp.Type
	}
	return json.Marshal(objectMap)
}

// AsScalarFunctionProperties is the BasicFunctionProperties implementation for FunctionProperties.
func (fp FunctionProperties) AsScalarFunctionProperties() (*ScalarFunctionProperties, bool) {
	return nil, false
}

// AsFunctionProperties is the BasicFunctionProperties implementation for FunctionProperties.
func (fp FunctionProperties) AsFunctionProperties() (*FunctionProperties, bool) {
	return &fp, true
}

// AsBasicFunctionProperties is the BasicFunctionProperties implementation for FunctionProperties.
func (fp FunctionProperties) AsBasicFunctionProperties() (BasicFunctionProperties, bool) {
	return &fp, true
}

// BasicFunctionRetrieveDefaultDefinitionParameters parameters used to specify the type of function to retrieve the
// default definition for.
type BasicFunctionRetrieveDefaultDefinitionParameters interface {
	AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool)
	AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool)
	AsFunctionRetrieveDefaultDefinitionParameters() (*FunctionRetrieveDefaultDefinitionParameters, bool)
}

// FunctionRetrieveDefaultDefinitionParameters parameters used to specify the type of function to retrieve the
// default definition for.
type FunctionRetrieveDefaultDefinitionParameters struct {
	// BindingType - Possible values include: 'BindingTypeFunctionRetrieveDefaultDefinitionParameters', 'BindingTypeMicrosoftMachineLearningWebService', 'BindingTypeMicrosoftStreamAnalyticsJavascriptUdf'
	BindingType BindingType `json:"bindingType,omitempty"`
}

func unmarshalBasicFunctionRetrieveDefaultDefinitionParameters(body []byte) (BasicFunctionRetrieveDefaultDefinitionParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["bindingType"] {
	case string(BindingTypeMicrosoftMachineLearningWebService):
		var amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters
		err := json.Unmarshal(body, &amlwsfrddp)
		return amlwsfrddp, err
	case string(BindingTypeMicrosoftStreamAnalyticsJavascriptUdf):
		var jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters
		err := json.Unmarshal(body, &jsfrddp)
		return jsfrddp, err
	default:
		var frddp FunctionRetrieveDefaultDefinitionParameters
		err := json.Unmarshal(body, &frddp)
		return frddp, err
	}
}
func unmarshalBasicFunctionRetrieveDefaultDefinitionParametersArray(body []byte) ([]BasicFunctionRetrieveDefaultDefinitionParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	frddpArray := make([]BasicFunctionRetrieveDefaultDefinitionParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		frddp, err := unmarshalBasicFunctionRetrieveDefaultDefinitionParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		frddpArray[index] = frddp
	}
	return frddpArray, nil
}

// MarshalJSON is the custom marshaler for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	frddp.BindingType = BindingTypeFunctionRetrieveDefaultDefinitionParameters
	objectMap := make(map[string]interface{})
	if frddp.BindingType != "" {
		objectMap["bindingType"] = frddp.BindingType
	}
	return json.Marshal(objectMap)
}

// AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsJavaScriptFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) AsFunctionRetrieveDefaultDefinitionParameters() (*FunctionRetrieveDefaultDefinitionParameters, bool) {
	return &frddp, true
}

// AsBasicFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) AsBasicFunctionRetrieveDefaultDefinitionParameters() (BasicFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &frddp, true
}

// FunctionsTestFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FunctionsTestFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FunctionsClient) (ResourceTestStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FunctionsTestFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FunctionsTestFuture.Result.
func (future *FunctionsTestFuture) result(client FunctionsClient) (rts ResourceTestStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.FunctionsTestFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rts.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.FunctionsTestFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rts.Response.Response, err = future.GetResult(sender); err == nil && rts.Response.Response.StatusCode != http.StatusNoContent {
		rts, err = client.TestResponder(rts.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.FunctionsTestFuture", "Result", rts.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Identity describes how identity is verified
type Identity struct {
	// TenantID - The identity tenantId
	TenantID *string `json:"tenantId,omitempty"`
	// PrincipalID - The identity principal ID
	PrincipalID *string `json:"principalId,omitempty"`
	// Type - The identity type
	Type *string `json:"type,omitempty"`
}

// Input an input object, containing all information associated with the named input. All inputs are
// contained under a streaming job.
type Input struct {
	autorest.Response `json:"-"`
	// Properties - The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
	Properties BasicInputProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Input.
func (i Input) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = i.Properties
	if i.Name != nil {
		objectMap["name"] = i.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Input struct.
func (i *Input) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicInputProperties(*v)
				if err != nil {
					return err
				}
				i.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		}
	}

	return nil
}

// InputListResult object containing a list of inputs under a streaming job.
type InputListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of inputs under a streaming job. Populated by a 'List' operation.
	Value *[]Input `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InputListResult.
func (ilr InputListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InputListResultIterator provides access to a complete listing of Input values.
type InputListResultIterator struct {
	i    int
	page InputListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InputListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InputListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InputListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InputListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InputListResultIterator) Response() InputListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InputListResultIterator) Value() Input {
	if !iter.page.NotDone() {
		return Input{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InputListResultIterator type.
func NewInputListResultIterator(page InputListResultPage) InputListResultIterator {
	return InputListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InputListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilr InputListResult) hasNextLink() bool {
	return ilr.NextLink != nil && len(*ilr.NextLink) != 0
}

// inputListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InputListResult) inputListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InputListResultPage contains a page of Input values.
type InputListResultPage struct {
	fn  func(context.Context, InputListResult) (InputListResult, error)
	ilr InputListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InputListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InputListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilr)
		if err != nil {
			return err
		}
		page.ilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InputListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InputListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InputListResultPage) Response() InputListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InputListResultPage) Values() []Input {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InputListResultPage type.
func NewInputListResultPage(cur InputListResult, getNextPage func(context.Context, InputListResult) (InputListResult, error)) InputListResultPage {
	return InputListResultPage{
		fn:  getNextPage,
		ilr: cur,
	}
}

// BasicInputProperties the properties that are associated with an input.
type BasicInputProperties interface {
	AsReferenceInputProperties() (*ReferenceInputProperties, bool)
	AsStreamInputProperties() (*StreamInputProperties, bool)
	AsInputProperties() (*InputProperties, bool)
}

// InputProperties the properties that are associated with an input.
type InputProperties struct {
	// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
	Serialization BasicSerialization `json:"serialization,omitempty"`
	// Diagnostics - READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty"`
	// Etag - READ-ONLY; The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Compression - Describes how input data is compressed
	Compression *Compression `json:"compression,omitempty"`
	// PartitionKey - partitionKey Describes a key in the input data which is used for partitioning the input data
	PartitionKey *string `json:"partitionKey,omitempty"`
	// Type - Possible values include: 'TypeBasicInputPropertiesTypeInputProperties', 'TypeBasicInputPropertiesTypeReference', 'TypeBasicInputPropertiesTypeStream'
	Type TypeBasicInputProperties `json:"type,omitempty"`
}

func unmarshalBasicInputProperties(body []byte) (BasicInputProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicInputPropertiesTypeReference):
		var rip ReferenceInputProperties
		err := json.Unmarshal(body, &rip)
		return rip, err
	case string(TypeBasicInputPropertiesTypeStream):
		var sip StreamInputProperties
		err := json.Unmarshal(body, &sip)
		return sip, err
	default:
		var IP InputProperties
		err := json.Unmarshal(body, &IP)
		return IP, err
	}
}
func unmarshalBasicInputPropertiesArray(body []byte) ([]BasicInputProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	IPArray := make([]BasicInputProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		IP, err := unmarshalBasicInputProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		IPArray[index] = IP
	}
	return IPArray, nil
}

// MarshalJSON is the custom marshaler for InputProperties.
func (IP InputProperties) MarshalJSON() ([]byte, error) {
	IP.Type = TypeBasicInputPropertiesTypeInputProperties
	objectMap := make(map[string]interface{})
	objectMap["serialization"] = IP.Serialization
	if IP.Compression != nil {
		objectMap["compression"] = IP.Compression
	}
	if IP.PartitionKey != nil {
		objectMap["partitionKey"] = IP.PartitionKey
	}
	if IP.Type != "" {
		objectMap["type"] = IP.Type
	}
	return json.Marshal(objectMap)
}

// AsReferenceInputProperties is the BasicInputProperties implementation for InputProperties.
func (IP InputProperties) AsReferenceInputProperties() (*ReferenceInputProperties, bool) {
	return nil, false
}

// AsStreamInputProperties is the BasicInputProperties implementation for InputProperties.
func (IP InputProperties) AsStreamInputProperties() (*StreamInputProperties, bool) {
	return nil, false
}

// AsInputProperties is the BasicInputProperties implementation for InputProperties.
func (IP InputProperties) AsInputProperties() (*InputProperties, bool) {
	return &IP, true
}

// AsBasicInputProperties is the BasicInputProperties implementation for InputProperties.
func (IP InputProperties) AsBasicInputProperties() (BasicInputProperties, bool) {
	return &IP, true
}

// UnmarshalJSON is the custom unmarshaler for InputProperties struct.
func (IP *InputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "serialization":
			if v != nil {
				serialization, err := unmarshalBasicSerialization(*v)
				if err != nil {
					return err
				}
				IP.Serialization = serialization
			}
		case "diagnostics":
			if v != nil {
				var diagnostics Diagnostics
				err = json.Unmarshal(*v, &diagnostics)
				if err != nil {
					return err
				}
				IP.Diagnostics = &diagnostics
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				IP.Etag = &etag
			}
		case "compression":
			if v != nil {
				var compression Compression
				err = json.Unmarshal(*v, &compression)
				if err != nil {
					return err
				}
				IP.Compression = &compression
			}
		case "partitionKey":
			if v != nil {
				var partitionKey string
				err = json.Unmarshal(*v, &partitionKey)
				if err != nil {
					return err
				}
				IP.PartitionKey = &partitionKey
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicInputProperties
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = typeVar
			}
		}
	}

	return nil
}

// InputsTestFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type InputsTestFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InputsClient) (ResourceTestStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InputsTestFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InputsTestFuture.Result.
func (future *InputsTestFuture) result(client InputsClient) (rts ResourceTestStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.InputsTestFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rts.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.InputsTestFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rts.Response.Response, err = future.GetResult(sender); err == nil && rts.Response.Response.StatusCode != http.StatusNoContent {
		rts, err = client.TestResponder(rts.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.InputsTestFuture", "Result", rts.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IoTHubStreamInputDataSource describes an IoT Hub input data source that contains stream data.
type IoTHubStreamInputDataSource struct {
	// IoTHubStreamInputDataSourceProperties - The properties that are associated with an IoT Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	*IoTHubStreamInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicStreamInputDataSourceTypeStreamInputDataSource', 'TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs', 'TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicStreamInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	ithsids.Type = TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs
	objectMap := make(map[string]interface{})
	if ithsids.IoTHubStreamInputDataSourceProperties != nil {
		objectMap["properties"] = ithsids.IoTHubStreamInputDataSourceProperties
	}
	if ithsids.Type != "" {
		objectMap["type"] = ithsids.Type
	}
	return json.Marshal(objectMap)
}

// AsIoTHubStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return &ithsids, true
}

// AsEventHubV2StreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsEventHubV2StreamInputDataSource() (*EventHubV2StreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return nil, false
}

// AsBlobStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return nil, false
}

// AsStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsStreamInputDataSource() (*StreamInputDataSource, bool) {
	return nil, false
}

// AsBasicStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsBasicStreamInputDataSource() (BasicStreamInputDataSource, bool) {
	return &ithsids, true
}

// UnmarshalJSON is the custom unmarshaler for IoTHubStreamInputDataSource struct.
func (ithsids *IoTHubStreamInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTHubStreamInputDataSourceProperties IoTHubStreamInputDataSourceProperties
				err = json.Unmarshal(*v, &ioTHubStreamInputDataSourceProperties)
				if err != nil {
					return err
				}
				ithsids.IoTHubStreamInputDataSourceProperties = &ioTHubStreamInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStreamInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ithsids.Type = typeVar
			}
		}
	}

	return nil
}

// IoTHubStreamInputDataSourceProperties the properties that are associated with a IoT Hub input containing
// stream data.
type IoTHubStreamInputDataSourceProperties struct {
	// IotHubNamespace - The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
	IotHubNamespace *string `json:"iotHubNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
	// ConsumerGroupName - The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// Endpoint - The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
	Endpoint *string `json:"endpoint,omitempty"`
}

// JavaScriptFunctionBinding the binding to a JavaScript function.
type JavaScriptFunctionBinding struct {
	// JavaScriptFunctionBindingProperties - The binding properties associated with a JavaScript function.
	*JavaScriptFunctionBindingProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicFunctionBindingTypeFunctionBinding', 'TypeBasicFunctionBindingTypeMicrosoftStreamAnalyticsJavascriptUdf', 'TypeBasicFunctionBindingTypeMicrosoftMachineLearningWebService'
	Type TypeBasicFunctionBinding `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) MarshalJSON() ([]byte, error) {
	jsfb.Type = TypeBasicFunctionBindingTypeMicrosoftStreamAnalyticsJavascriptUdf
	objectMap := make(map[string]interface{})
	if jsfb.JavaScriptFunctionBindingProperties != nil {
		objectMap["properties"] = jsfb.JavaScriptFunctionBindingProperties
	}
	if jsfb.Type != "" {
		objectMap["type"] = jsfb.Type
	}
	return json.Marshal(objectMap)
}

// AsJavaScriptFunctionBinding is the BasicFunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool) {
	return &jsfb, true
}

// AsAzureMachineLearningWebServiceFunctionBinding is the BasicFunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool) {
	return nil, false
}

// AsFunctionBinding is the BasicFunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsFunctionBinding() (*FunctionBinding, bool) {
	return nil, false
}

// AsBasicFunctionBinding is the BasicFunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsBasicFunctionBinding() (BasicFunctionBinding, bool) {
	return &jsfb, true
}

// UnmarshalJSON is the custom unmarshaler for JavaScriptFunctionBinding struct.
func (jsfb *JavaScriptFunctionBinding) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var javaScriptFunctionBindingProperties JavaScriptFunctionBindingProperties
				err = json.Unmarshal(*v, &javaScriptFunctionBindingProperties)
				if err != nil {
					return err
				}
				jsfb.JavaScriptFunctionBindingProperties = &javaScriptFunctionBindingProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicFunctionBinding
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jsfb.Type = typeVar
			}
		}
	}

	return nil
}

// JavaScriptFunctionBindingProperties the binding properties associated with a JavaScript function.
type JavaScriptFunctionBindingProperties struct {
	// Script - The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
	Script *string `json:"script,omitempty"`
}

// JavaScriptFunctionBindingRetrievalProperties the binding retrieval properties associated with a
// JavaScript function.
type JavaScriptFunctionBindingRetrievalProperties struct {
	// Script - The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'.
	Script *string `json:"script,omitempty"`
	// UdfType - The function type. Possible values include: 'UdfTypeScalar'
	UdfType UdfType `json:"udfType,omitempty"`
}

// JavaScriptFunctionRetrieveDefaultDefinitionParameters the parameters needed to retrieve the default
// function definition for a JavaScript function.
type JavaScriptFunctionRetrieveDefaultDefinitionParameters struct {
	// JavaScriptFunctionBindingRetrievalProperties - The binding retrieval properties associated with a JavaScript function.
	*JavaScriptFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
	// BindingType - Possible values include: 'BindingTypeFunctionRetrieveDefaultDefinitionParameters', 'BindingTypeMicrosoftMachineLearningWebService', 'BindingTypeMicrosoftStreamAnalyticsJavascriptUdf'
	BindingType BindingType `json:"bindingType,omitempty"`
}

// MarshalJSON is the custom marshaler for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	jsfrddp.BindingType = BindingTypeMicrosoftStreamAnalyticsJavascriptUdf
	objectMap := make(map[string]interface{})
	if jsfrddp.JavaScriptFunctionBindingRetrievalProperties != nil {
		objectMap["bindingRetrievalProperties"] = jsfrddp.JavaScriptFunctionBindingRetrievalProperties
	}
	if jsfrddp.BindingType != "" {
		objectMap["bindingType"] = jsfrddp.BindingType
	}
	return json.Marshal(objectMap)
}

// AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsJavaScriptFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &jsfrddp, true
}

// AsFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsFunctionRetrieveDefaultDefinitionParameters() (*FunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsBasicFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsBasicFunctionRetrieveDefaultDefinitionParameters() (BasicFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &jsfrddp, true
}

// UnmarshalJSON is the custom unmarshaler for JavaScriptFunctionRetrieveDefaultDefinitionParameters struct.
func (jsfrddp *JavaScriptFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bindingRetrievalProperties":
			if v != nil {
				var javaScriptFunctionBindingRetrievalProperties JavaScriptFunctionBindingRetrievalProperties
				err = json.Unmarshal(*v, &javaScriptFunctionBindingRetrievalProperties)
				if err != nil {
					return err
				}
				jsfrddp.JavaScriptFunctionBindingRetrievalProperties = &javaScriptFunctionBindingRetrievalProperties
			}
		case "bindingType":
			if v != nil {
				var bindingType BindingType
				err = json.Unmarshal(*v, &bindingType)
				if err != nil {
					return err
				}
				jsfrddp.BindingType = bindingType
			}
		}
	}

	return nil
}

// JobStorageAccount the properties that are associated with an Azure Storage account with MSI
type JobStorageAccount struct {
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
	// AccountName - The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`
	// AccountKey - The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`
}

// JSONSerialization describes how data from an input is serialized or how data is serialized when written
// to an output in JSON format.
type JSONSerialization struct {
	// JSONSerializationProperties - The properties that are associated with the JSON serialization type. Required on PUT (CreateOrReplace) requests.
	*JSONSerializationProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeSerialization', 'TypeAvro', 'TypeJSON', 'TypeCsv', 'TypeParquet'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JSONSerialization.
func (js JSONSerialization) MarshalJSON() ([]byte, error) {
	js.Type = TypeJSON
	objectMap := make(map[string]interface{})
	if js.JSONSerializationProperties != nil {
		objectMap["properties"] = js.JSONSerializationProperties
	}
	if js.Type != "" {
		objectMap["type"] = js.Type
	}
	return json.Marshal(objectMap)
}

// AsAvroSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return nil, false
}

// AsJSONSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return &js, true
}

// AsCsvSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return nil, false
}

// AsParquetSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsParquetSerialization() (*ParquetSerialization, bool) {
	return nil, false
}

// AsSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsSerialization() (*Serialization, bool) {
	return nil, false
}

// AsBasicSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsBasicSerialization() (BasicSerialization, bool) {
	return &js, true
}

// UnmarshalJSON is the custom unmarshaler for JSONSerialization struct.
func (js *JSONSerialization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var JSONSerializationProperties JSONSerializationProperties
				err = json.Unmarshal(*v, &JSONSerializationProperties)
				if err != nil {
					return err
				}
				js.JSONSerializationProperties = &JSONSerializationProperties
			}
		case "type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				js.Type = typeVar
			}
		}
	}

	return nil
}

// JSONSerializationProperties the properties that are associated with the JSON serialization type.
type JSONSerializationProperties struct {
	// Encoding - Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests. Possible values include: 'EncodingUTF8'
	Encoding Encoding `json:"encoding,omitempty"`
	// Format - This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null. Possible values include: 'JSONOutputSerializationFormatLineSeparated', 'JSONOutputSerializationFormatArray'
	Format JSONOutputSerializationFormat `json:"format,omitempty"`
}

// OAuthBasedDataSourceProperties the properties that are associated with data sources that use OAuth as
// their authentication model.
type OAuthBasedDataSourceProperties struct {
	// RefreshToken - A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// TokenUserPrincipalName - The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
	// TokenUserDisplayName - The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserDisplayName *string `json:"tokenUserDisplayName,omitempty"`
}

// Operation a Stream Analytics REST API operation
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - READ-ONLY; Contains the localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	return json.Marshal(objectMap)
}

// OperationDisplay contains the localized display information for this particular operation / action.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult result of the request to list Stream Analytics operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Stream Analytics operations supported by the Microsoft.StreamAnalytics resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Output an output object, containing all information associated with the named output. All outputs are
// contained under a streaming job.
type Output struct {
	autorest.Response `json:"-"`
	// OutputProperties - The properties that are associated with an output. Required on PUT (CreateOrReplace) requests.
	*OutputProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Output.
func (o Output) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.OutputProperties != nil {
		objectMap["properties"] = o.OutputProperties
	}
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Output struct.
func (o *Output) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var outputProperties OutputProperties
				err = json.Unmarshal(*v, &outputProperties)
				if err != nil {
					return err
				}
				o.OutputProperties = &outputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicOutputDataSource describes the data source that output will be written to.
type BasicOutputDataSource interface {
	AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool)
	AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool)
	AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool)
	AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool)
	AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool)
	AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool)
	AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool)
	AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool)
	AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool)
	AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool)
	AsBlobOutputDataSource() (*BlobOutputDataSource, bool)
	AsOutputDataSource() (*OutputDataSource, bool)
}

// OutputDataSource describes the data source that output will be written to.
type OutputDataSource struct {
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

func unmarshalBasicOutputDataSource(body []byte) (BasicOutputDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts):
		var adlsods AzureDataLakeStoreOutputDataSource
		err := json.Unmarshal(body, &adlsods)
		return adlsods, err
	case string(TypeBasicOutputDataSourceTypePowerBI):
		var pbods PowerBIOutputDataSource
		err := json.Unmarshal(body, &pbods)
		return pbods, err
	case string(TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic):
		var sbtods ServiceBusTopicOutputDataSource
		err := json.Unmarshal(body, &sbtods)
		return sbtods, err
	case string(TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue):
		var sbqods ServiceBusQueueOutputDataSource
		err := json.Unmarshal(body, &sbqods)
		return sbqods, err
	case string(TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB):
		var ddods DocumentDbOutputDataSource
		err := json.Unmarshal(body, &ddods)
		return ddods, err
	case string(TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse):
		var asods AzureSynapseOutputDataSource
		err := json.Unmarshal(body, &asods)
		return asods, err
	case string(TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase):
		var asdods AzureSQLDatabaseOutputDataSource
		err := json.Unmarshal(body, &asdods)
		return asdods, err
	case string(TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub):
		var ehvods EventHubV2OutputDataSource
		err := json.Unmarshal(body, &ehvods)
		return ehvods, err
	case string(TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub):
		var ehods EventHubOutputDataSource
		err := json.Unmarshal(body, &ehods)
		return ehods, err
	case string(TypeBasicOutputDataSourceTypeMicrosoftStorageTable):
		var atods AzureTableOutputDataSource
		err := json.Unmarshal(body, &atods)
		return atods, err
	case string(TypeBasicOutputDataSourceTypeMicrosoftStorageBlob):
		var bods BlobOutputDataSource
		err := json.Unmarshal(body, &bods)
		return bods, err
	default:
		var ods OutputDataSource
		err := json.Unmarshal(body, &ods)
		return ods, err
	}
}
func unmarshalBasicOutputDataSourceArray(body []byte) ([]BasicOutputDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	odsArray := make([]BasicOutputDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ods, err := unmarshalBasicOutputDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		odsArray[index] = ods
	}
	return odsArray, nil
}

// MarshalJSON is the custom marshaler for OutputDataSource.
func (ods OutputDataSource) MarshalJSON() ([]byte, error) {
	ods.Type = TypeBasicOutputDataSourceTypeOutputDataSource
	objectMap := make(map[string]interface{})
	if ods.Type != "" {
		objectMap["type"] = ods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return &ods, true
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &ods, true
}

// OutputListResult object containing a list of outputs under a streaming job.
type OutputListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of outputs under a streaming job. Populated by a 'List' operation.
	Value *[]Output `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OutputListResult.
func (olr OutputListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OutputListResultIterator provides access to a complete listing of Output values.
type OutputListResultIterator struct {
	i    int
	page OutputListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OutputListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutputListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OutputListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OutputListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OutputListResultIterator) Response() OutputListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OutputListResultIterator) Value() Output {
	if !iter.page.NotDone() {
		return Output{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OutputListResultIterator type.
func NewOutputListResultIterator(page OutputListResultPage) OutputListResultIterator {
	return OutputListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OutputListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OutputListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// outputListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OutputListResult) outputListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OutputListResultPage contains a page of Output values.
type OutputListResultPage struct {
	fn  func(context.Context, OutputListResult) (OutputListResult, error)
	olr OutputListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OutputListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutputListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OutputListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OutputListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OutputListResultPage) Response() OutputListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OutputListResultPage) Values() []Output {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OutputListResultPage type.
func NewOutputListResultPage(cur OutputListResult, getNextPage func(context.Context, OutputListResult) (OutputListResult, error)) OutputListResultPage {
	return OutputListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OutputProperties the properties that are associated with an output.
type OutputProperties struct {
	// Datasource - Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
	Datasource BasicOutputDataSource `json:"datasource,omitempty"`
	// TimeWindow - The time frame for filtering Stream Analytics job outputs.
	TimeWindow *string `json:"timeWindow,omitempty"`
	// SizeWindow - The size window to constrain a Stream Analytics output to.
	SizeWindow *float64 `json:"sizeWindow,omitempty"`
	// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
	Serialization BasicSerialization `json:"serialization,omitempty"`
	// Diagnostics - READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty"`
	// Etag - READ-ONLY; The current entity tag for the output. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for OutputProperties.
func (op OutputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["datasource"] = op.Datasource
	if op.TimeWindow != nil {
		objectMap["timeWindow"] = op.TimeWindow
	}
	if op.SizeWindow != nil {
		objectMap["sizeWindow"] = op.SizeWindow
	}
	objectMap["serialization"] = op.Serialization
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OutputProperties struct.
func (op *OutputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "datasource":
			if v != nil {
				datasource, err := unmarshalBasicOutputDataSource(*v)
				if err != nil {
					return err
				}
				op.Datasource = datasource
			}
		case "timeWindow":
			if v != nil {
				var timeWindow string
				err = json.Unmarshal(*v, &timeWindow)
				if err != nil {
					return err
				}
				op.TimeWindow = &timeWindow
			}
		case "sizeWindow":
			if v != nil {
				var sizeWindow float64
				err = json.Unmarshal(*v, &sizeWindow)
				if err != nil {
					return err
				}
				op.SizeWindow = &sizeWindow
			}
		case "serialization":
			if v != nil {
				serialization, err := unmarshalBasicSerialization(*v)
				if err != nil {
					return err
				}
				op.Serialization = serialization
			}
		case "diagnostics":
			if v != nil {
				var diagnostics Diagnostics
				err = json.Unmarshal(*v, &diagnostics)
				if err != nil {
					return err
				}
				op.Diagnostics = &diagnostics
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				op.Etag = &etag
			}
		}
	}

	return nil
}

// OutputsTestFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type OutputsTestFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OutputsClient) (ResourceTestStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OutputsTestFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OutputsTestFuture.Result.
func (future *OutputsTestFuture) result(client OutputsClient) (rts ResourceTestStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.OutputsTestFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rts.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.OutputsTestFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rts.Response.Response, err = future.GetResult(sender); err == nil && rts.Response.Response.StatusCode != http.StatusNoContent {
		rts, err = client.TestResponder(rts.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.OutputsTestFuture", "Result", rts.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ParquetSerialization describes how data from an input is serialized or how data is serialized when
// written to an output in Parquet format.
type ParquetSerialization struct {
	// Properties - The properties that are associated with the Parquet serialization type. Required on PUT (CreateOrReplace) requests.
	Properties interface{} `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeSerialization', 'TypeAvro', 'TypeJSON', 'TypeCsv', 'TypeParquet'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ParquetSerialization.
func (ps ParquetSerialization) MarshalJSON() ([]byte, error) {
	ps.Type = TypeParquet
	objectMap := make(map[string]interface{})
	if ps.Properties != nil {
		objectMap["properties"] = ps.Properties
	}
	if ps.Type != "" {
		objectMap["type"] = ps.Type
	}
	return json.Marshal(objectMap)
}

// AsAvroSerialization is the BasicSerialization implementation for ParquetSerialization.
func (ps ParquetSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return nil, false
}

// AsJSONSerialization is the BasicSerialization implementation for ParquetSerialization.
func (ps ParquetSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return nil, false
}

// AsCsvSerialization is the BasicSerialization implementation for ParquetSerialization.
func (ps ParquetSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return nil, false
}

// AsParquetSerialization is the BasicSerialization implementation for ParquetSerialization.
func (ps ParquetSerialization) AsParquetSerialization() (*ParquetSerialization, bool) {
	return &ps, true
}

// AsSerialization is the BasicSerialization implementation for ParquetSerialization.
func (ps ParquetSerialization) AsSerialization() (*Serialization, bool) {
	return nil, false
}

// AsBasicSerialization is the BasicSerialization implementation for ParquetSerialization.
func (ps ParquetSerialization) AsBasicSerialization() (BasicSerialization, bool) {
	return &ps, true
}

// PowerBIOutputDataSource describes a Power BI output data source.
type PowerBIOutputDataSource struct {
	// PowerBIOutputDataSourceProperties - The properties that are associated with a Power BI output. Required on PUT (CreateOrReplace) requests.
	*PowerBIOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) MarshalJSON() ([]byte, error) {
	pbods.Type = TypeBasicOutputDataSourceTypePowerBI
	objectMap := make(map[string]interface{})
	if pbods.PowerBIOutputDataSourceProperties != nil {
		objectMap["properties"] = pbods.PowerBIOutputDataSourceProperties
	}
	if pbods.Type != "" {
		objectMap["type"] = pbods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return &pbods, true
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &pbods, true
}

// UnmarshalJSON is the custom unmarshaler for PowerBIOutputDataSource struct.
func (pbods *PowerBIOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var powerBIOutputDataSourceProperties PowerBIOutputDataSourceProperties
				err = json.Unmarshal(*v, &powerBIOutputDataSourceProperties)
				if err != nil {
					return err
				}
				pbods.PowerBIOutputDataSourceProperties = &powerBIOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pbods.Type = typeVar
			}
		}
	}

	return nil
}

// PowerBIOutputDataSourceProperties the properties that are associated with a Power BI output.
type PowerBIOutputDataSourceProperties struct {
	// Dataset - The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
	Dataset *string `json:"dataset,omitempty"`
	// Table - The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
	// GroupID - The ID of the Power BI group.
	GroupID *string `json:"groupId,omitempty"`
	// GroupName - The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
	GroupName *string `json:"groupName,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
	// RefreshToken - A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// TokenUserPrincipalName - The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
	// TokenUserDisplayName - The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserDisplayName *string `json:"tokenUserDisplayName,omitempty"`
}

// PrivateEndpoint complete information about the private endpoint.
type PrivateEndpoint struct {
	autorest.Response `json:"-"`
	// PrivateEndpointProperties - The properties associated with a private endpoint.
	*PrivateEndpointProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Unique opaque string (generally a GUID) that represents the metadata state of the resource (private endpoint) and changes whenever the resource is updated. Required on PUT (CreateOrUpdate) requests.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if peVar.PrivateEndpointProperties != nil {
		objectMap["properties"] = peVar.PrivateEndpointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpoint struct.
func (peVar *PrivateEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointProperties PrivateEndpointProperties
				err = json.Unmarshal(*v, &privateEndpointProperties)
				if err != nil {
					return err
				}
				peVar.PrivateEndpointProperties = &privateEndpointProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				peVar.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				peVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				peVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				peVar.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointListResult a list of private endpoints.
type PrivateEndpointListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of private endpoints.
	Value *[]PrivateEndpoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to fetch the next set of private endpoints.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointListResult.
func (pelr PrivateEndpointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointListResultIterator provides access to a complete listing of PrivateEndpoint values.
type PrivateEndpointListResultIterator struct {
	i    int
	page PrivateEndpointListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointListResultIterator) Response() PrivateEndpointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointListResultIterator) Value() PrivateEndpoint {
	if !iter.page.NotDone() {
		return PrivateEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointListResultIterator type.
func NewPrivateEndpointListResultIterator(page PrivateEndpointListResultPage) PrivateEndpointListResultIterator {
	return PrivateEndpointListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pelr PrivateEndpointListResult) IsEmpty() bool {
	return pelr.Value == nil || len(*pelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pelr PrivateEndpointListResult) hasNextLink() bool {
	return pelr.NextLink != nil && len(*pelr.NextLink) != 0
}

// privateEndpointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pelr PrivateEndpointListResult) privateEndpointListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pelr.NextLink)))
}

// PrivateEndpointListResultPage contains a page of PrivateEndpoint values.
type PrivateEndpointListResultPage struct {
	fn   func(context.Context, PrivateEndpointListResult) (PrivateEndpointListResult, error)
	pelr PrivateEndpointListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pelr)
		if err != nil {
			return err
		}
		page.pelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointListResultPage) NotDone() bool {
	return !page.pelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointListResultPage) Response() PrivateEndpointListResult {
	return page.pelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointListResultPage) Values() []PrivateEndpoint {
	if page.pelr.IsEmpty() {
		return nil
	}
	return *page.pelr.Value
}

// Creates a new instance of the PrivateEndpointListResultPage type.
func NewPrivateEndpointListResultPage(cur PrivateEndpointListResult, getNextPage func(context.Context, PrivateEndpointListResult) (PrivateEndpointListResult, error)) PrivateEndpointListResultPage {
	return PrivateEndpointListResultPage{
		fn:   getNextPage,
		pelr: cur,
	}
}

// PrivateEndpointProperties the properties associated with a private endpoint.
type PrivateEndpointProperties struct {
	// CreatedDate - READ-ONLY; The date when this private endpoint was created.
	CreatedDate *string `json:"createdDate,omitempty"`
	// ManualPrivateLinkServiceConnections - A list of connections to the remote resource. Immutable after it is set.
	ManualPrivateLinkServiceConnections *[]PrivateLinkServiceConnection `json:"manualPrivateLinkServiceConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointProperties.
func (pep PrivateEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pep.ManualPrivateLinkServiceConnections != nil {
		objectMap["manualPrivateLinkServiceConnections"] = pep.ManualPrivateLinkServiceConnections
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateEndpointsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointsDeleteFuture.Result.
func (future *PrivateEndpointsDeleteFuture) result(client PrivateEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.PrivateEndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.PrivateEndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkConnectionState a collection of read-only information about the state of the connection to
// the private remote resource.
type PrivateLinkConnectionState struct {
	// Status - READ-ONLY; Indicates whether the connection has been Approved/Rejected/Removed by the owner of the remote resource/service.
	Status *string `json:"status,omitempty"`
	// Description - READ-ONLY; The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkConnectionState.
func (plcs PrivateLinkConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnection a grouping of information about the connection to the remote resource.
type PrivateLinkServiceConnection struct {
	// PrivateLinkServiceConnectionProperties - Bag of properties defining a privatelinkServiceConnection.
	*PrivateLinkServiceConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnection.
func (plsc PrivateLinkServiceConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plsc.PrivateLinkServiceConnectionProperties != nil {
		objectMap["properties"] = plsc.PrivateLinkServiceConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkServiceConnection struct.
func (plsc *PrivateLinkServiceConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkServiceConnectionProperties PrivateLinkServiceConnectionProperties
				err = json.Unmarshal(*v, &privateLinkServiceConnectionProperties)
				if err != nil {
					return err
				}
				plsc.PrivateLinkServiceConnectionProperties = &privateLinkServiceConnectionProperties
			}
		}
	}

	return nil
}

// PrivateLinkServiceConnectionProperties bag of properties defining a privatelinkServiceConnection.
type PrivateLinkServiceConnectionProperties struct {
	// PrivateLinkServiceID - The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
	PrivateLinkServiceID *string `json:"privateLinkServiceId,omitempty"`
	// GroupIds - The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
	GroupIds *[]string `json:"groupIds,omitempty"`
	// RequestMessage - READ-ONLY; A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
	RequestMessage *string `json:"requestMessage,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of read-only information about the state of the connection to the private remote resource.
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnectionProperties.
func (plscp PrivateLinkServiceConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plscp.PrivateLinkServiceID != nil {
		objectMap["privateLinkServiceId"] = plscp.PrivateLinkServiceID
	}
	if plscp.GroupIds != nil {
		objectMap["groupIds"] = plscp.GroupIds
	}
	if plscp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = plscp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicReferenceInputDataSource describes an input data source that contains reference data.
type BasicReferenceInputDataSource interface {
	AsAzureSQLReferenceInputDataSource() (*AzureSQLReferenceInputDataSource, bool)
	AsBlobReferenceInputDataSource() (*BlobReferenceInputDataSource, bool)
	AsReferenceInputDataSource() (*ReferenceInputDataSource, bool)
}

// ReferenceInputDataSource describes an input data source that contains reference data.
type ReferenceInputDataSource struct {
	// Type - Possible values include: 'TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource', 'TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicReferenceInputDataSource `json:"type,omitempty"`
}

func unmarshalBasicReferenceInputDataSource(body []byte) (BasicReferenceInputDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase):
		var asrids AzureSQLReferenceInputDataSource
		err := json.Unmarshal(body, &asrids)
		return asrids, err
	case string(TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob):
		var brids BlobReferenceInputDataSource
		err := json.Unmarshal(body, &brids)
		return brids, err
	default:
		var rids ReferenceInputDataSource
		err := json.Unmarshal(body, &rids)
		return rids, err
	}
}
func unmarshalBasicReferenceInputDataSourceArray(body []byte) ([]BasicReferenceInputDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ridsArray := make([]BasicReferenceInputDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rids, err := unmarshalBasicReferenceInputDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		ridsArray[index] = rids
	}
	return ridsArray, nil
}

// MarshalJSON is the custom marshaler for ReferenceInputDataSource.
func (rids ReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	rids.Type = TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource
	objectMap := make(map[string]interface{})
	if rids.Type != "" {
		objectMap["type"] = rids.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureSQLReferenceInputDataSource is the BasicReferenceInputDataSource implementation for ReferenceInputDataSource.
func (rids ReferenceInputDataSource) AsAzureSQLReferenceInputDataSource() (*AzureSQLReferenceInputDataSource, bool) {
	return nil, false
}

// AsBlobReferenceInputDataSource is the BasicReferenceInputDataSource implementation for ReferenceInputDataSource.
func (rids ReferenceInputDataSource) AsBlobReferenceInputDataSource() (*BlobReferenceInputDataSource, bool) {
	return nil, false
}

// AsReferenceInputDataSource is the BasicReferenceInputDataSource implementation for ReferenceInputDataSource.
func (rids ReferenceInputDataSource) AsReferenceInputDataSource() (*ReferenceInputDataSource, bool) {
	return &rids, true
}

// AsBasicReferenceInputDataSource is the BasicReferenceInputDataSource implementation for ReferenceInputDataSource.
func (rids ReferenceInputDataSource) AsBasicReferenceInputDataSource() (BasicReferenceInputDataSource, bool) {
	return &rids, true
}

// ReferenceInputProperties the properties that are associated with an input containing reference data.
type ReferenceInputProperties struct {
	// Datasource - Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
	Datasource BasicReferenceInputDataSource `json:"datasource,omitempty"`
	// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
	Serialization BasicSerialization `json:"serialization,omitempty"`
	// Diagnostics - READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty"`
	// Etag - READ-ONLY; The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Compression - Describes how input data is compressed
	Compression *Compression `json:"compression,omitempty"`
	// PartitionKey - partitionKey Describes a key in the input data which is used for partitioning the input data
	PartitionKey *string `json:"partitionKey,omitempty"`
	// Type - Possible values include: 'TypeBasicInputPropertiesTypeInputProperties', 'TypeBasicInputPropertiesTypeReference', 'TypeBasicInputPropertiesTypeStream'
	Type TypeBasicInputProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReferenceInputProperties.
func (rip ReferenceInputProperties) MarshalJSON() ([]byte, error) {
	rip.Type = TypeBasicInputPropertiesTypeReference
	objectMap := make(map[string]interface{})
	objectMap["datasource"] = rip.Datasource
	objectMap["serialization"] = rip.Serialization
	if rip.Compression != nil {
		objectMap["compression"] = rip.Compression
	}
	if rip.PartitionKey != nil {
		objectMap["partitionKey"] = rip.PartitionKey
	}
	if rip.Type != "" {
		objectMap["type"] = rip.Type
	}
	return json.Marshal(objectMap)
}

// AsReferenceInputProperties is the BasicInputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsReferenceInputProperties() (*ReferenceInputProperties, bool) {
	return &rip, true
}

// AsStreamInputProperties is the BasicInputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsStreamInputProperties() (*StreamInputProperties, bool) {
	return nil, false
}

// AsInputProperties is the BasicInputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsInputProperties() (*InputProperties, bool) {
	return nil, false
}

// AsBasicInputProperties is the BasicInputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsBasicInputProperties() (BasicInputProperties, bool) {
	return &rip, true
}

// UnmarshalJSON is the custom unmarshaler for ReferenceInputProperties struct.
func (rip *ReferenceInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "datasource":
			if v != nil {
				datasource, err := unmarshalBasicReferenceInputDataSource(*v)
				if err != nil {
					return err
				}
				rip.Datasource = datasource
			}
		case "serialization":
			if v != nil {
				serialization, err := unmarshalBasicSerialization(*v)
				if err != nil {
					return err
				}
				rip.Serialization = serialization
			}
		case "diagnostics":
			if v != nil {
				var diagnostics Diagnostics
				err = json.Unmarshal(*v, &diagnostics)
				if err != nil {
					return err
				}
				rip.Diagnostics = &diagnostics
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rip.Etag = &etag
			}
		case "compression":
			if v != nil {
				var compression Compression
				err = json.Unmarshal(*v, &compression)
				if err != nil {
					return err
				}
				rip.Compression = &compression
			}
		case "partitionKey":
			if v != nil {
				var partitionKey string
				err = json.Unmarshal(*v, &partitionKey)
				if err != nil {
					return err
				}
				rip.PartitionKey = &partitionKey
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicInputProperties
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rip.Type = typeVar
			}
		}
	}

	return nil
}

// Resource the base resource definition
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceTestStatus describes the status of the test operation along with error information, if
// applicable.
type ResourceTestStatus struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; The status of the test operation.
	Status *string `json:"status,omitempty"`
	// Error - READ-ONLY; Describes the error that occurred.
	Error *ErrorResponse `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceTestStatus.
func (rts ResourceTestStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ScalarFunctionConfiguration describes the configuration of the scalar function.
type ScalarFunctionConfiguration struct {
	// Inputs - A list of inputs describing the parameters of the function.
	Inputs *[]FunctionInput `json:"inputs,omitempty"`
	// Output - The output of the function.
	Output *FunctionOutput `json:"output,omitempty"`
	// Binding - The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
	Binding BasicFunctionBinding `json:"binding,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ScalarFunctionConfiguration struct.
func (sfc *ScalarFunctionConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "inputs":
			if v != nil {
				var inputs []FunctionInput
				err = json.Unmarshal(*v, &inputs)
				if err != nil {
					return err
				}
				sfc.Inputs = &inputs
			}
		case "output":
			if v != nil {
				var output FunctionOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				sfc.Output = &output
			}
		case "binding":
			if v != nil {
				binding, err := unmarshalBasicFunctionBinding(*v)
				if err != nil {
					return err
				}
				sfc.Binding = binding
			}
		}
	}

	return nil
}

// ScalarFunctionProperties the properties that are associated with a scalar function.
type ScalarFunctionProperties struct {
	// ScalarFunctionConfiguration - Describes the configuration of the scalar function.
	*ScalarFunctionConfiguration `json:"properties,omitempty"`
	// Etag - READ-ONLY; The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Type - Possible values include: 'TypeBasicFunctionPropertiesTypeFunctionProperties', 'TypeBasicFunctionPropertiesTypeScalar'
	Type TypeBasicFunctionProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) MarshalJSON() ([]byte, error) {
	sfp.Type = TypeBasicFunctionPropertiesTypeScalar
	objectMap := make(map[string]interface{})
	if sfp.ScalarFunctionConfiguration != nil {
		objectMap["properties"] = sfp.ScalarFunctionConfiguration
	}
	if sfp.Type != "" {
		objectMap["type"] = sfp.Type
	}
	return json.Marshal(objectMap)
}

// AsScalarFunctionProperties is the BasicFunctionProperties implementation for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) AsScalarFunctionProperties() (*ScalarFunctionProperties, bool) {
	return &sfp, true
}

// AsFunctionProperties is the BasicFunctionProperties implementation for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) AsFunctionProperties() (*FunctionProperties, bool) {
	return nil, false
}

// AsBasicFunctionProperties is the BasicFunctionProperties implementation for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) AsBasicFunctionProperties() (BasicFunctionProperties, bool) {
	return &sfp, true
}

// UnmarshalJSON is the custom unmarshaler for ScalarFunctionProperties struct.
func (sfp *ScalarFunctionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scalarFunctionConfiguration ScalarFunctionConfiguration
				err = json.Unmarshal(*v, &scalarFunctionConfiguration)
				if err != nil {
					return err
				}
				sfp.ScalarFunctionConfiguration = &scalarFunctionConfiguration
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sfp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicFunctionProperties
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sfp.Type = typeVar
			}
		}
	}

	return nil
}

// ScaleStreamingJobParameters parameters supplied to the Scale Streaming Job operation.
type ScaleStreamingJobParameters struct {
	// StreamingUnits - Specifies the number of streaming units that the streaming job will scale to.
	StreamingUnits *int32 `json:"streamingUnits,omitempty"`
}

// BasicSerialization describes how data from an input is serialized or how data is serialized when written to an
// output.
type BasicSerialization interface {
	AsAvroSerialization() (*AvroSerialization, bool)
	AsJSONSerialization() (*JSONSerialization, bool)
	AsCsvSerialization() (*CsvSerialization, bool)
	AsParquetSerialization() (*ParquetSerialization, bool)
	AsSerialization() (*Serialization, bool)
}

// Serialization describes how data from an input is serialized or how data is serialized when written to an
// output.
type Serialization struct {
	// Type - Possible values include: 'TypeSerialization', 'TypeAvro', 'TypeJSON', 'TypeCsv', 'TypeParquet'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicSerialization(body []byte) (BasicSerialization, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeAvro):
		var as AvroSerialization
		err := json.Unmarshal(body, &as)
		return as, err
	case string(TypeJSON):
		var js JSONSerialization
		err := json.Unmarshal(body, &js)
		return js, err
	case string(TypeCsv):
		var cs CsvSerialization
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeParquet):
		var ps ParquetSerialization
		err := json.Unmarshal(body, &ps)
		return ps, err
	default:
		var s Serialization
		err := json.Unmarshal(body, &s)
		return s, err
	}
}
func unmarshalBasicSerializationArray(body []byte) ([]BasicSerialization, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sArray := make([]BasicSerialization, len(rawMessages))

	for index, rawMessage := range rawMessages {
		s, err := unmarshalBasicSerialization(*rawMessage)
		if err != nil {
			return nil, err
		}
		sArray[index] = s
	}
	return sArray, nil
}

// MarshalJSON is the custom marshaler for Serialization.
func (s Serialization) MarshalJSON() ([]byte, error) {
	s.Type = TypeSerialization
	objectMap := make(map[string]interface{})
	if s.Type != "" {
		objectMap["type"] = s.Type
	}
	return json.Marshal(objectMap)
}

// AsAvroSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return nil, false
}

// AsJSONSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return nil, false
}

// AsCsvSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return nil, false
}

// AsParquetSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsParquetSerialization() (*ParquetSerialization, bool) {
	return nil, false
}

// AsSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsSerialization() (*Serialization, bool) {
	return &s, true
}

// AsBasicSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsBasicSerialization() (BasicSerialization, bool) {
	return &s, true
}

// ServiceBusDataSourceProperties the common properties that are associated with Service Bus data sources
// (Queues, Topics, Event Hubs, etc.).
type ServiceBusDataSourceProperties struct {
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
}

// ServiceBusQueueOutputDataSource describes a Service Bus Queue output data source.
type ServiceBusQueueOutputDataSource struct {
	// ServiceBusQueueOutputDataSourceProperties - The properties that are associated with a Service Bus Queue output. Required on PUT (CreateOrReplace) requests.
	*ServiceBusQueueOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) MarshalJSON() ([]byte, error) {
	sbqods.Type = TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue
	objectMap := make(map[string]interface{})
	if sbqods.ServiceBusQueueOutputDataSourceProperties != nil {
		objectMap["properties"] = sbqods.ServiceBusQueueOutputDataSourceProperties
	}
	if sbqods.Type != "" {
		objectMap["type"] = sbqods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return &sbqods, true
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &sbqods, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceBusQueueOutputDataSource struct.
func (sbqods *ServiceBusQueueOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceBusQueueOutputDataSourceProperties ServiceBusQueueOutputDataSourceProperties
				err = json.Unmarshal(*v, &serviceBusQueueOutputDataSourceProperties)
				if err != nil {
					return err
				}
				sbqods.ServiceBusQueueOutputDataSourceProperties = &serviceBusQueueOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sbqods.Type = typeVar
			}
		}
	}

	return nil
}

// ServiceBusQueueOutputDataSourceProperties the properties that are associated with a Service Bus Queue
// output.
type ServiceBusQueueOutputDataSourceProperties struct {
	// QueueName - The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
	QueueName *string `json:"queueName,omitempty"`
	// PropertyColumns - A string array of the names of output columns to be attached to Service Bus messages as custom properties.
	PropertyColumns *[]string `json:"propertyColumns,omitempty"`
	// SystemPropertyColumns - The system properties associated with the Service Bus Queue. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
	SystemPropertyColumns interface{} `json:"systemPropertyColumns,omitempty"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
}

// ServiceBusTopicOutputDataSource describes a Service Bus Topic output data source.
type ServiceBusTopicOutputDataSource struct {
	// ServiceBusTopicOutputDataSourceProperties - The properties that are associated with a Service Bus Topic output. Required on PUT (CreateOrReplace) requests.
	*ServiceBusTopicOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicOutputDataSourceTypeOutputDataSource', 'TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts', 'TypeBasicOutputDataSourceTypePowerBI', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue', 'TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse', 'TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase', 'TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicOutputDataSourceTypeMicrosoftStorageTable', 'TypeBasicOutputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) MarshalJSON() ([]byte, error) {
	sbtods.Type = TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic
	objectMap := make(map[string]interface{})
	if sbtods.ServiceBusTopicOutputDataSourceProperties != nil {
		objectMap["properties"] = sbtods.ServiceBusTopicOutputDataSourceProperties
	}
	if sbtods.Type != "" {
		objectMap["type"] = sbtods.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return &sbtods, true
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSynapseOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureSynapseOutputDataSource() (*AzureSynapseOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubV2OutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsEventHubV2OutputDataSource() (*EventHubV2OutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &sbtods, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceBusTopicOutputDataSource struct.
func (sbtods *ServiceBusTopicOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceBusTopicOutputDataSourceProperties ServiceBusTopicOutputDataSourceProperties
				err = json.Unmarshal(*v, &serviceBusTopicOutputDataSourceProperties)
				if err != nil {
					return err
				}
				sbtods.ServiceBusTopicOutputDataSourceProperties = &serviceBusTopicOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sbtods.Type = typeVar
			}
		}
	}

	return nil
}

// ServiceBusTopicOutputDataSourceProperties the properties that are associated with a Service Bus Topic
// output.
type ServiceBusTopicOutputDataSourceProperties struct {
	// TopicName - The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
	TopicName *string `json:"topicName,omitempty"`
	// PropertyColumns - A string array of the names of output columns to be attached to Service Bus messages as custom properties.
	PropertyColumns *[]string `json:"propertyColumns,omitempty"`
	// SystemPropertyColumns - The system properties associated with the Service Bus Topic Output. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
	SystemPropertyColumns map[string]*string `json:"systemPropertyColumns"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
	// AuthenticationMode - Authentication Mode. Possible values include: 'AuthenticationModeMsi', 'AuthenticationModeUserToken', 'AuthenticationModeConnectionString'
	AuthenticationMode AuthenticationMode `json:"authenticationMode,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBusTopicOutputDataSourceProperties.
func (sbtodsp ServiceBusTopicOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbtodsp.TopicName != nil {
		objectMap["topicName"] = sbtodsp.TopicName
	}
	if sbtodsp.PropertyColumns != nil {
		objectMap["propertyColumns"] = sbtodsp.PropertyColumns
	}
	if sbtodsp.SystemPropertyColumns != nil {
		objectMap["systemPropertyColumns"] = sbtodsp.SystemPropertyColumns
	}
	if sbtodsp.ServiceBusNamespace != nil {
		objectMap["serviceBusNamespace"] = sbtodsp.ServiceBusNamespace
	}
	if sbtodsp.SharedAccessPolicyName != nil {
		objectMap["sharedAccessPolicyName"] = sbtodsp.SharedAccessPolicyName
	}
	if sbtodsp.SharedAccessPolicyKey != nil {
		objectMap["sharedAccessPolicyKey"] = sbtodsp.SharedAccessPolicyKey
	}
	if sbtodsp.AuthenticationMode != "" {
		objectMap["authenticationMode"] = sbtodsp.AuthenticationMode
	}
	return json.Marshal(objectMap)
}

// Sku the properties that are associated with a SKU.
type Sku struct {
	// Name - The name of the SKU. Required on PUT (CreateOrReplace) requests. Possible values include: 'SkuNameStandard'
	Name SkuName `json:"name,omitempty"`
}

// StartStreamingJobParameters parameters supplied to the Start Streaming Job operation.
type StartStreamingJobParameters struct {
	// OutputStartMode - Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time. Possible values include: 'OutputStartModeJobStartTime', 'OutputStartModeCustomTime', 'OutputStartModeLastOutputEventTime'
	OutputStartMode OutputStartMode `json:"outputStartMode,omitempty"`
	// OutputStartTime - Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime.
	OutputStartTime *date.Time `json:"outputStartTime,omitempty"`
}

// StorageAccount the properties that are associated with an Azure Storage account
type StorageAccount struct {
	// AccountName - The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`
	// AccountKey - The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`
}

// StreamingJob a streaming job object, containing all information associated with the named streaming job.
type StreamingJob struct {
	autorest.Response `json:"-"`
	// StreamingJobProperties - The properties that are associated with a streaming job.  Required on PUT (CreateOrReplace) requests.
	*StreamingJobProperties `json:"properties,omitempty"`
	// Identity - Describes the system-assigned managed identity assigned to this job that can be used to authenticate with inputs and outputs.
	Identity *Identity `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingJob.
func (sj StreamingJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sj.StreamingJobProperties != nil {
		objectMap["properties"] = sj.StreamingJobProperties
	}
	if sj.Identity != nil {
		objectMap["identity"] = sj.Identity
	}
	if sj.Tags != nil {
		objectMap["tags"] = sj.Tags
	}
	if sj.Location != nil {
		objectMap["location"] = sj.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StreamingJob struct.
func (sj *StreamingJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var streamingJobProperties StreamingJobProperties
				err = json.Unmarshal(*v, &streamingJobProperties)
				if err != nil {
					return err
				}
				sj.StreamingJobProperties = &streamingJobProperties
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sj.Identity = &identity
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sj.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sj.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sj.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sj.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sj.Type = &typeVar
			}
		}
	}

	return nil
}

// StreamingJobListResult object containing a list of streaming jobs.
type StreamingJobListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of streaming jobs. Populated by a 'List' operation.
	Value *[]StreamingJob `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingJobListResult.
func (sjlr StreamingJobListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StreamingJobListResultIterator provides access to a complete listing of StreamingJob values.
type StreamingJobListResultIterator struct {
	i    int
	page StreamingJobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StreamingJobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StreamingJobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StreamingJobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StreamingJobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StreamingJobListResultIterator) Response() StreamingJobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StreamingJobListResultIterator) Value() StreamingJob {
	if !iter.page.NotDone() {
		return StreamingJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StreamingJobListResultIterator type.
func NewStreamingJobListResultIterator(page StreamingJobListResultPage) StreamingJobListResultIterator {
	return StreamingJobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sjlr StreamingJobListResult) IsEmpty() bool {
	return sjlr.Value == nil || len(*sjlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sjlr StreamingJobListResult) hasNextLink() bool {
	return sjlr.NextLink != nil && len(*sjlr.NextLink) != 0
}

// streamingJobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sjlr StreamingJobListResult) streamingJobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sjlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sjlr.NextLink)))
}

// StreamingJobListResultPage contains a page of StreamingJob values.
type StreamingJobListResultPage struct {
	fn   func(context.Context, StreamingJobListResult) (StreamingJobListResult, error)
	sjlr StreamingJobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StreamingJobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StreamingJobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sjlr)
		if err != nil {
			return err
		}
		page.sjlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StreamingJobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StreamingJobListResultPage) NotDone() bool {
	return !page.sjlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StreamingJobListResultPage) Response() StreamingJobListResult {
	return page.sjlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StreamingJobListResultPage) Values() []StreamingJob {
	if page.sjlr.IsEmpty() {
		return nil
	}
	return *page.sjlr.Value
}

// Creates a new instance of the StreamingJobListResultPage type.
func NewStreamingJobListResultPage(cur StreamingJobListResult, getNextPage func(context.Context, StreamingJobListResult) (StreamingJobListResult, error)) StreamingJobListResultPage {
	return StreamingJobListResultPage{
		fn:   getNextPage,
		sjlr: cur,
	}
}

// StreamingJobProperties the properties that are associated with a streaming job.
type StreamingJobProperties struct {
	// Sku - Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
	Sku *Sku `json:"sku,omitempty"`
	// JobID - READ-ONLY; A GUID uniquely identifying the streaming job. This GUID is generated upon creation of the streaming job.
	JobID *string `json:"jobId,omitempty"`
	// ProvisioningState - READ-ONLY; Describes the provisioning status of the streaming job.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// JobState - READ-ONLY; Describes the state of the streaming job.
	JobState *string `json:"jobState,omitempty"`
	// JobType - Describes the type of the job. Valid modes are `Cloud` and 'Edge'. Possible values include: 'JobTypeCloud', 'JobTypeEdge'
	JobType JobType `json:"jobType,omitempty"`
	// OutputStartMode - This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time. Possible values include: 'OutputStartModeJobStartTime', 'OutputStartModeCustomTime', 'OutputStartModeLastOutputEventTime'
	OutputStartMode OutputStartMode `json:"outputStartMode,omitempty"`
	// OutputStartTime - Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime.
	OutputStartTime *date.Time `json:"outputStartTime,omitempty"`
	// LastOutputEventTime - READ-ONLY; Value is either an ISO-8601 formatted timestamp indicating the last output event time of the streaming job or null indicating that output has not yet been produced. In case of multiple outputs or multiple streams, this shows the latest value in that set.
	LastOutputEventTime *date.Time `json:"lastOutputEventTime,omitempty"`
	// EventsOutOfOrderPolicy - Indicates the policy to apply to events that arrive out of order in the input event stream. Possible values include: 'EventsOutOfOrderPolicyAdjust', 'EventsOutOfOrderPolicyDrop'
	EventsOutOfOrderPolicy EventsOutOfOrderPolicy `json:"eventsOutOfOrderPolicy,omitempty"`
	// OutputErrorPolicy - Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size). Possible values include: 'OutputErrorPolicyStop', 'OutputErrorPolicyDrop'
	OutputErrorPolicy OutputErrorPolicy `json:"outputErrorPolicy,omitempty"`
	// EventsOutOfOrderMaxDelayInSeconds - The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order.
	EventsOutOfOrderMaxDelayInSeconds *int32 `json:"eventsOutOfOrderMaxDelayInSeconds,omitempty"`
	// EventsLateArrivalMaxDelayInSeconds - The maximum tolerable delay in seconds where events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days) and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to have a value of -1.
	EventsLateArrivalMaxDelayInSeconds *int32 `json:"eventsLateArrivalMaxDelayInSeconds,omitempty"`
	// DataLocale - The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none specified.
	DataLocale *string `json:"dataLocale,omitempty"`
	// CompatibilityLevel - Controls certain runtime behaviors of the streaming job. Possible values include: 'CompatibilityLevelOneFullStopZero', 'CompatibilityLevelOneFullStopTwo'
	CompatibilityLevel CompatibilityLevel `json:"compatibilityLevel,omitempty"`
	// CreatedDate - READ-ONLY; Value is an ISO-8601 formatted UTC timestamp indicating when the streaming job was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// Inputs - A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
	Inputs *[]Input `json:"inputs,omitempty"`
	// Transformation - Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
	Transformation *Transformation `json:"transformation,omitempty"`
	// Outputs - A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
	Outputs *[]Output `json:"outputs,omitempty"`
	// Functions - A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
	Functions *[]Function `json:"functions,omitempty"`
	// Etag - READ-ONLY; The current entity tag for the streaming job. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// JobStorageAccount - The properties that are associated with an Azure Storage account with MSI
	JobStorageAccount *JobStorageAccount `json:"jobStorageAccount,omitempty"`
	// ContentStoragePolicy - Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. Possible values include: 'ContentStoragePolicySystemAccount', 'ContentStoragePolicyJobStorageAccount'
	ContentStoragePolicy ContentStoragePolicy `json:"contentStoragePolicy,omitempty"`
	// Cluster - The cluster which streaming jobs will run on.
	Cluster *ClusterInfo `json:"cluster,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingJobProperties.
func (sjp StreamingJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sjp.Sku != nil {
		objectMap["sku"] = sjp.Sku
	}
	if sjp.JobType != "" {
		objectMap["jobType"] = sjp.JobType
	}
	if sjp.OutputStartMode != "" {
		objectMap["outputStartMode"] = sjp.OutputStartMode
	}
	if sjp.OutputStartTime != nil {
		objectMap["outputStartTime"] = sjp.OutputStartTime
	}
	if sjp.EventsOutOfOrderPolicy != "" {
		objectMap["eventsOutOfOrderPolicy"] = sjp.EventsOutOfOrderPolicy
	}
	if sjp.OutputErrorPolicy != "" {
		objectMap["outputErrorPolicy"] = sjp.OutputErrorPolicy
	}
	if sjp.EventsOutOfOrderMaxDelayInSeconds != nil {
		objectMap["eventsOutOfOrderMaxDelayInSeconds"] = sjp.EventsOutOfOrderMaxDelayInSeconds
	}
	if sjp.EventsLateArrivalMaxDelayInSeconds != nil {
		objectMap["eventsLateArrivalMaxDelayInSeconds"] = sjp.EventsLateArrivalMaxDelayInSeconds
	}
	if sjp.DataLocale != nil {
		objectMap["dataLocale"] = sjp.DataLocale
	}
	if sjp.CompatibilityLevel != "" {
		objectMap["compatibilityLevel"] = sjp.CompatibilityLevel
	}
	if sjp.Inputs != nil {
		objectMap["inputs"] = sjp.Inputs
	}
	if sjp.Transformation != nil {
		objectMap["transformation"] = sjp.Transformation
	}
	if sjp.Outputs != nil {
		objectMap["outputs"] = sjp.Outputs
	}
	if sjp.Functions != nil {
		objectMap["functions"] = sjp.Functions
	}
	if sjp.JobStorageAccount != nil {
		objectMap["jobStorageAccount"] = sjp.JobStorageAccount
	}
	if sjp.ContentStoragePolicy != "" {
		objectMap["contentStoragePolicy"] = sjp.ContentStoragePolicy
	}
	if sjp.Cluster != nil {
		objectMap["cluster"] = sjp.Cluster
	}
	return json.Marshal(objectMap)
}

// StreamingJobsCreateOrReplaceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StreamingJobsCreateOrReplaceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingJobsClient) (StreamingJob, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingJobsCreateOrReplaceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingJobsCreateOrReplaceFuture.Result.
func (future *StreamingJobsCreateOrReplaceFuture) result(client StreamingJobsClient) (sj StreamingJob, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsCreateOrReplaceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sj.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.StreamingJobsCreateOrReplaceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sj.Response.Response, err = future.GetResult(sender); err == nil && sj.Response.Response.StatusCode != http.StatusNoContent {
		sj, err = client.CreateOrReplaceResponder(sj.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsCreateOrReplaceFuture", "Result", sj.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StreamingJobsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StreamingJobsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingJobsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingJobsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingJobsDeleteFuture.Result.
func (future *StreamingJobsDeleteFuture) result(client StreamingJobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.StreamingJobsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// StreamingJobsScaleFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StreamingJobsScaleFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingJobsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingJobsScaleFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingJobsScaleFuture.Result.
func (future *StreamingJobsScaleFuture) result(client StreamingJobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsScaleFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.StreamingJobsScaleFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// StreamingJobsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StreamingJobsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingJobsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingJobsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingJobsStartFuture.Result.
func (future *StreamingJobsStartFuture) result(client StreamingJobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.StreamingJobsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// StreamingJobsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StreamingJobsStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingJobsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingJobsStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingJobsStopFuture.Result.
func (future *StreamingJobsStopFuture) result(client StreamingJobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("streamanalytics.StreamingJobsStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BasicStreamInputDataSource describes an input data source that contains stream data.
type BasicStreamInputDataSource interface {
	AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool)
	AsEventHubV2StreamInputDataSource() (*EventHubV2StreamInputDataSource, bool)
	AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool)
	AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool)
	AsStreamInputDataSource() (*StreamInputDataSource, bool)
}

// StreamInputDataSource describes an input data source that contains stream data.
type StreamInputDataSource struct {
	// Type - Possible values include: 'TypeBasicStreamInputDataSourceTypeStreamInputDataSource', 'TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs', 'TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicStreamInputDataSource `json:"type,omitempty"`
}

func unmarshalBasicStreamInputDataSource(body []byte) (BasicStreamInputDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs):
		var ithsids IoTHubStreamInputDataSource
		err := json.Unmarshal(body, &ithsids)
		return ithsids, err
	case string(TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub):
		var ehvsids EventHubV2StreamInputDataSource
		err := json.Unmarshal(body, &ehvsids)
		return ehvsids, err
	case string(TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub):
		var ehsids EventHubStreamInputDataSource
		err := json.Unmarshal(body, &ehsids)
		return ehsids, err
	case string(TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob):
		var bsids BlobStreamInputDataSource
		err := json.Unmarshal(body, &bsids)
		return bsids, err
	default:
		var sids StreamInputDataSource
		err := json.Unmarshal(body, &sids)
		return sids, err
	}
}
func unmarshalBasicStreamInputDataSourceArray(body []byte) ([]BasicStreamInputDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sidsArray := make([]BasicStreamInputDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sids, err := unmarshalBasicStreamInputDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		sidsArray[index] = sids
	}
	return sidsArray, nil
}

// MarshalJSON is the custom marshaler for StreamInputDataSource.
func (sids StreamInputDataSource) MarshalJSON() ([]byte, error) {
	sids.Type = TypeBasicStreamInputDataSourceTypeStreamInputDataSource
	objectMap := make(map[string]interface{})
	if sids.Type != "" {
		objectMap["type"] = sids.Type
	}
	return json.Marshal(objectMap)
}

// AsIoTHubStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubV2StreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsEventHubV2StreamInputDataSource() (*EventHubV2StreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return nil, false
}

// AsBlobStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return nil, false
}

// AsStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsStreamInputDataSource() (*StreamInputDataSource, bool) {
	return &sids, true
}

// AsBasicStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsBasicStreamInputDataSource() (BasicStreamInputDataSource, bool) {
	return &sids, true
}

// StreamInputProperties the properties that are associated with an input containing stream data.
type StreamInputProperties struct {
	// Datasource - Describes an input data source that contains stream data. Required on PUT (CreateOrReplace) requests.
	Datasource BasicStreamInputDataSource `json:"datasource,omitempty"`
	// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
	Serialization BasicSerialization `json:"serialization,omitempty"`
	// Diagnostics - READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty"`
	// Etag - READ-ONLY; The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Compression - Describes how input data is compressed
	Compression *Compression `json:"compression,omitempty"`
	// PartitionKey - partitionKey Describes a key in the input data which is used for partitioning the input data
	PartitionKey *string `json:"partitionKey,omitempty"`
	// Type - Possible values include: 'TypeBasicInputPropertiesTypeInputProperties', 'TypeBasicInputPropertiesTypeReference', 'TypeBasicInputPropertiesTypeStream'
	Type TypeBasicInputProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamInputProperties.
func (sip StreamInputProperties) MarshalJSON() ([]byte, error) {
	sip.Type = TypeBasicInputPropertiesTypeStream
	objectMap := make(map[string]interface{})
	objectMap["datasource"] = sip.Datasource
	objectMap["serialization"] = sip.Serialization
	if sip.Compression != nil {
		objectMap["compression"] = sip.Compression
	}
	if sip.PartitionKey != nil {
		objectMap["partitionKey"] = sip.PartitionKey
	}
	if sip.Type != "" {
		objectMap["type"] = sip.Type
	}
	return json.Marshal(objectMap)
}

// AsReferenceInputProperties is the BasicInputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsReferenceInputProperties() (*ReferenceInputProperties, bool) {
	return nil, false
}

// AsStreamInputProperties is the BasicInputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsStreamInputProperties() (*StreamInputProperties, bool) {
	return &sip, true
}

// AsInputProperties is the BasicInputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsInputProperties() (*InputProperties, bool) {
	return nil, false
}

// AsBasicInputProperties is the BasicInputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsBasicInputProperties() (BasicInputProperties, bool) {
	return &sip, true
}

// UnmarshalJSON is the custom unmarshaler for StreamInputProperties struct.
func (sip *StreamInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "datasource":
			if v != nil {
				datasource, err := unmarshalBasicStreamInputDataSource(*v)
				if err != nil {
					return err
				}
				sip.Datasource = datasource
			}
		case "serialization":
			if v != nil {
				serialization, err := unmarshalBasicSerialization(*v)
				if err != nil {
					return err
				}
				sip.Serialization = serialization
			}
		case "diagnostics":
			if v != nil {
				var diagnostics Diagnostics
				err = json.Unmarshal(*v, &diagnostics)
				if err != nil {
					return err
				}
				sip.Diagnostics = &diagnostics
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sip.Etag = &etag
			}
		case "compression":
			if v != nil {
				var compression Compression
				err = json.Unmarshal(*v, &compression)
				if err != nil {
					return err
				}
				sip.Compression = &compression
			}
		case "partitionKey":
			if v != nil {
				var partitionKey string
				err = json.Unmarshal(*v, &partitionKey)
				if err != nil {
					return err
				}
				sip.PartitionKey = &partitionKey
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicInputProperties
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sip.Type = typeVar
			}
		}
	}

	return nil
}

// SubResource the base sub-resource model definition.
type SubResource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubResource.
func (sr SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	return json.Marshal(objectMap)
}

// SubscriptionQuota describes the current quota for the subscription.
type SubscriptionQuota struct {
	// SubscriptionQuotaProperties - READ-ONLY; Describes the properties of the quota.
	*SubscriptionQuotaProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionQuota.
func (sq SubscriptionQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sq.Name != nil {
		objectMap["name"] = sq.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionQuota struct.
func (sq *SubscriptionQuota) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionQuotaProperties SubscriptionQuotaProperties
				err = json.Unmarshal(*v, &subscriptionQuotaProperties)
				if err != nil {
					return err
				}
				sq.SubscriptionQuotaProperties = &subscriptionQuotaProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sq.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sq.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sq.Type = &typeVar
			}
		}
	}

	return nil
}

// SubscriptionQuotaProperties describes the properties of the quota.
type SubscriptionQuotaProperties struct {
	// MaxCount - READ-ONLY; The max permitted usage of this resource.
	MaxCount *int32 `json:"maxCount,omitempty"`
	// CurrentCount - READ-ONLY; The current usage of this resource.
	CurrentCount *int32 `json:"currentCount,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionQuotaProperties.
func (sq SubscriptionQuotaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SubscriptionQuotasListResult result of the GetQuotas operation. It contains a list of quotas for the
// subscription in a particular region.
type SubscriptionQuotasListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of quotas for the subscription in a particular region.
	Value *[]SubscriptionQuota `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionQuotasListResult.
func (sqlr SubscriptionQuotasListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// Transformation a transformation object, containing all information associated with the named
// transformation. All transformations are contained under a streaming job.
type Transformation struct {
	autorest.Response `json:"-"`
	// TransformationProperties - The properties that are associated with a transformation. Required on PUT (CreateOrReplace) requests.
	*TransformationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Transformation.
func (t Transformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TransformationProperties != nil {
		objectMap["properties"] = t.TransformationProperties
	}
	if t.Name != nil {
		objectMap["name"] = t.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Transformation struct.
func (t *Transformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transformationProperties TransformationProperties
				err = json.Unmarshal(*v, &transformationProperties)
				if err != nil {
					return err
				}
				t.TransformationProperties = &transformationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TransformationProperties the properties that are associated with a transformation.
type TransformationProperties struct {
	// StreamingUnits - Specifies the number of streaming units that the streaming job uses.
	StreamingUnits *int32 `json:"streamingUnits,omitempty"`
	// ValidStreamingUnits - Specifies the valid streaming units a streaming job can scale to.
	ValidStreamingUnits *[]int32 `json:"validStreamingUnits,omitempty"`
	// Query - Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
	Query *string `json:"query,omitempty"`
	// Etag - READ-ONLY; The current entity tag for the transformation. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for TransformationProperties.
func (tp TransformationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.StreamingUnits != nil {
		objectMap["streamingUnits"] = tp.StreamingUnits
	}
	if tp.ValidStreamingUnits != nil {
		objectMap["validStreamingUnits"] = tp.ValidStreamingUnits
	}
	if tp.Query != nil {
		objectMap["query"] = tp.Query
	}
	return json.Marshal(objectMap)
}
