// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/common/offline_user_data.proto

package common

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Address identifier of offline data.
type OfflineUserAddressInfo struct {
	// First name of the user, which is hashed as SHA-256 after normalized
	// (Lowercase all characters; Remove any extra spaces before, after, and in
	// between).
	HashedFirstName *wrappers.StringValue `protobuf:"bytes,1,opt,name=hashed_first_name,json=hashedFirstName,proto3" json:"hashed_first_name,omitempty"`
	// Last name of the user, which is hashed as SHA-256 after normalized (lower
	// case only and no punctuation).
	HashedLastName *wrappers.StringValue `protobuf:"bytes,2,opt,name=hashed_last_name,json=hashedLastName,proto3" json:"hashed_last_name,omitempty"`
	// City of the address. Only accepted for Store Sales Direct data.
	City *wrappers.StringValue `protobuf:"bytes,3,opt,name=city,proto3" json:"city,omitempty"`
	// State code of the address. Only accepted for Store Sales Direct data.
	State *wrappers.StringValue `protobuf:"bytes,4,opt,name=state,proto3" json:"state,omitempty"`
	// 2-letter country code in ISO-3166-1 alpha-2 of the user's address.
	CountryCode *wrappers.StringValue `protobuf:"bytes,5,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Postal code of the user's address.
	PostalCode           *wrappers.StringValue `protobuf:"bytes,6,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *OfflineUserAddressInfo) Reset()         { *m = OfflineUserAddressInfo{} }
func (m *OfflineUserAddressInfo) String() string { return proto.CompactTextString(m) }
func (*OfflineUserAddressInfo) ProtoMessage()    {}
func (*OfflineUserAddressInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5aaebd090f8ad90, []int{0}
}

func (m *OfflineUserAddressInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfflineUserAddressInfo.Unmarshal(m, b)
}
func (m *OfflineUserAddressInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfflineUserAddressInfo.Marshal(b, m, deterministic)
}
func (m *OfflineUserAddressInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfflineUserAddressInfo.Merge(m, src)
}
func (m *OfflineUserAddressInfo) XXX_Size() int {
	return xxx_messageInfo_OfflineUserAddressInfo.Size(m)
}
func (m *OfflineUserAddressInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_OfflineUserAddressInfo.DiscardUnknown(m)
}

var xxx_messageInfo_OfflineUserAddressInfo proto.InternalMessageInfo

func (m *OfflineUserAddressInfo) GetHashedFirstName() *wrappers.StringValue {
	if m != nil {
		return m.HashedFirstName
	}
	return nil
}

func (m *OfflineUserAddressInfo) GetHashedLastName() *wrappers.StringValue {
	if m != nil {
		return m.HashedLastName
	}
	return nil
}

func (m *OfflineUserAddressInfo) GetCity() *wrappers.StringValue {
	if m != nil {
		return m.City
	}
	return nil
}

func (m *OfflineUserAddressInfo) GetState() *wrappers.StringValue {
	if m != nil {
		return m.State
	}
	return nil
}

func (m *OfflineUserAddressInfo) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *OfflineUserAddressInfo) GetPostalCode() *wrappers.StringValue {
	if m != nil {
		return m.PostalCode
	}
	return nil
}

// Hashed user identifying information.
type UserIdentifier struct {
	// Exactly one must be specified.
	//
	// Types that are valid to be assigned to Identifier:
	//	*UserIdentifier_HashedEmail
	//	*UserIdentifier_HashedPhoneNumber
	//	*UserIdentifier_MobileId
	//	*UserIdentifier_ThirdPartyUserId
	//	*UserIdentifier_AddressInfo
	Identifier           isUserIdentifier_Identifier `protobuf_oneof:"identifier"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *UserIdentifier) Reset()         { *m = UserIdentifier{} }
func (m *UserIdentifier) String() string { return proto.CompactTextString(m) }
func (*UserIdentifier) ProtoMessage()    {}
func (*UserIdentifier) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5aaebd090f8ad90, []int{1}
}

func (m *UserIdentifier) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserIdentifier.Unmarshal(m, b)
}
func (m *UserIdentifier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserIdentifier.Marshal(b, m, deterministic)
}
func (m *UserIdentifier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserIdentifier.Merge(m, src)
}
func (m *UserIdentifier) XXX_Size() int {
	return xxx_messageInfo_UserIdentifier.Size(m)
}
func (m *UserIdentifier) XXX_DiscardUnknown() {
	xxx_messageInfo_UserIdentifier.DiscardUnknown(m)
}

var xxx_messageInfo_UserIdentifier proto.InternalMessageInfo

type isUserIdentifier_Identifier interface {
	isUserIdentifier_Identifier()
}

type UserIdentifier_HashedEmail struct {
	HashedEmail *wrappers.StringValue `protobuf:"bytes,1,opt,name=hashed_email,json=hashedEmail,proto3,oneof"`
}

type UserIdentifier_HashedPhoneNumber struct {
	HashedPhoneNumber *wrappers.StringValue `protobuf:"bytes,2,opt,name=hashed_phone_number,json=hashedPhoneNumber,proto3,oneof"`
}

type UserIdentifier_MobileId struct {
	MobileId *wrappers.StringValue `protobuf:"bytes,3,opt,name=mobile_id,json=mobileId,proto3,oneof"`
}

type UserIdentifier_ThirdPartyUserId struct {
	ThirdPartyUserId *wrappers.StringValue `protobuf:"bytes,4,opt,name=third_party_user_id,json=thirdPartyUserId,proto3,oneof"`
}

type UserIdentifier_AddressInfo struct {
	AddressInfo *OfflineUserAddressInfo `protobuf:"bytes,5,opt,name=address_info,json=addressInfo,proto3,oneof"`
}

func (*UserIdentifier_HashedEmail) isUserIdentifier_Identifier() {}

func (*UserIdentifier_HashedPhoneNumber) isUserIdentifier_Identifier() {}

func (*UserIdentifier_MobileId) isUserIdentifier_Identifier() {}

func (*UserIdentifier_ThirdPartyUserId) isUserIdentifier_Identifier() {}

func (*UserIdentifier_AddressInfo) isUserIdentifier_Identifier() {}

func (m *UserIdentifier) GetIdentifier() isUserIdentifier_Identifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (m *UserIdentifier) GetHashedEmail() *wrappers.StringValue {
	if x, ok := m.GetIdentifier().(*UserIdentifier_HashedEmail); ok {
		return x.HashedEmail
	}
	return nil
}

func (m *UserIdentifier) GetHashedPhoneNumber() *wrappers.StringValue {
	if x, ok := m.GetIdentifier().(*UserIdentifier_HashedPhoneNumber); ok {
		return x.HashedPhoneNumber
	}
	return nil
}

func (m *UserIdentifier) GetMobileId() *wrappers.StringValue {
	if x, ok := m.GetIdentifier().(*UserIdentifier_MobileId); ok {
		return x.MobileId
	}
	return nil
}

func (m *UserIdentifier) GetThirdPartyUserId() *wrappers.StringValue {
	if x, ok := m.GetIdentifier().(*UserIdentifier_ThirdPartyUserId); ok {
		return x.ThirdPartyUserId
	}
	return nil
}

func (m *UserIdentifier) GetAddressInfo() *OfflineUserAddressInfo {
	if x, ok := m.GetIdentifier().(*UserIdentifier_AddressInfo); ok {
		return x.AddressInfo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*UserIdentifier) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*UserIdentifier_HashedEmail)(nil),
		(*UserIdentifier_HashedPhoneNumber)(nil),
		(*UserIdentifier_MobileId)(nil),
		(*UserIdentifier_ThirdPartyUserId)(nil),
		(*UserIdentifier_AddressInfo)(nil),
	}
}

// Attribute of the store sales transaction.
type TransactionAttribute struct {
	// Timestamp when transaction occurred. Required.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	TransactionDateTime *wrappers.StringValue `protobuf:"bytes,1,opt,name=transaction_date_time,json=transactionDateTime,proto3" json:"transaction_date_time,omitempty"`
	// Transaction amount in micros. Required.
	TransactionAmountMicros *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=transaction_amount_micros,json=transactionAmountMicros,proto3" json:"transaction_amount_micros,omitempty"`
	// Transaction currency code. ISO 4217 three-letter code is used. Required.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,3,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// The resource name of conversion action to report conversions to.
	// Required.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,4,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// Transaction order id.
	// Accessible to whitelisted customers only.
	OrderId *wrappers.StringValue `protobuf:"bytes,5,opt,name=order_id,json=orderId,proto3" json:"order_id,omitempty"`
	// Store attributes of the transaction.
	// Accessible to whitelisted customers only.
	StoreAttribute *StoreAttribute `protobuf:"bytes,6,opt,name=store_attribute,json=storeAttribute,proto3" json:"store_attribute,omitempty"`
	// Value of the custom variable for each transaction.
	// Accessible to whitelisted customers only.
	CustomValue          *wrappers.StringValue `protobuf:"bytes,7,opt,name=custom_value,json=customValue,proto3" json:"custom_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TransactionAttribute) Reset()         { *m = TransactionAttribute{} }
func (m *TransactionAttribute) String() string { return proto.CompactTextString(m) }
func (*TransactionAttribute) ProtoMessage()    {}
func (*TransactionAttribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5aaebd090f8ad90, []int{2}
}

func (m *TransactionAttribute) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransactionAttribute.Unmarshal(m, b)
}
func (m *TransactionAttribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransactionAttribute.Marshal(b, m, deterministic)
}
func (m *TransactionAttribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionAttribute.Merge(m, src)
}
func (m *TransactionAttribute) XXX_Size() int {
	return xxx_messageInfo_TransactionAttribute.Size(m)
}
func (m *TransactionAttribute) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionAttribute.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionAttribute proto.InternalMessageInfo

func (m *TransactionAttribute) GetTransactionDateTime() *wrappers.StringValue {
	if m != nil {
		return m.TransactionDateTime
	}
	return nil
}

func (m *TransactionAttribute) GetTransactionAmountMicros() *wrappers.DoubleValue {
	if m != nil {
		return m.TransactionAmountMicros
	}
	return nil
}

func (m *TransactionAttribute) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *TransactionAttribute) GetConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *TransactionAttribute) GetOrderId() *wrappers.StringValue {
	if m != nil {
		return m.OrderId
	}
	return nil
}

func (m *TransactionAttribute) GetStoreAttribute() *StoreAttribute {
	if m != nil {
		return m.StoreAttribute
	}
	return nil
}

func (m *TransactionAttribute) GetCustomValue() *wrappers.StringValue {
	if m != nil {
		return m.CustomValue
	}
	return nil
}

// Store attributes of the transaction.
type StoreAttribute struct {
	// Store code from
	// https://support.google.com/business/answer/3370250#storecode
	StoreCode            *wrappers.StringValue `protobuf:"bytes,1,opt,name=store_code,json=storeCode,proto3" json:"store_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *StoreAttribute) Reset()         { *m = StoreAttribute{} }
func (m *StoreAttribute) String() string { return proto.CompactTextString(m) }
func (*StoreAttribute) ProtoMessage()    {}
func (*StoreAttribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5aaebd090f8ad90, []int{3}
}

func (m *StoreAttribute) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StoreAttribute.Unmarshal(m, b)
}
func (m *StoreAttribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StoreAttribute.Marshal(b, m, deterministic)
}
func (m *StoreAttribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreAttribute.Merge(m, src)
}
func (m *StoreAttribute) XXX_Size() int {
	return xxx_messageInfo_StoreAttribute.Size(m)
}
func (m *StoreAttribute) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreAttribute.DiscardUnknown(m)
}

var xxx_messageInfo_StoreAttribute proto.InternalMessageInfo

func (m *StoreAttribute) GetStoreCode() *wrappers.StringValue {
	if m != nil {
		return m.StoreCode
	}
	return nil
}

// User data holding user identifiers and attributes.
type UserData struct {
	// User identification info. Required.
	UserIdentifiers []*UserIdentifier `protobuf:"bytes,1,rep,name=user_identifiers,json=userIdentifiers,proto3" json:"user_identifiers,omitempty"`
	// Additional transactions/attributes associated with the user.
	// Required when updating store sales data.
	TransactionAttribute *TransactionAttribute `protobuf:"bytes,2,opt,name=transaction_attribute,json=transactionAttribute,proto3" json:"transaction_attribute,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UserData) Reset()         { *m = UserData{} }
func (m *UserData) String() string { return proto.CompactTextString(m) }
func (*UserData) ProtoMessage()    {}
func (*UserData) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5aaebd090f8ad90, []int{4}
}

func (m *UserData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserData.Unmarshal(m, b)
}
func (m *UserData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserData.Marshal(b, m, deterministic)
}
func (m *UserData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserData.Merge(m, src)
}
func (m *UserData) XXX_Size() int {
	return xxx_messageInfo_UserData.Size(m)
}
func (m *UserData) XXX_DiscardUnknown() {
	xxx_messageInfo_UserData.DiscardUnknown(m)
}

var xxx_messageInfo_UserData proto.InternalMessageInfo

func (m *UserData) GetUserIdentifiers() []*UserIdentifier {
	if m != nil {
		return m.UserIdentifiers
	}
	return nil
}

func (m *UserData) GetTransactionAttribute() *TransactionAttribute {
	if m != nil {
		return m.TransactionAttribute
	}
	return nil
}

// Metadata for customer match user list.
type CustomerMatchUserListMetadata struct {
	// The resource name of remarketing list to update data.
	// Required for job of CUSTOMER_MATCH_USER_LIST type.
	UserList             *wrappers.StringValue `protobuf:"bytes,1,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CustomerMatchUserListMetadata) Reset()         { *m = CustomerMatchUserListMetadata{} }
func (m *CustomerMatchUserListMetadata) String() string { return proto.CompactTextString(m) }
func (*CustomerMatchUserListMetadata) ProtoMessage()    {}
func (*CustomerMatchUserListMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5aaebd090f8ad90, []int{5}
}

func (m *CustomerMatchUserListMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerMatchUserListMetadata.Unmarshal(m, b)
}
func (m *CustomerMatchUserListMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerMatchUserListMetadata.Marshal(b, m, deterministic)
}
func (m *CustomerMatchUserListMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerMatchUserListMetadata.Merge(m, src)
}
func (m *CustomerMatchUserListMetadata) XXX_Size() int {
	return xxx_messageInfo_CustomerMatchUserListMetadata.Size(m)
}
func (m *CustomerMatchUserListMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerMatchUserListMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerMatchUserListMetadata proto.InternalMessageInfo

func (m *CustomerMatchUserListMetadata) GetUserList() *wrappers.StringValue {
	if m != nil {
		return m.UserList
	}
	return nil
}

// Metadata for Store Sales Direct.
type StoreSalesMetadata struct {
	// This is the fraction of all transactions that are identifiable (i.e.,
	// associated with any form of customer information).
	// Required.
	// The fraction needs to be between 0 and 1 (excluding 0).
	LoyaltyFraction *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=loyalty_fraction,json=loyaltyFraction,proto3" json:"loyalty_fraction,omitempty"`
	// This is the ratio of sales being uploaded compared to the overall sales
	// that can be associated with a customer. Required.
	// The fraction needs to be between 0 and 1 (excluding 0). For example, if you
	// upload half the sales that you are able to associate with a customer, this
	// would be 0.5.
	TransactionUploadFraction *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=transaction_upload_fraction,json=transactionUploadFraction,proto3" json:"transaction_upload_fraction,omitempty"`
	// Name of the store sales custom variable key. A predefined key that
	// can be applied to the transaction and then later used for custom
	// segementation in reporting.
	// Accessible to whitelisted customers only.
	CustomKey *wrappers.StringValue `protobuf:"bytes,4,opt,name=custom_key,json=customKey,proto3" json:"custom_key,omitempty"`
	// Metadata for a third party Store Sales upload.
	ThirdPartyMetadata   *StoreSalesThirdPartyMetadata `protobuf:"bytes,3,opt,name=third_party_metadata,json=thirdPartyMetadata,proto3" json:"third_party_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *StoreSalesMetadata) Reset()         { *m = StoreSalesMetadata{} }
func (m *StoreSalesMetadata) String() string { return proto.CompactTextString(m) }
func (*StoreSalesMetadata) ProtoMessage()    {}
func (*StoreSalesMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5aaebd090f8ad90, []int{6}
}

func (m *StoreSalesMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StoreSalesMetadata.Unmarshal(m, b)
}
func (m *StoreSalesMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StoreSalesMetadata.Marshal(b, m, deterministic)
}
func (m *StoreSalesMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreSalesMetadata.Merge(m, src)
}
func (m *StoreSalesMetadata) XXX_Size() int {
	return xxx_messageInfo_StoreSalesMetadata.Size(m)
}
func (m *StoreSalesMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreSalesMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StoreSalesMetadata proto.InternalMessageInfo

func (m *StoreSalesMetadata) GetLoyaltyFraction() *wrappers.DoubleValue {
	if m != nil {
		return m.LoyaltyFraction
	}
	return nil
}

func (m *StoreSalesMetadata) GetTransactionUploadFraction() *wrappers.DoubleValue {
	if m != nil {
		return m.TransactionUploadFraction
	}
	return nil
}

func (m *StoreSalesMetadata) GetCustomKey() *wrappers.StringValue {
	if m != nil {
		return m.CustomKey
	}
	return nil
}

func (m *StoreSalesMetadata) GetThirdPartyMetadata() *StoreSalesThirdPartyMetadata {
	if m != nil {
		return m.ThirdPartyMetadata
	}
	return nil
}

// Metadata for a third party Store Sales.
// This is a whitelisted only product. Please contact your Google business
// development representative for details on the upload configuration.
type StoreSalesThirdPartyMetadata struct {
	// Time the advertiser uploaded the data to the partner. Required.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	AdvertiserUploadDateTime *wrappers.StringValue `protobuf:"bytes,1,opt,name=advertiser_upload_date_time,json=advertiserUploadDateTime,proto3" json:"advertiser_upload_date_time,omitempty"`
	// The fraction of transactions that are valid. Invalid transactions may
	// include invalid formats or values.
	// Required.
	// The fraction needs to be between 0 and 1 (excluding 0).
	ValidTransactionFraction *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=valid_transaction_fraction,json=validTransactionFraction,proto3" json:"valid_transaction_fraction,omitempty"`
	// The fraction of valid transactions that are matched to a third party
	// assigned user ID on the partner side.
	// Required.
	// The fraction needs to be between 0 and 1 (excluding 0).
	PartnerMatchFraction *wrappers.DoubleValue `protobuf:"bytes,3,opt,name=partner_match_fraction,json=partnerMatchFraction,proto3" json:"partner_match_fraction,omitempty"`
	// The fraction of valid transactions that are uploaded by the partner to
	// Google.
	// Required.
	// The fraction needs to be between 0 and 1 (excluding 0).
	PartnerUploadFraction *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=partner_upload_fraction,json=partnerUploadFraction,proto3" json:"partner_upload_fraction,omitempty"`
	// Version of partner IDs to be used for uploads. Required.
	BridgeMapVersionId *wrappers.StringValue `protobuf:"bytes,5,opt,name=bridge_map_version_id,json=bridgeMapVersionId,proto3" json:"bridge_map_version_id,omitempty"`
	// ID of the third party partner updating the transaction feed.
	PartnerId            *wrappers.Int64Value `protobuf:"bytes,6,opt,name=partner_id,json=partnerId,proto3" json:"partner_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StoreSalesThirdPartyMetadata) Reset()         { *m = StoreSalesThirdPartyMetadata{} }
func (m *StoreSalesThirdPartyMetadata) String() string { return proto.CompactTextString(m) }
func (*StoreSalesThirdPartyMetadata) ProtoMessage()    {}
func (*StoreSalesThirdPartyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_a5aaebd090f8ad90, []int{7}
}

func (m *StoreSalesThirdPartyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StoreSalesThirdPartyMetadata.Unmarshal(m, b)
}
func (m *StoreSalesThirdPartyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StoreSalesThirdPartyMetadata.Marshal(b, m, deterministic)
}
func (m *StoreSalesThirdPartyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreSalesThirdPartyMetadata.Merge(m, src)
}
func (m *StoreSalesThirdPartyMetadata) XXX_Size() int {
	return xxx_messageInfo_StoreSalesThirdPartyMetadata.Size(m)
}
func (m *StoreSalesThirdPartyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreSalesThirdPartyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StoreSalesThirdPartyMetadata proto.InternalMessageInfo

func (m *StoreSalesThirdPartyMetadata) GetAdvertiserUploadDateTime() *wrappers.StringValue {
	if m != nil {
		return m.AdvertiserUploadDateTime
	}
	return nil
}

func (m *StoreSalesThirdPartyMetadata) GetValidTransactionFraction() *wrappers.DoubleValue {
	if m != nil {
		return m.ValidTransactionFraction
	}
	return nil
}

func (m *StoreSalesThirdPartyMetadata) GetPartnerMatchFraction() *wrappers.DoubleValue {
	if m != nil {
		return m.PartnerMatchFraction
	}
	return nil
}

func (m *StoreSalesThirdPartyMetadata) GetPartnerUploadFraction() *wrappers.DoubleValue {
	if m != nil {
		return m.PartnerUploadFraction
	}
	return nil
}

func (m *StoreSalesThirdPartyMetadata) GetBridgeMapVersionId() *wrappers.StringValue {
	if m != nil {
		return m.BridgeMapVersionId
	}
	return nil
}

func (m *StoreSalesThirdPartyMetadata) GetPartnerId() *wrappers.Int64Value {
	if m != nil {
		return m.PartnerId
	}
	return nil
}

func init() {
	proto.RegisterType((*OfflineUserAddressInfo)(nil), "google.ads.googleads.v3.common.OfflineUserAddressInfo")
	proto.RegisterType((*UserIdentifier)(nil), "google.ads.googleads.v3.common.UserIdentifier")
	proto.RegisterType((*TransactionAttribute)(nil), "google.ads.googleads.v3.common.TransactionAttribute")
	proto.RegisterType((*StoreAttribute)(nil), "google.ads.googleads.v3.common.StoreAttribute")
	proto.RegisterType((*UserData)(nil), "google.ads.googleads.v3.common.UserData")
	proto.RegisterType((*CustomerMatchUserListMetadata)(nil), "google.ads.googleads.v3.common.CustomerMatchUserListMetadata")
	proto.RegisterType((*StoreSalesMetadata)(nil), "google.ads.googleads.v3.common.StoreSalesMetadata")
	proto.RegisterType((*StoreSalesThirdPartyMetadata)(nil), "google.ads.googleads.v3.common.StoreSalesThirdPartyMetadata")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/common/offline_user_data.proto", fileDescriptor_a5aaebd090f8ad90)
}

var fileDescriptor_a5aaebd090f8ad90 = []byte{
	// 1056 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x96, 0xdf, 0x4e, 0x1b, 0x47,
	0x14, 0xc6, 0x31, 0x26, 0x09, 0x1c, 0x28, 0x90, 0x01, 0x12, 0x17, 0x68, 0x14, 0xf9, 0xaa, 0x57,
	0xeb, 0x2a, 0x8e, 0xa8, 0x6a, 0x5a, 0x55, 0x06, 0x0a, 0x58, 0x8d, 0x09, 0x32, 0x84, 0xb6, 0x04,
	0x69, 0x35, 0xde, 0x19, 0x9b, 0x51, 0x77, 0x77, 0x56, 0x33, 0xb3, 0xae, 0xfc, 0x12, 0x55, 0xaf,
	0x7b, 0xd9, 0xde, 0xf5, 0x51, 0x7a, 0xd5, 0xc7, 0xa8, 0x7a, 0xd3, 0x57, 0x88, 0xe6, 0xcf, 0xae,
	0x4d, 0x42, 0xc2, 0xe4, 0xca, 0x3b, 0xe3, 0xf3, 0xfb, 0x66, 0xf6, 0x9c, 0xef, 0x1c, 0x1b, 0x76,
	0x86, 0x9c, 0x0f, 0x63, 0xda, 0xc0, 0x44, 0x36, 0xec, 0xa3, 0x7e, 0x1a, 0x35, 0x1b, 0x11, 0x4f,
	0x12, 0x9e, 0x36, 0xf8, 0x60, 0x10, 0xb3, 0x94, 0x86, 0xb9, 0xa4, 0x22, 0x24, 0x58, 0xe1, 0x20,
	0x13, 0x5c, 0x71, 0xf4, 0xc4, 0x06, 0x07, 0x98, 0xc8, 0xa0, 0xe4, 0x82, 0x51, 0x33, 0xb0, 0xdc,
	0xa6, 0xfb, 0xbe, 0x61, 0xa2, 0xfb, 0xf9, 0xa0, 0xf1, 0x8b, 0xc0, 0x59, 0x46, 0x85, 0xb4, 0xfc,
	0xe6, 0x76, 0x71, 0x6e, 0xc6, 0x1a, 0x38, 0x4d, 0xb9, 0xc2, 0x8a, 0xf1, 0xd4, 0x7d, 0x5b, 0xff,
	0xad, 0x0a, 0x8f, 0x5e, 0xda, 0x93, 0x5f, 0x49, 0x2a, 0xda, 0x84, 0x08, 0x2a, 0x65, 0x27, 0x1d,
	0x70, 0x74, 0x0c, 0x0f, 0xaf, 0xb1, 0xbc, 0xa6, 0x24, 0x1c, 0x30, 0x21, 0x55, 0x98, 0xe2, 0x84,
	0xd6, 0x2a, 0x4f, 0x2b, 0x9f, 0x2f, 0x3e, 0xdb, 0x76, 0x37, 0x09, 0x8a, 0x43, 0x83, 0x33, 0x25,
	0x58, 0x3a, 0xbc, 0xc0, 0x71, 0x4e, 0x7b, 0x2b, 0x16, 0x3b, 0xd4, 0xd4, 0x09, 0x4e, 0x28, 0x3a,
	0x84, 0x55, 0xa7, 0x14, 0xe3, 0x42, 0x68, 0xd6, 0x43, 0x68, 0xd9, 0x52, 0x2f, 0xb0, 0xd3, 0xf9,
	0x02, 0xe6, 0x22, 0xa6, 0xc6, 0xb5, 0xaa, 0x07, 0x6b, 0x22, 0xd1, 0x33, 0xb8, 0x27, 0x15, 0x56,
	0xb4, 0x36, 0xe7, 0x81, 0xd8, 0x50, 0xf4, 0x2d, 0x2c, 0x45, 0x3c, 0x4f, 0x95, 0x18, 0x87, 0x11,
	0x27, 0xb4, 0x76, 0xcf, 0x03, 0x5d, 0x74, 0xc4, 0x3e, 0x27, 0x14, 0x7d, 0x03, 0x8b, 0x19, 0x97,
	0x0a, 0xc7, 0x96, 0xbf, 0xef, 0xc1, 0x83, 0x05, 0x34, 0x5e, 0xff, 0xbd, 0x0a, 0xcb, 0xba, 0x16,
	0x1d, 0x42, 0x53, 0xc5, 0x06, 0x8c, 0x0a, 0xd4, 0x86, 0x25, 0x97, 0x40, 0x9a, 0x60, 0x16, 0xfb,
	0x54, 0xe1, 0x78, 0xa6, 0xb7, 0x68, 0x99, 0xef, 0x34, 0x82, 0x4e, 0x60, 0xcd, 0x49, 0x64, 0xd7,
	0x3c, 0xa5, 0x61, 0x9a, 0x27, 0x7d, 0x2a, 0x7c, 0xca, 0x70, 0x3c, 0xd3, 0x73, 0x46, 0x38, 0xd5,
	0xe4, 0x89, 0x01, 0xd1, 0x2e, 0x2c, 0x24, 0xbc, 0xcf, 0x62, 0x1a, 0x32, 0xe2, 0x53, 0x90, 0xe3,
	0x99, 0xde, 0xbc, 0x05, 0x3a, 0x04, 0x75, 0x61, 0x4d, 0x5d, 0x33, 0x41, 0xc2, 0x0c, 0x0b, 0x35,
	0xb6, 0x96, 0x67, 0xc4, 0xa7, 0x48, 0xc7, 0x33, 0xbd, 0x55, 0x83, 0x9e, 0x6a, 0xd2, 0xa6, 0x09,
	0xbd, 0x86, 0x25, 0x6c, 0x8d, 0x1b, 0xb2, 0x74, 0xc0, 0x5d, 0xc5, 0x76, 0x82, 0x0f, 0x77, 0x4e,
	0x70, 0xbb, 0xef, 0x75, 0xe2, 0xf0, 0x64, 0xb9, 0xb7, 0x04, 0xc0, 0xca, 0x4a, 0xd4, 0xff, 0x9c,
	0x83, 0xf5, 0x73, 0x81, 0x53, 0x89, 0x23, 0xdd, 0x46, 0x6d, 0xa5, 0x04, 0xeb, 0xe7, 0x8a, 0xa2,
	0x53, 0xd8, 0x50, 0x93, 0x7d, 0xdd, 0xc0, 0x34, 0x54, 0xcc, 0xb3, 0x63, 0xd6, 0xa6, 0xd0, 0x03,
	0xac, 0xe8, 0x39, 0x4b, 0x28, 0xfa, 0x11, 0x3e, 0x9d, 0x56, 0xc4, 0x89, 0xb6, 0x58, 0x98, 0xb0,
	0x48, 0x70, 0xf9, 0xde, 0xba, 0x1d, 0xf0, 0xbc, 0x1f, 0x53, 0xab, 0xfa, 0x78, 0x0a, 0x6f, 0x1b,
	0xba, 0x6b, 0x60, 0xd4, 0x86, 0x4f, 0xa2, 0x5c, 0x08, 0x9a, 0x46, 0xce, 0xe2, 0x3e, 0x0d, 0xb5,
	0x54, 0x20, 0xc6, 0xe3, 0x1d, 0x78, 0x18, 0xf1, 0x74, 0x44, 0x85, 0x34, 0x77, 0x33, 0x67, 0x78,
	0x35, 0xd9, 0xea, 0x04, 0x6b, 0x1b, 0x0a, 0x7d, 0x09, 0xf3, 0x5c, 0x10, 0xeb, 0x00, 0x9f, 0x5e,
	0x7b, 0x60, 0xa2, 0x3b, 0x04, 0xfd, 0x00, 0x2b, 0x52, 0x71, 0x41, 0x43, 0x5c, 0x54, 0xc1, 0xf5,
	0x5a, 0x70, 0x57, 0xe5, 0xcf, 0x34, 0x56, 0xd6, 0xae, 0xb7, 0x2c, 0x6f, 0xac, 0xcd, 0x04, 0xc8,
	0xa5, 0xe2, 0x49, 0x38, 0xd2, 0x27, 0xd6, 0x1e, 0x78, 0x4d, 0x00, 0x43, 0x98, 0x45, 0xbd, 0x0b,
	0xcb, 0x37, 0x8f, 0x40, 0xbb, 0x00, 0xf6, 0xae, 0x26, 0xdf, 0x3e, 0x9e, 0x58, 0x30, 0xf1, 0x66,
	0x22, 0xfc, 0x53, 0x81, 0x79, 0xed, 0xd2, 0x03, 0xac, 0x30, 0xfa, 0x09, 0x56, 0x5d, 0xbf, 0x14,
	0xa6, 0x94, 0xb5, 0xca, 0xd3, 0xaa, 0xcf, 0x6b, 0xdf, 0x9c, 0x2a, 0xbd, 0x95, 0xfc, 0xc6, 0x5a,
	0x22, 0x76, 0xd3, 0xc3, 0x93, 0xb4, 0x5a, 0xb7, 0x3d, 0xbf, 0x4b, 0xff, 0xb6, 0xc6, 0xe8, 0xad,
	0xab, 0x5b, 0x76, 0xeb, 0x97, 0xf0, 0xd9, 0xbe, 0x49, 0x18, 0x15, 0x5d, 0xac, 0xa2, 0x6b, 0x7d,
	0xb5, 0x17, 0x4c, 0xaa, 0x2e, 0x55, 0x58, 0xff, 0xf8, 0xa1, 0xaf, 0x60, 0xc1, 0xbc, 0x66, 0xcc,
	0xa4, 0xf2, 0xca, 0xd7, 0x7c, 0xee, 0x24, 0xea, 0xff, 0xce, 0x02, 0x32, 0xe9, 0x3f, 0xc3, 0x31,
	0x95, 0xa5, 0xe2, 0x11, 0xac, 0xc6, 0x7c, 0x8c, 0x63, 0x35, 0x0e, 0x07, 0xc2, 0x39, 0xb6, 0xe2,
	0xd1, 0x46, 0x2b, 0x8e, 0x3a, 0x74, 0x10, 0xba, 0x82, 0xad, 0xe9, 0x34, 0xe5, 0x59, 0xcc, 0x31,
	0x99, 0x68, 0xfa, 0xb4, 0xe6, 0x74, 0x67, 0xbf, 0x32, 0x7c, 0xa9, 0xbe, 0x0b, 0xe0, 0xcc, 0xf7,
	0x33, 0x1d, 0x7b, 0xb5, 0xd4, 0x82, 0x8d, 0xff, 0x9e, 0x8e, 0x51, 0x0a, 0xeb, 0xd3, 0x83, 0x35,
	0x71, 0xef, 0xee, 0x1a, 0xfc, 0x6b, 0xaf, 0xbe, 0x30, 0x59, 0x3b, 0x2f, 0x67, 0x6c, 0x91, 0xbf,
	0x1e, 0x52, 0xef, 0xec, 0xd5, 0x7f, 0x9d, 0x83, 0xed, 0x0f, 0x41, 0xe8, 0x35, 0x6c, 0x61, 0x32,
	0xa2, 0x42, 0x31, 0x5d, 0x4c, 0x97, 0xaa, 0x8f, 0x1b, 0x8e, 0xb5, 0x89, 0x80, 0x4d, 0x55, 0x39,
	0x21, 0x2f, 0x61, 0x73, 0x84, 0x63, 0x46, 0xc2, 0xe9, 0x72, 0x7c, 0x54, 0x1d, 0x6a, 0x86, 0x9f,
	0xf2, 0x6d, 0x59, 0x86, 0x1e, 0x3c, 0xd2, 0x39, 0x4c, 0xa9, 0x08, 0x13, 0x6d, 0xd0, 0x89, 0x6e,
	0xd5, 0x43, 0x77, 0xdd, 0xb1, 0xc6, 0xdb, 0xa5, 0xe6, 0x39, 0x3c, 0x2e, 0x34, 0xdf, 0x36, 0xcd,
	0x9c, 0x87, 0xe8, 0x86, 0x83, 0xdf, 0x32, 0xcc, 0x4b, 0xd8, 0xe8, 0x0b, 0x46, 0x86, 0x34, 0x4c,
	0x70, 0x16, 0x16, 0x23, 0xd9, 0x73, 0x98, 0x22, 0x8b, 0x76, 0x71, 0x76, 0x61, 0xc1, 0x0e, 0x41,
	0x2d, 0x80, 0xe2, 0x9a, 0x8c, 0xb8, 0x91, 0xba, 0xf5, 0x8e, 0x4a, 0x27, 0x55, 0x3b, 0xcf, 0x9d,
	0x01, 0x5d, 0x78, 0x87, 0xec, 0xfd, 0x5f, 0x81, 0x7a, 0xc4, 0x93, 0x3b, 0x8c, 0xb6, 0xb7, 0x3e,
	0xf5, 0xdb, 0xab, 0xa7, 0xda, 0xa9, 0x56, 0x3d, 0xad, 0x5c, 0x1e, 0x38, 0x6e, 0xc8, 0x63, 0x9c,
	0x0e, 0x03, 0x2e, 0x86, 0x8d, 0x21, 0x4d, 0xcd, 0x99, 0xc5, 0x9f, 0xe6, 0x8c, 0xc9, 0xf7, 0xfd,
	0x87, 0xde, 0xb5, 0x1f, 0x7f, 0xcc, 0x56, 0x8f, 0xda, 0xed, 0xbf, 0x66, 0x9f, 0x1c, 0x59, 0xb1,
	0x36, 0x91, 0x81, 0x7d, 0xd4, 0x4f, 0x17, 0xcd, 0x60, 0xdf, 0x84, 0xfd, 0x5d, 0x04, 0x5c, 0xb5,
	0x89, 0xbc, 0x2a, 0x03, 0xae, 0x2e, 0x9a, 0x57, 0x36, 0xe0, 0xbf, 0xd9, 0xba, 0xdd, 0x6d, 0xb5,
	0xda, 0x44, 0xb6, 0x5a, 0x65, 0x48, 0xab, 0x75, 0xd1, 0x6c, 0xb5, 0x6c, 0x50, 0xff, 0xbe, 0xb9,
	0x5d, 0xf3, 0x4d, 0x00, 0x00, 0x00, 0xff, 0xff, 0x27, 0x9c, 0xe1, 0x96, 0xe0, 0x0b, 0x00, 0x00,
}
