// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/google_ads_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [GoogleAdsService.Search][google.ads.googleads.v3.services.GoogleAdsService.Search].
type SearchGoogleAdsRequest struct {
	// Required. The ID of the customer being queried.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The query string.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request
	// the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When too large a page is requested, the server may decide to
	// further limit the number of returned resources.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If true, the request is validated but not executed.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If true, the total number of results that match the query ignoring the
	// LIMIT clause will be included in the response.
	// Default is false.
	ReturnTotalResultsCount bool `protobuf:"varint,7,opt,name=return_total_results_count,json=returnTotalResultsCount,proto3" json:"return_total_results_count,omitempty"`
	// Determines whether a summary row will be returned. By default, summary row
	// is not returned. If requested, the summary row will be sent in a response
	// by itself after all other query results are returned.
	SummaryRowSetting    enums.SummaryRowSettingEnum_SummaryRowSetting `protobuf:"varint,8,opt,name=summary_row_setting,json=summaryRowSetting,proto3,enum=google.ads.googleads.v3.enums.SummaryRowSettingEnum_SummaryRowSetting" json:"summary_row_setting,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *SearchGoogleAdsRequest) Reset()         { *m = SearchGoogleAdsRequest{} }
func (m *SearchGoogleAdsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchGoogleAdsRequest) ProtoMessage()    {}
func (*SearchGoogleAdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_da24cac89ef496be, []int{0}
}

func (m *SearchGoogleAdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchGoogleAdsRequest.Unmarshal(m, b)
}
func (m *SearchGoogleAdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchGoogleAdsRequest.Marshal(b, m, deterministic)
}
func (m *SearchGoogleAdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchGoogleAdsRequest.Merge(m, src)
}
func (m *SearchGoogleAdsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchGoogleAdsRequest.Size(m)
}
func (m *SearchGoogleAdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchGoogleAdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchGoogleAdsRequest proto.InternalMessageInfo

func (m *SearchGoogleAdsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *SearchGoogleAdsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchGoogleAdsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchGoogleAdsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchGoogleAdsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

func (m *SearchGoogleAdsRequest) GetReturnTotalResultsCount() bool {
	if m != nil {
		return m.ReturnTotalResultsCount
	}
	return false
}

func (m *SearchGoogleAdsRequest) GetSummaryRowSetting() enums.SummaryRowSettingEnum_SummaryRowSetting {
	if m != nil {
		return m.SummaryRowSetting
	}
	return enums.SummaryRowSettingEnum_UNSPECIFIED
}

// Response message for [GoogleAdsService.Search][google.ads.googleads.v3.services.GoogleAdsService.Search].
type SearchGoogleAdsResponse struct {
	// The list of rows that matched the query.
	Results []*GoogleAdsRow `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of results that match the query ignoring the LIMIT
	// clause.
	TotalResultsCount int64 `protobuf:"varint,3,opt,name=total_results_count,json=totalResultsCount,proto3" json:"total_results_count,omitempty"`
	// FieldMask that represents what fields were requested by the user.
	FieldMask *field_mask.FieldMask `protobuf:"bytes,5,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Summary row that contains summary of metrics in results.
	// Summary of metrics means aggregation of metrics across all results,
	// here aggregation could be sum, average, rate, etc.
	SummaryRow           *GoogleAdsRow `protobuf:"bytes,6,opt,name=summary_row,json=summaryRow,proto3" json:"summary_row,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SearchGoogleAdsResponse) Reset()         { *m = SearchGoogleAdsResponse{} }
func (m *SearchGoogleAdsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchGoogleAdsResponse) ProtoMessage()    {}
func (*SearchGoogleAdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_da24cac89ef496be, []int{1}
}

func (m *SearchGoogleAdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchGoogleAdsResponse.Unmarshal(m, b)
}
func (m *SearchGoogleAdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchGoogleAdsResponse.Marshal(b, m, deterministic)
}
func (m *SearchGoogleAdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchGoogleAdsResponse.Merge(m, src)
}
func (m *SearchGoogleAdsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchGoogleAdsResponse.Size(m)
}
func (m *SearchGoogleAdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchGoogleAdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchGoogleAdsResponse proto.InternalMessageInfo

func (m *SearchGoogleAdsResponse) GetResults() []*GoogleAdsRow {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchGoogleAdsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *SearchGoogleAdsResponse) GetTotalResultsCount() int64 {
	if m != nil {
		return m.TotalResultsCount
	}
	return 0
}

func (m *SearchGoogleAdsResponse) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

func (m *SearchGoogleAdsResponse) GetSummaryRow() *GoogleAdsRow {
	if m != nil {
		return m.SummaryRow
	}
	return nil
}

// Request message for [GoogleAdsService.SearchStream][google.ads.googleads.v3.services.GoogleAdsService.SearchStream].
type SearchGoogleAdsStreamRequest struct {
	// Required. The ID of the customer being queried.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The query string.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Determines whether a summary row will be returned. By default, summary row
	// is not returned. If requested, the summary row will be sent in a response
	// by itself after all other query results are returned.
	SummaryRowSetting    enums.SummaryRowSettingEnum_SummaryRowSetting `protobuf:"varint,3,opt,name=summary_row_setting,json=summaryRowSetting,proto3,enum=google.ads.googleads.v3.enums.SummaryRowSettingEnum_SummaryRowSetting" json:"summary_row_setting,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *SearchGoogleAdsStreamRequest) Reset()         { *m = SearchGoogleAdsStreamRequest{} }
func (m *SearchGoogleAdsStreamRequest) String() string { return proto.CompactTextString(m) }
func (*SearchGoogleAdsStreamRequest) ProtoMessage()    {}
func (*SearchGoogleAdsStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_da24cac89ef496be, []int{2}
}

func (m *SearchGoogleAdsStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchGoogleAdsStreamRequest.Unmarshal(m, b)
}
func (m *SearchGoogleAdsStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchGoogleAdsStreamRequest.Marshal(b, m, deterministic)
}
func (m *SearchGoogleAdsStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchGoogleAdsStreamRequest.Merge(m, src)
}
func (m *SearchGoogleAdsStreamRequest) XXX_Size() int {
	return xxx_messageInfo_SearchGoogleAdsStreamRequest.Size(m)
}
func (m *SearchGoogleAdsStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchGoogleAdsStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchGoogleAdsStreamRequest proto.InternalMessageInfo

func (m *SearchGoogleAdsStreamRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *SearchGoogleAdsStreamRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchGoogleAdsStreamRequest) GetSummaryRowSetting() enums.SummaryRowSettingEnum_SummaryRowSetting {
	if m != nil {
		return m.SummaryRowSetting
	}
	return enums.SummaryRowSettingEnum_UNSPECIFIED
}

// Response message for [GoogleAdsService.SearchStream][google.ads.googleads.v3.services.GoogleAdsService.SearchStream].
type SearchGoogleAdsStreamResponse struct {
	// The list of rows that matched the query.
	Results []*GoogleAdsRow `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// FieldMask that represents what fields were requested by the user.
	FieldMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Summary row that contains summary of metrics in results.
	// Summary of metrics means aggregation of metrics across all results,
	// here aggregation could be sum, average, rate, etc.
	SummaryRow           *GoogleAdsRow `protobuf:"bytes,3,opt,name=summary_row,json=summaryRow,proto3" json:"summary_row,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SearchGoogleAdsStreamResponse) Reset()         { *m = SearchGoogleAdsStreamResponse{} }
func (m *SearchGoogleAdsStreamResponse) String() string { return proto.CompactTextString(m) }
func (*SearchGoogleAdsStreamResponse) ProtoMessage()    {}
func (*SearchGoogleAdsStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_da24cac89ef496be, []int{3}
}

func (m *SearchGoogleAdsStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchGoogleAdsStreamResponse.Unmarshal(m, b)
}
func (m *SearchGoogleAdsStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchGoogleAdsStreamResponse.Marshal(b, m, deterministic)
}
func (m *SearchGoogleAdsStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchGoogleAdsStreamResponse.Merge(m, src)
}
func (m *SearchGoogleAdsStreamResponse) XXX_Size() int {
	return xxx_messageInfo_SearchGoogleAdsStreamResponse.Size(m)
}
func (m *SearchGoogleAdsStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchGoogleAdsStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchGoogleAdsStreamResponse proto.InternalMessageInfo

func (m *SearchGoogleAdsStreamResponse) GetResults() []*GoogleAdsRow {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchGoogleAdsStreamResponse) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

func (m *SearchGoogleAdsStreamResponse) GetSummaryRow() *GoogleAdsRow {
	if m != nil {
		return m.SummaryRow
	}
	return nil
}

// A returned row from the query.
type GoogleAdsRow struct {
	// The account budget in the query.
	AccountBudget *resources.AccountBudget `protobuf:"bytes,42,opt,name=account_budget,json=accountBudget,proto3" json:"account_budget,omitempty"`
	// The account budget proposal referenced in the query.
	AccountBudgetProposal *resources.AccountBudgetProposal `protobuf:"bytes,43,opt,name=account_budget_proposal,json=accountBudgetProposal,proto3" json:"account_budget_proposal,omitempty"`
	// The ad group referenced in the query.
	AdGroup *resources.AdGroup `protobuf:"bytes,3,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The ad referenced in the query.
	AdGroupAd *resources.AdGroupAd `protobuf:"bytes,16,opt,name=ad_group_ad,json=adGroupAd,proto3" json:"ad_group_ad,omitempty"`
	// The ad group ad asset view in the query.
	AdGroupAdAssetView *resources.AdGroupAdAssetView `protobuf:"bytes,131,opt,name=ad_group_ad_asset_view,json=adGroupAdAssetView,proto3" json:"ad_group_ad_asset_view,omitempty"`
	// The ad group ad label referenced in the query.
	AdGroupAdLabel *resources.AdGroupAdLabel `protobuf:"bytes,120,opt,name=ad_group_ad_label,json=adGroupAdLabel,proto3" json:"ad_group_ad_label,omitempty"`
	// The ad group audience view referenced in the query.
	AdGroupAudienceView *resources.AdGroupAudienceView `protobuf:"bytes,57,opt,name=ad_group_audience_view,json=adGroupAudienceView,proto3" json:"ad_group_audience_view,omitempty"`
	// The bid modifier referenced in the query.
	AdGroupBidModifier *resources.AdGroupBidModifier `protobuf:"bytes,24,opt,name=ad_group_bid_modifier,json=adGroupBidModifier,proto3" json:"ad_group_bid_modifier,omitempty"`
	// The criterion referenced in the query.
	AdGroupCriterion *resources.AdGroupCriterion `protobuf:"bytes,17,opt,name=ad_group_criterion,json=adGroupCriterion,proto3" json:"ad_group_criterion,omitempty"`
	// The ad group criterion label referenced in the query.
	AdGroupCriterionLabel *resources.AdGroupCriterionLabel `protobuf:"bytes,121,opt,name=ad_group_criterion_label,json=adGroupCriterionLabel,proto3" json:"ad_group_criterion_label,omitempty"`
	// The ad group criterion simulation referenced in the query.
	AdGroupCriterionSimulation *resources.AdGroupCriterionSimulation `protobuf:"bytes,110,opt,name=ad_group_criterion_simulation,json=adGroupCriterionSimulation,proto3" json:"ad_group_criterion_simulation,omitempty"`
	// The ad group extension setting referenced in the query.
	AdGroupExtensionSetting *resources.AdGroupExtensionSetting `protobuf:"bytes,112,opt,name=ad_group_extension_setting,json=adGroupExtensionSetting,proto3" json:"ad_group_extension_setting,omitempty"`
	// The ad group feed referenced in the query.
	AdGroupFeed *resources.AdGroupFeed `protobuf:"bytes,67,opt,name=ad_group_feed,json=adGroupFeed,proto3" json:"ad_group_feed,omitempty"`
	// The ad group label referenced in the query.
	AdGroupLabel *resources.AdGroupLabel `protobuf:"bytes,115,opt,name=ad_group_label,json=adGroupLabel,proto3" json:"ad_group_label,omitempty"`
	// The ad group simulation referenced in the query.
	AdGroupSimulation *resources.AdGroupSimulation `protobuf:"bytes,107,opt,name=ad_group_simulation,json=adGroupSimulation,proto3" json:"ad_group_simulation,omitempty"`
	// The ad parameter referenced in the query.
	AdParameter *resources.AdParameter `protobuf:"bytes,130,opt,name=ad_parameter,json=adParameter,proto3" json:"ad_parameter,omitempty"`
	// The age range view referenced in the query.
	AgeRangeView *resources.AgeRangeView `protobuf:"bytes,48,opt,name=age_range_view,json=ageRangeView,proto3" json:"age_range_view,omitempty"`
	// The ad schedule view referenced in the query.
	AdScheduleView *resources.AdScheduleView `protobuf:"bytes,89,opt,name=ad_schedule_view,json=adScheduleView,proto3" json:"ad_schedule_view,omitempty"`
	// The domain category referenced in the query.
	DomainCategory *resources.DomainCategory `protobuf:"bytes,91,opt,name=domain_category,json=domainCategory,proto3" json:"domain_category,omitempty"`
	// The asset referenced in the query.
	Asset *resources.Asset `protobuf:"bytes,105,opt,name=asset,proto3" json:"asset,omitempty"`
	// The bidding strategy referenced in the query.
	BiddingStrategy *resources.BiddingStrategy `protobuf:"bytes,18,opt,name=bidding_strategy,json=biddingStrategy,proto3" json:"bidding_strategy,omitempty"`
	// The billing setup referenced in the query.
	BillingSetup *resources.BillingSetup `protobuf:"bytes,41,opt,name=billing_setup,json=billingSetup,proto3" json:"billing_setup,omitempty"`
	// The campaign budget referenced in the query.
	CampaignBudget *resources.CampaignBudget `protobuf:"bytes,19,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// The campaign referenced in the query.
	Campaign *resources.Campaign `protobuf:"bytes,2,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// The campaign audience view referenced in the query.
	CampaignAudienceView *resources.CampaignAudienceView `protobuf:"bytes,69,opt,name=campaign_audience_view,json=campaignAudienceView,proto3" json:"campaign_audience_view,omitempty"`
	// The campaign bid modifier referenced in the query.
	CampaignBidModifier *resources.CampaignBidModifier `protobuf:"bytes,26,opt,name=campaign_bid_modifier,json=campaignBidModifier,proto3" json:"campaign_bid_modifier,omitempty"`
	// The campaign criterion referenced in the query.
	CampaignCriterion *resources.CampaignCriterion `protobuf:"bytes,20,opt,name=campaign_criterion,json=campaignCriterion,proto3" json:"campaign_criterion,omitempty"`
	// The campaign criterion simulation referenced in the query.
	CampaignCriterionSimulation *resources.CampaignCriterionSimulation `protobuf:"bytes,111,opt,name=campaign_criterion_simulation,json=campaignCriterionSimulation,proto3" json:"campaign_criterion_simulation,omitempty"`
	// The campaign draft referenced in the query.
	CampaignDraft *resources.CampaignDraft `protobuf:"bytes,49,opt,name=campaign_draft,json=campaignDraft,proto3" json:"campaign_draft,omitempty"`
	// The campaign experiment referenced in the query.
	CampaignExperiment *resources.CampaignExperiment `protobuf:"bytes,84,opt,name=campaign_experiment,json=campaignExperiment,proto3" json:"campaign_experiment,omitempty"`
	// The campaign extension setting referenced in the query.
	CampaignExtensionSetting *resources.CampaignExtensionSetting `protobuf:"bytes,113,opt,name=campaign_extension_setting,json=campaignExtensionSetting,proto3" json:"campaign_extension_setting,omitempty"`
	// The campaign feed referenced in the query.
	CampaignFeed *resources.CampaignFeed `protobuf:"bytes,63,opt,name=campaign_feed,json=campaignFeed,proto3" json:"campaign_feed,omitempty"`
	// The campaign label referenced in the query.
	CampaignLabel *resources.CampaignLabel `protobuf:"bytes,108,opt,name=campaign_label,json=campaignLabel,proto3" json:"campaign_label,omitempty"`
	// Campaign Shared Set referenced in AWQL query.
	CampaignSharedSet *resources.CampaignSharedSet `protobuf:"bytes,30,opt,name=campaign_shared_set,json=campaignSharedSet,proto3" json:"campaign_shared_set,omitempty"`
	// The carrier constant referenced in the query.
	CarrierConstant *resources.CarrierConstant `protobuf:"bytes,66,opt,name=carrier_constant,json=carrierConstant,proto3" json:"carrier_constant,omitempty"`
	// The ChangeStatus referenced in the query.
	ChangeStatus *resources.ChangeStatus `protobuf:"bytes,37,opt,name=change_status,json=changeStatus,proto3" json:"change_status,omitempty"`
	// The conversion action referenced in the query.
	ConversionAction *resources.ConversionAction `protobuf:"bytes,103,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The ClickView referenced in the query.
	ClickView *resources.ClickView `protobuf:"bytes,122,opt,name=click_view,json=clickView,proto3" json:"click_view,omitempty"`
	// The currency constant referenced in the query.
	CurrencyConstant *resources.CurrencyConstant `protobuf:"bytes,134,opt,name=currency_constant,json=currencyConstant,proto3" json:"currency_constant,omitempty"`
	// The CustomInterest referenced in the query.
	CustomInterest *resources.CustomInterest `protobuf:"bytes,104,opt,name=custom_interest,json=customInterest,proto3" json:"custom_interest,omitempty"`
	// The customer referenced in the query.
	Customer *resources.Customer `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// The CustomerManagerLink referenced in the query.
	CustomerManagerLink *resources.CustomerManagerLink `protobuf:"bytes,61,opt,name=customer_manager_link,json=customerManagerLink,proto3" json:"customer_manager_link,omitempty"`
	// The CustomerClientLink referenced in the query.
	CustomerClientLink *resources.CustomerClientLink `protobuf:"bytes,62,opt,name=customer_client_link,json=customerClientLink,proto3" json:"customer_client_link,omitempty"`
	// The CustomerClient referenced in the query.
	CustomerClient *resources.CustomerClient `protobuf:"bytes,70,opt,name=customer_client,json=customerClient,proto3" json:"customer_client,omitempty"`
	// The customer extension setting referenced in the query.
	CustomerExtensionSetting *resources.CustomerExtensionSetting `protobuf:"bytes,114,opt,name=customer_extension_setting,json=customerExtensionSetting,proto3" json:"customer_extension_setting,omitempty"`
	// The customer feed referenced in the query.
	CustomerFeed *resources.CustomerFeed `protobuf:"bytes,64,opt,name=customer_feed,json=customerFeed,proto3" json:"customer_feed,omitempty"`
	// The customer label referenced in the query.
	CustomerLabel *resources.CustomerLabel `protobuf:"bytes,124,opt,name=customer_label,json=customerLabel,proto3" json:"customer_label,omitempty"`
	// The customer negative criterion referenced in the query.
	CustomerNegativeCriterion *resources.CustomerNegativeCriterion `protobuf:"bytes,88,opt,name=customer_negative_criterion,json=customerNegativeCriterion,proto3" json:"customer_negative_criterion,omitempty"`
	// The detail placement view referenced in the query.
	DetailPlacementView *resources.DetailPlacementView `protobuf:"bytes,118,opt,name=detail_placement_view,json=detailPlacementView,proto3" json:"detail_placement_view,omitempty"`
	// The display keyword view referenced in the query.
	DisplayKeywordView *resources.DisplayKeywordView `protobuf:"bytes,47,opt,name=display_keyword_view,json=displayKeywordView,proto3" json:"display_keyword_view,omitempty"`
	// The distance view referenced in the query.
	DistanceView *resources.DistanceView `protobuf:"bytes,132,opt,name=distance_view,json=distanceView,proto3" json:"distance_view,omitempty"`
	// The dynamic search ads search term view referenced in the query.
	DynamicSearchAdsSearchTermView *resources.DynamicSearchAdsSearchTermView `protobuf:"bytes,106,opt,name=dynamic_search_ads_search_term_view,json=dynamicSearchAdsSearchTermView,proto3" json:"dynamic_search_ads_search_term_view,omitempty"`
	// The expanded landing page view referenced in the query.
	ExpandedLandingPageView *resources.ExpandedLandingPageView `protobuf:"bytes,128,opt,name=expanded_landing_page_view,json=expandedLandingPageView,proto3" json:"expanded_landing_page_view,omitempty"`
	// The extension feed item referenced in the query.
	ExtensionFeedItem *resources.ExtensionFeedItem `protobuf:"bytes,85,opt,name=extension_feed_item,json=extensionFeedItem,proto3" json:"extension_feed_item,omitempty"`
	// The feed referenced in the query.
	Feed *resources.Feed `protobuf:"bytes,46,opt,name=feed,proto3" json:"feed,omitempty"`
	// The feed item referenced in the query.
	FeedItem *resources.FeedItem `protobuf:"bytes,50,opt,name=feed_item,json=feedItem,proto3" json:"feed_item,omitempty"`
	// The feed item target referenced in the query.
	FeedItemTarget *resources.FeedItemTarget `protobuf:"bytes,116,opt,name=feed_item_target,json=feedItemTarget,proto3" json:"feed_item_target,omitempty"`
	// The feed mapping referenced in the query.
	FeedMapping *resources.FeedMapping `protobuf:"bytes,58,opt,name=feed_mapping,json=feedMapping,proto3" json:"feed_mapping,omitempty"`
	// The feed placeholder view referenced in the query.
	FeedPlaceholderView *resources.FeedPlaceholderView `protobuf:"bytes,97,opt,name=feed_placeholder_view,json=feedPlaceholderView,proto3" json:"feed_placeholder_view,omitempty"`
	// The gender view referenced in the query.
	GenderView *resources.GenderView `protobuf:"bytes,40,opt,name=gender_view,json=genderView,proto3" json:"gender_view,omitempty"`
	// The geo target constant referenced in the query.
	GeoTargetConstant *resources.GeoTargetConstant `protobuf:"bytes,23,opt,name=geo_target_constant,json=geoTargetConstant,proto3" json:"geo_target_constant,omitempty"`
	// The geographic view referenced in the query.
	GeographicView *resources.GeographicView `protobuf:"bytes,125,opt,name=geographic_view,json=geographicView,proto3" json:"geographic_view,omitempty"`
	// The group placement view referenced in the query.
	GroupPlacementView *resources.GroupPlacementView `protobuf:"bytes,119,opt,name=group_placement_view,json=groupPlacementView,proto3" json:"group_placement_view,omitempty"`
	// The hotel group view referenced in the query.
	HotelGroupView *resources.HotelGroupView `protobuf:"bytes,51,opt,name=hotel_group_view,json=hotelGroupView,proto3" json:"hotel_group_view,omitempty"`
	// The hotel performance view referenced in the query.
	HotelPerformanceView *resources.HotelPerformanceView `protobuf:"bytes,71,opt,name=hotel_performance_view,json=hotelPerformanceView,proto3" json:"hotel_performance_view,omitempty"`
	// The keyword view referenced in the query.
	KeywordView *resources.KeywordView `protobuf:"bytes,21,opt,name=keyword_view,json=keywordView,proto3" json:"keyword_view,omitempty"`
	// The keyword plan referenced in the query.
	KeywordPlan *resources.KeywordPlan `protobuf:"bytes,32,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
	// The keyword plan campaign referenced in the query.
	KeywordPlanCampaign *resources.KeywordPlanCampaign `protobuf:"bytes,33,opt,name=keyword_plan_campaign,json=keywordPlanCampaign,proto3" json:"keyword_plan_campaign,omitempty"`
	// The keyword plan negative keyword referenced in the query.
	KeywordPlanNegativeKeyword *resources.KeywordPlanNegativeKeyword `protobuf:"bytes,34,opt,name=keyword_plan_negative_keyword,json=keywordPlanNegativeKeyword,proto3" json:"keyword_plan_negative_keyword,omitempty"`
	// The keyword plan ad group referenced in the query.
	KeywordPlanAdGroup *resources.KeywordPlanAdGroup `protobuf:"bytes,35,opt,name=keyword_plan_ad_group,json=keywordPlanAdGroup,proto3" json:"keyword_plan_ad_group,omitempty"`
	// The keyword plan keyword referenced in the query.
	KeywordPlanKeyword *resources.KeywordPlanKeyword `protobuf:"bytes,36,opt,name=keyword_plan_keyword,json=keywordPlanKeyword,proto3" json:"keyword_plan_keyword,omitempty"`
	// The label referenced in the query.
	Label *resources.Label `protobuf:"bytes,52,opt,name=label,proto3" json:"label,omitempty"`
	// The landing page view referenced in the query.
	LandingPageView *resources.LandingPageView `protobuf:"bytes,126,opt,name=landing_page_view,json=landingPageView,proto3" json:"landing_page_view,omitempty"`
	// The language constant referenced in the query.
	LanguageConstant *resources.LanguageConstant `protobuf:"bytes,55,opt,name=language_constant,json=languageConstant,proto3" json:"language_constant,omitempty"`
	// The location view referenced in the query.
	LocationView *resources.LocationView `protobuf:"bytes,123,opt,name=location_view,json=locationView,proto3" json:"location_view,omitempty"`
	// The managed placement view referenced in the query.
	ManagedPlacementView *resources.ManagedPlacementView `protobuf:"bytes,53,opt,name=managed_placement_view,json=managedPlacementView,proto3" json:"managed_placement_view,omitempty"`
	// The media file referenced in the query.
	MediaFile *resources.MediaFile `protobuf:"bytes,90,opt,name=media_file,json=mediaFile,proto3" json:"media_file,omitempty"`
	// The mobile app category constant referenced in the query.
	MobileAppCategoryConstant *resources.MobileAppCategoryConstant `protobuf:"bytes,87,opt,name=mobile_app_category_constant,json=mobileAppCategoryConstant,proto3" json:"mobile_app_category_constant,omitempty"`
	// The mobile device constant referenced in the query.
	MobileDeviceConstant *resources.MobileDeviceConstant `protobuf:"bytes,98,opt,name=mobile_device_constant,json=mobileDeviceConstant,proto3" json:"mobile_device_constant,omitempty"`
	// The mutate job referenced in the query.
	MutateJob *resources.MutateJob `protobuf:"bytes,127,opt,name=mutate_job,json=mutateJob,proto3" json:"mutate_job,omitempty"`
	// The offline user data job referenced in the query.
	OfflineUserDataJob *resources.OfflineUserDataJob `protobuf:"bytes,137,opt,name=offline_user_data_job,json=offlineUserDataJob,proto3" json:"offline_user_data_job,omitempty"`
	// The operating system version constant referenced in the query.
	OperatingSystemVersionConstant *resources.OperatingSystemVersionConstant `protobuf:"bytes,86,opt,name=operating_system_version_constant,json=operatingSystemVersionConstant,proto3" json:"operating_system_version_constant,omitempty"`
	// The paid organic search term view referenced in the query.
	PaidOrganicSearchTermView *resources.PaidOrganicSearchTermView `protobuf:"bytes,129,opt,name=paid_organic_search_term_view,json=paidOrganicSearchTermView,proto3" json:"paid_organic_search_term_view,omitempty"`
	// The parental status view referenced in the query.
	ParentalStatusView *resources.ParentalStatusView `protobuf:"bytes,45,opt,name=parental_status_view,json=parentalStatusView,proto3" json:"parental_status_view,omitempty"`
	// The Product Bidding Category referenced in the query.
	ProductBiddingCategoryConstant *resources.ProductBiddingCategoryConstant `protobuf:"bytes,109,opt,name=product_bidding_category_constant,json=productBiddingCategoryConstant,proto3" json:"product_bidding_category_constant,omitempty"`
	// The product group view referenced in the query.
	ProductGroupView *resources.ProductGroupView `protobuf:"bytes,54,opt,name=product_group_view,json=productGroupView,proto3" json:"product_group_view,omitempty"`
	// The recommendation referenced in the query.
	Recommendation *resources.Recommendation `protobuf:"bytes,22,opt,name=recommendation,proto3" json:"recommendation,omitempty"`
	// The search term view referenced in the query.
	SearchTermView *resources.SearchTermView `protobuf:"bytes,68,opt,name=search_term_view,json=searchTermView,proto3" json:"search_term_view,omitempty"`
	// The shared set referenced in the query.
	SharedCriterion *resources.SharedCriterion `protobuf:"bytes,29,opt,name=shared_criterion,json=sharedCriterion,proto3" json:"shared_criterion,omitempty"`
	// The shared set referenced in the query.
	SharedSet *resources.SharedSet `protobuf:"bytes,27,opt,name=shared_set,json=sharedSet,proto3" json:"shared_set,omitempty"`
	// The shopping performance view referenced in the query.
	ShoppingPerformanceView *resources.ShoppingPerformanceView `protobuf:"bytes,117,opt,name=shopping_performance_view,json=shoppingPerformanceView,proto3" json:"shopping_performance_view,omitempty"`
	// The topic view referenced in the query.
	TopicView *resources.TopicView `protobuf:"bytes,44,opt,name=topic_view,json=topicView,proto3" json:"topic_view,omitempty"`
	// The user interest referenced in the query.
	UserInterest *resources.UserInterest `protobuf:"bytes,59,opt,name=user_interest,json=userInterest,proto3" json:"user_interest,omitempty"`
	// The user list referenced in the query.
	UserList *resources.UserList `protobuf:"bytes,38,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
	// The user location view referenced in the query.
	UserLocationView *resources.UserLocationView `protobuf:"bytes,135,opt,name=user_location_view,json=userLocationView,proto3" json:"user_location_view,omitempty"`
	// The remarketing action referenced in the query.
	RemarketingAction *resources.RemarketingAction `protobuf:"bytes,60,opt,name=remarketing_action,json=remarketingAction,proto3" json:"remarketing_action,omitempty"`
	// The topic constant referenced in the query.
	TopicConstant *resources.TopicConstant `protobuf:"bytes,31,opt,name=topic_constant,json=topicConstant,proto3" json:"topic_constant,omitempty"`
	// The video referenced in the query.
	Video *resources.Video `protobuf:"bytes,39,opt,name=video,proto3" json:"video,omitempty"`
	// The metrics.
	Metrics *common.Metrics `protobuf:"bytes,4,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// The segments.
	Segments             *common.Segments `protobuf:"bytes,102,opt,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GoogleAdsRow) Reset()         { *m = GoogleAdsRow{} }
func (m *GoogleAdsRow) String() string { return proto.CompactTextString(m) }
func (*GoogleAdsRow) ProtoMessage()    {}
func (*GoogleAdsRow) Descriptor() ([]byte, []int) {
	return fileDescriptor_da24cac89ef496be, []int{4}
}

func (m *GoogleAdsRow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GoogleAdsRow.Unmarshal(m, b)
}
func (m *GoogleAdsRow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GoogleAdsRow.Marshal(b, m, deterministic)
}
func (m *GoogleAdsRow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GoogleAdsRow.Merge(m, src)
}
func (m *GoogleAdsRow) XXX_Size() int {
	return xxx_messageInfo_GoogleAdsRow.Size(m)
}
func (m *GoogleAdsRow) XXX_DiscardUnknown() {
	xxx_messageInfo_GoogleAdsRow.DiscardUnknown(m)
}

var xxx_messageInfo_GoogleAdsRow proto.InternalMessageInfo

func (m *GoogleAdsRow) GetAccountBudget() *resources.AccountBudget {
	if m != nil {
		return m.AccountBudget
	}
	return nil
}

func (m *GoogleAdsRow) GetAccountBudgetProposal() *resources.AccountBudgetProposal {
	if m != nil {
		return m.AccountBudgetProposal
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroup() *resources.AdGroup {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupAd() *resources.AdGroupAd {
	if m != nil {
		return m.AdGroupAd
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupAdAssetView() *resources.AdGroupAdAssetView {
	if m != nil {
		return m.AdGroupAdAssetView
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupAdLabel() *resources.AdGroupAdLabel {
	if m != nil {
		return m.AdGroupAdLabel
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupAudienceView() *resources.AdGroupAudienceView {
	if m != nil {
		return m.AdGroupAudienceView
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupBidModifier() *resources.AdGroupBidModifier {
	if m != nil {
		return m.AdGroupBidModifier
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupCriterion() *resources.AdGroupCriterion {
	if m != nil {
		return m.AdGroupCriterion
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupCriterionLabel() *resources.AdGroupCriterionLabel {
	if m != nil {
		return m.AdGroupCriterionLabel
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupCriterionSimulation() *resources.AdGroupCriterionSimulation {
	if m != nil {
		return m.AdGroupCriterionSimulation
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupExtensionSetting() *resources.AdGroupExtensionSetting {
	if m != nil {
		return m.AdGroupExtensionSetting
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupFeed() *resources.AdGroupFeed {
	if m != nil {
		return m.AdGroupFeed
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupLabel() *resources.AdGroupLabel {
	if m != nil {
		return m.AdGroupLabel
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupSimulation() *resources.AdGroupSimulation {
	if m != nil {
		return m.AdGroupSimulation
	}
	return nil
}

func (m *GoogleAdsRow) GetAdParameter() *resources.AdParameter {
	if m != nil {
		return m.AdParameter
	}
	return nil
}

func (m *GoogleAdsRow) GetAgeRangeView() *resources.AgeRangeView {
	if m != nil {
		return m.AgeRangeView
	}
	return nil
}

func (m *GoogleAdsRow) GetAdScheduleView() *resources.AdScheduleView {
	if m != nil {
		return m.AdScheduleView
	}
	return nil
}

func (m *GoogleAdsRow) GetDomainCategory() *resources.DomainCategory {
	if m != nil {
		return m.DomainCategory
	}
	return nil
}

func (m *GoogleAdsRow) GetAsset() *resources.Asset {
	if m != nil {
		return m.Asset
	}
	return nil
}

func (m *GoogleAdsRow) GetBiddingStrategy() *resources.BiddingStrategy {
	if m != nil {
		return m.BiddingStrategy
	}
	return nil
}

func (m *GoogleAdsRow) GetBillingSetup() *resources.BillingSetup {
	if m != nil {
		return m.BillingSetup
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignBudget() *resources.CampaignBudget {
	if m != nil {
		return m.CampaignBudget
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaign() *resources.Campaign {
	if m != nil {
		return m.Campaign
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignAudienceView() *resources.CampaignAudienceView {
	if m != nil {
		return m.CampaignAudienceView
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignBidModifier() *resources.CampaignBidModifier {
	if m != nil {
		return m.CampaignBidModifier
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignCriterion() *resources.CampaignCriterion {
	if m != nil {
		return m.CampaignCriterion
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignCriterionSimulation() *resources.CampaignCriterionSimulation {
	if m != nil {
		return m.CampaignCriterionSimulation
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignDraft() *resources.CampaignDraft {
	if m != nil {
		return m.CampaignDraft
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignExperiment() *resources.CampaignExperiment {
	if m != nil {
		return m.CampaignExperiment
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignExtensionSetting() *resources.CampaignExtensionSetting {
	if m != nil {
		return m.CampaignExtensionSetting
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignFeed() *resources.CampaignFeed {
	if m != nil {
		return m.CampaignFeed
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignLabel() *resources.CampaignLabel {
	if m != nil {
		return m.CampaignLabel
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignSharedSet() *resources.CampaignSharedSet {
	if m != nil {
		return m.CampaignSharedSet
	}
	return nil
}

func (m *GoogleAdsRow) GetCarrierConstant() *resources.CarrierConstant {
	if m != nil {
		return m.CarrierConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetChangeStatus() *resources.ChangeStatus {
	if m != nil {
		return m.ChangeStatus
	}
	return nil
}

func (m *GoogleAdsRow) GetConversionAction() *resources.ConversionAction {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *GoogleAdsRow) GetClickView() *resources.ClickView {
	if m != nil {
		return m.ClickView
	}
	return nil
}

func (m *GoogleAdsRow) GetCurrencyConstant() *resources.CurrencyConstant {
	if m != nil {
		return m.CurrencyConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomInterest() *resources.CustomInterest {
	if m != nil {
		return m.CustomInterest
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomer() *resources.Customer {
	if m != nil {
		return m.Customer
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerManagerLink() *resources.CustomerManagerLink {
	if m != nil {
		return m.CustomerManagerLink
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerClientLink() *resources.CustomerClientLink {
	if m != nil {
		return m.CustomerClientLink
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerClient() *resources.CustomerClient {
	if m != nil {
		return m.CustomerClient
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerExtensionSetting() *resources.CustomerExtensionSetting {
	if m != nil {
		return m.CustomerExtensionSetting
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerFeed() *resources.CustomerFeed {
	if m != nil {
		return m.CustomerFeed
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerLabel() *resources.CustomerLabel {
	if m != nil {
		return m.CustomerLabel
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerNegativeCriterion() *resources.CustomerNegativeCriterion {
	if m != nil {
		return m.CustomerNegativeCriterion
	}
	return nil
}

func (m *GoogleAdsRow) GetDetailPlacementView() *resources.DetailPlacementView {
	if m != nil {
		return m.DetailPlacementView
	}
	return nil
}

func (m *GoogleAdsRow) GetDisplayKeywordView() *resources.DisplayKeywordView {
	if m != nil {
		return m.DisplayKeywordView
	}
	return nil
}

func (m *GoogleAdsRow) GetDistanceView() *resources.DistanceView {
	if m != nil {
		return m.DistanceView
	}
	return nil
}

func (m *GoogleAdsRow) GetDynamicSearchAdsSearchTermView() *resources.DynamicSearchAdsSearchTermView {
	if m != nil {
		return m.DynamicSearchAdsSearchTermView
	}
	return nil
}

func (m *GoogleAdsRow) GetExpandedLandingPageView() *resources.ExpandedLandingPageView {
	if m != nil {
		return m.ExpandedLandingPageView
	}
	return nil
}

func (m *GoogleAdsRow) GetExtensionFeedItem() *resources.ExtensionFeedItem {
	if m != nil {
		return m.ExtensionFeedItem
	}
	return nil
}

func (m *GoogleAdsRow) GetFeed() *resources.Feed {
	if m != nil {
		return m.Feed
	}
	return nil
}

func (m *GoogleAdsRow) GetFeedItem() *resources.FeedItem {
	if m != nil {
		return m.FeedItem
	}
	return nil
}

func (m *GoogleAdsRow) GetFeedItemTarget() *resources.FeedItemTarget {
	if m != nil {
		return m.FeedItemTarget
	}
	return nil
}

func (m *GoogleAdsRow) GetFeedMapping() *resources.FeedMapping {
	if m != nil {
		return m.FeedMapping
	}
	return nil
}

func (m *GoogleAdsRow) GetFeedPlaceholderView() *resources.FeedPlaceholderView {
	if m != nil {
		return m.FeedPlaceholderView
	}
	return nil
}

func (m *GoogleAdsRow) GetGenderView() *resources.GenderView {
	if m != nil {
		return m.GenderView
	}
	return nil
}

func (m *GoogleAdsRow) GetGeoTargetConstant() *resources.GeoTargetConstant {
	if m != nil {
		return m.GeoTargetConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetGeographicView() *resources.GeographicView {
	if m != nil {
		return m.GeographicView
	}
	return nil
}

func (m *GoogleAdsRow) GetGroupPlacementView() *resources.GroupPlacementView {
	if m != nil {
		return m.GroupPlacementView
	}
	return nil
}

func (m *GoogleAdsRow) GetHotelGroupView() *resources.HotelGroupView {
	if m != nil {
		return m.HotelGroupView
	}
	return nil
}

func (m *GoogleAdsRow) GetHotelPerformanceView() *resources.HotelPerformanceView {
	if m != nil {
		return m.HotelPerformanceView
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordView() *resources.KeywordView {
	if m != nil {
		return m.KeywordView
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlan() *resources.KeywordPlan {
	if m != nil {
		return m.KeywordPlan
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlanCampaign() *resources.KeywordPlanCampaign {
	if m != nil {
		return m.KeywordPlanCampaign
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlanNegativeKeyword() *resources.KeywordPlanNegativeKeyword {
	if m != nil {
		return m.KeywordPlanNegativeKeyword
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlanAdGroup() *resources.KeywordPlanAdGroup {
	if m != nil {
		return m.KeywordPlanAdGroup
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlanKeyword() *resources.KeywordPlanKeyword {
	if m != nil {
		return m.KeywordPlanKeyword
	}
	return nil
}

func (m *GoogleAdsRow) GetLabel() *resources.Label {
	if m != nil {
		return m.Label
	}
	return nil
}

func (m *GoogleAdsRow) GetLandingPageView() *resources.LandingPageView {
	if m != nil {
		return m.LandingPageView
	}
	return nil
}

func (m *GoogleAdsRow) GetLanguageConstant() *resources.LanguageConstant {
	if m != nil {
		return m.LanguageConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetLocationView() *resources.LocationView {
	if m != nil {
		return m.LocationView
	}
	return nil
}

func (m *GoogleAdsRow) GetManagedPlacementView() *resources.ManagedPlacementView {
	if m != nil {
		return m.ManagedPlacementView
	}
	return nil
}

func (m *GoogleAdsRow) GetMediaFile() *resources.MediaFile {
	if m != nil {
		return m.MediaFile
	}
	return nil
}

func (m *GoogleAdsRow) GetMobileAppCategoryConstant() *resources.MobileAppCategoryConstant {
	if m != nil {
		return m.MobileAppCategoryConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetMobileDeviceConstant() *resources.MobileDeviceConstant {
	if m != nil {
		return m.MobileDeviceConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetMutateJob() *resources.MutateJob {
	if m != nil {
		return m.MutateJob
	}
	return nil
}

func (m *GoogleAdsRow) GetOfflineUserDataJob() *resources.OfflineUserDataJob {
	if m != nil {
		return m.OfflineUserDataJob
	}
	return nil
}

func (m *GoogleAdsRow) GetOperatingSystemVersionConstant() *resources.OperatingSystemVersionConstant {
	if m != nil {
		return m.OperatingSystemVersionConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetPaidOrganicSearchTermView() *resources.PaidOrganicSearchTermView {
	if m != nil {
		return m.PaidOrganicSearchTermView
	}
	return nil
}

func (m *GoogleAdsRow) GetParentalStatusView() *resources.ParentalStatusView {
	if m != nil {
		return m.ParentalStatusView
	}
	return nil
}

func (m *GoogleAdsRow) GetProductBiddingCategoryConstant() *resources.ProductBiddingCategoryConstant {
	if m != nil {
		return m.ProductBiddingCategoryConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetProductGroupView() *resources.ProductGroupView {
	if m != nil {
		return m.ProductGroupView
	}
	return nil
}

func (m *GoogleAdsRow) GetRecommendation() *resources.Recommendation {
	if m != nil {
		return m.Recommendation
	}
	return nil
}

func (m *GoogleAdsRow) GetSearchTermView() *resources.SearchTermView {
	if m != nil {
		return m.SearchTermView
	}
	return nil
}

func (m *GoogleAdsRow) GetSharedCriterion() *resources.SharedCriterion {
	if m != nil {
		return m.SharedCriterion
	}
	return nil
}

func (m *GoogleAdsRow) GetSharedSet() *resources.SharedSet {
	if m != nil {
		return m.SharedSet
	}
	return nil
}

func (m *GoogleAdsRow) GetShoppingPerformanceView() *resources.ShoppingPerformanceView {
	if m != nil {
		return m.ShoppingPerformanceView
	}
	return nil
}

func (m *GoogleAdsRow) GetTopicView() *resources.TopicView {
	if m != nil {
		return m.TopicView
	}
	return nil
}

func (m *GoogleAdsRow) GetUserInterest() *resources.UserInterest {
	if m != nil {
		return m.UserInterest
	}
	return nil
}

func (m *GoogleAdsRow) GetUserList() *resources.UserList {
	if m != nil {
		return m.UserList
	}
	return nil
}

func (m *GoogleAdsRow) GetUserLocationView() *resources.UserLocationView {
	if m != nil {
		return m.UserLocationView
	}
	return nil
}

func (m *GoogleAdsRow) GetRemarketingAction() *resources.RemarketingAction {
	if m != nil {
		return m.RemarketingAction
	}
	return nil
}

func (m *GoogleAdsRow) GetTopicConstant() *resources.TopicConstant {
	if m != nil {
		return m.TopicConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetVideo() *resources.Video {
	if m != nil {
		return m.Video
	}
	return nil
}

func (m *GoogleAdsRow) GetMetrics() *common.Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *GoogleAdsRow) GetSegments() *common.Segments {
	if m != nil {
		return m.Segments
	}
	return nil
}

// Request message for [GoogleAdsService.Mutate][google.ads.googleads.v3.services.GoogleAdsService.Mutate].
type MutateGoogleAdsRequest struct {
	// Required. The ID of the customer whose resources are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual resources.
	MutateOperations []*MutateOperation `protobuf:"bytes,2,rep,name=mutate_operations,json=mutateOperations,proto3" json:"mutate_operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateGoogleAdsRequest) Reset()         { *m = MutateGoogleAdsRequest{} }
func (m *MutateGoogleAdsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateGoogleAdsRequest) ProtoMessage()    {}
func (*MutateGoogleAdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_da24cac89ef496be, []int{5}
}

func (m *MutateGoogleAdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateGoogleAdsRequest.Unmarshal(m, b)
}
func (m *MutateGoogleAdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateGoogleAdsRequest.Marshal(b, m, deterministic)
}
func (m *MutateGoogleAdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateGoogleAdsRequest.Merge(m, src)
}
func (m *MutateGoogleAdsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateGoogleAdsRequest.Size(m)
}
func (m *MutateGoogleAdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateGoogleAdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateGoogleAdsRequest proto.InternalMessageInfo

func (m *MutateGoogleAdsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateGoogleAdsRequest) GetMutateOperations() []*MutateOperation {
	if m != nil {
		return m.MutateOperations
	}
	return nil
}

func (m *MutateGoogleAdsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateGoogleAdsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// Response message for [GoogleAdsService.Mutate][google.ads.googleads.v3.services.GoogleAdsService.Mutate].
type MutateGoogleAdsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g., auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All responses for the mutate.
	MutateOperationResponses []*MutateOperationResponse `protobuf:"bytes,1,rep,name=mutate_operation_responses,json=mutateOperationResponses,proto3" json:"mutate_operation_responses,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}                   `json:"-"`
	XXX_unrecognized         []byte                     `json:"-"`
	XXX_sizecache            int32                      `json:"-"`
}

func (m *MutateGoogleAdsResponse) Reset()         { *m = MutateGoogleAdsResponse{} }
func (m *MutateGoogleAdsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateGoogleAdsResponse) ProtoMessage()    {}
func (*MutateGoogleAdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_da24cac89ef496be, []int{6}
}

func (m *MutateGoogleAdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateGoogleAdsResponse.Unmarshal(m, b)
}
func (m *MutateGoogleAdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateGoogleAdsResponse.Marshal(b, m, deterministic)
}
func (m *MutateGoogleAdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateGoogleAdsResponse.Merge(m, src)
}
func (m *MutateGoogleAdsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateGoogleAdsResponse.Size(m)
}
func (m *MutateGoogleAdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateGoogleAdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateGoogleAdsResponse proto.InternalMessageInfo

func (m *MutateGoogleAdsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateGoogleAdsResponse) GetMutateOperationResponses() []*MutateOperationResponse {
	if m != nil {
		return m.MutateOperationResponses
	}
	return nil
}

// A single operation (create, update, remove) on a resource.
type MutateOperation struct {
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*MutateOperation_AdGroupAdLabelOperation
	//	*MutateOperation_AdGroupAdOperation
	//	*MutateOperation_AdGroupBidModifierOperation
	//	*MutateOperation_AdGroupCriterionLabelOperation
	//	*MutateOperation_AdGroupCriterionOperation
	//	*MutateOperation_AdGroupExtensionSettingOperation
	//	*MutateOperation_AdGroupFeedOperation
	//	*MutateOperation_AdGroupLabelOperation
	//	*MutateOperation_AdGroupOperation
	//	*MutateOperation_AdOperation
	//	*MutateOperation_AdParameterOperation
	//	*MutateOperation_AssetOperation
	//	*MutateOperation_BiddingStrategyOperation
	//	*MutateOperation_CampaignBidModifierOperation
	//	*MutateOperation_CampaignBudgetOperation
	//	*MutateOperation_CampaignCriterionOperation
	//	*MutateOperation_CampaignDraftOperation
	//	*MutateOperation_CampaignExperimentOperation
	//	*MutateOperation_CampaignExtensionSettingOperation
	//	*MutateOperation_CampaignFeedOperation
	//	*MutateOperation_CampaignLabelOperation
	//	*MutateOperation_CampaignOperation
	//	*MutateOperation_CampaignSharedSetOperation
	//	*MutateOperation_ConversionActionOperation
	//	*MutateOperation_CustomerExtensionSettingOperation
	//	*MutateOperation_CustomerFeedOperation
	//	*MutateOperation_CustomerLabelOperation
	//	*MutateOperation_CustomerNegativeCriterionOperation
	//	*MutateOperation_CustomerOperation
	//	*MutateOperation_ExtensionFeedItemOperation
	//	*MutateOperation_FeedItemOperation
	//	*MutateOperation_FeedItemTargetOperation
	//	*MutateOperation_FeedMappingOperation
	//	*MutateOperation_FeedOperation
	//	*MutateOperation_LabelOperation
	//	*MutateOperation_MediaFileOperation
	//	*MutateOperation_RemarketingActionOperation
	//	*MutateOperation_SharedCriterionOperation
	//	*MutateOperation_SharedSetOperation
	//	*MutateOperation_UserListOperation
	Operation            isMutateOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *MutateOperation) Reset()         { *m = MutateOperation{} }
func (m *MutateOperation) String() string { return proto.CompactTextString(m) }
func (*MutateOperation) ProtoMessage()    {}
func (*MutateOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_da24cac89ef496be, []int{7}
}

func (m *MutateOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateOperation.Unmarshal(m, b)
}
func (m *MutateOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateOperation.Marshal(b, m, deterministic)
}
func (m *MutateOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateOperation.Merge(m, src)
}
func (m *MutateOperation) XXX_Size() int {
	return xxx_messageInfo_MutateOperation.Size(m)
}
func (m *MutateOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateOperation.DiscardUnknown(m)
}

var xxx_messageInfo_MutateOperation proto.InternalMessageInfo

type isMutateOperation_Operation interface {
	isMutateOperation_Operation()
}

type MutateOperation_AdGroupAdLabelOperation struct {
	AdGroupAdLabelOperation *AdGroupAdLabelOperation `protobuf:"bytes,17,opt,name=ad_group_ad_label_operation,json=adGroupAdLabelOperation,proto3,oneof"`
}

type MutateOperation_AdGroupAdOperation struct {
	AdGroupAdOperation *AdGroupAdOperation `protobuf:"bytes,1,opt,name=ad_group_ad_operation,json=adGroupAdOperation,proto3,oneof"`
}

type MutateOperation_AdGroupBidModifierOperation struct {
	AdGroupBidModifierOperation *AdGroupBidModifierOperation `protobuf:"bytes,2,opt,name=ad_group_bid_modifier_operation,json=adGroupBidModifierOperation,proto3,oneof"`
}

type MutateOperation_AdGroupCriterionLabelOperation struct {
	AdGroupCriterionLabelOperation *AdGroupCriterionLabelOperation `protobuf:"bytes,18,opt,name=ad_group_criterion_label_operation,json=adGroupCriterionLabelOperation,proto3,oneof"`
}

type MutateOperation_AdGroupCriterionOperation struct {
	AdGroupCriterionOperation *AdGroupCriterionOperation `protobuf:"bytes,3,opt,name=ad_group_criterion_operation,json=adGroupCriterionOperation,proto3,oneof"`
}

type MutateOperation_AdGroupExtensionSettingOperation struct {
	AdGroupExtensionSettingOperation *AdGroupExtensionSettingOperation `protobuf:"bytes,19,opt,name=ad_group_extension_setting_operation,json=adGroupExtensionSettingOperation,proto3,oneof"`
}

type MutateOperation_AdGroupFeedOperation struct {
	AdGroupFeedOperation *AdGroupFeedOperation `protobuf:"bytes,20,opt,name=ad_group_feed_operation,json=adGroupFeedOperation,proto3,oneof"`
}

type MutateOperation_AdGroupLabelOperation struct {
	AdGroupLabelOperation *AdGroupLabelOperation `protobuf:"bytes,21,opt,name=ad_group_label_operation,json=adGroupLabelOperation,proto3,oneof"`
}

type MutateOperation_AdGroupOperation struct {
	AdGroupOperation *AdGroupOperation `protobuf:"bytes,5,opt,name=ad_group_operation,json=adGroupOperation,proto3,oneof"`
}

type MutateOperation_AdOperation struct {
	AdOperation *AdOperation `protobuf:"bytes,49,opt,name=ad_operation,json=adOperation,proto3,oneof"`
}

type MutateOperation_AdParameterOperation struct {
	AdParameterOperation *AdParameterOperation `protobuf:"bytes,22,opt,name=ad_parameter_operation,json=adParameterOperation,proto3,oneof"`
}

type MutateOperation_AssetOperation struct {
	AssetOperation *AssetOperation `protobuf:"bytes,23,opt,name=asset_operation,json=assetOperation,proto3,oneof"`
}

type MutateOperation_BiddingStrategyOperation struct {
	BiddingStrategyOperation *BiddingStrategyOperation `protobuf:"bytes,6,opt,name=bidding_strategy_operation,json=biddingStrategyOperation,proto3,oneof"`
}

type MutateOperation_CampaignBidModifierOperation struct {
	CampaignBidModifierOperation *CampaignBidModifierOperation `protobuf:"bytes,7,opt,name=campaign_bid_modifier_operation,json=campaignBidModifierOperation,proto3,oneof"`
}

type MutateOperation_CampaignBudgetOperation struct {
	CampaignBudgetOperation *CampaignBudgetOperation `protobuf:"bytes,8,opt,name=campaign_budget_operation,json=campaignBudgetOperation,proto3,oneof"`
}

type MutateOperation_CampaignCriterionOperation struct {
	CampaignCriterionOperation *CampaignCriterionOperation `protobuf:"bytes,13,opt,name=campaign_criterion_operation,json=campaignCriterionOperation,proto3,oneof"`
}

type MutateOperation_CampaignDraftOperation struct {
	CampaignDraftOperation *CampaignDraftOperation `protobuf:"bytes,24,opt,name=campaign_draft_operation,json=campaignDraftOperation,proto3,oneof"`
}

type MutateOperation_CampaignExperimentOperation struct {
	CampaignExperimentOperation *CampaignExperimentOperation `protobuf:"bytes,25,opt,name=campaign_experiment_operation,json=campaignExperimentOperation,proto3,oneof"`
}

type MutateOperation_CampaignExtensionSettingOperation struct {
	CampaignExtensionSettingOperation *CampaignExtensionSettingOperation `protobuf:"bytes,26,opt,name=campaign_extension_setting_operation,json=campaignExtensionSettingOperation,proto3,oneof"`
}

type MutateOperation_CampaignFeedOperation struct {
	CampaignFeedOperation *CampaignFeedOperation `protobuf:"bytes,27,opt,name=campaign_feed_operation,json=campaignFeedOperation,proto3,oneof"`
}

type MutateOperation_CampaignLabelOperation struct {
	CampaignLabelOperation *CampaignLabelOperation `protobuf:"bytes,28,opt,name=campaign_label_operation,json=campaignLabelOperation,proto3,oneof"`
}

type MutateOperation_CampaignOperation struct {
	CampaignOperation *CampaignOperation `protobuf:"bytes,10,opt,name=campaign_operation,json=campaignOperation,proto3,oneof"`
}

type MutateOperation_CampaignSharedSetOperation struct {
	CampaignSharedSetOperation *CampaignSharedSetOperation `protobuf:"bytes,11,opt,name=campaign_shared_set_operation,json=campaignSharedSetOperation,proto3,oneof"`
}

type MutateOperation_ConversionActionOperation struct {
	ConversionActionOperation *ConversionActionOperation `protobuf:"bytes,12,opt,name=conversion_action_operation,json=conversionActionOperation,proto3,oneof"`
}

type MutateOperation_CustomerExtensionSettingOperation struct {
	CustomerExtensionSettingOperation *CustomerExtensionSettingOperation `protobuf:"bytes,30,opt,name=customer_extension_setting_operation,json=customerExtensionSettingOperation,proto3,oneof"`
}

type MutateOperation_CustomerFeedOperation struct {
	CustomerFeedOperation *CustomerFeedOperation `protobuf:"bytes,31,opt,name=customer_feed_operation,json=customerFeedOperation,proto3,oneof"`
}

type MutateOperation_CustomerLabelOperation struct {
	CustomerLabelOperation *CustomerLabelOperation `protobuf:"bytes,32,opt,name=customer_label_operation,json=customerLabelOperation,proto3,oneof"`
}

type MutateOperation_CustomerNegativeCriterionOperation struct {
	CustomerNegativeCriterionOperation *CustomerNegativeCriterionOperation `protobuf:"bytes,34,opt,name=customer_negative_criterion_operation,json=customerNegativeCriterionOperation,proto3,oneof"`
}

type MutateOperation_CustomerOperation struct {
	CustomerOperation *CustomerOperation `protobuf:"bytes,35,opt,name=customer_operation,json=customerOperation,proto3,oneof"`
}

type MutateOperation_ExtensionFeedItemOperation struct {
	ExtensionFeedItemOperation *ExtensionFeedItemOperation `protobuf:"bytes,36,opt,name=extension_feed_item_operation,json=extensionFeedItemOperation,proto3,oneof"`
}

type MutateOperation_FeedItemOperation struct {
	FeedItemOperation *FeedItemOperation `protobuf:"bytes,37,opt,name=feed_item_operation,json=feedItemOperation,proto3,oneof"`
}

type MutateOperation_FeedItemTargetOperation struct {
	FeedItemTargetOperation *FeedItemTargetOperation `protobuf:"bytes,38,opt,name=feed_item_target_operation,json=feedItemTargetOperation,proto3,oneof"`
}

type MutateOperation_FeedMappingOperation struct {
	FeedMappingOperation *FeedMappingOperation `protobuf:"bytes,39,opt,name=feed_mapping_operation,json=feedMappingOperation,proto3,oneof"`
}

type MutateOperation_FeedOperation struct {
	FeedOperation *FeedOperation `protobuf:"bytes,40,opt,name=feed_operation,json=feedOperation,proto3,oneof"`
}

type MutateOperation_LabelOperation struct {
	LabelOperation *LabelOperation `protobuf:"bytes,41,opt,name=label_operation,json=labelOperation,proto3,oneof"`
}

type MutateOperation_MediaFileOperation struct {
	MediaFileOperation *MediaFileOperation `protobuf:"bytes,42,opt,name=media_file_operation,json=mediaFileOperation,proto3,oneof"`
}

type MutateOperation_RemarketingActionOperation struct {
	RemarketingActionOperation *RemarketingActionOperation `protobuf:"bytes,43,opt,name=remarketing_action_operation,json=remarketingActionOperation,proto3,oneof"`
}

type MutateOperation_SharedCriterionOperation struct {
	SharedCriterionOperation *SharedCriterionOperation `protobuf:"bytes,14,opt,name=shared_criterion_operation,json=sharedCriterionOperation,proto3,oneof"`
}

type MutateOperation_SharedSetOperation struct {
	SharedSetOperation *SharedSetOperation `protobuf:"bytes,15,opt,name=shared_set_operation,json=sharedSetOperation,proto3,oneof"`
}

type MutateOperation_UserListOperation struct {
	UserListOperation *UserListOperation `protobuf:"bytes,16,opt,name=user_list_operation,json=userListOperation,proto3,oneof"`
}

func (*MutateOperation_AdGroupAdLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupAdOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupBidModifierOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupCriterionLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupExtensionSettingOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupFeedOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdParameterOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AssetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_BiddingStrategyOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignBidModifierOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignBudgetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignDraftOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignExperimentOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignExtensionSettingOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignFeedOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignSharedSetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_ConversionActionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerExtensionSettingOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerFeedOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerNegativeCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerOperation) isMutateOperation_Operation() {}

func (*MutateOperation_ExtensionFeedItemOperation) isMutateOperation_Operation() {}

func (*MutateOperation_FeedItemOperation) isMutateOperation_Operation() {}

func (*MutateOperation_FeedItemTargetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_FeedMappingOperation) isMutateOperation_Operation() {}

func (*MutateOperation_FeedOperation) isMutateOperation_Operation() {}

func (*MutateOperation_LabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_MediaFileOperation) isMutateOperation_Operation() {}

func (*MutateOperation_RemarketingActionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_SharedCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_SharedSetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_UserListOperation) isMutateOperation_Operation() {}

func (m *MutateOperation) GetOperation() isMutateOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupAdLabelOperation() *AdGroupAdLabelOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupAdLabelOperation); ok {
		return x.AdGroupAdLabelOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupAdOperation() *AdGroupAdOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupAdOperation); ok {
		return x.AdGroupAdOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupBidModifierOperation() *AdGroupBidModifierOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupBidModifierOperation); ok {
		return x.AdGroupBidModifierOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupCriterionLabelOperation() *AdGroupCriterionLabelOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupCriterionLabelOperation); ok {
		return x.AdGroupCriterionLabelOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupCriterionOperation() *AdGroupCriterionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupCriterionOperation); ok {
		return x.AdGroupCriterionOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupExtensionSettingOperation() *AdGroupExtensionSettingOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupExtensionSettingOperation); ok {
		return x.AdGroupExtensionSettingOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupFeedOperation() *AdGroupFeedOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupFeedOperation); ok {
		return x.AdGroupFeedOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupLabelOperation() *AdGroupLabelOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupLabelOperation); ok {
		return x.AdGroupLabelOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupOperation() *AdGroupOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupOperation); ok {
		return x.AdGroupOperation
	}
	return nil
}

func (m *MutateOperation) GetAdOperation() *AdOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdOperation); ok {
		return x.AdOperation
	}
	return nil
}

func (m *MutateOperation) GetAdParameterOperation() *AdParameterOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdParameterOperation); ok {
		return x.AdParameterOperation
	}
	return nil
}

func (m *MutateOperation) GetAssetOperation() *AssetOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AssetOperation); ok {
		return x.AssetOperation
	}
	return nil
}

func (m *MutateOperation) GetBiddingStrategyOperation() *BiddingStrategyOperation {
	if x, ok := m.GetOperation().(*MutateOperation_BiddingStrategyOperation); ok {
		return x.BiddingStrategyOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignBidModifierOperation() *CampaignBidModifierOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignBidModifierOperation); ok {
		return x.CampaignBidModifierOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignBudgetOperation() *CampaignBudgetOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignBudgetOperation); ok {
		return x.CampaignBudgetOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignCriterionOperation() *CampaignCriterionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignCriterionOperation); ok {
		return x.CampaignCriterionOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignDraftOperation() *CampaignDraftOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignDraftOperation); ok {
		return x.CampaignDraftOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignExperimentOperation() *CampaignExperimentOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignExperimentOperation); ok {
		return x.CampaignExperimentOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignExtensionSettingOperation() *CampaignExtensionSettingOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignExtensionSettingOperation); ok {
		return x.CampaignExtensionSettingOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignFeedOperation() *CampaignFeedOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignFeedOperation); ok {
		return x.CampaignFeedOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignLabelOperation() *CampaignLabelOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignLabelOperation); ok {
		return x.CampaignLabelOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignOperation() *CampaignOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignOperation); ok {
		return x.CampaignOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignSharedSetOperation() *CampaignSharedSetOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignSharedSetOperation); ok {
		return x.CampaignSharedSetOperation
	}
	return nil
}

func (m *MutateOperation) GetConversionActionOperation() *ConversionActionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_ConversionActionOperation); ok {
		return x.ConversionActionOperation
	}
	return nil
}

func (m *MutateOperation) GetCustomerExtensionSettingOperation() *CustomerExtensionSettingOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CustomerExtensionSettingOperation); ok {
		return x.CustomerExtensionSettingOperation
	}
	return nil
}

func (m *MutateOperation) GetCustomerFeedOperation() *CustomerFeedOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CustomerFeedOperation); ok {
		return x.CustomerFeedOperation
	}
	return nil
}

func (m *MutateOperation) GetCustomerLabelOperation() *CustomerLabelOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CustomerLabelOperation); ok {
		return x.CustomerLabelOperation
	}
	return nil
}

func (m *MutateOperation) GetCustomerNegativeCriterionOperation() *CustomerNegativeCriterionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CustomerNegativeCriterionOperation); ok {
		return x.CustomerNegativeCriterionOperation
	}
	return nil
}

func (m *MutateOperation) GetCustomerOperation() *CustomerOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CustomerOperation); ok {
		return x.CustomerOperation
	}
	return nil
}

func (m *MutateOperation) GetExtensionFeedItemOperation() *ExtensionFeedItemOperation {
	if x, ok := m.GetOperation().(*MutateOperation_ExtensionFeedItemOperation); ok {
		return x.ExtensionFeedItemOperation
	}
	return nil
}

func (m *MutateOperation) GetFeedItemOperation() *FeedItemOperation {
	if x, ok := m.GetOperation().(*MutateOperation_FeedItemOperation); ok {
		return x.FeedItemOperation
	}
	return nil
}

func (m *MutateOperation) GetFeedItemTargetOperation() *FeedItemTargetOperation {
	if x, ok := m.GetOperation().(*MutateOperation_FeedItemTargetOperation); ok {
		return x.FeedItemTargetOperation
	}
	return nil
}

func (m *MutateOperation) GetFeedMappingOperation() *FeedMappingOperation {
	if x, ok := m.GetOperation().(*MutateOperation_FeedMappingOperation); ok {
		return x.FeedMappingOperation
	}
	return nil
}

func (m *MutateOperation) GetFeedOperation() *FeedOperation {
	if x, ok := m.GetOperation().(*MutateOperation_FeedOperation); ok {
		return x.FeedOperation
	}
	return nil
}

func (m *MutateOperation) GetLabelOperation() *LabelOperation {
	if x, ok := m.GetOperation().(*MutateOperation_LabelOperation); ok {
		return x.LabelOperation
	}
	return nil
}

func (m *MutateOperation) GetMediaFileOperation() *MediaFileOperation {
	if x, ok := m.GetOperation().(*MutateOperation_MediaFileOperation); ok {
		return x.MediaFileOperation
	}
	return nil
}

func (m *MutateOperation) GetRemarketingActionOperation() *RemarketingActionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_RemarketingActionOperation); ok {
		return x.RemarketingActionOperation
	}
	return nil
}

func (m *MutateOperation) GetSharedCriterionOperation() *SharedCriterionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_SharedCriterionOperation); ok {
		return x.SharedCriterionOperation
	}
	return nil
}

func (m *MutateOperation) GetSharedSetOperation() *SharedSetOperation {
	if x, ok := m.GetOperation().(*MutateOperation_SharedSetOperation); ok {
		return x.SharedSetOperation
	}
	return nil
}

func (m *MutateOperation) GetUserListOperation() *UserListOperation {
	if x, ok := m.GetOperation().(*MutateOperation_UserListOperation); ok {
		return x.UserListOperation
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MutateOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MutateOperation_AdGroupAdLabelOperation)(nil),
		(*MutateOperation_AdGroupAdOperation)(nil),
		(*MutateOperation_AdGroupBidModifierOperation)(nil),
		(*MutateOperation_AdGroupCriterionLabelOperation)(nil),
		(*MutateOperation_AdGroupCriterionOperation)(nil),
		(*MutateOperation_AdGroupExtensionSettingOperation)(nil),
		(*MutateOperation_AdGroupFeedOperation)(nil),
		(*MutateOperation_AdGroupLabelOperation)(nil),
		(*MutateOperation_AdGroupOperation)(nil),
		(*MutateOperation_AdOperation)(nil),
		(*MutateOperation_AdParameterOperation)(nil),
		(*MutateOperation_AssetOperation)(nil),
		(*MutateOperation_BiddingStrategyOperation)(nil),
		(*MutateOperation_CampaignBidModifierOperation)(nil),
		(*MutateOperation_CampaignBudgetOperation)(nil),
		(*MutateOperation_CampaignCriterionOperation)(nil),
		(*MutateOperation_CampaignDraftOperation)(nil),
		(*MutateOperation_CampaignExperimentOperation)(nil),
		(*MutateOperation_CampaignExtensionSettingOperation)(nil),
		(*MutateOperation_CampaignFeedOperation)(nil),
		(*MutateOperation_CampaignLabelOperation)(nil),
		(*MutateOperation_CampaignOperation)(nil),
		(*MutateOperation_CampaignSharedSetOperation)(nil),
		(*MutateOperation_ConversionActionOperation)(nil),
		(*MutateOperation_CustomerExtensionSettingOperation)(nil),
		(*MutateOperation_CustomerFeedOperation)(nil),
		(*MutateOperation_CustomerLabelOperation)(nil),
		(*MutateOperation_CustomerNegativeCriterionOperation)(nil),
		(*MutateOperation_CustomerOperation)(nil),
		(*MutateOperation_ExtensionFeedItemOperation)(nil),
		(*MutateOperation_FeedItemOperation)(nil),
		(*MutateOperation_FeedItemTargetOperation)(nil),
		(*MutateOperation_FeedMappingOperation)(nil),
		(*MutateOperation_FeedOperation)(nil),
		(*MutateOperation_LabelOperation)(nil),
		(*MutateOperation_MediaFileOperation)(nil),
		(*MutateOperation_RemarketingActionOperation)(nil),
		(*MutateOperation_SharedCriterionOperation)(nil),
		(*MutateOperation_SharedSetOperation)(nil),
		(*MutateOperation_UserListOperation)(nil),
	}
}

// Response message for the resource mutate.
type MutateOperationResponse struct {
	// The mutate response.
	//
	// Types that are valid to be assigned to Response:
	//	*MutateOperationResponse_AdGroupAdLabelResult
	//	*MutateOperationResponse_AdGroupAdResult
	//	*MutateOperationResponse_AdGroupBidModifierResult
	//	*MutateOperationResponse_AdGroupCriterionLabelResult
	//	*MutateOperationResponse_AdGroupCriterionResult
	//	*MutateOperationResponse_AdGroupExtensionSettingResult
	//	*MutateOperationResponse_AdGroupFeedResult
	//	*MutateOperationResponse_AdGroupLabelResult
	//	*MutateOperationResponse_AdGroupResult
	//	*MutateOperationResponse_AdParameterResult
	//	*MutateOperationResponse_AdResult
	//	*MutateOperationResponse_AssetResult
	//	*MutateOperationResponse_BiddingStrategyResult
	//	*MutateOperationResponse_CampaignBidModifierResult
	//	*MutateOperationResponse_CampaignBudgetResult
	//	*MutateOperationResponse_CampaignCriterionResult
	//	*MutateOperationResponse_CampaignDraftResult
	//	*MutateOperationResponse_CampaignExperimentResult
	//	*MutateOperationResponse_CampaignExtensionSettingResult
	//	*MutateOperationResponse_CampaignFeedResult
	//	*MutateOperationResponse_CampaignLabelResult
	//	*MutateOperationResponse_CampaignResult
	//	*MutateOperationResponse_CampaignSharedSetResult
	//	*MutateOperationResponse_ConversionActionResult
	//	*MutateOperationResponse_CustomerExtensionSettingResult
	//	*MutateOperationResponse_CustomerFeedResult
	//	*MutateOperationResponse_CustomerLabelResult
	//	*MutateOperationResponse_CustomerNegativeCriterionResult
	//	*MutateOperationResponse_CustomerResult
	//	*MutateOperationResponse_ExtensionFeedItemResult
	//	*MutateOperationResponse_FeedItemResult
	//	*MutateOperationResponse_FeedItemTargetResult
	//	*MutateOperationResponse_FeedMappingResult
	//	*MutateOperationResponse_FeedResult
	//	*MutateOperationResponse_LabelResult
	//	*MutateOperationResponse_MediaFileResult
	//	*MutateOperationResponse_RemarketingActionResult
	//	*MutateOperationResponse_SharedCriterionResult
	//	*MutateOperationResponse_SharedSetResult
	//	*MutateOperationResponse_UserListResult
	Response             isMutateOperationResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *MutateOperationResponse) Reset()         { *m = MutateOperationResponse{} }
func (m *MutateOperationResponse) String() string { return proto.CompactTextString(m) }
func (*MutateOperationResponse) ProtoMessage()    {}
func (*MutateOperationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_da24cac89ef496be, []int{8}
}

func (m *MutateOperationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateOperationResponse.Unmarshal(m, b)
}
func (m *MutateOperationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateOperationResponse.Marshal(b, m, deterministic)
}
func (m *MutateOperationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateOperationResponse.Merge(m, src)
}
func (m *MutateOperationResponse) XXX_Size() int {
	return xxx_messageInfo_MutateOperationResponse.Size(m)
}
func (m *MutateOperationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateOperationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateOperationResponse proto.InternalMessageInfo

type isMutateOperationResponse_Response interface {
	isMutateOperationResponse_Response()
}

type MutateOperationResponse_AdGroupAdLabelResult struct {
	AdGroupAdLabelResult *MutateAdGroupAdLabelResult `protobuf:"bytes,17,opt,name=ad_group_ad_label_result,json=adGroupAdLabelResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupAdResult struct {
	AdGroupAdResult *MutateAdGroupAdResult `protobuf:"bytes,1,opt,name=ad_group_ad_result,json=adGroupAdResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupBidModifierResult struct {
	AdGroupBidModifierResult *MutateAdGroupBidModifierResult `protobuf:"bytes,2,opt,name=ad_group_bid_modifier_result,json=adGroupBidModifierResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupCriterionLabelResult struct {
	AdGroupCriterionLabelResult *MutateAdGroupCriterionLabelResult `protobuf:"bytes,18,opt,name=ad_group_criterion_label_result,json=adGroupCriterionLabelResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupCriterionResult struct {
	AdGroupCriterionResult *MutateAdGroupCriterionResult `protobuf:"bytes,3,opt,name=ad_group_criterion_result,json=adGroupCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupExtensionSettingResult struct {
	AdGroupExtensionSettingResult *MutateAdGroupExtensionSettingResult `protobuf:"bytes,19,opt,name=ad_group_extension_setting_result,json=adGroupExtensionSettingResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupFeedResult struct {
	AdGroupFeedResult *MutateAdGroupFeedResult `protobuf:"bytes,20,opt,name=ad_group_feed_result,json=adGroupFeedResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupLabelResult struct {
	AdGroupLabelResult *MutateAdGroupLabelResult `protobuf:"bytes,21,opt,name=ad_group_label_result,json=adGroupLabelResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupResult struct {
	AdGroupResult *MutateAdGroupResult `protobuf:"bytes,5,opt,name=ad_group_result,json=adGroupResult,proto3,oneof"`
}

type MutateOperationResponse_AdParameterResult struct {
	AdParameterResult *MutateAdParameterResult `protobuf:"bytes,22,opt,name=ad_parameter_result,json=adParameterResult,proto3,oneof"`
}

type MutateOperationResponse_AdResult struct {
	AdResult *MutateAdResult `protobuf:"bytes,49,opt,name=ad_result,json=adResult,proto3,oneof"`
}

type MutateOperationResponse_AssetResult struct {
	AssetResult *MutateAssetResult `protobuf:"bytes,23,opt,name=asset_result,json=assetResult,proto3,oneof"`
}

type MutateOperationResponse_BiddingStrategyResult struct {
	BiddingStrategyResult *MutateBiddingStrategyResult `protobuf:"bytes,6,opt,name=bidding_strategy_result,json=biddingStrategyResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignBidModifierResult struct {
	CampaignBidModifierResult *MutateCampaignBidModifierResult `protobuf:"bytes,7,opt,name=campaign_bid_modifier_result,json=campaignBidModifierResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignBudgetResult struct {
	CampaignBudgetResult *MutateCampaignBudgetResult `protobuf:"bytes,8,opt,name=campaign_budget_result,json=campaignBudgetResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignCriterionResult struct {
	CampaignCriterionResult *MutateCampaignCriterionResult `protobuf:"bytes,13,opt,name=campaign_criterion_result,json=campaignCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignDraftResult struct {
	CampaignDraftResult *MutateCampaignDraftResult `protobuf:"bytes,24,opt,name=campaign_draft_result,json=campaignDraftResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignExperimentResult struct {
	CampaignExperimentResult *MutateCampaignExperimentResult `protobuf:"bytes,25,opt,name=campaign_experiment_result,json=campaignExperimentResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignExtensionSettingResult struct {
	CampaignExtensionSettingResult *MutateCampaignExtensionSettingResult `protobuf:"bytes,26,opt,name=campaign_extension_setting_result,json=campaignExtensionSettingResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignFeedResult struct {
	CampaignFeedResult *MutateCampaignFeedResult `protobuf:"bytes,27,opt,name=campaign_feed_result,json=campaignFeedResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignLabelResult struct {
	CampaignLabelResult *MutateCampaignLabelResult `protobuf:"bytes,28,opt,name=campaign_label_result,json=campaignLabelResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignResult struct {
	CampaignResult *MutateCampaignResult `protobuf:"bytes,10,opt,name=campaign_result,json=campaignResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignSharedSetResult struct {
	CampaignSharedSetResult *MutateCampaignSharedSetResult `protobuf:"bytes,11,opt,name=campaign_shared_set_result,json=campaignSharedSetResult,proto3,oneof"`
}

type MutateOperationResponse_ConversionActionResult struct {
	ConversionActionResult *MutateConversionActionResult `protobuf:"bytes,12,opt,name=conversion_action_result,json=conversionActionResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerExtensionSettingResult struct {
	CustomerExtensionSettingResult *MutateCustomerExtensionSettingResult `protobuf:"bytes,30,opt,name=customer_extension_setting_result,json=customerExtensionSettingResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerFeedResult struct {
	CustomerFeedResult *MutateCustomerFeedResult `protobuf:"bytes,31,opt,name=customer_feed_result,json=customerFeedResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerLabelResult struct {
	CustomerLabelResult *MutateCustomerLabelResult `protobuf:"bytes,32,opt,name=customer_label_result,json=customerLabelResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerNegativeCriterionResult struct {
	CustomerNegativeCriterionResult *MutateCustomerNegativeCriteriaResult `protobuf:"bytes,34,opt,name=customer_negative_criterion_result,json=customerNegativeCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerResult struct {
	CustomerResult *MutateCustomerResult `protobuf:"bytes,35,opt,name=customer_result,json=customerResult,proto3,oneof"`
}

type MutateOperationResponse_ExtensionFeedItemResult struct {
	ExtensionFeedItemResult *MutateExtensionFeedItemResult `protobuf:"bytes,36,opt,name=extension_feed_item_result,json=extensionFeedItemResult,proto3,oneof"`
}

type MutateOperationResponse_FeedItemResult struct {
	FeedItemResult *MutateFeedItemResult `protobuf:"bytes,37,opt,name=feed_item_result,json=feedItemResult,proto3,oneof"`
}

type MutateOperationResponse_FeedItemTargetResult struct {
	FeedItemTargetResult *MutateFeedItemTargetResult `protobuf:"bytes,38,opt,name=feed_item_target_result,json=feedItemTargetResult,proto3,oneof"`
}

type MutateOperationResponse_FeedMappingResult struct {
	FeedMappingResult *MutateFeedMappingResult `protobuf:"bytes,39,opt,name=feed_mapping_result,json=feedMappingResult,proto3,oneof"`
}

type MutateOperationResponse_FeedResult struct {
	FeedResult *MutateFeedResult `protobuf:"bytes,40,opt,name=feed_result,json=feedResult,proto3,oneof"`
}

type MutateOperationResponse_LabelResult struct {
	LabelResult *MutateLabelResult `protobuf:"bytes,41,opt,name=label_result,json=labelResult,proto3,oneof"`
}

type MutateOperationResponse_MediaFileResult struct {
	MediaFileResult *MutateMediaFileResult `protobuf:"bytes,42,opt,name=media_file_result,json=mediaFileResult,proto3,oneof"`
}

type MutateOperationResponse_RemarketingActionResult struct {
	RemarketingActionResult *MutateRemarketingActionResult `protobuf:"bytes,43,opt,name=remarketing_action_result,json=remarketingActionResult,proto3,oneof"`
}

type MutateOperationResponse_SharedCriterionResult struct {
	SharedCriterionResult *MutateSharedCriterionResult `protobuf:"bytes,14,opt,name=shared_criterion_result,json=sharedCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_SharedSetResult struct {
	SharedSetResult *MutateSharedSetResult `protobuf:"bytes,15,opt,name=shared_set_result,json=sharedSetResult,proto3,oneof"`
}

type MutateOperationResponse_UserListResult struct {
	UserListResult *MutateUserListResult `protobuf:"bytes,16,opt,name=user_list_result,json=userListResult,proto3,oneof"`
}

func (*MutateOperationResponse_AdGroupAdLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupAdResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupBidModifierResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupCriterionLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupExtensionSettingResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupFeedResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdParameterResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AssetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_BiddingStrategyResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignBidModifierResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignBudgetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignDraftResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignExperimentResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignExtensionSettingResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignFeedResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignSharedSetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_ConversionActionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerExtensionSettingResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerFeedResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerNegativeCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_ExtensionFeedItemResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_FeedItemResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_FeedItemTargetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_FeedMappingResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_FeedResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_LabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_MediaFileResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_RemarketingActionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_SharedCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_SharedSetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_UserListResult) isMutateOperationResponse_Response() {}

func (m *MutateOperationResponse) GetResponse() isMutateOperationResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupAdLabelResult() *MutateAdGroupAdLabelResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupAdLabelResult); ok {
		return x.AdGroupAdLabelResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupAdResult() *MutateAdGroupAdResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupAdResult); ok {
		return x.AdGroupAdResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupBidModifierResult() *MutateAdGroupBidModifierResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupBidModifierResult); ok {
		return x.AdGroupBidModifierResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupCriterionLabelResult() *MutateAdGroupCriterionLabelResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupCriterionLabelResult); ok {
		return x.AdGroupCriterionLabelResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupCriterionResult() *MutateAdGroupCriterionResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupCriterionResult); ok {
		return x.AdGroupCriterionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupExtensionSettingResult() *MutateAdGroupExtensionSettingResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupExtensionSettingResult); ok {
		return x.AdGroupExtensionSettingResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupFeedResult() *MutateAdGroupFeedResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupFeedResult); ok {
		return x.AdGroupFeedResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupLabelResult() *MutateAdGroupLabelResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupLabelResult); ok {
		return x.AdGroupLabelResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupResult() *MutateAdGroupResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupResult); ok {
		return x.AdGroupResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdParameterResult() *MutateAdParameterResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdParameterResult); ok {
		return x.AdParameterResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdResult() *MutateAdResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdResult); ok {
		return x.AdResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAssetResult() *MutateAssetResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AssetResult); ok {
		return x.AssetResult
	}
	return nil
}

func (m *MutateOperationResponse) GetBiddingStrategyResult() *MutateBiddingStrategyResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_BiddingStrategyResult); ok {
		return x.BiddingStrategyResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignBidModifierResult() *MutateCampaignBidModifierResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignBidModifierResult); ok {
		return x.CampaignBidModifierResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignBudgetResult() *MutateCampaignBudgetResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignBudgetResult); ok {
		return x.CampaignBudgetResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignCriterionResult() *MutateCampaignCriterionResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignCriterionResult); ok {
		return x.CampaignCriterionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignDraftResult() *MutateCampaignDraftResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignDraftResult); ok {
		return x.CampaignDraftResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignExperimentResult() *MutateCampaignExperimentResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignExperimentResult); ok {
		return x.CampaignExperimentResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignExtensionSettingResult() *MutateCampaignExtensionSettingResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignExtensionSettingResult); ok {
		return x.CampaignExtensionSettingResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignFeedResult() *MutateCampaignFeedResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignFeedResult); ok {
		return x.CampaignFeedResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignLabelResult() *MutateCampaignLabelResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignLabelResult); ok {
		return x.CampaignLabelResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignResult() *MutateCampaignResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignResult); ok {
		return x.CampaignResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignSharedSetResult() *MutateCampaignSharedSetResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignSharedSetResult); ok {
		return x.CampaignSharedSetResult
	}
	return nil
}

func (m *MutateOperationResponse) GetConversionActionResult() *MutateConversionActionResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_ConversionActionResult); ok {
		return x.ConversionActionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCustomerExtensionSettingResult() *MutateCustomerExtensionSettingResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CustomerExtensionSettingResult); ok {
		return x.CustomerExtensionSettingResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCustomerFeedResult() *MutateCustomerFeedResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CustomerFeedResult); ok {
		return x.CustomerFeedResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCustomerLabelResult() *MutateCustomerLabelResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CustomerLabelResult); ok {
		return x.CustomerLabelResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCustomerNegativeCriterionResult() *MutateCustomerNegativeCriteriaResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CustomerNegativeCriterionResult); ok {
		return x.CustomerNegativeCriterionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCustomerResult() *MutateCustomerResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CustomerResult); ok {
		return x.CustomerResult
	}
	return nil
}

func (m *MutateOperationResponse) GetExtensionFeedItemResult() *MutateExtensionFeedItemResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_ExtensionFeedItemResult); ok {
		return x.ExtensionFeedItemResult
	}
	return nil
}

func (m *MutateOperationResponse) GetFeedItemResult() *MutateFeedItemResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_FeedItemResult); ok {
		return x.FeedItemResult
	}
	return nil
}

func (m *MutateOperationResponse) GetFeedItemTargetResult() *MutateFeedItemTargetResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_FeedItemTargetResult); ok {
		return x.FeedItemTargetResult
	}
	return nil
}

func (m *MutateOperationResponse) GetFeedMappingResult() *MutateFeedMappingResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_FeedMappingResult); ok {
		return x.FeedMappingResult
	}
	return nil
}

func (m *MutateOperationResponse) GetFeedResult() *MutateFeedResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_FeedResult); ok {
		return x.FeedResult
	}
	return nil
}

func (m *MutateOperationResponse) GetLabelResult() *MutateLabelResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_LabelResult); ok {
		return x.LabelResult
	}
	return nil
}

func (m *MutateOperationResponse) GetMediaFileResult() *MutateMediaFileResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_MediaFileResult); ok {
		return x.MediaFileResult
	}
	return nil
}

func (m *MutateOperationResponse) GetRemarketingActionResult() *MutateRemarketingActionResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_RemarketingActionResult); ok {
		return x.RemarketingActionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetSharedCriterionResult() *MutateSharedCriterionResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_SharedCriterionResult); ok {
		return x.SharedCriterionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetSharedSetResult() *MutateSharedSetResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_SharedSetResult); ok {
		return x.SharedSetResult
	}
	return nil
}

func (m *MutateOperationResponse) GetUserListResult() *MutateUserListResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_UserListResult); ok {
		return x.UserListResult
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MutateOperationResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MutateOperationResponse_AdGroupAdLabelResult)(nil),
		(*MutateOperationResponse_AdGroupAdResult)(nil),
		(*MutateOperationResponse_AdGroupBidModifierResult)(nil),
		(*MutateOperationResponse_AdGroupCriterionLabelResult)(nil),
		(*MutateOperationResponse_AdGroupCriterionResult)(nil),
		(*MutateOperationResponse_AdGroupExtensionSettingResult)(nil),
		(*MutateOperationResponse_AdGroupFeedResult)(nil),
		(*MutateOperationResponse_AdGroupLabelResult)(nil),
		(*MutateOperationResponse_AdGroupResult)(nil),
		(*MutateOperationResponse_AdParameterResult)(nil),
		(*MutateOperationResponse_AdResult)(nil),
		(*MutateOperationResponse_AssetResult)(nil),
		(*MutateOperationResponse_BiddingStrategyResult)(nil),
		(*MutateOperationResponse_CampaignBidModifierResult)(nil),
		(*MutateOperationResponse_CampaignBudgetResult)(nil),
		(*MutateOperationResponse_CampaignCriterionResult)(nil),
		(*MutateOperationResponse_CampaignDraftResult)(nil),
		(*MutateOperationResponse_CampaignExperimentResult)(nil),
		(*MutateOperationResponse_CampaignExtensionSettingResult)(nil),
		(*MutateOperationResponse_CampaignFeedResult)(nil),
		(*MutateOperationResponse_CampaignLabelResult)(nil),
		(*MutateOperationResponse_CampaignResult)(nil),
		(*MutateOperationResponse_CampaignSharedSetResult)(nil),
		(*MutateOperationResponse_ConversionActionResult)(nil),
		(*MutateOperationResponse_CustomerExtensionSettingResult)(nil),
		(*MutateOperationResponse_CustomerFeedResult)(nil),
		(*MutateOperationResponse_CustomerLabelResult)(nil),
		(*MutateOperationResponse_CustomerNegativeCriterionResult)(nil),
		(*MutateOperationResponse_CustomerResult)(nil),
		(*MutateOperationResponse_ExtensionFeedItemResult)(nil),
		(*MutateOperationResponse_FeedItemResult)(nil),
		(*MutateOperationResponse_FeedItemTargetResult)(nil),
		(*MutateOperationResponse_FeedMappingResult)(nil),
		(*MutateOperationResponse_FeedResult)(nil),
		(*MutateOperationResponse_LabelResult)(nil),
		(*MutateOperationResponse_MediaFileResult)(nil),
		(*MutateOperationResponse_RemarketingActionResult)(nil),
		(*MutateOperationResponse_SharedCriterionResult)(nil),
		(*MutateOperationResponse_SharedSetResult)(nil),
		(*MutateOperationResponse_UserListResult)(nil),
	}
}

func init() {
	proto.RegisterType((*SearchGoogleAdsRequest)(nil), "google.ads.googleads.v3.services.SearchGoogleAdsRequest")
	proto.RegisterType((*SearchGoogleAdsResponse)(nil), "google.ads.googleads.v3.services.SearchGoogleAdsResponse")
	proto.RegisterType((*SearchGoogleAdsStreamRequest)(nil), "google.ads.googleads.v3.services.SearchGoogleAdsStreamRequest")
	proto.RegisterType((*SearchGoogleAdsStreamResponse)(nil), "google.ads.googleads.v3.services.SearchGoogleAdsStreamResponse")
	proto.RegisterType((*GoogleAdsRow)(nil), "google.ads.googleads.v3.services.GoogleAdsRow")
	proto.RegisterType((*MutateGoogleAdsRequest)(nil), "google.ads.googleads.v3.services.MutateGoogleAdsRequest")
	proto.RegisterType((*MutateGoogleAdsResponse)(nil), "google.ads.googleads.v3.services.MutateGoogleAdsResponse")
	proto.RegisterType((*MutateOperation)(nil), "google.ads.googleads.v3.services.MutateOperation")
	proto.RegisterType((*MutateOperationResponse)(nil), "google.ads.googleads.v3.services.MutateOperationResponse")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/google_ads_service.proto", fileDescriptor_da24cac89ef496be)
}

var fileDescriptor_da24cac89ef496be = []byte{
	// 5686 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x7d, 0xcb, 0x73, 0x1c, 0x47,
	0x72, 0xf7, 0x37, 0xe0, 0x92, 0x04, 0x0b, 0x20, 0x1e, 0x05, 0x82, 0x28, 0x82, 0x4f, 0x41, 0x94,
	0x44, 0x51, 0x12, 0x20, 0x3e, 0xf4, 0x20, 0xf8, 0x12, 0x1e, 0x24, 0xa5, 0x15, 0xb9, 0xc4, 0xd7,
	0xa0, 0xa8, 0xe7, 0x7a, 0xb6, 0xd0, 0x5d, 0x33, 0x68, 0x61, 0xa6, 0x7b, 0xd8, 0xdd, 0x03, 0x12,
	0xd2, 0x4a, 0xab, 0xd5, 0xae, 0xbd, 0xe1, 0xb0, 0x63, 0x23, 0x1c, 0xb2, 0x1d, 0xe1, 0xab, 0x8f,
	0xfe, 0x33, 0x7c, 0x71, 0xc4, 0x86, 0x2f, 0x0e, 0x1f, 0xec, 0x90, 0x2f, 0x3e, 0x38, 0x7c, 0xf0,
	0xc5, 0xe1, 0x83, 0x6f, 0x3e, 0x38, 0xba, 0xba, 0xba, 0xbb, 0xaa, 0xba, 0x1a, 0x93, 0x35, 0x5a,
	0xdf, 0xa6, 0xb3, 0xfa, 0x97, 0x99, 0x5d, 0x9d, 0x59, 0x95, 0x95, 0x9d, 0x09, 0xa0, 0x6b, 0xed,
	0x30, 0x6c, 0x77, 0xd8, 0x12, 0xf5, 0xe2, 0xa5, 0xec, 0x67, 0xfa, 0x6b, 0xf7, 0xca, 0x52, 0xcc,
	0xa2, 0x5d, 0xdf, 0x65, 0x39, 0xb5, 0x49, 0xbd, 0xb8, 0x29, 0x68, 0x8b, 0xbd, 0x28, 0x4c, 0x42,
	0x7c, 0x2e, 0x1b, 0x59, 0xa4, 0x5e, 0xbc, 0x58, 0x40, 0x17, 0x77, 0xaf, 0x2c, 0xe6, 0xd0, 0xf9,
	0x57, 0xeb, 0x98, 0xbb, 0x61, 0xb7, 0x1b, 0x06, 0x4b, 0x5d, 0x96, 0x44, 0xbe, 0x1b, 0x67, 0xfc,
	0xe6, 0x5f, 0x1b, 0x70, 0x77, 0xcc, 0xda, 0x5d, 0x16, 0x24, 0xf9, 0xed, 0x6f, 0xd5, 0xdd, 0xce,
	0x82, 0x7e, 0x37, 0x5e, 0x8a, 0xfb, 0xdd, 0x2e, 0x8d, 0xf6, 0x9a, 0x51, 0xf8, 0xb4, 0x19, 0xb3,
	0x24, 0xf1, 0x83, 0xb6, 0x00, 0xbe, 0x59, 0x07, 0x8c, 0x58, 0x1c, 0xf6, 0xa3, 0xf4, 0x99, 0xa9,
	0xeb, 0x86, 0xfd, 0x20, 0x69, 0x6e, 0xf5, 0xbd, 0x36, 0x4b, 0x04, 0xee, 0xb6, 0x2d, 0xae, 0xd9,
	0x8b, 0xc2, 0x5e, 0x18, 0xd3, 0x8e, 0x60, 0xf0, 0x3a, 0x80, 0x81, 0xd7, 0x6c, 0x47, 0x61, 0xbf,
	0x27, 0x10, 0x57, 0xe0, 0x88, 0x26, 0xf5, 0x04, 0xe8, 0x96, 0x15, 0xa8, 0x49, 0xe3, 0x98, 0x25,
	0xcd, 0x5d, 0x9f, 0x3d, 0x15, 0xf8, 0x6b, 0x76, 0xf8, 0x0e, 0xdd, 0x62, 0x9d, 0x61, 0x44, 0xf7,
	0x3d, 0x9f, 0x05, 0x2e, 0x93, 0x45, 0xdf, 0xb4, 0xc0, 0x6f, 0xf9, 0x5e, 0xb3, 0x1b, 0x7a, 0x7e,
	0xcb, 0x67, 0x91, 0x80, 0x2f, 0x5b, 0xc0, 0xdd, 0xc8, 0x4f, 0x58, 0xe4, 0x87, 0x81, 0xc0, 0xbe,
	0x33, 0x0c, 0x56, 0x79, 0xf8, 0x3b, 0x43, 0x71, 0x88, 0xfd, 0x6e, 0xbf, 0x43, 0x93, 0x52, 0x91,
	0x55, 0x0b, 0x36, 0xec, 0x59, 0xc2, 0x82, 0x98, 0xb3, 0x51, 0x4c, 0xfc, 0x0d, 0x0b, 0x1e, 0x2d,
	0xc6, 0x3c, 0x0b, 0xcf, 0xc8, 0x61, 0xf2, 0x93, 0x5f, 0xb7, 0xc0, 0x55, 0x9e, 0xf7, 0x2a, 0x08,
	0xdc, 0xa3, 0x11, 0xed, 0xb2, 0xa4, 0x78, 0xd5, 0x6f, 0x83, 0x50, 0xb1, 0xbb, 0xcd, 0xbc, 0x7e,
	0x47, 0xb1, 0x31, 0xc8, 0x43, 0xb6, 0x59, 0x33, 0xa2, 0x41, 0x5b, 0xc1, 0xbd, 0x06, 0xc0, 0xa5,
	0xae, 0x04, 0x57, 0x70, 0xcb, 0xf7, 0x3c, 0x3f, 0x68, 0x37, 0xe3, 0x24, 0xa2, 0x09, 0x6b, 0xef,
	0xc1, 0x5f, 0xde, 0x96, 0xdf, 0xe9, 0x70, 0x24, 0x4b, 0x8a, 0xb5, 0x02, 0xb0, 0xba, 0xb8, 0xb4,
	0xdb, 0xa3, 0x7e, 0x3b, 0x80, 0x7b, 0x6b, 0x8e, 0x18, 0xd6, 0x5b, 0x0b, 0xbc, 0xc1, 0x5b, 0xdf,
	0xb2, 0x81, 0xcb, 0x0b, 0xf1, 0xb2, 0x05, 0x50, 0x77, 0xf3, 0x3b, 0xc3, 0x60, 0xab, 0x46, 0xfb,
	0xa6, 0x05, 0x1b, 0x2f, 0xa2, 0xad, 0x04, 0xee, 0x29, 0x05, 0x8e, 0x3d, 0xeb, 0xb1, 0xc8, 0x4f,
	0xb7, 0x3c, 0xf8, 0xca, 0x20, 0x81, 0x87, 0x5e, 0x19, 0x0a, 0x1e, 0x76, 0x2b, 0x43, 0x01, 0xb3,
	0x5c, 0x19, 0x0a, 0x5c, 0xbc, 0x4d, 0x23, 0xe6, 0x35, 0xad, 0x5c, 0xc8, 0xa5, 0x51, 0xe4, 0xb3,
	0xa8, 0xe9, 0x86, 0x41, 0x9c, 0xd0, 0x62, 0xa6, 0x20, 0x4f, 0xb9, 0xcd, 0x1d, 0x3c, 0x4e, 0x68,
	0xd2, 0xcf, 0x43, 0x8a, 0xcb, 0x00, 0x58, 0xc7, 0x77, 0x77, 0x2c, 0x77, 0x4b, 0x37, 0x0c, 0x76,
	0x59, 0xc4, 0x5f, 0x06, 0x75, 0x25, 0x23, 0x82, 0x40, 0xfb, 0x51, 0xc4, 0x02, 0x77, 0x4f, 0x7f,
	0x40, 0x88, 0xef, 0xf4, 0xe3, 0x24, 0xec, 0x36, 0xfd, 0x20, 0x61, 0x11, 0x8b, 0x13, 0x8b, 0x55,
	0x82, 0x03, 0xad, 0xdc, 0x54, 0x20, 0x9a, 0x6e, 0xc7, 0x2f, 0xcd, 0xf5, 0x86, 0x35, 0xb0, 0xd9,
	0xf1, 0x83, 0x1d, 0x0b, 0x63, 0xcf, 0xd1, 0x3f, 0xc4, 0xd8, 0x73, 0x1e, 0x96, 0xc6, 0x9e, 0xc3,
	0x64, 0x63, 0xbf, 0x69, 0x81, 0xeb, 0xd2, 0x80, 0xb6, 0x53, 0x7c, 0xf9, 0xc4, 0x6b, 0x16, 0xf0,
	0x80, 0xb5, 0x69, 0xe2, 0xef, 0xb2, 0xca, 0xfa, 0x06, 0xd0, 0xc1, 0x63, 0x09, 0xf5, 0x3b, 0xcd,
	0x5e, 0x87, 0xba, 0x2c, 0x5d, 0x5d, 0x64, 0x6b, 0x06, 0xbc, 0x33, 0xcf, 0x8f, 0x7b, 0x1d, 0xba,
	0xd7, 0xdc, 0x61, 0x7b, 0x4f, 0xc3, 0xc8, 0x93, 0xd1, 0x6f, 0x80, 0xd0, 0x09, 0xd5, 0xf6, 0x11,
	0x80, 0x85, 0x79, 0x61, 0x97, 0xfa, 0x41, 0xd3, 0x4d, 0xf7, 0xc9, 0x30, 0xca, 0x77, 0xca, 0xf7,
	0x01, 0xc0, 0xbd, 0x80, 0x76, 0x7d, 0xb7, 0x19, 0x33, 0x1a, 0xb9, 0xdb, 0xe2, 0x14, 0xc3, 0x7f,
	0x26, 0x2c, 0xea, 0xca, 0x5a, 0x00, 0x0c, 0x8e, 0x3d, 0xeb, 0xd1, 0xc0, 0x63, 0x69, 0xcc, 0x1b,
	0xf0, 0x9d, 0xbb, 0x47, 0xd5, 0x18, 0xe1, 0x3a, 0x84, 0x47, 0x6e, 0xab, 0xa9, 0xc5, 0x35, 0xfd,
	0x84, 0x75, 0x05, 0xf8, 0xd5, 0xc1, 0x60, 0xc9, 0x48, 0x2f, 0xc1, 0xee, 0x96, 0x05, 0xbc, 0x6d,
	0x01, 0x69, 0x26, 0x34, 0x2a, 0x77, 0xdc, 0xab, 0x40, 0x64, 0x97, 0xf6, 0x7a, 0xa5, 0xfb, 0xdd,
	0x04, 0xa2, 0xb8, 0x25, 0x6e, 0x87, 0x1d, 0x8f, 0x45, 0xf2, 0x64, 0x02, 0x0e, 0x3f, 0x6d, 0x16,
	0x68, 0xa0, 0xeb, 0x10, 0x50, 0x28, 0x9e, 0x6e, 0x88, 0x55, 0xb5, 0xcd, 0xc2, 0x76, 0x44, 0x7b,
	0xdb, 0xbe, 0x6b, 0xe9, 0x36, 0x59, 0xf4, 0x6b, 0x74, 0x3a, 0xc0, 0x7b, 0xd9, 0x0e, 0x13, 0xd6,
	0x11, 0x11, 0xb4, 0x84, 0xbc, 0x05, 0x45, 0xf6, 0x58, 0xd4, 0x0a, 0xa3, 0xae, 0xee, 0x79, 0x80,
	0xf7, 0x9a, 0xbb, 0x79, 0xaf, 0x43, 0x2d, 0xd6, 0x18, 0x19, 0xd5, 0xd4, 0x0e, 0xb5, 0xb6, 0x70,
	0x2d, 0x6a, 0xbd, 0x61, 0x09, 0x17, 0x17, 0xf0, 0xf8, 0x4f, 0x41, 0x17, 0x0b, 0xad, 0xca, 0xc6,
	0x62, 0xe2, 0xec, 0x8e, 0x10, 0xf2, 0x7e, 0x72, 0x0d, 0x72, 0xbb, 0x79, 0x21, 0x82, 0x41, 0xdb,
	0xfd, 0x14, 0x66, 0x1f, 0x3b, 0x75, 0x42, 0x97, 0x07, 0xc3, 0x96, 0xa6, 0x98, 0xed, 0x79, 0x9e,
	0xd9, 0x09, 0x00, 0xb1, 0x57, 0x97, 0x79, 0x3e, 0x6d, 0xb6, 0xfc, 0x8e, 0xc8, 0x40, 0xcd, 0xaf,
	0x03, 0x30, 0xe1, 0x96, 0xdf, 0x61, 0x4d, 0xda, 0xeb, 0x15, 0x9b, 0x87, 0xfe, 0xc0, 0xb7, 0xc0,
	0x5c, 0x3c, 0xb6, 0xeb, 0xbb, 0x95, 0x09, 0x83, 0x68, 0xde, 0x4f, 0x68, 0xc2, 0x9a, 0x9f, 0x87,
	0x5b, 0x70, 0x1f, 0x08, 0x5b, 0xad, 0x8e, 0x1f, 0xb0, 0x66, 0x3f, 0x66, 0x51, 0xd3, 0xa3, 0x09,
	0x95, 0xe0, 0xef, 0x01, 0xe0, 0x3d, 0x16, 0xd1, 0x84, 0x1f, 0x12, 0xf7, 0xe2, 0x74, 0x41, 0xcf,
	0x43, 0x50, 0x4d, 0x7b, 0x80, 0x43, 0xf4, 0xa8, 0xef, 0x35, 0xc3, 0xa8, 0x4d, 0x83, 0x72, 0x23,
	0xd5, 0x77, 0xcf, 0x1b, 0x10, 0x36, 0x11, 0x0b, 0x12, 0xda, 0x11, 0x31, 0xb7, 0x8c, 0x06, 0x3c,
	0x4f, 0x2f, 0x0a, 0xbd, 0xbe, 0x9b, 0x34, 0xf3, 0x43, 0x73, 0xdd, 0xdb, 0x5c, 0x86, 0xb3, 0xaa,
	0x2c, 0xa7, 0x80, 0xc0, 0x2f, 0x62, 0x6e, 0xd8, 0xed, 0xb2, 0xc0, 0x93, 0x4f, 0x83, 0xcb, 0x10,
	0x5c, 0x97, 0x46, 0x3b, 0x8c, 0xbf, 0x10, 0xe5, 0x10, 0x00, 0x58, 0xfc, 0x6b, 0xa6, 0x1c, 0x82,
	0xcc, 0x8e, 0x54, 0x7a, 0x90, 0x78, 0x19, 0x8c, 0x2c, 0x0f, 0x63, 0x2b, 0x10, 0x4c, 0xc8, 0xb7,
	0xff, 0xba, 0xdd, 0x06, 0x30, 0xbd, 0x49, 0xd8, 0xf3, 0xdd, 0x21, 0x1c, 0x2c, 0xc3, 0xd9, 0x85,
	0xa2, 0xdc, 0xb1, 0xb4, 0xe3, 0xd1, 0x25, 0x20, 0xac, 0xe3, 0xc7, 0x16, 0x06, 0x97, 0x41, 0x0c,
	0x8b, 0x26, 0x60, 0x43, 0xd8, 0xf5, 0x3d, 0x16, 0x0e, 0xca, 0x51, 0x16, 0xc9, 0xfa, 0x4a, 0x62,
	0x56, 0xcd, 0xd9, 0xd7, 0x2b, 0x6b, 0xe4, 0xa0, 0x62, 0xd7, 0xe1, 0x58, 0x39, 0xdb, 0xa3, 0x71,
	0xb9, 0x07, 0xe7, 0xa2, 0xa5, 0x59, 0x35, 0x46, 0x2b, 0xc3, 0x30, 0x52, 0x59, 0xbc, 0x07, 0x67,
	0x51, 0x39, 0x62, 0x6a, 0xac, 0x6e, 0xc0, 0x59, 0xf1, 0x98, 0x57, 0x45, 0xdf, 0x84, 0xa3, 0x4d,
	0x53, 0xf1, 0x16, 0x1c, 0xae, 0x02, 0xaf, 0x43, 0x80, 0x45, 0xea, 0x55, 0x03, 0x5f, 0x82, 0x80,
	0x55, 0xc8, 0xd5, 0xc1, 0x10, 0xfe, 0x35, 0x42, 0x45, 0xdd, 0x1e, 0x88, 0xd2, 0x33, 0xa9, 0xd6,
	0x96, 0x6b, 0xcc, 0x53, 0x6a, 0x5c, 0x6e, 0x59, 0x70, 0xc9, 0xbe, 0xff, 0xd8, 0x1a, 0xac, 0x29,
	0xf3, 0x68, 0x69, 0x27, 0x6a, 0xd6, 0x51, 0x83, 0xaf, 0xc2, 0xe1, 0x65, 0xf2, 0xd1, 0xda, 0x67,
	0xea, 0x73, 0x90, 0xd6, 0x3e, 0xa3, 0xa4, 0x22, 0x87, 0x9f, 0x8b, 0xe1, 0x7c, 0xa6, 0x4c, 0x4c,
	0x0e, 0x3b, 0x89, 0xe5, 0x26, 0xaa, 0xf1, 0x18, 0xbc, 0x90, 0x57, 0x72, 0x86, 0xf6, 0xaf, 0xa1,
	0x36, 0x3b, 0x66, 0xff, 0x1a, 0xe4, 0x24, 0x99, 0xfd, 0x6b, 0x50, 0x72, 0x65, 0x1a, 0xfc, 0xc7,
	0x70, 0x78, 0x35, 0xe7, 0x65, 0xff, 0x4a, 0x73, 0x5e, 0xb6, 0xaf, 0xd4, 0x90, 0xb5, 0xd1, 0x78,
	0xbc, 0x3d, 0x90, 0x47, 0x1d, 0xf2, 0xb6, 0x05, 0x52, 0xe4, 0x2d, 0x6c, 0x57, 0x71, 0x39, 0x39,
	0xa3, 0x81, 0xaf, 0xc0, 0xc0, 0xb6, 0xeb, 0xb8, 0xe9, 0x5d, 0x0f, 0xae, 0x35, 0x28, 0x4f, 0x78,
	0xd6, 0x6b, 0x67, 0x35, 0xc0, 0xb6, 0x9e, 0x66, 0x3d, 0x5a, 0xb6, 0x56, 0xbf, 0xd6, 0xdf, 0x07,
	0x1b, 0x47, 0x11, 0x55, 0x6a, 0xc8, 0x53, 0x39, 0xb2, 0xe7, 0x2f, 0xd1, 0x20, 0x08, 0x13, 0x1e,
	0x43, 0xe6, 0x1f, 0x2c, 0xe6, 0xa4, 0x51, 0x25, 0xf7, 0x7e, 0x56, 0x1a, 0x68, 0xf9, 0xac, 0xe3,
	0x35, 0xb7, 0xd8, 0x36, 0xdd, 0xf5, 0xc3, 0x3c, 0xab, 0x2f, 0x8a, 0x37, 0x96, 0xf8, 0xd5, 0x56,
	0xbf, 0x25, 0xee, 0xea, 0xd2, 0x78, 0x47, 0xe3, 0x1d, 0xf5, 0xdc, 0x25, 0xf9, 0x2b, 0xc9, 0xc2,
	0x7f, 0x8e, 0xa0, 0xe3, 0x9b, 0xfc, 0x48, 0x72, 0x8f, 0xdf, 0xb1, 0xe2, 0xc5, 0x0e, 0x7b, 0xd2,
	0x67, 0x71, 0x82, 0xcf, 0xa3, 0xb1, 0xc2, 0xc5, 0x7c, 0x8f, 0x34, 0xce, 0x35, 0x2e, 0x1c, 0x59,
	0x3d, 0xf0, 0xaf, 0x2b, 0x23, 0x0e, 0xca, 0xe9, 0xef, 0x79, 0xf8, 0x04, 0x3a, 0xf8, 0xa4, 0xcf,
	0xa2, 0x3d, 0x32, 0x52, 0x8e, 0x67, 0x14, 0x7c, 0x1a, 0x21, 0x9e, 0xca, 0x48, 0xc2, 0x1d, 0x16,
	0x90, 0x03, 0xe9, 0xb8, 0x73, 0x24, 0xa5, 0x3c, 0x4a, 0x09, 0xf8, 0x24, 0xe2, 0x17, 0xcd, 0xd8,
	0xff, 0x82, 0x91, 0x1f, 0x9d, 0x6b, 0x5c, 0x38, 0xe8, 0x8c, 0xa6, 0x84, 0x4d, 0xff, 0x0b, 0x86,
	0x9f, 0x47, 0x47, 0x77, 0x69, 0xc7, 0xf7, 0xd2, 0x93, 0x76, 0x18, 0x74, 0xf6, 0xc8, 0xc1, 0x73,
	0x8d, 0x0b, 0xa3, 0xce, 0x78, 0x4e, 0x7c, 0x18, 0x74, 0xf6, 0xf0, 0x75, 0x34, 0x1f, 0xb1, 0xa4,
	0x1f, 0x05, 0xcd, 0x24, 0x4c, 0xcf, 0xa2, 0x11, 0x8b, 0xfb, 0x9d, 0x24, 0x6e, 0xf2, 0xba, 0x0d,
	0x72, 0x98, 0x23, 0xe6, 0xb2, 0x3b, 0x1e, 0xa5, 0x37, 0x38, 0xd9, 0xf8, 0x5a, 0x3a, 0x8c, 0x77,
	0xd1, 0x8c, 0xa1, 0xac, 0x84, 0x8c, 0x9e, 0x6b, 0x5c, 0x98, 0xb8, 0x7c, 0x77, 0xb1, 0xae, 0x1e,
	0x86, 0x17, 0xa4, 0x2c, 0x6e, 0x66, 0x48, 0x27, 0x7c, 0xba, 0x99, 0xe1, 0xee, 0x04, 0xfd, 0x6e,
	0x95, 0xea, 0x4c, 0xc7, 0x3a, 0x69, 0xe1, 0xef, 0x46, 0xd0, 0x5c, 0x65, 0xc6, 0xe3, 0x5e, 0x18,
	0xc4, 0x0c, 0xbf, 0x8b, 0x0e, 0x8b, 0x67, 0x20, 0x8d, 0x73, 0x07, 0x2e, 0x8c, 0x5d, 0x5e, 0x5c,
	0x1c, 0x54, 0x97, 0xb3, 0x58, 0x72, 0x09, 0x9f, 0x3a, 0x39, 0x1c, 0xbf, 0x88, 0x26, 0x03, 0xf6,
	0x2c, 0x69, 0x4a, 0x2f, 0x80, 0xbf, 0x20, 0xe7, 0x68, 0x4a, 0xde, 0x28, 0x5e, 0xc2, 0x22, 0x9a,
	0x31, 0xcd, 0x5d, 0xfa, 0xb2, 0x0e, 0x38, 0xd3, 0x49, 0x65, 0xd6, 0xae, 0x21, 0x54, 0x1a, 0x17,
	0x7f, 0x29, 0x63, 0x97, 0xe7, 0x73, 0x25, 0x73, 0xfb, 0x5b, 0xbc, 0x9b, 0xde, 0xf2, 0x80, 0xc6,
	0x3b, 0xce, 0x91, 0x56, 0xfe, 0x13, 0x3f, 0x44, 0x63, 0xd2, 0x84, 0x93, 0x43, 0x1c, 0x6b, 0xfb,
	0x80, 0xa8, 0x9c, 0xd0, 0x85, 0x7f, 0x6a, 0xa0, 0x53, 0xda, 0x4c, 0x6e, 0x26, 0x11, 0xa3, 0xdd,
	0xdf, 0x9b, 0x05, 0xd7, 0xd8, 0xc8, 0x81, 0xff, 0x6b, 0x1b, 0xf9, 0xef, 0x06, 0x3a, 0x5d, 0xf3,
	0x64, 0xbf, 0x77, 0x4b, 0x51, 0xdf, 0xe8, 0xc8, 0x0f, 0x78, 0xa3, 0x07, 0x7e, 0xf0, 0x1b, 0xfd,
	0xee, 0x3e, 0x1a, 0x97, 0x07, 0xf1, 0x87, 0x68, 0x42, 0x2d, 0xc3, 0x22, 0x17, 0xb9, 0x90, 0xd7,
	0x6b, 0x85, 0x14, 0x87, 0xed, 0xc5, 0x95, 0x0c, 0xb8, 0xca, 0x71, 0xce, 0x51, 0x2a, 0x5f, 0xe2,
	0x1e, 0x9a, 0xab, 0xa9, 0xef, 0x22, 0xaf, 0x70, 0x09, 0x6f, 0xdb, 0x4a, 0xd8, 0x10, 0x78, 0x67,
	0x96, 0x9a, 0xc8, 0xf8, 0x0e, 0x1a, 0xcd, 0x0f, 0x6e, 0x62, 0xa6, 0x2e, 0x42, 0x44, 0x78, 0xf7,
	0x52, 0x84, 0x73, 0x98, 0x66, 0x3f, 0xf0, 0x7d, 0x34, 0x26, 0x9d, 0xea, 0xc9, 0x14, 0xe7, 0xf4,
	0x2a, 0x9c, 0xd3, 0x8a, 0xe7, 0x1c, 0xa1, 0xf9, 0x4f, 0xfc, 0x39, 0x3a, 0x6e, 0x2e, 0x1f, 0x23,
	0xbf, 0x6a, 0x70, 0xce, 0x6f, 0xd8, 0x70, 0x5e, 0x49, 0xe1, 0x8f, 0x7d, 0xf6, 0xd4, 0xc1, 0xb4,
	0x42, 0xc3, 0x9f, 0xa1, 0xe9, 0x4a, 0x46, 0x83, 0x3c, 0xe3, 0x52, 0x2e, 0xd9, 0x48, 0xb9, 0x9f,
	0x02, 0x9d, 0x09, 0xaa, 0x5c, 0xe3, 0x1d, 0xf9, 0x49, 0xe4, 0xfa, 0x16, 0x72, 0x8d, 0x8b, 0x78,
	0xd3, 0x42, 0x84, 0x80, 0xf3, 0x27, 0x99, 0xa1, 0x55, 0x22, 0xde, 0x46, 0xb3, 0xc6, 0xf4, 0x08,
	0x21, 0xb6, 0x93, 0xb6, 0xea, 0x7b, 0x0f, 0x04, 0xb8, 0x98, 0x34, 0x89, 0x86, 0x29, 0xc2, 0xd5,
	0xcc, 0x07, 0x99, 0xe6, 0x62, 0xae, 0xc0, 0xc5, 0xac, 0xe5, 0x50, 0x67, 0x8a, 0x6a, 0x14, 0xfc,
	0x04, 0x91, 0xba, 0x2c, 0x0d, 0xd9, 0x83, 0xfb, 0x82, 0xc6, 0x36, 0x7b, 0x4b, 0xb3, 0xd4, 0x44,
	0xc6, 0xdf, 0x34, 0xd0, 0xe9, 0x7d, 0xcb, 0xe7, 0x48, 0xc0, 0x05, 0xdf, 0x1c, 0x42, 0xf0, 0x66,
	0xc1, 0xc4, 0x99, 0xa7, 0xb5, 0x63, 0xf8, 0x29, 0x9a, 0xaf, 0xcf, 0x07, 0x91, 0x1e, 0x17, 0xbf,
	0x0c, 0x17, 0x7f, 0x27, 0x67, 0x91, 0xaf, 0xea, 0x73, 0xd4, 0x3c, 0x80, 0x1d, 0x74, 0x54, 0xc9,
	0x1e, 0x91, 0xb5, 0x01, 0xcb, 0x66, 0x45, 0xd6, 0x5d, 0xc6, 0x3c, 0x67, 0x8c, 0x96, 0x17, 0xf8,
	0x03, 0x34, 0xa1, 0xe6, 0x94, 0x48, 0xcc, 0x99, 0x2e, 0xc1, 0x99, 0x66, 0xef, 0x6b, 0x9c, 0x4a,
	0x57, 0xd8, 0x43, 0x33, 0x86, 0x52, 0x3f, 0xb2, 0xc3, 0x79, 0x5f, 0x85, 0xf3, 0x96, 0x5e, 0xc9,
	0x34, 0xd5, 0x49, 0xd8, 0x41, 0xe3, 0x72, 0x62, 0x8a, 0x7c, 0xdb, 0xb0, 0x98, 0x90, 0x8d, 0x1c,
	0x96, 0x4e, 0x48, 0x71, 0xc1, 0x27, 0x44, 0xa9, 0xfb, 0x23, 0xaf, 0xc3, 0x27, 0xa4, 0xcd, 0x9c,
	0x14, 0xc7, 0xdd, 0x7f, 0x9c, 0x4a, 0x57, 0xf8, 0x53, 0x34, 0xa5, 0x17, 0x22, 0x92, 0x8f, 0x2d,
	0x56, 0xb0, 0x4d, 0x81, 0xe4, 0xac, 0x27, 0xa8, 0x72, 0x8d, 0x3f, 0x41, 0x93, 0x5a, 0x65, 0x04,
	0xf9, 0x14, 0xcc, 0x7b, 0x9d, 0x23, 0xd7, 0x04, 0xd0, 0x99, 0xf0, 0x94, 0x6b, 0x7c, 0x0b, 0x1d,
	0xe4, 0x6b, 0x3b, 0xf1, 0x39, 0xc7, 0x0b, 0x10, 0x6d, 0xd3, 0xfb, 0x9d, 0x0c, 0x86, 0x7f, 0x8a,
	0xa6, 0xf4, 0xb4, 0x1c, 0xc1, 0x9c, 0xd5, 0x65, 0x00, 0xab, 0xd5, 0x0c, 0xba, 0x29, 0x90, 0xce,
	0xe4, 0x96, 0x4a, 0xc0, 0x8f, 0xd0, 0x51, 0xa5, 0x0a, 0x92, 0xbc, 0x0c, 0x7e, 0x5b, 0xab, 0x19,
	0x6e, 0x33, 0x85, 0x39, 0xe3, 0x5b, 0xd2, 0x55, 0x3a, 0xa1, 0x5a, 0x12, 0x8f, 0xcc, 0x80, 0x27,
	0x74, 0x4d, 0x20, 0x45, 0xf8, 0x30, 0xe1, 0x2a, 0xd7, 0xf8, 0x1e, 0x1a, 0xcd, 0x29, 0x22, 0x66,
	0x7a, 0xc5, 0x82, 0xa9, 0x53, 0x80, 0x71, 0x17, 0x1d, 0x37, 0xd7, 0x65, 0x92, 0x3b, 0x9c, 0xed,
	0x5b, 0x16, 0x6c, 0x95, 0x8d, 0xeb, 0x98, 0x6b, 0xa0, 0xe2, 0xcf, 0xd1, 0xac, 0x31, 0x3d, 0x4a,
	0xe6, 0xc1, 0xbb, 0x64, 0x31, 0x33, 0xd2, 0xd6, 0x35, 0xe3, 0x56, 0x89, 0xd8, 0x45, 0xb8, 0x9a,
	0x04, 0x25, 0xc7, 0xc0, 0xab, 0x47, 0x2e, 0xa8, 0xdc, 0xbc, 0xa6, 0x5d, 0x9d, 0x84, 0xbf, 0x6d,
	0xa0, 0xd3, 0xfb, 0x16, 0x79, 0x92, 0x90, 0x0b, 0xbc, 0x35, 0x8c, 0x40, 0x69, 0xe1, 0x3a, 0xe9,
	0xd6, 0x0f, 0xa6, 0x61, 0xaa, 0x9a, 0xab, 0x25, 0x97, 0xc0, 0x61, 0x6a, 0x2e, 0x74, 0x3d, 0xc5,
	0x39, 0x47, 0x5d, 0xf9, 0x12, 0xb7, 0xd0, 0x8c, 0x21, 0x8b, 0x4b, 0x1e, 0x81, 0xc3, 0x8c, 0x9c,
	0xfb, 0x9d, 0x02, 0xec, 0x14, 0x2f, 0xa5, 0xa4, 0xe1, 0x3d, 0x34, 0x5f, 0x9f, 0xe9, 0x25, 0x4f,
	0xb8, 0xb8, 0xeb, 0x56, 0xe2, 0xb4, 0xed, 0x90, 0xb8, 0x35, 0x23, 0xa9, 0xef, 0x2b, 0x99, 0x61,
	0x72, 0x1b, 0xec, 0xfb, 0xb9, 0x34, 0xbe, 0x21, 0x8e, 0xbb, 0xd2, 0x95, 0xf2, 0x46, 0xb2, 0x1d,
	0xb1, 0x63, 0xfd, 0x46, 0xb2, 0x2d, 0xb1, 0xd0, 0xae, 0xd8, 0x13, 0x0d, 0x29, 0x61, 0x72, 0xc6,
	0xda, 0xaa, 0x37, 0x39, 0x78, 0x93, 0x25, 0xa5, 0x55, 0x17, 0xa4, 0x74, 0xbd, 0xd5, 0xab, 0x61,
	0xc9, 0x2a, 0x78, 0xbd, 0x5d, 0xcb, 0xa0, 0x6b, 0x02, 0xe9, 0x4c, 0xba, 0x2a, 0x81, 0xcf, 0xb9,
	0x5c, 0x32, 0x4b, 0x5e, 0x80, 0xcf, 0x39, 0xc7, 0x6d, 0x72, 0x98, 0x33, 0xee, 0x4a, 0x57, 0xf8,
	0x67, 0x68, 0xba, 0x92, 0xe9, 0x26, 0x6d, 0x70, 0xa8, 0xba, 0x56, 0x60, 0x57, 0x38, 0xd4, 0x99,
	0x72, 0x35, 0x0a, 0x7e, 0x1f, 0xa1, 0xb2, 0x66, 0x97, 0x7c, 0x01, 0x3e, 0xfb, 0xac, 0xa5, 0x20,
	0xbe, 0x2a, 0x1e, 0x71, 0xf3, 0x9f, 0x98, 0xa2, 0xe9, 0x4a, 0x45, 0x2e, 0xf9, 0xa3, 0x06, 0x5c,
	0x5f, 0x01, 0x2e, 0xa6, 0x79, 0xca, 0xd5, 0x28, 0x7c, 0x07, 0x52, 0x2b, 0x77, 0xc9, 0x36, 0x7c,
	0x07, 0xe2, 0xc8, 0xf7, 0x04, 0xd0, 0x99, 0x70, 0x95, 0x6b, 0xbe, 0x03, 0x89, 0x24, 0x06, 0x69,
	0xc0, 0x77, 0x20, 0x01, 0x71, 0x0a, 0x30, 0xdf, 0x12, 0x4c, 0x95, 0xac, 0xe4, 0x26, 0x7c, 0x4b,
	0x10, 0xf8, 0x07, 0x19, 0xfc, 0xbe, 0x1f, 0xec, 0x38, 0x33, 0x6e, 0x95, 0x88, 0xdb, 0xe8, 0x98,
	0xa9, 0x4c, 0x98, 0xdc, 0x82, 0x2f, 0x68, 0x02, 0xbe, 0xc6, 0xd1, 0x5c, 0x12, 0x76, 0x2b, 0xb4,
	0x72, 0xe6, 0x0b, 0x41, 0xe4, 0xae, 0xe5, 0xcc, 0xe7, 0xfc, 0xf2, 0x99, 0xcf, 0xaf, 0xf9, 0x62,
	0x59, 0xfb, 0x3d, 0x86, 0x44, 0xf0, 0xc5, 0x52, 0x30, 0x31, 0x2c, 0x96, 0x35, 0x23, 0xdc, 0x71,
	0xe5, 0xef, 0x37, 0xe4, 0x1d, 0xb8, 0xe3, 0x0a, 0x9c, 0x58, 0x2c, 0xa5, 0x2b, 0xbe, 0x58, 0x2a,
	0xdf, 0x75, 0xc8, 0xcf, 0xe1, 0x8b, 0xa5, 0x00, 0xe6, 0x8b, 0xa5, 0x7c, 0x89, 0x7f, 0x8e, 0x4e,
	0xee, 0xf3, 0xc5, 0x87, 0x7c, 0xc4, 0xa5, 0xdc, 0xb0, 0x90, 0xf2, 0x13, 0xc1, 0xa4, 0x0c, 0x09,
	0x4e, 0xb8, 0x75, 0x43, 0xa9, 0x61, 0x1b, 0xcb, 0xa3, 0xc9, 0x2e, 0xd8, 0xb0, 0xd7, 0x39, 0x7e,
	0x23, 0x87, 0x67, 0x19, 0x01, 0xaf, 0x4a, 0x4c, 0x0d, 0xdb, 0x54, 0x4b, 0x4d, 0x96, 0xc0, 0x86,
	0xbd, 0x9e, 0xc1, 0xdf, 0xcf, 0xd0, 0x59, 0x16, 0xc5, 0xab, 0xd0, 0xf0, 0x07, 0xe8, 0xa8, 0x52,
	0x76, 0x4d, 0x7e, 0xdd, 0x00, 0x9b, 0xc0, 0xba, 0x00, 0x66, 0x27, 0x1b, 0x4f, 0xba, 0xc2, 0xbf,
	0x6d, 0xa0, 0xe7, 0x01, 0xe5, 0xd5, 0xe4, 0x73, 0x2e, 0x6c, 0x05, 0x22, 0x2c, 0xe3, 0x96, 0xa5,
	0x31, 0x57, 0xbc, 0x38, 0xfb, 0xf1, 0x88, 0x45, 0x5d, 0x2e, 0xfe, 0x8c, 0xb7, 0xef, 0x38, 0x7e,
	0x86, 0xe6, 0xeb, 0x2b, 0xb4, 0xc9, 0x37, 0x0d, 0xf0, 0x01, 0xfd, 0x8e, 0xe0, 0x72, 0x3f, 0x63,
	0xb2, 0x41, 0xc5, 0xc9, 0x6e, 0x8e, 0x99, 0x07, 0xd2, 0x1d, 0xde, 0xf0, 0x85, 0x90, 0x7c, 0x00,
	0xde, 0xe1, 0x0b, 0xaf, 0x4d, 0x9d, 0xeb, 0xbd, 0x84, 0x75, 0x9d, 0x69, 0xa6, 0x93, 0xf0, 0x75,
	0xf4, 0x23, 0xee, 0xc0, 0x8b, 0x9c, 0xed, 0x4b, 0x00, 0xb6, 0xdc, 0x71, 0x39, 0x08, 0xbf, 0x8b,
	0x8e, 0x94, 0x8a, 0x5d, 0x06, 0x2f, 0xfe, 0x85, 0x3e, 0xa3, 0xad, 0x5c, 0x8d, 0x4f, 0xd1, 0x94,
	0xfe, 0x41, 0x92, 0x24, 0xe0, 0x85, 0x32, 0x67, 0xf8, 0x88, 0x03, 0x9d, 0x89, 0x96, 0x72, 0x8d,
	0xff, 0x3f, 0x1a, 0x97, 0x3f, 0x56, 0x92, 0x65, 0xf0, 0xc1, 0x3e, 0x65, 0xfc, 0x20, 0x43, 0x39,
	0x63, 0xad, 0xf2, 0x22, 0xf5, 0x69, 0x63, 0x99, 0x39, 0xa1, 0x60, 0x9f, 0x4e, 0x79, 0x6f, 0x94,
	0xf0, 0xcc, 0xa7, 0x5b, 0x55, 0x22, 0xfe, 0x09, 0x1a, 0x93, 0x6a, 0xd2, 0xc9, 0x05, 0x2e, 0xe1,
	0x35, 0x80, 0x84, 0x7b, 0x1c, 0xc5, 0x19, 0xa3, 0x76, 0xf1, 0x3b, 0x35, 0x2c, 0x43, 0xb9, 0x3a,
	0x99, 0x03, 0x1b, 0xd6, 0x3d, 0x16, 0x66, 0x33, 0x5b, 0x84, 0x1c, 0xd3, 0x6d, 0x9d, 0x94, 0xee,
	0x7c, 0x5a, 0x5d, 0x3b, 0xf9, 0x0a, 0xfc, 0x42, 0xef, 0x15, 0xc8, 0x2c, 0x45, 0xd1, 0x56, 0xae,
	0xd3, 0x55, 0xce, 0x54, 0xfa, 0x4e, 0x9e, 0x82, 0x57, 0x39, 0x9e, 0xfc, 0x51, 0xd7, 0x53, 0xdc,
	0xae, 0xd0, 0x52, 0xb3, 0xd4, 0xab, 0xe4, 0xc9, 0x15, 0xf0, 0x53, 0xbc, 0x9b, 0x42, 0xb9, 0xa4,
	0xec, 0x29, 0xb6, 0x95, 0xeb, 0xf4, 0xc8, 0x6d, 0x2e, 0xa4, 0x27, 0xf7, 0xc0, 0x47, 0x6e, 0x2e,
	0x62, 0xa3, 0xc4, 0x67, 0x47, 0xee, 0x6d, 0x03, 0x35, 0xf5, 0x02, 0x65, 0x4b, 0x98, 0x05, 0x7b,
	0x81, 0xbc, 0x17, 0x8c, 0xed, 0x48, 0x9b, 0x80, 0xc4, 0xb2, 0xd7, 0xa1, 0x01, 0x39, 0x67, 0xcb,
	0x72, 0xa3, 0x43, 0x83, 0x82, 0x65, 0x7a, 0x91, 0x3a, 0x96, 0xb1, 0x50, 0x9f, 0x3c, 0x07, 0x76,
	0x2c, 0x89, 0x77, 0x91, 0xe8, 0x98, 0xd9, 0xa9, 0x12, 0x79, 0xfa, 0x77, 0xdf, 0xc2, 0x7c, 0xb2,
	0x00, 0x4e, 0xff, 0x4a, 0x42, 0xf3, 0x08, 0x40, 0x90, 0x9c, 0xf9, 0x9d, 0xda, 0x31, 0xbc, 0xad,
	0x3d, 0x6e, 0xf1, 0x69, 0xe6, 0x79, 0xb0, 0x29, 0x4b, 0x92, 0xf3, 0xaf, 0x34, 0x78, 0xa7, 0x42,
	0x4b, 0x7d, 0xc6, 0xd4, 0xc2, 0x40, 0xce, 0x0f, 0x23, 0x28, 0x7f, 0x34, 0x59, 0x50, 0xfe, 0x48,
	0xb7, 0xd0, 0xc1, 0x2c, 0x78, 0xbb, 0x0a, 0xce, 0xf1, 0x65, 0x41, 0x5b, 0x06, 0xc3, 0x7f, 0x80,
	0xa6, 0xab, 0x1b, 0xed, 0xd7, 0xe0, 0x43, 0xa7, 0xbe, 0xbf, 0x4e, 0x76, 0xb4, 0x7d, 0xf5, 0x67,
	0x9c, 0xbf, 0xda, 0xa6, 0x40, 0xde, 0x02, 0x1f, 0xb7, 0xee, 0x0b, 0x6c, 0x79, 0xdc, 0xea, 0x68,
	0x94, 0x34, 0x3a, 0x56, 0x0a, 0x73, 0xc9, 0x97, 0xe0, 0xd0, 0xe8, 0xbe, 0xc0, 0x65, 0xa1, 0x51,
	0x47, 0xba, 0x4a, 0x97, 0x0b, 0x73, 0xb3, 0x03, 0x79, 0x03, 0xbc, 0x5c, 0x64, 0x67, 0x20, 0x4f,
	0x5d, 0xf8, 0x8e, 0x75, 0x0d, 0xd4, 0xf4, 0x8c, 0x5b, 0x56, 0xce, 0x90, 0x4f, 0xc0, 0x67, 0xdc,
	0x07, 0x29, 0xe8, 0xae, 0xdf, 0x61, 0xce, 0x91, 0x6e, 0xfe, 0x13, 0x7f, 0x85, 0x4e, 0xed, 0xd7,
	0x34, 0x41, 0x3e, 0x04, 0x47, 0xe0, 0x0f, 0x38, 0x9b, 0x95, 0x5e, 0x2f, 0xcf, 0x29, 0x17, 0xef,
	0xe1, 0x44, 0xb7, 0x6e, 0x88, 0x4f, 0x9d, 0xb1, 0xdb, 0x82, 0x6c, 0xc1, 0xa7, 0x8e, 0x33, 0x58,
	0xe7, 0xf8, 0x42, 0xe6, 0xb1, 0xae, 0x81, 0xca, 0xa7, 0xae, 0x68, 0xce, 0x20, 0xbf, 0x80, 0x4f,
	0x1d, 0x07, 0xfd, 0x38, 0xdc, 0x72, 0x8e, 0x74, 0xf3, 0x9f, 0xd8, 0x47, 0xb3, 0xc6, 0xae, 0x0d,
	0xf2, 0xc7, 0xf0, 0x2f, 0xa3, 0x0f, 0x33, 0x06, 0x1f, 0xc4, 0x2c, 0x5a, 0xa7, 0x09, 0x4d, 0x25,
	0xe0, 0xb0, 0x42, 0xc3, 0x7f, 0xda, 0x40, 0xcf, 0x0d, 0x6c, 0xf1, 0x20, 0x8f, 0xc1, 0xa1, 0xf7,
	0xc3, 0x9c, 0xd7, 0x26, 0x67, 0xf5, 0x38, 0xe3, 0x54, 0x4c, 0xde, 0x99, 0x70, 0xdf, 0x71, 0xfc,
	0x0b, 0x74, 0x7a, 0xdf, 0x2e, 0x11, 0xf2, 0xcb, 0x06, 0xd8, 0x6c, 0x36, 0xa8, 0xef, 0x3d, 0xcc,
	0xf8, 0x68, 0x07, 0x80, 0x13, 0xbd, 0xba, 0xa1, 0x74, 0xc9, 0x34, 0xf5, 0x97, 0x90, 0xd7, 0xc0,
	0x13, 0xbf, 0x21, 0xe0, 0x59, 0x66, 0x2a, 0x0b, 0x33, 0x7a, 0x15, 0x1a, 0x9f, 0xf8, 0x81, 0xbd,
	0x28, 0xa4, 0x0b, 0x9e, 0xf8, 0x8d, 0x8c, 0x97, 0xf8, 0xde, 0x51, 0xf1, 0x94, 0x33, 0xbd, 0x7d,
	0xc7, 0x31, 0x45, 0xb8, 0xda, 0xce, 0x42, 0xde, 0x04, 0x2f, 0x91, 0x42, 0x7c, 0x19, 0xf9, 0x4c,
	0xf5, 0x34, 0x0a, 0xfe, 0x18, 0x4d, 0xa8, 0x5d, 0x2f, 0xe4, 0x38, 0x38, 0xac, 0x72, 0x14, 0xa0,
	0xa3, 0x31, 0x4a, 0x63, 0xb6, 0x8a, 0xa5, 0xac, 0x83, 0x99, 0x6b, 0xd6, 0x31, 0x11, 0xab, 0x26,
	0xf1, 0x53, 0x34, 0xa5, 0x57, 0xf4, 0x91, 0xd3, 0xe0, 0xbd, 0x29, 0x4b, 0xac, 0x96, 0x49, 0x83,
	0xc9, 0x58, 0x25, 0xa4, 0x2b, 0x87, 0x94, 0xcc, 0x3d, 0x09, 0x5e, 0x39, 0xca, 0x24, 0xee, 0x91,
	0xb8, 0x48, 0xde, 0xee, 0xa2, 0x13, 0xb5, 0xdd, 0x33, 0xa4, 0x0f, 0x3e, 0xb8, 0x6e, 0x0a, 0x1e,
	0x7a, 0x94, 0x39, 0x17, 0x9b, 0x07, 0xd2, 0x87, 0x28, 0x5b, 0x67, 0xc8, 0xab, 0xe0, 0x87, 0x78,
	0x94, 0x82, 0xb2, 0xec, 0x68, 0x92, 0xff, 0x4c, 0xf7, 0x52, 0xa5, 0xa7, 0x86, 0x5c, 0x07, 0xef,
	0xa5, 0xe9, 0xd2, 0x56, 0xa4, 0x2d, 0xc7, 0xfb, 0xd2, 0x55, 0x7a, 0x70, 0x2d, 0x8a, 0x23, 0xc9,
	0x8b, 0xe0, 0x83, 0x6b, 0xca, 0xf1, 0xbe, 0x1f, 0x27, 0xce, 0x68, 0x5f, 0xfc, 0xc2, 0x5b, 0x08,
	0x57, 0x3b, 0x71, 0xc8, 0x6f, 0xe0, 0xe9, 0x5b, 0xce, 0x53, 0xde, 0xf5, 0xa7, 0xfa, 0x1a, 0x05,
	0xbb, 0x08, 0x57, 0x2b, 0x51, 0xc9, 0x0d, 0xf0, 0x79, 0xcd, 0x29, 0xc1, 0x22, 0xa5, 0x3d, 0x1d,
	0xe9, 0x24, 0xfc, 0x21, 0x9a, 0x50, 0x1b, 0xa5, 0xc8, 0x59, 0x70, 0xf2, 0x8d, 0xbf, 0xb9, 0x62,
	0x79, 0x39, 0x9a, 0xc8, 0x97, 0x69, 0x3c, 0xc8, 0xfb, 0x8d, 0xc8, 0x4b, 0xe0, 0x78, 0xf0, 0x71,
	0x7a, 0xbf, 0x93, 0xc1, 0xf0, 0x0a, 0x3a, 0x2c, 0xfe, 0xa6, 0x17, 0xaf, 0xce, 0xdc, 0x2f, 0x49,
	0x91, 0xfd, 0x51, 0xaf, 0xc5, 0x07, 0xd9, 0xed, 0x4e, 0x8e, 0xc3, 0xeb, 0x68, 0x34, 0xff, 0x43,
	0x5f, 0xa4, 0x35, 0x40, 0x0b, 0xc1, 0x63, 0x53, 0xdc, 0xef, 0x14, 0xc8, 0x85, 0xff, 0x6a, 0xa0,
	0xe3, 0xd9, 0x16, 0x3d, 0x64, 0x8d, 0xaa, 0x8b, 0xa6, 0x45, 0x5c, 0x20, 0x76, 0xbe, 0x30, 0x88,
	0xc9, 0x08, 0x2f, 0x9b, 0xbb, 0x34, 0xb8, 0x5a, 0x2d, 0x13, 0xfd, 0x30, 0x47, 0x66, 0xec, 0xa7,
	0xba, 0x2a, 0x35, 0xc6, 0x2f, 0xa1, 0xc9, 0x1e, 0x8d, 0x12, 0x9f, 0x76, 0x9a, 0x2d, 0xea, 0x77,
	0xfa, 0x11, 0xe3, 0x65, 0x5e, 0xa3, 0xce, 0x84, 0x20, 0xdf, 0xcd, 0xa8, 0xd5, 0xd2, 0xd6, 0x1f,
	0x55, 0x4b, 0x5b, 0x17, 0xbe, 0x6f, 0xa0, 0xb9, 0xca, 0x33, 0x8b, 0xda, 0xbf, 0xbb, 0x68, 0x56,
	0x93, 0xd4, 0x64, 0x51, 0x14, 0x46, 0xa2, 0xac, 0x0c, 0xe7, 0x8f, 0x14, 0xf5, 0xdc, 0x45, 0xf1,
	0xa1, 0x66, 0x46, 0xd5, 0xe1, 0x4e, 0x7a, 0x3b, 0x7e, 0x8a, 0xe6, 0xf5, 0x69, 0x69, 0x46, 0x42,
	0x48, 0x5e, 0x56, 0x78, 0xcd, 0x7a, 0x7e, 0x72, 0x35, 0x1d, 0xd2, 0x35, 0x0f, 0xc4, 0x0b, 0xff,
	0xf0, 0x02, 0x9a, 0xd4, 0x50, 0x78, 0x0f, 0x9d, 0xac, 0xf6, 0xbb, 0x15, 0x7a, 0x89, 0x8a, 0x27,
	0x80, 0x36, 0x6a, 0x99, 0x58, 0xc1, 0xff, 0xdd, 0xff, 0x57, 0x54, 0xe4, 0xe8, 0x43, 0x69, 0xa4,
	0x27, 0x8b, 0x2e, 0x85, 0x36, 0x06, 0x78, 0x7a, 0x55, 0xa8, 0x2c, 0xaf, 0xac, 0x81, 0x2b, 0x45,
	0xfd, 0x61, 0x03, 0x9d, 0x35, 0x37, 0xd6, 0x95, 0x52, 0x47, 0x06, 0x9c, 0x7d, 0x75, 0xa9, 0xd2,
	0x27, 0x77, 0x59, 0xfc, 0x49, 0x5a, 0x3f, 0x8c, 0x7f, 0xdb, 0x40, 0x0b, 0xb5, 0xad, 0x79, 0xa5,
	0x2a, 0x59, 0x89, 0xc7, 0x3b, 0x60, 0x55, 0xd4, 0x32, 0x2f, 0x59, 0x9b, 0x33, 0x74, 0xdf, 0x3b,
	0xf0, 0xd7, 0xe8, 0x94, 0x41, 0x9f, 0x52, 0x93, 0x03, 0x03, 0xbe, 0xaa, 0xd4, 0x6a, 0x22, 0x2b,
	0x71, 0x82, 0xd6, 0x0d, 0xe2, 0x3f, 0x6f, 0xa0, 0xf3, 0xfb, 0xf4, 0x07, 0x96, 0x8a, 0x64, 0x15,
	0x24, 0xab, 0x60, 0x45, 0xf4, 0x4f, 0x38, 0xb2, 0x3e, 0xe7, 0xe8, 0x80, 0x7b, 0x70, 0x88, 0xe6,
	0xd4, 0x56, 0xc3, 0x52, 0x91, 0x63, 0x03, 0xf2, 0x32, 0xba, 0x22, 0x77, 0x19, 0x53, 0xcc, 0xf3,
	0x18, 0x35, 0xd0, 0x71, 0x24, 0x15, 0x03, 0xea, 0xd6, 0x30, 0x3b, 0xe0, 0xcc, 0xa6, 0x4b, 0xac,
	0x18, 0xc1, 0x2c, 0x35, 0x0d, 0xa4, 0x5b, 0x79, 0x21, 0xb3, 0x94, 0x76, 0x70, 0x40, 0x74, 0xa7,
	0x4b, 0x93, 0x05, 0xe5, 0x45, 0x8e, 0xa5, 0x8c, 0xac, 0xc8, 0xac, 0xe4, 0x7e, 0x69, 0x40, 0x32,
	0x57, 0xe2, 0x2e, 0x33, 0x1e, 0xa3, 0xd2, 0x5c, 0x05, 0xbc, 0xe4, 0xb4, 0xec, 0xa8, 0x2c, 0xb9,
	0x1f, 0x87, 0xbf, 0x9b, 0xa2, 0x66, 0x4d, 0x7b, 0x37, 0x55, 0x3a, 0xfe, 0x14, 0x4d, 0x66, 0x05,
	0xba, 0xa5, 0xa0, 0xb9, 0x01, 0xa1, 0x42, 0x29, 0x28, 0x05, 0xca, 0x22, 0x26, 0xa8, 0x42, 0xc1,
	0x5f, 0xa0, 0xf9, 0x4a, 0xe3, 0x65, 0x29, 0xe7, 0xd0, 0x80, 0xa8, 0xb5, 0x90, 0xa3, 0x95, 0x7a,
	0xc9, 0x12, 0xc9, 0x56, 0xcd, 0x18, 0xfe, 0x4d, 0x03, 0x9d, 0x35, 0x37, 0x6d, 0x96, 0x1a, 0x1c,
	0x1e, 0x50, 0xc5, 0x53, 0x68, 0x60, 0x28, 0x4f, 0x92, 0xb5, 0x38, 0xe5, 0xee, 0x33, 0x8e, 0x9f,
	0xa2, 0x13, 0x7a, 0xdf, 0x67, 0xa9, 0xc2, 0x28, 0x74, 0x0f, 0x52, 0x6b, 0xc7, 0x94, 0x3d, 0xc8,
	0x35, 0x0f, 0xe1, 0x6f, 0x1a, 0xe8, 0x94, 0xa1, 0x8c, 0xa9, 0x14, 0x7e, 0x74, 0xc0, 0x91, 0xbb,
	0x22, 0xdc, 0xb8, 0x02, 0xce, 0xbb, 0xb5, 0xa3, 0x38, 0x41, 0x44, 0x6b, 0x38, 0x2d, 0xa5, 0x93,
	0x01, 0x75, 0xc0, 0x15, 0xe9, 0xbc, 0x7c, 0x49, 0x96, 0x7c, 0xdc, 0x35, 0x8e, 0xe0, 0x5f, 0xc9,
	0xf5, 0x5b, 0x52, 0xa3, 0x6a, 0x29, 0xfb, 0x04, 0x74, 0x3f, 0xac, 0xd6, 0x3a, 0x29, 0xfb, 0xa1,
	0x5b, 0x3f, 0x8c, 0xff, 0xb2, 0x81, 0xce, 0xef, 0xd3, 0xea, 0x5a, 0x2a, 0x93, 0x95, 0xc9, 0xad,
	0xd9, 0x28, 0x53, 0xbf, 0xfe, 0x3f, 0xe7, 0x0e, 0xba, 0x09, 0x3f, 0x41, 0x73, 0x6a, 0xdf, 0x6c,
	0xa9, 0xca, 0x49, 0xe8, 0x72, 0x2c, 0x97, 0x49, 0x29, 0xcb, 0xb1, 0x6b, 0x1a, 0x50, 0xec, 0x40,
	0xdf, 0x02, 0x4e, 0xd9, 0xda, 0x41, 0x65, 0x0f, 0x38, 0xee, 0x1a, 0x47, 0xb0, 0x27, 0x15, 0x0b,
	0x96, 0xf2, 0xd0, 0x80, 0xe3, 0x5c, 0x45, 0x9e, 0x2c, 0xaa, 0xa8, 0xab, 0x2a, 0xa5, 0xfc, 0x52,
	0xb6, 0x36, 0xa9, 0xc3, 0xaf, 0x94, 0x38, 0x66, 0xeb, 0x67, 0x45, 0x0a, 0xc0, 0xe8, 0x67, 0xd5,
	0x51, 0xfc, 0x15, 0x3a, 0x59, 0x6d, 0x08, 0x2e, 0x15, 0x18, 0x87, 0x46, 0x3a, 0x7a, 0xbd, 0x94,
	0x12, 0xe9, 0xb8, 0x75, 0x83, 0x99, 0xa9, 0xd7, 0xb7, 0x13, 0x97, 0x8a, 0x9c, 0x01, 0x9b, 0x7a,
	0x4d, 0xb5, 0x8a, 0x6a, 0xea, 0x83, 0x6e, 0xe2, 0xa6, 0xae, 0xf4, 0x26, 0x97, 0xaa, 0x9c, 0x05,
	0x9b, 0xba, 0x54, 0xd6, 0xa2, 0x9a, 0xba, 0x69, 0x80, 0x9b, 0xba, 0xda, 0xd0, 0x5c, 0xca, 0x3c,
	0x07, 0x36, 0x75, 0xb9, 0xe4, 0x45, 0x35, 0x75, 0xe3, 0x08, 0xfe, 0xab, 0x06, 0x7a, 0x61, 0xbf,
	0x46, 0xe8, 0x52, 0x87, 0xec, 0x33, 0xd8, 0x3a, 0x5c, 0x87, 0x4a, 0x11, 0x8c, 0xac, 0xcf, 0x82,
	0x3b, 0xf0, 0x2e, 0xee, 0x86, 0xb9, 0x6a, 0xa5, 0x1e, 0xcf, 0x83, 0xdd, 0x50, 0x60, 0x55, 0x37,
	0xd4, 0x89, 0xdc, 0x0d, 0x4d, 0x5d, 0xd8, 0xa5, 0xc4, 0xf3, 0x50, 0x37, 0xac, 0x14, 0x5b, 0x28,
	0x6e, 0xc8, 0x6a, 0x47, 0x31, 0x43, 0x33, 0x26, 0xc1, 0x2f, 0x40, 0x1f, 0xd5, 0x24, 0x6f, 0xba,
	0x55, 0x11, 0xf3, 0x0c, 0xcd, 0x57, 0x3a, 0xbe, 0x4b, 0x69, 0x2f, 0x42, 0x43, 0x0a, 0xb5, 0xd2,
	0x42, 0x09, 0x29, 0x5a, 0xe6, 0xa1, 0x34, 0x3c, 0x55, 0x5a, 0xc5, 0x4b, 0xa9, 0x2f, 0x41, 0xc3,
	0x53, 0xa9, 0x0c, 0x43, 0x09, 0x4f, 0x5b, 0x06, 0x3a, 0xfe, 0x08, 0x4d, 0x68, 0x6e, 0x7b, 0x61,
	0x40, 0xca, 0x50, 0x91, 0x23, 0x0b, 0x38, 0xda, 0x52, 0xdc, 0xf4, 0x53, 0x34, 0xa9, 0x7b, 0xe7,
	0xcb, 0xd0, 0xc0, 0xb7, 0xe2, 0x95, 0x13, 0x1d, 0xd5, 0x1b, 0xb7, 0xd1, 0x31, 0xa9, 0x53, 0xbd,
	0x94, 0x70, 0x11, 0x7a, 0xf8, 0x2f, 0x3e, 0xbc, 0x29, 0x87, 0xff, 0x6e, 0x85, 0xca, 0x63, 0x3c,
	0x43, 0x67, 0x7b, 0x29, 0xf2, 0x15, 0xa8, 0xd1, 0x57, 0x12, 0x8b, 0x8a, 0xd1, 0x47, 0xb5, 0xa3,
	0x69, 0x94, 0x5f, 0x69, 0x8c, 0x2f, 0xe5, 0x4f, 0x40, 0xa3, 0x7c, 0x2d, 0x9f, 0xae, 0x44, 0xf9,
	0x71, 0xcd, 0x58, 0x3a, 0xd1, 0xc6, 0x1d, 0x77, 0x12, 0x3a, 0xd1, 0xc6, 0x9d, 0x16, 0xc7, 0xd5,
	0x1d, 0x96, 0xa1, 0x99, 0xb2, 0x05, 0xbf, 0x14, 0x34, 0x05, 0x75, 0xed, 0x3c, 0xdd, 0xac, 0xb8,
	0x76, 0x5f, 0x27, 0xae, 0x8e, 0xa1, 0x23, 0x05, 0xf3, 0x85, 0x7f, 0x39, 0x9f, 0x27, 0xec, 0x2a,
	0x09, 0x2f, 0xbc, 0x2b, 0x1d, 0xaa, 0x8b, 0xdc, 0x56, 0xd6, 0x7f, 0x2b, 0x12, 0x5b, 0x37, 0xa0,
	0x69, 0x36, 0xad, 0x0b, 0x92, 0xf3, 0x90, 0x0e, 0xf3, 0x0a, 0x1d, 0xb7, 0xa4, 0x83, 0x35, 0xf5,
	0x72, 0x89, 0x0d, 0xe8, 0x66, 0xaa, 0x49, 0x2c, 0x84, 0x4d, 0x52, 0x95, 0x84, 0xbf, 0x6d, 0x48,
	0xd9, 0x1b, 0xe5, 0xfc, 0x26, 0x44, 0x8e, 0x40, 0xf3, 0x48, 0x8a, 0x48, 0xb9, 0xc1, 0x24, 0x97,
	0x4d, 0x68, 0xcd, 0x18, 0xfe, 0x13, 0x39, 0xb5, 0xa6, 0xa7, 0xb4, 0x84, 0x1e, 0x18, 0x1a, 0xd2,
	0x28, 0x7a, 0x68, 0x3d, 0x8d, 0xb9, 0x2a, 0x27, 0x69, 0xfd, 0x30, 0xfe, 0x12, 0x9d, 0x30, 0x28,
	0x23, 0xd4, 0x38, 0x00, 0x3d, 0xcb, 0x9a, 0xd5, 0x28, 0x34, 0x38, 0x4e, 0x8d, 0x23, 0xf8, 0xcf,
	0x1a, 0xe8, 0xb9, 0x7d, 0x92, 0x59, 0x42, 0x8b, 0x2c, 0x93, 0x75, 0xc7, 0x52, 0x8b, 0x4a, 0xb1,
	0x72, 0xae, 0xcc, 0x69, 0xba, 0xdf, 0x0d, 0xb8, 0x83, 0x8e, 0xa9, 0x99, 0x2c, 0xa1, 0xc5, 0x31,
	0xe8, 0x0e, 0xa8, 0x68, 0xc1, 0x6b, 0x21, 0x73, 0xc9, 0xd3, 0x54, 0x27, 0xe2, 0x50, 0x4a, 0xe9,
	0x2a, 0x16, 0x30, 0x0b, 0x5d, 0xe2, 0x14, 0x71, 0xea, 0x8b, 0xc7, 0xb4, 0x42, 0xc5, 0x4d, 0x34,
	0x59, 0x08, 0x14, 0xa2, 0x0e, 0x0e, 0xf8, 0x5a, 0x6d, 0x16, 0x55, 0x48, 0x39, 0x4a, 0x65, 0x02,
	0xde, 0xe1, 0xbd, 0x98, 0x65, 0xb2, 0x49, 0x08, 0x39, 0x6e, 0x3b, 0x7d, 0x65, 0xc3, 0xa4, 0x34,
	0x7d, 0x1a, 0x11, 0x3f, 0x44, 0x47, 0xca, 0xf5, 0xe2, 0x12, 0x74, 0xab, 0xcd, 0x45, 0x14, 0x9c,
	0x47, 0x69, 0xfe, 0x3e, 0x3e, 0x42, 0xe3, 0x59, 0xea, 0x4a, 0xf0, 0x9c, 0x83, 0x2e, 0xc5, 0x82,
	0x27, 0xef, 0x45, 0xcc, 0xd9, 0x8e, 0xd1, 0xf2, 0x12, 0x3f, 0x45, 0x73, 0x95, 0xbc, 0x95, 0x10,
	0x72, 0x08, 0x9a, 0x38, 0xc8, 0x84, 0xe8, 0x5d, 0x8a, 0xb9, 0xb8, 0xd9, 0x2d, 0xd3, 0x00, 0xfe,
	0xb5, 0x9c, 0xb1, 0x31, 0x2d, 0x7a, 0x87, 0x07, 0x94, 0x0d, 0x68, 0xe2, 0x4d, 0x6d, 0x75, 0xb9,
	0x0a, 0x27, 0xdc, 0xba, 0x41, 0x9c, 0x48, 0xfd, 0x83, 0x22, 0x63, 0x25, 0xe4, 0x8f, 0xda, 0xed,
	0x2c, 0x5a, 0xc3, 0x63, 0xb1, 0xb3, 0xb8, 0x06, 0x3a, 0xfe, 0x4a, 0xca, 0x93, 0x55, 0x96, 0xb7,
	0x2c, 0x55, 0x75, 0xdb, 0x56, 0x70, 0x75, 0x7d, 0x9b, 0x73, 0xcd, 0x43, 0xf8, 0x89, 0xd4, 0xc5,
	0x98, 0xa5, 0xaa, 0x84, 0x68, 0x02, 0x3d, 0x3c, 0xab, 0xa2, 0xb3, 0xde, 0xbb, 0x5c, 0xec, 0x8c,
	0x5b, 0x25, 0xa7, 0xc1, 0xdb, 0xbc, 0x29, 0x4f, 0x25, 0x04, 0x9f, 0xb0, 0xdb, 0xe1, 0x0c, 0x6d,
	0x79, 0xc5, 0x0e, 0xe7, 0xd6, 0x8c, 0xe1, 0xef, 0x1a, 0xe8, 0xb9, 0x7d, 0x92, 0x54, 0x42, 0x93,
	0x2c, 0x43, 0x75, 0xd7, 0x5e, 0x93, 0x9a, 0x75, 0xfd, 0x8c, 0xbb, 0xef, 0x1d, 0x38, 0x40, 0xc7,
	0xd4, 0x0c, 0x95, 0xd0, 0xe3, 0xa4, 0xdd, 0x4a, 0xab, 0xf4, 0xf2, 0x15, 0x2b, 0xad, 0x5b, 0xa1,
	0x2a, 0xef, 0x5e, 0x59, 0xda, 0x4f, 0x0d, 0xf7, 0xee, 0xd5, 0xb5, 0x7d, 0xc6, 0xad, 0x92, 0x31,
	0x95, 0x1a, 0x89, 0x85, 0x30, 0x04, 0x3d, 0x42, 0xa9, 0xc2, 0x0a, 0x39, 0x45, 0x77, 0xa2, 0x10,
	0xf1, 0xb5, 0x64, 0x5d, 0x52, 0x94, 0x2c, 0xa4, 0x8d, 0x0d, 0xe7, 0x51, 0x65, 0x75, 0x4a, 0xc5,
	0xa3, 0xb4, 0x21, 0xfc, 0x05, 0x22, 0xd5, 0xa4, 0x94, 0x90, 0x3e, 0x6e, 0x17, 0xae, 0x54, 0xfa,
	0xf8, 0x8a, 0x70, 0xc5, 0x35, 0x8e, 0x64, 0x76, 0x5d, 0x9f, 0x91, 0x12, 0x5a, 0x9c, 0xb1, 0xb4,
	0xeb, 0xba, 0xe6, 0xaa, 0xd2, 0xae, 0xf7, 0xbd, 0x83, 0xdb, 0xb5, 0x92, 0x8e, 0x12, 0x7a, 0x9c,
	0xb5, 0xb4, 0x6b, 0xb9, 0xed, 0xaa, 0xb4, 0xeb, 0x0a, 0x95, 0xdb, 0xb5, 0x9a, 0x8b, 0x12, 0x02,
	0xcf, 0x59, 0xda, 0xb5, 0xd2, 0x90, 0x55, 0xda, 0x75, 0x95, 0x8c, 0xff, 0xa2, 0x81, 0x16, 0xf6,
	0x4b, 0x44, 0x09, 0x05, 0x16, 0x86, 0x9b, 0x79, 0x2d, 0xcb, 0x44, 0x0b, 0x5d, 0xce, 0xd6, 0xe6,
	0xa1, 0x24, 0x7f, 0xcb, 0xd5, 0x12, 0x3a, 0x3c, 0x6f, 0xe9, 0x6f, 0x79, 0x9b, 0x63, 0xe9, 0x6f,
	0x0a, 0x25, 0xf5, 0x37, 0x53, 0x02, 0x4a, 0x48, 0x3b, 0x6f, 0xe7, 0x6f, 0xd5, 0x86, 0x9f, 0xc2,
	0xdf, 0x98, 0x79, 0x08, 0x6f, 0xc9, 0x7d, 0x37, 0x42, 0xea, 0x0b, 0x76, 0xcf, 0x58, 0x11, 0x56,
	0xb4, 0xdf, 0x08, 0x19, 0x7d, 0x34, 0x57, 0x49, 0x3d, 0x09, 0x51, 0x2f, 0xda, 0xc5, 0x06, 0x5a,
	0x9f, 0x4f, 0x11, 0x1b, 0xb4, 0x0c, 0xf4, 0x34, 0x52, 0x55, 0xf2, 0x4e, 0x42, 0xe4, 0x4b, 0x76,
	0x91, 0xaa, 0xdc, 0x01, 0x54, 0x44, 0xaa, 0x2d, 0x9d, 0x88, 0x3f, 0x40, 0x63, 0xb2, 0x73, 0x5e,
	0x80, 0x7e, 0x34, 0x2e, 0x85, 0x14, 0xdc, 0x51, 0xab, 0x74, 0xc6, 0x8f, 0xd0, 0xb8, 0xe2, 0x83,
	0x2f, 0xdb, 0xc5, 0xab, 0xaa, 0xef, 0x8d, 0x75, 0x24, 0x9f, 0x63, 0x68, 0x5a, 0x4a, 0x37, 0x09,
	0xf6, 0x17, 0xed, 0x8e, 0xe4, 0x65, 0xa9, 0x77, 0x71, 0x24, 0xef, 0xaa, 0xa4, 0x34, 0x40, 0x33,
	0xa4, 0x9a, 0x84, 0xb8, 0x57, 0xec, 0xcc, 0xbb, 0x5a, 0xc6, 0x56, 0x98, 0x77, 0x64, 0x1e, 0x4a,
	0xa3, 0xf2, 0x4a, 0x9e, 0x49, 0x08, 0x9f, 0xb0, 0x8b, 0xca, 0xf5, 0xd2, 0xcd, 0x22, 0x2a, 0x8f,
	0x4d, 0x03, 0xe9, 0xf4, 0x56, 0xb7, 0xcf, 0x49, 0xbb, 0xe9, 0xad, 0x6e, 0x9b, 0x93, 0xb1, 0xb6,
	0x5d, 0x6e, 0xa1, 0xa9, 0x32, 0xc3, 0x24, 0xa4, 0x4c, 0xd9, 0xb9, 0x6f, 0x51, 0xd3, 0x58, 0xb8,
	0x6f, 0x5f, 0xa1, 0xac, 0x22, 0x34, 0x9a, 0x57, 0x63, 0x5d, 0xfe, 0xdb, 0x83, 0x68, 0xaa, 0xfc,
	0x53, 0x70, 0x19, 0x23, 0xfc, 0xf7, 0x0d, 0x74, 0x28, 0x2b, 0x9b, 0xc5, 0x80, 0xcf, 0x14, 0xe6,
	0xbf, 0xf2, 0x38, 0x7f, 0x6d, 0x08, 0x64, 0xa6, 0xd4, 0xc2, 0x83, 0xef, 0x57, 0xa6, 0xa5, 0xea,
	0xbb, 0x57, 0xf9, 0xdf, 0xcc, 0xfb, 0xf6, 0x1f, 0xff, 0xed, 0xbb, 0x91, 0x2b, 0x0b, 0x8b, 0xfc,
	0x7f, 0x7d, 0x8a, 0xc1, 0x78, 0xe9, 0x4b, 0xe9, 0xbe, 0x9b, 0x17, 0xbf, 0x12, 0x7f, 0x37, 0x73,
	0xc5, 0x8b, 0x97, 0xb3, 0x3a, 0xdf, 0xe5, 0xc6, 0x45, 0xfc, 0xef, 0x0d, 0x34, 0x9e, 0x89, 0xca,
	0xfe, 0xd6, 0x1d, 0xbe, 0x65, 0xad, 0x9a, 0xf2, 0xe7, 0xff, 0xe6, 0x6f, 0x0f, 0x8d, 0x17, 0x0f,
	0xb8, 0x59, 0xfb, 0x80, 0xd7, 0x16, 0xae, 0xda, 0x3d, 0x60, 0xc6, 0x79, 0xb9, 0x71, 0xf1, 0xf5,
	0x06, 0xfe, 0xe7, 0x06, 0x3a, 0x94, 0xd9, 0x00, 0xe4, 0xbd, 0x99, 0x2b, 0x1f, 0xe7, 0xaf, 0x0d,
	0x81, 0x14, 0x8f, 0xf5, 0xf1, 0xf7, 0x2b, 0xa7, 0xe5, 0xc7, 0xaa, 0xd4, 0x46, 0xda, 0xbe, 0xc3,
	0x8c, 0xc1, 0x72, 0xe3, 0xe2, 0xfc, 0xc9, 0xdf, 0xad, 0x90, 0x52, 0x19, 0xf1, 0xab, 0xe7, 0xc7,
	0x8b, 0x6e, 0xd8, 0x5d, 0xfd, 0x9f, 0x06, 0x3a, 0xef, 0x86, 0xdd, 0x81, 0x8a, 0xaf, 0xce, 0xea,
	0xa6, 0xbe, 0x11, 0x85, 0x49, 0xb8, 0xd1, 0xf8, 0xe4, 0x5d, 0x01, 0x6d, 0x87, 0x1d, 0x1a, 0xb4,
	0x17, 0xc3, 0xa8, 0xbd, 0xd4, 0x66, 0x01, 0xff, 0x23, 0x85, 0x4b, 0xa5, 0xb0, 0xfa, 0xbf, 0xcc,
	0x7a, 0x3d, 0xff, 0xf1, 0xd7, 0x23, 0x07, 0xee, 0xad, 0xac, 0xfc, 0xcd, 0xc8, 0xb9, 0x4c, 0xd2,
	0xe2, 0x8a, 0x27, 0xfd, 0x55, 0xc2, 0xc5, 0xc7, 0x57, 0x16, 0x85, 0xe0, 0xf8, 0x77, 0xf9, 0x2d,
	0x9f, 0xad, 0x78, 0xf1, 0x67, 0xc5, 0x2d, 0x9f, 0x3d, 0xbe, 0xf2, 0x59, 0x7e, 0xcb, 0x7f, 0x8c,
	0x9c, 0xcf, 0xe8, 0xcb, 0xcb, 0xe9, 0x64, 0x2c, 0x17, 0x37, 0x2d, 0x2f, 0x3f, 0xbe, 0xb2, 0xbc,
	0x9c, 0xdf, 0xb6, 0x75, 0x88, 0xeb, 0x79, 0xe5, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x1d, 0x27,
	0x89, 0x44, 0xa6, 0x77, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GoogleAdsServiceClient is the client API for GoogleAdsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GoogleAdsServiceClient interface {
	// Returns all rows that match the search query.
	Search(ctx context.Context, in *SearchGoogleAdsRequest, opts ...grpc.CallOption) (*SearchGoogleAdsResponse, error)
	// Returns all rows that match the search stream query.
	SearchStream(ctx context.Context, in *SearchGoogleAdsStreamRequest, opts ...grpc.CallOption) (GoogleAdsService_SearchStreamClient, error)
	// Creates, updates, or removes resources. This method supports atomic
	// transactions with multiple types of resources. For example, you can
	// atomically create a campaign and a campaign budget, or perform up to
	// thousands of mutates atomically.
	//
	// This method is essentially a wrapper around a series of mutate methods. The
	// only features it offers over calling those methods directly are:
	//
	// - Atomic transactions
	// - Temp resource names (described below)
	// - Somewhat reduced latency over making a series of mutate calls
	//
	// Note: Only resources that support atomic transactions are included, so this
	// method can't replace all calls to individual services.
	//
	// ## Atomic Transaction Benefits
	//
	// Atomicity makes error handling much easier. If you're making a series of
	// changes and one fails, it can leave your account in an inconsistent state.
	// With atomicity, you either reach the desired state directly, or the request
	// fails and you can retry.
	//
	// ## Temp Resource Names
	//
	// Temp resource names are a special type of resource name used to create a
	// resource and reference that resource in the same request. For example, if a
	// campaign budget is created with `resource_name` equal to
	// `customers/123/campaignBudgets/-1`, that resource name can be reused in
	// the `Campaign.budget` field in the same request. That way, the two
	// resources are created and linked atomically.
	//
	// To create a temp resource name, put a negative number in the part of the
	// name that the server would normally allocate.
	//
	// Note:
	//
	// - Resources must be created with a temp name before the name can be reused.
	//   For example, the previous CampaignBudget+Campaign example would fail if
	//   the mutate order was reversed.
	// - Temp names are not remembered across requests.
	// - There's no limit to the number of temp names in a request.
	// - Each temp name must use a unique negative number, even if the resource
	//   types differ.
	//
	// ## Latency
	//
	// It's important to group mutates by resource type or the request may time
	// out and fail. Latency is roughly equal to a series of calls to individual
	// mutate methods, where each change in resource type is a new call. For
	// example, mutating 10 campaigns then 10 ad groups is like 2 calls, while
	// mutating 1 campaign, 1 ad group, 1 campaign, 1 ad group is like 4 calls.
	Mutate(ctx context.Context, in *MutateGoogleAdsRequest, opts ...grpc.CallOption) (*MutateGoogleAdsResponse, error)
}

type googleAdsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGoogleAdsServiceClient(cc grpc.ClientConnInterface) GoogleAdsServiceClient {
	return &googleAdsServiceClient{cc}
}

func (c *googleAdsServiceClient) Search(ctx context.Context, in *SearchGoogleAdsRequest, opts ...grpc.CallOption) (*SearchGoogleAdsResponse, error) {
	out := new(SearchGoogleAdsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.GoogleAdsService/Search", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *googleAdsServiceClient) SearchStream(ctx context.Context, in *SearchGoogleAdsStreamRequest, opts ...grpc.CallOption) (GoogleAdsService_SearchStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_GoogleAdsService_serviceDesc.Streams[0], "/google.ads.googleads.v3.services.GoogleAdsService/SearchStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &googleAdsServiceSearchStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type GoogleAdsService_SearchStreamClient interface {
	Recv() (*SearchGoogleAdsStreamResponse, error)
	grpc.ClientStream
}

type googleAdsServiceSearchStreamClient struct {
	grpc.ClientStream
}

func (x *googleAdsServiceSearchStreamClient) Recv() (*SearchGoogleAdsStreamResponse, error) {
	m := new(SearchGoogleAdsStreamResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *googleAdsServiceClient) Mutate(ctx context.Context, in *MutateGoogleAdsRequest, opts ...grpc.CallOption) (*MutateGoogleAdsResponse, error) {
	out := new(MutateGoogleAdsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.GoogleAdsService/Mutate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GoogleAdsServiceServer is the server API for GoogleAdsService service.
type GoogleAdsServiceServer interface {
	// Returns all rows that match the search query.
	Search(context.Context, *SearchGoogleAdsRequest) (*SearchGoogleAdsResponse, error)
	// Returns all rows that match the search stream query.
	SearchStream(*SearchGoogleAdsStreamRequest, GoogleAdsService_SearchStreamServer) error
	// Creates, updates, or removes resources. This method supports atomic
	// transactions with multiple types of resources. For example, you can
	// atomically create a campaign and a campaign budget, or perform up to
	// thousands of mutates atomically.
	//
	// This method is essentially a wrapper around a series of mutate methods. The
	// only features it offers over calling those methods directly are:
	//
	// - Atomic transactions
	// - Temp resource names (described below)
	// - Somewhat reduced latency over making a series of mutate calls
	//
	// Note: Only resources that support atomic transactions are included, so this
	// method can't replace all calls to individual services.
	//
	// ## Atomic Transaction Benefits
	//
	// Atomicity makes error handling much easier. If you're making a series of
	// changes and one fails, it can leave your account in an inconsistent state.
	// With atomicity, you either reach the desired state directly, or the request
	// fails and you can retry.
	//
	// ## Temp Resource Names
	//
	// Temp resource names are a special type of resource name used to create a
	// resource and reference that resource in the same request. For example, if a
	// campaign budget is created with `resource_name` equal to
	// `customers/123/campaignBudgets/-1`, that resource name can be reused in
	// the `Campaign.budget` field in the same request. That way, the two
	// resources are created and linked atomically.
	//
	// To create a temp resource name, put a negative number in the part of the
	// name that the server would normally allocate.
	//
	// Note:
	//
	// - Resources must be created with a temp name before the name can be reused.
	//   For example, the previous CampaignBudget+Campaign example would fail if
	//   the mutate order was reversed.
	// - Temp names are not remembered across requests.
	// - There's no limit to the number of temp names in a request.
	// - Each temp name must use a unique negative number, even if the resource
	//   types differ.
	//
	// ## Latency
	//
	// It's important to group mutates by resource type or the request may time
	// out and fail. Latency is roughly equal to a series of calls to individual
	// mutate methods, where each change in resource type is a new call. For
	// example, mutating 10 campaigns then 10 ad groups is like 2 calls, while
	// mutating 1 campaign, 1 ad group, 1 campaign, 1 ad group is like 4 calls.
	Mutate(context.Context, *MutateGoogleAdsRequest) (*MutateGoogleAdsResponse, error)
}

// UnimplementedGoogleAdsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedGoogleAdsServiceServer struct {
}

func (*UnimplementedGoogleAdsServiceServer) Search(ctx context.Context, req *SearchGoogleAdsRequest) (*SearchGoogleAdsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Search not implemented")
}
func (*UnimplementedGoogleAdsServiceServer) SearchStream(req *SearchGoogleAdsStreamRequest, srv GoogleAdsService_SearchStreamServer) error {
	return status1.Errorf(codes.Unimplemented, "method SearchStream not implemented")
}
func (*UnimplementedGoogleAdsServiceServer) Mutate(ctx context.Context, req *MutateGoogleAdsRequest) (*MutateGoogleAdsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Mutate not implemented")
}

func RegisterGoogleAdsServiceServer(s *grpc.Server, srv GoogleAdsServiceServer) {
	s.RegisterService(&_GoogleAdsService_serviceDesc, srv)
}

func _GoogleAdsService_Search_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchGoogleAdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GoogleAdsServiceServer).Search(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.GoogleAdsService/Search",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GoogleAdsServiceServer).Search(ctx, req.(*SearchGoogleAdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GoogleAdsService_SearchStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SearchGoogleAdsStreamRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(GoogleAdsServiceServer).SearchStream(m, &googleAdsServiceSearchStreamServer{stream})
}

type GoogleAdsService_SearchStreamServer interface {
	Send(*SearchGoogleAdsStreamResponse) error
	grpc.ServerStream
}

type googleAdsServiceSearchStreamServer struct {
	grpc.ServerStream
}

func (x *googleAdsServiceSearchStreamServer) Send(m *SearchGoogleAdsStreamResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _GoogleAdsService_Mutate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateGoogleAdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GoogleAdsServiceServer).Mutate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.GoogleAdsService/Mutate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GoogleAdsServiceServer).Mutate(ctx, req.(*MutateGoogleAdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GoogleAdsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.GoogleAdsService",
	HandlerType: (*GoogleAdsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Search",
			Handler:    _GoogleAdsService_Search_Handler,
		},
		{
			MethodName: "Mutate",
			Handler:    _GoogleAdsService_Mutate_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SearchStream",
			Handler:       _GoogleAdsService_SearchStream_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/ads/googleads/v3/services/google_ads_service.proto",
}
