// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/reservation/v1/reservation.proto

package reservation

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Commitment plan defines the current committed period. Capacity commitment
// cannot be deleted during it's committed period.
type CapacityCommitment_CommitmentPlan int32

const (
	// Invalid plan value. Requests with this value will be rejected with
	// error code `google.rpc.Code.INVALID_ARGUMENT`.
	CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED CapacityCommitment_CommitmentPlan = 0
	// Flex commitments have committed period of 1 minute after becoming ACTIVE.
	// After that, they are not in a committed period anymore and can be removed
	// any time.
	CapacityCommitment_FLEX CapacityCommitment_CommitmentPlan = 3
	// Trial commitments have a committed period of 182 days after becoming
	// ACTIVE. After that, they are converted to a new commitment based on the
	// `renewal_plan`. Default `renewal_plan` for Trial commitment is Flex so
	// that it can be deleted right after committed period ends.
	CapacityCommitment_TRIAL CapacityCommitment_CommitmentPlan = 5
	// Monthly commitments have a committed period of 30 days after becoming
	// ACTIVE. After that, they are not in a committed period anymore and can be
	// removed any time.
	CapacityCommitment_MONTHLY CapacityCommitment_CommitmentPlan = 2
	// Annual commitments have a committed period of 365 days after becoming
	// ACTIVE. After that they are converted to a new commitment based on the
	// renewal_plan.
	CapacityCommitment_ANNUAL CapacityCommitment_CommitmentPlan = 4
)

var CapacityCommitment_CommitmentPlan_name = map[int32]string{
	0: "COMMITMENT_PLAN_UNSPECIFIED",
	3: "FLEX",
	5: "TRIAL",
	2: "MONTHLY",
	4: "ANNUAL",
}

var CapacityCommitment_CommitmentPlan_value = map[string]int32{
	"COMMITMENT_PLAN_UNSPECIFIED": 0,
	"FLEX":                        3,
	"TRIAL":                       5,
	"MONTHLY":                     2,
	"ANNUAL":                      4,
}

func (x CapacityCommitment_CommitmentPlan) String() string {
	return proto.EnumName(CapacityCommitment_CommitmentPlan_name, int32(x))
}

func (CapacityCommitment_CommitmentPlan) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{1, 0}
}

// Capacity commitment can either become ACTIVE right away or transition
// from PENDING to ACTIVE or FAILED.
type CapacityCommitment_State int32

const (
	// Invalid state value.
	CapacityCommitment_STATE_UNSPECIFIED CapacityCommitment_State = 0
	// Capacity commitment is pending provisioning. Pending capacity commitment
	// does not contribute to the parent's slot_capacity.
	CapacityCommitment_PENDING CapacityCommitment_State = 1
	// Once slots are provisioned, capacity commitment becomes active.
	// slot_count is added to the parent's slot_capacity.
	CapacityCommitment_ACTIVE CapacityCommitment_State = 2
	// Capacity commitment is failed to be activated by the backend.
	CapacityCommitment_FAILED CapacityCommitment_State = 3
)

var CapacityCommitment_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PENDING",
	2: "ACTIVE",
	3: "FAILED",
}

var CapacityCommitment_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PENDING":           1,
	"ACTIVE":            2,
	"FAILED":            3,
}

func (x CapacityCommitment_State) String() string {
	return proto.EnumName(CapacityCommitment_State_name, int32(x))
}

func (CapacityCommitment_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{1, 1}
}

// Types of job, which could be specified when using the reservation.
type Assignment_JobType int32

const (
	// Invalid type. Requests with this value will be rejected with
	// error code `google.rpc.Code.INVALID_ARGUMENT`.
	Assignment_JOB_TYPE_UNSPECIFIED Assignment_JobType = 0
	// Pipeline (load/export) jobs from the project will use the reservation.
	Assignment_PIPELINE Assignment_JobType = 1
	// Query jobs from the project will use the reservation.
	Assignment_QUERY Assignment_JobType = 2
)

var Assignment_JobType_name = map[int32]string{
	0: "JOB_TYPE_UNSPECIFIED",
	1: "PIPELINE",
	2: "QUERY",
}

var Assignment_JobType_value = map[string]int32{
	"JOB_TYPE_UNSPECIFIED": 0,
	"PIPELINE":             1,
	"QUERY":                2,
}

func (x Assignment_JobType) String() string {
	return proto.EnumName(Assignment_JobType_name, int32(x))
}

func (Assignment_JobType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{17, 0}
}

// Assignment will remain in PENDING state if no active capacity commitment is
// present. It will become ACTIVE when some capacity commitment becomes
// active.
type Assignment_State int32

const (
	// Invalid state value.
	Assignment_STATE_UNSPECIFIED Assignment_State = 0
	// Queries from assignee will be executed as on-demand, if related
	// assignment is pending.
	Assignment_PENDING Assignment_State = 1
	// Assignment is ready.
	Assignment_ACTIVE Assignment_State = 2
)

var Assignment_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PENDING",
	2: "ACTIVE",
}

var Assignment_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PENDING":           1,
	"ACTIVE":            2,
}

func (x Assignment_State) String() string {
	return proto.EnumName(Assignment_State_name, int32(x))
}

func (Assignment_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{17, 1}
}

// A reservation is a mechanism used to guarantee slots to users.
type Reservation struct {
	// The resource name of the reservation, e.g.,
	// `projects/*/locations/*/reservations/team1-prod`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Minimum slots available to this reservation. A slot is a unit of
	// computational power in BigQuery, and serves as the unit of parallelism.
	//
	// Queries using this reservation might use more slots during runtime if
	// ignore_idle_slots is set to false.
	//
	// If the new reservation's slot capacity exceed the parent's slot capacity or
	// if total slot capacity of the new reservation and its siblings exceeds the
	// parent's slot capacity, the request will fail with
	// `google.rpc.Code.RESOURCE_EXHAUSTED`.
	SlotCapacity int64 `protobuf:"varint,2,opt,name=slot_capacity,json=slotCapacity,proto3" json:"slot_capacity,omitempty"`
	// If false, any query using this reservation will use idle slots from other
	// reservations within the same admin project. If true, a query using this
	// reservation will execute with the slot capacity specified above at most.
	IgnoreIdleSlots      bool     `protobuf:"varint,4,opt,name=ignore_idle_slots,json=ignoreIdleSlots,proto3" json:"ignore_idle_slots,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Reservation) Reset()         { *m = Reservation{} }
func (m *Reservation) String() string { return proto.CompactTextString(m) }
func (*Reservation) ProtoMessage()    {}
func (*Reservation) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{0}
}

func (m *Reservation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Reservation.Unmarshal(m, b)
}
func (m *Reservation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Reservation.Marshal(b, m, deterministic)
}
func (m *Reservation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Reservation.Merge(m, src)
}
func (m *Reservation) XXX_Size() int {
	return xxx_messageInfo_Reservation.Size(m)
}
func (m *Reservation) XXX_DiscardUnknown() {
	xxx_messageInfo_Reservation.DiscardUnknown(m)
}

var xxx_messageInfo_Reservation proto.InternalMessageInfo

func (m *Reservation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Reservation) GetSlotCapacity() int64 {
	if m != nil {
		return m.SlotCapacity
	}
	return 0
}

func (m *Reservation) GetIgnoreIdleSlots() bool {
	if m != nil {
		return m.IgnoreIdleSlots
	}
	return false
}

// Capacity commitment is a way to purchase compute capacity for BigQuery jobs
// (in the form of slots) with some committed period of usage. Annual
// commitments renew by default. Commitments can be removed after their
// commitment end time passes.
//
// In order to remove annual commitment, its plan needs to be changed
// to monthly or flex first.
//
// A capacity commitment resource exists as a child resource of the admin
// project.
type CapacityCommitment struct {
	// Output only. The resource name of the capacity commitment, e.g.,
	// `projects/myproject/locations/US/capacityCommitments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Number of slots in this commitment.
	SlotCount int64 `protobuf:"varint,2,opt,name=slot_count,json=slotCount,proto3" json:"slot_count,omitempty"`
	// Capacity commitment commitment plan.
	Plan CapacityCommitment_CommitmentPlan `protobuf:"varint,3,opt,name=plan,proto3,enum=google.cloud.bigquery.reservation.v1.CapacityCommitment_CommitmentPlan" json:"plan,omitempty"`
	// Output only. State of the commitment.
	State CapacityCommitment_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.bigquery.reservation.v1.CapacityCommitment_State" json:"state,omitempty"`
	// Output only. The end of the current commitment period. It is applicable
	// only for ACTIVE capacity commitments.
	CommitmentEndTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=commitment_end_time,json=commitmentEndTime,proto3" json:"commitment_end_time,omitempty"`
	// Output only. For FAILED commitment plan, provides the reason of failure.
	FailureStatus *status.Status `protobuf:"bytes,7,opt,name=failure_status,json=failureStatus,proto3" json:"failure_status,omitempty"`
	// The plan this capacity commitment is converted to after commitment_end_time
	// passes. Once the plan is changed, committed period is extended according to
	// commitment plan. Only applicable for ANNUAL and TRIAL commitments.
	RenewalPlan          CapacityCommitment_CommitmentPlan `protobuf:"varint,8,opt,name=renewal_plan,json=renewalPlan,proto3,enum=google.cloud.bigquery.reservation.v1.CapacityCommitment_CommitmentPlan" json:"renewal_plan,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *CapacityCommitment) Reset()         { *m = CapacityCommitment{} }
func (m *CapacityCommitment) String() string { return proto.CompactTextString(m) }
func (*CapacityCommitment) ProtoMessage()    {}
func (*CapacityCommitment) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{1}
}

func (m *CapacityCommitment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CapacityCommitment.Unmarshal(m, b)
}
func (m *CapacityCommitment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CapacityCommitment.Marshal(b, m, deterministic)
}
func (m *CapacityCommitment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CapacityCommitment.Merge(m, src)
}
func (m *CapacityCommitment) XXX_Size() int {
	return xxx_messageInfo_CapacityCommitment.Size(m)
}
func (m *CapacityCommitment) XXX_DiscardUnknown() {
	xxx_messageInfo_CapacityCommitment.DiscardUnknown(m)
}

var xxx_messageInfo_CapacityCommitment proto.InternalMessageInfo

func (m *CapacityCommitment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CapacityCommitment) GetSlotCount() int64 {
	if m != nil {
		return m.SlotCount
	}
	return 0
}

func (m *CapacityCommitment) GetPlan() CapacityCommitment_CommitmentPlan {
	if m != nil {
		return m.Plan
	}
	return CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED
}

func (m *CapacityCommitment) GetState() CapacityCommitment_State {
	if m != nil {
		return m.State
	}
	return CapacityCommitment_STATE_UNSPECIFIED
}

func (m *CapacityCommitment) GetCommitmentEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.CommitmentEndTime
	}
	return nil
}

func (m *CapacityCommitment) GetFailureStatus() *status.Status {
	if m != nil {
		return m.FailureStatus
	}
	return nil
}

func (m *CapacityCommitment) GetRenewalPlan() CapacityCommitment_CommitmentPlan {
	if m != nil {
		return m.RenewalPlan
	}
	return CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED
}

// The request for
// [ReservationService.CreateReservation][google.cloud.bigquery.reservation.v1.ReservationService.CreateReservation].
type CreateReservationRequest struct {
	// Required. Project, location. E.g.,
	// `projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The reservation ID. This field must only contain lower case alphanumeric
	// characters or dash. Max length is 64 characters.
	ReservationId string `protobuf:"bytes,2,opt,name=reservation_id,json=reservationId,proto3" json:"reservation_id,omitempty"`
	// Definition of the new reservation to create.
	Reservation          *Reservation `protobuf:"bytes,3,opt,name=reservation,proto3" json:"reservation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateReservationRequest) Reset()         { *m = CreateReservationRequest{} }
func (m *CreateReservationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateReservationRequest) ProtoMessage()    {}
func (*CreateReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{2}
}

func (m *CreateReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateReservationRequest.Unmarshal(m, b)
}
func (m *CreateReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateReservationRequest.Marshal(b, m, deterministic)
}
func (m *CreateReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateReservationRequest.Merge(m, src)
}
func (m *CreateReservationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateReservationRequest.Size(m)
}
func (m *CreateReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateReservationRequest proto.InternalMessageInfo

func (m *CreateReservationRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateReservationRequest) GetReservationId() string {
	if m != nil {
		return m.ReservationId
	}
	return ""
}

func (m *CreateReservationRequest) GetReservation() *Reservation {
	if m != nil {
		return m.Reservation
	}
	return nil
}

// The request for
// [ReservationService.ListReservations][google.cloud.bigquery.reservation.v1.ReservationService.ListReservations].
type ListReservationsRequest struct {
	// Required. The parent resource name containing project and location, e.g.:
	//   "projects/myproject/locations/US"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListReservationsRequest) Reset()         { *m = ListReservationsRequest{} }
func (m *ListReservationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListReservationsRequest) ProtoMessage()    {}
func (*ListReservationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{3}
}

func (m *ListReservationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReservationsRequest.Unmarshal(m, b)
}
func (m *ListReservationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReservationsRequest.Marshal(b, m, deterministic)
}
func (m *ListReservationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReservationsRequest.Merge(m, src)
}
func (m *ListReservationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListReservationsRequest.Size(m)
}
func (m *ListReservationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReservationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListReservationsRequest proto.InternalMessageInfo

func (m *ListReservationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListReservationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListReservationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListReservations][google.cloud.bigquery.reservation.v1.ReservationService.ListReservations].
type ListReservationsResponse struct {
	// List of reservations visible to the user.
	Reservations []*Reservation `protobuf:"bytes,1,rep,name=reservations,proto3" json:"reservations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListReservationsResponse) Reset()         { *m = ListReservationsResponse{} }
func (m *ListReservationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListReservationsResponse) ProtoMessage()    {}
func (*ListReservationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{4}
}

func (m *ListReservationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReservationsResponse.Unmarshal(m, b)
}
func (m *ListReservationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReservationsResponse.Marshal(b, m, deterministic)
}
func (m *ListReservationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReservationsResponse.Merge(m, src)
}
func (m *ListReservationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListReservationsResponse.Size(m)
}
func (m *ListReservationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReservationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListReservationsResponse proto.InternalMessageInfo

func (m *ListReservationsResponse) GetReservations() []*Reservation {
	if m != nil {
		return m.Reservations
	}
	return nil
}

func (m *ListReservationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.GetReservation][google.cloud.bigquery.reservation.v1.ReservationService.GetReservation].
type GetReservationRequest struct {
	// Required. Resource name of the reservation to retrieve. E.g.,
	//    `projects/myproject/locations/US/reservations/team1-prod`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetReservationRequest) Reset()         { *m = GetReservationRequest{} }
func (m *GetReservationRequest) String() string { return proto.CompactTextString(m) }
func (*GetReservationRequest) ProtoMessage()    {}
func (*GetReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{5}
}

func (m *GetReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetReservationRequest.Unmarshal(m, b)
}
func (m *GetReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetReservationRequest.Marshal(b, m, deterministic)
}
func (m *GetReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReservationRequest.Merge(m, src)
}
func (m *GetReservationRequest) XXX_Size() int {
	return xxx_messageInfo_GetReservationRequest.Size(m)
}
func (m *GetReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReservationRequest proto.InternalMessageInfo

func (m *GetReservationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.DeleteReservation][google.cloud.bigquery.reservation.v1.ReservationService.DeleteReservation].
type DeleteReservationRequest struct {
	// Required. Resource name of the reservation to retrieve. E.g.,
	//    `projects/myproject/locations/US/reservations/team1-prod`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteReservationRequest) Reset()         { *m = DeleteReservationRequest{} }
func (m *DeleteReservationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteReservationRequest) ProtoMessage()    {}
func (*DeleteReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{6}
}

func (m *DeleteReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteReservationRequest.Unmarshal(m, b)
}
func (m *DeleteReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteReservationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteReservationRequest.Merge(m, src)
}
func (m *DeleteReservationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteReservationRequest.Size(m)
}
func (m *DeleteReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteReservationRequest proto.InternalMessageInfo

func (m *DeleteReservationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.UpdateReservation][google.cloud.bigquery.reservation.v1.ReservationService.UpdateReservation].
type UpdateReservationRequest struct {
	// Content of the reservation to update.
	Reservation *Reservation `protobuf:"bytes,1,opt,name=reservation,proto3" json:"reservation,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateReservationRequest) Reset()         { *m = UpdateReservationRequest{} }
func (m *UpdateReservationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateReservationRequest) ProtoMessage()    {}
func (*UpdateReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{7}
}

func (m *UpdateReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateReservationRequest.Unmarshal(m, b)
}
func (m *UpdateReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateReservationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateReservationRequest.Merge(m, src)
}
func (m *UpdateReservationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateReservationRequest.Size(m)
}
func (m *UpdateReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateReservationRequest proto.InternalMessageInfo

func (m *UpdateReservationRequest) GetReservation() *Reservation {
	if m != nil {
		return m.Reservation
	}
	return nil
}

func (m *UpdateReservationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request for
// [ReservationService.CreateCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.CreateCapacityCommitment].
type CreateCapacityCommitmentRequest struct {
	// Required. Resource name of the parent reservation. E.g.,
	//    projects/myproject/locations/US
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Content of the capacity commitment to create.
	CapacityCommitment *CapacityCommitment `protobuf:"bytes,2,opt,name=capacity_commitment,json=capacityCommitment,proto3" json:"capacity_commitment,omitempty"`
	// If true, fail the request if another project in the organization has a
	// capacity commitment.
	EnforceSingleAdminProjectPerOrg bool     `protobuf:"varint,4,opt,name=enforce_single_admin_project_per_org,json=enforceSingleAdminProjectPerOrg,proto3" json:"enforce_single_admin_project_per_org,omitempty"`
	XXX_NoUnkeyedLiteral            struct{} `json:"-"`
	XXX_unrecognized                []byte   `json:"-"`
	XXX_sizecache                   int32    `json:"-"`
}

func (m *CreateCapacityCommitmentRequest) Reset()         { *m = CreateCapacityCommitmentRequest{} }
func (m *CreateCapacityCommitmentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateCapacityCommitmentRequest) ProtoMessage()    {}
func (*CreateCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{8}
}

func (m *CreateCapacityCommitmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateCapacityCommitmentRequest.Unmarshal(m, b)
}
func (m *CreateCapacityCommitmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateCapacityCommitmentRequest.Marshal(b, m, deterministic)
}
func (m *CreateCapacityCommitmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateCapacityCommitmentRequest.Merge(m, src)
}
func (m *CreateCapacityCommitmentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateCapacityCommitmentRequest.Size(m)
}
func (m *CreateCapacityCommitmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateCapacityCommitmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateCapacityCommitmentRequest proto.InternalMessageInfo

func (m *CreateCapacityCommitmentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateCapacityCommitmentRequest) GetCapacityCommitment() *CapacityCommitment {
	if m != nil {
		return m.CapacityCommitment
	}
	return nil
}

func (m *CreateCapacityCommitmentRequest) GetEnforceSingleAdminProjectPerOrg() bool {
	if m != nil {
		return m.EnforceSingleAdminProjectPerOrg
	}
	return false
}

// The request for
// [ReservationService.ListCapacityCommitments][google.cloud.bigquery.reservation.v1.ReservationService.ListCapacityCommitments].
type ListCapacityCommitmentsRequest struct {
	// Required. Resource name of the parent reservation. E.g.,
	//    projects/myproject/locations/US
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCapacityCommitmentsRequest) Reset()         { *m = ListCapacityCommitmentsRequest{} }
func (m *ListCapacityCommitmentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListCapacityCommitmentsRequest) ProtoMessage()    {}
func (*ListCapacityCommitmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{9}
}

func (m *ListCapacityCommitmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCapacityCommitmentsRequest.Unmarshal(m, b)
}
func (m *ListCapacityCommitmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCapacityCommitmentsRequest.Marshal(b, m, deterministic)
}
func (m *ListCapacityCommitmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCapacityCommitmentsRequest.Merge(m, src)
}
func (m *ListCapacityCommitmentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListCapacityCommitmentsRequest.Size(m)
}
func (m *ListCapacityCommitmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCapacityCommitmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCapacityCommitmentsRequest proto.InternalMessageInfo

func (m *ListCapacityCommitmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCapacityCommitmentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCapacityCommitmentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListCapacityCommitments][google.cloud.bigquery.reservation.v1.ReservationService.ListCapacityCommitments].
type ListCapacityCommitmentsResponse struct {
	// List of capacity commitments visible to the user.
	CapacityCommitments []*CapacityCommitment `protobuf:"bytes,1,rep,name=capacity_commitments,json=capacityCommitments,proto3" json:"capacity_commitments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCapacityCommitmentsResponse) Reset()         { *m = ListCapacityCommitmentsResponse{} }
func (m *ListCapacityCommitmentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListCapacityCommitmentsResponse) ProtoMessage()    {}
func (*ListCapacityCommitmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{10}
}

func (m *ListCapacityCommitmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCapacityCommitmentsResponse.Unmarshal(m, b)
}
func (m *ListCapacityCommitmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCapacityCommitmentsResponse.Marshal(b, m, deterministic)
}
func (m *ListCapacityCommitmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCapacityCommitmentsResponse.Merge(m, src)
}
func (m *ListCapacityCommitmentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListCapacityCommitmentsResponse.Size(m)
}
func (m *ListCapacityCommitmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCapacityCommitmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCapacityCommitmentsResponse proto.InternalMessageInfo

func (m *ListCapacityCommitmentsResponse) GetCapacityCommitments() []*CapacityCommitment {
	if m != nil {
		return m.CapacityCommitments
	}
	return nil
}

func (m *ListCapacityCommitmentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.GetCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.GetCapacityCommitment].
type GetCapacityCommitmentRequest struct {
	// Required. Resource name of the capacity commitment to retrieve. E.g.,
	//    projects/myproject/locations/US/capacityCommitments/123
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCapacityCommitmentRequest) Reset()         { *m = GetCapacityCommitmentRequest{} }
func (m *GetCapacityCommitmentRequest) String() string { return proto.CompactTextString(m) }
func (*GetCapacityCommitmentRequest) ProtoMessage()    {}
func (*GetCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{11}
}

func (m *GetCapacityCommitmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCapacityCommitmentRequest.Unmarshal(m, b)
}
func (m *GetCapacityCommitmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCapacityCommitmentRequest.Marshal(b, m, deterministic)
}
func (m *GetCapacityCommitmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCapacityCommitmentRequest.Merge(m, src)
}
func (m *GetCapacityCommitmentRequest) XXX_Size() int {
	return xxx_messageInfo_GetCapacityCommitmentRequest.Size(m)
}
func (m *GetCapacityCommitmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCapacityCommitmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCapacityCommitmentRequest proto.InternalMessageInfo

func (m *GetCapacityCommitmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.DeleteCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.DeleteCapacityCommitment].
type DeleteCapacityCommitmentRequest struct {
	// Required. Resource name of the capacity commitment to delete. E.g.,
	//    projects/myproject/locations/US/capacityCommitments/123
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteCapacityCommitmentRequest) Reset()         { *m = DeleteCapacityCommitmentRequest{} }
func (m *DeleteCapacityCommitmentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteCapacityCommitmentRequest) ProtoMessage()    {}
func (*DeleteCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{12}
}

func (m *DeleteCapacityCommitmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteCapacityCommitmentRequest.Unmarshal(m, b)
}
func (m *DeleteCapacityCommitmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteCapacityCommitmentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteCapacityCommitmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteCapacityCommitmentRequest.Merge(m, src)
}
func (m *DeleteCapacityCommitmentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteCapacityCommitmentRequest.Size(m)
}
func (m *DeleteCapacityCommitmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteCapacityCommitmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteCapacityCommitmentRequest proto.InternalMessageInfo

func (m *DeleteCapacityCommitmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.UpdateCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.UpdateCapacityCommitment].
type UpdateCapacityCommitmentRequest struct {
	// Content of the capacity commitment to update.
	CapacityCommitment *CapacityCommitment `protobuf:"bytes,1,opt,name=capacity_commitment,json=capacityCommitment,proto3" json:"capacity_commitment,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateCapacityCommitmentRequest) Reset()         { *m = UpdateCapacityCommitmentRequest{} }
func (m *UpdateCapacityCommitmentRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCapacityCommitmentRequest) ProtoMessage()    {}
func (*UpdateCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{13}
}

func (m *UpdateCapacityCommitmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCapacityCommitmentRequest.Unmarshal(m, b)
}
func (m *UpdateCapacityCommitmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCapacityCommitmentRequest.Marshal(b, m, deterministic)
}
func (m *UpdateCapacityCommitmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCapacityCommitmentRequest.Merge(m, src)
}
func (m *UpdateCapacityCommitmentRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCapacityCommitmentRequest.Size(m)
}
func (m *UpdateCapacityCommitmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCapacityCommitmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCapacityCommitmentRequest proto.InternalMessageInfo

func (m *UpdateCapacityCommitmentRequest) GetCapacityCommitment() *CapacityCommitment {
	if m != nil {
		return m.CapacityCommitment
	}
	return nil
}

func (m *UpdateCapacityCommitmentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request for
// [ReservationService.SplitCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.SplitCapacityCommitment].
type SplitCapacityCommitmentRequest struct {
	// Required. The resource name e.g.,:
	//   projects/myproject/locations/US/capacityCommitments/123
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Number of slots in the capacity commitment after the split.
	SlotCount            int64    `protobuf:"varint,2,opt,name=slot_count,json=slotCount,proto3" json:"slot_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SplitCapacityCommitmentRequest) Reset()         { *m = SplitCapacityCommitmentRequest{} }
func (m *SplitCapacityCommitmentRequest) String() string { return proto.CompactTextString(m) }
func (*SplitCapacityCommitmentRequest) ProtoMessage()    {}
func (*SplitCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{14}
}

func (m *SplitCapacityCommitmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitCapacityCommitmentRequest.Unmarshal(m, b)
}
func (m *SplitCapacityCommitmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitCapacityCommitmentRequest.Marshal(b, m, deterministic)
}
func (m *SplitCapacityCommitmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitCapacityCommitmentRequest.Merge(m, src)
}
func (m *SplitCapacityCommitmentRequest) XXX_Size() int {
	return xxx_messageInfo_SplitCapacityCommitmentRequest.Size(m)
}
func (m *SplitCapacityCommitmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitCapacityCommitmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SplitCapacityCommitmentRequest proto.InternalMessageInfo

func (m *SplitCapacityCommitmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SplitCapacityCommitmentRequest) GetSlotCount() int64 {
	if m != nil {
		return m.SlotCount
	}
	return 0
}

// The response for
// [ReservationService.SplitCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.SplitCapacityCommitment].
type SplitCapacityCommitmentResponse struct {
	// First capacity commitment, result of a split.
	First *CapacityCommitment `protobuf:"bytes,1,opt,name=first,proto3" json:"first,omitempty"`
	// Second capacity commitment, result of a split.
	Second               *CapacityCommitment `protobuf:"bytes,2,opt,name=second,proto3" json:"second,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *SplitCapacityCommitmentResponse) Reset()         { *m = SplitCapacityCommitmentResponse{} }
func (m *SplitCapacityCommitmentResponse) String() string { return proto.CompactTextString(m) }
func (*SplitCapacityCommitmentResponse) ProtoMessage()    {}
func (*SplitCapacityCommitmentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{15}
}

func (m *SplitCapacityCommitmentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitCapacityCommitmentResponse.Unmarshal(m, b)
}
func (m *SplitCapacityCommitmentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitCapacityCommitmentResponse.Marshal(b, m, deterministic)
}
func (m *SplitCapacityCommitmentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitCapacityCommitmentResponse.Merge(m, src)
}
func (m *SplitCapacityCommitmentResponse) XXX_Size() int {
	return xxx_messageInfo_SplitCapacityCommitmentResponse.Size(m)
}
func (m *SplitCapacityCommitmentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitCapacityCommitmentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SplitCapacityCommitmentResponse proto.InternalMessageInfo

func (m *SplitCapacityCommitmentResponse) GetFirst() *CapacityCommitment {
	if m != nil {
		return m.First
	}
	return nil
}

func (m *SplitCapacityCommitmentResponse) GetSecond() *CapacityCommitment {
	if m != nil {
		return m.Second
	}
	return nil
}

// The request for
// [ReservationService.MergeCapacityCommitments][google.cloud.bigquery.reservation.v1.ReservationService.MergeCapacityCommitments].
type MergeCapacityCommitmentsRequest struct {
	// Parent resource that identifies admin project and location e.g.,
	// projects/myproject/locations/us
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Ids of capacity commitments to merge.
	// These capacity commitments must exist under admin project and location
	// specified in the parent.
	CapacityCommitmentIds []string `protobuf:"bytes,2,rep,name=capacity_commitment_ids,json=capacityCommitmentIds,proto3" json:"capacity_commitment_ids,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *MergeCapacityCommitmentsRequest) Reset()         { *m = MergeCapacityCommitmentsRequest{} }
func (m *MergeCapacityCommitmentsRequest) String() string { return proto.CompactTextString(m) }
func (*MergeCapacityCommitmentsRequest) ProtoMessage()    {}
func (*MergeCapacityCommitmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{16}
}

func (m *MergeCapacityCommitmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeCapacityCommitmentsRequest.Unmarshal(m, b)
}
func (m *MergeCapacityCommitmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeCapacityCommitmentsRequest.Marshal(b, m, deterministic)
}
func (m *MergeCapacityCommitmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeCapacityCommitmentsRequest.Merge(m, src)
}
func (m *MergeCapacityCommitmentsRequest) XXX_Size() int {
	return xxx_messageInfo_MergeCapacityCommitmentsRequest.Size(m)
}
func (m *MergeCapacityCommitmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeCapacityCommitmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeCapacityCommitmentsRequest proto.InternalMessageInfo

func (m *MergeCapacityCommitmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *MergeCapacityCommitmentsRequest) GetCapacityCommitmentIds() []string {
	if m != nil {
		return m.CapacityCommitmentIds
	}
	return nil
}

// A Assignment allows a project to submit jobs
// of a certain type using slots from the specified reservation.
type Assignment struct {
	// Output only. Name of the resource. E.g.:
	// `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource which will use the reservation. E.g.
	// `projects/myproject`, `folders/123`, or `organizations/456`.
	Assignee string `protobuf:"bytes,4,opt,name=assignee,proto3" json:"assignee,omitempty"`
	// Which type of jobs will use the reservation.
	JobType Assignment_JobType `protobuf:"varint,3,opt,name=job_type,json=jobType,proto3,enum=google.cloud.bigquery.reservation.v1.Assignment_JobType" json:"job_type,omitempty"`
	// Output only. State of the assignment.
	State                Assignment_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.bigquery.reservation.v1.Assignment_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Assignment) Reset()         { *m = Assignment{} }
func (m *Assignment) String() string { return proto.CompactTextString(m) }
func (*Assignment) ProtoMessage()    {}
func (*Assignment) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{17}
}

func (m *Assignment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Assignment.Unmarshal(m, b)
}
func (m *Assignment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Assignment.Marshal(b, m, deterministic)
}
func (m *Assignment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Assignment.Merge(m, src)
}
func (m *Assignment) XXX_Size() int {
	return xxx_messageInfo_Assignment.Size(m)
}
func (m *Assignment) XXX_DiscardUnknown() {
	xxx_messageInfo_Assignment.DiscardUnknown(m)
}

var xxx_messageInfo_Assignment proto.InternalMessageInfo

func (m *Assignment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Assignment) GetAssignee() string {
	if m != nil {
		return m.Assignee
	}
	return ""
}

func (m *Assignment) GetJobType() Assignment_JobType {
	if m != nil {
		return m.JobType
	}
	return Assignment_JOB_TYPE_UNSPECIFIED
}

func (m *Assignment) GetState() Assignment_State {
	if m != nil {
		return m.State
	}
	return Assignment_STATE_UNSPECIFIED
}

// The request for
// [ReservationService.CreateAssignment][google.cloud.bigquery.reservation.v1.ReservationService.CreateAssignment].
// Note: "bigquery.reservationAssignments.create" permission is required on the
// related assignee.
type CreateAssignmentRequest struct {
	// Required. The parent resource name of the assignment
	// E.g. `projects/myproject/locations/US/reservations/team1-prod`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Assignment resource to create.
	Assignment           *Assignment `protobuf:"bytes,2,opt,name=assignment,proto3" json:"assignment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateAssignmentRequest) Reset()         { *m = CreateAssignmentRequest{} }
func (m *CreateAssignmentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAssignmentRequest) ProtoMessage()    {}
func (*CreateAssignmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{18}
}

func (m *CreateAssignmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAssignmentRequest.Unmarshal(m, b)
}
func (m *CreateAssignmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAssignmentRequest.Marshal(b, m, deterministic)
}
func (m *CreateAssignmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAssignmentRequest.Merge(m, src)
}
func (m *CreateAssignmentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAssignmentRequest.Size(m)
}
func (m *CreateAssignmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAssignmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAssignmentRequest proto.InternalMessageInfo

func (m *CreateAssignmentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAssignmentRequest) GetAssignment() *Assignment {
	if m != nil {
		return m.Assignment
	}
	return nil
}

// The request for
// [ReservationService.ListAssignments][google.cloud.bigquery.reservation.v1.ReservationService.ListAssignments].
type ListAssignmentsRequest struct {
	// Required. The parent resource name e.g.:
	//
	// `projects/myproject/locations/US/reservations/team1-prod`
	//
	// Or:
	//
	// `projects/myproject/locations/US/reservations/-`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAssignmentsRequest) Reset()         { *m = ListAssignmentsRequest{} }
func (m *ListAssignmentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAssignmentsRequest) ProtoMessage()    {}
func (*ListAssignmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{19}
}

func (m *ListAssignmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssignmentsRequest.Unmarshal(m, b)
}
func (m *ListAssignmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssignmentsRequest.Marshal(b, m, deterministic)
}
func (m *ListAssignmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssignmentsRequest.Merge(m, src)
}
func (m *ListAssignmentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAssignmentsRequest.Size(m)
}
func (m *ListAssignmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssignmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssignmentsRequest proto.InternalMessageInfo

func (m *ListAssignmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAssignmentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAssignmentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListAssignments][google.cloud.bigquery.reservation.v1.ReservationService.ListAssignments].
type ListAssignmentsResponse struct {
	// List of assignments visible to the user.
	Assignments []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAssignmentsResponse) Reset()         { *m = ListAssignmentsResponse{} }
func (m *ListAssignmentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAssignmentsResponse) ProtoMessage()    {}
func (*ListAssignmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{20}
}

func (m *ListAssignmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssignmentsResponse.Unmarshal(m, b)
}
func (m *ListAssignmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssignmentsResponse.Marshal(b, m, deterministic)
}
func (m *ListAssignmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssignmentsResponse.Merge(m, src)
}
func (m *ListAssignmentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAssignmentsResponse.Size(m)
}
func (m *ListAssignmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssignmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssignmentsResponse proto.InternalMessageInfo

func (m *ListAssignmentsResponse) GetAssignments() []*Assignment {
	if m != nil {
		return m.Assignments
	}
	return nil
}

func (m *ListAssignmentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.DeleteAssignment][google.cloud.bigquery.reservation.v1.ReservationService.DeleteAssignment].
// Note: "bigquery.reservationAssignments.delete" permission is required on the
// related assignee.
type DeleteAssignmentRequest struct {
	// Required. Name of the resource, e.g.
	//   `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAssignmentRequest) Reset()         { *m = DeleteAssignmentRequest{} }
func (m *DeleteAssignmentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAssignmentRequest) ProtoMessage()    {}
func (*DeleteAssignmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{21}
}

func (m *DeleteAssignmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAssignmentRequest.Unmarshal(m, b)
}
func (m *DeleteAssignmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAssignmentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAssignmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAssignmentRequest.Merge(m, src)
}
func (m *DeleteAssignmentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAssignmentRequest.Size(m)
}
func (m *DeleteAssignmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAssignmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAssignmentRequest proto.InternalMessageInfo

func (m *DeleteAssignmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.SearchAssignments][google.cloud.bigquery.reservation.v1.ReservationService.SearchAssignments].
// Note: "bigquery.reservationAssignments.search" permission is required on the
// related assignee.
type SearchAssignmentsRequest struct {
	// Required. The resource name of the admin project(containing project and
	// location), e.g.:
	//   "projects/myproject/locations/US".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Please specify resource name as assignee in the query.
	//
	// Examples:
	//
	// * `assignee=projects/myproject`
	// * `assignee=folders/123`
	// * `assignee=organizations/456`
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of items to return per page.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAssignmentsRequest) Reset()         { *m = SearchAssignmentsRequest{} }
func (m *SearchAssignmentsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchAssignmentsRequest) ProtoMessage()    {}
func (*SearchAssignmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{22}
}

func (m *SearchAssignmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAssignmentsRequest.Unmarshal(m, b)
}
func (m *SearchAssignmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAssignmentsRequest.Marshal(b, m, deterministic)
}
func (m *SearchAssignmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAssignmentsRequest.Merge(m, src)
}
func (m *SearchAssignmentsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchAssignmentsRequest.Size(m)
}
func (m *SearchAssignmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAssignmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAssignmentsRequest proto.InternalMessageInfo

func (m *SearchAssignmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchAssignmentsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchAssignmentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchAssignmentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [ReservationService.SearchAssignments][google.cloud.bigquery.reservation.v1.ReservationService.SearchAssignments].
type SearchAssignmentsResponse struct {
	// List of assignments visible to the user.
	Assignments []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAssignmentsResponse) Reset()         { *m = SearchAssignmentsResponse{} }
func (m *SearchAssignmentsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchAssignmentsResponse) ProtoMessage()    {}
func (*SearchAssignmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{23}
}

func (m *SearchAssignmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAssignmentsResponse.Unmarshal(m, b)
}
func (m *SearchAssignmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAssignmentsResponse.Marshal(b, m, deterministic)
}
func (m *SearchAssignmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAssignmentsResponse.Merge(m, src)
}
func (m *SearchAssignmentsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchAssignmentsResponse.Size(m)
}
func (m *SearchAssignmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAssignmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAssignmentsResponse proto.InternalMessageInfo

func (m *SearchAssignmentsResponse) GetAssignments() []*Assignment {
	if m != nil {
		return m.Assignments
	}
	return nil
}

func (m *SearchAssignmentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.MoveAssignment][google.cloud.bigquery.reservation.v1.ReservationService.MoveAssignment].
//
// **Note**: "bigquery.reservationAssignments.create" permission is required on
// the destination_id.
//
// **Note**: "bigquery.reservationAssignments.create" and
// "bigquery.reservationAssignments.delete" permission are required on the
// related assignee.
type MoveAssignmentRequest struct {
	// Required. The resource name of the assignment,
	// e.g.
	// `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The new reservation ID, e.g.:
	//   `projects/myotherproject/locations/US/reservations/team2-prod`
	DestinationId        string   `protobuf:"bytes,3,opt,name=destination_id,json=destinationId,proto3" json:"destination_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveAssignmentRequest) Reset()         { *m = MoveAssignmentRequest{} }
func (m *MoveAssignmentRequest) String() string { return proto.CompactTextString(m) }
func (*MoveAssignmentRequest) ProtoMessage()    {}
func (*MoveAssignmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{24}
}

func (m *MoveAssignmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveAssignmentRequest.Unmarshal(m, b)
}
func (m *MoveAssignmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveAssignmentRequest.Marshal(b, m, deterministic)
}
func (m *MoveAssignmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveAssignmentRequest.Merge(m, src)
}
func (m *MoveAssignmentRequest) XXX_Size() int {
	return xxx_messageInfo_MoveAssignmentRequest.Size(m)
}
func (m *MoveAssignmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveAssignmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveAssignmentRequest proto.InternalMessageInfo

func (m *MoveAssignmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MoveAssignmentRequest) GetDestinationId() string {
	if m != nil {
		return m.DestinationId
	}
	return ""
}

// Represents a BI Reservation.
type BiReservation struct {
	// The resource name of the singleton BI reservation.
	// Reservation names have the form
	// `projects/{project_id}/locations/{location_id}/bireservation`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The last update timestamp of a reservation.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Size of a reservation, in bytes.
	Size                 int64    `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BiReservation) Reset()         { *m = BiReservation{} }
func (m *BiReservation) String() string { return proto.CompactTextString(m) }
func (*BiReservation) ProtoMessage()    {}
func (*BiReservation) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{25}
}

func (m *BiReservation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BiReservation.Unmarshal(m, b)
}
func (m *BiReservation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BiReservation.Marshal(b, m, deterministic)
}
func (m *BiReservation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BiReservation.Merge(m, src)
}
func (m *BiReservation) XXX_Size() int {
	return xxx_messageInfo_BiReservation.Size(m)
}
func (m *BiReservation) XXX_DiscardUnknown() {
	xxx_messageInfo_BiReservation.DiscardUnknown(m)
}

var xxx_messageInfo_BiReservation proto.InternalMessageInfo

func (m *BiReservation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BiReservation) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *BiReservation) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

// A request to get a singleton BI reservation.
type GetBiReservationRequest struct {
	// Required. Name of the requested reservation, for example:
	// `projects/{project_id}/locations/{location_id}/bireservation`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBiReservationRequest) Reset()         { *m = GetBiReservationRequest{} }
func (m *GetBiReservationRequest) String() string { return proto.CompactTextString(m) }
func (*GetBiReservationRequest) ProtoMessage()    {}
func (*GetBiReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{26}
}

func (m *GetBiReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBiReservationRequest.Unmarshal(m, b)
}
func (m *GetBiReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBiReservationRequest.Marshal(b, m, deterministic)
}
func (m *GetBiReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBiReservationRequest.Merge(m, src)
}
func (m *GetBiReservationRequest) XXX_Size() int {
	return xxx_messageInfo_GetBiReservationRequest.Size(m)
}
func (m *GetBiReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBiReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBiReservationRequest proto.InternalMessageInfo

func (m *GetBiReservationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to update a BI reservation.
type UpdateBiReservationRequest struct {
	// A reservation to update.
	BiReservation *BiReservation `protobuf:"bytes,1,opt,name=bi_reservation,json=biReservation,proto3" json:"bi_reservation,omitempty"`
	// A list of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateBiReservationRequest) Reset()         { *m = UpdateBiReservationRequest{} }
func (m *UpdateBiReservationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBiReservationRequest) ProtoMessage()    {}
func (*UpdateBiReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beef70125ad5a16a, []int{27}
}

func (m *UpdateBiReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBiReservationRequest.Unmarshal(m, b)
}
func (m *UpdateBiReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBiReservationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateBiReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBiReservationRequest.Merge(m, src)
}
func (m *UpdateBiReservationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBiReservationRequest.Size(m)
}
func (m *UpdateBiReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBiReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBiReservationRequest proto.InternalMessageInfo

func (m *UpdateBiReservationRequest) GetBiReservation() *BiReservation {
	if m != nil {
		return m.BiReservation
	}
	return nil
}

func (m *UpdateBiReservationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.bigquery.reservation.v1.CapacityCommitment_CommitmentPlan", CapacityCommitment_CommitmentPlan_name, CapacityCommitment_CommitmentPlan_value)
	proto.RegisterEnum("google.cloud.bigquery.reservation.v1.CapacityCommitment_State", CapacityCommitment_State_name, CapacityCommitment_State_value)
	proto.RegisterEnum("google.cloud.bigquery.reservation.v1.Assignment_JobType", Assignment_JobType_name, Assignment_JobType_value)
	proto.RegisterEnum("google.cloud.bigquery.reservation.v1.Assignment_State", Assignment_State_name, Assignment_State_value)
	proto.RegisterType((*Reservation)(nil), "google.cloud.bigquery.reservation.v1.Reservation")
	proto.RegisterType((*CapacityCommitment)(nil), "google.cloud.bigquery.reservation.v1.CapacityCommitment")
	proto.RegisterType((*CreateReservationRequest)(nil), "google.cloud.bigquery.reservation.v1.CreateReservationRequest")
	proto.RegisterType((*ListReservationsRequest)(nil), "google.cloud.bigquery.reservation.v1.ListReservationsRequest")
	proto.RegisterType((*ListReservationsResponse)(nil), "google.cloud.bigquery.reservation.v1.ListReservationsResponse")
	proto.RegisterType((*GetReservationRequest)(nil), "google.cloud.bigquery.reservation.v1.GetReservationRequest")
	proto.RegisterType((*DeleteReservationRequest)(nil), "google.cloud.bigquery.reservation.v1.DeleteReservationRequest")
	proto.RegisterType((*UpdateReservationRequest)(nil), "google.cloud.bigquery.reservation.v1.UpdateReservationRequest")
	proto.RegisterType((*CreateCapacityCommitmentRequest)(nil), "google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest")
	proto.RegisterType((*ListCapacityCommitmentsRequest)(nil), "google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsRequest")
	proto.RegisterType((*ListCapacityCommitmentsResponse)(nil), "google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsResponse")
	proto.RegisterType((*GetCapacityCommitmentRequest)(nil), "google.cloud.bigquery.reservation.v1.GetCapacityCommitmentRequest")
	proto.RegisterType((*DeleteCapacityCommitmentRequest)(nil), "google.cloud.bigquery.reservation.v1.DeleteCapacityCommitmentRequest")
	proto.RegisterType((*UpdateCapacityCommitmentRequest)(nil), "google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest")
	proto.RegisterType((*SplitCapacityCommitmentRequest)(nil), "google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentRequest")
	proto.RegisterType((*SplitCapacityCommitmentResponse)(nil), "google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse")
	proto.RegisterType((*MergeCapacityCommitmentsRequest)(nil), "google.cloud.bigquery.reservation.v1.MergeCapacityCommitmentsRequest")
	proto.RegisterType((*Assignment)(nil), "google.cloud.bigquery.reservation.v1.Assignment")
	proto.RegisterType((*CreateAssignmentRequest)(nil), "google.cloud.bigquery.reservation.v1.CreateAssignmentRequest")
	proto.RegisterType((*ListAssignmentsRequest)(nil), "google.cloud.bigquery.reservation.v1.ListAssignmentsRequest")
	proto.RegisterType((*ListAssignmentsResponse)(nil), "google.cloud.bigquery.reservation.v1.ListAssignmentsResponse")
	proto.RegisterType((*DeleteAssignmentRequest)(nil), "google.cloud.bigquery.reservation.v1.DeleteAssignmentRequest")
	proto.RegisterType((*SearchAssignmentsRequest)(nil), "google.cloud.bigquery.reservation.v1.SearchAssignmentsRequest")
	proto.RegisterType((*SearchAssignmentsResponse)(nil), "google.cloud.bigquery.reservation.v1.SearchAssignmentsResponse")
	proto.RegisterType((*MoveAssignmentRequest)(nil), "google.cloud.bigquery.reservation.v1.MoveAssignmentRequest")
	proto.RegisterType((*BiReservation)(nil), "google.cloud.bigquery.reservation.v1.BiReservation")
	proto.RegisterType((*GetBiReservationRequest)(nil), "google.cloud.bigquery.reservation.v1.GetBiReservationRequest")
	proto.RegisterType((*UpdateBiReservationRequest)(nil), "google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/reservation/v1/reservation.proto", fileDescriptor_beef70125ad5a16a)
}

var fileDescriptor_beef70125ad5a16a = []byte{
	// 2364 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0x4f, 0x6c, 0x1b, 0x59,
	0x19, 0xe7, 0xd9, 0x49, 0x9a, 0x7c, 0x69, 0x52, 0xe7, 0x75, 0xbb, 0xf1, 0xba, 0x4b, 0x13, 0x66,
	0x17, 0x14, 0x45, 0x5d, 0x4f, 0x9b, 0x55, 0xdb, 0xc5, 0x6d, 0xd3, 0x4e, 0x52, 0xb7, 0x75, 0xd7,
	0x71, 0xdc, 0xb1, 0x03, 0xb4, 0x7b, 0x18, 0x4d, 0xec, 0x17, 0x77, 0x5a, 0x7b, 0x66, 0x3a, 0x33,
	0x4e, 0xc9, 0x46, 0x11, 0x62, 0x0f, 0x48, 0xac, 0xd0, 0x82, 0x40, 0x08, 0x71, 0x07, 0x89, 0xc3,
	0x72, 0x01, 0x81, 0x56, 0x70, 0x42, 0x48, 0x48, 0x70, 0x41, 0x02, 0x4e, 0x96, 0x10, 0x2b, 0xc4,
	0x1f, 0xa9, 0x7b, 0x01, 0xed, 0x8d, 0x13, 0x9a, 0x37, 0xcf, 0xf6, 0x8c, 0x3d, 0x13, 0x8f, 0xc7,
	0xc9, 0xc2, 0xcd, 0xf3, 0xfe, 0x7c, 0xef, 0xfb, 0xfb, 0x7b, 0xef, 0xfb, 0x25, 0x70, 0xb9, 0xa6,
	0x69, 0xb5, 0x3a, 0xe1, 0x2b, 0x75, 0xad, 0x59, 0xe5, 0xb7, 0x95, 0xda, 0xd3, 0x26, 0x31, 0xf6,
	0x78, 0x83, 0x98, 0xc4, 0xd8, 0x95, 0x2d, 0x45, 0x53, 0xf9, 0xdd, 0x8b, 0xee, 0xcf, 0xb4, 0x6e,
	0x68, 0x96, 0x86, 0x5f, 0x75, 0xf6, 0xa5, 0xe9, 0xbe, 0x74, 0x7b, 0x5f, 0xda, 0xbd, 0x70, 0xf7,
	0x62, 0xea, 0x65, 0x26, 0x5d, 0xd6, 0x15, 0x5e, 0x56, 0x55, 0xcd, 0xa2, 0x33, 0xa6, 0x23, 0x23,
	0x35, 0xef, 0x9a, 0xad, 0xd4, 0x15, 0xa2, 0x5a, 0x6c, 0x62, 0xc1, 0x35, 0xb1, 0xa3, 0x90, 0x7a,
	0x55, 0xda, 0x26, 0x8f, 0xe4, 0x5d, 0x45, 0x33, 0xd8, 0x82, 0x97, 0x5c, 0x0b, 0x0c, 0x62, 0x6a,
	0x4d, 0xa3, 0x42, 0xd8, 0xd4, 0x59, 0x36, 0x45, 0xbf, 0xb6, 0x9b, 0x3b, 0x3c, 0x69, 0xe8, 0xd6,
	0x1e, 0x9b, 0x5c, 0xec, 0x9d, 0x74, 0xa4, 0x37, 0x64, 0xf3, 0x49, 0xcf, 0xd1, 0x9d, 0x15, 0x96,
	0xd2, 0x20, 0xa6, 0x25, 0x37, 0xf4, 0x1e, 0xa5, 0x0d, 0xbd, 0xc2, 0x9b, 0x96, 0x6c, 0x35, 0x99,
	0x35, 0xdc, 0x47, 0x08, 0xa6, 0xc5, 0xae, 0xf9, 0x18, 0xc3, 0x98, 0x2a, 0x37, 0x48, 0x12, 0x2d,
	0xa2, 0xa5, 0x29, 0x91, 0xfe, 0xc6, 0xaf, 0xc0, 0x8c, 0x59, 0xd7, 0x2c, 0xa9, 0x22, 0xeb, 0x72,
	0x45, 0xb1, 0xf6, 0x92, 0xb1, 0x45, 0xb4, 0x14, 0x17, 0x4f, 0xda, 0x83, 0xeb, 0x6c, 0x0c, 0x2f,
	0xc3, 0x9c, 0x52, 0x53, 0x35, 0x83, 0x48, 0x4a, 0xb5, 0x4e, 0x24, 0x7b, 0xce, 0x4c, 0x8e, 0x2d,
	0xa2, 0xa5, 0x49, 0xf1, 0x94, 0x33, 0x91, 0xab, 0xd6, 0x49, 0xc9, 0x1e, 0xce, 0x3c, 0x7b, 0x2e,
	0x58, 0xd0, 0x71, 0xbf, 0xdb, 0xfb, 0x8e, 0x9a, 0xb2, 0xae, 0x98, 0xe9, 0x8a, 0xd6, 0xe0, 0xdd,
	0x9a, 0xad, 0xe9, 0x86, 0xf6, 0x98, 0x54, 0x2c, 0x93, 0xdf, 0x67, 0xbf, 0x0e, 0xf8, 0xba, 0x56,
	0x71, 0x62, 0xc3, 0xef, 0xb7, 0x7f, 0x1e, 0xb8, 0xc3, 0x6e, 0xf2, 0xfb, 0xae, 0xaf, 0x03, 0xee,
	0x83, 0x09, 0xc0, 0x6d, 0x8d, 0xd7, 0xb5, 0x46, 0x43, 0xb1, 0x1a, 0x44, 0xb5, 0xf0, 0xbc, 0xdb,
	0xe8, 0xb5, 0xf8, 0x87, 0x42, 0x9c, 0x59, 0xfe, 0x69, 0x00, 0xc7, 0x72, 0xad, 0xa9, 0x5a, 0xcc,
	0xec, 0x29, 0x6a, 0xb6, 0x3d, 0x80, 0xdf, 0x82, 0x31, 0xbd, 0x2e, 0xab, 0xc9, 0xf8, 0x22, 0x5a,
	0x9a, 0x5d, 0xb9, 0x93, 0x0e, 0x93, 0x5d, 0xe9, 0xfe, 0xf3, 0xd3, 0xdd, 0x9f, 0xc5, 0xba, 0xac,
	0x8a, 0x54, 0x28, 0x7e, 0x00, 0xe3, 0x76, 0xa4, 0x08, 0x75, 0xe2, 0xec, 0xca, 0x6a, 0x64, 0xe9,
	0x25, 0x5b, 0x8a, 0x63, 0x95, 0x23, 0x11, 0x6f, 0xc2, 0xe9, 0x4a, 0x67, 0x5e, 0x22, 0x6a, 0x55,
	0xb2, 0xf3, 0x25, 0x39, 0xbe, 0x88, 0x96, 0xa6, 0x57, 0x52, 0xed, 0x83, 0xda, 0xc9, 0x94, 0x2e,
	0xb7, 0x93, 0xc9, 0x11, 0x32, 0xd7, 0xdd, 0x9b, 0x55, 0xab, 0xf6, 0x24, 0x5e, 0x85, 0xd9, 0x1d,
	0x59, 0xa9, 0x37, 0x0d, 0x22, 0x39, 0xd9, 0x95, 0x3c, 0x41, 0x65, 0xe1, 0xb6, 0x2c, 0x43, 0xaf,
	0x50, 0x3d, 0x9a, 0xa6, 0x23, 0x63, 0x86, 0x2d, 0x77, 0xc6, 0xf0, 0x63, 0x38, 0x69, 0x10, 0x95,
	0x3c, 0x93, 0xeb, 0x12, 0x75, 0xe8, 0xe4, 0xd1, 0x3a, 0x74, 0x9a, 0x09, 0xb7, 0x3f, 0x38, 0x09,
	0x66, 0xbd, 0xd3, 0x78, 0x01, 0xce, 0xae, 0x6f, 0x6e, 0x6c, 0xe4, 0xca, 0x1b, 0xd9, 0x42, 0x59,
	0x2a, 0xe6, 0x85, 0x82, 0xb4, 0x55, 0x28, 0x15, 0xb3, 0xeb, 0xb9, 0xdb, 0xb9, 0xec, 0xad, 0xc4,
	0xa7, 0xf0, 0x24, 0x8c, 0xdd, 0xce, 0x67, 0xbf, 0x94, 0x88, 0xe3, 0x29, 0x18, 0x2f, 0x8b, 0x39,
	0x21, 0x9f, 0x18, 0xc7, 0xd3, 0x70, 0x62, 0x63, 0xb3, 0x50, 0xbe, 0x9b, 0x7f, 0x90, 0x88, 0x61,
	0x80, 0x09, 0xa1, 0x50, 0xd8, 0x12, 0xf2, 0x89, 0x31, 0x6e, 0x1d, 0xc6, 0xa9, 0xcb, 0xf1, 0x19,
	0x98, 0x2b, 0x95, 0x85, 0x72, 0xb6, 0x47, 0xda, 0x34, 0x9c, 0x28, 0x66, 0x0b, 0xb7, 0x72, 0x85,
	0x3b, 0x09, 0x44, 0x37, 0xae, 0x97, 0x73, 0x5f, 0xc8, 0x3a, 0x42, 0x6e, 0x0b, 0xb9, 0x7c, 0xf6,
	0x56, 0x22, 0x9e, 0x79, 0x0f, 0x3d, 0x17, 0xde, 0x45, 0x70, 0x29, 0x44, 0x91, 0xf8, 0x24, 0xf4,
	0xfd, 0xb0, 0xb5, 0x52, 0xe9, 0xdb, 0x6b, 0xf2, 0xfb, 0xed, 0x41, 0xa9, 0x1b, 0xe8, 0x03, 0xee,
	0x1f, 0x08, 0x92, 0xeb, 0x06, 0x91, 0x2d, 0xe2, 0x2a, 0x4a, 0x91, 0x3c, 0x6d, 0x12, 0xd3, 0xc2,
	0x05, 0x98, 0xd0, 0x65, 0x83, 0xa8, 0x16, 0x2b, 0xa1, 0xcb, 0x1f, 0x0a, 0xb1, 0xff, 0x08, 0x17,
	0xf0, 0x90, 0x35, 0x2e, 0x32, 0x29, 0xf8, 0xb3, 0x30, 0xeb, 0xda, 0x21, 0x29, 0x55, 0x5a, 0x7b,
	0x53, 0xe2, 0x8c, 0x6b, 0x34, 0x57, 0xc5, 0x25, 0x98, 0x76, 0x0d, 0xd0, 0x32, 0x9c, 0x5e, 0xb9,
	0x18, 0x2e, 0x6b, 0xdc, 0xc7, 0xba, 0xa5, 0x70, 0x3f, 0x44, 0x30, 0x9f, 0x57, 0x4c, 0xcb, 0xb5,
	0xc0, 0x3c, 0x2e, 0x3b, 0xcf, 0xc2, 0x94, 0x2e, 0xd7, 0x88, 0x64, 0x2a, 0x6f, 0x13, 0x6a, 0xe2,
	0xb8, 0x38, 0x69, 0x0f, 0x94, 0x94, 0xb7, 0x29, 0xf8, 0xd0, 0x49, 0x4b, 0x7b, 0x42, 0x1c, 0xe3,
	0xa6, 0x44, 0xba, 0xbc, 0x6c, 0x0f, 0x70, 0xdf, 0x47, 0x90, 0xec, 0xd7, 0xd3, 0xd4, 0x35, 0xd5,
	0x24, 0x78, 0xcb, 0x2e, 0xa8, 0xee, 0x78, 0x12, 0x2d, 0xc6, 0xa3, 0xb9, 0xc6, 0x23, 0x06, 0x7f,
	0x0e, 0x4e, 0xa9, 0xe4, 0xcb, 0x96, 0xe4, 0xd2, 0x8b, 0x05, 0xc6, 0x1e, 0x2e, 0x76, 0x74, 0xab,
	0xc0, 0x99, 0x3b, 0xc4, 0xf2, 0x49, 0x94, 0x7b, 0x1e, 0xa4, 0x65, 0xee, 0x1b, 0xf6, 0x2a, 0x70,
	0xc0, 0x99, 0xdb, 0x81, 0xe4, 0x2d, 0x52, 0x27, 0xbe, 0x09, 0x79, 0x94, 0xe7, 0xbc, 0x8f, 0x20,
	0xb9, 0xa5, 0x57, 0xfd, 0x33, 0xbf, 0x27, 0x05, 0xd1, 0x51, 0xa4, 0x20, 0xbe, 0x0a, 0xd3, 0x4d,
	0x7a, 0x20, 0xbd, 0xe3, 0xa9, 0x8b, 0xfd, 0x70, 0xf9, 0xb6, 0xfd, 0x0c, 0xd8, 0x90, 0xcd, 0x27,
	0x22, 0x38, 0xcb, 0xed, 0xdf, 0xdc, 0x4f, 0x62, 0xb0, 0xe0, 0x14, 0x6a, 0x3f, 0x30, 0xb4, 0xb5,
	0xde, 0xea, 0xc9, 0xe3, 0xeb, 0xd4, 0x41, 0x57, 0x70, 0x34, 0xb8, 0xe9, 0xa4, 0xb3, 0x02, 0xa7,
	0x7d, 0xb0, 0x83, 0xe9, 0xff, 0x46, 0x54, 0x34, 0x17, 0x71, 0x3f, 0x4a, 0xe1, 0x0d, 0x78, 0x95,
	0xa8, 0x3b, 0x9a, 0x51, 0xb1, 0x8b, 0x47, 0xad, 0xd5, 0x89, 0x24, 0x57, 0x1b, 0x8a, 0x2a, 0x31,
	0xb8, 0x93, 0x74, 0x62, 0x48, 0x9a, 0x51, 0x63, 0x2f, 0x90, 0x05, 0xb6, 0xb6, 0x44, 0x97, 0x0a,
	0xf6, 0xca, 0xa2, 0xb3, 0xb0, 0x48, 0x8c, 0x4d, 0xa3, 0xc6, 0xfd, 0x14, 0xc1, 0x39, 0xbb, 0x98,
	0xfa, 0x4f, 0x37, 0x8f, 0xd9, 0x67, 0xa3, 0x40, 0xc0, 0xcf, 0x11, 0x2c, 0x04, 0x6a, 0xcd, 0x90,
	0xe0, 0x09, 0xbc, 0xe0, 0x13, 0x93, 0x36, 0x22, 0x44, 0x0f, 0xca, 0x69, 0x9f, 0xab, 0x23, 0x34,
	0x3e, 0x3c, 0x85, 0x97, 0xef, 0x10, 0x2b, 0x38, 0x3f, 0xef, 0x7b, 0xca, 0x97, 0x79, 0x3a, 0xe2,
	0x65, 0xc8, 0xaa, 0xd8, 0x82, 0x05, 0x07, 0x2d, 0x3e, 0xd1, 0x53, 0x7f, 0x8b, 0x60, 0xc1, 0xc1,
	0x8e, 0xe0, 0x63, 0x03, 0xaa, 0x06, 0x1d, 0x43, 0xd5, 0x8c, 0x04, 0x2c, 0xdf, 0x46, 0x70, 0xae,
	0xa4, 0xd7, 0x95, 0x4f, 0x34, 0x6e, 0x03, 0x9e, 0xe0, 0xdc, 0xaf, 0x11, 0x2c, 0x04, 0x2a, 0xc5,
	0x4a, 0xa0, 0x00, 0xe3, 0x3b, 0x8a, 0x61, 0x8e, 0xee, 0x52, 0x47, 0x0c, 0x2e, 0xc2, 0x84, 0x49,
	0x2a, 0x9a, 0x5a, 0x1d, 0x19, 0xd9, 0x98, 0x1c, 0xee, 0xc7, 0x08, 0x16, 0x36, 0x88, 0x51, 0x23,
	0x87, 0xe0, 0x8f, 0xd8, 0x83, 0x3f, 0x99, 0x23, 0x00, 0x9f, 0xcb, 0x30, 0xef, 0x93, 0x7a, 0x92,
	0x52, 0x35, 0x93, 0xb1, 0xc5, 0xf8, 0xd2, 0x94, 0x78, 0xa6, 0x3f, 0x89, 0x72, 0x55, 0x93, 0xfb,
	0x38, 0x0e, 0x20, 0x98, 0xa6, 0x52, 0x53, 0x0f, 0xef, 0x9f, 0x52, 0x30, 0x29, 0xd3, 0x65, 0xc4,
	0x69, 0x63, 0xa6, 0xc4, 0xce, 0x37, 0x2e, 0xc1, 0xe4, 0x63, 0x6d, 0x5b, 0xb2, 0xf6, 0x74, 0xc2,
	0x1a, 0xa8, 0x90, 0x7e, 0xec, 0x1e, 0x9c, 0xbe, 0xa7, 0x6d, 0x97, 0xf7, 0x74, 0x22, 0x9e, 0x78,
	0xec, 0xfc, 0xc0, 0xf7, 0xdb, 0x4d, 0xd3, 0x04, 0x95, 0x78, 0x79, 0x68, 0x89, 0x7d, 0xcd, 0x12,
	0x77, 0x0d, 0x4e, 0xb0, 0x63, 0x70, 0x12, 0x5e, 0xb8, 0xb7, 0xb9, 0x26, 0x95, 0x1f, 0x14, 0x7b,
	0xdf, 0xf4, 0x27, 0x61, 0xb2, 0x98, 0x2b, 0x66, 0xf3, 0xb9, 0x42, 0x36, 0x81, 0xec, 0x2e, 0xe1,
	0xfe, 0x56, 0x56, 0x7c, 0x90, 0x88, 0x71, 0x57, 0x22, 0x36, 0x03, 0x99, 0x6f, 0xa1, 0xe7, 0xc2,
	0x37, 0x10, 0xbc, 0x16, 0x22, 0xc0, 0xae, 0x48, 0xbc, 0x35, 0x7a, 0x93, 0xcc, 0xcb, 0x1d, 0x71,
	0x26, 0xbf, 0xdf, 0xfd, 0x38, 0xe0, 0x7e, 0x81, 0x60, 0xde, 0x79, 0x59, 0x74, 0x4f, 0x6c, 0x67,
	0xe7, 0x46, 0x4f, 0x76, 0x5e, 0xa2, 0xb5, 0xcf, 0xe3, 0xe1, 0xf4, 0xef, 0x24, 0x66, 0x11, 0xa0,
	0x7b, 0x32, 0x2b, 0xb3, 0x0b, 0xc3, 0x06, 0x53, 0x74, 0xc9, 0xe0, 0x7e, 0x80, 0xe0, 0x45, 0xfb,
	0xae, 0xec, 0x4e, 0x0f, 0x7a, 0xd5, 0xc3, 0xff, 0xe2, 0x55, 0xff, 0x5d, 0xd6, 0x7d, 0x78, 0xd4,
	0x64, 0x38, 0x26, 0xc2, 0xb4, 0x2b, 0x36, 0xec, 0x06, 0x1f, 0xde, 0x2b, 0x6e, 0x21, 0xa1, 0x6f,
	0xec, 0x2a, 0xcc, 0x3b, 0xd7, 0x67, 0x7f, 0xe8, 0x73, 0x9e, 0xea, 0x67, 0x81, 0x1f, 0x32, 0x71,
	0xd9, 0x75, 0xf9, 0x4b, 0x04, 0xc9, 0x12, 0x91, 0x8d, 0xca, 0x23, 0x9f, 0x30, 0x1d, 0x71, 0x8a,
	0xbd, 0x00, 0xe3, 0x74, 0x17, 0xb3, 0xd7, 0xf9, 0xf0, 0xc6, 0x2e, 0x7e, 0x68, 0xec, 0xc6, 0x7a,
	0x63, 0xf7, 0x3d, 0x04, 0x2f, 0xf9, 0x68, 0xff, 0x7f, 0x10, 0xbd, 0xaf, 0x23, 0x38, 0xb3, 0xa1,
	0xed, 0x1e, 0x6b, 0xf0, 0xec, 0xa6, 0xbd, 0x4a, 0x4c, 0x4b, 0x51, 0x3b, 0x4d, 0xbb, 0x93, 0xdd,
	0x33, 0xae, 0xd1, 0x5c, 0x95, 0xfb, 0x27, 0x82, 0x99, 0x35, 0x65, 0x10, 0xe7, 0x78, 0xb3, 0xf3,
	0x52, 0xa1, 0xd4, 0x54, 0x3c, 0x1c, 0x35, 0xc5, 0x9e, 0x2b, 0x94, 0x93, 0xc2, 0x30, 0x46, 0x83,
	0x38, 0x46, 0x9f, 0x0c, 0xf4, 0x77, 0xa6, 0xfe, 0x5c, 0x50, 0xe0, 0x42, 0x08, 0xe3, 0xbc, 0x0a,
	0x5e, 0x0a, 0x8b, 0xaa, 0xdb, 0x8a, 0x9b, 0x49, 0xa8, 0xc1, 0xfc, 0x1d, 0x62, 0x79, 0x44, 0xb5,
	0xdd, 0x9e, 0xf7, 0xb8, 0xfd, 0x0d, 0xea, 0xf6, 0x95, 0xe1, 0x35, 0x63, 0x65, 0xf3, 0x33, 0x04,
	0x29, 0xe7, 0x95, 0xe9, 0x7b, 0xd8, 0x43, 0x98, 0xdd, 0x56, 0xa4, 0xfe, 0x36, 0xf5, 0xf5, 0x70,
	0xc9, 0xe7, 0x95, 0x39, 0xb3, 0xed, 0x71, 0xcd, 0x28, 0x2f, 0xca, 0x95, 0xdf, 0xbf, 0x02, 0xd8,
	0x25, 0xac, 0x44, 0x8c, 0x5d, 0xa5, 0x42, 0xf0, 0xbf, 0x11, 0xcc, 0xf5, 0x51, 0x4d, 0x38, 0x2c,
	0x01, 0x1a, 0xc0, 0x51, 0xa5, 0x86, 0x6f, 0xca, 0x39, 0xa5, 0x25, 0x7c, 0xc6, 0x41, 0x8b, 0xf3,
	0xae, 0x55, 0xe7, 0xbd, 0xd4, 0xd4, 0x3b, 0x7f, 0xfc, 0xdb, 0x77, 0x62, 0x37, 0xb8, 0x0b, 0xfc,
	0xee, 0x45, 0x7e, 0xdf, 0x59, 0x7d, 0xbd, 0x93, 0x2f, 0xcb, 0xae, 0x3c, 0x59, 0xf6, 0xde, 0xba,
	0x19, 0x4f, 0xcb, 0xff, 0x27, 0x04, 0x89, 0x5e, 0x36, 0x07, 0x5f, 0x0f, 0xa7, 0x72, 0x00, 0x5b,
	0x95, 0x5a, 0x8d, 0xba, 0xdd, 0x41, 0x2c, 0x4e, 0x68, 0x09, 0x0c, 0x2c, 0xa9, 0x8d, 0x2b, 0x78,
	0x68, 0x1b, 0xf1, 0xaf, 0x10, 0xcc, 0x7a, 0x99, 0x20, 0x7c, 0x35, 0x9c, 0x56, 0xbe, 0xfc, 0x51,
	0x94, 0x20, 0xde, 0x68, 0x09, 0xb4, 0x4a, 0x3c, 0x36, 0xd8, 0x03, 0x01, 0x16, 0x78, 0x9f, 0x46,
	0xcb, 0x07, 0xf8, 0x7d, 0x04, 0x73, 0x7d, 0x44, 0x53, 0xd8, 0x74, 0x0c, 0x62, 0xa8, 0x52, 0x2f,
	0xf6, 0xd5, 0x48, 0xb6, 0xa1, 0x5b, 0x7b, 0x3d, 0xea, 0x2e, 0x0f, 0xaf, 0xee, 0xc7, 0x08, 0xe6,
	0xfa, 0xe8, 0xaa, 0xb0, 0xea, 0x06, 0xf1, 0x5c, 0x51, 0x1c, 0xff, 0xa4, 0x25, 0xcc, 0xbb, 0xcb,
	0xc6, 0x85, 0x13, 0xd4, 0xb8, 0x37, 0x57, 0xae, 0x51, 0xe3, 0xdc, 0x22, 0x86, 0x30, 0xd4, 0x5b,
	0x3f, 0xef, 0xc5, 0xda, 0xf4, 0xb4, 0x0f, 0x1d, 0x9e, 0x1d, 0x06, 0x3a, 0x02, 0xbb, 0xdb, 0x54,
	0xe4, 0x3e, 0x8f, 0x7b, 0xda, 0x12, 0x52, 0x0c, 0x48, 0x7c, 0xfa, 0x2d, 0xea, 0x8d, 0x02, 0x77,
	0x25, 0x4c, 0x75, 0xf9, 0xb0, 0x2e, 0x19, 0x3f, 0xfa, 0x00, 0xff, 0x8b, 0x3d, 0x24, 0x7d, 0x3a,
	0x4a, 0x7c, 0x2b, 0x3c, 0x30, 0x04, 0x37, 0xa4, 0xa9, 0xec, 0x88, 0x52, 0x18, 0xca, 0xdc, 0xf5,
	0xa2, 0xcc, 0xe7, 0x71, 0x54, 0x3f, 0xe0, 0x3f, 0x23, 0x4a, 0x3b, 0xfb, 0x24, 0xc0, 0x5a, 0x68,
	0xcc, 0x39, 0x8e, 0xe8, 0xdf, 0x76, 0x97, 0x74, 0xdb, 0xbe, 0xc3, 0x32, 0xdd, 0xef, 0xaf, 0x32,
	0xcb, 0x07, 0x36, 0x98, 0x26, 0x83, 0x38, 0xac, 0xb0, 0x39, 0x3e, 0x80, 0x03, 0x0b, 0x84, 0x25,
	0xaf, 0x0d, 0xcb, 0x91, 0x6d, 0xf8, 0x51, 0xac, 0x4d, 0xa6, 0x47, 0xb7, 0x61, 0x00, 0xa1, 0x36,
	0x42, 0xa4, 0xde, 0x45, 0x2d, 0x61, 0xc1, 0xa7, 0x9a, 0xfa, 0xb0, 0x6b, 0x7b, 0xe5, 0x4d, 0xea,
	0x01, 0x9f, 0xb5, 0xe9, 0xe1, 0xbd, 0xe2, 0x5f, 0xc1, 0xef, 0xc4, 0x60, 0x3e, 0x80, 0xda, 0x0a,
	0x5b, 0xc1, 0x87, 0xd3, 0x75, 0x61, 0x2b, 0x78, 0x00, 0xbf, 0xc6, 0x3d, 0x6c, 0x09, 0xa7, 0x6c,
	0xa3, 0xcf, 0x77, 0x89, 0x3a, 0xea, 0xa4, 0x35, 0xee, 0x7a, 0xc4, 0x34, 0xc9, 0x98, 0xf6, 0x91,
	0x19, 0xb4, 0x8c, 0xbf, 0x16, 0x83, 0x64, 0x10, 0x33, 0x16, 0x36, 0x5f, 0x06, 0x30, 0x6b, 0x23,
	0xe4, 0x8b, 0xd2, 0x12, 0xce, 0x05, 0xe3, 0xba, 0xa4, 0x54, 0x4d, 0x8f, 0x23, 0x22, 0x60, 0x7b,
	0xc3, 0xd6, 0xdd, 0x76, 0xc4, 0x47, 0x08, 0x12, 0xbd, 0xe4, 0x4b, 0xd8, 0x07, 0x62, 0x00, 0x69,
	0x93, 0x1a, 0xba, 0xfb, 0xe4, 0x76, 0x5a, 0xc2, 0x1c, 0x33, 0xb8, 0xdb, 0x87, 0x52, 0x1b, 0xf3,
	0xdc, 0xea, 0x60, 0x1b, 0x7b, 0xef, 0x70, 0x37, 0xd7, 0x94, 0x71, 0xb1, 0x35, 0xf8, 0x2f, 0x08,
	0x4e, 0xf5, 0xd0, 0x20, 0xf8, 0x5a, 0xf8, 0xfb, 0xa6, 0x9f, 0x3d, 0x48, 0x5d, 0x8f, 0xb8, 0x9b,
	0xe5, 0xf8, 0xa6, 0xf7, 0x96, 0xba, 0x89, 0x47, 0xb4, 0x16, 0x7f, 0x80, 0x20, 0xd1, 0xcb, 0xa8,
	0x84, 0x8d, 0x67, 0x00, 0x13, 0x13, 0x08, 0xde, 0x1b, 0x6e, 0xf0, 0xbe, 0xb9, 0xbc, 0x3a, 0xe4,
	0x9b, 0xd2, 0xc3, 0x08, 0x2e, 0x1f, 0xe0, 0xbf, 0x22, 0x98, 0xeb, 0xe3, 0x39, 0xc2, 0xbe, 0x30,
	0x83, 0xe8, 0x9d, 0xd4, 0x8d, 0xc8, 0xfb, 0x59, 0x88, 0xf2, 0x2d, 0xe1, 0x24, 0xcb, 0x4d, 0xba,
	0x93, 0x5a, 0x7b, 0x05, 0x5f, 0x0a, 0x51, 0x7a, 0x19, 0xb3, 0xcf, 0x9c, 0xbf, 0x23, 0x98, 0xf5,
	0x52, 0x26, 0x61, 0x3b, 0x17, 0x5f, 0xa2, 0x25, 0x42, 0xad, 0x55, 0x5b, 0xc2, 0x69, 0x0a, 0xab,
	0x5e, 0x56, 0x85, 0x9a, 0x75, 0x97, 0x5b, 0x1f, 0x2d, 0x88, 0x99, 0x86, 0xb6, 0x4b, 0x71, 0xe5,
	0x37, 0x08, 0x12, 0xbd, 0x2c, 0x45, 0xd8, 0x3c, 0x0c, 0x60, 0x37, 0x52, 0x51, 0x88, 0x05, 0x6e,
	0xd5, 0x9d, 0xa4, 0x17, 0x31, 0x3f, 0xd0, 0x3e, 0x0f, 0x11, 0x71, 0x80, 0xbf, 0x1a, 0x83, 0xd3,
	0x3e, 0x24, 0x08, 0xbe, 0x39, 0xcc, 0xa3, 0xe2, 0xe8, 0xcc, 0x31, 0x5b, 0x42, 0xca, 0xcb, 0xba,
	0xf4, 0x3d, 0x22, 0x8a, 0x2b, 0x4e, 0x25, 0x7a, 0x97, 0xa5, 0xc3, 0xdb, 0x9c, 0xe9, 0xe1, 0x75,
	0x52, 0x5f, 0xf9, 0x9d, 0xc0, 0x0d, 0xe6, 0x90, 0xfe, 0x20, 0x7c, 0xf1, 0x91, 0x65, 0xe9, 0x66,
	0x86, 0xe7, 0x9f, 0x3d, 0x7b, 0xd6, 0x4b, 0x30, 0xc9, 0x4d, 0xeb, 0x51, 0xe7, 0x5f, 0x2a, 0xcf,
	0x0f, 0x5a, 0x48, 0x5d, 0xf2, 0x9a, 0x5e, 0x97, 0xad, 0x1d, 0xcd, 0x68, 0xac, 0x7d, 0x13, 0xc1,
	0x52, 0x45, 0x6b, 0x84, 0x72, 0xd8, 0x5a, 0xc2, 0x65, 0x4b, 0xd1, 0x46, 0xac, 0x22, 0x7a, 0xb8,
	0xc9, 0x76, 0xd6, 0xb4, 0xba, 0xac, 0xd6, 0xd2, 0x9a, 0x51, 0xe3, 0x6b, 0x44, 0xa5, 0x78, 0xc6,
	0x77, 0xcf, 0x3f, 0xfc, 0x1f, 0x3f, 0xaf, 0xba, 0x3e, 0xb7, 0x27, 0xe8, 0xde, 0xd7, 0xff, 0x1b,
	0x00, 0x00, 0xff, 0xff, 0x2b, 0x43, 0x81, 0x91, 0x33, 0x2a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReservationServiceClient is the client API for ReservationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReservationServiceClient interface {
	// Creates a new reservation resource.
	CreateReservation(ctx context.Context, in *CreateReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Lists all the reservations for the project in the specified location.
	ListReservations(ctx context.Context, in *ListReservationsRequest, opts ...grpc.CallOption) (*ListReservationsResponse, error)
	// Returns information about the reservation.
	GetReservation(ctx context.Context, in *GetReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservation(ctx context.Context, in *DeleteReservationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates an existing reservation resource.
	UpdateReservation(ctx context.Context, in *UpdateReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Creates a new capacity commitment resource.
	CreateCapacityCommitment(ctx context.Context, in *CreateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Lists all the capacity commitments for the admin project.
	ListCapacityCommitments(ctx context.Context, in *ListCapacityCommitmentsRequest, opts ...grpc.CallOption) (*ListCapacityCommitmentsResponse, error)
	// Returns information about the capacity commitment.
	GetCapacityCommitment(ctx context.Context, in *GetCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Deletes a capacity commitment. Attempting to delete capacity commitment
	// before its commitment_end_time will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	DeleteCapacityCommitment(ctx context.Context, in *DeleteCapacityCommitmentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates an existing capacity commitment.
	//
	// Only `plan` and `renewal_plan` fields can be updated.
	//
	// Plan can only be changed to a plan of a longer commitment period.
	// Attempting to change to a plan with shorter commitment period will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	UpdateCapacityCommitment(ctx context.Context, in *UpdateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Splits capacity commitment to two commitments of the same plan and
	// `commitment_end_time`.
	//
	// A common use case is to enable downgrading commitments.
	//
	// For example, in order to downgrade from 10000 slots to 8000, you might
	// split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
	// you would change the plan of the first one to `FLEX` and then delete it.
	SplitCapacityCommitment(ctx context.Context, in *SplitCapacityCommitmentRequest, opts ...grpc.CallOption) (*SplitCapacityCommitmentResponse, error)
	// Merges capacity commitments of the same plan into a single commitment.
	//
	// The resulting capacity commitment has the greater commitment_end_time
	// out of the to-be-merged capacity commitments.
	//
	// Attempting to merge capacity commitments of different plan will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	MergeCapacityCommitments(ctx context.Context, in *MergeCapacityCommitmentsRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Creates an assignment object which allows the given project to submit jobs
	// of a certain type using slots from the specified reservation.
	//
	// Currently a
	// resource (project, folder, organization) can only have one assignment per
	// each (job_type, location) combination, and that reservation will be used
	// for all jobs of the matching type.
	//
	// Different assignments can be created on different levels of the
	// projects, folders or organization hierarchy.  During query execution,
	// the assignment is looked up at the project, folder and organization levels
	// in that order. The first assignment found is applied to the query.
	//
	// When creating assignments, it does not matter if other assignments exist at
	// higher levels.
	//
	// Example:
	//
	// * The organization `organizationA` contains two projects, `project1`
	//   and `project2`.
	// * Assignments for all three entities (`organizationA`, `project1`, and
	//   `project2`) could all be created and mapped to the same or different
	//   reservations.
	//
	// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
	// 'bigquery.admin' permissions on the project using the reservation
	// and the project that owns this reservation.
	//
	// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
	// does not match location of the reservation.
	CreateAssignment(ctx context.Context, in *CreateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error)
	// Lists assignments.
	//
	// Only explicitly created assignments will be returned.
	//
	// Example:
	//
	// * Organization `organizationA` contains two projects, `project1` and
	//   `project2`.
	// * Reservation `res1` exists and was created previously.
	// * CreateAssignment was used previously to define the following
	//   associations between entities and reservations: `<organizationA, res1>`
	//   and `<project1, res1>`
	//
	// In this example, ListAssignments will just return the above two assignments
	// for reservation `res1`, and no expansion/merge will happen.
	//
	// The wildcard "-" can be used for
	// reservations in the request. In that case all assignments belongs to the
	// specified project and location will be listed.
	//
	// **Note** "-" cannot be used for projects nor locations.
	ListAssignments(ctx context.Context, in *ListAssignmentsRequest, opts ...grpc.CallOption) (*ListAssignmentsResponse, error)
	// Deletes a assignment. No expansion will happen.
	//
	// Example:
	//
	// * Organization `organizationA` contains two projects, `project1` and
	//   `project2`.
	// * Reservation `res1` exists and was created previously.
	// * CreateAssignment was used previously to define the following
	//   associations between entities and reservations: `<organizationA, res1>`
	//   and `<project1, res1>`
	//
	// In this example, deletion of the `<organizationA, res1>` assignment won't
	// affect the other assignment `<project1, res1>`. After said deletion,
	// queries from `project1` will still use `res1` while queries from
	// `project2` will switch to use on-demand mode.
	DeleteAssignment(ctx context.Context, in *DeleteAssignmentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Looks up assignments for a specified resource for a particular region.
	// If the request is about a project:
	//
	// 1. Assignments created on the project will be returned if they exist.
	// 2. Otherwise assignments created on the closest ancestor will be
	//    returned.
	// 3. Assignments for different JobTypes will all be returned.
	//
	// The same logic applies if the request is about a folder.
	//
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	//
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//
	// 1. permission on the assignee will be verified in this API.
	// 2. Hierarchy lookup (project->folder->organization) happens in this API.
	// 3. Parent here is `projects/*/locations/*`, instead of
	//    `projects/*/locations/*reservations/*`.
	//
	// **Note** "-" cannot be used for projects
	// nor locations.
	SearchAssignments(ctx context.Context, in *SearchAssignmentsRequest, opts ...grpc.CallOption) (*SearchAssignmentsResponse, error)
	// Moves an assignment under a new reservation.
	//
	// This differs from removing an existing assignment and recreating a new one
	// by providing a transactional change that ensures an assignee always has an
	// associated reservation.
	MoveAssignment(ctx context.Context, in *MoveAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error)
	// Retrieves a BI reservation.
	GetBiReservation(ctx context.Context, in *GetBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error)
	// Updates a BI reservation.
	//
	// Only fields specified in the `field_mask` are updated.
	//
	// A singleton BI reservation always exists with default size 0.
	// In order to reserve BI capacity it needs to be updated to an amount
	// greater than 0. In order to release BI capacity reservation size
	// must be set to 0.
	UpdateBiReservation(ctx context.Context, in *UpdateBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error)
}

type reservationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReservationServiceClient(cc grpc.ClientConnInterface) ReservationServiceClient {
	return &reservationServiceClient{cc}
}

func (c *reservationServiceClient) CreateReservation(ctx context.Context, in *CreateReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/CreateReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListReservations(ctx context.Context, in *ListReservationsRequest, opts ...grpc.CallOption) (*ListReservationsResponse, error) {
	out := new(ListReservationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/ListReservations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetReservation(ctx context.Context, in *GetReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/GetReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteReservation(ctx context.Context, in *DeleteReservationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateReservation(ctx context.Context, in *UpdateReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) CreateCapacityCommitment(ctx context.Context, in *CreateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/CreateCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListCapacityCommitments(ctx context.Context, in *ListCapacityCommitmentsRequest, opts ...grpc.CallOption) (*ListCapacityCommitmentsResponse, error) {
	out := new(ListCapacityCommitmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/ListCapacityCommitments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetCapacityCommitment(ctx context.Context, in *GetCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/GetCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteCapacityCommitment(ctx context.Context, in *DeleteCapacityCommitmentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateCapacityCommitment(ctx context.Context, in *UpdateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) SplitCapacityCommitment(ctx context.Context, in *SplitCapacityCommitmentRequest, opts ...grpc.CallOption) (*SplitCapacityCommitmentResponse, error) {
	out := new(SplitCapacityCommitmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/SplitCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) MergeCapacityCommitments(ctx context.Context, in *MergeCapacityCommitmentsRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/MergeCapacityCommitments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) CreateAssignment(ctx context.Context, in *CreateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error) {
	out := new(Assignment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/CreateAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListAssignments(ctx context.Context, in *ListAssignmentsRequest, opts ...grpc.CallOption) (*ListAssignmentsResponse, error) {
	out := new(ListAssignmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/ListAssignments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteAssignment(ctx context.Context, in *DeleteAssignmentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) SearchAssignments(ctx context.Context, in *SearchAssignmentsRequest, opts ...grpc.CallOption) (*SearchAssignmentsResponse, error) {
	out := new(SearchAssignmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/SearchAssignments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) MoveAssignment(ctx context.Context, in *MoveAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error) {
	out := new(Assignment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/MoveAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetBiReservation(ctx context.Context, in *GetBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error) {
	out := new(BiReservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/GetBiReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateBiReservation(ctx context.Context, in *UpdateBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error) {
	out := new(BiReservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateBiReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReservationServiceServer is the server API for ReservationService service.
type ReservationServiceServer interface {
	// Creates a new reservation resource.
	CreateReservation(context.Context, *CreateReservationRequest) (*Reservation, error)
	// Lists all the reservations for the project in the specified location.
	ListReservations(context.Context, *ListReservationsRequest) (*ListReservationsResponse, error)
	// Returns information about the reservation.
	GetReservation(context.Context, *GetReservationRequest) (*Reservation, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservation(context.Context, *DeleteReservationRequest) (*empty.Empty, error)
	// Updates an existing reservation resource.
	UpdateReservation(context.Context, *UpdateReservationRequest) (*Reservation, error)
	// Creates a new capacity commitment resource.
	CreateCapacityCommitment(context.Context, *CreateCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Lists all the capacity commitments for the admin project.
	ListCapacityCommitments(context.Context, *ListCapacityCommitmentsRequest) (*ListCapacityCommitmentsResponse, error)
	// Returns information about the capacity commitment.
	GetCapacityCommitment(context.Context, *GetCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Deletes a capacity commitment. Attempting to delete capacity commitment
	// before its commitment_end_time will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	DeleteCapacityCommitment(context.Context, *DeleteCapacityCommitmentRequest) (*empty.Empty, error)
	// Updates an existing capacity commitment.
	//
	// Only `plan` and `renewal_plan` fields can be updated.
	//
	// Plan can only be changed to a plan of a longer commitment period.
	// Attempting to change to a plan with shorter commitment period will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	UpdateCapacityCommitment(context.Context, *UpdateCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Splits capacity commitment to two commitments of the same plan and
	// `commitment_end_time`.
	//
	// A common use case is to enable downgrading commitments.
	//
	// For example, in order to downgrade from 10000 slots to 8000, you might
	// split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
	// you would change the plan of the first one to `FLEX` and then delete it.
	SplitCapacityCommitment(context.Context, *SplitCapacityCommitmentRequest) (*SplitCapacityCommitmentResponse, error)
	// Merges capacity commitments of the same plan into a single commitment.
	//
	// The resulting capacity commitment has the greater commitment_end_time
	// out of the to-be-merged capacity commitments.
	//
	// Attempting to merge capacity commitments of different plan will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	MergeCapacityCommitments(context.Context, *MergeCapacityCommitmentsRequest) (*CapacityCommitment, error)
	// Creates an assignment object which allows the given project to submit jobs
	// of a certain type using slots from the specified reservation.
	//
	// Currently a
	// resource (project, folder, organization) can only have one assignment per
	// each (job_type, location) combination, and that reservation will be used
	// for all jobs of the matching type.
	//
	// Different assignments can be created on different levels of the
	// projects, folders or organization hierarchy.  During query execution,
	// the assignment is looked up at the project, folder and organization levels
	// in that order. The first assignment found is applied to the query.
	//
	// When creating assignments, it does not matter if other assignments exist at
	// higher levels.
	//
	// Example:
	//
	// * The organization `organizationA` contains two projects, `project1`
	//   and `project2`.
	// * Assignments for all three entities (`organizationA`, `project1`, and
	//   `project2`) could all be created and mapped to the same or different
	//   reservations.
	//
	// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
	// 'bigquery.admin' permissions on the project using the reservation
	// and the project that owns this reservation.
	//
	// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
	// does not match location of the reservation.
	CreateAssignment(context.Context, *CreateAssignmentRequest) (*Assignment, error)
	// Lists assignments.
	//
	// Only explicitly created assignments will be returned.
	//
	// Example:
	//
	// * Organization `organizationA` contains two projects, `project1` and
	//   `project2`.
	// * Reservation `res1` exists and was created previously.
	// * CreateAssignment was used previously to define the following
	//   associations between entities and reservations: `<organizationA, res1>`
	//   and `<project1, res1>`
	//
	// In this example, ListAssignments will just return the above two assignments
	// for reservation `res1`, and no expansion/merge will happen.
	//
	// The wildcard "-" can be used for
	// reservations in the request. In that case all assignments belongs to the
	// specified project and location will be listed.
	//
	// **Note** "-" cannot be used for projects nor locations.
	ListAssignments(context.Context, *ListAssignmentsRequest) (*ListAssignmentsResponse, error)
	// Deletes a assignment. No expansion will happen.
	//
	// Example:
	//
	// * Organization `organizationA` contains two projects, `project1` and
	//   `project2`.
	// * Reservation `res1` exists and was created previously.
	// * CreateAssignment was used previously to define the following
	//   associations between entities and reservations: `<organizationA, res1>`
	//   and `<project1, res1>`
	//
	// In this example, deletion of the `<organizationA, res1>` assignment won't
	// affect the other assignment `<project1, res1>`. After said deletion,
	// queries from `project1` will still use `res1` while queries from
	// `project2` will switch to use on-demand mode.
	DeleteAssignment(context.Context, *DeleteAssignmentRequest) (*empty.Empty, error)
	// Looks up assignments for a specified resource for a particular region.
	// If the request is about a project:
	//
	// 1. Assignments created on the project will be returned if they exist.
	// 2. Otherwise assignments created on the closest ancestor will be
	//    returned.
	// 3. Assignments for different JobTypes will all be returned.
	//
	// The same logic applies if the request is about a folder.
	//
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	//
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//
	// 1. permission on the assignee will be verified in this API.
	// 2. Hierarchy lookup (project->folder->organization) happens in this API.
	// 3. Parent here is `projects/*/locations/*`, instead of
	//    `projects/*/locations/*reservations/*`.
	//
	// **Note** "-" cannot be used for projects
	// nor locations.
	SearchAssignments(context.Context, *SearchAssignmentsRequest) (*SearchAssignmentsResponse, error)
	// Moves an assignment under a new reservation.
	//
	// This differs from removing an existing assignment and recreating a new one
	// by providing a transactional change that ensures an assignee always has an
	// associated reservation.
	MoveAssignment(context.Context, *MoveAssignmentRequest) (*Assignment, error)
	// Retrieves a BI reservation.
	GetBiReservation(context.Context, *GetBiReservationRequest) (*BiReservation, error)
	// Updates a BI reservation.
	//
	// Only fields specified in the `field_mask` are updated.
	//
	// A singleton BI reservation always exists with default size 0.
	// In order to reserve BI capacity it needs to be updated to an amount
	// greater than 0. In order to release BI capacity reservation size
	// must be set to 0.
	UpdateBiReservation(context.Context, *UpdateBiReservationRequest) (*BiReservation, error)
}

// UnimplementedReservationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReservationServiceServer struct {
}

func (*UnimplementedReservationServiceServer) CreateReservation(ctx context.Context, req *CreateReservationRequest) (*Reservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateReservation not implemented")
}
func (*UnimplementedReservationServiceServer) ListReservations(ctx context.Context, req *ListReservationsRequest) (*ListReservationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReservations not implemented")
}
func (*UnimplementedReservationServiceServer) GetReservation(ctx context.Context, req *GetReservationRequest) (*Reservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReservation not implemented")
}
func (*UnimplementedReservationServiceServer) DeleteReservation(ctx context.Context, req *DeleteReservationRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteReservation not implemented")
}
func (*UnimplementedReservationServiceServer) UpdateReservation(ctx context.Context, req *UpdateReservationRequest) (*Reservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateReservation not implemented")
}
func (*UnimplementedReservationServiceServer) CreateCapacityCommitment(ctx context.Context, req *CreateCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) ListCapacityCommitments(ctx context.Context, req *ListCapacityCommitmentsRequest) (*ListCapacityCommitmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCapacityCommitments not implemented")
}
func (*UnimplementedReservationServiceServer) GetCapacityCommitment(ctx context.Context, req *GetCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) DeleteCapacityCommitment(ctx context.Context, req *DeleteCapacityCommitmentRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) UpdateCapacityCommitment(ctx context.Context, req *UpdateCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) SplitCapacityCommitment(ctx context.Context, req *SplitCapacityCommitmentRequest) (*SplitCapacityCommitmentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SplitCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) MergeCapacityCommitments(ctx context.Context, req *MergeCapacityCommitmentsRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MergeCapacityCommitments not implemented")
}
func (*UnimplementedReservationServiceServer) CreateAssignment(ctx context.Context, req *CreateAssignmentRequest) (*Assignment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAssignment not implemented")
}
func (*UnimplementedReservationServiceServer) ListAssignments(ctx context.Context, req *ListAssignmentsRequest) (*ListAssignmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAssignments not implemented")
}
func (*UnimplementedReservationServiceServer) DeleteAssignment(ctx context.Context, req *DeleteAssignmentRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAssignment not implemented")
}
func (*UnimplementedReservationServiceServer) SearchAssignments(ctx context.Context, req *SearchAssignmentsRequest) (*SearchAssignmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAssignments not implemented")
}
func (*UnimplementedReservationServiceServer) MoveAssignment(ctx context.Context, req *MoveAssignmentRequest) (*Assignment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MoveAssignment not implemented")
}
func (*UnimplementedReservationServiceServer) GetBiReservation(ctx context.Context, req *GetBiReservationRequest) (*BiReservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetBiReservation not implemented")
}
func (*UnimplementedReservationServiceServer) UpdateBiReservation(ctx context.Context, req *UpdateBiReservationRequest) (*BiReservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateBiReservation not implemented")
}

func RegisterReservationServiceServer(s *grpc.Server, srv ReservationServiceServer) {
	s.RegisterService(&_ReservationService_serviceDesc, srv)
}

func _ReservationService_CreateReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/CreateReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateReservation(ctx, req.(*CreateReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListReservations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReservationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListReservations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/ListReservations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListReservations(ctx, req.(*ListReservationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/GetReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetReservation(ctx, req.(*GetReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteReservation(ctx, req.(*DeleteReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateReservation(ctx, req.(*UpdateReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_CreateCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/CreateCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateCapacityCommitment(ctx, req.(*CreateCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListCapacityCommitments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCapacityCommitmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListCapacityCommitments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/ListCapacityCommitments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListCapacityCommitments(ctx, req.(*ListCapacityCommitmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/GetCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetCapacityCommitment(ctx, req.(*GetCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteCapacityCommitment(ctx, req.(*DeleteCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateCapacityCommitment(ctx, req.(*UpdateCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SplitCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SplitCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/SplitCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SplitCapacityCommitment(ctx, req.(*SplitCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_MergeCapacityCommitments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeCapacityCommitmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).MergeCapacityCommitments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/MergeCapacityCommitments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).MergeCapacityCommitments(ctx, req.(*MergeCapacityCommitmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_CreateAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/CreateAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateAssignment(ctx, req.(*CreateAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/ListAssignments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListAssignments(ctx, req.(*ListAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteAssignment(ctx, req.(*DeleteAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SearchAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SearchAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/SearchAssignments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SearchAssignments(ctx, req.(*SearchAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_MoveAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).MoveAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/MoveAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).MoveAssignment(ctx, req.(*MoveAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetBiReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBiReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetBiReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/GetBiReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetBiReservation(ctx, req.(*GetBiReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateBiReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBiReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateBiReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateBiReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateBiReservation(ctx, req.(*UpdateBiReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReservationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.reservation.v1.ReservationService",
	HandlerType: (*ReservationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReservation",
			Handler:    _ReservationService_CreateReservation_Handler,
		},
		{
			MethodName: "ListReservations",
			Handler:    _ReservationService_ListReservations_Handler,
		},
		{
			MethodName: "GetReservation",
			Handler:    _ReservationService_GetReservation_Handler,
		},
		{
			MethodName: "DeleteReservation",
			Handler:    _ReservationService_DeleteReservation_Handler,
		},
		{
			MethodName: "UpdateReservation",
			Handler:    _ReservationService_UpdateReservation_Handler,
		},
		{
			MethodName: "CreateCapacityCommitment",
			Handler:    _ReservationService_CreateCapacityCommitment_Handler,
		},
		{
			MethodName: "ListCapacityCommitments",
			Handler:    _ReservationService_ListCapacityCommitments_Handler,
		},
		{
			MethodName: "GetCapacityCommitment",
			Handler:    _ReservationService_GetCapacityCommitment_Handler,
		},
		{
			MethodName: "DeleteCapacityCommitment",
			Handler:    _ReservationService_DeleteCapacityCommitment_Handler,
		},
		{
			MethodName: "UpdateCapacityCommitment",
			Handler:    _ReservationService_UpdateCapacityCommitment_Handler,
		},
		{
			MethodName: "SplitCapacityCommitment",
			Handler:    _ReservationService_SplitCapacityCommitment_Handler,
		},
		{
			MethodName: "MergeCapacityCommitments",
			Handler:    _ReservationService_MergeCapacityCommitments_Handler,
		},
		{
			MethodName: "CreateAssignment",
			Handler:    _ReservationService_CreateAssignment_Handler,
		},
		{
			MethodName: "ListAssignments",
			Handler:    _ReservationService_ListAssignments_Handler,
		},
		{
			MethodName: "DeleteAssignment",
			Handler:    _ReservationService_DeleteAssignment_Handler,
		},
		{
			MethodName: "SearchAssignments",
			Handler:    _ReservationService_SearchAssignments_Handler,
		},
		{
			MethodName: "MoveAssignment",
			Handler:    _ReservationService_MoveAssignment_Handler,
		},
		{
			MethodName: "GetBiReservation",
			Handler:    _ReservationService_GetBiReservation_Handler,
		},
		{
			MethodName: "UpdateBiReservation",
			Handler:    _ReservationService_UpdateBiReservation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/reservation/v1/reservation.proto",
}
