// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/environment.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents an environment state. When a environment is pointed to a new
// agent version, the environment is temporarily set to the `LOADING` state.
// During that time, the environment keeps on serving the previous version of
// the agent. After the new agent version is done loading, the environment is
// set back to the `RUNNING` state.
type Environment_State int32

const (
	// Not specified. This value is not used.
	Environment_STATE_UNSPECIFIED Environment_State = 0
	// Stopped.
	Environment_STOPPED Environment_State = 1
	// Loading.
	Environment_LOADING Environment_State = 2
	// Running.
	Environment_RUNNING Environment_State = 3
)

var Environment_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "STOPPED",
	2: "LOADING",
	3: "RUNNING",
}

var Environment_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"STOPPED":           1,
	"LOADING":           2,
	"RUNNING":           3,
}

func (x Environment_State) String() string {
	return proto.EnumName(Environment_State_name, int32(x))
}

func (Environment_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f690af77cb8ebc0e, []int{0, 0}
}

// Represents an agent environment.
type Environment struct {
	// Output only. The unique identifier of this agent environment.
	// Format: `projects/<Project ID>/agent/environments/<Environment ID>`.
	// For Environment ID, "-" is reserved for 'draft' environment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The developer-provided description for this environment.
	// The maximum length is 500 characters. If exceeded, the request is rejected.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The agent version loaded into this environment.
	// Format: `projects/<Project ID>/agent/versions/<Version ID>`.
	AgentVersion string `protobuf:"bytes,3,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	// Output only. The state of this environment. This field is read-only, i.e., it cannot be
	// set by create and update methods.
	State Environment_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.dialogflow.v2beta1.Environment_State" json:"state,omitempty"`
	// Output only. The last update time of this environment. This field is read-only, i.e., it
	// cannot be set by create and update methods.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Environment) Reset()         { *m = Environment{} }
func (m *Environment) String() string { return proto.CompactTextString(m) }
func (*Environment) ProtoMessage()    {}
func (*Environment) Descriptor() ([]byte, []int) {
	return fileDescriptor_f690af77cb8ebc0e, []int{0}
}

func (m *Environment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Environment.Unmarshal(m, b)
}
func (m *Environment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Environment.Marshal(b, m, deterministic)
}
func (m *Environment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Environment.Merge(m, src)
}
func (m *Environment) XXX_Size() int {
	return xxx_messageInfo_Environment.Size(m)
}
func (m *Environment) XXX_DiscardUnknown() {
	xxx_messageInfo_Environment.DiscardUnknown(m)
}

var xxx_messageInfo_Environment proto.InternalMessageInfo

func (m *Environment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Environment) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Environment) GetAgentVersion() string {
	if m != nil {
		return m.AgentVersion
	}
	return ""
}

func (m *Environment) GetState() Environment_State {
	if m != nil {
		return m.State
	}
	return Environment_STATE_UNSPECIFIED
}

func (m *Environment) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// The request message for [Environments.ListEnvironments][google.cloud.dialogflow.v2beta1.Environments.ListEnvironments].
type ListEnvironmentsRequest struct {
	// Required. The agent to list all environments from.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEnvironmentsRequest) Reset()         { *m = ListEnvironmentsRequest{} }
func (m *ListEnvironmentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListEnvironmentsRequest) ProtoMessage()    {}
func (*ListEnvironmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f690af77cb8ebc0e, []int{1}
}

func (m *ListEnvironmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEnvironmentsRequest.Unmarshal(m, b)
}
func (m *ListEnvironmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEnvironmentsRequest.Marshal(b, m, deterministic)
}
func (m *ListEnvironmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEnvironmentsRequest.Merge(m, src)
}
func (m *ListEnvironmentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListEnvironmentsRequest.Size(m)
}
func (m *ListEnvironmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEnvironmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEnvironmentsRequest proto.InternalMessageInfo

func (m *ListEnvironmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListEnvironmentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEnvironmentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Environments.ListEnvironments][google.cloud.dialogflow.v2beta1.Environments.ListEnvironments].
type ListEnvironmentsResponse struct {
	// The list of agent environments. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Environments []*Environment `protobuf:"bytes,1,rep,name=environments,proto3" json:"environments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEnvironmentsResponse) Reset()         { *m = ListEnvironmentsResponse{} }
func (m *ListEnvironmentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListEnvironmentsResponse) ProtoMessage()    {}
func (*ListEnvironmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f690af77cb8ebc0e, []int{2}
}

func (m *ListEnvironmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEnvironmentsResponse.Unmarshal(m, b)
}
func (m *ListEnvironmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEnvironmentsResponse.Marshal(b, m, deterministic)
}
func (m *ListEnvironmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEnvironmentsResponse.Merge(m, src)
}
func (m *ListEnvironmentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListEnvironmentsResponse.Size(m)
}
func (m *ListEnvironmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEnvironmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEnvironmentsResponse proto.InternalMessageInfo

func (m *ListEnvironmentsResponse) GetEnvironments() []*Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

func (m *ListEnvironmentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Environment_State", Environment_State_name, Environment_State_value)
	proto.RegisterType((*Environment)(nil), "google.cloud.dialogflow.v2beta1.Environment")
	proto.RegisterType((*ListEnvironmentsRequest)(nil), "google.cloud.dialogflow.v2beta1.ListEnvironmentsRequest")
	proto.RegisterType((*ListEnvironmentsResponse)(nil), "google.cloud.dialogflow.v2beta1.ListEnvironmentsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/environment.proto", fileDescriptor_f690af77cb8ebc0e)
}

var fileDescriptor_f690af77cb8ebc0e = []byte{
	// 769 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0x4f, 0x4f, 0x13, 0x4f,
	0x18, 0xfe, 0x6d, 0x4b, 0xf9, 0xc9, 0x14, 0xb4, 0x4e, 0x62, 0x28, 0xd5, 0x84, 0x5a, 0x82, 0x56,
	0x03, 0xbb, 0xa1, 0x5c, 0x14, 0x42, 0xe2, 0x42, 0x0b, 0x69, 0x82, 0xa5, 0xd9, 0x16, 0x12, 0x89,
	0xc9, 0x66, 0xba, 0x9d, 0x2e, 0x2b, 0xbb, 0x3b, 0xeb, 0xce, 0xb4, 0x20, 0x84, 0x8b, 0x47, 0xaf,
	0xfa, 0x09, 0x3c, 0x78, 0xf0, 0xe0, 0x07, 0xf1, 0xa8, 0x89, 0x67, 0x0e, 0x9e, 0xfc, 0x04, 0x86,
	0x8b, 0x66, 0x67, 0xb6, 0xed, 0x02, 0xd6, 0xaa, 0xb7, 0x7d, 0xff, 0x3c, 0xef, 0x3e, 0xf3, 0xbc,
	0xcf, 0x0c, 0x58, 0x30, 0x09, 0x31, 0x6d, 0xac, 0x18, 0x36, 0x69, 0x37, 0x95, 0xa6, 0x85, 0x6c,
	0x62, 0xb6, 0x6c, 0x72, 0xa0, 0x74, 0x0a, 0x0d, 0xcc, 0xd0, 0x82, 0x82, 0xdd, 0x8e, 0xe5, 0x13,
	0xd7, 0xc1, 0x2e, 0x93, 0x3d, 0x9f, 0x30, 0x02, 0xa7, 0x05, 0x44, 0xe6, 0x10, 0xb9, 0x0f, 0x91,
	0x43, 0x48, 0xe6, 0x56, 0x38, 0x13, 0x79, 0x96, 0x82, 0x5c, 0x97, 0x30, 0xc4, 0x2c, 0xe2, 0x52,
	0x01, 0xcf, 0x4c, 0x47, 0xaa, 0x2d, 0x0b, 0xdb, 0x4d, 0xbd, 0x81, 0xf7, 0x50, 0xc7, 0x22, 0x7e,
	0xd8, 0x30, 0x15, 0x69, 0xf0, 0x31, 0x25, 0x6d, 0xdf, 0xc0, 0x61, 0xa9, 0x30, 0x8c, 0x2d, 0x6a,
	0x37, 0x2d, 0xa2, 0x1b, 0xc4, 0x6d, 0x59, 0x66, 0x88, 0xb9, 0x19, 0x62, 0x78, 0xd4, 0x68, 0xb7,
	0x14, 0xec, 0x78, 0xec, 0x45, 0x58, 0xcc, 0x5e, 0x2c, 0x0a, 0x46, 0x0e, 0xa2, 0xfb, 0x17, 0xe8,
	0xf6, 0x3a, 0x98, 0xe5, 0x60, 0xca, 0x90, 0xe3, 0x85, 0x0d, 0x93, 0x11, 0xba, 0x86, 0x6d, 0xf5,
	0x74, 0xca, 0x7d, 0x89, 0x83, 0x64, 0xa9, 0xaf, 0x1e, 0x9c, 0x04, 0x23, 0x2e, 0x72, 0x70, 0x5a,
	0xca, 0x4a, 0xf9, 0xb1, 0xd5, 0xf8, 0xa9, 0x1a, 0xd7, 0x78, 0x02, 0xce, 0x82, 0x64, 0x13, 0x53,
	0xc3, 0xb7, 0xbc, 0x40, 0xa7, 0x74, 0xac, 0x5b, 0x97, 0xb4, 0x68, 0x1e, 0x56, 0xc0, 0x04, 0x32,
	0xb1, 0xcb, 0xf4, 0x0e, 0xf6, 0x69, 0xd0, 0x18, 0xe7, 0x8d, 0xf7, 0x4e, 0x55, 0xe9, 0x4c, 0x9d,
	0x01, 0xb7, 0x23, 0x9b, 0x10, 0x94, 0x90, 0x67, 0x51, 0xd9, 0x20, 0x8e, 0xb2, 0x23, 0x00, 0xda,
	0x38, 0xc7, 0x87, 0x11, 0x7c, 0x0c, 0x12, 0x94, 0x21, 0x86, 0xd3, 0x23, 0x59, 0x29, 0x7f, 0xb5,
	0x50, 0x90, 0x87, 0xec, 0x55, 0x8e, 0x1c, 0x46, 0xae, 0x05, 0x48, 0x71, 0x08, 0x31, 0x05, 0x3e,
	0x02, 0xc9, 0xb6, 0xd7, 0x44, 0x0c, 0xeb, 0x81, 0x42, 0xe9, 0x44, 0x56, 0xca, 0x27, 0x0b, 0x99,
	0xee, 0xd0, 0xae, 0x7c, 0x72, 0xbd, 0x2b, 0x9f, 0x00, 0x03, 0x81, 0x09, 0xb2, 0xb9, 0x12, 0x48,
	0xf0, 0xb1, 0xf0, 0x06, 0xb8, 0x5e, 0xab, 0xab, 0xf5, 0x92, 0xbe, 0x5d, 0xa9, 0x55, 0x4b, 0x6b,
	0xe5, 0xf5, 0x72, 0xa9, 0x98, 0xfa, 0x0f, 0x26, 0xc1, 0xff, 0xb5, 0xfa, 0x56, 0xb5, 0x5a, 0x2a,
	0xa6, 0xa4, 0x20, 0xd8, 0xdc, 0x52, 0x8b, 0xe5, 0xca, 0x46, 0x2a, 0x16, 0x04, 0xda, 0x76, 0xa5,
	0x12, 0x04, 0xf1, 0x25, 0xfd, 0x9b, 0xfa, 0x14, 0xcc, 0x0e, 0x56, 0x23, 0xba, 0x93, 0x45, 0xcf,
	0x27, 0xcf, 0xb0, 0xc1, 0xa8, 0x72, 0x1c, 0x7e, 0x9d, 0x28, 0x5c, 0xa4, 0xa8, 0xef, 0xa9, 0x72,
	0x1c, 0x89, 0x4e, 0x72, 0xef, 0x24, 0x30, 0xb9, 0x69, 0x51, 0x16, 0x19, 0x44, 0x35, 0xfc, 0xbc,
	0x8d, 0x29, 0x83, 0x25, 0x30, 0xea, 0x21, 0x1f, 0xbb, 0x2c, 0x5c, 0xf3, 0xfc, 0xa9, 0x1a, 0x3b,
	0x53, 0xef, 0xc2, 0x3f, 0xe3, 0xa3, 0x85, 0x60, 0x98, 0x05, 0x63, 0x1e, 0x32, 0xb1, 0x4e, 0xad,
	0x23, 0xcc, 0x0d, 0x91, 0x10, 0x86, 0xb8, 0x12, 0x64, 0x6b, 0xd6, 0x11, 0x86, 0x39, 0x00, 0x78,
	0x07, 0x23, 0xfb, 0xb8, 0x6b, 0x05, 0xde, 0xc2, 0x81, 0xf5, 0x20, 0x9b, 0x7b, 0x23, 0x81, 0xf4,
	0x65, 0xa2, 0xd4, 0x23, 0x2e, 0xc5, 0xb0, 0x0a, 0xc6, 0xa3, 0x67, 0x4c, 0x4b, 0xd9, 0x78, 0x3e,
	0x59, 0x98, 0xfb, 0x1b, 0x17, 0x68, 0xe7, 0x26, 0xc0, 0x3b, 0xe0, 0x9a, 0x8b, 0x0f, 0x99, 0x1e,
	0xe1, 0xc5, 0xbd, 0xac, 0x4d, 0x04, 0xe9, 0x6a, 0x97, 0x56, 0xe1, 0x55, 0x1c, 0x8c, 0x47, 0x29,
	0xc1, 0x1f, 0x12, 0x48, 0x5d, 0xe4, 0x09, 0x1f, 0x0c, 0x65, 0x32, 0x60, 0x07, 0x99, 0x87, 0xff,
	0x80, 0x14, 0xa2, 0xe4, 0x3a, 0x2f, 0x3f, 0x7f, 0x7d, 0x1d, 0xf3, 0xa0, 0xd2, 0x7b, 0x51, 0x8e,
	0xc5, 0x46, 0x56, 0x7a, 0x46, 0xb9, 0x2f, 0x0c, 0x72, 0x72, 0xce, 0x21, 0xbb, 0x2b, 0x70, 0xf9,
	0x77, 0x10, 0x9b, 0x18, 0xe2, 0x11, 0xfc, 0x35, 0x3c, 0x73, 0xf8, 0x51, 0x9d, 0x1a, 0xe8, 0x90,
	0x4f, 0xea, 0x93, 0x3d, 0xc6, 0x3c, 0xba, 0xa4, 0x28, 0x07, 0x07, 0x97, 0xec, 0x83, 0xda, 0x6c,
	0x4f, 0x3c, 0x88, 0xf3, 0x9e, 0x8d, 0x58, 0x8b, 0xf8, 0xce, 0xdc, 0xb0, 0xf6, 0xfe, 0xaf, 0x56,
	0x3f, 0x48, 0x60, 0xc6, 0x20, 0xce, 0x30, 0xc9, 0x56, 0x53, 0x11, 0xbd, 0xaa, 0xc1, 0x65, 0xae,
	0x4a, 0xbb, 0xe5, 0x10, 0x64, 0x12, 0x1b, 0xb9, 0xa6, 0x4c, 0x7c, 0x53, 0x31, 0xb1, 0xcb, 0xaf,
	0xba, 0xd2, 0xff, 0xed, 0xc0, 0xd7, 0x7a, 0xb9, 0x9f, 0xfa, 0x2e, 0x49, 0x6f, 0x63, 0xb1, 0xe2,
	0xfa, 0xfb, 0xd8, 0xf4, 0x86, 0x98, 0xb9, 0xc6, 0x89, 0x14, 0xfb, 0x44, 0x76, 0x04, 0xa8, 0x31,
	0xca, 0xe7, 0x2f, 0xfe, 0x0c, 0x00, 0x00, 0xff, 0xff, 0xa4, 0x61, 0xbd, 0x57, 0xba, 0x06, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EnvironmentsClient is the client API for Environments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EnvironmentsClient interface {
	// Returns the list of all non-draft environments of the specified agent.
	ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error)
}

type environmentsClient struct {
	cc grpc.ClientConnInterface
}

func NewEnvironmentsClient(cc grpc.ClientConnInterface) EnvironmentsClient {
	return &environmentsClient{cc}
}

func (c *environmentsClient) ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error) {
	out := new(ListEnvironmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Environments/ListEnvironments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EnvironmentsServer is the server API for Environments service.
type EnvironmentsServer interface {
	// Returns the list of all non-draft environments of the specified agent.
	ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error)
}

// UnimplementedEnvironmentsServer can be embedded to have forward compatible implementations.
type UnimplementedEnvironmentsServer struct {
}

func (*UnimplementedEnvironmentsServer) ListEnvironments(ctx context.Context, req *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnvironments not implemented")
}

func RegisterEnvironmentsServer(s *grpc.Server, srv EnvironmentsServer) {
	s.RegisterService(&_Environments_serviceDesc, srv)
}

func _Environments_ListEnvironments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEnvironmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Environments/ListEnvironments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, req.(*ListEnvironmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Environments_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Environments",
	HandlerType: (*EnvironmentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEnvironments",
			Handler:    _Environments_ListEnvironments_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/environment.proto",
}
