// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/secrets/v1beta1/service.proto

package secretmanager

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [SecretManagerService.ListSecrets][google.cloud.secrets.v1beta1.SecretManagerService.ListSecrets].
type ListSecretsRequest struct {
	// Required. The resource name of the project associated with the
	// [Secrets][google.cloud.secrets.v1beta1.Secret], in the format `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to be returned in a single page. If
	// set to 0, the server decides the number of results to return. If the
	// number is greater than 25000, it is capped at 25000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Pagination token, returned earlier via
	// [ListSecretsResponse.next_page_token][google.cloud.secrets.v1beta1.ListSecretsResponse.next_page_token].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSecretsRequest) Reset()         { *m = ListSecretsRequest{} }
func (m *ListSecretsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSecretsRequest) ProtoMessage()    {}
func (*ListSecretsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{0}
}

func (m *ListSecretsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSecretsRequest.Unmarshal(m, b)
}
func (m *ListSecretsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSecretsRequest.Marshal(b, m, deterministic)
}
func (m *ListSecretsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSecretsRequest.Merge(m, src)
}
func (m *ListSecretsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSecretsRequest.Size(m)
}
func (m *ListSecretsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSecretsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSecretsRequest proto.InternalMessageInfo

func (m *ListSecretsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSecretsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSecretsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [SecretManagerService.ListSecrets][google.cloud.secrets.v1beta1.SecretManagerService.ListSecrets].
type ListSecretsResponse struct {
	// The list of [Secrets][google.cloud.secrets.v1beta1.Secret] sorted in reverse by create_time (newest
	// first).
	Secrets []*Secret `protobuf:"bytes,1,rep,name=secrets,proto3" json:"secrets,omitempty"`
	// A token to retrieve the next page of results. Pass this value in
	// [ListSecretsRequest.page_token][google.cloud.secrets.v1beta1.ListSecretsRequest.page_token] to retrieve the next page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [Secrets][google.cloud.secrets.v1beta1.Secret].
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSecretsResponse) Reset()         { *m = ListSecretsResponse{} }
func (m *ListSecretsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSecretsResponse) ProtoMessage()    {}
func (*ListSecretsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{1}
}

func (m *ListSecretsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSecretsResponse.Unmarshal(m, b)
}
func (m *ListSecretsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSecretsResponse.Marshal(b, m, deterministic)
}
func (m *ListSecretsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSecretsResponse.Merge(m, src)
}
func (m *ListSecretsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSecretsResponse.Size(m)
}
func (m *ListSecretsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSecretsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSecretsResponse proto.InternalMessageInfo

func (m *ListSecretsResponse) GetSecrets() []*Secret {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *ListSecretsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListSecretsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for [SecretManagerService.CreateSecret][google.cloud.secrets.v1beta1.SecretManagerService.CreateSecret].
type CreateSecretRequest struct {
	// Required. The resource name of the project to associate with the
	// [Secret][google.cloud.secrets.v1beta1.Secret], in the format `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. This must be unique within the project.
	//
	// A secret ID is a string with a maximum length of 255 characters and can
	// contain uppercase and lowercase letters, numerals, and the hyphen (`-`) and
	// underscore (`_`) characters.
	SecretId string `protobuf:"bytes,2,opt,name=secret_id,json=secretId,proto3" json:"secret_id,omitempty"`
	// Required. A [Secret][google.cloud.secrets.v1beta1.Secret] with initial field values.
	Secret               *Secret  `protobuf:"bytes,3,opt,name=secret,proto3" json:"secret,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSecretRequest) Reset()         { *m = CreateSecretRequest{} }
func (m *CreateSecretRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSecretRequest) ProtoMessage()    {}
func (*CreateSecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{2}
}

func (m *CreateSecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSecretRequest.Unmarshal(m, b)
}
func (m *CreateSecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSecretRequest.Marshal(b, m, deterministic)
}
func (m *CreateSecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSecretRequest.Merge(m, src)
}
func (m *CreateSecretRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSecretRequest.Size(m)
}
func (m *CreateSecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSecretRequest proto.InternalMessageInfo

func (m *CreateSecretRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSecretRequest) GetSecretId() string {
	if m != nil {
		return m.SecretId
	}
	return ""
}

func (m *CreateSecretRequest) GetSecret() *Secret {
	if m != nil {
		return m.Secret
	}
	return nil
}

// Request message for [SecretManagerService.AddSecretVersion][google.cloud.secrets.v1beta1.SecretManagerService.AddSecretVersion].
type AddSecretVersionRequest struct {
	// Required. The resource name of the [Secret][google.cloud.secrets.v1beta1.Secret] to associate with the
	// [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] in the format `projects/*/secrets/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The secret payload of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	Payload              *SecretPayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *AddSecretVersionRequest) Reset()         { *m = AddSecretVersionRequest{} }
func (m *AddSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*AddSecretVersionRequest) ProtoMessage()    {}
func (*AddSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{3}
}

func (m *AddSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddSecretVersionRequest.Unmarshal(m, b)
}
func (m *AddSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *AddSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSecretVersionRequest.Merge(m, src)
}
func (m *AddSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_AddSecretVersionRequest.Size(m)
}
func (m *AddSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddSecretVersionRequest proto.InternalMessageInfo

func (m *AddSecretVersionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *AddSecretVersionRequest) GetPayload() *SecretPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Request message for [SecretManagerService.GetSecret][google.cloud.secrets.v1beta1.SecretManagerService.GetSecret].
type GetSecretRequest struct {
	// Required. The resource name of the [Secret][google.cloud.secrets.v1beta1.Secret], in the format `projects/*/secrets/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSecretRequest) Reset()         { *m = GetSecretRequest{} }
func (m *GetSecretRequest) String() string { return proto.CompactTextString(m) }
func (*GetSecretRequest) ProtoMessage()    {}
func (*GetSecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{4}
}

func (m *GetSecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSecretRequest.Unmarshal(m, b)
}
func (m *GetSecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSecretRequest.Marshal(b, m, deterministic)
}
func (m *GetSecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSecretRequest.Merge(m, src)
}
func (m *GetSecretRequest) XXX_Size() int {
	return xxx_messageInfo_GetSecretRequest.Size(m)
}
func (m *GetSecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSecretRequest proto.InternalMessageInfo

func (m *GetSecretRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.ListSecretVersions][google.cloud.secrets.v1beta1.SecretManagerService.ListSecretVersions].
type ListSecretVersionsRequest struct {
	// Required. The resource name of the [Secret][google.cloud.secrets.v1beta1.Secret] associated with the
	// [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion] to list, in the format
	// `projects/*/secrets/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to be returned in a single page. If
	// set to 0, the server decides the number of results to return. If the
	// number is greater than 25000, it is capped at 25000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Pagination token, returned earlier via
	// ListSecretVersionsResponse.next_page_token][].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSecretVersionsRequest) Reset()         { *m = ListSecretVersionsRequest{} }
func (m *ListSecretVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSecretVersionsRequest) ProtoMessage()    {}
func (*ListSecretVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{5}
}

func (m *ListSecretVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSecretVersionsRequest.Unmarshal(m, b)
}
func (m *ListSecretVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSecretVersionsRequest.Marshal(b, m, deterministic)
}
func (m *ListSecretVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSecretVersionsRequest.Merge(m, src)
}
func (m *ListSecretVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSecretVersionsRequest.Size(m)
}
func (m *ListSecretVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSecretVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSecretVersionsRequest proto.InternalMessageInfo

func (m *ListSecretVersionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSecretVersionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSecretVersionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [SecretManagerService.ListSecretVersions][google.cloud.secrets.v1beta1.SecretManagerService.ListSecretVersions].
type ListSecretVersionsResponse struct {
	// The list of [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion] sorted in reverse by
	// create_time (newest first).
	Versions []*SecretVersion `protobuf:"bytes,1,rep,name=versions,proto3" json:"versions,omitempty"`
	// A token to retrieve the next page of results. Pass this value in
	// [ListSecretVersionsRequest.page_token][google.cloud.secrets.v1beta1.ListSecretVersionsRequest.page_token] to retrieve the next page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion].
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSecretVersionsResponse) Reset()         { *m = ListSecretVersionsResponse{} }
func (m *ListSecretVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSecretVersionsResponse) ProtoMessage()    {}
func (*ListSecretVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{6}
}

func (m *ListSecretVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSecretVersionsResponse.Unmarshal(m, b)
}
func (m *ListSecretVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSecretVersionsResponse.Marshal(b, m, deterministic)
}
func (m *ListSecretVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSecretVersionsResponse.Merge(m, src)
}
func (m *ListSecretVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSecretVersionsResponse.Size(m)
}
func (m *ListSecretVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSecretVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSecretVersionsResponse proto.InternalMessageInfo

func (m *ListSecretVersionsResponse) GetVersions() []*SecretVersion {
	if m != nil {
		return m.Versions
	}
	return nil
}

func (m *ListSecretVersionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListSecretVersionsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for [SecretManagerService.GetSecretVersion][google.cloud.secrets.v1beta1.SecretManagerService.GetSecretVersion].
type GetSecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] in the format
	// `projects/*/secrets/*/versions/*`.
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSecretVersionRequest) Reset()         { *m = GetSecretVersionRequest{} }
func (m *GetSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*GetSecretVersionRequest) ProtoMessage()    {}
func (*GetSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{7}
}

func (m *GetSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSecretVersionRequest.Unmarshal(m, b)
}
func (m *GetSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *GetSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSecretVersionRequest.Merge(m, src)
}
func (m *GetSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_GetSecretVersionRequest.Size(m)
}
func (m *GetSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSecretVersionRequest proto.InternalMessageInfo

func (m *GetSecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.UpdateSecret][google.cloud.secrets.v1beta1.SecretManagerService.UpdateSecret].
type UpdateSecretRequest struct {
	// Required. [Secret][google.cloud.secrets.v1beta1.Secret] with updated field values.
	Secret *Secret `protobuf:"bytes,1,opt,name=secret,proto3" json:"secret,omitempty"`
	// Required. Specifies the fields to be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSecretRequest) Reset()         { *m = UpdateSecretRequest{} }
func (m *UpdateSecretRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSecretRequest) ProtoMessage()    {}
func (*UpdateSecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{8}
}

func (m *UpdateSecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSecretRequest.Unmarshal(m, b)
}
func (m *UpdateSecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSecretRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSecretRequest.Merge(m, src)
}
func (m *UpdateSecretRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSecretRequest.Size(m)
}
func (m *UpdateSecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSecretRequest proto.InternalMessageInfo

func (m *UpdateSecretRequest) GetSecret() *Secret {
	if m != nil {
		return m.Secret
	}
	return nil
}

func (m *UpdateSecretRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [SecretManagerService.AccessSecretVersion][google.cloud.secrets.v1beta1.SecretManagerService.AccessSecretVersion].
type AccessSecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] in the format
	// `projects/*/secrets/*/versions/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccessSecretVersionRequest) Reset()         { *m = AccessSecretVersionRequest{} }
func (m *AccessSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*AccessSecretVersionRequest) ProtoMessage()    {}
func (*AccessSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{9}
}

func (m *AccessSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccessSecretVersionRequest.Unmarshal(m, b)
}
func (m *AccessSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccessSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *AccessSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessSecretVersionRequest.Merge(m, src)
}
func (m *AccessSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_AccessSecretVersionRequest.Size(m)
}
func (m *AccessSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AccessSecretVersionRequest proto.InternalMessageInfo

func (m *AccessSecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for [SecretManagerService.AccessSecretVersion][google.cloud.secrets.v1beta1.SecretManagerService.AccessSecretVersion].
type AccessSecretVersionResponse struct {
	// The resource name of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] in the format
	// `projects/*/secrets/*/versions/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Secret payload
	Payload              *SecretPayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *AccessSecretVersionResponse) Reset()         { *m = AccessSecretVersionResponse{} }
func (m *AccessSecretVersionResponse) String() string { return proto.CompactTextString(m) }
func (*AccessSecretVersionResponse) ProtoMessage()    {}
func (*AccessSecretVersionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{10}
}

func (m *AccessSecretVersionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccessSecretVersionResponse.Unmarshal(m, b)
}
func (m *AccessSecretVersionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccessSecretVersionResponse.Marshal(b, m, deterministic)
}
func (m *AccessSecretVersionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessSecretVersionResponse.Merge(m, src)
}
func (m *AccessSecretVersionResponse) XXX_Size() int {
	return xxx_messageInfo_AccessSecretVersionResponse.Size(m)
}
func (m *AccessSecretVersionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessSecretVersionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AccessSecretVersionResponse proto.InternalMessageInfo

func (m *AccessSecretVersionResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AccessSecretVersionResponse) GetPayload() *SecretPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Request message for [SecretManagerService.DeleteSecret][google.cloud.secrets.v1beta1.SecretManagerService.DeleteSecret].
type DeleteSecretRequest struct {
	// Required. The resource name of the [Secret][google.cloud.secrets.v1beta1.Secret] to delete in the format
	// `projects/*/secrets/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSecretRequest) Reset()         { *m = DeleteSecretRequest{} }
func (m *DeleteSecretRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSecretRequest) ProtoMessage()    {}
func (*DeleteSecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{11}
}

func (m *DeleteSecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSecretRequest.Unmarshal(m, b)
}
func (m *DeleteSecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSecretRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSecretRequest.Merge(m, src)
}
func (m *DeleteSecretRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSecretRequest.Size(m)
}
func (m *DeleteSecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSecretRequest proto.InternalMessageInfo

func (m *DeleteSecretRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.DisableSecretVersion][google.cloud.secrets.v1beta1.SecretManagerService.DisableSecretVersion].
type DisableSecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to disable in the format
	// `projects/*/secrets/*/versions/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisableSecretVersionRequest) Reset()         { *m = DisableSecretVersionRequest{} }
func (m *DisableSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*DisableSecretVersionRequest) ProtoMessage()    {}
func (*DisableSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{12}
}

func (m *DisableSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisableSecretVersionRequest.Unmarshal(m, b)
}
func (m *DisableSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisableSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *DisableSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisableSecretVersionRequest.Merge(m, src)
}
func (m *DisableSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_DisableSecretVersionRequest.Size(m)
}
func (m *DisableSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DisableSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DisableSecretVersionRequest proto.InternalMessageInfo

func (m *DisableSecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.EnableSecretVersion][google.cloud.secrets.v1beta1.SecretManagerService.EnableSecretVersion].
type EnableSecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to enable in the format
	// `projects/*/secrets/*/versions/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnableSecretVersionRequest) Reset()         { *m = EnableSecretVersionRequest{} }
func (m *EnableSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*EnableSecretVersionRequest) ProtoMessage()    {}
func (*EnableSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{13}
}

func (m *EnableSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnableSecretVersionRequest.Unmarshal(m, b)
}
func (m *EnableSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnableSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *EnableSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnableSecretVersionRequest.Merge(m, src)
}
func (m *EnableSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_EnableSecretVersionRequest.Size(m)
}
func (m *EnableSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EnableSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EnableSecretVersionRequest proto.InternalMessageInfo

func (m *EnableSecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.DestroySecretVersion][google.cloud.secrets.v1beta1.SecretManagerService.DestroySecretVersion].
type DestroySecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to destroy in the format
	// `projects/*/secrets/*/versions/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DestroySecretVersionRequest) Reset()         { *m = DestroySecretVersionRequest{} }
func (m *DestroySecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*DestroySecretVersionRequest) ProtoMessage()    {}
func (*DestroySecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a0e1a61a378c59, []int{14}
}

func (m *DestroySecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DestroySecretVersionRequest.Unmarshal(m, b)
}
func (m *DestroySecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DestroySecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *DestroySecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DestroySecretVersionRequest.Merge(m, src)
}
func (m *DestroySecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_DestroySecretVersionRequest.Size(m)
}
func (m *DestroySecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DestroySecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DestroySecretVersionRequest proto.InternalMessageInfo

func (m *DestroySecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*ListSecretsRequest)(nil), "google.cloud.secrets.v1beta1.ListSecretsRequest")
	proto.RegisterType((*ListSecretsResponse)(nil), "google.cloud.secrets.v1beta1.ListSecretsResponse")
	proto.RegisterType((*CreateSecretRequest)(nil), "google.cloud.secrets.v1beta1.CreateSecretRequest")
	proto.RegisterType((*AddSecretVersionRequest)(nil), "google.cloud.secrets.v1beta1.AddSecretVersionRequest")
	proto.RegisterType((*GetSecretRequest)(nil), "google.cloud.secrets.v1beta1.GetSecretRequest")
	proto.RegisterType((*ListSecretVersionsRequest)(nil), "google.cloud.secrets.v1beta1.ListSecretVersionsRequest")
	proto.RegisterType((*ListSecretVersionsResponse)(nil), "google.cloud.secrets.v1beta1.ListSecretVersionsResponse")
	proto.RegisterType((*GetSecretVersionRequest)(nil), "google.cloud.secrets.v1beta1.GetSecretVersionRequest")
	proto.RegisterType((*UpdateSecretRequest)(nil), "google.cloud.secrets.v1beta1.UpdateSecretRequest")
	proto.RegisterType((*AccessSecretVersionRequest)(nil), "google.cloud.secrets.v1beta1.AccessSecretVersionRequest")
	proto.RegisterType((*AccessSecretVersionResponse)(nil), "google.cloud.secrets.v1beta1.AccessSecretVersionResponse")
	proto.RegisterType((*DeleteSecretRequest)(nil), "google.cloud.secrets.v1beta1.DeleteSecretRequest")
	proto.RegisterType((*DisableSecretVersionRequest)(nil), "google.cloud.secrets.v1beta1.DisableSecretVersionRequest")
	proto.RegisterType((*EnableSecretVersionRequest)(nil), "google.cloud.secrets.v1beta1.EnableSecretVersionRequest")
	proto.RegisterType((*DestroySecretVersionRequest)(nil), "google.cloud.secrets.v1beta1.DestroySecretVersionRequest")
}

func init() {
	proto.RegisterFile("google/cloud/secrets/v1beta1/service.proto", fileDescriptor_67a0e1a61a378c59)
}

var fileDescriptor_67a0e1a61a378c59 = []byte{
	// 1368 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xcb, 0x6f, 0x1b, 0xc5,
	0x1f, 0xd7, 0x38, 0xbf, 0x3e, 0x32, 0xf1, 0x0f, 0xaa, 0x71, 0x69, 0xd2, 0x6d, 0x81, 0x68, 0x69,
	0xab, 0xe0, 0xa4, 0xbb, 0x38, 0x55, 0xda, 0xb2, 0xa5, 0x25, 0x9b, 0x34, 0x35, 0x05, 0x02, 0x96,
	0x5d, 0x72, 0x40, 0x95, 0xa2, 0x89, 0x77, 0xea, 0x2e, 0xb5, 0x77, 0x97, 0x9d, 0xb1, 0x4b, 0x8b,
	0x7a, 0x01, 0x0e, 0x48, 0x48, 0x5c, 0x90, 0x38, 0x20, 0x4e, 0x1c, 0x40, 0xad, 0xb8, 0x70, 0x01,
	0xf1, 0x07, 0x00, 0xa2, 0x37, 0xe0, 0x96, 0x53, 0x0f, 0x9c, 0xf8, 0x0b, 0x10, 0x27, 0xb4, 0xf3,
	0xb0, 0x77, 0xfd, 0x5c, 0xa7, 0x09, 0xa7, 0x38, 0xf3, 0x7d, 0x7d, 0xbe, 0xef, 0xaf, 0x0d, 0xf3,
	0x35, 0xdf, 0xaf, 0xd5, 0x89, 0x59, 0xad, 0xfb, 0x4d, 0xc7, 0xa4, 0xa4, 0x1a, 0x12, 0x46, 0xcd,
	0x56, 0x61, 0x8b, 0x30, 0x5c, 0x30, 0x29, 0x09, 0x5b, 0x6e, 0x95, 0x18, 0x41, 0xe8, 0x33, 0x1f,
	0x1d, 0x17, 0xbc, 0x06, 0xe7, 0x35, 0x24, 0xaf, 0x21, 0x79, 0x35, 0x49, 0x35, 0x71, 0xe0, 0x9a,
	0xd8, 0xf3, 0x7c, 0x86, 0x99, 0xeb, 0x7b, 0x54, 0xc8, 0x6a, 0xd3, 0x31, 0x6a, 0xb5, 0xee, 0x12,
	0x8f, 0x49, 0xc2, 0xb3, 0x31, 0xc2, 0x0d, 0x97, 0xd4, 0x9d, 0xcd, 0x2d, 0x72, 0x13, 0xb7, 0x5c,
	0x3f, 0x94, 0x0c, 0x47, 0x63, 0x0c, 0x21, 0xa1, 0x7e, 0x33, 0x54, 0x80, 0xb4, 0x85, 0xa1, 0xe0,
	0x15, 0xb3, 0x82, 0xf0, 0x8c, 0xe4, 0x76, 0x71, 0xc3, 0x6c, 0x15, 0xa2, 0x3f, 0x9b, 0x81, 0x5f,
	0x77, 0xab, 0x77, 0x24, 0x5d, 0x4b, 0xd2, 0x13, 0xb4, 0x63, 0x92, 0xc6, 0xff, 0xdb, 0x6a, 0xde,
	0x30, 0x49, 0x23, 0x60, 0x8a, 0x38, 0xdb, 0x4d, 0x14, 0x7e, 0x34, 0x30, 0xbd, 0x25, 0x38, 0xf4,
	0x6f, 0x00, 0x44, 0xaf, 0xbb, 0x94, 0x55, 0x04, 0xc4, 0x32, 0x79, 0xb7, 0x49, 0x28, 0x43, 0xaf,
	0xc1, 0xfd, 0x01, 0x0e, 0x89, 0xc7, 0x66, 0xc0, 0x2c, 0x98, 0x9b, 0x5c, 0x39, 0xf3, 0xc8, 0xce,
	0xfc, 0x63, 0x9f, 0x86, 0xf3, 0xdc, 0x21, 0x85, 0xbf, 0x81, 0x3d, 0x5c, 0x23, 0xa1, 0x21, 0xac,
	0xe0, 0xc0, 0xa5, 0x46, 0xd5, 0x6f, 0x98, 0xa5, 0xd0, 0x7f, 0x87, 0x54, 0x59, 0x59, 0xaa, 0x40,
	0xb3, 0x70, 0x32, 0xc0, 0x35, 0xb2, 0x49, 0xdd, 0xbb, 0x64, 0x26, 0x33, 0x0b, 0xe6, 0xf6, 0xad,
	0x4c, 0x3c, 0xb2, 0x41, 0xf9, 0x60, 0xf4, 0x5a, 0x71, 0xef, 0x12, 0xa4, 0x43, 0xc8, 0x39, 0x98,
	0x7f, 0x8b, 0x78, 0x33, 0x13, 0xdc, 0x24, 0x67, 0xe1, 0x82, 0xd7, 0xa2, 0x57, 0xfd, 0x4b, 0x00,
	0x73, 0x09, 0xa4, 0x34, 0xf0, 0x3d, 0x4a, 0xd0, 0x25, 0x78, 0x40, 0xc6, 0x77, 0x06, 0xcc, 0x4e,
	0xcc, 0x4d, 0x2d, 0x9e, 0x30, 0x86, 0x55, 0x83, 0x21, 0xe4, 0xcb, 0x4a, 0x08, 0x9d, 0x82, 0x4f,
	0x7a, 0xe4, 0x3d, 0xb6, 0x19, 0x03, 0x10, 0x61, 0x9c, 0x2c, 0xff, 0x3f, 0x7a, 0x2e, 0x29, 0xfb,
	0xe8, 0x69, 0x08, 0x99, 0xcf, 0x70, 0x5d, 0xb8, 0x11, 0x61, 0xdc, 0x57, 0x9e, 0xe4, 0x2f, 0x91,
	0x0b, 0xfa, 0x2f, 0x00, 0xe6, 0x56, 0x43, 0x82, 0x19, 0x91, 0x06, 0xf6, 0x28, 0x92, 0x02, 0xf6,
	0xa6, 0xeb, 0x08, 0x94, 0x51, 0x98, 0x32, 0xe5, 0x83, 0xe2, 0xf5, 0xaa, 0x83, 0x6c, 0xb8, 0x5f,
	0x7c, 0xe6, 0x08, 0x53, 0x06, 0x43, 0x28, 0x91, 0x82, 0xfa, 0x03, 0x00, 0xa7, 0x6d, 0xc7, 0x11,
	0xa4, 0x0d, 0x12, 0x52, 0xd7, 0xf7, 0x94, 0x37, 0xab, 0x5d, 0xde, 0xcc, 0x73, 0x6f, 0x4e, 0xc2,
	0xe7, 0x84, 0xec, 0x00, 0x37, 0x64, 0x44, 0x94, 0x17, 0xaf, 0xc2, 0x03, 0x01, 0xbe, 0x53, 0xf7,
	0xb1, 0xf0, 0x61, 0x6a, 0x71, 0x3e, 0x0d, 0xc8, 0x92, 0x10, 0x11, 0x58, 0x95, 0x02, 0xbd, 0x02,
	0x0f, 0x15, 0x09, 0x4b, 0x86, 0xfc, 0x65, 0xf8, 0x3f, 0x0f, 0x37, 0xc8, 0x4e, 0x20, 0x72, 0x41,
	0xfd, 0x6b, 0x00, 0x8f, 0x76, 0x4a, 0x4d, 0x86, 0x80, 0xee, 0x6a, 0x0c, 0x76, 0xa7, 0x27, 0xbe,
	0x05, 0x50, 0xeb, 0x07, 0x54, 0xb6, 0x46, 0x11, 0x1e, 0x6c, 0xc9, 0x37, 0xd9, 0x1b, 0xa9, 0x22,
	0xad, 0x72, 0xde, 0x16, 0xde, 0xad, 0x1e, 0xc1, 0x70, 0xba, 0x9d, 0xac, 0xae, 0xc2, 0xba, 0x92,
	0xc8, 0xd9, 0x22, 0x0f, 0xe9, 0x02, 0xcc, 0xa7, 0x08, 0xa9, 0x52, 0x24, 0x52, 0xf7, 0x05, 0x80,
	0xb9, 0xb7, 0x02, 0xa7, 0xa7, 0x0d, 0x3b, 0x7d, 0x01, 0x76, 0xd8, 0x17, 0x68, 0x19, 0x4e, 0x35,
	0xb9, 0x66, 0x3e, 0x3f, 0x65, 0xe9, 0x6a, 0x4a, 0x8f, 0x1a, 0xb1, 0xc6, 0x95, 0x68, 0xc4, 0xae,
	0x63, 0x7a, 0x4b, 0x48, 0x43, 0x21, 0x13, 0x3d, 0xe8, 0x0e, 0xd4, 0xec, 0x6a, 0x95, 0x50, 0xba,
	0xa7, 0x21, 0xb8, 0x0f, 0xe0, 0xb1, 0xbe, 0x66, 0x64, 0x55, 0xac, 0x26, 0xec, 0x98, 0x3b, 0x32,
	0x82, 0xd6, 0x1e, 0xa7, 0x87, 0x3b, 0xed, 0xbb, 0x01, 0x73, 0x97, 0x49, 0x9d, 0x74, 0x67, 0xeb,
	0xb1, 0x3b, 0x98, 0xc0, 0x63, 0x97, 0x5d, 0x8a, 0xb7, 0xea, 0x64, 0x4f, 0x43, 0xed, 0x40, 0x6d,
	0xcd, 0xdb, 0x73, 0x2b, 0x91, 0x33, 0x84, 0xb2, 0xd0, 0xbf, 0xb3, 0x97, 0x66, 0x16, 0x3f, 0x3c,
	0x02, 0x0f, 0x8b, 0xf7, 0x75, 0x21, 0x54, 0x11, 0x37, 0x16, 0xba, 0x0f, 0xe0, 0x54, 0x6c, 0xf3,
	0xa2, 0x17, 0x86, 0xa7, 0xba, 0xf7, 0x9c, 0xd0, 0x0a, 0x63, 0x48, 0x88, 0x2a, 0xd5, 0x97, 0xb6,
	0x6d, 0x39, 0x2b, 0x3f, 0xf8, 0xe3, 0xcf, 0xcf, 0x32, 0xa7, 0xd0, 0x89, 0xf6, 0xf9, 0xf4, 0xbe,
	0x78, 0xbf, 0x18, 0x88, 0xed, 0x48, 0xcd, 0xfc, 0x3d, 0x75, 0x62, 0xa1, 0x1f, 0x00, 0xcc, 0xc6,
	0xd7, 0x30, 0x1a, 0x61, 0xba, 0xcf, 0xca, 0xd6, 0x52, 0xcd, 0x06, 0xfd, 0x8d, 0x6d, 0x7b, 0x5a,
	0x00, 0x59, 0x68, 0xef, 0x64, 0xf9, 0x89, 0x23, 0x36, 0xf4, 0x54, 0x88, 0x2d, 0x35, 0x5e, 0x7e,
	0x02, 0xf0, 0x50, 0xf7, 0xda, 0x45, 0x4b, 0xc3, 0xa1, 0x0c, 0x58, 0xd3, 0xda, 0x38, 0x63, 0x5e,
	0x5f, 0xdf, 0xb6, 0x9f, 0x90, 0x8e, 0xc8, 0xb6, 0xe4, 0xf8, 0xcf, 0xea, 0x85, 0x21, 0xf8, 0xdb,
	0x37, 0x6d, 0xfe, 0x9e, 0x85, 0x1d, 0x47, 0xea, 0xb2, 0x40, 0x1e, 0x7d, 0x0e, 0xe0, 0x64, 0x7b,
	0xca, 0x23, 0x63, 0x38, 0x92, 0xee, 0xdd, 0x9d, 0x32, 0xf6, 0x67, 0xb6, 0x6d, 0x5e, 0xb3, 0xbd,
	0xa5, 0x11, 0xbd, 0xf6, 0x87, 0x89, 0x7e, 0x04, 0x30, 0x1b, 0x5f, 0x0d, 0xa3, 0x4a, 0xa3, 0xcf,
	0x1a, 0x49, 0x09, 0xaf, 0xb4, 0x6d, 0x23, 0x41, 0x5a, 0x88, 0x6d, 0x0c, 0x0e, 0x76, 0x69, 0x71,
	0xbe, 0x03, 0x56, 0xf0, 0x18, 0x83, 0x31, 0xb7, 0x8b, 0xe3, 0x53, 0x00, 0xb3, 0xf1, 0x41, 0x39,
	0x0a, 0x7b, 0x9f, 0xa1, 0xaa, 0x1d, 0xe9, 0x59, 0x55, 0x6b, 0xd1, 0x57, 0x85, 0xae, 0x60, 0xe6,
	0xd3, 0x05, 0xf3, 0xd7, 0xc4, 0xf7, 0x06, 0x75, 0x79, 0xa0, 0x73, 0x69, 0x1b, 0xbd, 0xeb, 0xa8,
	0xd2, 0xce, 0x8f, 0x2f, 0x28, 0x07, 0xc5, 0x72, 0x72, 0x50, 0x14, 0x90, 0x99, 0xae, 0x6c, 0xcd,
	0xf6, 0x75, 0xf3, 0x3d, 0x88, 0x1d, 0x91, 0x29, 0x3b, 0x6f, 0xc0, 0x1d, 0x33, 0x5e, 0xe7, 0x5d,
	0x8a, 0x47, 0x3e, 0x01, 0x7c, 0x60, 0xe4, 0xdb, 0xa8, 0xa3, 0x24, 0xfc, 0x06, 0x60, 0xae, 0xcf,
	0xa6, 0x47, 0x23, 0x82, 0x39, 0xf8, 0x06, 0xd1, 0x5e, 0xdc, 0x81, 0xa4, 0xcc, 0xc3, 0x5a, 0xdc,
	0x99, 0xf3, 0xe8, 0xec, 0x98, 0xce, 0x58, 0x98, 0xeb, 0x8e, 0x0a, 0xeb, 0x70, 0xbf, 0xd5, 0x8d,
	0x46, 0x40, 0x1b, 0xb2, 0xee, 0xc7, 0x4b, 0xca, 0xd5, 0xb8, 0x1f, 0x2f, 0xe9, 0xe7, 0xc6, 0xf5,
	0xc3, 0x11, 0x40, 0xa2, 0x51, 0xf8, 0x33, 0x80, 0xb9, 0x3e, 0xf7, 0xc1, 0xa8, 0xfc, 0x0c, 0x3e,
	0x29, 0xc6, 0xf3, 0xe4, 0x95, 0xb8, 0x27, 0x17, 0xf4, 0xb1, 0x33, 0x42, 0x3c, 0xe5, 0x08, 0x4f,
	0x4a, 0x9f, 0x13, 0x64, 0x64, 0x52, 0x06, 0x9f, 0x2d, 0xff, 0x71, 0x52, 0x04, 0x90, 0xc8, 0x97,
	0x4f, 0x00, 0xcc, 0x56, 0x08, 0xbb, 0x8a, 0x1b, 0x25, 0xfe, 0x3b, 0x0a, 0xd2, 0x15, 0x10, 0x17,
	0x37, 0x8c, 0x56, 0x64, 0xb9, 0x43, 0x54, 0x60, 0x9f, 0xea, 0xe2, 0x11, 0x54, 0x7d, 0x99, 0xe3,
	0xb1, 0xf4, 0xa5, 0x0e, 0x1e, 0xf5, 0x8d, 0x7e, 0xc0, 0x40, 0xa7, 0x31, 0xe5, 0x11, 0x9a, 0x8f,
	0x01, 0xcc, 0x16, 0x87, 0xa1, 0x29, 0xa6, 0x47, 0x73, 0x91, 0xa3, 0x39, 0x87, 0xd2, 0xa3, 0xa9,
	0xc5, 0x2d, 0x7f, 0x07, 0x20, 0xba, 0x46, 0x28, 0x7f, 0x21, 0x61, 0xc3, 0xa5, 0x62, 0x3a, 0xce,
	0x75, 0x19, 0xeb, 0x65, 0x51, 0xb0, 0x9e, 0x4f, 0xc1, 0x29, 0x87, 0xc5, 0x15, 0x0e, 0x75, 0x59,
	0xbf, 0x90, 0x1a, 0x2a, 0xeb, 0x51, 0x66, 0x81, 0xbc, 0x56, 0x7a, 0x68, 0x1f, 0x1f, 0x76, 0xe8,
	0xfe, 0x6e, 0x1b, 0x37, 0x19, 0x0b, 0xa8, 0x65, 0x9a, 0xb7, 0x6f, 0xdf, 0xee, 0xbe, 0x82, 0x71,
	0x93, 0xdd, 0x14, 0x3f, 0xd1, 0x9d, 0x0e, 0xea, 0x98, 0xdd, 0xf0, 0xc3, 0xc6, 0xca, 0x47, 0x19,
	0x78, 0xaa, 0xea, 0x37, 0xfa, 0x15, 0xa7, 0x32, 0x21, 0x21, 0xaf, 0x64, 0xe5, 0x81, 0x5c, 0x8a,
	0xf6, 0x69, 0x09, 0xbc, 0xfd, 0xa6, 0x94, 0xa9, 0xf9, 0x75, 0xec, 0xd5, 0x0c, 0x3f, 0xac, 0x99,
	0x35, 0xe2, 0xf1, 0x6d, 0x6b, 0x76, 0x2c, 0x27, 0x7e, 0x13, 0x94, 0x2a, 0x55, 0x14, 0x2e, 0x24,
	0x5e, 0xff, 0x06, 0xe0, 0xab, 0xcc, 0x44, 0xb1, 0xb2, 0xfe, 0x20, 0xa3, 0x17, 0x85, 0xea, 0x55,
	0x0e, 0x27, 0x71, 0xa5, 0x1b, 0x1b, 0x85, 0x95, 0x48, 0xf6, 0xa1, 0x62, 0xba, 0xce, 0x99, 0xae,
	0x27, 0x98, 0xae, 0x6f, 0x08, 0x03, 0x7f, 0x65, 0x4e, 0x0a, 0x26, 0xcb, 0xe2, 0x5c, 0x96, 0x95,
	0x60, 0xb3, 0x2c, 0xc9, 0xb7, 0xb5, 0x9f, 0xc3, 0x3e, 0xf3, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xe4, 0x02, 0xde, 0x1a, 0x86, 0x15, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SecretManagerServiceClient is the client API for SecretManagerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecretManagerServiceClient interface {
	// Lists [Secrets][google.cloud.secrets.v1beta1.Secret].
	ListSecrets(ctx context.Context, in *ListSecretsRequest, opts ...grpc.CallOption) (*ListSecretsResponse, error)
	// Creates a new [Secret][google.cloud.secrets.v1beta1.Secret] containing no [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion].
	CreateSecret(ctx context.Context, in *CreateSecretRequest, opts ...grpc.CallOption) (*Secret, error)
	// Creates a new [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] containing secret data and attaches
	// it to an existing [Secret][google.cloud.secrets.v1beta1.Secret].
	AddSecretVersion(ctx context.Context, in *AddSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Gets metadata for a given [Secret][google.cloud.secrets.v1beta1.Secret].
	GetSecret(ctx context.Context, in *GetSecretRequest, opts ...grpc.CallOption) (*Secret, error)
	// Updates metadata of an existing [Secret][google.cloud.secrets.v1beta1.Secret].
	UpdateSecret(ctx context.Context, in *UpdateSecretRequest, opts ...grpc.CallOption) (*Secret, error)
	// Deletes a [Secret][google.cloud.secrets.v1beta1.Secret].
	DeleteSecret(ctx context.Context, in *DeleteSecretRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion]. This call does not return secret
	// data.
	ListSecretVersions(ctx context.Context, in *ListSecretVersionsRequest, opts ...grpc.CallOption) (*ListSecretVersionsResponse, error)
	// Gets metadata for a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	//
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	GetSecretVersion(ctx context.Context, in *GetSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Accesses a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion]. This call returns the secret data.
	//
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	AccessSecretVersion(ctx context.Context, in *AccessSecretVersionRequest, opts ...grpc.CallOption) (*AccessSecretVersionResponse, error)
	// Disables a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	//
	// Sets the [state][google.cloud.secrets.v1beta1.SecretVersion.state] of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to
	// [DISABLED][google.cloud.secrets.v1beta1.SecretVersion.State.DISABLED].
	DisableSecretVersion(ctx context.Context, in *DisableSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Enables a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	//
	// Sets the [state][google.cloud.secrets.v1beta1.SecretVersion.state] of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to
	// [ENABLED][google.cloud.secrets.v1beta1.SecretVersion.State.ENABLED].
	EnableSecretVersion(ctx context.Context, in *EnableSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Destroys a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	//
	// Sets the [state][google.cloud.secrets.v1beta1.SecretVersion.state] of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to
	// [DESTROYED][google.cloud.secrets.v1beta1.SecretVersion.State.DESTROYED] and irrevocably destroys the
	// secret data.
	DestroySecretVersion(ctx context.Context, in *DestroySecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Sets the access control policy on the specified secret. Replaces any
	// existing policy.
	//
	// Permissions on [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion] are enforced according
	// to the policy set on the associated [Secret][google.cloud.secrets.v1beta1.Secret].
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a secret.
	// Returns empty policy if the secret exists and does not have a policy set.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has for the specified secret.
	// If the secret does not exist, this call returns an empty set of
	// permissions, not a NOT_FOUND error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type secretManagerServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSecretManagerServiceClient(cc grpc.ClientConnInterface) SecretManagerServiceClient {
	return &secretManagerServiceClient{cc}
}

func (c *secretManagerServiceClient) ListSecrets(ctx context.Context, in *ListSecretsRequest, opts ...grpc.CallOption) (*ListSecretsResponse, error) {
	out := new(ListSecretsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/ListSecrets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) CreateSecret(ctx context.Context, in *CreateSecretRequest, opts ...grpc.CallOption) (*Secret, error) {
	out := new(Secret)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/CreateSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) AddSecretVersion(ctx context.Context, in *AddSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/AddSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) GetSecret(ctx context.Context, in *GetSecretRequest, opts ...grpc.CallOption) (*Secret, error) {
	out := new(Secret)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/GetSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) UpdateSecret(ctx context.Context, in *UpdateSecretRequest, opts ...grpc.CallOption) (*Secret, error) {
	out := new(Secret)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/UpdateSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) DeleteSecret(ctx context.Context, in *DeleteSecretRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/DeleteSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) ListSecretVersions(ctx context.Context, in *ListSecretVersionsRequest, opts ...grpc.CallOption) (*ListSecretVersionsResponse, error) {
	out := new(ListSecretVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/ListSecretVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) GetSecretVersion(ctx context.Context, in *GetSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/GetSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) AccessSecretVersion(ctx context.Context, in *AccessSecretVersionRequest, opts ...grpc.CallOption) (*AccessSecretVersionResponse, error) {
	out := new(AccessSecretVersionResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/AccessSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) DisableSecretVersion(ctx context.Context, in *DisableSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/DisableSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) EnableSecretVersion(ctx context.Context, in *EnableSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/EnableSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) DestroySecretVersion(ctx context.Context, in *DestroySecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/DestroySecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.secrets.v1beta1.SecretManagerService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecretManagerServiceServer is the server API for SecretManagerService service.
type SecretManagerServiceServer interface {
	// Lists [Secrets][google.cloud.secrets.v1beta1.Secret].
	ListSecrets(context.Context, *ListSecretsRequest) (*ListSecretsResponse, error)
	// Creates a new [Secret][google.cloud.secrets.v1beta1.Secret] containing no [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion].
	CreateSecret(context.Context, *CreateSecretRequest) (*Secret, error)
	// Creates a new [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] containing secret data and attaches
	// it to an existing [Secret][google.cloud.secrets.v1beta1.Secret].
	AddSecretVersion(context.Context, *AddSecretVersionRequest) (*SecretVersion, error)
	// Gets metadata for a given [Secret][google.cloud.secrets.v1beta1.Secret].
	GetSecret(context.Context, *GetSecretRequest) (*Secret, error)
	// Updates metadata of an existing [Secret][google.cloud.secrets.v1beta1.Secret].
	UpdateSecret(context.Context, *UpdateSecretRequest) (*Secret, error)
	// Deletes a [Secret][google.cloud.secrets.v1beta1.Secret].
	DeleteSecret(context.Context, *DeleteSecretRequest) (*empty.Empty, error)
	// Lists [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion]. This call does not return secret
	// data.
	ListSecretVersions(context.Context, *ListSecretVersionsRequest) (*ListSecretVersionsResponse, error)
	// Gets metadata for a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	//
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	GetSecretVersion(context.Context, *GetSecretVersionRequest) (*SecretVersion, error)
	// Accesses a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion]. This call returns the secret data.
	//
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	AccessSecretVersion(context.Context, *AccessSecretVersionRequest) (*AccessSecretVersionResponse, error)
	// Disables a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	//
	// Sets the [state][google.cloud.secrets.v1beta1.SecretVersion.state] of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to
	// [DISABLED][google.cloud.secrets.v1beta1.SecretVersion.State.DISABLED].
	DisableSecretVersion(context.Context, *DisableSecretVersionRequest) (*SecretVersion, error)
	// Enables a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	//
	// Sets the [state][google.cloud.secrets.v1beta1.SecretVersion.state] of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to
	// [ENABLED][google.cloud.secrets.v1beta1.SecretVersion.State.ENABLED].
	EnableSecretVersion(context.Context, *EnableSecretVersionRequest) (*SecretVersion, error)
	// Destroys a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	//
	// Sets the [state][google.cloud.secrets.v1beta1.SecretVersion.state] of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to
	// [DESTROYED][google.cloud.secrets.v1beta1.SecretVersion.State.DESTROYED] and irrevocably destroys the
	// secret data.
	DestroySecretVersion(context.Context, *DestroySecretVersionRequest) (*SecretVersion, error)
	// Sets the access control policy on the specified secret. Replaces any
	// existing policy.
	//
	// Permissions on [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion] are enforced according
	// to the policy set on the associated [Secret][google.cloud.secrets.v1beta1.Secret].
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a secret.
	// Returns empty policy if the secret exists and does not have a policy set.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has for the specified secret.
	// If the secret does not exist, this call returns an empty set of
	// permissions, not a NOT_FOUND error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedSecretManagerServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSecretManagerServiceServer struct {
}

func (*UnimplementedSecretManagerServiceServer) ListSecrets(ctx context.Context, req *ListSecretsRequest) (*ListSecretsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSecrets not implemented")
}
func (*UnimplementedSecretManagerServiceServer) CreateSecret(ctx context.Context, req *CreateSecretRequest) (*Secret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSecret not implemented")
}
func (*UnimplementedSecretManagerServiceServer) AddSecretVersion(ctx context.Context, req *AddSecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) GetSecret(ctx context.Context, req *GetSecretRequest) (*Secret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSecret not implemented")
}
func (*UnimplementedSecretManagerServiceServer) UpdateSecret(ctx context.Context, req *UpdateSecretRequest) (*Secret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecret not implemented")
}
func (*UnimplementedSecretManagerServiceServer) DeleteSecret(ctx context.Context, req *DeleteSecretRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSecret not implemented")
}
func (*UnimplementedSecretManagerServiceServer) ListSecretVersions(ctx context.Context, req *ListSecretVersionsRequest) (*ListSecretVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSecretVersions not implemented")
}
func (*UnimplementedSecretManagerServiceServer) GetSecretVersion(ctx context.Context, req *GetSecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) AccessSecretVersion(ctx context.Context, req *AccessSecretVersionRequest) (*AccessSecretVersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AccessSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) DisableSecretVersion(ctx context.Context, req *DisableSecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) EnableSecretVersion(ctx context.Context, req *EnableSecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) DestroySecretVersion(ctx context.Context, req *DestroySecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DestroySecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedSecretManagerServiceServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedSecretManagerServiceServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterSecretManagerServiceServer(s *grpc.Server, srv SecretManagerServiceServer) {
	s.RegisterService(&_SecretManagerService_serviceDesc, srv)
}

func _SecretManagerService_ListSecrets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecretsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).ListSecrets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/ListSecrets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).ListSecrets(ctx, req.(*ListSecretsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_CreateSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).CreateSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/CreateSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).CreateSecret(ctx, req.(*CreateSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_AddSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).AddSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/AddSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).AddSecretVersion(ctx, req.(*AddSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_GetSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).GetSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/GetSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).GetSecret(ctx, req.(*GetSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_UpdateSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).UpdateSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/UpdateSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).UpdateSecret(ctx, req.(*UpdateSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_DeleteSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).DeleteSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/DeleteSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).DeleteSecret(ctx, req.(*DeleteSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_ListSecretVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecretVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).ListSecretVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/ListSecretVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).ListSecretVersions(ctx, req.(*ListSecretVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_GetSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).GetSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/GetSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).GetSecretVersion(ctx, req.(*GetSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_AccessSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccessSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).AccessSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/AccessSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).AccessSecretVersion(ctx, req.(*AccessSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_DisableSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).DisableSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/DisableSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).DisableSecretVersion(ctx, req.(*DisableSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_EnableSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).EnableSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/EnableSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).EnableSecretVersion(ctx, req.(*EnableSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_DestroySecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroySecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).DestroySecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/DestroySecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).DestroySecretVersion(ctx, req.(*DestroySecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secrets.v1beta1.SecretManagerService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecretManagerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.secrets.v1beta1.SecretManagerService",
	HandlerType: (*SecretManagerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSecrets",
			Handler:    _SecretManagerService_ListSecrets_Handler,
		},
		{
			MethodName: "CreateSecret",
			Handler:    _SecretManagerService_CreateSecret_Handler,
		},
		{
			MethodName: "AddSecretVersion",
			Handler:    _SecretManagerService_AddSecretVersion_Handler,
		},
		{
			MethodName: "GetSecret",
			Handler:    _SecretManagerService_GetSecret_Handler,
		},
		{
			MethodName: "UpdateSecret",
			Handler:    _SecretManagerService_UpdateSecret_Handler,
		},
		{
			MethodName: "DeleteSecret",
			Handler:    _SecretManagerService_DeleteSecret_Handler,
		},
		{
			MethodName: "ListSecretVersions",
			Handler:    _SecretManagerService_ListSecretVersions_Handler,
		},
		{
			MethodName: "GetSecretVersion",
			Handler:    _SecretManagerService_GetSecretVersion_Handler,
		},
		{
			MethodName: "AccessSecretVersion",
			Handler:    _SecretManagerService_AccessSecretVersion_Handler,
		},
		{
			MethodName: "DisableSecretVersion",
			Handler:    _SecretManagerService_DisableSecretVersion_Handler,
		},
		{
			MethodName: "EnableSecretVersion",
			Handler:    _SecretManagerService_EnableSecretVersion_Handler,
		},
		{
			MethodName: "DestroySecretVersion",
			Handler:    _SecretManagerService_DestroySecretVersion_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SecretManagerService_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SecretManagerService_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SecretManagerService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/secrets/v1beta1/service.proto",
}
