// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/websecurityscanner/v1/finding.proto

package websecurityscanner

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The severity level of a vulnerability.
type Finding_Severity int32

const (
	// No severity specified. The default value.
	Finding_SEVERITY_UNSPECIFIED Finding_Severity = 0
	// Critical severity.
	Finding_CRITICAL Finding_Severity = 1
	// High severity.
	Finding_HIGH Finding_Severity = 2
	// Medium severity.
	Finding_MEDIUM Finding_Severity = 3
	// Low severity.
	Finding_LOW Finding_Severity = 4
)

var Finding_Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "CRITICAL",
	2: "HIGH",
	3: "MEDIUM",
	4: "LOW",
}

var Finding_Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"CRITICAL":             1,
	"HIGH":                 2,
	"MEDIUM":               3,
	"LOW":                  4,
}

func (x Finding_Severity) String() string {
	return proto.EnumName(Finding_Severity_name, int32(x))
}

func (Finding_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e0a90e5fb95d5f15, []int{0, 0}
}

// A Finding resource represents a vulnerability instance identified during a
// ScanRun.
type Finding struct {
	// Output only. The resource name of the Finding. The name follows the format of
	// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
	// The finding IDs are generated by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The type of the Finding.
	// Detailed and up-to-date information on findings can be found here:
	// https://cloud.google.com/security-command-center/docs/how-to-remediate-web-security-scanner-findings
	FindingType string `protobuf:"bytes,2,opt,name=finding_type,json=findingType,proto3" json:"finding_type,omitempty"`
	// Output only. The severity level of the reported vulnerability.
	Severity Finding_Severity `protobuf:"varint,17,opt,name=severity,proto3,enum=google.cloud.websecurityscanner.v1.Finding_Severity" json:"severity,omitempty"`
	// Output only. The http method of the request that triggered the vulnerability, in
	// uppercase.
	HttpMethod string `protobuf:"bytes,3,opt,name=http_method,json=httpMethod,proto3" json:"http_method,omitempty"`
	// Output only. The URL produced by the server-side fuzzer and used in the request that
	// triggered the vulnerability.
	FuzzedUrl string `protobuf:"bytes,4,opt,name=fuzzed_url,json=fuzzedUrl,proto3" json:"fuzzed_url,omitempty"`
	// Output only. The body of the request that triggered the vulnerability.
	Body string `protobuf:"bytes,5,opt,name=body,proto3" json:"body,omitempty"`
	// Output only. The description of the vulnerability.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The URL containing human-readable payload that user can leverage to
	// reproduce the vulnerability.
	ReproductionUrl string `protobuf:"bytes,7,opt,name=reproduction_url,json=reproductionUrl,proto3" json:"reproduction_url,omitempty"`
	// Output only. If the vulnerability was originated from nested IFrame, the immediate
	// parent IFrame is reported.
	FrameUrl string `protobuf:"bytes,8,opt,name=frame_url,json=frameUrl,proto3" json:"frame_url,omitempty"`
	// Output only. The URL where the browser lands when the vulnerability is detected.
	FinalUrl string `protobuf:"bytes,9,opt,name=final_url,json=finalUrl,proto3" json:"final_url,omitempty"`
	// Output only. The tracking ID uniquely identifies a vulnerability instance across
	// multiple ScanRuns.
	TrackingId string `protobuf:"bytes,10,opt,name=tracking_id,json=trackingId,proto3" json:"tracking_id,omitempty"`
	// Output only. An addon containing information reported for a vulnerability with an HTML
	// form, if any.
	Form *Form `protobuf:"bytes,16,opt,name=form,proto3" json:"form,omitempty"`
	// Output only. An addon containing information about outdated libraries.
	OutdatedLibrary *OutdatedLibrary `protobuf:"bytes,11,opt,name=outdated_library,json=outdatedLibrary,proto3" json:"outdated_library,omitempty"`
	// Output only. An addon containing detailed information regarding any resource causing the
	// vulnerability such as JavaScript sources, image, audio files, etc.
	ViolatingResource *ViolatingResource `protobuf:"bytes,12,opt,name=violating_resource,json=violatingResource,proto3" json:"violating_resource,omitempty"`
	// Output only. An addon containing information about vulnerable or missing HTTP headers.
	VulnerableHeaders *VulnerableHeaders `protobuf:"bytes,15,opt,name=vulnerable_headers,json=vulnerableHeaders,proto3" json:"vulnerable_headers,omitempty"`
	// Output only. An addon containing information about request parameters which were found
	// to be vulnerable.
	VulnerableParameters *VulnerableParameters `protobuf:"bytes,13,opt,name=vulnerable_parameters,json=vulnerableParameters,proto3" json:"vulnerable_parameters,omitempty"`
	// Output only. An addon containing information reported for an XSS, if any.
	Xss                  *Xss     `protobuf:"bytes,14,opt,name=xss,proto3" json:"xss,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Finding) Reset()         { *m = Finding{} }
func (m *Finding) String() string { return proto.CompactTextString(m) }
func (*Finding) ProtoMessage()    {}
func (*Finding) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0a90e5fb95d5f15, []int{0}
}

func (m *Finding) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Finding.Unmarshal(m, b)
}
func (m *Finding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Finding.Marshal(b, m, deterministic)
}
func (m *Finding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Finding.Merge(m, src)
}
func (m *Finding) XXX_Size() int {
	return xxx_messageInfo_Finding.Size(m)
}
func (m *Finding) XXX_DiscardUnknown() {
	xxx_messageInfo_Finding.DiscardUnknown(m)
}

var xxx_messageInfo_Finding proto.InternalMessageInfo

func (m *Finding) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Finding) GetFindingType() string {
	if m != nil {
		return m.FindingType
	}
	return ""
}

func (m *Finding) GetSeverity() Finding_Severity {
	if m != nil {
		return m.Severity
	}
	return Finding_SEVERITY_UNSPECIFIED
}

func (m *Finding) GetHttpMethod() string {
	if m != nil {
		return m.HttpMethod
	}
	return ""
}

func (m *Finding) GetFuzzedUrl() string {
	if m != nil {
		return m.FuzzedUrl
	}
	return ""
}

func (m *Finding) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *Finding) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Finding) GetReproductionUrl() string {
	if m != nil {
		return m.ReproductionUrl
	}
	return ""
}

func (m *Finding) GetFrameUrl() string {
	if m != nil {
		return m.FrameUrl
	}
	return ""
}

func (m *Finding) GetFinalUrl() string {
	if m != nil {
		return m.FinalUrl
	}
	return ""
}

func (m *Finding) GetTrackingId() string {
	if m != nil {
		return m.TrackingId
	}
	return ""
}

func (m *Finding) GetForm() *Form {
	if m != nil {
		return m.Form
	}
	return nil
}

func (m *Finding) GetOutdatedLibrary() *OutdatedLibrary {
	if m != nil {
		return m.OutdatedLibrary
	}
	return nil
}

func (m *Finding) GetViolatingResource() *ViolatingResource {
	if m != nil {
		return m.ViolatingResource
	}
	return nil
}

func (m *Finding) GetVulnerableHeaders() *VulnerableHeaders {
	if m != nil {
		return m.VulnerableHeaders
	}
	return nil
}

func (m *Finding) GetVulnerableParameters() *VulnerableParameters {
	if m != nil {
		return m.VulnerableParameters
	}
	return nil
}

func (m *Finding) GetXss() *Xss {
	if m != nil {
		return m.Xss
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.websecurityscanner.v1.Finding_Severity", Finding_Severity_name, Finding_Severity_value)
	proto.RegisterType((*Finding)(nil), "google.cloud.websecurityscanner.v1.Finding")
}

func init() {
	proto.RegisterFile("google/cloud/websecurityscanner/v1/finding.proto", fileDescriptor_e0a90e5fb95d5f15)
}

var fileDescriptor_e0a90e5fb95d5f15 = []byte{
	// 695 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0x4f, 0x6f, 0xd3, 0x30,
	0x18, 0xc6, 0xc9, 0x5a, 0xb6, 0xd6, 0x2d, 0x5b, 0x66, 0x0d, 0x29, 0x0c, 0xa1, 0x95, 0x1d, 0xa0,
	0xbb, 0x24, 0x6c, 0x03, 0xc4, 0xbf, 0xcb, 0xd6, 0x75, 0x2c, 0xd2, 0xc6, 0x4a, 0xda, 0x8e, 0x3f,
	0x07, 0x22, 0x37, 0x76, 0xd3, 0x40, 0x12, 0x47, 0x76, 0x12, 0xe8, 0xa6, 0x49, 0x20, 0x71, 0xe6,
	0x33, 0x72, 0xe6, 0x53, 0x20, 0x3b, 0xc9, 0x28, 0xdb, 0x04, 0xdd, 0xcd, 0x7e, 0x5e, 0xff, 0x9e,
	0xc7, 0xaf, 0xdb, 0xbc, 0xe0, 0x81, 0x4b, 0xa9, 0xeb, 0x13, 0xc3, 0xf1, 0x69, 0x82, 0x8d, 0xcf,
	0x64, 0xc0, 0x89, 0x93, 0x30, 0x2f, 0x1e, 0x73, 0x07, 0x85, 0x21, 0x61, 0x46, 0xba, 0x6e, 0x0c,
	0xbd, 0x10, 0x7b, 0xa1, 0xab, 0x47, 0x8c, 0xc6, 0x14, 0xae, 0x66, 0x84, 0x2e, 0x09, 0xfd, 0x22,
	0xa1, 0xa7, 0xeb, 0xcb, 0x2b, 0xb9, 0x2b, 0x8a, 0x3c, 0x63, 0xe8, 0x11, 0x1f, 0xdb, 0x03, 0x32,
	0x42, 0xa9, 0x47, 0x59, 0x66, 0xb2, 0x7c, 0x6b, 0xe2, 0x00, 0x23, 0x9c, 0x26, 0xcc, 0x21, 0x79,
	0xe9, 0xf1, 0xf4, 0x37, 0xb2, 0x11, 0xc6, 0x34, 0xcc, 0xb8, 0xd5, 0x6f, 0x55, 0x30, 0xb7, 0x9b,
	0xe9, 0x10, 0x82, 0x72, 0x88, 0x02, 0xa2, 0x29, 0x0d, 0xa5, 0x59, 0xb5, 0xe4, 0x1a, 0xde, 0x05,
	0xf5, 0x02, 0x8b, 0xc7, 0x11, 0xd1, 0x66, 0x64, 0xad, 0x96, 0x6b, 0xbd, 0x71, 0x44, 0x60, 0x1f,
	0x54, 0x38, 0x49, 0x89, 0x08, 0xd3, 0x16, 0x1b, 0x4a, 0x73, 0x7e, 0xe3, 0xa1, 0xfe, 0xff, 0x6e,
	0xf5, 0x3c, 0x55, 0xef, 0xe6, 0xec, 0x76, 0xe9, 0xe7, 0x56, 0xc9, 0x3a, 0xb3, 0x82, 0x2b, 0xa0,
	0x36, 0x8a, 0xe3, 0xc8, 0x0e, 0x48, 0x3c, 0xa2, 0x58, 0x2b, 0xc9, 0x60, 0x20, 0xa4, 0x03, 0xa9,
	0xc0, 0x3b, 0x00, 0x0c, 0x93, 0xe3, 0x63, 0x82, 0xed, 0x84, 0xf9, 0x5a, 0x59, 0xd6, 0xab, 0x99,
	0xd2, 0x67, 0xbe, 0xe8, 0x66, 0x40, 0xf1, 0x58, 0xbb, 0x9e, 0x75, 0x23, 0xd6, 0xb0, 0x01, 0x6a,
	0x98, 0x70, 0x87, 0x79, 0x51, 0xec, 0xd1, 0x50, 0x9b, 0xcd, 0x9a, 0x99, 0x90, 0xe0, 0x1a, 0x50,
	0x19, 0x89, 0x18, 0xc5, 0x89, 0x23, 0xf6, 0xd2, 0x7a, 0x4e, 0x1e, 0x5b, 0x98, 0xd4, 0x45, 0xc0,
	0x6d, 0x50, 0x1d, 0x32, 0x14, 0x10, 0x79, 0xa6, 0x22, 0xcf, 0x54, 0xa4, 0x50, 0x14, 0xbd, 0x10,
	0xf9, 0xb2, 0x58, 0xcd, 0x8b, 0x42, 0x10, 0xc5, 0x15, 0x50, 0x8b, 0x19, 0x72, 0x3e, 0x89, 0x57,
	0xf5, 0xb0, 0x06, 0xb2, 0xd6, 0x0a, 0xc9, 0xc4, 0xf0, 0x05, 0x28, 0x0f, 0x29, 0x0b, 0x34, 0xb5,
	0xa1, 0x34, 0x6b, 0x1b, 0xcd, 0xa9, 0x9e, 0x93, 0xb2, 0xc0, 0x92, 0x14, 0xfc, 0x00, 0x54, 0x9a,
	0xc4, 0x18, 0xc5, 0x04, 0xdb, 0xbe, 0x37, 0x60, 0x88, 0x8d, 0xb5, 0x9a, 0x74, 0xda, 0x9c, 0xc6,
	0xe9, 0x30, 0x67, 0xf7, 0x33, 0xd4, 0x5a, 0xa0, 0x7f, 0x0b, 0x10, 0x03, 0x98, 0x7a, 0xd4, 0x47,
	0xb1, 0xb8, 0x7f, 0xf1, 0x3f, 0xd4, 0xea, 0x32, 0xe1, 0xd1, 0x34, 0x09, 0x47, 0x05, 0x6d, 0xe5,
	0xb0, 0xb5, 0x98, 0x9e, 0x97, 0x64, 0x4a, 0xe2, 0x87, 0x84, 0xa1, 0x81, 0x4f, 0xec, 0x11, 0x41,
	0x98, 0x30, 0xae, 0x2d, 0x5c, 0x21, 0xe5, 0x8c, 0xde, 0xcb, 0x60, 0x6b, 0x31, 0x3d, 0x2f, 0xc1,
	0x00, 0xdc, 0x9c, 0x48, 0x89, 0x90, 0xf8, 0xfd, 0x62, 0x11, 0x74, 0x43, 0x06, 0x3d, 0xb9, 0x5a,
	0x50, 0xe7, 0x8c, 0xb7, 0x96, 0xd2, 0x4b, 0x54, 0xf8, 0x14, 0x94, 0xbe, 0x70, 0xae, 0xcd, 0x4b,
	0xf3, 0xfb, 0xd3, 0x98, 0xbf, 0xe5, 0xdc, 0x12, 0xcc, 0xea, 0x6b, 0x50, 0x29, 0x3e, 0x15, 0xa8,
	0x81, 0xa5, 0x6e, 0xfb, 0xa8, 0x6d, 0x99, 0xbd, 0x77, 0x76, 0xff, 0x55, 0xb7, 0xd3, 0x6e, 0x99,
	0xbb, 0x66, 0x7b, 0x47, 0xbd, 0x06, 0xeb, 0xa0, 0xd2, 0xb2, 0xcc, 0x9e, 0xd9, 0xda, 0xda, 0x57,
	0x15, 0x58, 0x01, 0xe5, 0x3d, 0xf3, 0xe5, 0x9e, 0x3a, 0x03, 0x01, 0x98, 0x3d, 0x68, 0xef, 0x98,
	0xfd, 0x03, 0xb5, 0x04, 0xe7, 0x40, 0x69, 0xff, 0xf0, 0x8d, 0x5a, 0x7e, 0xf6, 0x5d, 0xf9, 0xb5,
	0xf5, 0x55, 0x01, 0x6b, 0x97, 0x24, 0x67, 0x37, 0x43, 0x91, 0xc7, 0x75, 0x87, 0x06, 0x46, 0x31,
	0x22, 0xba, 0x11, 0xa3, 0x1f, 0x89, 0x13, 0x73, 0xe3, 0x24, 0x5f, 0x9d, 0x1a, 0x02, 0x69, 0xd1,
	0x70, 0xe8, 0xb9, 0xdc, 0x38, 0x11, 0x1b, 0xdb, 0x91, 0xbb, 0xac, 0x62, 0x25, 0x61, 0x21, 0xb3,
	0x24, 0x3c, 0x2d, 0x86, 0x10, 0x37, 0x4e, 0xf2, 0xd5, 0xe9, 0xf6, 0x0f, 0x05, 0xdc, 0x73, 0x68,
	0x30, 0xc5, 0x6b, 0x6c, 0xd7, 0xf3, 0x8b, 0x74, 0xc4, 0xf0, 0xea, 0x28, 0xef, 0x7b, 0x39, 0xe3,
	0x52, 0x1f, 0x85, 0xae, 0x4e, 0x99, 0x6b, 0xb8, 0x24, 0x94, 0xa3, 0xcd, 0xf8, 0xd3, 0xc2, 0xbf,
	0xa6, 0xe2, 0xf3, 0x8b, 0xea, 0x60, 0x56, 0x1a, 0x6c, 0xfe, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x46,
	0x8a, 0xf9, 0x53, 0xe7, 0x05, 0x00, 0x00,
}
