// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/websecurityscanner/v1/scan_config.proto

package websecurityscanner

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Type of user agents used for scanning.
type ScanConfig_UserAgent int32

const (
	// The user agent is unknown. Service will default to CHROME_LINUX.
	ScanConfig_USER_AGENT_UNSPECIFIED ScanConfig_UserAgent = 0
	// Chrome on Linux. This is the service default if unspecified.
	ScanConfig_CHROME_LINUX ScanConfig_UserAgent = 1
	// Chrome on Android.
	ScanConfig_CHROME_ANDROID ScanConfig_UserAgent = 2
	// Safari on IPhone.
	ScanConfig_SAFARI_IPHONE ScanConfig_UserAgent = 3
)

var ScanConfig_UserAgent_name = map[int32]string{
	0: "USER_AGENT_UNSPECIFIED",
	1: "CHROME_LINUX",
	2: "CHROME_ANDROID",
	3: "SAFARI_IPHONE",
}

var ScanConfig_UserAgent_value = map[string]int32{
	"USER_AGENT_UNSPECIFIED": 0,
	"CHROME_LINUX":           1,
	"CHROME_ANDROID":         2,
	"SAFARI_IPHONE":          3,
}

func (x ScanConfig_UserAgent) String() string {
	return proto.EnumName(ScanConfig_UserAgent_name, int32(x))
}

func (ScanConfig_UserAgent) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0, 0}
}

// Scan risk levels supported by Web Security Scanner. LOW impact
// scanning will minimize requests with the potential to modify data. To
// achieve the maximum scan coverage, NORMAL risk level is recommended.
type ScanConfig_RiskLevel int32

const (
	// Use default, which is NORMAL.
	ScanConfig_RISK_LEVEL_UNSPECIFIED ScanConfig_RiskLevel = 0
	// Normal scanning (Recommended)
	ScanConfig_NORMAL ScanConfig_RiskLevel = 1
	// Lower impact scanning
	ScanConfig_LOW ScanConfig_RiskLevel = 2
)

var ScanConfig_RiskLevel_name = map[int32]string{
	0: "RISK_LEVEL_UNSPECIFIED",
	1: "NORMAL",
	2: "LOW",
}

var ScanConfig_RiskLevel_value = map[string]int32{
	"RISK_LEVEL_UNSPECIFIED": 0,
	"NORMAL":                 1,
	"LOW":                    2,
}

func (x ScanConfig_RiskLevel) String() string {
	return proto.EnumName(ScanConfig_RiskLevel_name, int32(x))
}

func (ScanConfig_RiskLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0, 1}
}

// Controls export of scan configurations and results to Security
// Command Center.
type ScanConfig_ExportToSecurityCommandCenter int32

const (
	// Use default, which is ENABLED.
	ScanConfig_EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED ScanConfig_ExportToSecurityCommandCenter = 0
	// Export results of this scan to Security Command Center.
	ScanConfig_ENABLED ScanConfig_ExportToSecurityCommandCenter = 1
	// Do not export results of this scan to Security Command Center.
	ScanConfig_DISABLED ScanConfig_ExportToSecurityCommandCenter = 2
)

var ScanConfig_ExportToSecurityCommandCenter_name = map[int32]string{
	0: "EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED",
	1: "ENABLED",
	2: "DISABLED",
}

var ScanConfig_ExportToSecurityCommandCenter_value = map[string]int32{
	"EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED": 0,
	"ENABLED":  1,
	"DISABLED": 2,
}

func (x ScanConfig_ExportToSecurityCommandCenter) String() string {
	return proto.EnumName(ScanConfig_ExportToSecurityCommandCenter_name, int32(x))
}

func (ScanConfig_ExportToSecurityCommandCenter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0, 2}
}

// A ScanConfig resource contains the configurations to launch a scan.
type ScanConfig struct {
	// The resource name of the ScanConfig. The name follows the format of
	// 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
	// generated by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user provided display name of the ScanConfig.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The maximum QPS during scanning. A valid value ranges from 5 to 20
	// inclusively. If the field is unspecified or its value is set 0, server will
	// default to 15. Other values outside of [5, 20] range will be rejected with
	// INVALID_ARGUMENT error.
	MaxQps int32 `protobuf:"varint,3,opt,name=max_qps,json=maxQps,proto3" json:"max_qps,omitempty"`
	// Required. The starting URLs from which the scanner finds site pages.
	StartingUrls []string `protobuf:"bytes,4,rep,name=starting_urls,json=startingUrls,proto3" json:"starting_urls,omitempty"`
	// The authentication configuration. If specified, service will use the
	// authentication configuration during scanning.
	Authentication *ScanConfig_Authentication `protobuf:"bytes,5,opt,name=authentication,proto3" json:"authentication,omitempty"`
	// The user agent used during scanning.
	UserAgent ScanConfig_UserAgent `protobuf:"varint,6,opt,name=user_agent,json=userAgent,proto3,enum=google.cloud.websecurityscanner.v1.ScanConfig_UserAgent" json:"user_agent,omitempty"`
	// The excluded URL patterns as described in
	// https://cloud.google.com/security-command-center/docs/how-to-use-web-security-scanner#excluding_urls
	BlacklistPatterns []string `protobuf:"bytes,7,rep,name=blacklist_patterns,json=blacklistPatterns,proto3" json:"blacklist_patterns,omitempty"`
	// The schedule of the ScanConfig.
	Schedule *ScanConfig_Schedule `protobuf:"bytes,8,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Controls export of scan configurations and results to Security
	// Command Center.
	ExportToSecurityCommandCenter ScanConfig_ExportToSecurityCommandCenter `protobuf:"varint,10,opt,name=export_to_security_command_center,json=exportToSecurityCommandCenter,proto3,enum=google.cloud.websecurityscanner.v1.ScanConfig_ExportToSecurityCommandCenter" json:"export_to_security_command_center,omitempty"`
	// The risk level selected for the scan
	RiskLevel ScanConfig_RiskLevel `protobuf:"varint,12,opt,name=risk_level,json=riskLevel,proto3,enum=google.cloud.websecurityscanner.v1.ScanConfig_RiskLevel" json:"risk_level,omitempty"`
	// Whether the scan config is managed by Web Security Scanner, output
	// only.
	ManagedScan bool `protobuf:"varint,13,opt,name=managed_scan,json=managedScan,proto3" json:"managed_scan,omitempty"`
	// Whether the scan configuration has enabled static IP address scan feature.
	// If enabled, the scanner will access applications from static IP addresses.
	StaticIpScan         bool     `protobuf:"varint,14,opt,name=static_ip_scan,json=staticIpScan,proto3" json:"static_ip_scan,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanConfig) Reset()         { *m = ScanConfig{} }
func (m *ScanConfig) String() string { return proto.CompactTextString(m) }
func (*ScanConfig) ProtoMessage()    {}
func (*ScanConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0}
}

func (m *ScanConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig.Unmarshal(m, b)
}
func (m *ScanConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig.Marshal(b, m, deterministic)
}
func (m *ScanConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig.Merge(m, src)
}
func (m *ScanConfig) XXX_Size() int {
	return xxx_messageInfo_ScanConfig.Size(m)
}
func (m *ScanConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig proto.InternalMessageInfo

func (m *ScanConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ScanConfig) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ScanConfig) GetMaxQps() int32 {
	if m != nil {
		return m.MaxQps
	}
	return 0
}

func (m *ScanConfig) GetStartingUrls() []string {
	if m != nil {
		return m.StartingUrls
	}
	return nil
}

func (m *ScanConfig) GetAuthentication() *ScanConfig_Authentication {
	if m != nil {
		return m.Authentication
	}
	return nil
}

func (m *ScanConfig) GetUserAgent() ScanConfig_UserAgent {
	if m != nil {
		return m.UserAgent
	}
	return ScanConfig_USER_AGENT_UNSPECIFIED
}

func (m *ScanConfig) GetBlacklistPatterns() []string {
	if m != nil {
		return m.BlacklistPatterns
	}
	return nil
}

func (m *ScanConfig) GetSchedule() *ScanConfig_Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *ScanConfig) GetExportToSecurityCommandCenter() ScanConfig_ExportToSecurityCommandCenter {
	if m != nil {
		return m.ExportToSecurityCommandCenter
	}
	return ScanConfig_EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED
}

func (m *ScanConfig) GetRiskLevel() ScanConfig_RiskLevel {
	if m != nil {
		return m.RiskLevel
	}
	return ScanConfig_RISK_LEVEL_UNSPECIFIED
}

func (m *ScanConfig) GetManagedScan() bool {
	if m != nil {
		return m.ManagedScan
	}
	return false
}

func (m *ScanConfig) GetStaticIpScan() bool {
	if m != nil {
		return m.StaticIpScan
	}
	return false
}

// Scan authentication configuration.
type ScanConfig_Authentication struct {
	// Required.
	// Authentication configuration
	//
	// Types that are valid to be assigned to Authentication:
	//	*ScanConfig_Authentication_GoogleAccount_
	//	*ScanConfig_Authentication_CustomAccount_
	//	*ScanConfig_Authentication_IapCredential_
	Authentication       isScanConfig_Authentication_Authentication `protobuf_oneof:"authentication"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *ScanConfig_Authentication) Reset()         { *m = ScanConfig_Authentication{} }
func (m *ScanConfig_Authentication) String() string { return proto.CompactTextString(m) }
func (*ScanConfig_Authentication) ProtoMessage()    {}
func (*ScanConfig_Authentication) Descriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0, 0}
}

func (m *ScanConfig_Authentication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Authentication.Unmarshal(m, b)
}
func (m *ScanConfig_Authentication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Authentication.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Authentication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Authentication.Merge(m, src)
}
func (m *ScanConfig_Authentication) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Authentication.Size(m)
}
func (m *ScanConfig_Authentication) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Authentication.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Authentication proto.InternalMessageInfo

type isScanConfig_Authentication_Authentication interface {
	isScanConfig_Authentication_Authentication()
}

type ScanConfig_Authentication_GoogleAccount_ struct {
	GoogleAccount *ScanConfig_Authentication_GoogleAccount `protobuf:"bytes,1,opt,name=google_account,json=googleAccount,proto3,oneof"`
}

type ScanConfig_Authentication_CustomAccount_ struct {
	CustomAccount *ScanConfig_Authentication_CustomAccount `protobuf:"bytes,2,opt,name=custom_account,json=customAccount,proto3,oneof"`
}

type ScanConfig_Authentication_IapCredential_ struct {
	IapCredential *ScanConfig_Authentication_IapCredential `protobuf:"bytes,4,opt,name=iap_credential,json=iapCredential,proto3,oneof"`
}

func (*ScanConfig_Authentication_GoogleAccount_) isScanConfig_Authentication_Authentication() {}

func (*ScanConfig_Authentication_CustomAccount_) isScanConfig_Authentication_Authentication() {}

func (*ScanConfig_Authentication_IapCredential_) isScanConfig_Authentication_Authentication() {}

func (m *ScanConfig_Authentication) GetAuthentication() isScanConfig_Authentication_Authentication {
	if m != nil {
		return m.Authentication
	}
	return nil
}

func (m *ScanConfig_Authentication) GetGoogleAccount() *ScanConfig_Authentication_GoogleAccount {
	if x, ok := m.GetAuthentication().(*ScanConfig_Authentication_GoogleAccount_); ok {
		return x.GoogleAccount
	}
	return nil
}

func (m *ScanConfig_Authentication) GetCustomAccount() *ScanConfig_Authentication_CustomAccount {
	if x, ok := m.GetAuthentication().(*ScanConfig_Authentication_CustomAccount_); ok {
		return x.CustomAccount
	}
	return nil
}

func (m *ScanConfig_Authentication) GetIapCredential() *ScanConfig_Authentication_IapCredential {
	if x, ok := m.GetAuthentication().(*ScanConfig_Authentication_IapCredential_); ok {
		return x.IapCredential
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScanConfig_Authentication) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScanConfig_Authentication_GoogleAccount_)(nil),
		(*ScanConfig_Authentication_CustomAccount_)(nil),
		(*ScanConfig_Authentication_IapCredential_)(nil),
	}
}

// Describes authentication configuration that uses a Google account.
type ScanConfig_Authentication_GoogleAccount struct {
	// Required. The user name of the Google account.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Input only. The password of the Google account. The credential is stored encrypted
	// and not returned in any response nor included in audit logs.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanConfig_Authentication_GoogleAccount) Reset() {
	*m = ScanConfig_Authentication_GoogleAccount{}
}
func (m *ScanConfig_Authentication_GoogleAccount) String() string { return proto.CompactTextString(m) }
func (*ScanConfig_Authentication_GoogleAccount) ProtoMessage()    {}
func (*ScanConfig_Authentication_GoogleAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0, 0, 0}
}

func (m *ScanConfig_Authentication_GoogleAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.Unmarshal(m, b)
}
func (m *ScanConfig_Authentication_GoogleAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Authentication_GoogleAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.Merge(m, src)
}
func (m *ScanConfig_Authentication_GoogleAccount) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.Size(m)
}
func (m *ScanConfig_Authentication_GoogleAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Authentication_GoogleAccount proto.InternalMessageInfo

func (m *ScanConfig_Authentication_GoogleAccount) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *ScanConfig_Authentication_GoogleAccount) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

// Describes authentication configuration that uses a custom account.
type ScanConfig_Authentication_CustomAccount struct {
	// Required. The user name of the custom account.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Input only. The password of the custom account. The credential is stored encrypted
	// and not returned in any response nor included in audit logs.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// Required. The login form URL of the website.
	LoginUrl             string   `protobuf:"bytes,3,opt,name=login_url,json=loginUrl,proto3" json:"login_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanConfig_Authentication_CustomAccount) Reset() {
	*m = ScanConfig_Authentication_CustomAccount{}
}
func (m *ScanConfig_Authentication_CustomAccount) String() string { return proto.CompactTextString(m) }
func (*ScanConfig_Authentication_CustomAccount) ProtoMessage()    {}
func (*ScanConfig_Authentication_CustomAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0, 0, 1}
}

func (m *ScanConfig_Authentication_CustomAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Authentication_CustomAccount.Unmarshal(m, b)
}
func (m *ScanConfig_Authentication_CustomAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Authentication_CustomAccount.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Authentication_CustomAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Authentication_CustomAccount.Merge(m, src)
}
func (m *ScanConfig_Authentication_CustomAccount) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Authentication_CustomAccount.Size(m)
}
func (m *ScanConfig_Authentication_CustomAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Authentication_CustomAccount.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Authentication_CustomAccount proto.InternalMessageInfo

func (m *ScanConfig_Authentication_CustomAccount) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *ScanConfig_Authentication_CustomAccount) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *ScanConfig_Authentication_CustomAccount) GetLoginUrl() string {
	if m != nil {
		return m.LoginUrl
	}
	return ""
}

// Describes authentication configuration for Identity-Aware-Proxy (IAP).
type ScanConfig_Authentication_IapCredential struct {
	// Identity-Aware-Proxy (IAP) Authentication Configuration
	//
	// Types that are valid to be assigned to IapCredentials:
	//	*ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo_
	IapCredentials       isScanConfig_Authentication_IapCredential_IapCredentials `protobuf_oneof:"iap_credentials"`
	XXX_NoUnkeyedLiteral struct{}                                                 `json:"-"`
	XXX_unrecognized     []byte                                                   `json:"-"`
	XXX_sizecache        int32                                                    `json:"-"`
}

func (m *ScanConfig_Authentication_IapCredential) Reset() {
	*m = ScanConfig_Authentication_IapCredential{}
}
func (m *ScanConfig_Authentication_IapCredential) String() string { return proto.CompactTextString(m) }
func (*ScanConfig_Authentication_IapCredential) ProtoMessage()    {}
func (*ScanConfig_Authentication_IapCredential) Descriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0, 0, 2}
}

func (m *ScanConfig_Authentication_IapCredential) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Authentication_IapCredential.Unmarshal(m, b)
}
func (m *ScanConfig_Authentication_IapCredential) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Authentication_IapCredential.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Authentication_IapCredential) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Authentication_IapCredential.Merge(m, src)
}
func (m *ScanConfig_Authentication_IapCredential) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Authentication_IapCredential.Size(m)
}
func (m *ScanConfig_Authentication_IapCredential) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Authentication_IapCredential.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Authentication_IapCredential proto.InternalMessageInfo

type isScanConfig_Authentication_IapCredential_IapCredentials interface {
	isScanConfig_Authentication_IapCredential_IapCredentials()
}

type ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo_ struct {
	IapTestServiceAccountInfo *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo `protobuf:"bytes,1,opt,name=iap_test_service_account_info,json=iapTestServiceAccountInfo,proto3,oneof"`
}

func (*ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo_) isScanConfig_Authentication_IapCredential_IapCredentials() {
}

func (m *ScanConfig_Authentication_IapCredential) GetIapCredentials() isScanConfig_Authentication_IapCredential_IapCredentials {
	if m != nil {
		return m.IapCredentials
	}
	return nil
}

func (m *ScanConfig_Authentication_IapCredential) GetIapTestServiceAccountInfo() *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo {
	if x, ok := m.GetIapCredentials().(*ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo_); ok {
		return x.IapTestServiceAccountInfo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScanConfig_Authentication_IapCredential) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo_)(nil),
	}
}

// Describes authentication configuration when Web-Security-Scanner
// service account is added in Identity-Aware-Proxy (IAP) access policies.
type ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo struct {
	// Required. Describes OAuth2 client id of resources protected by
	// Identity-Aware-Proxy (IAP).
	TargetAudienceClientId string   `protobuf:"bytes,1,opt,name=target_audience_client_id,json=targetAudienceClientId,proto3" json:"target_audience_client_id,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) Reset() {
	*m = ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo{}
}
func (m *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) String() string {
	return proto.CompactTextString(m)
}
func (*ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) ProtoMessage() {}
func (*ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0, 0, 2, 0}
}

func (m *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo.Unmarshal(m, b)
}
func (m *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo.Merge(m, src)
}
func (m *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo.Size(m)
}
func (m *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo proto.InternalMessageInfo

func (m *ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo) GetTargetAudienceClientId() string {
	if m != nil {
		return m.TargetAudienceClientId
	}
	return ""
}

// Scan schedule configuration.
type ScanConfig_Schedule struct {
	// A timestamp indicates when the next run will be scheduled. The value is
	// refreshed by the server after each run. If unspecified, it will default
	// to current server time, which means the scan will be scheduled to start
	// immediately.
	ScheduleTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=schedule_time,json=scheduleTime,proto3" json:"schedule_time,omitempty"`
	// Required. The duration of time between executions in days.
	IntervalDurationDays int32    `protobuf:"varint,2,opt,name=interval_duration_days,json=intervalDurationDays,proto3" json:"interval_duration_days,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanConfig_Schedule) Reset()         { *m = ScanConfig_Schedule{} }
func (m *ScanConfig_Schedule) String() string { return proto.CompactTextString(m) }
func (*ScanConfig_Schedule) ProtoMessage()    {}
func (*ScanConfig_Schedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_87034538e0e89662, []int{0, 1}
}

func (m *ScanConfig_Schedule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Schedule.Unmarshal(m, b)
}
func (m *ScanConfig_Schedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Schedule.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Schedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Schedule.Merge(m, src)
}
func (m *ScanConfig_Schedule) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Schedule.Size(m)
}
func (m *ScanConfig_Schedule) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Schedule.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Schedule proto.InternalMessageInfo

func (m *ScanConfig_Schedule) GetScheduleTime() *timestamp.Timestamp {
	if m != nil {
		return m.ScheduleTime
	}
	return nil
}

func (m *ScanConfig_Schedule) GetIntervalDurationDays() int32 {
	if m != nil {
		return m.IntervalDurationDays
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.cloud.websecurityscanner.v1.ScanConfig_UserAgent", ScanConfig_UserAgent_name, ScanConfig_UserAgent_value)
	proto.RegisterEnum("google.cloud.websecurityscanner.v1.ScanConfig_RiskLevel", ScanConfig_RiskLevel_name, ScanConfig_RiskLevel_value)
	proto.RegisterEnum("google.cloud.websecurityscanner.v1.ScanConfig_ExportToSecurityCommandCenter", ScanConfig_ExportToSecurityCommandCenter_name, ScanConfig_ExportToSecurityCommandCenter_value)
	proto.RegisterType((*ScanConfig)(nil), "google.cloud.websecurityscanner.v1.ScanConfig")
	proto.RegisterType((*ScanConfig_Authentication)(nil), "google.cloud.websecurityscanner.v1.ScanConfig.Authentication")
	proto.RegisterType((*ScanConfig_Authentication_GoogleAccount)(nil), "google.cloud.websecurityscanner.v1.ScanConfig.Authentication.GoogleAccount")
	proto.RegisterType((*ScanConfig_Authentication_CustomAccount)(nil), "google.cloud.websecurityscanner.v1.ScanConfig.Authentication.CustomAccount")
	proto.RegisterType((*ScanConfig_Authentication_IapCredential)(nil), "google.cloud.websecurityscanner.v1.ScanConfig.Authentication.IapCredential")
	proto.RegisterType((*ScanConfig_Authentication_IapCredential_IapTestServiceAccountInfo)(nil), "google.cloud.websecurityscanner.v1.ScanConfig.Authentication.IapCredential.IapTestServiceAccountInfo")
	proto.RegisterType((*ScanConfig_Schedule)(nil), "google.cloud.websecurityscanner.v1.ScanConfig.Schedule")
}

func init() {
	proto.RegisterFile("google/cloud/websecurityscanner/v1/scan_config.proto", fileDescriptor_87034538e0e89662)
}

var fileDescriptor_87034538e0e89662 = []byte{
	// 1004 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xdd, 0x6e, 0xdb, 0x36,
	0x14, 0xae, 0x9c, 0x36, 0xb1, 0x19, 0xdb, 0x71, 0x88, 0x21, 0x53, 0x3c, 0x04, 0x73, 0xb3, 0x61,
	0xf0, 0x4d, 0x6d, 0x24, 0x2b, 0xb0, 0x01, 0xfb, 0x83, 0x2c, 0xab, 0x89, 0x50, 0xc7, 0xf6, 0x28,
	0x7b, 0xed, 0xb6, 0x0b, 0x8e, 0x91, 0x18, 0x85, 0x88, 0xfe, 0x26, 0x52, 0x6e, 0x72, 0xb9, 0x47,
	0xd8, 0xcd, 0xde, 0x61, 0xd8, 0x4b, 0x6d, 0x4f, 0xb1, 0xdb, 0x81, 0x94, 0xe4, 0xc6, 0x29, 0x9a,
	0x2d, 0x5d, 0xee, 0xc8, 0x73, 0xce, 0xf7, 0x7d, 0x3c, 0x87, 0x47, 0x87, 0x02, 0x4f, 0xfd, 0x38,
	0xf6, 0x03, 0xda, 0x77, 0x83, 0x38, 0xf3, 0xfa, 0xaf, 0xe8, 0x29, 0xa7, 0x6e, 0x96, 0x32, 0x71,
	0xc5, 0x5d, 0x12, 0x45, 0x34, 0xed, 0x2f, 0x0e, 0xfa, 0x72, 0x89, 0xdd, 0x38, 0x3a, 0x63, 0x7e,
	0x2f, 0x49, 0x63, 0x11, 0xc3, 0xfd, 0x1c, 0xd5, 0x53, 0xa8, 0xde, 0x9b, 0xa8, 0xde, 0xe2, 0xa0,
	0xfd, 0x61, 0xc1, 0x4c, 0x12, 0xd6, 0x3f, 0x63, 0x34, 0xf0, 0xf0, 0x29, 0x3d, 0x27, 0x0b, 0x16,
	0xa7, 0x39, 0xc9, 0x32, 0x40, 0xed, 0x4e, 0xb3, 0xb3, 0xbe, 0x60, 0x21, 0xe5, 0x82, 0x84, 0x49,
	0x1e, 0xb0, 0xff, 0xf7, 0x16, 0x00, 0x8e, 0x4b, 0x22, 0x53, 0x49, 0x43, 0x08, 0x1e, 0x46, 0x24,
	0xa4, 0xba, 0xd6, 0xd1, 0xba, 0x35, 0xa4, 0xd6, 0xf0, 0x31, 0xa8, 0x7b, 0x8c, 0x27, 0x01, 0xb9,
	0xc2, 0xca, 0x57, 0x51, 0xbe, 0xcd, 0xc2, 0x36, 0x96, 0x21, 0xef, 0x83, 0x8d, 0x90, 0x5c, 0xe2,
	0x9f, 0x13, 0xae, 0xaf, 0x75, 0xb4, 0xee, 0x23, 0xb4, 0x1e, 0x92, 0xcb, 0x6f, 0x13, 0x0e, 0x3f,
	0x02, 0x0d, 0x2e, 0x48, 0x2a, 0x58, 0xe4, 0xe3, 0x2c, 0x0d, 0xb8, 0xfe, 0xb0, 0xb3, 0xd6, 0xad,
	0xa1, 0x7a, 0x69, 0x9c, 0xa7, 0x01, 0x87, 0x14, 0x34, 0x49, 0x26, 0xce, 0x69, 0x24, 0x98, 0x4b,
	0x04, 0x8b, 0x23, 0xfd, 0x51, 0x47, 0xeb, 0x6e, 0x1e, 0x7e, 0xd5, 0xfb, 0xf7, 0x12, 0xf4, 0x5e,
	0x1f, 0xbe, 0x67, 0xac, 0x90, 0xa0, 0x1b, 0xa4, 0xf0, 0x05, 0x00, 0x19, 0xa7, 0x29, 0x26, 0x3e,
	0x8d, 0x84, 0xbe, 0xde, 0xd1, 0xba, 0xcd, 0xc3, 0xcf, 0xef, 0x28, 0x31, 0xe7, 0x34, 0x35, 0x24,
	0x1e, 0xd5, 0xb2, 0x72, 0x09, 0x9f, 0x00, 0x78, 0x1a, 0x10, 0xf7, 0x22, 0x60, 0x5c, 0xe0, 0x84,
	0x08, 0x41, 0xd3, 0x88, 0xeb, 0x1b, 0x2a, 0xd3, 0xed, 0xa5, 0x67, 0x5a, 0x38, 0xa0, 0x03, 0xaa,
	0xdc, 0x3d, 0xa7, 0x5e, 0x16, 0x50, 0xbd, 0xaa, 0x12, 0xfd, 0xec, 0x8e, 0xa7, 0x70, 0x0a, 0x38,
	0x5a, 0x12, 0xc1, 0xdf, 0x34, 0xf0, 0x98, 0x5e, 0x26, 0x71, 0x2a, 0xb0, 0x88, 0x71, 0x09, 0xc7,
	0x6e, 0x1c, 0x86, 0x24, 0xf2, 0xb0, 0x4b, 0x23, 0x41, 0x53, 0x1d, 0xa8, 0xa4, 0x47, 0x77, 0x94,
	0xb3, 0x14, 0xef, 0x2c, 0x76, 0x8a, 0x28, 0x33, 0x27, 0x35, 0x15, 0x27, 0xda, 0xa3, 0xb7, 0xb9,
	0x65, 0xd5, 0x53, 0xc6, 0x2f, 0x70, 0x40, 0x17, 0x34, 0xd0, 0xeb, 0xef, 0x54, 0x75, 0xc4, 0xf8,
	0xc5, 0x48, 0xe2, 0x51, 0x2d, 0x2d, 0x97, 0xb2, 0x2d, 0x43, 0x12, 0x11, 0x9f, 0x7a, 0x58, 0xa2,
	0xf4, 0x46, 0x47, 0xeb, 0x56, 0xd1, 0x66, 0x61, 0x93, 0x68, 0xf8, 0x31, 0x68, 0x72, 0x41, 0x04,
	0x73, 0x31, 0x4b, 0xf2, 0xa0, 0xa6, 0x0a, 0xaa, 0xe7, 0x56, 0x3b, 0x91, 0x51, 0xed, 0xbf, 0xd6,
	0x41, 0x73, 0xb5, 0x75, 0xa0, 0x00, 0xcd, 0xfc, 0x84, 0x98, 0xb8, 0x6e, 0x9c, 0x45, 0x42, 0x7d,
	0x10, 0x9b, 0x87, 0xcf, 0xff, 0x57, 0x47, 0xf6, 0x8e, 0x14, 0xd8, 0xc8, 0x29, 0x8f, 0x1f, 0xa0,
	0x86, 0x7f, 0xdd, 0x20, 0x55, 0xdd, 0x8c, 0x8b, 0x38, 0x5c, 0xaa, 0x56, 0xee, 0x43, 0xd5, 0x54,
	0x9c, 0xd7, 0x54, 0xdd, 0xeb, 0x06, 0xa9, 0xca, 0x48, 0x82, 0xdd, 0x94, 0x7a, 0x12, 0x44, 0x02,
	0xfd, 0xe1, 0x7d, 0xa8, 0xda, 0x24, 0x31, 0x97, 0x94, 0x52, 0x95, 0x5d, 0x37, 0xb4, 0x8f, 0x40,
	0x63, 0xa5, 0x1a, 0xb0, 0x0d, 0xaa, 0xf2, 0x8b, 0xba, 0x36, 0x7d, 0x96, 0x7b, 0xe9, 0x4b, 0x08,
	0xe7, 0xaf, 0xe2, 0xd4, 0x2b, 0xa6, 0xcf, 0x72, 0xdf, 0xf6, 0x40, 0x63, 0x25, 0xc1, 0x77, 0x25,
	0x82, 0x1f, 0x80, 0x5a, 0x10, 0xfb, 0x2c, 0x92, 0x73, 0x4a, 0x4d, 0xb1, 0x1a, 0xaa, 0x2a, 0xc3,
	0x3c, 0x0d, 0xda, 0x7f, 0x54, 0x40, 0x63, 0x25, 0x23, 0xf8, 0xbb, 0x06, 0xf6, 0x64, 0xdd, 0x04,
	0xe5, 0x02, 0x73, 0x9a, 0x2e, 0x98, 0xbb, 0xec, 0x16, 0xcc, 0xa2, 0xb3, 0xb8, 0x68, 0x19, 0x7a,
	0x8f, 0x65, 0x94, 0xbb, 0x19, 0xe5, 0xc2, 0xc9, 0xe5, 0x8a, 0x8c, 0xed, 0xe8, 0x2c, 0x3e, 0x7e,
	0x80, 0x76, 0xd9, 0xdb, 0x9c, 0xed, 0x1f, 0xc1, 0xee, 0x5b, 0x91, 0xf0, 0x6b, 0xb0, 0x2b, 0x48,
	0xea, 0x53, 0x81, 0x49, 0xe6, 0x31, 0x1a, 0xb9, 0x14, 0xbb, 0x01, 0xa3, 0x32, 0x0b, 0x2f, 0x2f,
	0xe0, 0x60, 0xed, 0x4f, 0xa3, 0x82, 0x76, 0xf2, 0x28, 0xa3, 0x08, 0x32, 0x55, 0x8c, 0xed, 0x0d,
	0xb6, 0xc1, 0xd6, 0x6a, 0xff, 0xf0, 0x41, 0xeb, 0xe6, 0x40, 0x6f, 0xff, 0xa2, 0x81, 0x6a, 0x39,
	0xb5, 0xe0, 0x37, 0xa0, 0x51, 0xce, 0x2d, 0x2c, 0xdf, 0xa3, 0xa2, 0x52, 0xed, 0xb2, 0x52, 0xe5,
	0x63, 0xd5, 0x9b, 0x95, 0x8f, 0x15, 0xaa, 0x97, 0x00, 0x69, 0x82, 0x4f, 0xc1, 0x0e, 0x93, 0xc3,
	0x65, 0x41, 0x02, 0xec, 0x65, 0xa9, 0x92, 0xc0, 0x1e, 0xb9, 0xe2, 0xea, 0x52, 0x1f, 0xa1, 0xf7,
	0x4a, 0xef, 0xb0, 0x70, 0x0e, 0xc9, 0x15, 0xdf, 0xff, 0x09, 0xd4, 0x96, 0xe3, 0x1b, 0xb6, 0xc1,
	0xce, 0xdc, 0xb1, 0x10, 0x36, 0x8e, 0xac, 0xf1, 0x0c, 0xcf, 0xc7, 0xce, 0xd4, 0x32, 0xed, 0x67,
	0xb6, 0x35, 0x6c, 0x3d, 0x80, 0x2d, 0x50, 0x37, 0x8f, 0xd1, 0xe4, 0xc4, 0xc2, 0x23, 0x7b, 0x3c,
	0x7f, 0xd9, 0xd2, 0x20, 0x04, 0xcd, 0xc2, 0x62, 0x8c, 0x87, 0x68, 0x62, 0x0f, 0x5b, 0x15, 0xb8,
	0x0d, 0x1a, 0x8e, 0xf1, 0xcc, 0x40, 0x36, 0xb6, 0xa7, 0xc7, 0x93, 0xb1, 0xd5, 0x5a, 0xdb, 0xff,
	0x12, 0xd4, 0x96, 0xa3, 0x4a, 0x2a, 0x20, 0xdb, 0x79, 0x8e, 0x47, 0xd6, 0x77, 0xd6, 0xe8, 0x86,
	0x02, 0x00, 0xeb, 0xe3, 0x09, 0x3a, 0x31, 0x46, 0x2d, 0x0d, 0x6e, 0x80, 0xb5, 0xd1, 0xe4, 0x45,
	0xab, 0xb2, 0x1f, 0x82, 0xbd, 0x5b, 0x27, 0x2d, 0x3c, 0x00, 0x4f, 0xac, 0x97, 0xd3, 0x09, 0x9a,
	0xe1, 0xd9, 0x04, 0x3b, 0x96, 0x39, 0x47, 0xf6, 0xec, 0x7b, 0x6c, 0x4e, 0x4e, 0x4e, 0x8c, 0xf1,
	0x10, 0x9b, 0xd6, 0x78, 0x66, 0xa1, 0x1b, 0x42, 0x9b, 0x60, 0xc3, 0x1a, 0x1b, 0x83, 0x91, 0x35,
	0x6c, 0x69, 0xb0, 0x0e, 0xaa, 0x43, 0xdb, 0xc9, 0x77, 0x95, 0xc1, 0xaf, 0x1a, 0xf8, 0xc4, 0x8d,
	0xc3, 0xff, 0xd0, 0x9e, 0x83, 0xad, 0xd7, 0xfd, 0x39, 0x95, 0x77, 0x33, 0xd5, 0x7e, 0x98, 0x15,
	0x30, 0x3f, 0x0e, 0x48, 0xe4, 0xf7, 0xe2, 0xd4, 0xef, 0xfb, 0x34, 0x52, 0x37, 0xd7, 0xcf, 0x5d,
	0x24, 0x61, 0xfc, 0xb6, 0x5f, 0x9e, 0x2f, 0xde, 0xb4, 0x9e, 0xae, 0x2b, 0x82, 0x4f, 0xff, 0x09,
	0x00, 0x00, 0xff, 0xff, 0xfa, 0xb6, 0xb1, 0x3a, 0x32, 0x09, 0x00, 0x00,
}
