import { FormGroupProps, TextAreaProps, TextInputProps } from '@patternfly/react-core';
import * as React from 'react';
import * as yup from 'yup';
declare type MaybeArraySchema<T> = [T] extends [Array<infer E>] ? yup.ArraySchema<E> : yup.Schema<T>;
export interface IFormField<T> {
    value: T;
    setValue: React.Dispatch<React.SetStateAction<T>>;
    setInitialValue: (value: T) => void;
    isDirty: boolean;
    isTouched: boolean;
    setIsTouched: (isTouched: boolean) => void;
    reset: () => void;
    schema: MaybeArraySchema<T>;
}
export interface IValidatedFormField<T> extends IFormField<T> {
    error: yup.ValidationError | null;
    isValid: boolean;
}
declare type FormFields<TFieldValues> = {
    [key in keyof TFieldValues]: IFormField<TFieldValues[key]>;
};
declare type ValidatedFormFields<TFieldValues> = {
    [key in keyof TFieldValues]: IValidatedFormField<TFieldValues[key]>;
};
export interface IFormState<TFieldValues> {
    fields: ValidatedFormFields<TFieldValues>;
    values: TFieldValues;
    isDirty: boolean;
    isValid: boolean;
    isTouched: boolean;
    reset: () => void;
}
export declare const useFormField: <T>(initialValue: T, schema: MaybeArraySchema<T>, options?: {
    initialTouched?: boolean;
}) => IFormField<T>;
export declare const useFormState: <TFieldValues>(fields: FormFields<TFieldValues>, yupOptions?: yup.ValidateOptions) => IFormState<TFieldValues>;
export declare const getFormGroupProps: <T>(field: IValidatedFormField<T>) => Pick<FormGroupProps, 'validated' | 'helperTextInvalid'>;
export declare const getTextFieldProps: (field: IValidatedFormField<string> | IValidatedFormField<string | undefined>) => Pick<TextInputProps | TextAreaProps, 'value' | 'onChange' | 'onBlur' | 'validated'>;
export declare const getTextInputProps: (field: IValidatedFormField<string> | IValidatedFormField<string | undefined>) => Partial<TextInputProps>;
export declare const getTextAreaProps: (field: IValidatedFormField<string> | IValidatedFormField<string | undefined>) => Partial<TextAreaProps>;
export {};
