import { IDiscoveryResource, IDiscoveryParameters, OAuthClient } from './resources/common';
import type { ResponseType } from 'axios';
export interface IDiscoveryClient {
    get(resource: IDiscoveryResource, params?: object): Promise<any>;
    getRaw(path: string): Promise<any>;
    apiRoot(): string;
    rootNamespace(): string;
    setTokenExpiryHandler: (TokenExpiryHandler: any, number: any) => void;
}
export declare class DiscoveryClient extends OAuthClient implements IDiscoveryClient {
    private readonly _discoveryApi;
    private readonly _discoveryNamespace;
    private readonly _requester;
    constructor(discoveryApi: string, discoveryNamespace: string, token: string, customResponseType?: ResponseType);
    rootNamespace(): string;
    apiRoot(): string;
    private fullPath;
    get: (resource: IDiscoveryResource, params?: IDiscoveryParameters | undefined) => Promise<any>;
    getRaw: (path: string) => Promise<any>;
    private _get;
}
