import { Updater } from './utils';
import { Query } from './query';
import { QueryConfig, QueryFunction, QueryKey, ReactQueryConfig, TypedQueryFunction, TypedQueryFunctionArgs, ResolvedQueryConfig } from './types';
import { QueryObserver } from './queryObserver';
interface QueryCacheConfig {
    frozen?: boolean;
    defaultConfig?: ReactQueryConfig;
}
interface ClearOptions {
    notify?: boolean;
}
interface PrefetchQueryOptions {
    force?: boolean;
    throwOnError?: boolean;
}
interface RefetchQueriesOptions extends QueryPredicateOptions {
    throwOnError?: boolean;
}
interface InvalidateQueriesOptions extends RefetchQueriesOptions {
    refetchActive?: boolean;
    refetchInactive?: boolean;
}
interface QueryPredicateOptions {
    active?: boolean;
    exact?: boolean;
    stale?: boolean;
}
declare type QueryPredicate = QueryKey | QueryPredicateFn | true;
declare type QueryPredicateFn = (query: Query<unknown, unknown>) => boolean;
export interface FetchQueryObjectConfig<TResult, TError> {
    queryKey: QueryKey;
    queryFn?: QueryFunction<TResult>;
    config?: QueryConfig<TResult, TError>;
}
export interface PrefetchQueryObjectConfig<TResult, TError> {
    queryKey: QueryKey;
    queryFn?: QueryFunction<TResult>;
    config?: QueryConfig<TResult, TError>;
    options?: PrefetchQueryOptions;
}
declare type QueryCacheListener = (cache: QueryCache, query?: Query<unknown, unknown>) => void;
export declare class QueryCache {
    isFetching: number;
    private config;
    private globalListeners;
    private queries;
    private queriesArray;
    constructor(config?: QueryCacheConfig);
    notifyGlobalListeners(query?: Query<any, any>): void;
    getDefaultConfig(): ReactQueryConfig<unknown, unknown> | undefined;
    getResolvedQueryConfig<TResult, TError>(queryKey: QueryKey, config?: QueryConfig<TResult, TError>): ResolvedQueryConfig<TResult, TError>;
    subscribe(listener: QueryCacheListener): () => void;
    clear(options?: ClearOptions): void;
    getQueries<TResult = unknown, TError = unknown>(predicate?: QueryPredicate, options?: QueryPredicateOptions): Query<TResult, TError>[];
    getQuery<TResult, TError = unknown>(predicate: QueryPredicate): Query<TResult, TError> | undefined;
    getQueryByHash<TResult, TError = unknown>(queryHash: string): Query<TResult, TError> | undefined;
    getQueryData<TResult>(predicate: QueryPredicate): TResult | undefined;
    removeQuery(query: Query<any, any>): void;
    removeQueries(predicate?: QueryPredicate, options?: QueryPredicateOptions): void;
    cancelQueries(predicate?: QueryPredicate, options?: QueryPredicateOptions): void;
    /**
     * @return Promise resolving to an array with the invalidated queries.
     */
    invalidateQueries(predicate?: QueryPredicate, options?: InvalidateQueriesOptions): Promise<Query<unknown, unknown>[]>;
    /**
     * @return Promise resolving to an array with the refetched queries.
     */
    refetchQueries(predicate?: QueryPredicate, options?: RefetchQueriesOptions): Promise<Query<unknown, unknown>[]>;
    resetErrorBoundaries(): void;
    buildQuery<TResult, TError = unknown>(queryKey: QueryKey, config?: QueryConfig<TResult, TError>): Query<TResult, TError>;
    createQuery<TResult, TError = unknown>(config: ResolvedQueryConfig<TResult, TError>): Query<TResult, TError>;
    fetchQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryConfig?: QueryConfig<TResult, TError>): Promise<TResult>;
    fetchQuery<TResult, TError, TArgs extends TypedQueryFunctionArgs>(queryKey: QueryKey, queryFn: TypedQueryFunction<TResult, TArgs>, queryConfig?: QueryConfig<TResult, TError>): Promise<TResult>;
    fetchQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryFn: QueryFunction<TResult>, queryConfig?: QueryConfig<TResult, TError>): Promise<TResult>;
    fetchQuery<TResult = unknown, TError = unknown>(config: FetchQueryObjectConfig<TResult, TError>): Promise<TResult>;
    prefetchQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, options?: PrefetchQueryOptions): Promise<TResult | undefined>;
    prefetchQuery<TResult, TError, TArgs extends TypedQueryFunctionArgs>(queryKey: QueryKey, queryFn: TypedQueryFunction<TResult, TArgs>, options?: PrefetchQueryOptions): Promise<TResult | undefined>;
    prefetchQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryFn: QueryFunction<TResult>, options?: PrefetchQueryOptions): Promise<TResult | undefined>;
    prefetchQuery<TResult, TError, TArgs extends TypedQueryFunctionArgs>(queryKey: QueryKey, queryFn: TypedQueryFunction<TResult, TArgs>, queryConfig: QueryConfig<TResult, TError>, options?: PrefetchQueryOptions): Promise<TResult | undefined>;
    prefetchQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryFn: QueryFunction<TResult>, queryConfig: QueryConfig<TResult, TError>, options?: PrefetchQueryOptions): Promise<TResult | undefined>;
    prefetchQuery<TResult = unknown, TError = unknown>(config: PrefetchQueryObjectConfig<TResult, TError>): Promise<TResult | undefined>;
    watchQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryConfig?: QueryConfig<TResult, TError>): QueryObserver<TResult, TError>;
    watchQuery<TResult, TError, TArgs extends TypedQueryFunctionArgs>(queryKey: QueryKey, queryFn: TypedQueryFunction<TResult, TArgs>, queryConfig?: QueryConfig<TResult, TError>): QueryObserver<TResult, TError>;
    watchQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryFn: QueryFunction<TResult>, queryConfig?: QueryConfig<TResult, TError>): QueryObserver<TResult, TError>;
    setQueryData<TResult, TError = unknown>(queryKey: QueryKey, updater: Updater<TResult | undefined, TResult>, config?: QueryConfig<TResult, TError>): void;
}
declare const defaultQueryCache: QueryCache;
export { defaultQueryCache as queryCache };
export declare const queryCaches: QueryCache[];
/**
 * @deprecated
 */
export declare function makeQueryCache(config?: QueryCacheConfig): QueryCache;
export declare function onVisibilityOrOnlineChange(type: 'focus' | 'online'): void;
