import { QueryConfig, QueryFunction, QueryKey, QueryResult, TypedQueryFunction, TypedQueryFunctionArgs } from '../core/types';
export interface UseQueryObjectConfig<TResult, TError> {
    queryKey: QueryKey;
    queryFn?: QueryFunction<TResult>;
    config?: QueryConfig<TResult, TError>;
}
export declare function useQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryConfig?: QueryConfig<TResult, TError>): QueryResult<TResult, TError>;
export declare function useQuery<TResult, TError, TArgs extends TypedQueryFunctionArgs>(queryKey: QueryKey, queryFn: TypedQueryFunction<TResult, TArgs>, queryConfig?: QueryConfig<TResult, TError>): QueryResult<TResult, TError>;
export declare function useQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryFn: QueryFunction<TResult>, queryConfig?: QueryConfig<TResult, TError>): QueryResult<TResult, TError>;
export declare function useQuery<TResult = unknown, TError = unknown>(config: UseQueryObjectConfig<TResult, TError>): QueryResult<TResult, TError>;
