// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/ec2query"
)

const opAcceptReservedInstancesExchangeQuote = "AcceptReservedInstancesExchangeQuote"

// AcceptReservedInstancesExchangeQuoteRequest generates a "aws/request.Request" representing the
// client's request for the AcceptReservedInstancesExchangeQuote operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptReservedInstancesExchangeQuote for more information on using the AcceptReservedInstancesExchangeQuote
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptReservedInstancesExchangeQuoteRequest method.
//    req, resp := client.AcceptReservedInstancesExchangeQuoteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote
func (c *EC2) AcceptReservedInstancesExchangeQuoteRequest(input *AcceptReservedInstancesExchangeQuoteInput) (req *request.Request, output *AcceptReservedInstancesExchangeQuoteOutput) {
	op := &request.Operation{
		Name:       opAcceptReservedInstancesExchangeQuote,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptReservedInstancesExchangeQuoteInput{}
	}

	output = &AcceptReservedInstancesExchangeQuoteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptReservedInstancesExchangeQuote API operation for Amazon Elastic Compute Cloud.
//
// Accepts the Convertible Reserved Instance exchange quote described in the
// GetReservedInstancesExchangeQuote call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptReservedInstancesExchangeQuote for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote
func (c *EC2) AcceptReservedInstancesExchangeQuote(input *AcceptReservedInstancesExchangeQuoteInput) (*AcceptReservedInstancesExchangeQuoteOutput, error) {
	req, out := c.AcceptReservedInstancesExchangeQuoteRequest(input)
	return out, req.Send()
}

// AcceptReservedInstancesExchangeQuoteWithContext is the same as AcceptReservedInstancesExchangeQuote with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptReservedInstancesExchangeQuote for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptReservedInstancesExchangeQuoteWithContext(ctx aws.Context, input *AcceptReservedInstancesExchangeQuoteInput, opts ...request.Option) (*AcceptReservedInstancesExchangeQuoteOutput, error) {
	req, out := c.AcceptReservedInstancesExchangeQuoteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptTransitGatewayMulticastDomainAssociations = "AcceptTransitGatewayMulticastDomainAssociations"

// AcceptTransitGatewayMulticastDomainAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the AcceptTransitGatewayMulticastDomainAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptTransitGatewayMulticastDomainAssociations for more information on using the AcceptTransitGatewayMulticastDomainAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptTransitGatewayMulticastDomainAssociationsRequest method.
//    req, resp := client.AcceptTransitGatewayMulticastDomainAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations
func (c *EC2) AcceptTransitGatewayMulticastDomainAssociationsRequest(input *AcceptTransitGatewayMulticastDomainAssociationsInput) (req *request.Request, output *AcceptTransitGatewayMulticastDomainAssociationsOutput) {
	op := &request.Operation{
		Name:       opAcceptTransitGatewayMulticastDomainAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptTransitGatewayMulticastDomainAssociationsInput{}
	}

	output = &AcceptTransitGatewayMulticastDomainAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptTransitGatewayMulticastDomainAssociations API operation for Amazon Elastic Compute Cloud.
//
// Accepts a request to associate subnets with a transit gateway multicast domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptTransitGatewayMulticastDomainAssociations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations
func (c *EC2) AcceptTransitGatewayMulticastDomainAssociations(input *AcceptTransitGatewayMulticastDomainAssociationsInput) (*AcceptTransitGatewayMulticastDomainAssociationsOutput, error) {
	req, out := c.AcceptTransitGatewayMulticastDomainAssociationsRequest(input)
	return out, req.Send()
}

// AcceptTransitGatewayMulticastDomainAssociationsWithContext is the same as AcceptTransitGatewayMulticastDomainAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptTransitGatewayMulticastDomainAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptTransitGatewayMulticastDomainAssociationsWithContext(ctx aws.Context, input *AcceptTransitGatewayMulticastDomainAssociationsInput, opts ...request.Option) (*AcceptTransitGatewayMulticastDomainAssociationsOutput, error) {
	req, out := c.AcceptTransitGatewayMulticastDomainAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptTransitGatewayPeeringAttachment = "AcceptTransitGatewayPeeringAttachment"

// AcceptTransitGatewayPeeringAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the AcceptTransitGatewayPeeringAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptTransitGatewayPeeringAttachment for more information on using the AcceptTransitGatewayPeeringAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptTransitGatewayPeeringAttachmentRequest method.
//    req, resp := client.AcceptTransitGatewayPeeringAttachmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment
func (c *EC2) AcceptTransitGatewayPeeringAttachmentRequest(input *AcceptTransitGatewayPeeringAttachmentInput) (req *request.Request, output *AcceptTransitGatewayPeeringAttachmentOutput) {
	op := &request.Operation{
		Name:       opAcceptTransitGatewayPeeringAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptTransitGatewayPeeringAttachmentInput{}
	}

	output = &AcceptTransitGatewayPeeringAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptTransitGatewayPeeringAttachment API operation for Amazon Elastic Compute Cloud.
//
// Accepts a transit gateway peering attachment request. The peering attachment
// must be in the pendingAcceptance state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptTransitGatewayPeeringAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment
func (c *EC2) AcceptTransitGatewayPeeringAttachment(input *AcceptTransitGatewayPeeringAttachmentInput) (*AcceptTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.AcceptTransitGatewayPeeringAttachmentRequest(input)
	return out, req.Send()
}

// AcceptTransitGatewayPeeringAttachmentWithContext is the same as AcceptTransitGatewayPeeringAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptTransitGatewayPeeringAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptTransitGatewayPeeringAttachmentWithContext(ctx aws.Context, input *AcceptTransitGatewayPeeringAttachmentInput, opts ...request.Option) (*AcceptTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.AcceptTransitGatewayPeeringAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptTransitGatewayVpcAttachment = "AcceptTransitGatewayVpcAttachment"

// AcceptTransitGatewayVpcAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the AcceptTransitGatewayVpcAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptTransitGatewayVpcAttachment for more information on using the AcceptTransitGatewayVpcAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptTransitGatewayVpcAttachmentRequest method.
//    req, resp := client.AcceptTransitGatewayVpcAttachmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment
func (c *EC2) AcceptTransitGatewayVpcAttachmentRequest(input *AcceptTransitGatewayVpcAttachmentInput) (req *request.Request, output *AcceptTransitGatewayVpcAttachmentOutput) {
	op := &request.Operation{
		Name:       opAcceptTransitGatewayVpcAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptTransitGatewayVpcAttachmentInput{}
	}

	output = &AcceptTransitGatewayVpcAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptTransitGatewayVpcAttachment API operation for Amazon Elastic Compute Cloud.
//
// Accepts a request to attach a VPC to a transit gateway.
//
// The VPC attachment must be in the pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments
// to view your pending VPC attachment requests. Use RejectTransitGatewayVpcAttachment
// to reject a VPC attachment request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptTransitGatewayVpcAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment
func (c *EC2) AcceptTransitGatewayVpcAttachment(input *AcceptTransitGatewayVpcAttachmentInput) (*AcceptTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.AcceptTransitGatewayVpcAttachmentRequest(input)
	return out, req.Send()
}

// AcceptTransitGatewayVpcAttachmentWithContext is the same as AcceptTransitGatewayVpcAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptTransitGatewayVpcAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptTransitGatewayVpcAttachmentWithContext(ctx aws.Context, input *AcceptTransitGatewayVpcAttachmentInput, opts ...request.Option) (*AcceptTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.AcceptTransitGatewayVpcAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptVpcEndpointConnections = "AcceptVpcEndpointConnections"

// AcceptVpcEndpointConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the AcceptVpcEndpointConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptVpcEndpointConnections for more information on using the AcceptVpcEndpointConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptVpcEndpointConnectionsRequest method.
//    req, resp := client.AcceptVpcEndpointConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections
func (c *EC2) AcceptVpcEndpointConnectionsRequest(input *AcceptVpcEndpointConnectionsInput) (req *request.Request, output *AcceptVpcEndpointConnectionsOutput) {
	op := &request.Operation{
		Name:       opAcceptVpcEndpointConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptVpcEndpointConnectionsInput{}
	}

	output = &AcceptVpcEndpointConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptVpcEndpointConnections API operation for Amazon Elastic Compute Cloud.
//
// Accepts one or more interface VPC endpoint connection requests to your VPC
// endpoint service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptVpcEndpointConnections for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections
func (c *EC2) AcceptVpcEndpointConnections(input *AcceptVpcEndpointConnectionsInput) (*AcceptVpcEndpointConnectionsOutput, error) {
	req, out := c.AcceptVpcEndpointConnectionsRequest(input)
	return out, req.Send()
}

// AcceptVpcEndpointConnectionsWithContext is the same as AcceptVpcEndpointConnections with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptVpcEndpointConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptVpcEndpointConnectionsWithContext(ctx aws.Context, input *AcceptVpcEndpointConnectionsInput, opts ...request.Option) (*AcceptVpcEndpointConnectionsOutput, error) {
	req, out := c.AcceptVpcEndpointConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptVpcPeeringConnection = "AcceptVpcPeeringConnection"

// AcceptVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AcceptVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptVpcPeeringConnection for more information on using the AcceptVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptVpcPeeringConnectionRequest method.
//    req, resp := client.AcceptVpcPeeringConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection
func (c *EC2) AcceptVpcPeeringConnectionRequest(input *AcceptVpcPeeringConnectionInput) (req *request.Request, output *AcceptVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opAcceptVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptVpcPeeringConnectionInput{}
	}

	output = &AcceptVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Accept a VPC peering connection request. To accept a request, the VPC peering
// connection must be in the pending-acceptance state, and you must be the owner
// of the peer VPC. Use DescribeVpcPeeringConnections to view your outstanding
// VPC peering connection requests.
//
// For an inter-Region VPC peering connection request, you must accept the VPC
// peering connection in the Region of the accepter VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptVpcPeeringConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection
func (c *EC2) AcceptVpcPeeringConnection(input *AcceptVpcPeeringConnectionInput) (*AcceptVpcPeeringConnectionOutput, error) {
	req, out := c.AcceptVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// AcceptVpcPeeringConnectionWithContext is the same as AcceptVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptVpcPeeringConnectionWithContext(ctx aws.Context, input *AcceptVpcPeeringConnectionInput, opts ...request.Option) (*AcceptVpcPeeringConnectionOutput, error) {
	req, out := c.AcceptVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdvertiseByoipCidr = "AdvertiseByoipCidr"

// AdvertiseByoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the AdvertiseByoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdvertiseByoipCidr for more information on using the AdvertiseByoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdvertiseByoipCidrRequest method.
//    req, resp := client.AdvertiseByoipCidrRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr
func (c *EC2) AdvertiseByoipCidrRequest(input *AdvertiseByoipCidrInput) (req *request.Request, output *AdvertiseByoipCidrOutput) {
	op := &request.Operation{
		Name:       opAdvertiseByoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdvertiseByoipCidrInput{}
	}

	output = &AdvertiseByoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdvertiseByoipCidr API operation for Amazon Elastic Compute Cloud.
//
// Advertises an IPv4 or IPv6 address range that is provisioned for use with
// your AWS resources through bring your own IP addresses (BYOIP).
//
// You can perform this operation at most once every 10 seconds, even if you
// specify different address ranges each time.
//
// We recommend that you stop advertising the BYOIP CIDR from other locations
// when you advertise it from AWS. To minimize down time, you can configure
// your AWS resources to use an address from a BYOIP CIDR before it is advertised,
// and then simultaneously stop advertising it from the current location and
// start advertising it through AWS.
//
// It can take a few minutes before traffic to the specified addresses starts
// routing to AWS because of BGP propagation delays.
//
// To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AdvertiseByoipCidr for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr
func (c *EC2) AdvertiseByoipCidr(input *AdvertiseByoipCidrInput) (*AdvertiseByoipCidrOutput, error) {
	req, out := c.AdvertiseByoipCidrRequest(input)
	return out, req.Send()
}

// AdvertiseByoipCidrWithContext is the same as AdvertiseByoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See AdvertiseByoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AdvertiseByoipCidrWithContext(ctx aws.Context, input *AdvertiseByoipCidrInput, opts ...request.Option) (*AdvertiseByoipCidrOutput, error) {
	req, out := c.AdvertiseByoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateAddress = "AllocateAddress"

// AllocateAddressRequest generates a "aws/request.Request" representing the
// client's request for the AllocateAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateAddress for more information on using the AllocateAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateAddressRequest method.
//    req, resp := client.AllocateAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress
func (c *EC2) AllocateAddressRequest(input *AllocateAddressInput) (req *request.Request, output *AllocateAddressOutput) {
	op := &request.Operation{
		Name:       opAllocateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateAddressInput{}
	}

	output = &AllocateAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateAddress API operation for Amazon Elastic Compute Cloud.
//
// Allocates an Elastic IP address to your AWS account. After you allocate the
// Elastic IP address you can associate it with an instance or network interface.
// After you release an Elastic IP address, it is released to the IP address
// pool and can be allocated to a different AWS account.
//
// You can allocate an Elastic IP address from an address pool owned by AWS
// or from an address pool created from a public IPv4 address range that you
// have brought to AWS for use with your AWS resources using bring your own
// IP addresses (BYOIP). For more information, see Bring Your Own IP Addresses
// (BYOIP) (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// [EC2-VPC] If you release an Elastic IP address, you might be able to recover
// it. You cannot recover an Elastic IP address that you released after it is
// allocated to another AWS account. You cannot recover an Elastic IP address
// for EC2-Classic. To attempt to recover an Elastic IP address that you released,
// specify it in this operation.
//
// An Elastic IP address is for use either in the EC2-Classic platform or in
// a VPC. By default, you can allocate 5 Elastic IP addresses for EC2-Classic
// per Region and 5 Elastic IP addresses for EC2-VPC per Region.
//
// For more information, see Elastic IP Addresses (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// You can allocate a carrier IP address which is a public IP address from a
// telecommunication carrier, to a network interface which resides in a subnet
// in a Wavelength Zone (for example an EC2 instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AllocateAddress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress
func (c *EC2) AllocateAddress(input *AllocateAddressInput) (*AllocateAddressOutput, error) {
	req, out := c.AllocateAddressRequest(input)
	return out, req.Send()
}

// AllocateAddressWithContext is the same as AllocateAddress with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AllocateAddressWithContext(ctx aws.Context, input *AllocateAddressInput, opts ...request.Option) (*AllocateAddressOutput, error) {
	req, out := c.AllocateAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateHosts = "AllocateHosts"

// AllocateHostsRequest generates a "aws/request.Request" representing the
// client's request for the AllocateHosts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateHosts for more information on using the AllocateHosts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateHostsRequest method.
//    req, resp := client.AllocateHostsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts
func (c *EC2) AllocateHostsRequest(input *AllocateHostsInput) (req *request.Request, output *AllocateHostsOutput) {
	op := &request.Operation{
		Name:       opAllocateHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateHostsInput{}
	}

	output = &AllocateHostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateHosts API operation for Amazon Elastic Compute Cloud.
//
// Allocates a Dedicated Host to your account. At a minimum, specify the supported
// instance type or instance family, the Availability Zone in which to allocate
// the host, and the number of hosts to allocate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AllocateHosts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts
func (c *EC2) AllocateHosts(input *AllocateHostsInput) (*AllocateHostsOutput, error) {
	req, out := c.AllocateHostsRequest(input)
	return out, req.Send()
}

// AllocateHostsWithContext is the same as AllocateHosts with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateHosts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AllocateHostsWithContext(ctx aws.Context, input *AllocateHostsInput, opts ...request.Option) (*AllocateHostsOutput, error) {
	req, out := c.AllocateHostsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplySecurityGroupsToClientVpnTargetNetwork = "ApplySecurityGroupsToClientVpnTargetNetwork"

// ApplySecurityGroupsToClientVpnTargetNetworkRequest generates a "aws/request.Request" representing the
// client's request for the ApplySecurityGroupsToClientVpnTargetNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplySecurityGroupsToClientVpnTargetNetwork for more information on using the ApplySecurityGroupsToClientVpnTargetNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplySecurityGroupsToClientVpnTargetNetworkRequest method.
//    req, resp := client.ApplySecurityGroupsToClientVpnTargetNetworkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork
func (c *EC2) ApplySecurityGroupsToClientVpnTargetNetworkRequest(input *ApplySecurityGroupsToClientVpnTargetNetworkInput) (req *request.Request, output *ApplySecurityGroupsToClientVpnTargetNetworkOutput) {
	op := &request.Operation{
		Name:       opApplySecurityGroupsToClientVpnTargetNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplySecurityGroupsToClientVpnTargetNetworkInput{}
	}

	output = &ApplySecurityGroupsToClientVpnTargetNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplySecurityGroupsToClientVpnTargetNetwork API operation for Amazon Elastic Compute Cloud.
//
// Applies a security group to the association between the target network and
// the Client VPN endpoint. This action replaces the existing security groups
// with the specified security groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ApplySecurityGroupsToClientVpnTargetNetwork for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork
func (c *EC2) ApplySecurityGroupsToClientVpnTargetNetwork(input *ApplySecurityGroupsToClientVpnTargetNetworkInput) (*ApplySecurityGroupsToClientVpnTargetNetworkOutput, error) {
	req, out := c.ApplySecurityGroupsToClientVpnTargetNetworkRequest(input)
	return out, req.Send()
}

// ApplySecurityGroupsToClientVpnTargetNetworkWithContext is the same as ApplySecurityGroupsToClientVpnTargetNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See ApplySecurityGroupsToClientVpnTargetNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) ApplySecurityGroupsToClientVpnTargetNetworkWithContext(ctx aws.Context, input *ApplySecurityGroupsToClientVpnTargetNetworkInput, opts ...request.Option) (*ApplySecurityGroupsToClientVpnTargetNetworkOutput, error) {
	req, out := c.ApplySecurityGroupsToClientVpnTargetNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssignIpv6Addresses = "AssignIpv6Addresses"

// AssignIpv6AddressesRequest generates a "aws/request.Request" representing the
// client's request for the AssignIpv6Addresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssignIpv6Addresses for more information on using the AssignIpv6Addresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssignIpv6AddressesRequest method.
//    req, resp := client.AssignIpv6AddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses
func (c *EC2) AssignIpv6AddressesRequest(input *AssignIpv6AddressesInput) (req *request.Request, output *AssignIpv6AddressesOutput) {
	op := &request.Operation{
		Name:       opAssignIpv6Addresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignIpv6AddressesInput{}
	}

	output = &AssignIpv6AddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssignIpv6Addresses API operation for Amazon Elastic Compute Cloud.
//
// Assigns one or more IPv6 addresses to the specified network interface. You
// can specify one or more specific IPv6 addresses, or you can specify the number
// of IPv6 addresses to be automatically assigned from within the subnet's IPv6
// CIDR block range. You can assign as many IPv6 addresses to a network interface
// as you can assign private IPv4 addresses, and the limit varies per instance
// type. For information, see IP Addresses Per Network Interface Per Instance
// Type (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
// in the Amazon Elastic Compute Cloud User Guide.
//
// You must specify either the IPv6 addresses or the IPv6 address count in the
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssignIpv6Addresses for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses
func (c *EC2) AssignIpv6Addresses(input *AssignIpv6AddressesInput) (*AssignIpv6AddressesOutput, error) {
	req, out := c.AssignIpv6AddressesRequest(input)
	return out, req.Send()
}

// AssignIpv6AddressesWithContext is the same as AssignIpv6Addresses with the addition of
// the ability to pass a context and additional request options.
//
// See AssignIpv6Addresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssignIpv6AddressesWithContext(ctx aws.Context, input *AssignIpv6AddressesInput, opts ...request.Option) (*AssignIpv6AddressesOutput, error) {
	req, out := c.AssignIpv6AddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssignPrivateIpAddresses = "AssignPrivateIpAddresses"

// AssignPrivateIpAddressesRequest generates a "aws/request.Request" representing the
// client's request for the AssignPrivateIpAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssignPrivateIpAddresses for more information on using the AssignPrivateIpAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssignPrivateIpAddressesRequest method.
//    req, resp := client.AssignPrivateIpAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses
func (c *EC2) AssignPrivateIpAddressesRequest(input *AssignPrivateIpAddressesInput) (req *request.Request, output *AssignPrivateIpAddressesOutput) {
	op := &request.Operation{
		Name:       opAssignPrivateIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignPrivateIpAddressesInput{}
	}

	output = &AssignPrivateIpAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssignPrivateIpAddresses API operation for Amazon Elastic Compute Cloud.
//
// Assigns one or more secondary private IP addresses to the specified network
// interface.
//
// You can specify one or more specific secondary IP addresses, or you can specify
// the number of secondary IP addresses to be automatically assigned within
// the subnet's CIDR block range. The number of secondary IP addresses that
// you can assign to an instance varies by instance type. For information about
// instance types, see Instance Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
// in the Amazon Elastic Compute Cloud User Guide. For more information about
// Elastic IP addresses, see Elastic IP Addresses (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// When you move a secondary private IP address to another network interface,
// any Elastic IP address that is associated with the IP address is also moved.
//
// Remapping an IP address is an asynchronous operation. When you move an IP
// address from one network interface to another, check network/interfaces/macs/mac/local-ipv4s
// in the instance metadata to confirm that the remapping is complete.
//
// You must specify either the IP addresses or the IP address count in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssignPrivateIpAddresses for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses
func (c *EC2) AssignPrivateIpAddresses(input *AssignPrivateIpAddressesInput) (*AssignPrivateIpAddressesOutput, error) {
	req, out := c.AssignPrivateIpAddressesRequest(input)
	return out, req.Send()
}

// AssignPrivateIpAddressesWithContext is the same as AssignPrivateIpAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See AssignPrivateIpAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssignPrivateIpAddressesWithContext(ctx aws.Context, input *AssignPrivateIpAddressesInput, opts ...request.Option) (*AssignPrivateIpAddressesOutput, error) {
	req, out := c.AssignPrivateIpAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateAddress = "AssociateAddress"

// AssociateAddressRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAddress for more information on using the AssociateAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateAddressRequest method.
//    req, resp := client.AssociateAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress
func (c *EC2) AssociateAddressRequest(input *AssociateAddressInput) (req *request.Request, output *AssociateAddressOutput) {
	op := &request.Operation{
		Name:       opAssociateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateAddressInput{}
	}

	output = &AssociateAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateAddress API operation for Amazon Elastic Compute Cloud.
//
// Associates an Elastic IP address, or carrier IP address (for instances that
// are in subnets in Wavelength Zones) with an instance or a network interface.
// Before you can use an Elastic IP address, you must allocate it to your account.
//
// An Elastic IP address is for use in either the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is
// already associated with a different instance, it is disassociated from that
// instance and associated with the specified instance. If you associate an
// Elastic IP address with an instance that has an existing Elastic IP address,
// the existing address is disassociated from the instance, but remains allocated
// to your account.
//
// [VPC in an EC2-Classic account] If you don't specify a private IP address,
// the Elastic IP address is associated with the primary IP address. If the
// Elastic IP address is already associated with a different instance or a network
// interface, you get an error unless you allow reassociation. You cannot associate
// an Elastic IP address with an instance or network interface that has an existing
// Elastic IP address.
//
// [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication
// carrier to the instance or network interface.
//
// You cannot associate an Elastic IP address with an interface in a different
// network border group.
//
// This is an idempotent operation. If you perform the operation more than once,
// Amazon EC2 doesn't return an error, and you may be charged for each time
// the Elastic IP address is remapped to the same instance. For more information,
// see the Elastic IP Addresses section of Amazon EC2 Pricing (http://aws.amazon.com/ec2/pricing/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateAddress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress
func (c *EC2) AssociateAddress(input *AssociateAddressInput) (*AssociateAddressOutput, error) {
	req, out := c.AssociateAddressRequest(input)
	return out, req.Send()
}

// AssociateAddressWithContext is the same as AssociateAddress with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateAddressWithContext(ctx aws.Context, input *AssociateAddressInput, opts ...request.Option) (*AssociateAddressOutput, error) {
	req, out := c.AssociateAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateClientVpnTargetNetwork = "AssociateClientVpnTargetNetwork"

// AssociateClientVpnTargetNetworkRequest generates a "aws/request.Request" representing the
// client's request for the AssociateClientVpnTargetNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateClientVpnTargetNetwork for more information on using the AssociateClientVpnTargetNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateClientVpnTargetNetworkRequest method.
//    req, resp := client.AssociateClientVpnTargetNetworkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork
func (c *EC2) AssociateClientVpnTargetNetworkRequest(input *AssociateClientVpnTargetNetworkInput) (req *request.Request, output *AssociateClientVpnTargetNetworkOutput) {
	op := &request.Operation{
		Name:       opAssociateClientVpnTargetNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateClientVpnTargetNetworkInput{}
	}

	output = &AssociateClientVpnTargetNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateClientVpnTargetNetwork API operation for Amazon Elastic Compute Cloud.
//
// Associates a target network with a Client VPN endpoint. A target network
// is a subnet in a VPC. You can associate multiple subnets from the same VPC
// with a Client VPN endpoint. You can associate only one subnet in each Availability
// Zone. We recommend that you associate at least two subnets to provide Availability
// Zone redundancy.
//
// If you specified a VPC when you created the Client VPN endpoint or if you
// have previous subnet associations, the specified subnet must be in the same
// VPC. To specify a subnet that's in a different VPC, you must first modify
// the Client VPN endpoint (ModifyClientVpnEndpoint) and change the VPC that's
// associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateClientVpnTargetNetwork for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork
func (c *EC2) AssociateClientVpnTargetNetwork(input *AssociateClientVpnTargetNetworkInput) (*AssociateClientVpnTargetNetworkOutput, error) {
	req, out := c.AssociateClientVpnTargetNetworkRequest(input)
	return out, req.Send()
}

// AssociateClientVpnTargetNetworkWithContext is the same as AssociateClientVpnTargetNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateClientVpnTargetNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateClientVpnTargetNetworkWithContext(ctx aws.Context, input *AssociateClientVpnTargetNetworkInput, opts ...request.Option) (*AssociateClientVpnTargetNetworkOutput, error) {
	req, out := c.AssociateClientVpnTargetNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateDhcpOptions = "AssociateDhcpOptions"

// AssociateDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDhcpOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDhcpOptions for more information on using the AssociateDhcpOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateDhcpOptionsRequest method.
//    req, resp := client.AssociateDhcpOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions
func (c *EC2) AssociateDhcpOptionsRequest(input *AssociateDhcpOptionsInput) (req *request.Request, output *AssociateDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opAssociateDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDhcpOptionsInput{}
	}

	output = &AssociateDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Associates a set of DHCP options (that you've previously created) with the
// specified VPC, or associates no DHCP options with the VPC.
//
// After you associate the options with the VPC, any existing instances and
// all new instances that you launch in that VPC use the options. You don't
// need to restart or relaunch the instances. They automatically pick up the
// changes within a few hours, depending on how frequently the instance renews
// its DHCP lease. You can explicitly renew the lease using the operating system
// on the instance.
//
// For more information, see DHCP Options Sets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateDhcpOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions
func (c *EC2) AssociateDhcpOptions(input *AssociateDhcpOptionsInput) (*AssociateDhcpOptionsOutput, error) {
	req, out := c.AssociateDhcpOptionsRequest(input)
	return out, req.Send()
}

// AssociateDhcpOptionsWithContext is the same as AssociateDhcpOptions with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDhcpOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateDhcpOptionsWithContext(ctx aws.Context, input *AssociateDhcpOptionsInput, opts ...request.Option) (*AssociateDhcpOptionsOutput, error) {
	req, out := c.AssociateDhcpOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateEnclaveCertificateIamRole = "AssociateEnclaveCertificateIamRole"

// AssociateEnclaveCertificateIamRoleRequest generates a "aws/request.Request" representing the
// client's request for the AssociateEnclaveCertificateIamRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateEnclaveCertificateIamRole for more information on using the AssociateEnclaveCertificateIamRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateEnclaveCertificateIamRoleRequest method.
//    req, resp := client.AssociateEnclaveCertificateIamRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole
func (c *EC2) AssociateEnclaveCertificateIamRoleRequest(input *AssociateEnclaveCertificateIamRoleInput) (req *request.Request, output *AssociateEnclaveCertificateIamRoleOutput) {
	op := &request.Operation{
		Name:       opAssociateEnclaveCertificateIamRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateEnclaveCertificateIamRoleInput{}
	}

	output = &AssociateEnclaveCertificateIamRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateEnclaveCertificateIamRole API operation for Amazon Elastic Compute Cloud.
//
// Associates an AWS Identity and Access Management (IAM) role with an AWS Certificate
// Manager (ACM) certificate. This enables the certificate to be used by the
// ACM for Nitro Enclaves application inside an enclave. For more information,
// see AWS Certificate Manager for Nitro Enclaves (https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html)
// in the AWS Nitro Enclaves User Guide.
//
// When the IAM role is associated with the ACM certificate, places the certificate,
// certificate chain, and encrypted private key in an Amazon S3 bucket that
// only the associated IAM role can access. The private key of the certificate
// is encrypted with an AWS-managed KMS customer master (CMK) that has an attached
// attestation-based CMK policy.
//
// To enable the IAM role to access the Amazon S3 object, you must grant it
// permission to call s3:GetObject on the Amazon S3 bucket returned by the command.
// To enable the IAM role to access the AWS KMS CMK, you must grant it permission
// to call kms:Decrypt on AWS KMS CMK returned by the command. For more information,
// see Grant the role permission to access the certificate and encryption key
// (https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy)
// in the AWS Nitro Enclaves User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateEnclaveCertificateIamRole for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole
func (c *EC2) AssociateEnclaveCertificateIamRole(input *AssociateEnclaveCertificateIamRoleInput) (*AssociateEnclaveCertificateIamRoleOutput, error) {
	req, out := c.AssociateEnclaveCertificateIamRoleRequest(input)
	return out, req.Send()
}

// AssociateEnclaveCertificateIamRoleWithContext is the same as AssociateEnclaveCertificateIamRole with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateEnclaveCertificateIamRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateEnclaveCertificateIamRoleWithContext(ctx aws.Context, input *AssociateEnclaveCertificateIamRoleInput, opts ...request.Option) (*AssociateEnclaveCertificateIamRoleOutput, error) {
	req, out := c.AssociateEnclaveCertificateIamRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateIamInstanceProfile = "AssociateIamInstanceProfile"

// AssociateIamInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIamInstanceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIamInstanceProfile for more information on using the AssociateIamInstanceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateIamInstanceProfileRequest method.
//    req, resp := client.AssociateIamInstanceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile
func (c *EC2) AssociateIamInstanceProfileRequest(input *AssociateIamInstanceProfileInput) (req *request.Request, output *AssociateIamInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opAssociateIamInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIamInstanceProfileInput{}
	}

	output = &AssociateIamInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateIamInstanceProfile API operation for Amazon Elastic Compute Cloud.
//
// Associates an IAM instance profile with a running or stopped instance. You
// cannot associate more than one IAM instance profile with an instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateIamInstanceProfile for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile
func (c *EC2) AssociateIamInstanceProfile(input *AssociateIamInstanceProfileInput) (*AssociateIamInstanceProfileOutput, error) {
	req, out := c.AssociateIamInstanceProfileRequest(input)
	return out, req.Send()
}

// AssociateIamInstanceProfileWithContext is the same as AssociateIamInstanceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIamInstanceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateIamInstanceProfileWithContext(ctx aws.Context, input *AssociateIamInstanceProfileInput, opts ...request.Option) (*AssociateIamInstanceProfileOutput, error) {
	req, out := c.AssociateIamInstanceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateRouteTable = "AssociateRouteTable"

// AssociateRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the AssociateRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateRouteTable for more information on using the AssociateRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateRouteTableRequest method.
//    req, resp := client.AssociateRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable
func (c *EC2) AssociateRouteTableRequest(input *AssociateRouteTableInput) (req *request.Request, output *AssociateRouteTableOutput) {
	op := &request.Operation{
		Name:       opAssociateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateRouteTableInput{}
	}

	output = &AssociateRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Associates a subnet in your VPC or an internet gateway or virtual private
// gateway attached to your VPC with a route table in your VPC. This association
// causes traffic from the subnet or gateway to be routed according to the routes
// in the route table. The action returns an association ID, which you need
// in order to disassociate the route table later. A route table can be associated
// with multiple subnets.
//
// For more information, see Route Tables (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable
func (c *EC2) AssociateRouteTable(input *AssociateRouteTableInput) (*AssociateRouteTableOutput, error) {
	req, out := c.AssociateRouteTableRequest(input)
	return out, req.Send()
}

// AssociateRouteTableWithContext is the same as AssociateRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateRouteTableWithContext(ctx aws.Context, input *AssociateRouteTableInput, opts ...request.Option) (*AssociateRouteTableOutput, error) {
	req, out := c.AssociateRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSubnetCidrBlock = "AssociateSubnetCidrBlock"

// AssociateSubnetCidrBlockRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSubnetCidrBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSubnetCidrBlock for more information on using the AssociateSubnetCidrBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateSubnetCidrBlockRequest method.
//    req, resp := client.AssociateSubnetCidrBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock
func (c *EC2) AssociateSubnetCidrBlockRequest(input *AssociateSubnetCidrBlockInput) (req *request.Request, output *AssociateSubnetCidrBlockOutput) {
	op := &request.Operation{
		Name:       opAssociateSubnetCidrBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSubnetCidrBlockInput{}
	}

	output = &AssociateSubnetCidrBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateSubnetCidrBlock API operation for Amazon Elastic Compute Cloud.
//
// Associates a CIDR block with your subnet. You can only associate a single
// IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a prefix length
// of /64.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateSubnetCidrBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock
func (c *EC2) AssociateSubnetCidrBlock(input *AssociateSubnetCidrBlockInput) (*AssociateSubnetCidrBlockOutput, error) {
	req, out := c.AssociateSubnetCidrBlockRequest(input)
	return out, req.Send()
}

// AssociateSubnetCidrBlockWithContext is the same as AssociateSubnetCidrBlock with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSubnetCidrBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateSubnetCidrBlockWithContext(ctx aws.Context, input *AssociateSubnetCidrBlockInput, opts ...request.Option) (*AssociateSubnetCidrBlockOutput, error) {
	req, out := c.AssociateSubnetCidrBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTransitGatewayMulticastDomain = "AssociateTransitGatewayMulticastDomain"

// AssociateTransitGatewayMulticastDomainRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTransitGatewayMulticastDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTransitGatewayMulticastDomain for more information on using the AssociateTransitGatewayMulticastDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateTransitGatewayMulticastDomainRequest method.
//    req, resp := client.AssociateTransitGatewayMulticastDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain
func (c *EC2) AssociateTransitGatewayMulticastDomainRequest(input *AssociateTransitGatewayMulticastDomainInput) (req *request.Request, output *AssociateTransitGatewayMulticastDomainOutput) {
	op := &request.Operation{
		Name:       opAssociateTransitGatewayMulticastDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTransitGatewayMulticastDomainInput{}
	}

	output = &AssociateTransitGatewayMulticastDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTransitGatewayMulticastDomain API operation for Amazon Elastic Compute Cloud.
//
// Associates the specified subnets and transit gateway attachments with the
// specified transit gateway multicast domain.
//
// The transit gateway attachment must be in the available state before you
// can add a resource. Use DescribeTransitGatewayAttachments (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html)
// to see the state of the attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateTransitGatewayMulticastDomain for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain
func (c *EC2) AssociateTransitGatewayMulticastDomain(input *AssociateTransitGatewayMulticastDomainInput) (*AssociateTransitGatewayMulticastDomainOutput, error) {
	req, out := c.AssociateTransitGatewayMulticastDomainRequest(input)
	return out, req.Send()
}

// AssociateTransitGatewayMulticastDomainWithContext is the same as AssociateTransitGatewayMulticastDomain with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTransitGatewayMulticastDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateTransitGatewayMulticastDomainWithContext(ctx aws.Context, input *AssociateTransitGatewayMulticastDomainInput, opts ...request.Option) (*AssociateTransitGatewayMulticastDomainOutput, error) {
	req, out := c.AssociateTransitGatewayMulticastDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTransitGatewayRouteTable = "AssociateTransitGatewayRouteTable"

// AssociateTransitGatewayRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTransitGatewayRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTransitGatewayRouteTable for more information on using the AssociateTransitGatewayRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateTransitGatewayRouteTableRequest method.
//    req, resp := client.AssociateTransitGatewayRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable
func (c *EC2) AssociateTransitGatewayRouteTableRequest(input *AssociateTransitGatewayRouteTableInput) (req *request.Request, output *AssociateTransitGatewayRouteTableOutput) {
	op := &request.Operation{
		Name:       opAssociateTransitGatewayRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTransitGatewayRouteTableInput{}
	}

	output = &AssociateTransitGatewayRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTransitGatewayRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Associates the specified attachment with the specified transit gateway route
// table. You can associate only one route table with an attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateTransitGatewayRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable
func (c *EC2) AssociateTransitGatewayRouteTable(input *AssociateTransitGatewayRouteTableInput) (*AssociateTransitGatewayRouteTableOutput, error) {
	req, out := c.AssociateTransitGatewayRouteTableRequest(input)
	return out, req.Send()
}

// AssociateTransitGatewayRouteTableWithContext is the same as AssociateTransitGatewayRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTransitGatewayRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateTransitGatewayRouteTableWithContext(ctx aws.Context, input *AssociateTransitGatewayRouteTableInput, opts ...request.Option) (*AssociateTransitGatewayRouteTableOutput, error) {
	req, out := c.AssociateTransitGatewayRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateVpcCidrBlock = "AssociateVpcCidrBlock"

// AssociateVpcCidrBlockRequest generates a "aws/request.Request" representing the
// client's request for the AssociateVpcCidrBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateVpcCidrBlock for more information on using the AssociateVpcCidrBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateVpcCidrBlockRequest method.
//    req, resp := client.AssociateVpcCidrBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock
func (c *EC2) AssociateVpcCidrBlockRequest(input *AssociateVpcCidrBlockInput) (req *request.Request, output *AssociateVpcCidrBlockOutput) {
	op := &request.Operation{
		Name:       opAssociateVpcCidrBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateVpcCidrBlockInput{}
	}

	output = &AssociateVpcCidrBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateVpcCidrBlock API operation for Amazon Elastic Compute Cloud.
//
// Associates a CIDR block with your VPC. You can associate a secondary IPv4
// CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from
// an IPv6 address pool that you provisioned through bring your own IP addresses
// (BYOIP (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)).
// The IPv6 CIDR block size is fixed at /56.
//
// You must specify one of the following in the request: an IPv4 CIDR block,
// an IPv6 pool, or an Amazon-provided IPv6 CIDR block.
//
// For more information about associating CIDR blocks with your VPC and applicable
// restrictions, see VPC and Subnet Sizing (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateVpcCidrBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock
func (c *EC2) AssociateVpcCidrBlock(input *AssociateVpcCidrBlockInput) (*AssociateVpcCidrBlockOutput, error) {
	req, out := c.AssociateVpcCidrBlockRequest(input)
	return out, req.Send()
}

// AssociateVpcCidrBlockWithContext is the same as AssociateVpcCidrBlock with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateVpcCidrBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateVpcCidrBlockWithContext(ctx aws.Context, input *AssociateVpcCidrBlockInput, opts ...request.Option) (*AssociateVpcCidrBlockOutput, error) {
	req, out := c.AssociateVpcCidrBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachClassicLinkVpc = "AttachClassicLinkVpc"

// AttachClassicLinkVpcRequest generates a "aws/request.Request" representing the
// client's request for the AttachClassicLinkVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachClassicLinkVpc for more information on using the AttachClassicLinkVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachClassicLinkVpcRequest method.
//    req, resp := client.AttachClassicLinkVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc
func (c *EC2) AttachClassicLinkVpcRequest(input *AttachClassicLinkVpcInput) (req *request.Request, output *AttachClassicLinkVpcOutput) {
	op := &request.Operation{
		Name:       opAttachClassicLinkVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachClassicLinkVpcInput{}
	}

	output = &AttachClassicLinkVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachClassicLinkVpc API operation for Amazon Elastic Compute Cloud.
//
// Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or
// more of the VPC's security groups. You cannot link an EC2-Classic instance
// to more than one VPC at a time. You can only link an instance that's in the
// running state. An instance is automatically unlinked from a VPC when it's
// stopped - you can link it to the VPC again when you restart it.
//
// After you've linked an instance, you cannot change the VPC security groups
// that are associated with it. To change the security groups, you must first
// unlink the instance, and then link it again.
//
// Linking your instance to a VPC is sometimes referred to as attaching your
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachClassicLinkVpc for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc
func (c *EC2) AttachClassicLinkVpc(input *AttachClassicLinkVpcInput) (*AttachClassicLinkVpcOutput, error) {
	req, out := c.AttachClassicLinkVpcRequest(input)
	return out, req.Send()
}

// AttachClassicLinkVpcWithContext is the same as AttachClassicLinkVpc with the addition of
// the ability to pass a context and additional request options.
//
// See AttachClassicLinkVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachClassicLinkVpcWithContext(ctx aws.Context, input *AttachClassicLinkVpcInput, opts ...request.Option) (*AttachClassicLinkVpcOutput, error) {
	req, out := c.AttachClassicLinkVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachInternetGateway = "AttachInternetGateway"

// AttachInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the AttachInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachInternetGateway for more information on using the AttachInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachInternetGatewayRequest method.
//    req, resp := client.AttachInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway
func (c *EC2) AttachInternetGatewayRequest(input *AttachInternetGatewayInput) (req *request.Request, output *AttachInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opAttachInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInternetGatewayInput{}
	}

	output = &AttachInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Attaches an internet gateway or a virtual private gateway to a VPC, enabling
// connectivity between the internet and the VPC. For more information about
// your VPC and internet gateway, see the Amazon Virtual Private Cloud User
// Guide (https://docs.aws.amazon.com/vpc/latest/userguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway
func (c *EC2) AttachInternetGateway(input *AttachInternetGatewayInput) (*AttachInternetGatewayOutput, error) {
	req, out := c.AttachInternetGatewayRequest(input)
	return out, req.Send()
}

// AttachInternetGatewayWithContext is the same as AttachInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See AttachInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachInternetGatewayWithContext(ctx aws.Context, input *AttachInternetGatewayInput, opts ...request.Option) (*AttachInternetGatewayOutput, error) {
	req, out := c.AttachInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachNetworkInterface = "AttachNetworkInterface"

// AttachNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AttachNetworkInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachNetworkInterface for more information on using the AttachNetworkInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachNetworkInterfaceRequest method.
//    req, resp := client.AttachNetworkInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface
func (c *EC2) AttachNetworkInterfaceRequest(input *AttachNetworkInterfaceInput) (req *request.Request, output *AttachNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opAttachNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachNetworkInterfaceInput{}
	}

	output = &AttachNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Attaches a network interface to an instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachNetworkInterface for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface
func (c *EC2) AttachNetworkInterface(input *AttachNetworkInterfaceInput) (*AttachNetworkInterfaceOutput, error) {
	req, out := c.AttachNetworkInterfaceRequest(input)
	return out, req.Send()
}

// AttachNetworkInterfaceWithContext is the same as AttachNetworkInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AttachNetworkInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachNetworkInterfaceWithContext(ctx aws.Context, input *AttachNetworkInterfaceInput, opts ...request.Option) (*AttachNetworkInterfaceOutput, error) {
	req, out := c.AttachNetworkInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachVolume = "AttachVolume"

// AttachVolumeRequest generates a "aws/request.Request" representing the
// client's request for the AttachVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachVolume for more information on using the AttachVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachVolumeRequest method.
//    req, resp := client.AttachVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume
func (c *EC2) AttachVolumeRequest(input *AttachVolumeInput) (req *request.Request, output *VolumeAttachment) {
	op := &request.Operation{
		Name:       opAttachVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVolumeInput{}
	}

	output = &VolumeAttachment{}
	req = c.newRequest(op, input, output)
	return
}

// AttachVolume API operation for Amazon Elastic Compute Cloud.
//
// Attaches an EBS volume to a running or stopped instance and exposes it to
// the instance with the specified device name.
//
// Encrypted EBS volumes must be attached to instances that support Amazon EBS
// encryption. For more information, see Amazon EBS encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// After you attach an EBS volume, you must make it available. For more information,
// see Making an EBS volume available for use (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html).
//
// If a volume has an AWS Marketplace product code:
//
//    * The volume can be attached only to a stopped instance.
//
//    * AWS Marketplace product codes are copied from the volume to the instance.
//
//    * You must be subscribed to the product.
//
//    * The instance type and operating system of the instance must support
//    the product. For example, you can't detach a volume from a Windows instance
//    and attach it to a Linux instance.
//
// For more information, see Attaching Amazon EBS volumes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachVolume for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume
func (c *EC2) AttachVolume(input *AttachVolumeInput) (*VolumeAttachment, error) {
	req, out := c.AttachVolumeRequest(input)
	return out, req.Send()
}

// AttachVolumeWithContext is the same as AttachVolume with the addition of
// the ability to pass a context and additional request options.
//
// See AttachVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachVolumeWithContext(ctx aws.Context, input *AttachVolumeInput, opts ...request.Option) (*VolumeAttachment, error) {
	req, out := c.AttachVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachVpnGateway = "AttachVpnGateway"

// AttachVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the AttachVpnGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachVpnGateway for more information on using the AttachVpnGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachVpnGatewayRequest method.
//    req, resp := client.AttachVpnGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway
func (c *EC2) AttachVpnGatewayRequest(input *AttachVpnGatewayInput) (req *request.Request, output *AttachVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opAttachVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVpnGatewayInput{}
	}

	output = &AttachVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Attaches a virtual private gateway to a VPC. You can attach one virtual private
// gateway to one VPC at a time.
//
// For more information, see AWS Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the AWS Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachVpnGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway
func (c *EC2) AttachVpnGateway(input *AttachVpnGatewayInput) (*AttachVpnGatewayOutput, error) {
	req, out := c.AttachVpnGatewayRequest(input)
	return out, req.Send()
}

// AttachVpnGatewayWithContext is the same as AttachVpnGateway with the addition of
// the ability to pass a context and additional request options.
//
// See AttachVpnGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachVpnGatewayWithContext(ctx aws.Context, input *AttachVpnGatewayInput, opts ...request.Option) (*AttachVpnGatewayOutput, error) {
	req, out := c.AttachVpnGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeClientVpnIngress = "AuthorizeClientVpnIngress"

// AuthorizeClientVpnIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeClientVpnIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeClientVpnIngress for more information on using the AuthorizeClientVpnIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeClientVpnIngressRequest method.
//    req, resp := client.AuthorizeClientVpnIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress
func (c *EC2) AuthorizeClientVpnIngressRequest(input *AuthorizeClientVpnIngressInput) (req *request.Request, output *AuthorizeClientVpnIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeClientVpnIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeClientVpnIngressInput{}
	}

	output = &AuthorizeClientVpnIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeClientVpnIngress API operation for Amazon Elastic Compute Cloud.
//
// Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization
// rules act as firewall rules that grant access to networks. You must configure
// ingress authorization rules to enable clients to access resources in AWS
// or on-premises networks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AuthorizeClientVpnIngress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress
func (c *EC2) AuthorizeClientVpnIngress(input *AuthorizeClientVpnIngressInput) (*AuthorizeClientVpnIngressOutput, error) {
	req, out := c.AuthorizeClientVpnIngressRequest(input)
	return out, req.Send()
}

// AuthorizeClientVpnIngressWithContext is the same as AuthorizeClientVpnIngress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeClientVpnIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AuthorizeClientVpnIngressWithContext(ctx aws.Context, input *AuthorizeClientVpnIngressInput, opts ...request.Option) (*AuthorizeClientVpnIngressOutput, error) {
	req, out := c.AuthorizeClientVpnIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeSecurityGroupEgress = "AuthorizeSecurityGroupEgress"

// AuthorizeSecurityGroupEgressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeSecurityGroupEgress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeSecurityGroupEgress for more information on using the AuthorizeSecurityGroupEgress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeSecurityGroupEgressRequest method.
//    req, resp := client.AuthorizeSecurityGroupEgressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress
func (c *EC2) AuthorizeSecurityGroupEgressRequest(input *AuthorizeSecurityGroupEgressInput) (req *request.Request, output *AuthorizeSecurityGroupEgressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSecurityGroupEgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSecurityGroupEgressInput{}
	}

	output = &AuthorizeSecurityGroupEgressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AuthorizeSecurityGroupEgress API operation for Amazon Elastic Compute Cloud.
//
// [VPC only] Adds the specified egress rules to a security group for use with
// a VPC.
//
// An outbound rule permits instances to send traffic to the specified IPv4
// or IPv6 CIDR address ranges, or to the instances associated with the specified
// destination security groups.
//
// You specify a protocol for each rule (for example, TCP). For the TCP and
// UDP protocols, you must also specify the destination port or port range.
// For the ICMP protocol, you must also specify the ICMP type and code. You
// can use -1 for the type or code to mean all types or all codes.
//
// Rule changes are propagated to affected instances as quickly as possible.
// However, a small delay might occur.
//
// For more information about VPC security group limits, see Amazon VPC Limits
// (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AuthorizeSecurityGroupEgress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress
func (c *EC2) AuthorizeSecurityGroupEgress(input *AuthorizeSecurityGroupEgressInput) (*AuthorizeSecurityGroupEgressOutput, error) {
	req, out := c.AuthorizeSecurityGroupEgressRequest(input)
	return out, req.Send()
}

// AuthorizeSecurityGroupEgressWithContext is the same as AuthorizeSecurityGroupEgress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeSecurityGroupEgress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AuthorizeSecurityGroupEgressWithContext(ctx aws.Context, input *AuthorizeSecurityGroupEgressInput, opts ...request.Option) (*AuthorizeSecurityGroupEgressOutput, error) {
	req, out := c.AuthorizeSecurityGroupEgressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeSecurityGroupIngress = "AuthorizeSecurityGroupIngress"

// AuthorizeSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeSecurityGroupIngress for more information on using the AuthorizeSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeSecurityGroupIngressRequest method.
//    req, resp := client.AuthorizeSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress
func (c *EC2) AuthorizeSecurityGroupIngressRequest(input *AuthorizeSecurityGroupIngressInput) (req *request.Request, output *AuthorizeSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSecurityGroupIngressInput{}
	}

	output = &AuthorizeSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AuthorizeSecurityGroupIngress API operation for Amazon Elastic Compute Cloud.
//
// Adds the specified ingress rules to a security group.
//
// An inbound rule permits instances to receive traffic from the specified IPv4
// or IPv6 CIDR address ranges, or from the instances associated with the specified
// destination security groups.
//
// You specify a protocol for each rule (for example, TCP). For TCP and UDP,
// you must also specify the destination port or port range. For ICMP/ICMPv6,
// you must also specify the ICMP/ICMPv6 type and code. You can use -1 to mean
// all types or all codes.
//
// Rule changes are propagated to instances within the security group as quickly
// as possible. However, a small delay might occur.
//
// For more information about VPC security group limits, see Amazon VPC Limits
// (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AuthorizeSecurityGroupIngress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress
func (c *EC2) AuthorizeSecurityGroupIngress(input *AuthorizeSecurityGroupIngressInput) (*AuthorizeSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// AuthorizeSecurityGroupIngressWithContext is the same as AuthorizeSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AuthorizeSecurityGroupIngressWithContext(ctx aws.Context, input *AuthorizeSecurityGroupIngressInput, opts ...request.Option) (*AuthorizeSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBundleInstance = "BundleInstance"

// BundleInstanceRequest generates a "aws/request.Request" representing the
// client's request for the BundleInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BundleInstance for more information on using the BundleInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BundleInstanceRequest method.
//    req, resp := client.BundleInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance
func (c *EC2) BundleInstanceRequest(input *BundleInstanceInput) (req *request.Request, output *BundleInstanceOutput) {
	op := &request.Operation{
		Name:       opBundleInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BundleInstanceInput{}
	}

	output = &BundleInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BundleInstance API operation for Amazon Elastic Compute Cloud.
//
// Bundles an Amazon instance store-backed Windows instance.
//
// During bundling, only the root device volume (C:\) is bundled. Data on other
// instance store volumes is not preserved.
//
// This action is not applicable for Linux/Unix instances or Windows instances
// that are backed by Amazon EBS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation BundleInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance
func (c *EC2) BundleInstance(input *BundleInstanceInput) (*BundleInstanceOutput, error) {
	req, out := c.BundleInstanceRequest(input)
	return out, req.Send()
}

// BundleInstanceWithContext is the same as BundleInstance with the addition of
// the ability to pass a context and additional request options.
//
// See BundleInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) BundleInstanceWithContext(ctx aws.Context, input *BundleInstanceInput, opts ...request.Option) (*BundleInstanceOutput, error) {
	req, out := c.BundleInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelBundleTask = "CancelBundleTask"

// CancelBundleTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelBundleTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelBundleTask for more information on using the CancelBundleTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelBundleTaskRequest method.
//    req, resp := client.CancelBundleTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask
func (c *EC2) CancelBundleTaskRequest(input *CancelBundleTaskInput) (req *request.Request, output *CancelBundleTaskOutput) {
	op := &request.Operation{
		Name:       opCancelBundleTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelBundleTaskInput{}
	}

	output = &CancelBundleTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelBundleTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels a bundling operation for an instance store-backed Windows instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelBundleTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask
func (c *EC2) CancelBundleTask(input *CancelBundleTaskInput) (*CancelBundleTaskOutput, error) {
	req, out := c.CancelBundleTaskRequest(input)
	return out, req.Send()
}

// CancelBundleTaskWithContext is the same as CancelBundleTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelBundleTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelBundleTaskWithContext(ctx aws.Context, input *CancelBundleTaskInput, opts ...request.Option) (*CancelBundleTaskOutput, error) {
	req, out := c.CancelBundleTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelCapacityReservation = "CancelCapacityReservation"

// CancelCapacityReservationRequest generates a "aws/request.Request" representing the
// client's request for the CancelCapacityReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelCapacityReservation for more information on using the CancelCapacityReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelCapacityReservationRequest method.
//    req, resp := client.CancelCapacityReservationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation
func (c *EC2) CancelCapacityReservationRequest(input *CancelCapacityReservationInput) (req *request.Request, output *CancelCapacityReservationOutput) {
	op := &request.Operation{
		Name:       opCancelCapacityReservation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelCapacityReservationInput{}
	}

	output = &CancelCapacityReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelCapacityReservation API operation for Amazon Elastic Compute Cloud.
//
// Cancels the specified Capacity Reservation, releases the reserved capacity,
// and changes the Capacity Reservation's state to cancelled.
//
// Instances running in the reserved capacity continue running until you stop
// them. Stopped instances that target the Capacity Reservation can no longer
// launch. Modify these instances to either target a different Capacity Reservation,
// launch On-Demand Instance capacity, or run in any open Capacity Reservation
// that has matching attributes and sufficient capacity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelCapacityReservation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation
func (c *EC2) CancelCapacityReservation(input *CancelCapacityReservationInput) (*CancelCapacityReservationOutput, error) {
	req, out := c.CancelCapacityReservationRequest(input)
	return out, req.Send()
}

// CancelCapacityReservationWithContext is the same as CancelCapacityReservation with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCapacityReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelCapacityReservationWithContext(ctx aws.Context, input *CancelCapacityReservationInput, opts ...request.Option) (*CancelCapacityReservationOutput, error) {
	req, out := c.CancelCapacityReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelConversionTask = "CancelConversionTask"

// CancelConversionTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelConversionTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelConversionTask for more information on using the CancelConversionTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelConversionTaskRequest method.
//    req, resp := client.CancelConversionTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask
func (c *EC2) CancelConversionTaskRequest(input *CancelConversionTaskInput) (req *request.Request, output *CancelConversionTaskOutput) {
	op := &request.Operation{
		Name:       opCancelConversionTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelConversionTaskInput{}
	}

	output = &CancelConversionTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelConversionTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels an active conversion task. The task can be the import of an instance
// or volume. The action removes all artifacts of the conversion, including
// a partially uploaded volume or instance. If the conversion is complete or
// is in the process of transferring the final disk image, the command fails
// and returns an exception.
//
// For more information, see Importing a Virtual Machine Using the Amazon EC2
// CLI (https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelConversionTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask
func (c *EC2) CancelConversionTask(input *CancelConversionTaskInput) (*CancelConversionTaskOutput, error) {
	req, out := c.CancelConversionTaskRequest(input)
	return out, req.Send()
}

// CancelConversionTaskWithContext is the same as CancelConversionTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelConversionTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelConversionTaskWithContext(ctx aws.Context, input *CancelConversionTaskInput, opts ...request.Option) (*CancelConversionTaskOutput, error) {
	req, out := c.CancelConversionTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelExportTask = "CancelExportTask"

// CancelExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelExportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelExportTask for more information on using the CancelExportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelExportTaskRequest method.
//    req, resp := client.CancelExportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask
func (c *EC2) CancelExportTaskRequest(input *CancelExportTaskInput) (req *request.Request, output *CancelExportTaskOutput) {
	op := &request.Operation{
		Name:       opCancelExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelExportTaskInput{}
	}

	output = &CancelExportTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelExportTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels an active export task. The request removes all artifacts of the export,
// including any partially-created Amazon S3 objects. If the export task is
// complete or is in the process of transferring the final disk image, the command
// fails and returns an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelExportTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask
func (c *EC2) CancelExportTask(input *CancelExportTaskInput) (*CancelExportTaskOutput, error) {
	req, out := c.CancelExportTaskRequest(input)
	return out, req.Send()
}

// CancelExportTaskWithContext is the same as CancelExportTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelExportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelExportTaskWithContext(ctx aws.Context, input *CancelExportTaskInput, opts ...request.Option) (*CancelExportTaskOutput, error) {
	req, out := c.CancelExportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelImportTask = "CancelImportTask"

// CancelImportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelImportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelImportTask for more information on using the CancelImportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelImportTaskRequest method.
//    req, resp := client.CancelImportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask
func (c *EC2) CancelImportTaskRequest(input *CancelImportTaskInput) (req *request.Request, output *CancelImportTaskOutput) {
	op := &request.Operation{
		Name:       opCancelImportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelImportTaskInput{}
	}

	output = &CancelImportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelImportTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels an in-process import virtual machine or import snapshot task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelImportTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask
func (c *EC2) CancelImportTask(input *CancelImportTaskInput) (*CancelImportTaskOutput, error) {
	req, out := c.CancelImportTaskRequest(input)
	return out, req.Send()
}

// CancelImportTaskWithContext is the same as CancelImportTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelImportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelImportTaskWithContext(ctx aws.Context, input *CancelImportTaskInput, opts ...request.Option) (*CancelImportTaskOutput, error) {
	req, out := c.CancelImportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelReservedInstancesListing = "CancelReservedInstancesListing"

// CancelReservedInstancesListingRequest generates a "aws/request.Request" representing the
// client's request for the CancelReservedInstancesListing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelReservedInstancesListing for more information on using the CancelReservedInstancesListing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelReservedInstancesListingRequest method.
//    req, resp := client.CancelReservedInstancesListingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing
func (c *EC2) CancelReservedInstancesListingRequest(input *CancelReservedInstancesListingInput) (req *request.Request, output *CancelReservedInstancesListingOutput) {
	op := &request.Operation{
		Name:       opCancelReservedInstancesListing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelReservedInstancesListingInput{}
	}

	output = &CancelReservedInstancesListingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelReservedInstancesListing API operation for Amazon Elastic Compute Cloud.
//
// Cancels the specified Reserved Instance listing in the Reserved Instance
// Marketplace.
//
// For more information, see Reserved Instance Marketplace (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelReservedInstancesListing for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing
func (c *EC2) CancelReservedInstancesListing(input *CancelReservedInstancesListingInput) (*CancelReservedInstancesListingOutput, error) {
	req, out := c.CancelReservedInstancesListingRequest(input)
	return out, req.Send()
}

// CancelReservedInstancesListingWithContext is the same as CancelReservedInstancesListing with the addition of
// the ability to pass a context and additional request options.
//
// See CancelReservedInstancesListing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelReservedInstancesListingWithContext(ctx aws.Context, input *CancelReservedInstancesListingInput, opts ...request.Option) (*CancelReservedInstancesListingOutput, error) {
	req, out := c.CancelReservedInstancesListingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSpotFleetRequests = "CancelSpotFleetRequests"

// CancelSpotFleetRequestsRequest generates a "aws/request.Request" representing the
// client's request for the CancelSpotFleetRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSpotFleetRequests for more information on using the CancelSpotFleetRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelSpotFleetRequestsRequest method.
//    req, resp := client.CancelSpotFleetRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests
func (c *EC2) CancelSpotFleetRequestsRequest(input *CancelSpotFleetRequestsInput) (req *request.Request, output *CancelSpotFleetRequestsOutput) {
	op := &request.Operation{
		Name:       opCancelSpotFleetRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelSpotFleetRequestsInput{}
	}

	output = &CancelSpotFleetRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelSpotFleetRequests API operation for Amazon Elastic Compute Cloud.
//
// Cancels the specified Spot Fleet requests.
//
// After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot
// Instances. You must specify whether the Spot Fleet should also terminate
// its Spot Instances. If you terminate the instances, the Spot Fleet request
// enters the cancelled_terminating state. Otherwise, the Spot Fleet request
// enters the cancelled_running state and the instances continue to run until
// they are interrupted or you terminate them manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelSpotFleetRequests for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests
func (c *EC2) CancelSpotFleetRequests(input *CancelSpotFleetRequestsInput) (*CancelSpotFleetRequestsOutput, error) {
	req, out := c.CancelSpotFleetRequestsRequest(input)
	return out, req.Send()
}

// CancelSpotFleetRequestsWithContext is the same as CancelSpotFleetRequests with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSpotFleetRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelSpotFleetRequestsWithContext(ctx aws.Context, input *CancelSpotFleetRequestsInput, opts ...request.Option) (*CancelSpotFleetRequestsOutput, error) {
	req, out := c.CancelSpotFleetRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSpotInstanceRequests = "CancelSpotInstanceRequests"

// CancelSpotInstanceRequestsRequest generates a "aws/request.Request" representing the
// client's request for the CancelSpotInstanceRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSpotInstanceRequests for more information on using the CancelSpotInstanceRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelSpotInstanceRequestsRequest method.
//    req, resp := client.CancelSpotInstanceRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests
func (c *EC2) CancelSpotInstanceRequestsRequest(input *CancelSpotInstanceRequestsInput) (req *request.Request, output *CancelSpotInstanceRequestsOutput) {
	op := &request.Operation{
		Name:       opCancelSpotInstanceRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelSpotInstanceRequestsInput{}
	}

	output = &CancelSpotInstanceRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelSpotInstanceRequests API operation for Amazon Elastic Compute Cloud.
//
// Cancels one or more Spot Instance requests.
//
// Canceling a Spot Instance request does not terminate running Spot Instances
// associated with the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelSpotInstanceRequests for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests
func (c *EC2) CancelSpotInstanceRequests(input *CancelSpotInstanceRequestsInput) (*CancelSpotInstanceRequestsOutput, error) {
	req, out := c.CancelSpotInstanceRequestsRequest(input)
	return out, req.Send()
}

// CancelSpotInstanceRequestsWithContext is the same as CancelSpotInstanceRequests with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSpotInstanceRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelSpotInstanceRequestsWithContext(ctx aws.Context, input *CancelSpotInstanceRequestsInput, opts ...request.Option) (*CancelSpotInstanceRequestsOutput, error) {
	req, out := c.CancelSpotInstanceRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmProductInstance = "ConfirmProductInstance"

// ConfirmProductInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmProductInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmProductInstance for more information on using the ConfirmProductInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmProductInstanceRequest method.
//    req, resp := client.ConfirmProductInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance
func (c *EC2) ConfirmProductInstanceRequest(input *ConfirmProductInstanceInput) (req *request.Request, output *ConfirmProductInstanceOutput) {
	op := &request.Operation{
		Name:       opConfirmProductInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmProductInstanceInput{}
	}

	output = &ConfirmProductInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmProductInstance API operation for Amazon Elastic Compute Cloud.
//
// Determines whether a product code is associated with an instance. This action
// can only be used by the owner of the product code. It is useful when a product
// code owner must verify whether another user's instance is eligible for support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ConfirmProductInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance
func (c *EC2) ConfirmProductInstance(input *ConfirmProductInstanceInput) (*ConfirmProductInstanceOutput, error) {
	req, out := c.ConfirmProductInstanceRequest(input)
	return out, req.Send()
}

// ConfirmProductInstanceWithContext is the same as ConfirmProductInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmProductInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) ConfirmProductInstanceWithContext(ctx aws.Context, input *ConfirmProductInstanceInput, opts ...request.Option) (*ConfirmProductInstanceOutput, error) {
	req, out := c.ConfirmProductInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyFpgaImage = "CopyFpgaImage"

// CopyFpgaImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyFpgaImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyFpgaImage for more information on using the CopyFpgaImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyFpgaImageRequest method.
//    req, resp := client.CopyFpgaImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage
func (c *EC2) CopyFpgaImageRequest(input *CopyFpgaImageInput) (req *request.Request, output *CopyFpgaImageOutput) {
	op := &request.Operation{
		Name:       opCopyFpgaImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyFpgaImageInput{}
	}

	output = &CopyFpgaImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyFpgaImage API operation for Amazon Elastic Compute Cloud.
//
// Copies the specified Amazon FPGA Image (AFI) to the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CopyFpgaImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage
func (c *EC2) CopyFpgaImage(input *CopyFpgaImageInput) (*CopyFpgaImageOutput, error) {
	req, out := c.CopyFpgaImageRequest(input)
	return out, req.Send()
}

// CopyFpgaImageWithContext is the same as CopyFpgaImage with the addition of
// the ability to pass a context and additional request options.
//
// See CopyFpgaImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CopyFpgaImageWithContext(ctx aws.Context, input *CopyFpgaImageInput, opts ...request.Option) (*CopyFpgaImageOutput, error) {
	req, out := c.CopyFpgaImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyImage = "CopyImage"

// CopyImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyImage for more information on using the CopyImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyImageRequest method.
//    req, resp := client.CopyImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage
func (c *EC2) CopyImageRequest(input *CopyImageInput) (req *request.Request, output *CopyImageOutput) {
	op := &request.Operation{
		Name:       opCopyImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyImageInput{}
	}

	output = &CopyImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyImage API operation for Amazon Elastic Compute Cloud.
//
// Initiates the copy of an AMI. You can copy an AMI from one Region to another,
// or from a Region to an AWS Outpost. You can't copy an AMI from an Outpost
// to a Region, from one Outpost to another, or within the same Outpost.
//
// To copy an AMI from one Region to another, specify the source Region using
// the SourceRegion parameter, and specify the destination Region using its
// endpoint. Copies of encrypted backing snapshots for the AMI are encrypted.
// Copies of unencrypted backing snapshots remain unencrypted, unless you set
// Encrypted during the copy operation. You cannot create an unencrypted copy
// of an encrypted backing snapshot.
//
// To copy an AMI from a Region to an Outpost, specify the source Region using
// the SourceRegion parameter, and specify the ARN of the destination Outpost
// using DestinationOutpostArn. Backing snapshots copied to an Outpost are encrypted
// by default using the default encryption key for the Region, or a different
// key that you specify in the request using KmsKeyId. Outposts do not support
// unencrypted snapshots. For more information, Amazon EBS local snapshots on
// Outposts (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information about the prerequisites and limits when copying an AMI,
// see Copying an AMI (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CopyImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage
func (c *EC2) CopyImage(input *CopyImageInput) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	return out, req.Send()
}

// CopyImageWithContext is the same as CopyImage with the addition of
// the ability to pass a context and additional request options.
//
// See CopyImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CopyImageWithContext(ctx aws.Context, input *CopyImageInput, opts ...request.Option) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopySnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopySnapshot for more information on using the CopySnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopySnapshotRequest method.
//    req, resp := client.CopySnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot
func (c *EC2) CopySnapshotRequest(input *CopySnapshotInput) (req *request.Request, output *CopySnapshotOutput) {
	op := &request.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	output = &CopySnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopySnapshot API operation for Amazon Elastic Compute Cloud.
//
// Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
// S3. You can copy a snapshot within the same Region, from one Region to another,
// or from a Region to an Outpost. You can't copy a snapshot from an Outpost
// to a Region, from one Outpost to another, or within the same Outpost.
//
// You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
//
// When copying snapshots to a Region, copies of encrypted EBS snapshots remain
// encrypted. Copies of unencrypted snapshots remain unencrypted, unless you
// enable encryption for the snapshot copy operation. By default, encrypted
// snapshot copies use the default AWS Key Management Service (AWS KMS) customer
// master key (CMK); however, you can specify a different CMK. To copy an encrypted
// snapshot that has been shared from another account, you must have permissions
// for the CMK used to encrypt the snapshot.
//
// Snapshots copied to an Outpost are encrypted by default using the default
// encryption key for the Region, or a different key that you specify in the
// request using KmsKeyId. Outposts do not support unencrypted snapshots. For
// more information, Amazon EBS local snapshots on Outposts (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Snapshots created by copying another snapshot have an arbitrary volume ID
// that should not be used for any purpose.
//
// For more information, see Copying an Amazon EBS snapshot (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CopySnapshot for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot
func (c *EC2) CopySnapshot(input *CopySnapshotInput) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	return out, req.Send()
}

// CopySnapshotWithContext is the same as CopySnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopySnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CopySnapshotWithContext(ctx aws.Context, input *CopySnapshotInput, opts ...request.Option) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCapacityReservation = "CreateCapacityReservation"

// CreateCapacityReservationRequest generates a "aws/request.Request" representing the
// client's request for the CreateCapacityReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCapacityReservation for more information on using the CreateCapacityReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCapacityReservationRequest method.
//    req, resp := client.CreateCapacityReservationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation
func (c *EC2) CreateCapacityReservationRequest(input *CreateCapacityReservationInput) (req *request.Request, output *CreateCapacityReservationOutput) {
	op := &request.Operation{
		Name:       opCreateCapacityReservation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCapacityReservationInput{}
	}

	output = &CreateCapacityReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCapacityReservation API operation for Amazon Elastic Compute Cloud.
//
// Creates a new Capacity Reservation with the specified attributes.
//
// Capacity Reservations enable you to reserve capacity for your Amazon EC2
// instances in a specific Availability Zone for any duration. This gives you
// the flexibility to selectively add capacity reservations and still get the
// Regional RI discounts for that usage. By creating Capacity Reservations,
// you ensure that you always have access to Amazon EC2 capacity when you need
// it, for as long as you need it. For more information, see Capacity Reservations
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html)
// in the Amazon EC2 User Guide.
//
// Your request to create a Capacity Reservation could fail if Amazon EC2 does
// not have sufficient capacity to fulfill the request. If your request fails
// due to Amazon EC2 capacity constraints, either try again at a later time,
// try in a different Availability Zone, or request a smaller capacity reservation.
// If your application is flexible across instance types and sizes, try to create
// a Capacity Reservation with different instance attributes.
//
// Your request could also fail if the requested quantity exceeds your On-Demand
// Instance limit for the selected instance type. If your request fails due
// to limit constraints, increase your On-Demand Instance limit for the required
// instance type and try again. For more information about increasing your instance
// limits, see Amazon EC2 Service Quotas (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCapacityReservation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation
func (c *EC2) CreateCapacityReservation(input *CreateCapacityReservationInput) (*CreateCapacityReservationOutput, error) {
	req, out := c.CreateCapacityReservationRequest(input)
	return out, req.Send()
}

// CreateCapacityReservationWithContext is the same as CreateCapacityReservation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCapacityReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateCapacityReservationWithContext(ctx aws.Context, input *CreateCapacityReservationInput, opts ...request.Option) (*CreateCapacityReservationOutput, error) {
	req, out := c.CreateCapacityReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCarrierGateway = "CreateCarrierGateway"

// CreateCarrierGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateCarrierGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCarrierGateway for more information on using the CreateCarrierGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCarrierGatewayRequest method.
//    req, resp := client.CreateCarrierGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway
func (c *EC2) CreateCarrierGatewayRequest(input *CreateCarrierGatewayInput) (req *request.Request, output *CreateCarrierGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateCarrierGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCarrierGatewayInput{}
	}

	output = &CreateCarrierGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCarrierGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a carrier gateway. For more information about carrier gateways, see
// Carrier gateways (https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway)
// in the AWS Wavelength Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCarrierGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway
func (c *EC2) CreateCarrierGateway(input *CreateCarrierGatewayInput) (*CreateCarrierGatewayOutput, error) {
	req, out := c.CreateCarrierGatewayRequest(input)
	return out, req.Send()
}

// CreateCarrierGatewayWithContext is the same as CreateCarrierGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCarrierGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateCarrierGatewayWithContext(ctx aws.Context, input *CreateCarrierGatewayInput, opts ...request.Option) (*CreateCarrierGatewayOutput, error) {
	req, out := c.CreateCarrierGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClientVpnEndpoint = "CreateClientVpnEndpoint"

// CreateClientVpnEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateClientVpnEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClientVpnEndpoint for more information on using the CreateClientVpnEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClientVpnEndpointRequest method.
//    req, resp := client.CreateClientVpnEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint
func (c *EC2) CreateClientVpnEndpointRequest(input *CreateClientVpnEndpointInput) (req *request.Request, output *CreateClientVpnEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateClientVpnEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClientVpnEndpointInput{}
	}

	output = &CreateClientVpnEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClientVpnEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Creates a Client VPN endpoint. A Client VPN endpoint is the resource you
// create and configure to enable and manage client VPN sessions. It is the
// destination endpoint at which all client VPN sessions are terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateClientVpnEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint
func (c *EC2) CreateClientVpnEndpoint(input *CreateClientVpnEndpointInput) (*CreateClientVpnEndpointOutput, error) {
	req, out := c.CreateClientVpnEndpointRequest(input)
	return out, req.Send()
}

// CreateClientVpnEndpointWithContext is the same as CreateClientVpnEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClientVpnEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateClientVpnEndpointWithContext(ctx aws.Context, input *CreateClientVpnEndpointInput, opts ...request.Option) (*CreateClientVpnEndpointOutput, error) {
	req, out := c.CreateClientVpnEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClientVpnRoute = "CreateClientVpnRoute"

// CreateClientVpnRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateClientVpnRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClientVpnRoute for more information on using the CreateClientVpnRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClientVpnRouteRequest method.
//    req, resp := client.CreateClientVpnRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute
func (c *EC2) CreateClientVpnRouteRequest(input *CreateClientVpnRouteInput) (req *request.Request, output *CreateClientVpnRouteOutput) {
	op := &request.Operation{
		Name:       opCreateClientVpnRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClientVpnRouteInput{}
	}

	output = &CreateClientVpnRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClientVpnRoute API operation for Amazon Elastic Compute Cloud.
//
// Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint
// has a route table that describes the available destination network routes.
// Each route in the route table specifies the path for traﬃc to speciﬁc
// resources or networks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateClientVpnRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute
func (c *EC2) CreateClientVpnRoute(input *CreateClientVpnRouteInput) (*CreateClientVpnRouteOutput, error) {
	req, out := c.CreateClientVpnRouteRequest(input)
	return out, req.Send()
}

// CreateClientVpnRouteWithContext is the same as CreateClientVpnRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClientVpnRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateClientVpnRouteWithContext(ctx aws.Context, input *CreateClientVpnRouteInput, opts ...request.Option) (*CreateClientVpnRouteOutput, error) {
	req, out := c.CreateClientVpnRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomerGateway = "CreateCustomerGateway"

// CreateCustomerGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomerGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomerGateway for more information on using the CreateCustomerGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCustomerGatewayRequest method.
//    req, resp := client.CreateCustomerGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway
func (c *EC2) CreateCustomerGatewayRequest(input *CreateCustomerGatewayInput) (req *request.Request, output *CreateCustomerGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateCustomerGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomerGatewayInput{}
	}

	output = &CreateCustomerGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomerGateway API operation for Amazon Elastic Compute Cloud.
//
// Provides information to AWS about your VPN customer gateway device. The customer
// gateway is the appliance at your end of the VPN connection. (The device on
// the AWS side of the VPN connection is the virtual private gateway.) You must
// provide the internet-routable IP address of the customer gateway's external
// interface. The IP address must be static and can be behind a device performing
// network address translation (NAT).
//
// For devices that use Border Gateway Protocol (BGP), you can also provide
// the device's BGP Autonomous System Number (ASN). You can use an existing
// ASN assigned to your network. If you don't have an ASN already, you can use
// a private ASN (in the 64512 - 65534 range).
//
// Amazon EC2 supports all 4-byte ASN numbers in the range of 1 - 2147483647,
// with the exception of the following:
//
//    * 7224 - reserved in the us-east-1 Region
//
//    * 9059 - reserved in the eu-west-1 Region
//
//    * 17943 - reserved in the ap-southeast-1 Region
//
//    * 10124 - reserved in the ap-northeast-1 Region
//
// For more information, see AWS Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the AWS Site-to-Site VPN User Guide.
//
// To create more than one customer gateway with the same VPN type, IP address,
// and BGP ASN, specify a unique device name for each customer gateway. Identical
// requests return information about the existing customer gateway and do not
// create new customer gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCustomerGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway
func (c *EC2) CreateCustomerGateway(input *CreateCustomerGatewayInput) (*CreateCustomerGatewayOutput, error) {
	req, out := c.CreateCustomerGatewayRequest(input)
	return out, req.Send()
}

// CreateCustomerGatewayWithContext is the same as CreateCustomerGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomerGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateCustomerGatewayWithContext(ctx aws.Context, input *CreateCustomerGatewayInput, opts ...request.Option) (*CreateCustomerGatewayOutput, error) {
	req, out := c.CreateCustomerGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDefaultSubnet = "CreateDefaultSubnet"

// CreateDefaultSubnetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDefaultSubnet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDefaultSubnet for more information on using the CreateDefaultSubnet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDefaultSubnetRequest method.
//    req, resp := client.CreateDefaultSubnetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet
func (c *EC2) CreateDefaultSubnetRequest(input *CreateDefaultSubnetInput) (req *request.Request, output *CreateDefaultSubnetOutput) {
	op := &request.Operation{
		Name:       opCreateDefaultSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDefaultSubnetInput{}
	}

	output = &CreateDefaultSubnetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDefaultSubnet API operation for Amazon Elastic Compute Cloud.
//
// Creates a default subnet with a size /20 IPv4 CIDR block in the specified
// Availability Zone in your default VPC. You can have only one default subnet
// per Availability Zone. For more information, see Creating a Default Subnet
// (https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateDefaultSubnet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet
func (c *EC2) CreateDefaultSubnet(input *CreateDefaultSubnetInput) (*CreateDefaultSubnetOutput, error) {
	req, out := c.CreateDefaultSubnetRequest(input)
	return out, req.Send()
}

// CreateDefaultSubnetWithContext is the same as CreateDefaultSubnet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDefaultSubnet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateDefaultSubnetWithContext(ctx aws.Context, input *CreateDefaultSubnetInput, opts ...request.Option) (*CreateDefaultSubnetOutput, error) {
	req, out := c.CreateDefaultSubnetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDefaultVpc = "CreateDefaultVpc"

// CreateDefaultVpcRequest generates a "aws/request.Request" representing the
// client's request for the CreateDefaultVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDefaultVpc for more information on using the CreateDefaultVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDefaultVpcRequest method.
//    req, resp := client.CreateDefaultVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc
func (c *EC2) CreateDefaultVpcRequest(input *CreateDefaultVpcInput) (req *request.Request, output *CreateDefaultVpcOutput) {
	op := &request.Operation{
		Name:       opCreateDefaultVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDefaultVpcInput{}
	}

	output = &CreateDefaultVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDefaultVpc API operation for Amazon Elastic Compute Cloud.
//
// Creates a default VPC with a size /16 IPv4 CIDR block and a default subnet
// in each Availability Zone. For more information about the components of a
// default VPC, see Default VPC and Default Subnets (https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html)
// in the Amazon Virtual Private Cloud User Guide. You cannot specify the components
// of the default VPC yourself.
//
// If you deleted your previous default VPC, you can create a default VPC. You
// cannot have more than one default VPC per Region.
//
// If your account supports EC2-Classic, you cannot use this action to create
// a default VPC in a Region that supports EC2-Classic. If you want a default
// VPC in a Region that supports EC2-Classic, see "I really want a default VPC
// for my existing EC2 account. Is that possible?" in the Default VPCs FAQ (http://aws.amazon.com/vpc/faqs/#Default_VPCs).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateDefaultVpc for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc
func (c *EC2) CreateDefaultVpc(input *CreateDefaultVpcInput) (*CreateDefaultVpcOutput, error) {
	req, out := c.CreateDefaultVpcRequest(input)
	return out, req.Send()
}

// CreateDefaultVpcWithContext is the same as CreateDefaultVpc with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDefaultVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateDefaultVpcWithContext(ctx aws.Context, input *CreateDefaultVpcInput, opts ...request.Option) (*CreateDefaultVpcOutput, error) {
	req, out := c.CreateDefaultVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDhcpOptions = "CreateDhcpOptions"

// CreateDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the CreateDhcpOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDhcpOptions for more information on using the CreateDhcpOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDhcpOptionsRequest method.
//    req, resp := client.CreateDhcpOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions
func (c *EC2) CreateDhcpOptionsRequest(input *CreateDhcpOptionsInput) (req *request.Request, output *CreateDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opCreateDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDhcpOptionsInput{}
	}

	output = &CreateDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Creates a set of DHCP options for your VPC. After creating the set, you must
// associate it with the VPC, causing all existing and new instances that you
// launch in the VPC to use this set of DHCP options. The following are the
// individual DHCP options you can specify. For more information about the options,
// see RFC 2132 (http://www.ietf.org/rfc/rfc2132.txt).
//
//    * domain-name-servers - The IP addresses of up to four domain name servers,
//    or AmazonProvidedDNS. The default DHCP option set specifies AmazonProvidedDNS.
//    If specifying more than one domain name server, specify the IP addresses
//    in a single parameter, separated by commas. To have your instance receive
//    a custom DNS hostname as specified in domain-name, you must set domain-name-servers
//    to a custom DNS server.
//
//    * domain-name - If you're using AmazonProvidedDNS in us-east-1, specify
//    ec2.internal. If you're using AmazonProvidedDNS in another Region, specify
//    region.compute.internal (for example, ap-northeast-1.compute.internal).
//    Otherwise, specify a domain name (for example, ExampleCompany.com). This
//    value is used to complete unqualified DNS hostnames. Important: Some Linux
//    operating systems accept multiple domain names separated by spaces. However,
//    Windows and other Linux operating systems treat the value as a single
//    domain, which results in unexpected behavior. If your DHCP options set
//    is associated with a VPC that has instances with multiple operating systems,
//    specify only one domain name.
//
//    * ntp-servers - The IP addresses of up to four Network Time Protocol (NTP)
//    servers.
//
//    * netbios-name-servers - The IP addresses of up to four NetBIOS name servers.
//
//    * netbios-node-type - The NetBIOS node type (1, 2, 4, or 8). We recommend
//    that you specify 2 (broadcast and multicast are not currently supported).
//    For more information about these node types, see RFC 2132 (http://www.ietf.org/rfc/rfc2132.txt).
//
// Your VPC automatically starts out with a set of DHCP options that includes
// only a DNS server that we provide (AmazonProvidedDNS). If you create a set
// of options, and if your VPC has an internet gateway, make sure to set the
// domain-name-servers option either to AmazonProvidedDNS or to a domain name
// server of your choice. For more information, see DHCP Options Sets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateDhcpOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions
func (c *EC2) CreateDhcpOptions(input *CreateDhcpOptionsInput) (*CreateDhcpOptionsOutput, error) {
	req, out := c.CreateDhcpOptionsRequest(input)
	return out, req.Send()
}

// CreateDhcpOptionsWithContext is the same as CreateDhcpOptions with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDhcpOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateDhcpOptionsWithContext(ctx aws.Context, input *CreateDhcpOptionsInput, opts ...request.Option) (*CreateDhcpOptionsOutput, error) {
	req, out := c.CreateDhcpOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEgressOnlyInternetGateway = "CreateEgressOnlyInternetGateway"

// CreateEgressOnlyInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateEgressOnlyInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEgressOnlyInternetGateway for more information on using the CreateEgressOnlyInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEgressOnlyInternetGatewayRequest method.
//    req, resp := client.CreateEgressOnlyInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway
func (c *EC2) CreateEgressOnlyInternetGatewayRequest(input *CreateEgressOnlyInternetGatewayInput) (req *request.Request, output *CreateEgressOnlyInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateEgressOnlyInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEgressOnlyInternetGatewayInput{}
	}

	output = &CreateEgressOnlyInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEgressOnlyInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only
// internet gateway is used to enable outbound communication over IPv6 from
// instances in your VPC to the internet, and prevents hosts outside of your
// VPC from initiating an IPv6 connection with your instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateEgressOnlyInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway
func (c *EC2) CreateEgressOnlyInternetGateway(input *CreateEgressOnlyInternetGatewayInput) (*CreateEgressOnlyInternetGatewayOutput, error) {
	req, out := c.CreateEgressOnlyInternetGatewayRequest(input)
	return out, req.Send()
}

// CreateEgressOnlyInternetGatewayWithContext is the same as CreateEgressOnlyInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEgressOnlyInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateEgressOnlyInternetGatewayWithContext(ctx aws.Context, input *CreateEgressOnlyInternetGatewayInput, opts ...request.Option) (*CreateEgressOnlyInternetGatewayOutput, error) {
	req, out := c.CreateEgressOnlyInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFleetRequest method.
//    req, resp := client.CreateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet
func (c *EC2) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for Amazon Elastic Compute Cloud.
//
// Launches an EC2 Fleet.
//
// You can create a single EC2 Fleet that includes multiple launch specifications
// that vary by instance type, AMI, Availability Zone, or subnet.
//
// For more information, see Launching an EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateFleet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet
func (c *EC2) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlowLogs = "CreateFlowLogs"

// CreateFlowLogsRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlowLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlowLogs for more information on using the CreateFlowLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFlowLogsRequest method.
//    req, resp := client.CreateFlowLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs
func (c *EC2) CreateFlowLogsRequest(input *CreateFlowLogsInput) (req *request.Request, output *CreateFlowLogsOutput) {
	op := &request.Operation{
		Name:       opCreateFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFlowLogsInput{}
	}

	output = &CreateFlowLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlowLogs API operation for Amazon Elastic Compute Cloud.
//
// Creates one or more flow logs to capture information about IP traffic for
// a specific network interface, subnet, or VPC.
//
// Flow log data for a monitored network interface is recorded as flow log records,
// which are log events consisting of fields that describe the traffic flow.
// For more information, see Flow Log Records (https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records)
// in the Amazon Virtual Private Cloud User Guide.
//
// When publishing to CloudWatch Logs, flow log records are published to a log
// group, and each network interface has a unique log stream in the log group.
// When publishing to Amazon S3, flow log records for all of the monitored network
// interfaces are published to a single log file object that is stored in the
// specified bucket.
//
// For more information, see VPC Flow Logs (https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateFlowLogs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs
func (c *EC2) CreateFlowLogs(input *CreateFlowLogsInput) (*CreateFlowLogsOutput, error) {
	req, out := c.CreateFlowLogsRequest(input)
	return out, req.Send()
}

// CreateFlowLogsWithContext is the same as CreateFlowLogs with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlowLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateFlowLogsWithContext(ctx aws.Context, input *CreateFlowLogsInput, opts ...request.Option) (*CreateFlowLogsOutput, error) {
	req, out := c.CreateFlowLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFpgaImage = "CreateFpgaImage"

// CreateFpgaImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateFpgaImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFpgaImage for more information on using the CreateFpgaImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFpgaImageRequest method.
//    req, resp := client.CreateFpgaImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage
func (c *EC2) CreateFpgaImageRequest(input *CreateFpgaImageInput) (req *request.Request, output *CreateFpgaImageOutput) {
	op := &request.Operation{
		Name:       opCreateFpgaImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFpgaImageInput{}
	}

	output = &CreateFpgaImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFpgaImage API operation for Amazon Elastic Compute Cloud.
//
// Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
//
// The create operation is asynchronous. To verify that the AFI is ready for
// use, check the output logs.
//
// An AFI contains the FPGA bitstream that is ready to download to an FPGA.
// You can securely deploy an AFI on multiple FPGA-accelerated instances. For
// more information, see the AWS FPGA Hardware Development Kit (https://github.com/aws/aws-fpga/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateFpgaImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage
func (c *EC2) CreateFpgaImage(input *CreateFpgaImageInput) (*CreateFpgaImageOutput, error) {
	req, out := c.CreateFpgaImageRequest(input)
	return out, req.Send()
}

// CreateFpgaImageWithContext is the same as CreateFpgaImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFpgaImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateFpgaImageWithContext(ctx aws.Context, input *CreateFpgaImageInput, opts ...request.Option) (*CreateFpgaImageOutput, error) {
	req, out := c.CreateFpgaImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImage = "CreateImage"

// CreateImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImage for more information on using the CreateImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImageRequest method.
//    req, resp := client.CreateImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage
func (c *EC2) CreateImageRequest(input *CreateImageInput) (req *request.Request, output *CreateImageOutput) {
	op := &request.Operation{
		Name:       opCreateImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageInput{}
	}

	output = &CreateImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImage API operation for Amazon Elastic Compute Cloud.
//
// Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
// is either running or stopped.
//
// If you customized your instance with instance store volumes or EBS volumes
// in addition to the root device volume, the new AMI contains block device
// mapping information for those volumes. When you launch an instance from this
// new AMI, the instance automatically launches with those additional volumes.
//
// For more information, see Creating Amazon EBS-Backed Linux AMIs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage
func (c *EC2) CreateImage(input *CreateImageInput) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	return out, req.Send()
}

// CreateImageWithContext is the same as CreateImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateImageWithContext(ctx aws.Context, input *CreateImageInput, opts ...request.Option) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceExportTask = "CreateInstanceExportTask"

// CreateInstanceExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceExportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceExportTask for more information on using the CreateInstanceExportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstanceExportTaskRequest method.
//    req, resp := client.CreateInstanceExportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask
func (c *EC2) CreateInstanceExportTaskRequest(input *CreateInstanceExportTaskInput) (req *request.Request, output *CreateInstanceExportTaskOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceExportTaskInput{}
	}

	output = &CreateInstanceExportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceExportTask API operation for Amazon Elastic Compute Cloud.
//
// Exports a running or stopped instance to an Amazon S3 bucket.
//
// For information about the supported operating systems, image formats, and
// known limitations for the types of instances you can export, see Exporting
// an Instance as a VM Using VM Import/Export (https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html)
// in the VM Import/Export User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateInstanceExportTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask
func (c *EC2) CreateInstanceExportTask(input *CreateInstanceExportTaskInput) (*CreateInstanceExportTaskOutput, error) {
	req, out := c.CreateInstanceExportTaskRequest(input)
	return out, req.Send()
}

// CreateInstanceExportTaskWithContext is the same as CreateInstanceExportTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceExportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateInstanceExportTaskWithContext(ctx aws.Context, input *CreateInstanceExportTaskInput, opts ...request.Option) (*CreateInstanceExportTaskOutput, error) {
	req, out := c.CreateInstanceExportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInternetGateway = "CreateInternetGateway"

// CreateInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInternetGateway for more information on using the CreateInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInternetGatewayRequest method.
//    req, resp := client.CreateInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway
func (c *EC2) CreateInternetGatewayRequest(input *CreateInternetGatewayInput) (req *request.Request, output *CreateInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInternetGatewayInput{}
	}

	output = &CreateInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates an internet gateway for use with a VPC. After creating the internet
// gateway, you attach it to a VPC using AttachInternetGateway.
//
// For more information about your VPC and internet gateway, see the Amazon
// Virtual Private Cloud User Guide (https://docs.aws.amazon.com/vpc/latest/userguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway
func (c *EC2) CreateInternetGateway(input *CreateInternetGatewayInput) (*CreateInternetGatewayOutput, error) {
	req, out := c.CreateInternetGatewayRequest(input)
	return out, req.Send()
}

// CreateInternetGatewayWithContext is the same as CreateInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateInternetGatewayWithContext(ctx aws.Context, input *CreateInternetGatewayInput, opts ...request.Option) (*CreateInternetGatewayOutput, error) {
	req, out := c.CreateInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeyPair = "CreateKeyPair"

// CreateKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeyPair for more information on using the CreateKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateKeyPairRequest method.
//    req, resp := client.CreateKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair
func (c *EC2) CreateKeyPairRequest(input *CreateKeyPairInput) (req *request.Request, output *CreateKeyPairOutput) {
	op := &request.Operation{
		Name:       opCreateKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyPairInput{}
	}

	output = &CreateKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeyPair API operation for Amazon Elastic Compute Cloud.
//
// Creates a 2048-bit RSA key pair with the specified name. Amazon EC2 stores
// the public key and displays the private key for you to save to a file. The
// private key is returned as an unencrypted PEM encoded PKCS#1 private key.
// If a key with the specified name already exists, Amazon EC2 returns an error.
//
// You can have up to five thousand key pairs per Region.
//
// The key pair returned to you is available only in the Region in which you
// create it. If you prefer, you can create your own key pair using a third-party
// tool and upload it to any Region using ImportKeyPair.
//
// For more information, see Key Pairs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateKeyPair for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair
func (c *EC2) CreateKeyPair(input *CreateKeyPairInput) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	return out, req.Send()
}

// CreateKeyPairWithContext is the same as CreateKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateKeyPairWithContext(ctx aws.Context, input *CreateKeyPairInput, opts ...request.Option) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLaunchTemplate = "CreateLaunchTemplate"

// CreateLaunchTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateLaunchTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLaunchTemplate for more information on using the CreateLaunchTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLaunchTemplateRequest method.
//    req, resp := client.CreateLaunchTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate
func (c *EC2) CreateLaunchTemplateRequest(input *CreateLaunchTemplateInput) (req *request.Request, output *CreateLaunchTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateLaunchTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLaunchTemplateInput{}
	}

	output = &CreateLaunchTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLaunchTemplate API operation for Amazon Elastic Compute Cloud.
//
// Creates a launch template. A launch template contains the parameters to launch
// an instance. When you launch an instance using RunInstances, you can specify
// a launch template instead of providing the launch parameters in the request.
// For more information, see Launching an instance from a launch template (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html)in
// the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLaunchTemplate for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate
func (c *EC2) CreateLaunchTemplate(input *CreateLaunchTemplateInput) (*CreateLaunchTemplateOutput, error) {
	req, out := c.CreateLaunchTemplateRequest(input)
	return out, req.Send()
}

// CreateLaunchTemplateWithContext is the same as CreateLaunchTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLaunchTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLaunchTemplateWithContext(ctx aws.Context, input *CreateLaunchTemplateInput, opts ...request.Option) (*CreateLaunchTemplateOutput, error) {
	req, out := c.CreateLaunchTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLaunchTemplateVersion = "CreateLaunchTemplateVersion"

// CreateLaunchTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateLaunchTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLaunchTemplateVersion for more information on using the CreateLaunchTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLaunchTemplateVersionRequest method.
//    req, resp := client.CreateLaunchTemplateVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion
func (c *EC2) CreateLaunchTemplateVersionRequest(input *CreateLaunchTemplateVersionInput) (req *request.Request, output *CreateLaunchTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opCreateLaunchTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLaunchTemplateVersionInput{}
	}

	output = &CreateLaunchTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLaunchTemplateVersion API operation for Amazon Elastic Compute Cloud.
//
// Creates a new version for a launch template. You can specify an existing
// version of launch template from which to base the new version.
//
// Launch template versions are numbered in the order in which they are created.
// You cannot specify, change, or replace the numbering of launch template versions.
//
// For more information, see Managing launch template versions (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions)in
// the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLaunchTemplateVersion for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion
func (c *EC2) CreateLaunchTemplateVersion(input *CreateLaunchTemplateVersionInput) (*CreateLaunchTemplateVersionOutput, error) {
	req, out := c.CreateLaunchTemplateVersionRequest(input)
	return out, req.Send()
}

// CreateLaunchTemplateVersionWithContext is the same as CreateLaunchTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLaunchTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLaunchTemplateVersionWithContext(ctx aws.Context, input *CreateLaunchTemplateVersionInput, opts ...request.Option) (*CreateLaunchTemplateVersionOutput, error) {
	req, out := c.CreateLaunchTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocalGatewayRoute = "CreateLocalGatewayRoute"

// CreateLocalGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocalGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocalGatewayRoute for more information on using the CreateLocalGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLocalGatewayRouteRequest method.
//    req, resp := client.CreateLocalGatewayRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute
func (c *EC2) CreateLocalGatewayRouteRequest(input *CreateLocalGatewayRouteInput) (req *request.Request, output *CreateLocalGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opCreateLocalGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocalGatewayRouteInput{}
	}

	output = &CreateLocalGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocalGatewayRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a static route for the specified local gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLocalGatewayRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute
func (c *EC2) CreateLocalGatewayRoute(input *CreateLocalGatewayRouteInput) (*CreateLocalGatewayRouteOutput, error) {
	req, out := c.CreateLocalGatewayRouteRequest(input)
	return out, req.Send()
}

// CreateLocalGatewayRouteWithContext is the same as CreateLocalGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocalGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLocalGatewayRouteWithContext(ctx aws.Context, input *CreateLocalGatewayRouteInput, opts ...request.Option) (*CreateLocalGatewayRouteOutput, error) {
	req, out := c.CreateLocalGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocalGatewayRouteTableVpcAssociation = "CreateLocalGatewayRouteTableVpcAssociation"

// CreateLocalGatewayRouteTableVpcAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocalGatewayRouteTableVpcAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocalGatewayRouteTableVpcAssociation for more information on using the CreateLocalGatewayRouteTableVpcAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLocalGatewayRouteTableVpcAssociationRequest method.
//    req, resp := client.CreateLocalGatewayRouteTableVpcAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation
func (c *EC2) CreateLocalGatewayRouteTableVpcAssociationRequest(input *CreateLocalGatewayRouteTableVpcAssociationInput) (req *request.Request, output *CreateLocalGatewayRouteTableVpcAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateLocalGatewayRouteTableVpcAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocalGatewayRouteTableVpcAssociationInput{}
	}

	output = &CreateLocalGatewayRouteTableVpcAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocalGatewayRouteTableVpcAssociation API operation for Amazon Elastic Compute Cloud.
//
// Associates the specified VPC with the specified local gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLocalGatewayRouteTableVpcAssociation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation
func (c *EC2) CreateLocalGatewayRouteTableVpcAssociation(input *CreateLocalGatewayRouteTableVpcAssociationInput) (*CreateLocalGatewayRouteTableVpcAssociationOutput, error) {
	req, out := c.CreateLocalGatewayRouteTableVpcAssociationRequest(input)
	return out, req.Send()
}

// CreateLocalGatewayRouteTableVpcAssociationWithContext is the same as CreateLocalGatewayRouteTableVpcAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocalGatewayRouteTableVpcAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLocalGatewayRouteTableVpcAssociationWithContext(ctx aws.Context, input *CreateLocalGatewayRouteTableVpcAssociationInput, opts ...request.Option) (*CreateLocalGatewayRouteTableVpcAssociationOutput, error) {
	req, out := c.CreateLocalGatewayRouteTableVpcAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateManagedPrefixList = "CreateManagedPrefixList"

// CreateManagedPrefixListRequest generates a "aws/request.Request" representing the
// client's request for the CreateManagedPrefixList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateManagedPrefixList for more information on using the CreateManagedPrefixList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateManagedPrefixListRequest method.
//    req, resp := client.CreateManagedPrefixListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList
func (c *EC2) CreateManagedPrefixListRequest(input *CreateManagedPrefixListInput) (req *request.Request, output *CreateManagedPrefixListOutput) {
	op := &request.Operation{
		Name:       opCreateManagedPrefixList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateManagedPrefixListInput{}
	}

	output = &CreateManagedPrefixListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateManagedPrefixList API operation for Amazon Elastic Compute Cloud.
//
// Creates a managed prefix list. You can specify one or more entries for the
// prefix list. Each entry consists of a CIDR block and an optional description.
//
// You must specify the maximum number of entries for the prefix list. The maximum
// number of entries cannot be changed later.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateManagedPrefixList for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList
func (c *EC2) CreateManagedPrefixList(input *CreateManagedPrefixListInput) (*CreateManagedPrefixListOutput, error) {
	req, out := c.CreateManagedPrefixListRequest(input)
	return out, req.Send()
}

// CreateManagedPrefixListWithContext is the same as CreateManagedPrefixList with the addition of
// the ability to pass a context and additional request options.
//
// See CreateManagedPrefixList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateManagedPrefixListWithContext(ctx aws.Context, input *CreateManagedPrefixListInput, opts ...request.Option) (*CreateManagedPrefixListOutput, error) {
	req, out := c.CreateManagedPrefixListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNatGateway = "CreateNatGateway"

// CreateNatGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateNatGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNatGateway for more information on using the CreateNatGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNatGatewayRequest method.
//    req, resp := client.CreateNatGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway
func (c *EC2) CreateNatGatewayRequest(input *CreateNatGatewayInput) (req *request.Request, output *CreateNatGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateNatGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNatGatewayInput{}
	}

	output = &CreateNatGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNatGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a NAT gateway in the specified public subnet. This action creates
// a network interface in the specified subnet with a private IP address from
// the IP address range of the subnet. Internet-bound traffic from a private
// subnet can be routed to the NAT gateway, therefore enabling instances in
// the private subnet to connect to the internet. For more information, see
// NAT Gateways (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNatGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway
func (c *EC2) CreateNatGateway(input *CreateNatGatewayInput) (*CreateNatGatewayOutput, error) {
	req, out := c.CreateNatGatewayRequest(input)
	return out, req.Send()
}

// CreateNatGatewayWithContext is the same as CreateNatGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNatGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNatGatewayWithContext(ctx aws.Context, input *CreateNatGatewayInput, opts ...request.Option) (*CreateNatGatewayOutput, error) {
	req, out := c.CreateNatGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkAcl = "CreateNetworkAcl"

// CreateNetworkAclRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkAcl for more information on using the CreateNetworkAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNetworkAclRequest method.
//    req, resp := client.CreateNetworkAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl
func (c *EC2) CreateNetworkAclRequest(input *CreateNetworkAclInput) (req *request.Request, output *CreateNetworkAclOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkAcl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkAclInput{}
	}

	output = &CreateNetworkAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkAcl API operation for Amazon Elastic Compute Cloud.
//
// Creates a network ACL in a VPC. Network ACLs provide an optional layer of
// security (in addition to security groups) for the instances in your VPC.
//
// For more information, see Network ACLs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl
func (c *EC2) CreateNetworkAcl(input *CreateNetworkAclInput) (*CreateNetworkAclOutput, error) {
	req, out := c.CreateNetworkAclRequest(input)
	return out, req.Send()
}

// CreateNetworkAclWithContext is the same as CreateNetworkAcl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkAclWithContext(ctx aws.Context, input *CreateNetworkAclInput, opts ...request.Option) (*CreateNetworkAclOutput, error) {
	req, out := c.CreateNetworkAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkAclEntry = "CreateNetworkAclEntry"

// CreateNetworkAclEntryRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkAclEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkAclEntry for more information on using the CreateNetworkAclEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNetworkAclEntryRequest method.
//    req, resp := client.CreateNetworkAclEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry
func (c *EC2) CreateNetworkAclEntryRequest(input *CreateNetworkAclEntryInput) (req *request.Request, output *CreateNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkAclEntryInput{}
	}

	output = &CreateNetworkAclEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateNetworkAclEntry API operation for Amazon Elastic Compute Cloud.
//
// Creates an entry (a rule) in a network ACL with the specified rule number.
// Each network ACL has a set of numbered ingress rules and a separate set of
// numbered egress rules. When determining whether a packet should be allowed
// in or out of a subnet associated with the ACL, we process the entries in
// the ACL according to the rule numbers, in ascending order. Each network ACL
// has a set of ingress rules and a separate set of egress rules.
//
// We recommend that you leave room between the rule numbers (for example, 100,
// 110, 120, ...), and not number them one right after the other (for example,
// 101, 102, 103, ...). This makes it easier to add a rule between existing
// ones without having to renumber the rules.
//
// After you add an entry, you can't modify it; you must either replace it,
// or create an entry and delete the old one.
//
// For more information about network ACLs, see Network ACLs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkAclEntry for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry
func (c *EC2) CreateNetworkAclEntry(input *CreateNetworkAclEntryInput) (*CreateNetworkAclEntryOutput, error) {
	req, out := c.CreateNetworkAclEntryRequest(input)
	return out, req.Send()
}

// CreateNetworkAclEntryWithContext is the same as CreateNetworkAclEntry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkAclEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkAclEntryWithContext(ctx aws.Context, input *CreateNetworkAclEntryInput, opts ...request.Option) (*CreateNetworkAclEntryOutput, error) {
	req, out := c.CreateNetworkAclEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkInsightsPath = "CreateNetworkInsightsPath"

// CreateNetworkInsightsPathRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkInsightsPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkInsightsPath for more information on using the CreateNetworkInsightsPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNetworkInsightsPathRequest method.
//    req, resp := client.CreateNetworkInsightsPathRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath
func (c *EC2) CreateNetworkInsightsPathRequest(input *CreateNetworkInsightsPathInput) (req *request.Request, output *CreateNetworkInsightsPathOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkInsightsPath,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkInsightsPathInput{}
	}

	output = &CreateNetworkInsightsPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkInsightsPath API operation for Amazon Elastic Compute Cloud.
//
// Creates a path to analyze for reachability.
//
// Reachability Analyzer enables you to analyze and debug network reachability
// between two resources in your virtual private cloud (VPC). For more information,
// see What is Reachability Analyzer (https://docs.aws.amazon.com/vpc/latest/reachability/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkInsightsPath for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath
func (c *EC2) CreateNetworkInsightsPath(input *CreateNetworkInsightsPathInput) (*CreateNetworkInsightsPathOutput, error) {
	req, out := c.CreateNetworkInsightsPathRequest(input)
	return out, req.Send()
}

// CreateNetworkInsightsPathWithContext is the same as CreateNetworkInsightsPath with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkInsightsPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkInsightsPathWithContext(ctx aws.Context, input *CreateNetworkInsightsPathInput, opts ...request.Option) (*CreateNetworkInsightsPathOutput, error) {
	req, out := c.CreateNetworkInsightsPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkInterface = "CreateNetworkInterface"

// CreateNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkInterface for more information on using the CreateNetworkInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNetworkInterfaceRequest method.
//    req, resp := client.CreateNetworkInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface
func (c *EC2) CreateNetworkInterfaceRequest(input *CreateNetworkInterfaceInput) (req *request.Request, output *CreateNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkInterfaceInput{}
	}

	output = &CreateNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Creates a network interface in the specified subnet.
//
// For more information about network interfaces, see Elastic Network Interfaces
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html) in the
// Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkInterface for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface
func (c *EC2) CreateNetworkInterface(input *CreateNetworkInterfaceInput) (*CreateNetworkInterfaceOutput, error) {
	req, out := c.CreateNetworkInterfaceRequest(input)
	return out, req.Send()
}

// CreateNetworkInterfaceWithContext is the same as CreateNetworkInterface with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkInterfaceWithContext(ctx aws.Context, input *CreateNetworkInterfaceInput, opts ...request.Option) (*CreateNetworkInterfaceOutput, error) {
	req, out := c.CreateNetworkInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkInterfacePermission = "CreateNetworkInterfacePermission"

// CreateNetworkInterfacePermissionRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkInterfacePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkInterfacePermission for more information on using the CreateNetworkInterfacePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNetworkInterfacePermissionRequest method.
//    req, resp := client.CreateNetworkInterfacePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission
func (c *EC2) CreateNetworkInterfacePermissionRequest(input *CreateNetworkInterfacePermissionInput) (req *request.Request, output *CreateNetworkInterfacePermissionOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkInterfacePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkInterfacePermissionInput{}
	}

	output = &CreateNetworkInterfacePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkInterfacePermission API operation for Amazon Elastic Compute Cloud.
//
// Grants an AWS-authorized account permission to attach the specified network
// interface to an instance in their account.
//
// You can grant permission to a single AWS account only, and only one account
// at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkInterfacePermission for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission
func (c *EC2) CreateNetworkInterfacePermission(input *CreateNetworkInterfacePermissionInput) (*CreateNetworkInterfacePermissionOutput, error) {
	req, out := c.CreateNetworkInterfacePermissionRequest(input)
	return out, req.Send()
}

// CreateNetworkInterfacePermissionWithContext is the same as CreateNetworkInterfacePermission with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkInterfacePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkInterfacePermissionWithContext(ctx aws.Context, input *CreateNetworkInterfacePermissionInput, opts ...request.Option) (*CreateNetworkInterfacePermissionOutput, error) {
	req, out := c.CreateNetworkInterfacePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlacementGroup = "CreatePlacementGroup"

// CreatePlacementGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlacementGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlacementGroup for more information on using the CreatePlacementGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePlacementGroupRequest method.
//    req, resp := client.CreatePlacementGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup
func (c *EC2) CreatePlacementGroupRequest(input *CreatePlacementGroupInput) (req *request.Request, output *CreatePlacementGroupOutput) {
	op := &request.Operation{
		Name:       opCreatePlacementGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlacementGroupInput{}
	}

	output = &CreatePlacementGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlacementGroup API operation for Amazon Elastic Compute Cloud.
//
// Creates a placement group in which to launch instances. The strategy of the
// placement group determines how the instances are organized within the group.
//
// A cluster placement group is a logical grouping of instances within a single
// Availability Zone that benefit from low network latency, high network throughput.
// A spread placement group places instances on distinct hardware. A partition
// placement group places groups of instances in different partitions, where
// instances in one partition do not share the same hardware with instances
// in another partition.
//
// For more information, see Placement groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreatePlacementGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup
func (c *EC2) CreatePlacementGroup(input *CreatePlacementGroupInput) (*CreatePlacementGroupOutput, error) {
	req, out := c.CreatePlacementGroupRequest(input)
	return out, req.Send()
}

// CreatePlacementGroupWithContext is the same as CreatePlacementGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlacementGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreatePlacementGroupWithContext(ctx aws.Context, input *CreatePlacementGroupInput, opts ...request.Option) (*CreatePlacementGroupOutput, error) {
	req, out := c.CreatePlacementGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReservedInstancesListing = "CreateReservedInstancesListing"

// CreateReservedInstancesListingRequest generates a "aws/request.Request" representing the
// client's request for the CreateReservedInstancesListing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReservedInstancesListing for more information on using the CreateReservedInstancesListing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReservedInstancesListingRequest method.
//    req, resp := client.CreateReservedInstancesListingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing
func (c *EC2) CreateReservedInstancesListingRequest(input *CreateReservedInstancesListingInput) (req *request.Request, output *CreateReservedInstancesListingOutput) {
	op := &request.Operation{
		Name:       opCreateReservedInstancesListing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReservedInstancesListingInput{}
	}

	output = &CreateReservedInstancesListingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReservedInstancesListing API operation for Amazon Elastic Compute Cloud.
//
// Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in
// the Reserved Instance Marketplace. You can submit one Standard Reserved Instance
// listing at a time. To get a list of your Standard Reserved Instances, you
// can use the DescribeReservedInstances operation.
//
// Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace.
// Convertible Reserved Instances cannot be sold.
//
// The Reserved Instance Marketplace matches sellers who want to resell Standard
// Reserved Instance capacity that they no longer need with buyers who want
// to purchase additional capacity. Reserved Instances bought and sold through
// the Reserved Instance Marketplace work like any other Reserved Instances.
//
// To sell your Standard Reserved Instances, you must first register as a seller
// in the Reserved Instance Marketplace. After completing the registration process,
// you can create a Reserved Instance Marketplace listing of some or all of
// your Standard Reserved Instances, and specify the upfront price to receive
// for them. Your Standard Reserved Instance listings then become available
// for purchase. To view the details of your Standard Reserved Instance listing,
// you can use the DescribeReservedInstancesListings operation.
//
// For more information, see Reserved Instance Marketplace (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateReservedInstancesListing for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing
func (c *EC2) CreateReservedInstancesListing(input *CreateReservedInstancesListingInput) (*CreateReservedInstancesListingOutput, error) {
	req, out := c.CreateReservedInstancesListingRequest(input)
	return out, req.Send()
}

// CreateReservedInstancesListingWithContext is the same as CreateReservedInstancesListing with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReservedInstancesListing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateReservedInstancesListingWithContext(ctx aws.Context, input *CreateReservedInstancesListingInput, opts ...request.Option) (*CreateReservedInstancesListingOutput, error) {
	req, out := c.CreateReservedInstancesListingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoute for more information on using the CreateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRouteRequest method.
//    req, resp := client.CreateRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute
func (c *EC2) CreateRouteRequest(input *CreateRouteInput) (req *request.Request, output *CreateRouteOutput) {
	op := &request.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	output = &CreateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a route in a route table within a VPC.
//
// You must specify one of the following targets: internet gateway or virtual
// private gateway, NAT instance, NAT gateway, VPC peering connection, network
// interface, egress-only internet gateway, or transit gateway.
//
// When determining how to route traffic, we use the route with the most specific
// match. For example, traffic is destined for the IPv4 address 192.0.2.3, and
// the route table includes the following two IPv4 routes:
//
//    * 192.0.2.0/24 (goes to some target A)
//
//    * 192.0.2.0/28 (goes to some target B)
//
// Both routes apply to the traffic destined for 192.0.2.3. However, the second
// route in the list covers a smaller number of IP addresses and is therefore
// more specific, so we use that route to determine where to target the traffic.
//
// For more information about route tables, see Route Tables (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute
func (c *EC2) CreateRoute(input *CreateRouteInput) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	return out, req.Send()
}

// CreateRouteWithContext is the same as CreateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateRouteWithContext(ctx aws.Context, input *CreateRouteInput, opts ...request.Option) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRouteTable = "CreateRouteTable"

// CreateRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRouteTable for more information on using the CreateRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRouteTableRequest method.
//    req, resp := client.CreateRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable
func (c *EC2) CreateRouteTableRequest(input *CreateRouteTableInput) (req *request.Request, output *CreateRouteTableOutput) {
	op := &request.Operation{
		Name:       opCreateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteTableInput{}
	}

	output = &CreateRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Creates a route table for the specified VPC. After you create a route table,
// you can add routes and associate the table with a subnet.
//
// For more information, see Route Tables (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable
func (c *EC2) CreateRouteTable(input *CreateRouteTableInput) (*CreateRouteTableOutput, error) {
	req, out := c.CreateRouteTableRequest(input)
	return out, req.Send()
}

// CreateRouteTableWithContext is the same as CreateRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateRouteTableWithContext(ctx aws.Context, input *CreateRouteTableInput, opts ...request.Option) (*CreateRouteTableOutput, error) {
	req, out := c.CreateRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityGroup = "CreateSecurityGroup"

// CreateSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecurityGroup for more information on using the CreateSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSecurityGroupRequest method.
//    req, resp := client.CreateSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup
func (c *EC2) CreateSecurityGroupRequest(input *CreateSecurityGroupInput) (req *request.Request, output *CreateSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityGroupInput{}
	}

	output = &CreateSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityGroup API operation for Amazon Elastic Compute Cloud.
//
// Creates a security group.
//
// A security group acts as a virtual firewall for your instance to control
// inbound and outbound traffic. For more information, see Amazon EC2 Security
// Groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
// in the Amazon Elastic Compute Cloud User Guide and Security Groups for Your
// VPC (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// When you create a security group, you specify a friendly name of your choice.
// You can have a security group for use in EC2-Classic with the same name as
// a security group for use in a VPC. However, you can't have two security groups
// for use in EC2-Classic with the same name or two security groups for use
// in a VPC with the same name.
//
// You have a default security group for use in EC2-Classic and a default security
// group for use in your VPC. If you don't specify a security group when you
// launch an instance, the instance is launched into the appropriate default
// security group. A default security group includes a default rule that grants
// instances unrestricted network access to each other.
//
// You can add or remove rules from your security groups using AuthorizeSecurityGroupIngress,
// AuthorizeSecurityGroupEgress, RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.
//
// For more information about VPC security group limits, see Amazon VPC Limits
// (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSecurityGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup
func (c *EC2) CreateSecurityGroup(input *CreateSecurityGroupInput) (*CreateSecurityGroupOutput, error) {
	req, out := c.CreateSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateSecurityGroupWithContext is the same as CreateSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSecurityGroupWithContext(ctx aws.Context, input *CreateSecurityGroupInput, opts ...request.Option) (*CreateSecurityGroupOutput, error) {
	req, out := c.CreateSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshot for more information on using the CreateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSnapshotRequest method.
//    req, resp := client.CreateSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot
func (c *EC2) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *Snapshot) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &Snapshot{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for Amazon Elastic Compute Cloud.
//
// Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use
// snapshots for backups, to make copies of EBS volumes, and to save data before
// shutting down an instance.
//
// You can create snapshots of volumes in a Region and volumes on an Outpost.
// If you create a snapshot of a volume in a Region, the snapshot must be stored
// in the same Region as the volume. If you create a snapshot of a volume on
// an Outpost, the snapshot can be stored on the same Outpost as the volume,
// or in the Region for that Outpost.
//
// When a snapshot is created, any AWS Marketplace product codes that are associated
// with the source volume are propagated to the snapshot.
//
// You can take a snapshot of an attached volume that is in use. However, snapshots
// only capture data that has been written to your EBS volume at the time the
// snapshot command is issued; this might exclude any data that has been cached
// by any applications or the operating system. If you can pause any file systems
// on the volume long enough to take a snapshot, your snapshot should be complete.
// However, if you cannot pause all file writes to the volume, you should unmount
// the volume from within the instance, issue the snapshot command, and then
// remount the volume to ensure a consistent and complete snapshot. You may
// remount and use your volume while the snapshot status is pending.
//
// To create a snapshot for EBS volumes that serve as root devices, you should
// stop the instance before taking the snapshot.
//
// Snapshots that are taken from encrypted volumes are automatically encrypted.
// Volumes that are created from encrypted snapshots are also automatically
// encrypted. Your encrypted volumes and any associated snapshots always remain
// protected.
//
// You can tag your snapshots during creation. For more information, see Tagging
// your Amazon EC2 resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information, see Amazon Elastic Block Store (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html)
// and Amazon EBS encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSnapshot for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot
func (c *EC2) CreateSnapshot(input *CreateSnapshotInput) (*Snapshot, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*Snapshot, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshots = "CreateSnapshots"

// CreateSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshots for more information on using the CreateSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSnapshotsRequest method.
//    req, resp := client.CreateSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots
func (c *EC2) CreateSnapshotsRequest(input *CreateSnapshotsInput) (req *request.Request, output *CreateSnapshotsOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotsInput{}
	}

	output = &CreateSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshots API operation for Amazon Elastic Compute Cloud.
//
// Creates crash-consistent snapshots of multiple EBS volumes and stores the
// data in S3. Volumes are chosen by specifying an instance. Any attached volumes
// will produce one snapshot each that is crash-consistent across the instance.
// Boot volumes can be excluded by changing the parameters.
//
// You can create multi-volume snapshots of instances in a Region and instances
// on an Outpost. If you create snapshots from an instance in a Region, the
// snapshots must be stored in the same Region as the instance. If you create
// snapshots from an instance on an Outpost, the snapshots can be stored on
// the same Outpost as the instance, or in the Region for that Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSnapshots for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots
func (c *EC2) CreateSnapshots(input *CreateSnapshotsInput) (*CreateSnapshotsOutput, error) {
	req, out := c.CreateSnapshotsRequest(input)
	return out, req.Send()
}

// CreateSnapshotsWithContext is the same as CreateSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSnapshotsWithContext(ctx aws.Context, input *CreateSnapshotsInput, opts ...request.Option) (*CreateSnapshotsOutput, error) {
	req, out := c.CreateSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSpotDatafeedSubscription = "CreateSpotDatafeedSubscription"

// CreateSpotDatafeedSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSpotDatafeedSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSpotDatafeedSubscription for more information on using the CreateSpotDatafeedSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSpotDatafeedSubscriptionRequest method.
//    req, resp := client.CreateSpotDatafeedSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription
func (c *EC2) CreateSpotDatafeedSubscriptionRequest(input *CreateSpotDatafeedSubscriptionInput) (req *request.Request, output *CreateSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSpotDatafeedSubscriptionInput{}
	}

	output = &CreateSpotDatafeedSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSpotDatafeedSubscription API operation for Amazon Elastic Compute Cloud.
//
// Creates a data feed for Spot Instances, enabling you to view Spot Instance
// usage logs. You can create one data feed per AWS account. For more information,
// see Spot Instance data feed (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
// in the Amazon EC2 User Guide for Linux Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSpotDatafeedSubscription for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription
func (c *EC2) CreateSpotDatafeedSubscription(input *CreateSpotDatafeedSubscriptionInput) (*CreateSpotDatafeedSubscriptionOutput, error) {
	req, out := c.CreateSpotDatafeedSubscriptionRequest(input)
	return out, req.Send()
}

// CreateSpotDatafeedSubscriptionWithContext is the same as CreateSpotDatafeedSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSpotDatafeedSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSpotDatafeedSubscriptionWithContext(ctx aws.Context, input *CreateSpotDatafeedSubscriptionInput, opts ...request.Option) (*CreateSpotDatafeedSubscriptionOutput, error) {
	req, out := c.CreateSpotDatafeedSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubnet = "CreateSubnet"

// CreateSubnetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubnet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubnet for more information on using the CreateSubnet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSubnetRequest method.
//    req, resp := client.CreateSubnetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet
func (c *EC2) CreateSubnetRequest(input *CreateSubnetInput) (req *request.Request, output *CreateSubnetOutput) {
	op := &request.Operation{
		Name:       opCreateSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubnetInput{}
	}

	output = &CreateSubnetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubnet API operation for Amazon Elastic Compute Cloud.
//
// Creates a subnet in a specified VPC.
//
// You must specify an IPv4 CIDR block for the subnet. After you create a subnet,
// you can't change its CIDR block. The allowed block size is between a /16
// netmask (65,536 IP addresses) and /28 netmask (16 IP addresses). The CIDR
// block must not overlap with the CIDR block of an existing subnet in the VPC.
//
// If you've associated an IPv6 CIDR block with your VPC, you can create a subnet
// with an IPv6 CIDR block that uses a /64 prefix length.
//
// AWS reserves both the first four and the last IPv4 address in each subnet's
// CIDR block. They're not available for use.
//
// If you add more than one subnet to a VPC, they're set up in a star topology
// with a logical router in the middle.
//
// When you stop an instance in a subnet, it retains its private IPv4 address.
// It's therefore possible to have a subnet with no running instances (they're
// all stopped), but no remaining IP addresses available.
//
// For more information about subnets, see Your VPC and Subnets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSubnet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet
func (c *EC2) CreateSubnet(input *CreateSubnetInput) (*CreateSubnetOutput, error) {
	req, out := c.CreateSubnetRequest(input)
	return out, req.Send()
}

// CreateSubnetWithContext is the same as CreateSubnet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubnet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSubnetWithContext(ctx aws.Context, input *CreateSubnetInput, opts ...request.Option) (*CreateSubnetOutput, error) {
	req, out := c.CreateSubnetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags
func (c *EC2) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for Amazon Elastic Compute Cloud.
//
// Adds or overwrites only the specified tags for the specified Amazon EC2 resource
// or resources. When you specify an existing tag key, the value is overwritten
// with the new value. Each resource can have a maximum of 50 tags. Each tag
// consists of a key and optional value. Tag keys must be unique per resource.
//
// For more information about tags, see Tagging Your Resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide. For more information about
// creating IAM policies that control users' access to resources based on tags,
// see Supported Resource-Level Permissions for Amazon EC2 API Actions (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags
func (c *EC2) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficMirrorFilter = "CreateTrafficMirrorFilter"

// CreateTrafficMirrorFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficMirrorFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficMirrorFilter for more information on using the CreateTrafficMirrorFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrafficMirrorFilterRequest method.
//    req, resp := client.CreateTrafficMirrorFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter
func (c *EC2) CreateTrafficMirrorFilterRequest(input *CreateTrafficMirrorFilterInput) (req *request.Request, output *CreateTrafficMirrorFilterOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficMirrorFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficMirrorFilterInput{}
	}

	output = &CreateTrafficMirrorFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficMirrorFilter API operation for Amazon Elastic Compute Cloud.
//
// Creates a Traffic Mirror filter.
//
// A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
//
// By default, no traffic is mirrored. To mirror traffic, use CreateTrafficMirrorFilterRule
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm)
// to add Traffic Mirror rules to the filter. The rules you add define what
// traffic gets mirrored. You can also use ModifyTrafficMirrorFilterNetworkServices
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html)
// to mirror supported network services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTrafficMirrorFilter for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter
func (c *EC2) CreateTrafficMirrorFilter(input *CreateTrafficMirrorFilterInput) (*CreateTrafficMirrorFilterOutput, error) {
	req, out := c.CreateTrafficMirrorFilterRequest(input)
	return out, req.Send()
}

// CreateTrafficMirrorFilterWithContext is the same as CreateTrafficMirrorFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficMirrorFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTrafficMirrorFilterWithContext(ctx aws.Context, input *CreateTrafficMirrorFilterInput, opts ...request.Option) (*CreateTrafficMirrorFilterOutput, error) {
	req, out := c.CreateTrafficMirrorFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficMirrorFilterRule = "CreateTrafficMirrorFilterRule"

// CreateTrafficMirrorFilterRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficMirrorFilterRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficMirrorFilterRule for more information on using the CreateTrafficMirrorFilterRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrafficMirrorFilterRuleRequest method.
//    req, resp := client.CreateTrafficMirrorFilterRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule
func (c *EC2) CreateTrafficMirrorFilterRuleRequest(input *CreateTrafficMirrorFilterRuleInput) (req *request.Request, output *CreateTrafficMirrorFilterRuleOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficMirrorFilterRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficMirrorFilterRuleInput{}
	}

	output = &CreateTrafficMirrorFilterRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficMirrorFilterRule API operation for Amazon Elastic Compute Cloud.
//
// Creates a Traffic Mirror filter rule.
//
// A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
//
// You need the Traffic Mirror filter ID when you create the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTrafficMirrorFilterRule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule
func (c *EC2) CreateTrafficMirrorFilterRule(input *CreateTrafficMirrorFilterRuleInput) (*CreateTrafficMirrorFilterRuleOutput, error) {
	req, out := c.CreateTrafficMirrorFilterRuleRequest(input)
	return out, req.Send()
}

// CreateTrafficMirrorFilterRuleWithContext is the same as CreateTrafficMirrorFilterRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficMirrorFilterRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTrafficMirrorFilterRuleWithContext(ctx aws.Context, input *CreateTrafficMirrorFilterRuleInput, opts ...request.Option) (*CreateTrafficMirrorFilterRuleOutput, error) {
	req, out := c.CreateTrafficMirrorFilterRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficMirrorSession = "CreateTrafficMirrorSession"

// CreateTrafficMirrorSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficMirrorSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficMirrorSession for more information on using the CreateTrafficMirrorSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrafficMirrorSessionRequest method.
//    req, resp := client.CreateTrafficMirrorSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession
func (c *EC2) CreateTrafficMirrorSessionRequest(input *CreateTrafficMirrorSessionInput) (req *request.Request, output *CreateTrafficMirrorSessionOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficMirrorSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficMirrorSessionInput{}
	}

	output = &CreateTrafficMirrorSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficMirrorSession API operation for Amazon Elastic Compute Cloud.
//
// Creates a Traffic Mirror session.
//
// A Traffic Mirror session actively copies packets from a Traffic Mirror source
// to a Traffic Mirror target. Create a filter, and then assign it to the session
// to define a subset of the traffic to mirror, for example all TCP traffic.
//
// The Traffic Mirror source and the Traffic Mirror target (monitoring appliances)
// can be in the same VPC, or in a different VPC connected via VPC peering or
// a transit gateway.
//
// By default, no traffic is mirrored. Use CreateTrafficMirrorFilter (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm)
// to create filter rules that specify the traffic to mirror.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTrafficMirrorSession for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession
func (c *EC2) CreateTrafficMirrorSession(input *CreateTrafficMirrorSessionInput) (*CreateTrafficMirrorSessionOutput, error) {
	req, out := c.CreateTrafficMirrorSessionRequest(input)
	return out, req.Send()
}

// CreateTrafficMirrorSessionWithContext is the same as CreateTrafficMirrorSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficMirrorSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTrafficMirrorSessionWithContext(ctx aws.Context, input *CreateTrafficMirrorSessionInput, opts ...request.Option) (*CreateTrafficMirrorSessionOutput, error) {
	req, out := c.CreateTrafficMirrorSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficMirrorTarget = "CreateTrafficMirrorTarget"

// CreateTrafficMirrorTargetRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficMirrorTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficMirrorTarget for more information on using the CreateTrafficMirrorTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrafficMirrorTargetRequest method.
//    req, resp := client.CreateTrafficMirrorTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget
func (c *EC2) CreateTrafficMirrorTargetRequest(input *CreateTrafficMirrorTargetInput) (req *request.Request, output *CreateTrafficMirrorTargetOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficMirrorTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficMirrorTargetInput{}
	}

	output = &CreateTrafficMirrorTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficMirrorTarget API operation for Amazon Elastic Compute Cloud.
//
// Creates a target for your Traffic Mirror session.
//
// A Traffic Mirror target is the destination for mirrored traffic. The Traffic
// Mirror source and the Traffic Mirror target (monitoring appliances) can be
// in the same VPC, or in different VPCs connected via VPC peering or a transit
// gateway.
//
// A Traffic Mirror target can be a network interface, or a Network Load Balancer.
//
// To use the target in a Traffic Mirror session, use CreateTrafficMirrorSession
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTrafficMirrorTarget for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget
func (c *EC2) CreateTrafficMirrorTarget(input *CreateTrafficMirrorTargetInput) (*CreateTrafficMirrorTargetOutput, error) {
	req, out := c.CreateTrafficMirrorTargetRequest(input)
	return out, req.Send()
}

// CreateTrafficMirrorTargetWithContext is the same as CreateTrafficMirrorTarget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficMirrorTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTrafficMirrorTargetWithContext(ctx aws.Context, input *CreateTrafficMirrorTargetInput, opts ...request.Option) (*CreateTrafficMirrorTargetOutput, error) {
	req, out := c.CreateTrafficMirrorTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGateway = "CreateTransitGateway"

// CreateTransitGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGateway for more information on using the CreateTransitGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitGatewayRequest method.
//    req, resp := client.CreateTransitGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway
func (c *EC2) CreateTransitGatewayRequest(input *CreateTransitGatewayInput) (req *request.Request, output *CreateTransitGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayInput{}
	}

	output = &CreateTransitGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a transit gateway.
//
// You can use a transit gateway to interconnect your virtual private clouds
// (VPC) and on-premises networks. After the transit gateway enters the available
// state, you can attach your VPCs and VPN connections to the transit gateway.
//
// To attach your VPCs, use CreateTransitGatewayVpcAttachment.
//
// To attach a VPN connection, use CreateCustomerGateway to create a customer
// gateway and specify the ID of the customer gateway and the ID of the transit
// gateway in a call to CreateVpnConnection.
//
// When you create a transit gateway, we create a default transit gateway route
// table and use it as the default association route table and the default propagation
// route table. You can use CreateTransitGatewayRouteTable to create additional
// transit gateway route tables. If you disable automatic route propagation,
// we do not create a default transit gateway route table. You can use EnableTransitGatewayRouteTablePropagation
// to propagate routes from a resource attachment to a transit gateway route
// table. If you disable automatic associations, you can use AssociateTransitGatewayRouteTable
// to associate a resource attachment with a transit gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway
func (c *EC2) CreateTransitGateway(input *CreateTransitGatewayInput) (*CreateTransitGatewayOutput, error) {
	req, out := c.CreateTransitGatewayRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayWithContext is the same as CreateTransitGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayWithContext(ctx aws.Context, input *CreateTransitGatewayInput, opts ...request.Option) (*CreateTransitGatewayOutput, error) {
	req, out := c.CreateTransitGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayConnect = "CreateTransitGatewayConnect"

// CreateTransitGatewayConnectRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayConnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayConnect for more information on using the CreateTransitGatewayConnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitGatewayConnectRequest method.
//    req, resp := client.CreateTransitGatewayConnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect
func (c *EC2) CreateTransitGatewayConnectRequest(input *CreateTransitGatewayConnectInput) (req *request.Request, output *CreateTransitGatewayConnectOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayConnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayConnectInput{}
	}

	output = &CreateTransitGatewayConnectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayConnect API operation for Amazon Elastic Compute Cloud.
//
// Creates a Connect attachment from a specified transit gateway attachment.
// A Connect attachment is a GRE-based tunnel attachment that you can use to
// establish a connection between a transit gateway and an appliance.
//
// A Connect attachment uses an existing VPC or AWS Direct Connect attachment
// as the underlying transport mechanism.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayConnect for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect
func (c *EC2) CreateTransitGatewayConnect(input *CreateTransitGatewayConnectInput) (*CreateTransitGatewayConnectOutput, error) {
	req, out := c.CreateTransitGatewayConnectRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayConnectWithContext is the same as CreateTransitGatewayConnect with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayConnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayConnectWithContext(ctx aws.Context, input *CreateTransitGatewayConnectInput, opts ...request.Option) (*CreateTransitGatewayConnectOutput, error) {
	req, out := c.CreateTransitGatewayConnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayConnectPeer = "CreateTransitGatewayConnectPeer"

// CreateTransitGatewayConnectPeerRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayConnectPeer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayConnectPeer for more information on using the CreateTransitGatewayConnectPeer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitGatewayConnectPeerRequest method.
//    req, resp := client.CreateTransitGatewayConnectPeerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer
func (c *EC2) CreateTransitGatewayConnectPeerRequest(input *CreateTransitGatewayConnectPeerInput) (req *request.Request, output *CreateTransitGatewayConnectPeerOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayConnectPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayConnectPeerInput{}
	}

	output = &CreateTransitGatewayConnectPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayConnectPeer API operation for Amazon Elastic Compute Cloud.
//
// Creates a Connect peer for a specified transit gateway Connect attachment
// between a transit gateway and an appliance.
//
// The peer address and transit gateway address must be the same IP address
// family (IPv4 or IPv6).
//
// For more information, see Connect peers (https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer)
// in the Transit Gateways Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayConnectPeer for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer
func (c *EC2) CreateTransitGatewayConnectPeer(input *CreateTransitGatewayConnectPeerInput) (*CreateTransitGatewayConnectPeerOutput, error) {
	req, out := c.CreateTransitGatewayConnectPeerRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayConnectPeerWithContext is the same as CreateTransitGatewayConnectPeer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayConnectPeer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayConnectPeerWithContext(ctx aws.Context, input *CreateTransitGatewayConnectPeerInput, opts ...request.Option) (*CreateTransitGatewayConnectPeerOutput, error) {
	req, out := c.CreateTransitGatewayConnectPeerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayMulticastDomain = "CreateTransitGatewayMulticastDomain"

// CreateTransitGatewayMulticastDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayMulticastDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayMulticastDomain for more information on using the CreateTransitGatewayMulticastDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitGatewayMulticastDomainRequest method.
//    req, resp := client.CreateTransitGatewayMulticastDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain
func (c *EC2) CreateTransitGatewayMulticastDomainRequest(input *CreateTransitGatewayMulticastDomainInput) (req *request.Request, output *CreateTransitGatewayMulticastDomainOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayMulticastDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayMulticastDomainInput{}
	}

	output = &CreateTransitGatewayMulticastDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayMulticastDomain API operation for Amazon Elastic Compute Cloud.
//
// Creates a multicast domain using the specified transit gateway.
//
// The transit gateway must be in the available state before you create a domain.
// Use DescribeTransitGateways (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html)
// to see the state of transit gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayMulticastDomain for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain
func (c *EC2) CreateTransitGatewayMulticastDomain(input *CreateTransitGatewayMulticastDomainInput) (*CreateTransitGatewayMulticastDomainOutput, error) {
	req, out := c.CreateTransitGatewayMulticastDomainRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayMulticastDomainWithContext is the same as CreateTransitGatewayMulticastDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayMulticastDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayMulticastDomainWithContext(ctx aws.Context, input *CreateTransitGatewayMulticastDomainInput, opts ...request.Option) (*CreateTransitGatewayMulticastDomainOutput, error) {
	req, out := c.CreateTransitGatewayMulticastDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayPeeringAttachment = "CreateTransitGatewayPeeringAttachment"

// CreateTransitGatewayPeeringAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayPeeringAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayPeeringAttachment for more information on using the CreateTransitGatewayPeeringAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitGatewayPeeringAttachmentRequest method.
//    req, resp := client.CreateTransitGatewayPeeringAttachmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment
func (c *EC2) CreateTransitGatewayPeeringAttachmentRequest(input *CreateTransitGatewayPeeringAttachmentInput) (req *request.Request, output *CreateTransitGatewayPeeringAttachmentOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayPeeringAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayPeeringAttachmentInput{}
	}

	output = &CreateTransitGatewayPeeringAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayPeeringAttachment API operation for Amazon Elastic Compute Cloud.
//
// Requests a transit gateway peering attachment between the specified transit
// gateway (requester) and a peer transit gateway (accepter). The transit gateways
// must be in different Regions. The peer transit gateway can be in your account
// or a different AWS account.
//
// After you create the peering attachment, the owner of the accepter transit
// gateway must accept the attachment request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayPeeringAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment
func (c *EC2) CreateTransitGatewayPeeringAttachment(input *CreateTransitGatewayPeeringAttachmentInput) (*CreateTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.CreateTransitGatewayPeeringAttachmentRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayPeeringAttachmentWithContext is the same as CreateTransitGatewayPeeringAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayPeeringAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayPeeringAttachmentWithContext(ctx aws.Context, input *CreateTransitGatewayPeeringAttachmentInput, opts ...request.Option) (*CreateTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.CreateTransitGatewayPeeringAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayPrefixListReference = "CreateTransitGatewayPrefixListReference"

// CreateTransitGatewayPrefixListReferenceRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayPrefixListReference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayPrefixListReference for more information on using the CreateTransitGatewayPrefixListReference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitGatewayPrefixListReferenceRequest method.
//    req, resp := client.CreateTransitGatewayPrefixListReferenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference
func (c *EC2) CreateTransitGatewayPrefixListReferenceRequest(input *CreateTransitGatewayPrefixListReferenceInput) (req *request.Request, output *CreateTransitGatewayPrefixListReferenceOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayPrefixListReference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayPrefixListReferenceInput{}
	}

	output = &CreateTransitGatewayPrefixListReferenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayPrefixListReference API operation for Amazon Elastic Compute Cloud.
//
// Creates a reference (route) to a prefix list in a specified transit gateway
// route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayPrefixListReference for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference
func (c *EC2) CreateTransitGatewayPrefixListReference(input *CreateTransitGatewayPrefixListReferenceInput) (*CreateTransitGatewayPrefixListReferenceOutput, error) {
	req, out := c.CreateTransitGatewayPrefixListReferenceRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayPrefixListReferenceWithContext is the same as CreateTransitGatewayPrefixListReference with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayPrefixListReference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayPrefixListReferenceWithContext(ctx aws.Context, input *CreateTransitGatewayPrefixListReferenceInput, opts ...request.Option) (*CreateTransitGatewayPrefixListReferenceOutput, error) {
	req, out := c.CreateTransitGatewayPrefixListReferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayRoute = "CreateTransitGatewayRoute"

// CreateTransitGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayRoute for more information on using the CreateTransitGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitGatewayRouteRequest method.
//    req, resp := client.CreateTransitGatewayRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute
func (c *EC2) CreateTransitGatewayRouteRequest(input *CreateTransitGatewayRouteInput) (req *request.Request, output *CreateTransitGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayRouteInput{}
	}

	output = &CreateTransitGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a static route for the specified transit gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute
func (c *EC2) CreateTransitGatewayRoute(input *CreateTransitGatewayRouteInput) (*CreateTransitGatewayRouteOutput, error) {
	req, out := c.CreateTransitGatewayRouteRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayRouteWithContext is the same as CreateTransitGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayRouteWithContext(ctx aws.Context, input *CreateTransitGatewayRouteInput, opts ...request.Option) (*CreateTransitGatewayRouteOutput, error) {
	req, out := c.CreateTransitGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayRouteTable = "CreateTransitGatewayRouteTable"

// CreateTransitGatewayRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayRouteTable for more information on using the CreateTransitGatewayRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitGatewayRouteTableRequest method.
//    req, resp := client.CreateTransitGatewayRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable
func (c *EC2) CreateTransitGatewayRouteTableRequest(input *CreateTransitGatewayRouteTableInput) (req *request.Request, output *CreateTransitGatewayRouteTableOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayRouteTableInput{}
	}

	output = &CreateTransitGatewayRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Creates a route table for the specified transit gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable
func (c *EC2) CreateTransitGatewayRouteTable(input *CreateTransitGatewayRouteTableInput) (*CreateTransitGatewayRouteTableOutput, error) {
	req, out := c.CreateTransitGatewayRouteTableRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayRouteTableWithContext is the same as CreateTransitGatewayRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayRouteTableWithContext(ctx aws.Context, input *CreateTransitGatewayRouteTableInput, opts ...request.Option) (*CreateTransitGatewayRouteTableOutput, error) {
	req, out := c.CreateTransitGatewayRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayVpcAttachment = "CreateTransitGatewayVpcAttachment"

// CreateTransitGatewayVpcAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayVpcAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayVpcAttachment for more information on using the CreateTransitGatewayVpcAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitGatewayVpcAttachmentRequest method.
//    req, resp := client.CreateTransitGatewayVpcAttachmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment
func (c *EC2) CreateTransitGatewayVpcAttachmentRequest(input *CreateTransitGatewayVpcAttachmentInput) (req *request.Request, output *CreateTransitGatewayVpcAttachmentOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayVpcAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayVpcAttachmentInput{}
	}

	output = &CreateTransitGatewayVpcAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayVpcAttachment API operation for Amazon Elastic Compute Cloud.
//
// Attaches the specified VPC to the specified transit gateway.
//
// If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC
// that is already attached, the new VPC CIDR range is not propagated to the
// default propagation route table.
//
// To send VPC traffic to an attached transit gateway, add a route to the VPC
// route table using CreateRoute.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayVpcAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment
func (c *EC2) CreateTransitGatewayVpcAttachment(input *CreateTransitGatewayVpcAttachmentInput) (*CreateTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.CreateTransitGatewayVpcAttachmentRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayVpcAttachmentWithContext is the same as CreateTransitGatewayVpcAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayVpcAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayVpcAttachmentWithContext(ctx aws.Context, input *CreateTransitGatewayVpcAttachmentInput, opts ...request.Option) (*CreateTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.CreateTransitGatewayVpcAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVolume = "CreateVolume"

// CreateVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVolume for more information on using the CreateVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVolumeRequest method.
//    req, resp := client.CreateVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume
func (c *EC2) CreateVolumeRequest(input *CreateVolumeInput) (req *request.Request, output *Volume) {
	op := &request.Operation{
		Name:       opCreateVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVolumeInput{}
	}

	output = &Volume{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVolume API operation for Amazon Elastic Compute Cloud.
//
// Creates an EBS volume that can be attached to an instance in the same Availability
// Zone.
//
// You can create a new empty volume or restore a volume from an EBS snapshot.
// Any AWS Marketplace product codes from the snapshot are propagated to the
// volume.
//
// You can create encrypted volumes. Encrypted volumes must be attached to instances
// that support Amazon EBS encryption. Volumes that are created from encrypted
// snapshots are also automatically encrypted. For more information, see Amazon
// EBS encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// You can tag your volumes during creation. For more information, see Tagging
// your Amazon EC2 resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information, see Creating an Amazon EBS volume (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVolume for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume
func (c *EC2) CreateVolume(input *CreateVolumeInput) (*Volume, error) {
	req, out := c.CreateVolumeRequest(input)
	return out, req.Send()
}

// CreateVolumeWithContext is the same as CreateVolume with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVolumeWithContext(ctx aws.Context, input *CreateVolumeInput, opts ...request.Option) (*Volume, error) {
	req, out := c.CreateVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpc = "CreateVpc"

// CreateVpcRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpc for more information on using the CreateVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpcRequest method.
//    req, resp := client.CreateVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc
func (c *EC2) CreateVpcRequest(input *CreateVpcInput) (req *request.Request, output *CreateVpcOutput) {
	op := &request.Operation{
		Name:       opCreateVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcInput{}
	}

	output = &CreateVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpc API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can
// create uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16
// netmask (65,536 IPv4 addresses). For more information about how large to
// make your VPC, see Your VPC and Subnets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// You can optionally request an IPv6 CIDR block for the VPC. You can request
// an Amazon-provided IPv6 CIDR block from Amazon's pool of IPv6 addresses,
// or an IPv6 CIDR block from an IPv6 address pool that you provisioned through
// bring your own IP addresses (BYOIP (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)).
//
// By default, each instance you launch in the VPC has the default DHCP options,
// which include only a default DNS server that we provide (AmazonProvidedDNS).
// For more information, see DHCP Options Sets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// You can specify the instance tenancy value for the VPC when you create it.
// You can't change this value for the VPC after you create it. For more information,
// see Dedicated Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpc for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc
func (c *EC2) CreateVpc(input *CreateVpcInput) (*CreateVpcOutput, error) {
	req, out := c.CreateVpcRequest(input)
	return out, req.Send()
}

// CreateVpcWithContext is the same as CreateVpc with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcWithContext(ctx aws.Context, input *CreateVpcInput, opts ...request.Option) (*CreateVpcOutput, error) {
	req, out := c.CreateVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcEndpoint = "CreateVpcEndpoint"

// CreateVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcEndpoint for more information on using the CreateVpcEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpcEndpointRequest method.
//    req, resp := client.CreateVpcEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint
func (c *EC2) CreateVpcEndpointRequest(input *CreateVpcEndpointInput) (req *request.Request, output *CreateVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcEndpointInput{}
	}

	output = &CreateVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPC endpoint for a specified service. An endpoint enables you to
// create a private connection between your VPC and the service. The service
// may be provided by AWS, an AWS Marketplace Partner, or another AWS account.
// For more information, see VPC Endpoints (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// A gateway endpoint serves as a target for a route in your route table for
// traffic destined for the AWS service. You can specify an endpoint policy
// to attach to the endpoint, which will control access to the service from
// your VPC. You can also specify the VPC route tables that use the endpoint.
//
// An interface endpoint is a network interface in your subnet that serves as
// an endpoint for communicating with the specified service. You can specify
// the subnets in which to create an endpoint, and the security groups to associate
// with the endpoint network interface.
//
// A GatewayLoadBalancer endpoint is a network interface in your subnet that
// serves an endpoint for communicating with a Gateway Load Balancer that you've
// configured as a VPC endpoint service.
//
// Use DescribeVpcEndpointServices to get a list of supported services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint
func (c *EC2) CreateVpcEndpoint(input *CreateVpcEndpointInput) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	return out, req.Send()
}

// CreateVpcEndpointWithContext is the same as CreateVpcEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcEndpointWithContext(ctx aws.Context, input *CreateVpcEndpointInput, opts ...request.Option) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcEndpointConnectionNotification = "CreateVpcEndpointConnectionNotification"

// CreateVpcEndpointConnectionNotificationRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcEndpointConnectionNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcEndpointConnectionNotification for more information on using the CreateVpcEndpointConnectionNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpcEndpointConnectionNotificationRequest method.
//    req, resp := client.CreateVpcEndpointConnectionNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification
func (c *EC2) CreateVpcEndpointConnectionNotificationRequest(input *CreateVpcEndpointConnectionNotificationInput) (req *request.Request, output *CreateVpcEndpointConnectionNotificationOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpointConnectionNotification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcEndpointConnectionNotificationInput{}
	}

	output = &CreateVpcEndpointConnectionNotificationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcEndpointConnectionNotification API operation for Amazon Elastic Compute Cloud.
//
// Creates a connection notification for a specified VPC endpoint or VPC endpoint
// service. A connection notification notifies you of specific endpoint events.
// You must create an SNS topic to receive notifications. For more information,
// see Create a Topic (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html)
// in the Amazon Simple Notification Service Developer Guide.
//
// You can create a connection notification for interface endpoints only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcEndpointConnectionNotification for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification
func (c *EC2) CreateVpcEndpointConnectionNotification(input *CreateVpcEndpointConnectionNotificationInput) (*CreateVpcEndpointConnectionNotificationOutput, error) {
	req, out := c.CreateVpcEndpointConnectionNotificationRequest(input)
	return out, req.Send()
}

// CreateVpcEndpointConnectionNotificationWithContext is the same as CreateVpcEndpointConnectionNotification with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcEndpointConnectionNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcEndpointConnectionNotificationWithContext(ctx aws.Context, input *CreateVpcEndpointConnectionNotificationInput, opts ...request.Option) (*CreateVpcEndpointConnectionNotificationOutput, error) {
	req, out := c.CreateVpcEndpointConnectionNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcEndpointServiceConfiguration = "CreateVpcEndpointServiceConfiguration"

// CreateVpcEndpointServiceConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcEndpointServiceConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcEndpointServiceConfiguration for more information on using the CreateVpcEndpointServiceConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpcEndpointServiceConfigurationRequest method.
//    req, resp := client.CreateVpcEndpointServiceConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration
func (c *EC2) CreateVpcEndpointServiceConfigurationRequest(input *CreateVpcEndpointServiceConfigurationInput) (req *request.Request, output *CreateVpcEndpointServiceConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpointServiceConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcEndpointServiceConfigurationInput{}
	}

	output = &CreateVpcEndpointServiceConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcEndpointServiceConfiguration API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPC endpoint service configuration to which service consumers (AWS
// accounts, IAM users, and IAM roles) can connect.
//
// To create an endpoint service configuration, you must first create one of
// the following for your service:
//
//    * A Network Load Balancer (https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html).
//    Service consumers connect to your service using an interface endpoint.
//
//    * A Gateway Load Balancer (https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/introduction.html).
//    Service consumers connect to your service using a Gateway Load Balancer
//    endpoint.
//
// For more information, see VPC Endpoint Services (https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// If you set the private DNS name, you must prove that you own the private
// DNS domain name. For more information, see VPC Endpoint Service Private DNS
// Name Verification (https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcEndpointServiceConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration
func (c *EC2) CreateVpcEndpointServiceConfiguration(input *CreateVpcEndpointServiceConfigurationInput) (*CreateVpcEndpointServiceConfigurationOutput, error) {
	req, out := c.CreateVpcEndpointServiceConfigurationRequest(input)
	return out, req.Send()
}

// CreateVpcEndpointServiceConfigurationWithContext is the same as CreateVpcEndpointServiceConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcEndpointServiceConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcEndpointServiceConfigurationWithContext(ctx aws.Context, input *CreateVpcEndpointServiceConfigurationInput, opts ...request.Option) (*CreateVpcEndpointServiceConfigurationOutput, error) {
	req, out := c.CreateVpcEndpointServiceConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcPeeringConnection = "CreateVpcPeeringConnection"

// CreateVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcPeeringConnection for more information on using the CreateVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpcPeeringConnectionRequest method.
//    req, resp := client.CreateVpcPeeringConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection
func (c *EC2) CreateVpcPeeringConnectionRequest(input *CreateVpcPeeringConnectionInput) (req *request.Request, output *CreateVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcPeeringConnectionInput{}
	}

	output = &CreateVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Requests a VPC peering connection between two VPCs: a requester VPC that
// you own and an accepter VPC with which to create the connection. The accepter
// VPC can belong to another AWS account and can be in a different Region to
// the requester VPC. The requester VPC and accepter VPC cannot have overlapping
// CIDR blocks.
//
// Limitations and rules apply to a VPC peering connection. For more information,
// see the limitations (https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations)
// section in the VPC Peering Guide.
//
// The owner of the accepter VPC must accept the peering request to activate
// the peering connection. The VPC peering connection request expires after
// 7 days, after which it cannot be accepted or rejected.
//
// If you create a VPC peering connection request between VPCs with overlapping
// CIDR blocks, the VPC peering connection has a status of failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcPeeringConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection
func (c *EC2) CreateVpcPeeringConnection(input *CreateVpcPeeringConnectionInput) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// CreateVpcPeeringConnectionWithContext is the same as CreateVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcPeeringConnectionWithContext(ctx aws.Context, input *CreateVpcPeeringConnectionInput, opts ...request.Option) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpnConnection = "CreateVpnConnection"

// CreateVpnConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpnConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpnConnection for more information on using the CreateVpnConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpnConnectionRequest method.
//    req, resp := client.CreateVpnConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection
func (c *EC2) CreateVpnConnectionRequest(input *CreateVpnConnectionInput) (req *request.Request, output *CreateVpnConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnConnectionInput{}
	}

	output = &CreateVpnConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpnConnection API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPN connection between an existing virtual private gateway or transit
// gateway and a customer gateway. The supported connection type is ipsec.1.
//
// The response includes information that you need to give to your network administrator
// to configure your customer gateway.
//
// We strongly recommend that you use HTTPS when calling this operation because
// the response contains sensitive cryptographic information for configuring
// your customer gateway device.
//
// If you decide to shut down your VPN connection for any reason and later create
// a new VPN connection, you must reconfigure your customer gateway with the
// new information returned from this call.
//
// This is an idempotent operation. If you perform the operation more than once,
// Amazon EC2 doesn't return an error.
//
// For more information, see AWS Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the AWS Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpnConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection
func (c *EC2) CreateVpnConnection(input *CreateVpnConnectionInput) (*CreateVpnConnectionOutput, error) {
	req, out := c.CreateVpnConnectionRequest(input)
	return out, req.Send()
}

// CreateVpnConnectionWithContext is the same as CreateVpnConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpnConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpnConnectionWithContext(ctx aws.Context, input *CreateVpnConnectionInput, opts ...request.Option) (*CreateVpnConnectionOutput, error) {
	req, out := c.CreateVpnConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpnConnectionRoute = "CreateVpnConnectionRoute"

// CreateVpnConnectionRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpnConnectionRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpnConnectionRoute for more information on using the CreateVpnConnectionRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpnConnectionRouteRequest method.
//    req, resp := client.CreateVpnConnectionRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute
func (c *EC2) CreateVpnConnectionRouteRequest(input *CreateVpnConnectionRouteInput) (req *request.Request, output *CreateVpnConnectionRouteOutput) {
	op := &request.Operation{
		Name:       opCreateVpnConnectionRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnConnectionRouteInput{}
	}

	output = &CreateVpnConnectionRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateVpnConnectionRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a static route associated with a VPN connection between an existing
// virtual private gateway and a VPN customer gateway. The static route allows
// traffic to be routed from the virtual private gateway to the VPN customer
// gateway.
//
// For more information, see AWS Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the AWS Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpnConnectionRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute
func (c *EC2) CreateVpnConnectionRoute(input *CreateVpnConnectionRouteInput) (*CreateVpnConnectionRouteOutput, error) {
	req, out := c.CreateVpnConnectionRouteRequest(input)
	return out, req.Send()
}

// CreateVpnConnectionRouteWithContext is the same as CreateVpnConnectionRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpnConnectionRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpnConnectionRouteWithContext(ctx aws.Context, input *CreateVpnConnectionRouteInput, opts ...request.Option) (*CreateVpnConnectionRouteOutput, error) {
	req, out := c.CreateVpnConnectionRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpnGateway = "CreateVpnGateway"

// CreateVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpnGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpnGateway for more information on using the CreateVpnGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpnGatewayRequest method.
//    req, resp := client.CreateVpnGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway
func (c *EC2) CreateVpnGatewayRequest(input *CreateVpnGatewayInput) (req *request.Request, output *CreateVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnGatewayInput{}
	}

	output = &CreateVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a virtual private gateway. A virtual private gateway is the endpoint
// on the VPC side of your VPN connection. You can create a virtual private
// gateway before creating the VPC itself.
//
// For more information, see AWS Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the AWS Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpnGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway
func (c *EC2) CreateVpnGateway(input *CreateVpnGatewayInput) (*CreateVpnGatewayOutput, error) {
	req, out := c.CreateVpnGatewayRequest(input)
	return out, req.Send()
}

// CreateVpnGatewayWithContext is the same as CreateVpnGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpnGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpnGatewayWithContext(ctx aws.Context, input *CreateVpnGatewayInput, opts ...request.Option) (*CreateVpnGatewayOutput, error) {
	req, out := c.CreateVpnGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCarrierGateway = "DeleteCarrierGateway"

// DeleteCarrierGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCarrierGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCarrierGateway for more information on using the DeleteCarrierGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCarrierGatewayRequest method.
//    req, resp := client.DeleteCarrierGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway
func (c *EC2) DeleteCarrierGatewayRequest(input *DeleteCarrierGatewayInput) (req *request.Request, output *DeleteCarrierGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteCarrierGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCarrierGatewayInput{}
	}

	output = &DeleteCarrierGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCarrierGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes a carrier gateway.
//
// If you do not delete the route that contains the carrier gateway as the Target,
// the route is a blackhole route. For information about how to delete a route,
// see DeleteRoute (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteCarrierGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway
func (c *EC2) DeleteCarrierGateway(input *DeleteCarrierGatewayInput) (*DeleteCarrierGatewayOutput, error) {
	req, out := c.DeleteCarrierGatewayRequest(input)
	return out, req.Send()
}

// DeleteCarrierGatewayWithContext is the same as DeleteCarrierGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCarrierGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteCarrierGatewayWithContext(ctx aws.Context, input *DeleteCarrierGatewayInput, opts ...request.Option) (*DeleteCarrierGatewayOutput, error) {
	req, out := c.DeleteCarrierGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClientVpnEndpoint = "DeleteClientVpnEndpoint"

// DeleteClientVpnEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClientVpnEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClientVpnEndpoint for more information on using the DeleteClientVpnEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClientVpnEndpointRequest method.
//    req, resp := client.DeleteClientVpnEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint
func (c *EC2) DeleteClientVpnEndpointRequest(input *DeleteClientVpnEndpointInput) (req *request.Request, output *DeleteClientVpnEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteClientVpnEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClientVpnEndpointInput{}
	}

	output = &DeleteClientVpnEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteClientVpnEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Client VPN endpoint. You must disassociate all target
// networks before you can delete a Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteClientVpnEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint
func (c *EC2) DeleteClientVpnEndpoint(input *DeleteClientVpnEndpointInput) (*DeleteClientVpnEndpointOutput, error) {
	req, out := c.DeleteClientVpnEndpointRequest(input)
	return out, req.Send()
}

// DeleteClientVpnEndpointWithContext is the same as DeleteClientVpnEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClientVpnEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteClientVpnEndpointWithContext(ctx aws.Context, input *DeleteClientVpnEndpointInput, opts ...request.Option) (*DeleteClientVpnEndpointOutput, error) {
	req, out := c.DeleteClientVpnEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClientVpnRoute = "DeleteClientVpnRoute"

// DeleteClientVpnRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClientVpnRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClientVpnRoute for more information on using the DeleteClientVpnRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClientVpnRouteRequest method.
//    req, resp := client.DeleteClientVpnRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute
func (c *EC2) DeleteClientVpnRouteRequest(input *DeleteClientVpnRouteInput) (req *request.Request, output *DeleteClientVpnRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteClientVpnRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClientVpnRouteInput{}
	}

	output = &DeleteClientVpnRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteClientVpnRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes a route from a Client VPN endpoint. You can only delete routes that
// you manually added using the CreateClientVpnRoute action. You cannot delete
// routes that were automatically added when associating a subnet. To remove
// routes that have been automatically added, disassociate the target subnet
// from the Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteClientVpnRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute
func (c *EC2) DeleteClientVpnRoute(input *DeleteClientVpnRouteInput) (*DeleteClientVpnRouteOutput, error) {
	req, out := c.DeleteClientVpnRouteRequest(input)
	return out, req.Send()
}

// DeleteClientVpnRouteWithContext is the same as DeleteClientVpnRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClientVpnRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteClientVpnRouteWithContext(ctx aws.Context, input *DeleteClientVpnRouteInput, opts ...request.Option) (*DeleteClientVpnRouteOutput, error) {
	req, out := c.DeleteClientVpnRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomerGateway = "DeleteCustomerGateway"

// DeleteCustomerGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomerGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomerGateway for more information on using the DeleteCustomerGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCustomerGatewayRequest method.
//    req, resp := client.DeleteCustomerGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway
func (c *EC2) DeleteCustomerGatewayRequest(input *DeleteCustomerGatewayInput) (req *request.Request, output *DeleteCustomerGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomerGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomerGatewayInput{}
	}

	output = &DeleteCustomerGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomerGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified customer gateway. You must delete the VPN connection
// before you can delete the customer gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteCustomerGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway
func (c *EC2) DeleteCustomerGateway(input *DeleteCustomerGatewayInput) (*DeleteCustomerGatewayOutput, error) {
	req, out := c.DeleteCustomerGatewayRequest(input)
	return out, req.Send()
}

// DeleteCustomerGatewayWithContext is the same as DeleteCustomerGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomerGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteCustomerGatewayWithContext(ctx aws.Context, input *DeleteCustomerGatewayInput, opts ...request.Option) (*DeleteCustomerGatewayOutput, error) {
	req, out := c.DeleteCustomerGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDhcpOptions = "DeleteDhcpOptions"

// DeleteDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDhcpOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDhcpOptions for more information on using the DeleteDhcpOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDhcpOptionsRequest method.
//    req, resp := client.DeleteDhcpOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions
func (c *EC2) DeleteDhcpOptionsRequest(input *DeleteDhcpOptionsInput) (req *request.Request, output *DeleteDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opDeleteDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDhcpOptionsInput{}
	}

	output = &DeleteDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified set of DHCP options. You must disassociate the set
// of DHCP options before you can delete it. You can disassociate the set of
// DHCP options by associating either a new set of options or the default set
// of options with the VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteDhcpOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions
func (c *EC2) DeleteDhcpOptions(input *DeleteDhcpOptionsInput) (*DeleteDhcpOptionsOutput, error) {
	req, out := c.DeleteDhcpOptionsRequest(input)
	return out, req.Send()
}

// DeleteDhcpOptionsWithContext is the same as DeleteDhcpOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDhcpOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteDhcpOptionsWithContext(ctx aws.Context, input *DeleteDhcpOptionsInput, opts ...request.Option) (*DeleteDhcpOptionsOutput, error) {
	req, out := c.DeleteDhcpOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEgressOnlyInternetGateway = "DeleteEgressOnlyInternetGateway"

// DeleteEgressOnlyInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEgressOnlyInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEgressOnlyInternetGateway for more information on using the DeleteEgressOnlyInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEgressOnlyInternetGatewayRequest method.
//    req, resp := client.DeleteEgressOnlyInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway
func (c *EC2) DeleteEgressOnlyInternetGatewayRequest(input *DeleteEgressOnlyInternetGatewayInput) (req *request.Request, output *DeleteEgressOnlyInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteEgressOnlyInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEgressOnlyInternetGatewayInput{}
	}

	output = &DeleteEgressOnlyInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEgressOnlyInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes an egress-only internet gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteEgressOnlyInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway
func (c *EC2) DeleteEgressOnlyInternetGateway(input *DeleteEgressOnlyInternetGatewayInput) (*DeleteEgressOnlyInternetGatewayOutput, error) {
	req, out := c.DeleteEgressOnlyInternetGatewayRequest(input)
	return out, req.Send()
}

// DeleteEgressOnlyInternetGatewayWithContext is the same as DeleteEgressOnlyInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEgressOnlyInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteEgressOnlyInternetGatewayWithContext(ctx aws.Context, input *DeleteEgressOnlyInternetGatewayInput, opts ...request.Option) (*DeleteEgressOnlyInternetGatewayOutput, error) {
	req, out := c.DeleteEgressOnlyInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleets = "DeleteFleets"

// DeleteFleetsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleets for more information on using the DeleteFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFleetsRequest method.
//    req, resp := client.DeleteFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets
func (c *EC2) DeleteFleetsRequest(input *DeleteFleetsInput) (req *request.Request, output *DeleteFleetsOutput) {
	op := &request.Operation{
		Name:       opDeleteFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetsInput{}
	}

	output = &DeleteFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFleets API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified EC2 Fleet.
//
// After you delete an EC2 Fleet, it launches no new instances.
//
// You must specify whether a deleted EC2 Fleet should also terminate its instances.
// If you choose to terminate the instances, the EC2 Fleet enters the deleted_terminating
// state. Otherwise, the EC2 Fleet enters the deleted_running state, and the
// instances continue to run until they are interrupted or you terminate them
// manually.
//
// For instant fleets, EC2 Fleet must terminate the instances when the fleet
// is deleted. A deleted instant fleet with running instances is not supported.
//
// Restrictions
//
//    * You can delete up to 25 instant fleets in a single request. If you exceed
//    this number, no instant fleets are deleted and an error is returned. There
//    is no restriction on the number of fleets of type maintain or request
//    that can be deleted in a single request.
//
//    * Up to 1000 instances can be terminated in a single request to delete
//    instant fleets.
//
// For more information, see Deleting an EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteFleets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets
func (c *EC2) DeleteFleets(input *DeleteFleetsInput) (*DeleteFleetsOutput, error) {
	req, out := c.DeleteFleetsRequest(input)
	return out, req.Send()
}

// DeleteFleetsWithContext is the same as DeleteFleets with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteFleetsWithContext(ctx aws.Context, input *DeleteFleetsInput, opts ...request.Option) (*DeleteFleetsOutput, error) {
	req, out := c.DeleteFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlowLogs = "DeleteFlowLogs"

// DeleteFlowLogsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlowLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlowLogs for more information on using the DeleteFlowLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFlowLogsRequest method.
//    req, resp := client.DeleteFlowLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs
func (c *EC2) DeleteFlowLogsRequest(input *DeleteFlowLogsInput) (req *request.Request, output *DeleteFlowLogsOutput) {
	op := &request.Operation{
		Name:       opDeleteFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFlowLogsInput{}
	}

	output = &DeleteFlowLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFlowLogs API operation for Amazon Elastic Compute Cloud.
//
// Deletes one or more flow logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteFlowLogs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs
func (c *EC2) DeleteFlowLogs(input *DeleteFlowLogsInput) (*DeleteFlowLogsOutput, error) {
	req, out := c.DeleteFlowLogsRequest(input)
	return out, req.Send()
}

// DeleteFlowLogsWithContext is the same as DeleteFlowLogs with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlowLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteFlowLogsWithContext(ctx aws.Context, input *DeleteFlowLogsInput, opts ...request.Option) (*DeleteFlowLogsOutput, error) {
	req, out := c.DeleteFlowLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFpgaImage = "DeleteFpgaImage"

// DeleteFpgaImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFpgaImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFpgaImage for more information on using the DeleteFpgaImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFpgaImageRequest method.
//    req, resp := client.DeleteFpgaImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage
func (c *EC2) DeleteFpgaImageRequest(input *DeleteFpgaImageInput) (req *request.Request, output *DeleteFpgaImageOutput) {
	op := &request.Operation{
		Name:       opDeleteFpgaImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFpgaImageInput{}
	}

	output = &DeleteFpgaImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFpgaImage API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Amazon FPGA Image (AFI).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteFpgaImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage
func (c *EC2) DeleteFpgaImage(input *DeleteFpgaImageInput) (*DeleteFpgaImageOutput, error) {
	req, out := c.DeleteFpgaImageRequest(input)
	return out, req.Send()
}

// DeleteFpgaImageWithContext is the same as DeleteFpgaImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFpgaImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteFpgaImageWithContext(ctx aws.Context, input *DeleteFpgaImageInput, opts ...request.Option) (*DeleteFpgaImageOutput, error) {
	req, out := c.DeleteFpgaImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInternetGateway = "DeleteInternetGateway"

// DeleteInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInternetGateway for more information on using the DeleteInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInternetGatewayRequest method.
//    req, resp := client.DeleteInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway
func (c *EC2) DeleteInternetGatewayRequest(input *DeleteInternetGatewayInput) (req *request.Request, output *DeleteInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInternetGatewayInput{}
	}

	output = &DeleteInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified internet gateway. You must detach the internet gateway
// from the VPC before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway
func (c *EC2) DeleteInternetGateway(input *DeleteInternetGatewayInput) (*DeleteInternetGatewayOutput, error) {
	req, out := c.DeleteInternetGatewayRequest(input)
	return out, req.Send()
}

// DeleteInternetGatewayWithContext is the same as DeleteInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteInternetGatewayWithContext(ctx aws.Context, input *DeleteInternetGatewayInput, opts ...request.Option) (*DeleteInternetGatewayOutput, error) {
	req, out := c.DeleteInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKeyPair = "DeleteKeyPair"

// DeleteKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKeyPair for more information on using the DeleteKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteKeyPairRequest method.
//    req, resp := client.DeleteKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair
func (c *EC2) DeleteKeyPairRequest(input *DeleteKeyPairInput) (req *request.Request, output *DeleteKeyPairOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyPairInput{}
	}

	output = &DeleteKeyPairOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKeyPair API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified key pair, by removing the public key from Amazon EC2.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteKeyPair for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair
func (c *EC2) DeleteKeyPair(input *DeleteKeyPairInput) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	return out, req.Send()
}

// DeleteKeyPairWithContext is the same as DeleteKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteKeyPairWithContext(ctx aws.Context, input *DeleteKeyPairInput, opts ...request.Option) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunchTemplate = "DeleteLaunchTemplate"

// DeleteLaunchTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunchTemplate for more information on using the DeleteLaunchTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLaunchTemplateRequest method.
//    req, resp := client.DeleteLaunchTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate
func (c *EC2) DeleteLaunchTemplateRequest(input *DeleteLaunchTemplateInput) (req *request.Request, output *DeleteLaunchTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLaunchTemplateInput{}
	}

	output = &DeleteLaunchTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLaunchTemplate API operation for Amazon Elastic Compute Cloud.
//
// Deletes a launch template. Deleting a launch template deletes all of its
// versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLaunchTemplate for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate
func (c *EC2) DeleteLaunchTemplate(input *DeleteLaunchTemplateInput) (*DeleteLaunchTemplateOutput, error) {
	req, out := c.DeleteLaunchTemplateRequest(input)
	return out, req.Send()
}

// DeleteLaunchTemplateWithContext is the same as DeleteLaunchTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunchTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLaunchTemplateWithContext(ctx aws.Context, input *DeleteLaunchTemplateInput, opts ...request.Option) (*DeleteLaunchTemplateOutput, error) {
	req, out := c.DeleteLaunchTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunchTemplateVersions = "DeleteLaunchTemplateVersions"

// DeleteLaunchTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunchTemplateVersions for more information on using the DeleteLaunchTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLaunchTemplateVersionsRequest method.
//    req, resp := client.DeleteLaunchTemplateVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions
func (c *EC2) DeleteLaunchTemplateVersionsRequest(input *DeleteLaunchTemplateVersionsInput) (req *request.Request, output *DeleteLaunchTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchTemplateVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLaunchTemplateVersionsInput{}
	}

	output = &DeleteLaunchTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLaunchTemplateVersions API operation for Amazon Elastic Compute Cloud.
//
// Deletes one or more versions of a launch template. You cannot delete the
// default version of a launch template; you must first assign a different version
// as the default. If the default version is the only version for the launch
// template, you must delete the entire launch template using DeleteLaunchTemplate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLaunchTemplateVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions
func (c *EC2) DeleteLaunchTemplateVersions(input *DeleteLaunchTemplateVersionsInput) (*DeleteLaunchTemplateVersionsOutput, error) {
	req, out := c.DeleteLaunchTemplateVersionsRequest(input)
	return out, req.Send()
}

// DeleteLaunchTemplateVersionsWithContext is the same as DeleteLaunchTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunchTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLaunchTemplateVersionsWithContext(ctx aws.Context, input *DeleteLaunchTemplateVersionsInput, opts ...request.Option) (*DeleteLaunchTemplateVersionsOutput, error) {
	req, out := c.DeleteLaunchTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLocalGatewayRoute = "DeleteLocalGatewayRoute"

// DeleteLocalGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLocalGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLocalGatewayRoute for more information on using the DeleteLocalGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLocalGatewayRouteRequest method.
//    req, resp := client.DeleteLocalGatewayRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute
func (c *EC2) DeleteLocalGatewayRouteRequest(input *DeleteLocalGatewayRouteInput) (req *request.Request, output *DeleteLocalGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteLocalGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocalGatewayRouteInput{}
	}

	output = &DeleteLocalGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLocalGatewayRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route from the specified local gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLocalGatewayRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute
func (c *EC2) DeleteLocalGatewayRoute(input *DeleteLocalGatewayRouteInput) (*DeleteLocalGatewayRouteOutput, error) {
	req, out := c.DeleteLocalGatewayRouteRequest(input)
	return out, req.Send()
}

// DeleteLocalGatewayRouteWithContext is the same as DeleteLocalGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLocalGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLocalGatewayRouteWithContext(ctx aws.Context, input *DeleteLocalGatewayRouteInput, opts ...request.Option) (*DeleteLocalGatewayRouteOutput, error) {
	req, out := c.DeleteLocalGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLocalGatewayRouteTableVpcAssociation = "DeleteLocalGatewayRouteTableVpcAssociation"

// DeleteLocalGatewayRouteTableVpcAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLocalGatewayRouteTableVpcAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLocalGatewayRouteTableVpcAssociation for more information on using the DeleteLocalGatewayRouteTableVpcAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLocalGatewayRouteTableVpcAssociationRequest method.
//    req, resp := client.DeleteLocalGatewayRouteTableVpcAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation
func (c *EC2) DeleteLocalGatewayRouteTableVpcAssociationRequest(input *DeleteLocalGatewayRouteTableVpcAssociationInput) (req *request.Request, output *DeleteLocalGatewayRouteTableVpcAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteLocalGatewayRouteTableVpcAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocalGatewayRouteTableVpcAssociationInput{}
	}

	output = &DeleteLocalGatewayRouteTableVpcAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLocalGatewayRouteTableVpcAssociation API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified association between a VPC and local gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLocalGatewayRouteTableVpcAssociation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation
func (c *EC2) DeleteLocalGatewayRouteTableVpcAssociation(input *DeleteLocalGatewayRouteTableVpcAssociationInput) (*DeleteLocalGatewayRouteTableVpcAssociationOutput, error) {
	req, out := c.DeleteLocalGatewayRouteTableVpcAssociationRequest(input)
	return out, req.Send()
}

// DeleteLocalGatewayRouteTableVpcAssociationWithContext is the same as DeleteLocalGatewayRouteTableVpcAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLocalGatewayRouteTableVpcAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLocalGatewayRouteTableVpcAssociationWithContext(ctx aws.Context, input *DeleteLocalGatewayRouteTableVpcAssociationInput, opts ...request.Option) (*DeleteLocalGatewayRouteTableVpcAssociationOutput, error) {
	req, out := c.DeleteLocalGatewayRouteTableVpcAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteManagedPrefixList = "DeleteManagedPrefixList"

// DeleteManagedPrefixListRequest generates a "aws/request.Request" representing the
// client's request for the DeleteManagedPrefixList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteManagedPrefixList for more information on using the DeleteManagedPrefixList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteManagedPrefixListRequest method.
//    req, resp := client.DeleteManagedPrefixListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList
func (c *EC2) DeleteManagedPrefixListRequest(input *DeleteManagedPrefixListInput) (req *request.Request, output *DeleteManagedPrefixListOutput) {
	op := &request.Operation{
		Name:       opDeleteManagedPrefixList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteManagedPrefixListInput{}
	}

	output = &DeleteManagedPrefixListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteManagedPrefixList API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified managed prefix list. You must first remove all references
// to the prefix list in your resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteManagedPrefixList for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList
func (c *EC2) DeleteManagedPrefixList(input *DeleteManagedPrefixListInput) (*DeleteManagedPrefixListOutput, error) {
	req, out := c.DeleteManagedPrefixListRequest(input)
	return out, req.Send()
}

// DeleteManagedPrefixListWithContext is the same as DeleteManagedPrefixList with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteManagedPrefixList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteManagedPrefixListWithContext(ctx aws.Context, input *DeleteManagedPrefixListInput, opts ...request.Option) (*DeleteManagedPrefixListOutput, error) {
	req, out := c.DeleteManagedPrefixListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNatGateway = "DeleteNatGateway"

// DeleteNatGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNatGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNatGateway for more information on using the DeleteNatGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNatGatewayRequest method.
//    req, resp := client.DeleteNatGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway
func (c *EC2) DeleteNatGatewayRequest(input *DeleteNatGatewayInput) (req *request.Request, output *DeleteNatGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteNatGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNatGatewayInput{}
	}

	output = &DeleteNatGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNatGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified NAT gateway. Deleting a NAT gateway disassociates its
// Elastic IP address, but does not release the address from your account. Deleting
// a NAT gateway does not delete any NAT gateway routes in your route tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNatGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway
func (c *EC2) DeleteNatGateway(input *DeleteNatGatewayInput) (*DeleteNatGatewayOutput, error) {
	req, out := c.DeleteNatGatewayRequest(input)
	return out, req.Send()
}

// DeleteNatGatewayWithContext is the same as DeleteNatGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNatGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNatGatewayWithContext(ctx aws.Context, input *DeleteNatGatewayInput, opts ...request.Option) (*DeleteNatGatewayOutput, error) {
	req, out := c.DeleteNatGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkAcl = "DeleteNetworkAcl"

// DeleteNetworkAclRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkAcl for more information on using the DeleteNetworkAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNetworkAclRequest method.
//    req, resp := client.DeleteNetworkAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl
func (c *EC2) DeleteNetworkAclRequest(input *DeleteNetworkAclInput) (req *request.Request, output *DeleteNetworkAclOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkAcl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkAclInput{}
	}

	output = &DeleteNetworkAclOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkAcl API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified network ACL. You can't delete the ACL if it's associated
// with any subnets. You can't delete the default network ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl
func (c *EC2) DeleteNetworkAcl(input *DeleteNetworkAclInput) (*DeleteNetworkAclOutput, error) {
	req, out := c.DeleteNetworkAclRequest(input)
	return out, req.Send()
}

// DeleteNetworkAclWithContext is the same as DeleteNetworkAcl with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkAclWithContext(ctx aws.Context, input *DeleteNetworkAclInput, opts ...request.Option) (*DeleteNetworkAclOutput, error) {
	req, out := c.DeleteNetworkAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkAclEntry = "DeleteNetworkAclEntry"

// DeleteNetworkAclEntryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkAclEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkAclEntry for more information on using the DeleteNetworkAclEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNetworkAclEntryRequest method.
//    req, resp := client.DeleteNetworkAclEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry
func (c *EC2) DeleteNetworkAclEntryRequest(input *DeleteNetworkAclEntryInput) (req *request.Request, output *DeleteNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkAclEntryInput{}
	}

	output = &DeleteNetworkAclEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkAclEntry API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified ingress or egress entry (rule) from the specified network
// ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkAclEntry for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry
func (c *EC2) DeleteNetworkAclEntry(input *DeleteNetworkAclEntryInput) (*DeleteNetworkAclEntryOutput, error) {
	req, out := c.DeleteNetworkAclEntryRequest(input)
	return out, req.Send()
}

// DeleteNetworkAclEntryWithContext is the same as DeleteNetworkAclEntry with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkAclEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkAclEntryWithContext(ctx aws.Context, input *DeleteNetworkAclEntryInput, opts ...request.Option) (*DeleteNetworkAclEntryOutput, error) {
	req, out := c.DeleteNetworkAclEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInsightsAnalysis = "DeleteNetworkInsightsAnalysis"

// DeleteNetworkInsightsAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInsightsAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInsightsAnalysis for more information on using the DeleteNetworkInsightsAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNetworkInsightsAnalysisRequest method.
//    req, resp := client.DeleteNetworkInsightsAnalysisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis
func (c *EC2) DeleteNetworkInsightsAnalysisRequest(input *DeleteNetworkInsightsAnalysisInput) (req *request.Request, output *DeleteNetworkInsightsAnalysisOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInsightsAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInsightsAnalysisInput{}
	}

	output = &DeleteNetworkInsightsAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetworkInsightsAnalysis API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified network insights analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInsightsAnalysis for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis
func (c *EC2) DeleteNetworkInsightsAnalysis(input *DeleteNetworkInsightsAnalysisInput) (*DeleteNetworkInsightsAnalysisOutput, error) {
	req, out := c.DeleteNetworkInsightsAnalysisRequest(input)
	return out, req.Send()
}

// DeleteNetworkInsightsAnalysisWithContext is the same as DeleteNetworkInsightsAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInsightsAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInsightsAnalysisWithContext(ctx aws.Context, input *DeleteNetworkInsightsAnalysisInput, opts ...request.Option) (*DeleteNetworkInsightsAnalysisOutput, error) {
	req, out := c.DeleteNetworkInsightsAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInsightsPath = "DeleteNetworkInsightsPath"

// DeleteNetworkInsightsPathRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInsightsPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInsightsPath for more information on using the DeleteNetworkInsightsPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNetworkInsightsPathRequest method.
//    req, resp := client.DeleteNetworkInsightsPathRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath
func (c *EC2) DeleteNetworkInsightsPathRequest(input *DeleteNetworkInsightsPathInput) (req *request.Request, output *DeleteNetworkInsightsPathOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInsightsPath,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInsightsPathInput{}
	}

	output = &DeleteNetworkInsightsPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetworkInsightsPath API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified path.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInsightsPath for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath
func (c *EC2) DeleteNetworkInsightsPath(input *DeleteNetworkInsightsPathInput) (*DeleteNetworkInsightsPathOutput, error) {
	req, out := c.DeleteNetworkInsightsPathRequest(input)
	return out, req.Send()
}

// DeleteNetworkInsightsPathWithContext is the same as DeleteNetworkInsightsPath with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInsightsPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInsightsPathWithContext(ctx aws.Context, input *DeleteNetworkInsightsPathInput, opts ...request.Option) (*DeleteNetworkInsightsPathOutput, error) {
	req, out := c.DeleteNetworkInsightsPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInterface = "DeleteNetworkInterface"

// DeleteNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInterface for more information on using the DeleteNetworkInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNetworkInterfaceRequest method.
//    req, resp := client.DeleteNetworkInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface
func (c *EC2) DeleteNetworkInterfaceRequest(input *DeleteNetworkInterfaceInput) (req *request.Request, output *DeleteNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInterfaceInput{}
	}

	output = &DeleteNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified network interface. You must detach the network interface
// before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInterface for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface
func (c *EC2) DeleteNetworkInterface(input *DeleteNetworkInterfaceInput) (*DeleteNetworkInterfaceOutput, error) {
	req, out := c.DeleteNetworkInterfaceRequest(input)
	return out, req.Send()
}

// DeleteNetworkInterfaceWithContext is the same as DeleteNetworkInterface with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInterfaceWithContext(ctx aws.Context, input *DeleteNetworkInterfaceInput, opts ...request.Option) (*DeleteNetworkInterfaceOutput, error) {
	req, out := c.DeleteNetworkInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInterfacePermission = "DeleteNetworkInterfacePermission"

// DeleteNetworkInterfacePermissionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInterfacePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInterfacePermission for more information on using the DeleteNetworkInterfacePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNetworkInterfacePermissionRequest method.
//    req, resp := client.DeleteNetworkInterfacePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission
func (c *EC2) DeleteNetworkInterfacePermissionRequest(input *DeleteNetworkInterfacePermissionInput) (req *request.Request, output *DeleteNetworkInterfacePermissionOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInterfacePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInterfacePermissionInput{}
	}

	output = &DeleteNetworkInterfacePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetworkInterfacePermission API operation for Amazon Elastic Compute Cloud.
//
// Deletes a permission for a network interface. By default, you cannot delete
// the permission if the account for which you're removing the permission has
// attached the network interface to an instance. However, you can force delete
// the permission, regardless of any attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInterfacePermission for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission
func (c *EC2) DeleteNetworkInterfacePermission(input *DeleteNetworkInterfacePermissionInput) (*DeleteNetworkInterfacePermissionOutput, error) {
	req, out := c.DeleteNetworkInterfacePermissionRequest(input)
	return out, req.Send()
}

// DeleteNetworkInterfacePermissionWithContext is the same as DeleteNetworkInterfacePermission with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInterfacePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInterfacePermissionWithContext(ctx aws.Context, input *DeleteNetworkInterfacePermissionInput, opts ...request.Option) (*DeleteNetworkInterfacePermissionOutput, error) {
	req, out := c.DeleteNetworkInterfacePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlacementGroup = "DeletePlacementGroup"

// DeletePlacementGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlacementGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlacementGroup for more information on using the DeletePlacementGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePlacementGroupRequest method.
//    req, resp := client.DeletePlacementGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup
func (c *EC2) DeletePlacementGroupRequest(input *DeletePlacementGroupInput) (req *request.Request, output *DeletePlacementGroupOutput) {
	op := &request.Operation{
		Name:       opDeletePlacementGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePlacementGroupInput{}
	}

	output = &DeletePlacementGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePlacementGroup API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified placement group. You must terminate all instances in
// the placement group before you can delete the placement group. For more information,
// see Placement groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeletePlacementGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup
func (c *EC2) DeletePlacementGroup(input *DeletePlacementGroupInput) (*DeletePlacementGroupOutput, error) {
	req, out := c.DeletePlacementGroupRequest(input)
	return out, req.Send()
}

// DeletePlacementGroupWithContext is the same as DeletePlacementGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlacementGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeletePlacementGroupWithContext(ctx aws.Context, input *DeletePlacementGroupInput, opts ...request.Option) (*DeletePlacementGroupOutput, error) {
	req, out := c.DeletePlacementGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQueuedReservedInstances = "DeleteQueuedReservedInstances"

// DeleteQueuedReservedInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQueuedReservedInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQueuedReservedInstances for more information on using the DeleteQueuedReservedInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteQueuedReservedInstancesRequest method.
//    req, resp := client.DeleteQueuedReservedInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances
func (c *EC2) DeleteQueuedReservedInstancesRequest(input *DeleteQueuedReservedInstancesInput) (req *request.Request, output *DeleteQueuedReservedInstancesOutput) {
	op := &request.Operation{
		Name:       opDeleteQueuedReservedInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteQueuedReservedInstancesInput{}
	}

	output = &DeleteQueuedReservedInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteQueuedReservedInstances API operation for Amazon Elastic Compute Cloud.
//
// Deletes the queued purchases for the specified Reserved Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteQueuedReservedInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances
func (c *EC2) DeleteQueuedReservedInstances(input *DeleteQueuedReservedInstancesInput) (*DeleteQueuedReservedInstancesOutput, error) {
	req, out := c.DeleteQueuedReservedInstancesRequest(input)
	return out, req.Send()
}

// DeleteQueuedReservedInstancesWithContext is the same as DeleteQueuedReservedInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQueuedReservedInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteQueuedReservedInstancesWithContext(ctx aws.Context, input *DeleteQueuedReservedInstancesInput, opts ...request.Option) (*DeleteQueuedReservedInstancesOutput, error) {
	req, out := c.DeleteQueuedReservedInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoute = "DeleteRoute"

// DeleteRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoute for more information on using the DeleteRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRouteRequest method.
//    req, resp := client.DeleteRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute
func (c *EC2) DeleteRouteRequest(input *DeleteRouteInput) (req *request.Request, output *DeleteRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRouteInput{}
	}

	output = &DeleteRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route from the specified route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute
func (c *EC2) DeleteRoute(input *DeleteRouteInput) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	return out, req.Send()
}

// DeleteRouteWithContext is the same as DeleteRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteRouteWithContext(ctx aws.Context, input *DeleteRouteInput, opts ...request.Option) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRouteTable = "DeleteRouteTable"

// DeleteRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRouteTable for more information on using the DeleteRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRouteTableRequest method.
//    req, resp := client.DeleteRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable
func (c *EC2) DeleteRouteTableRequest(input *DeleteRouteTableInput) (req *request.Request, output *DeleteRouteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRouteTableInput{}
	}

	output = &DeleteRouteTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route table. You must disassociate the route table
// from any subnets before you can delete it. You can't delete the main route
// table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable
func (c *EC2) DeleteRouteTable(input *DeleteRouteTableInput) (*DeleteRouteTableOutput, error) {
	req, out := c.DeleteRouteTableRequest(input)
	return out, req.Send()
}

// DeleteRouteTableWithContext is the same as DeleteRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteRouteTableWithContext(ctx aws.Context, input *DeleteRouteTableInput, opts ...request.Option) (*DeleteRouteTableOutput, error) {
	req, out := c.DeleteRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecurityGroup = "DeleteSecurityGroup"

// DeleteSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecurityGroup for more information on using the DeleteSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSecurityGroupRequest method.
//    req, resp := client.DeleteSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup
func (c *EC2) DeleteSecurityGroupRequest(input *DeleteSecurityGroupInput) (req *request.Request, output *DeleteSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecurityGroupInput{}
	}

	output = &DeleteSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityGroup API operation for Amazon Elastic Compute Cloud.
//
// Deletes a security group.
//
// If you attempt to delete a security group that is associated with an instance,
// or is referenced by another security group, the operation fails with InvalidGroup.InUse
// in EC2-Classic or DependencyViolation in EC2-VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSecurityGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup
func (c *EC2) DeleteSecurityGroup(input *DeleteSecurityGroupInput) (*DeleteSecurityGroupOutput, error) {
	req, out := c.DeleteSecurityGroupRequest(input)
	return out, req.Send()
}

// DeleteSecurityGroupWithContext is the same as DeleteSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteSecurityGroupWithContext(ctx aws.Context, input *DeleteSecurityGroupInput, opts ...request.Option) (*DeleteSecurityGroupOutput, error) {
	req, out := c.DeleteSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshot for more information on using the DeleteSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSnapshotRequest method.
//    req, resp := client.DeleteSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot
func (c *EC2) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	output = &DeleteSnapshotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSnapshot API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified snapshot.
//
// When you make periodic snapshots of a volume, the snapshots are incremental,
// and only the blocks on the device that have changed since your last snapshot
// are saved in the new snapshot. When you delete a snapshot, only the data
// not needed for any other snapshot is removed. So regardless of which prior
// snapshots have been deleted, all active snapshots will have access to all
// the information needed to restore the volume.
//
// You cannot delete a snapshot of the root device of an EBS volume used by
// a registered AMI. You must first de-register the AMI before you can delete
// the snapshot.
//
// For more information, see Deleting an Amazon EBS snapshot (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSnapshot for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot
func (c *EC2) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	return out, req.Send()
}

// DeleteSnapshotWithContext is the same as DeleteSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteSnapshotWithContext(ctx aws.Context, input *DeleteSnapshotInput, opts ...request.Option) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSpotDatafeedSubscription = "DeleteSpotDatafeedSubscription"

// DeleteSpotDatafeedSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSpotDatafeedSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSpotDatafeedSubscription for more information on using the DeleteSpotDatafeedSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSpotDatafeedSubscriptionRequest method.
//    req, resp := client.DeleteSpotDatafeedSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription
func (c *EC2) DeleteSpotDatafeedSubscriptionRequest(input *DeleteSpotDatafeedSubscriptionInput) (req *request.Request, output *DeleteSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSpotDatafeedSubscriptionInput{}
	}

	output = &DeleteSpotDatafeedSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSpotDatafeedSubscription API operation for Amazon Elastic Compute Cloud.
//
// Deletes the data feed for Spot Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSpotDatafeedSubscription for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription
func (c *EC2) DeleteSpotDatafeedSubscription(input *DeleteSpotDatafeedSubscriptionInput) (*DeleteSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DeleteSpotDatafeedSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteSpotDatafeedSubscriptionWithContext is the same as DeleteSpotDatafeedSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSpotDatafeedSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteSpotDatafeedSubscriptionWithContext(ctx aws.Context, input *DeleteSpotDatafeedSubscriptionInput, opts ...request.Option) (*DeleteSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DeleteSpotDatafeedSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubnet = "DeleteSubnet"

// DeleteSubnetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubnet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubnet for more information on using the DeleteSubnet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSubnetRequest method.
//    req, resp := client.DeleteSubnetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet
func (c *EC2) DeleteSubnetRequest(input *DeleteSubnetInput) (req *request.Request, output *DeleteSubnetOutput) {
	op := &request.Operation{
		Name:       opDeleteSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubnetInput{}
	}

	output = &DeleteSubnetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubnet API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified subnet. You must terminate all running instances in
// the subnet before you can delete the subnet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSubnet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet
func (c *EC2) DeleteSubnet(input *DeleteSubnetInput) (*DeleteSubnetOutput, error) {
	req, out := c.DeleteSubnetRequest(input)
	return out, req.Send()
}

// DeleteSubnetWithContext is the same as DeleteSubnet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubnet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteSubnetWithContext(ctx aws.Context, input *DeleteSubnetInput, opts ...request.Option) (*DeleteSubnetOutput, error) {
	req, out := c.DeleteSubnetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags
func (c *EC2) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified set of tags from the specified set of resources.
//
// To list the current tags, use DescribeTags. For more information about tags,
// see Tagging Your Resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags
func (c *EC2) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficMirrorFilter = "DeleteTrafficMirrorFilter"

// DeleteTrafficMirrorFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficMirrorFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficMirrorFilter for more information on using the DeleteTrafficMirrorFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrafficMirrorFilterRequest method.
//    req, resp := client.DeleteTrafficMirrorFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter
func (c *EC2) DeleteTrafficMirrorFilterRequest(input *DeleteTrafficMirrorFilterInput) (req *request.Request, output *DeleteTrafficMirrorFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficMirrorFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficMirrorFilterInput{}
	}

	output = &DeleteTrafficMirrorFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrafficMirrorFilter API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Traffic Mirror filter.
//
// You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror
// session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTrafficMirrorFilter for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter
func (c *EC2) DeleteTrafficMirrorFilter(input *DeleteTrafficMirrorFilterInput) (*DeleteTrafficMirrorFilterOutput, error) {
	req, out := c.DeleteTrafficMirrorFilterRequest(input)
	return out, req.Send()
}

// DeleteTrafficMirrorFilterWithContext is the same as DeleteTrafficMirrorFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficMirrorFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTrafficMirrorFilterWithContext(ctx aws.Context, input *DeleteTrafficMirrorFilterInput, opts ...request.Option) (*DeleteTrafficMirrorFilterOutput, error) {
	req, out := c.DeleteTrafficMirrorFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficMirrorFilterRule = "DeleteTrafficMirrorFilterRule"

// DeleteTrafficMirrorFilterRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficMirrorFilterRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficMirrorFilterRule for more information on using the DeleteTrafficMirrorFilterRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrafficMirrorFilterRuleRequest method.
//    req, resp := client.DeleteTrafficMirrorFilterRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule
func (c *EC2) DeleteTrafficMirrorFilterRuleRequest(input *DeleteTrafficMirrorFilterRuleInput) (req *request.Request, output *DeleteTrafficMirrorFilterRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficMirrorFilterRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficMirrorFilterRuleInput{}
	}

	output = &DeleteTrafficMirrorFilterRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrafficMirrorFilterRule API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Traffic Mirror rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTrafficMirrorFilterRule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule
func (c *EC2) DeleteTrafficMirrorFilterRule(input *DeleteTrafficMirrorFilterRuleInput) (*DeleteTrafficMirrorFilterRuleOutput, error) {
	req, out := c.DeleteTrafficMirrorFilterRuleRequest(input)
	return out, req.Send()
}

// DeleteTrafficMirrorFilterRuleWithContext is the same as DeleteTrafficMirrorFilterRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficMirrorFilterRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTrafficMirrorFilterRuleWithContext(ctx aws.Context, input *DeleteTrafficMirrorFilterRuleInput, opts ...request.Option) (*DeleteTrafficMirrorFilterRuleOutput, error) {
	req, out := c.DeleteTrafficMirrorFilterRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficMirrorSession = "DeleteTrafficMirrorSession"

// DeleteTrafficMirrorSessionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficMirrorSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficMirrorSession for more information on using the DeleteTrafficMirrorSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrafficMirrorSessionRequest method.
//    req, resp := client.DeleteTrafficMirrorSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession
func (c *EC2) DeleteTrafficMirrorSessionRequest(input *DeleteTrafficMirrorSessionInput) (req *request.Request, output *DeleteTrafficMirrorSessionOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficMirrorSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficMirrorSessionInput{}
	}

	output = &DeleteTrafficMirrorSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrafficMirrorSession API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Traffic Mirror session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTrafficMirrorSession for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession
func (c *EC2) DeleteTrafficMirrorSession(input *DeleteTrafficMirrorSessionInput) (*DeleteTrafficMirrorSessionOutput, error) {
	req, out := c.DeleteTrafficMirrorSessionRequest(input)
	return out, req.Send()
}

// DeleteTrafficMirrorSessionWithContext is the same as DeleteTrafficMirrorSession with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficMirrorSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTrafficMirrorSessionWithContext(ctx aws.Context, input *DeleteTrafficMirrorSessionInput, opts ...request.Option) (*DeleteTrafficMirrorSessionOutput, error) {
	req, out := c.DeleteTrafficMirrorSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficMirrorTarget = "DeleteTrafficMirrorTarget"

// DeleteTrafficMirrorTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficMirrorTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficMirrorTarget for more information on using the DeleteTrafficMirrorTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrafficMirrorTargetRequest method.
//    req, resp := client.DeleteTrafficMirrorTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget
func (c *EC2) DeleteTrafficMirrorTargetRequest(input *DeleteTrafficMirrorTargetInput) (req *request.Request, output *DeleteTrafficMirrorTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficMirrorTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficMirrorTargetInput{}
	}

	output = &DeleteTrafficMirrorTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrafficMirrorTarget API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Traffic Mirror target.
//
// You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror
// session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTrafficMirrorTarget for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget
func (c *EC2) DeleteTrafficMirrorTarget(input *DeleteTrafficMirrorTargetInput) (*DeleteTrafficMirrorTargetOutput, error) {
	req, out := c.DeleteTrafficMirrorTargetRequest(input)
	return out, req.Send()
}

// DeleteTrafficMirrorTargetWithContext is the same as DeleteTrafficMirrorTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficMirrorTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTrafficMirrorTargetWithContext(ctx aws.Context, input *DeleteTrafficMirrorTargetInput, opts ...request.Option) (*DeleteTrafficMirrorTargetOutput, error) {
	req, out := c.DeleteTrafficMirrorTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGateway = "DeleteTransitGateway"

// DeleteTransitGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGateway for more information on using the DeleteTransitGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTransitGatewayRequest method.
//    req, resp := client.DeleteTransitGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway
func (c *EC2) DeleteTransitGatewayRequest(input *DeleteTransitGatewayInput) (req *request.Request, output *DeleteTransitGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayInput{}
	}

	output = &DeleteTransitGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified transit gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway
func (c *EC2) DeleteTransitGateway(input *DeleteTransitGatewayInput) (*DeleteTransitGatewayOutput, error) {
	req, out := c.DeleteTransitGatewayRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayWithContext is the same as DeleteTransitGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayWithContext(ctx aws.Context, input *DeleteTransitGatewayInput, opts ...request.Option) (*DeleteTransitGatewayOutput, error) {
	req, out := c.DeleteTransitGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayConnect = "DeleteTransitGatewayConnect"

// DeleteTransitGatewayConnectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayConnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayConnect for more information on using the DeleteTransitGatewayConnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTransitGatewayConnectRequest method.
//    req, resp := client.DeleteTransitGatewayConnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect
func (c *EC2) DeleteTransitGatewayConnectRequest(input *DeleteTransitGatewayConnectInput) (req *request.Request, output *DeleteTransitGatewayConnectOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayConnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayConnectInput{}
	}

	output = &DeleteTransitGatewayConnectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayConnect API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Connect attachment. You must first delete any Connect
// peers for the attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayConnect for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect
func (c *EC2) DeleteTransitGatewayConnect(input *DeleteTransitGatewayConnectInput) (*DeleteTransitGatewayConnectOutput, error) {
	req, out := c.DeleteTransitGatewayConnectRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayConnectWithContext is the same as DeleteTransitGatewayConnect with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayConnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayConnectWithContext(ctx aws.Context, input *DeleteTransitGatewayConnectInput, opts ...request.Option) (*DeleteTransitGatewayConnectOutput, error) {
	req, out := c.DeleteTransitGatewayConnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayConnectPeer = "DeleteTransitGatewayConnectPeer"

// DeleteTransitGatewayConnectPeerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayConnectPeer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayConnectPeer for more information on using the DeleteTransitGatewayConnectPeer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTransitGatewayConnectPeerRequest method.
//    req, resp := client.DeleteTransitGatewayConnectPeerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer
func (c *EC2) DeleteTransitGatewayConnectPeerRequest(input *DeleteTransitGatewayConnectPeerInput) (req *request.Request, output *DeleteTransitGatewayConnectPeerOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayConnectPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayConnectPeerInput{}
	}

	output = &DeleteTransitGatewayConnectPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayConnectPeer API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Connect peer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayConnectPeer for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer
func (c *EC2) DeleteTransitGatewayConnectPeer(input *DeleteTransitGatewayConnectPeerInput) (*DeleteTransitGatewayConnectPeerOutput, error) {
	req, out := c.DeleteTransitGatewayConnectPeerRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayConnectPeerWithContext is the same as DeleteTransitGatewayConnectPeer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayConnectPeer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayConnectPeerWithContext(ctx aws.Context, input *DeleteTransitGatewayConnectPeerInput, opts ...request.Option) (*DeleteTransitGatewayConnectPeerOutput, error) {
	req, out := c.DeleteTransitGatewayConnectPeerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayMulticastDomain = "DeleteTransitGatewayMulticastDomain"

// DeleteTransitGatewayMulticastDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayMulticastDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayMulticastDomain for more information on using the DeleteTransitGatewayMulticastDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTransitGatewayMulticastDomainRequest method.
//    req, resp := client.DeleteTransitGatewayMulticastDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain
func (c *EC2) DeleteTransitGatewayMulticastDomainRequest(input *DeleteTransitGatewayMulticastDomainInput) (req *request.Request, output *DeleteTransitGatewayMulticastDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayMulticastDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayMulticastDomainInput{}
	}

	output = &DeleteTransitGatewayMulticastDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayMulticastDomain API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified transit gateway multicast domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayMulticastDomain for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain
func (c *EC2) DeleteTransitGatewayMulticastDomain(input *DeleteTransitGatewayMulticastDomainInput) (*DeleteTransitGatewayMulticastDomainOutput, error) {
	req, out := c.DeleteTransitGatewayMulticastDomainRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayMulticastDomainWithContext is the same as DeleteTransitGatewayMulticastDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayMulticastDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayMulticastDomainWithContext(ctx aws.Context, input *DeleteTransitGatewayMulticastDomainInput, opts ...request.Option) (*DeleteTransitGatewayMulticastDomainOutput, error) {
	req, out := c.DeleteTransitGatewayMulticastDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayPeeringAttachment = "DeleteTransitGatewayPeeringAttachment"

// DeleteTransitGatewayPeeringAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayPeeringAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayPeeringAttachment for more information on using the DeleteTransitGatewayPeeringAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTransitGatewayPeeringAttachmentRequest method.
//    req, resp := client.DeleteTransitGatewayPeeringAttachmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment
func (c *EC2) DeleteTransitGatewayPeeringAttachmentRequest(input *DeleteTransitGatewayPeeringAttachmentInput) (req *request.Request, output *DeleteTransitGatewayPeeringAttachmentOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayPeeringAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayPeeringAttachmentInput{}
	}

	output = &DeleteTransitGatewayPeeringAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayPeeringAttachment API operation for Amazon Elastic Compute Cloud.
//
// Deletes a transit gateway peering attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayPeeringAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment
func (c *EC2) DeleteTransitGatewayPeeringAttachment(input *DeleteTransitGatewayPeeringAttachmentInput) (*DeleteTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.DeleteTransitGatewayPeeringAttachmentRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayPeeringAttachmentWithContext is the same as DeleteTransitGatewayPeeringAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayPeeringAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayPeeringAttachmentWithContext(ctx aws.Context, input *DeleteTransitGatewayPeeringAttachmentInput, opts ...request.Option) (*DeleteTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.DeleteTransitGatewayPeeringAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayPrefixListReference = "DeleteTransitGatewayPrefixListReference"

// DeleteTransitGatewayPrefixListReferenceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayPrefixListReference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayPrefixListReference for more information on using the DeleteTransitGatewayPrefixListReference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTransitGatewayPrefixListReferenceRequest method.
//    req, resp := client.DeleteTransitGatewayPrefixListReferenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference
func (c *EC2) DeleteTransitGatewayPrefixListReferenceRequest(input *DeleteTransitGatewayPrefixListReferenceInput) (req *request.Request, output *DeleteTransitGatewayPrefixListReferenceOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayPrefixListReference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayPrefixListReferenceInput{}
	}

	output = &DeleteTransitGatewayPrefixListReferenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayPrefixListReference API operation for Amazon Elastic Compute Cloud.
//
// Deletes a reference (route) to a prefix list in a specified transit gateway
// route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayPrefixListReference for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference
func (c *EC2) DeleteTransitGatewayPrefixListReference(input *DeleteTransitGatewayPrefixListReferenceInput) (*DeleteTransitGatewayPrefixListReferenceOutput, error) {
	req, out := c.DeleteTransitGatewayPrefixListReferenceRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayPrefixListReferenceWithContext is the same as DeleteTransitGatewayPrefixListReference with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayPrefixListReference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayPrefixListReferenceWithContext(ctx aws.Context, input *DeleteTransitGatewayPrefixListReferenceInput, opts ...request.Option) (*DeleteTransitGatewayPrefixListReferenceOutput, error) {
	req, out := c.DeleteTransitGatewayPrefixListReferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayRoute = "DeleteTransitGatewayRoute"

// DeleteTransitGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayRoute for more information on using the DeleteTransitGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTransitGatewayRouteRequest method.
//    req, resp := client.DeleteTransitGatewayRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute
func (c *EC2) DeleteTransitGatewayRouteRequest(input *DeleteTransitGatewayRouteInput) (req *request.Request, output *DeleteTransitGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayRouteInput{}
	}

	output = &DeleteTransitGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route from the specified transit gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute
func (c *EC2) DeleteTransitGatewayRoute(input *DeleteTransitGatewayRouteInput) (*DeleteTransitGatewayRouteOutput, error) {
	req, out := c.DeleteTransitGatewayRouteRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayRouteWithContext is the same as DeleteTransitGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayRouteWithContext(ctx aws.Context, input *DeleteTransitGatewayRouteInput, opts ...request.Option) (*DeleteTransitGatewayRouteOutput, error) {
	req, out := c.DeleteTransitGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayRouteTable = "DeleteTransitGatewayRouteTable"

// DeleteTransitGatewayRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayRouteTable for more information on using the DeleteTransitGatewayRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTransitGatewayRouteTableRequest method.
//    req, resp := client.DeleteTransitGatewayRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable
func (c *EC2) DeleteTransitGatewayRouteTableRequest(input *DeleteTransitGatewayRouteTableInput) (req *request.Request, output *DeleteTransitGatewayRouteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayRouteTableInput{}
	}

	output = &DeleteTransitGatewayRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified transit gateway route table. You must disassociate
// the route table from any transit gateway route tables before you can delete
// it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable
func (c *EC2) DeleteTransitGatewayRouteTable(input *DeleteTransitGatewayRouteTableInput) (*DeleteTransitGatewayRouteTableOutput, error) {
	req, out := c.DeleteTransitGatewayRouteTableRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayRouteTableWithContext is the same as DeleteTransitGatewayRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayRouteTableWithContext(ctx aws.Context, input *DeleteTransitGatewayRouteTableInput, opts ...request.Option) (*DeleteTransitGatewayRouteTableOutput, error) {
	req, out := c.DeleteTransitGatewayRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayVpcAttachment = "DeleteTransitGatewayVpcAttachment"

// DeleteTransitGatewayVpcAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayVpcAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayVpcAttachment for more information on using the DeleteTransitGatewayVpcAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTransitGatewayVpcAttachmentRequest method.
//    req, resp := client.DeleteTransitGatewayVpcAttachmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment
func (c *EC2) DeleteTransitGatewayVpcAttachmentRequest(input *DeleteTransitGatewayVpcAttachmentInput) (req *request.Request, output *DeleteTransitGatewayVpcAttachmentOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayVpcAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayVpcAttachmentInput{}
	}

	output = &DeleteTransitGatewayVpcAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayVpcAttachment API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPC attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayVpcAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment
func (c *EC2) DeleteTransitGatewayVpcAttachment(input *DeleteTransitGatewayVpcAttachmentInput) (*DeleteTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.DeleteTransitGatewayVpcAttachmentRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayVpcAttachmentWithContext is the same as DeleteTransitGatewayVpcAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayVpcAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayVpcAttachmentWithContext(ctx aws.Context, input *DeleteTransitGatewayVpcAttachmentInput, opts ...request.Option) (*DeleteTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.DeleteTransitGatewayVpcAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVolume = "DeleteVolume"

// DeleteVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVolume for more information on using the DeleteVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVolumeRequest method.
//    req, resp := client.DeleteVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume
func (c *EC2) DeleteVolumeRequest(input *DeleteVolumeInput) (req *request.Request, output *DeleteVolumeOutput) {
	op := &request.Operation{
		Name:       opDeleteVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVolumeInput{}
	}

	output = &DeleteVolumeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVolume API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified EBS volume. The volume must be in the available state
// (not attached to an instance).
//
// The volume can remain in the deleting state for several minutes.
//
// For more information, see Deleting an Amazon EBS volume (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVolume for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume
func (c *EC2) DeleteVolume(input *DeleteVolumeInput) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	return out, req.Send()
}

// DeleteVolumeWithContext is the same as DeleteVolume with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVolumeWithContext(ctx aws.Context, input *DeleteVolumeInput, opts ...request.Option) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpc = "DeleteVpc"

// DeleteVpcRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpc for more information on using the DeleteVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpcRequest method.
//    req, resp := client.DeleteVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc
func (c *EC2) DeleteVpcRequest(input *DeleteVpcInput) (req *request.Request, output *DeleteVpcOutput) {
	op := &request.Operation{
		Name:       opDeleteVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcInput{}
	}

	output = &DeleteVpcOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpc API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPC. You must detach or delete all gateways and resources
// that are associated with the VPC before you can delete it. For example, you
// must terminate all instances running in the VPC, delete all security groups
// associated with the VPC (except the default one), delete all route tables
// associated with the VPC (except the default one), and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpc for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc
func (c *EC2) DeleteVpc(input *DeleteVpcInput) (*DeleteVpcOutput, error) {
	req, out := c.DeleteVpcRequest(input)
	return out, req.Send()
}

// DeleteVpcWithContext is the same as DeleteVpc with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcWithContext(ctx aws.Context, input *DeleteVpcInput, opts ...request.Option) (*DeleteVpcOutput, error) {
	req, out := c.DeleteVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcEndpointConnectionNotifications = "DeleteVpcEndpointConnectionNotifications"

// DeleteVpcEndpointConnectionNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcEndpointConnectionNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcEndpointConnectionNotifications for more information on using the DeleteVpcEndpointConnectionNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpcEndpointConnectionNotificationsRequest method.
//    req, resp := client.DeleteVpcEndpointConnectionNotificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications
func (c *EC2) DeleteVpcEndpointConnectionNotificationsRequest(input *DeleteVpcEndpointConnectionNotificationsInput) (req *request.Request, output *DeleteVpcEndpointConnectionNotificationsOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpointConnectionNotifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointConnectionNotificationsInput{}
	}

	output = &DeleteVpcEndpointConnectionNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcEndpointConnectionNotifications API operation for Amazon Elastic Compute Cloud.
//
// Deletes one or more VPC endpoint connection notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcEndpointConnectionNotifications for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications
func (c *EC2) DeleteVpcEndpointConnectionNotifications(input *DeleteVpcEndpointConnectionNotificationsInput) (*DeleteVpcEndpointConnectionNotificationsOutput, error) {
	req, out := c.DeleteVpcEndpointConnectionNotificationsRequest(input)
	return out, req.Send()
}

// DeleteVpcEndpointConnectionNotificationsWithContext is the same as DeleteVpcEndpointConnectionNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcEndpointConnectionNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcEndpointConnectionNotificationsWithContext(ctx aws.Context, input *DeleteVpcEndpointConnectionNotificationsInput, opts ...request.Option) (*DeleteVpcEndpointConnectionNotificationsOutput, error) {
	req, out := c.DeleteVpcEndpointConnectionNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcEndpointServiceConfigurations = "DeleteVpcEndpointServiceConfigurations"

// DeleteVpcEndpointServiceConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcEndpointServiceConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcEndpointServiceConfigurations for more information on using the DeleteVpcEndpointServiceConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpcEndpointServiceConfigurationsRequest method.
//    req, resp := client.DeleteVpcEndpointServiceConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations
func (c *EC2) DeleteVpcEndpointServiceConfigurationsRequest(input *DeleteVpcEndpointServiceConfigurationsInput) (req *request.Request, output *DeleteVpcEndpointServiceConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpointServiceConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointServiceConfigurationsInput{}
	}

	output = &DeleteVpcEndpointServiceConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcEndpointServiceConfigurations API operation for Amazon Elastic Compute Cloud.
//
// Deletes one or more VPC endpoint service configurations in your account.
// Before you delete the endpoint service configuration, you must reject any
// Available or PendingAcceptance interface endpoint connections that are attached
// to the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcEndpointServiceConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations
func (c *EC2) DeleteVpcEndpointServiceConfigurations(input *DeleteVpcEndpointServiceConfigurationsInput) (*DeleteVpcEndpointServiceConfigurationsOutput, error) {
	req, out := c.DeleteVpcEndpointServiceConfigurationsRequest(input)
	return out, req.Send()
}

// DeleteVpcEndpointServiceConfigurationsWithContext is the same as DeleteVpcEndpointServiceConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcEndpointServiceConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcEndpointServiceConfigurationsWithContext(ctx aws.Context, input *DeleteVpcEndpointServiceConfigurationsInput, opts ...request.Option) (*DeleteVpcEndpointServiceConfigurationsOutput, error) {
	req, out := c.DeleteVpcEndpointServiceConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcEndpoints = "DeleteVpcEndpoints"

// DeleteVpcEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcEndpoints for more information on using the DeleteVpcEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpcEndpointsRequest method.
//    req, resp := client.DeleteVpcEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints
func (c *EC2) DeleteVpcEndpointsRequest(input *DeleteVpcEndpointsInput) (req *request.Request, output *DeleteVpcEndpointsOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointsInput{}
	}

	output = &DeleteVpcEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcEndpoints API operation for Amazon Elastic Compute Cloud.
//
// Deletes one or more specified VPC endpoints. You can delete any of the following
// types of VPC endpoints.
//
//    * Gateway endpoint,
//
//    * Gateway Load Balancer endpoint,
//
//    * Interface endpoint
//
// The following rules apply when you delete a VPC endpoint:
//
//    * When you delete a gateway endpoint, we delete the endpoint routes in
//    the route tables that are associated with the endpoint.
//
//    * When you delete a Gateway Load Balancer endpoint, we delete the endpoint
//    network interfaces. You can only delete Gateway Load Balancer endpoints
//    when the routes that are associated with the endpoint are deleted.
//
//    * When you delete an interface endpoint, we delete the endpoint network
//    interfaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcEndpoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints
func (c *EC2) DeleteVpcEndpoints(input *DeleteVpcEndpointsInput) (*DeleteVpcEndpointsOutput, error) {
	req, out := c.DeleteVpcEndpointsRequest(input)
	return out, req.Send()
}

// DeleteVpcEndpointsWithContext is the same as DeleteVpcEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcEndpointsWithContext(ctx aws.Context, input *DeleteVpcEndpointsInput, opts ...request.Option) (*DeleteVpcEndpointsOutput, error) {
	req, out := c.DeleteVpcEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcPeeringConnection = "DeleteVpcPeeringConnection"

// DeleteVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcPeeringConnection for more information on using the DeleteVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpcPeeringConnectionRequest method.
//    req, resp := client.DeleteVpcPeeringConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection
func (c *EC2) DeleteVpcPeeringConnectionRequest(input *DeleteVpcPeeringConnectionInput) (req *request.Request, output *DeleteVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringConnectionInput{}
	}

	output = &DeleteVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Deletes a VPC peering connection. Either the owner of the requester VPC or
// the owner of the accepter VPC can delete the VPC peering connection if it's
// in the active state. The owner of the requester VPC can delete a VPC peering
// connection in the pending-acceptance state. You cannot delete a VPC peering
// connection that's in the failed state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcPeeringConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection
func (c *EC2) DeleteVpcPeeringConnection(input *DeleteVpcPeeringConnectionInput) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// DeleteVpcPeeringConnectionWithContext is the same as DeleteVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcPeeringConnectionWithContext(ctx aws.Context, input *DeleteVpcPeeringConnectionInput, opts ...request.Option) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpnConnection = "DeleteVpnConnection"

// DeleteVpnConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpnConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpnConnection for more information on using the DeleteVpnConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpnConnectionRequest method.
//    req, resp := client.DeleteVpnConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection
func (c *EC2) DeleteVpnConnectionRequest(input *DeleteVpnConnectionInput) (req *request.Request, output *DeleteVpnConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnConnectionInput{}
	}

	output = &DeleteVpnConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpnConnection API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPN connection.
//
// If you're deleting the VPC and its associated components, we recommend that
// you detach the virtual private gateway from the VPC and delete the VPC before
// deleting the VPN connection. If you believe that the tunnel credentials for
// your VPN connection have been compromised, you can delete the VPN connection
// and create a new one that has new keys, without needing to delete the VPC
// or virtual private gateway. If you create a new VPN connection, you must
// reconfigure the customer gateway device using the new configuration information
// returned with the new VPN connection ID.
//
// For certificate-based authentication, delete all AWS Certificate Manager
// (ACM) private certificates used for the AWS-side tunnel endpoints for the
// VPN connection before deleting the VPN connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpnConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection
func (c *EC2) DeleteVpnConnection(input *DeleteVpnConnectionInput) (*DeleteVpnConnectionOutput, error) {
	req, out := c.DeleteVpnConnectionRequest(input)
	return out, req.Send()
}

// DeleteVpnConnectionWithContext is the same as DeleteVpnConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpnConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpnConnectionWithContext(ctx aws.Context, input *DeleteVpnConnectionInput, opts ...request.Option) (*DeleteVpnConnectionOutput, error) {
	req, out := c.DeleteVpnConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpnConnectionRoute = "DeleteVpnConnectionRoute"

// DeleteVpnConnectionRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpnConnectionRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpnConnectionRoute for more information on using the DeleteVpnConnectionRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpnConnectionRouteRequest method.
//    req, resp := client.DeleteVpnConnectionRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute
func (c *EC2) DeleteVpnConnectionRouteRequest(input *DeleteVpnConnectionRouteInput) (req *request.Request, output *DeleteVpnConnectionRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnConnectionRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnConnectionRouteInput{}
	}

	output = &DeleteVpnConnectionRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpnConnectionRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified static route associated with a VPN connection between
// an existing virtual private gateway and a VPN customer gateway. The static
// route allows traffic to be routed from the virtual private gateway to the
// VPN customer gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpnConnectionRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute
func (c *EC2) DeleteVpnConnectionRoute(input *DeleteVpnConnectionRouteInput) (*DeleteVpnConnectionRouteOutput, error) {
	req, out := c.DeleteVpnConnectionRouteRequest(input)
	return out, req.Send()
}

// DeleteVpnConnectionRouteWithContext is the same as DeleteVpnConnectionRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpnConnectionRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpnConnectionRouteWithContext(ctx aws.Context, input *DeleteVpnConnectionRouteInput, opts ...request.Option) (*DeleteVpnConnectionRouteOutput, error) {
	req, out := c.DeleteVpnConnectionRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpnGateway = "DeleteVpnGateway"

// DeleteVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpnGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpnGateway for more information on using the DeleteVpnGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpnGatewayRequest method.
//    req, resp := client.DeleteVpnGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway
func (c *EC2) DeleteVpnGatewayRequest(input *DeleteVpnGatewayInput) (req *request.Request, output *DeleteVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnGatewayInput{}
	}

	output = &DeleteVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified virtual private gateway. You must first detach the
// virtual private gateway from the VPC. Note that you don't need to delete
// the virtual private gateway if you plan to delete and recreate the VPN connection
// between your VPC and your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpnGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway
func (c *EC2) DeleteVpnGateway(input *DeleteVpnGatewayInput) (*DeleteVpnGatewayOutput, error) {
	req, out := c.DeleteVpnGatewayRequest(input)
	return out, req.Send()
}

// DeleteVpnGatewayWithContext is the same as DeleteVpnGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpnGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpnGatewayWithContext(ctx aws.Context, input *DeleteVpnGatewayInput, opts ...request.Option) (*DeleteVpnGatewayOutput, error) {
	req, out := c.DeleteVpnGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprovisionByoipCidr = "DeprovisionByoipCidr"

// DeprovisionByoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the DeprovisionByoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprovisionByoipCidr for more information on using the DeprovisionByoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeprovisionByoipCidrRequest method.
//    req, resp := client.DeprovisionByoipCidrRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr
func (c *EC2) DeprovisionByoipCidrRequest(input *DeprovisionByoipCidrInput) (req *request.Request, output *DeprovisionByoipCidrOutput) {
	op := &request.Operation{
		Name:       opDeprovisionByoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprovisionByoipCidrInput{}
	}

	output = &DeprovisionByoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeprovisionByoipCidr API operation for Amazon Elastic Compute Cloud.
//
// Releases the specified address range that you provisioned for use with your
// AWS resources through bring your own IP addresses (BYOIP) and deletes the
// corresponding address pool.
//
// Before you can release an address range, you must stop advertising it using
// WithdrawByoipCidr and you must not have any IP addresses allocated from its
// address range.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeprovisionByoipCidr for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr
func (c *EC2) DeprovisionByoipCidr(input *DeprovisionByoipCidrInput) (*DeprovisionByoipCidrOutput, error) {
	req, out := c.DeprovisionByoipCidrRequest(input)
	return out, req.Send()
}

// DeprovisionByoipCidrWithContext is the same as DeprovisionByoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See DeprovisionByoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeprovisionByoipCidrWithContext(ctx aws.Context, input *DeprovisionByoipCidrInput, opts ...request.Option) (*DeprovisionByoipCidrOutput, error) {
	req, out := c.DeprovisionByoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterImage = "DeregisterImage"

// DeregisterImageRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterImage for more information on using the DeregisterImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterImageRequest method.
//    req, resp := client.DeregisterImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage
func (c *EC2) DeregisterImageRequest(input *DeregisterImageInput) (req *request.Request, output *DeregisterImageOutput) {
	op := &request.Operation{
		Name:       opDeregisterImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterImageInput{}
	}

	output = &DeregisterImageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterImage API operation for Amazon Elastic Compute Cloud.
//
// Deregisters the specified AMI. After you deregister an AMI, it can't be used
// to launch new instances; however, it doesn't affect any instances that you've
// already launched from the AMI. You'll continue to incur usage costs for those
// instances until you terminate them.
//
// When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot
// that was created for the root volume of the instance during the AMI creation
// process. When you deregister an instance store-backed AMI, it doesn't affect
// the files that you uploaded to Amazon S3 when you created the AMI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeregisterImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage
func (c *EC2) DeregisterImage(input *DeregisterImageInput) (*DeregisterImageOutput, error) {
	req, out := c.DeregisterImageRequest(input)
	return out, req.Send()
}

// DeregisterImageWithContext is the same as DeregisterImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeregisterImageWithContext(ctx aws.Context, input *DeregisterImageInput, opts ...request.Option) (*DeregisterImageOutput, error) {
	req, out := c.DeregisterImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterInstanceEventNotificationAttributes = "DeregisterInstanceEventNotificationAttributes"

// DeregisterInstanceEventNotificationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterInstanceEventNotificationAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterInstanceEventNotificationAttributes for more information on using the DeregisterInstanceEventNotificationAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterInstanceEventNotificationAttributesRequest method.
//    req, resp := client.DeregisterInstanceEventNotificationAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes
func (c *EC2) DeregisterInstanceEventNotificationAttributesRequest(input *DeregisterInstanceEventNotificationAttributesInput) (req *request.Request, output *DeregisterInstanceEventNotificationAttributesOutput) {
	op := &request.Operation{
		Name:       opDeregisterInstanceEventNotificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterInstanceEventNotificationAttributesInput{}
	}

	output = &DeregisterInstanceEventNotificationAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterInstanceEventNotificationAttributes API operation for Amazon Elastic Compute Cloud.
//
// Deregisters tag keys to prevent tags that have the specified tag keys from
// being included in scheduled event notifications for resources in the Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeregisterInstanceEventNotificationAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes
func (c *EC2) DeregisterInstanceEventNotificationAttributes(input *DeregisterInstanceEventNotificationAttributesInput) (*DeregisterInstanceEventNotificationAttributesOutput, error) {
	req, out := c.DeregisterInstanceEventNotificationAttributesRequest(input)
	return out, req.Send()
}

// DeregisterInstanceEventNotificationAttributesWithContext is the same as DeregisterInstanceEventNotificationAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterInstanceEventNotificationAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeregisterInstanceEventNotificationAttributesWithContext(ctx aws.Context, input *DeregisterInstanceEventNotificationAttributesInput, opts ...request.Option) (*DeregisterInstanceEventNotificationAttributesOutput, error) {
	req, out := c.DeregisterInstanceEventNotificationAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTransitGatewayMulticastGroupMembers = "DeregisterTransitGatewayMulticastGroupMembers"

// DeregisterTransitGatewayMulticastGroupMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTransitGatewayMulticastGroupMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTransitGatewayMulticastGroupMembers for more information on using the DeregisterTransitGatewayMulticastGroupMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterTransitGatewayMulticastGroupMembersRequest method.
//    req, resp := client.DeregisterTransitGatewayMulticastGroupMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers
func (c *EC2) DeregisterTransitGatewayMulticastGroupMembersRequest(input *DeregisterTransitGatewayMulticastGroupMembersInput) (req *request.Request, output *DeregisterTransitGatewayMulticastGroupMembersOutput) {
	op := &request.Operation{
		Name:       opDeregisterTransitGatewayMulticastGroupMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTransitGatewayMulticastGroupMembersInput{}
	}

	output = &DeregisterTransitGatewayMulticastGroupMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTransitGatewayMulticastGroupMembers API operation for Amazon Elastic Compute Cloud.
//
// Deregisters the specified members (network interfaces) from the transit gateway
// multicast group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeregisterTransitGatewayMulticastGroupMembers for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers
func (c *EC2) DeregisterTransitGatewayMulticastGroupMembers(input *DeregisterTransitGatewayMulticastGroupMembersInput) (*DeregisterTransitGatewayMulticastGroupMembersOutput, error) {
	req, out := c.DeregisterTransitGatewayMulticastGroupMembersRequest(input)
	return out, req.Send()
}

// DeregisterTransitGatewayMulticastGroupMembersWithContext is the same as DeregisterTransitGatewayMulticastGroupMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTransitGatewayMulticastGroupMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeregisterTransitGatewayMulticastGroupMembersWithContext(ctx aws.Context, input *DeregisterTransitGatewayMulticastGroupMembersInput, opts ...request.Option) (*DeregisterTransitGatewayMulticastGroupMembersOutput, error) {
	req, out := c.DeregisterTransitGatewayMulticastGroupMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTransitGatewayMulticastGroupSources = "DeregisterTransitGatewayMulticastGroupSources"

// DeregisterTransitGatewayMulticastGroupSourcesRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTransitGatewayMulticastGroupSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTransitGatewayMulticastGroupSources for more information on using the DeregisterTransitGatewayMulticastGroupSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterTransitGatewayMulticastGroupSourcesRequest method.
//    req, resp := client.DeregisterTransitGatewayMulticastGroupSourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources
func (c *EC2) DeregisterTransitGatewayMulticastGroupSourcesRequest(input *DeregisterTransitGatewayMulticastGroupSourcesInput) (req *request.Request, output *DeregisterTransitGatewayMulticastGroupSourcesOutput) {
	op := &request.Operation{
		Name:       opDeregisterTransitGatewayMulticastGroupSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTransitGatewayMulticastGroupSourcesInput{}
	}

	output = &DeregisterTransitGatewayMulticastGroupSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTransitGatewayMulticastGroupSources API operation for Amazon Elastic Compute Cloud.
//
// Deregisters the specified sources (network interfaces) from the transit gateway
// multicast group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeregisterTransitGatewayMulticastGroupSources for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources
func (c *EC2) DeregisterTransitGatewayMulticastGroupSources(input *DeregisterTransitGatewayMulticastGroupSourcesInput) (*DeregisterTransitGatewayMulticastGroupSourcesOutput, error) {
	req, out := c.DeregisterTransitGatewayMulticastGroupSourcesRequest(input)
	return out, req.Send()
}

// DeregisterTransitGatewayMulticastGroupSourcesWithContext is the same as DeregisterTransitGatewayMulticastGroupSources with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTransitGatewayMulticastGroupSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeregisterTransitGatewayMulticastGroupSourcesWithContext(ctx aws.Context, input *DeregisterTransitGatewayMulticastGroupSourcesInput, opts ...request.Option) (*DeregisterTransitGatewayMulticastGroupSourcesOutput, error) {
	req, out := c.DeregisterTransitGatewayMulticastGroupSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes
func (c *EC2) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for Amazon Elastic Compute Cloud.
//
// Describes attributes of your AWS account. The following are the supported
// account attributes:
//
//    * supported-platforms: Indicates whether your account can launch instances
//    into EC2-Classic and EC2-VPC, or only into EC2-VPC.
//
//    * default-vpc: The ID of the default VPC for your account, or none.
//
//    * max-instances: This attribute is no longer supported. The returned value
//    does not reflect your actual vCPU limit for running On-Demand Instances.
//    For more information, see On-Demand Instance Limits (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits)
//    in the Amazon Elastic Compute Cloud User Guide.
//
//    * vpc-max-security-groups-per-interface: The maximum number of security
//    groups that you can assign to a network interface.
//
//    * max-elastic-ips: The maximum number of Elastic IP addresses that you
//    can allocate for use with EC2-Classic.
//
//    * vpc-max-elastic-ips: The maximum number of Elastic IP addresses that
//    you can allocate for use with EC2-VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAccountAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes
func (c *EC2) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddresses = "DescribeAddresses"

// DescribeAddressesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddresses for more information on using the DescribeAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAddressesRequest method.
//    req, resp := client.DescribeAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses
func (c *EC2) DescribeAddressesRequest(input *DescribeAddressesInput) (req *request.Request, output *DescribeAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressesInput{}
	}

	output = &DescribeAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddresses API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
//
// An Elastic IP address is for use in either the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAddresses for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses
func (c *EC2) DescribeAddresses(input *DescribeAddressesInput) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	return out, req.Send()
}

// DescribeAddressesWithContext is the same as DescribeAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAddressesWithContext(ctx aws.Context, input *DescribeAddressesInput, opts ...request.Option) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddressesAttribute = "DescribeAddressesAttribute"

// DescribeAddressesAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddressesAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddressesAttribute for more information on using the DescribeAddressesAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAddressesAttributeRequest method.
//    req, resp := client.DescribeAddressesAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute
func (c *EC2) DescribeAddressesAttributeRequest(input *DescribeAddressesAttributeInput) (req *request.Request, output *DescribeAddressesAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeAddressesAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAddressesAttributeInput{}
	}

	output = &DescribeAddressesAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddressesAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the attributes of the specified Elastic IP addresses. For requirements,
// see Using reverse DNS for email applications (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAddressesAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute
func (c *EC2) DescribeAddressesAttribute(input *DescribeAddressesAttributeInput) (*DescribeAddressesAttributeOutput, error) {
	req, out := c.DescribeAddressesAttributeRequest(input)
	return out, req.Send()
}

// DescribeAddressesAttributeWithContext is the same as DescribeAddressesAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddressesAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAddressesAttributeWithContext(ctx aws.Context, input *DescribeAddressesAttributeInput, opts ...request.Option) (*DescribeAddressesAttributeOutput, error) {
	req, out := c.DescribeAddressesAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAddressesAttributePages iterates over the pages of a DescribeAddressesAttribute operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAddressesAttribute method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAddressesAttribute operation.
//    pageNum := 0
//    err := client.DescribeAddressesAttributePages(params,
//        func(page *ec2.DescribeAddressesAttributeOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeAddressesAttributePages(input *DescribeAddressesAttributeInput, fn func(*DescribeAddressesAttributeOutput, bool) bool) error {
	return c.DescribeAddressesAttributePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAddressesAttributePagesWithContext same as DescribeAddressesAttributePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAddressesAttributePagesWithContext(ctx aws.Context, input *DescribeAddressesAttributeInput, fn func(*DescribeAddressesAttributeOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAddressesAttributeInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAddressesAttributeRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAddressesAttributeOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAggregateIdFormat = "DescribeAggregateIdFormat"

// DescribeAggregateIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregateIdFormat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregateIdFormat for more information on using the DescribeAggregateIdFormat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAggregateIdFormatRequest method.
//    req, resp := client.DescribeAggregateIdFormatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat
func (c *EC2) DescribeAggregateIdFormatRequest(input *DescribeAggregateIdFormatInput) (req *request.Request, output *DescribeAggregateIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregateIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAggregateIdFormatInput{}
	}

	output = &DescribeAggregateIdFormatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregateIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Describes the longer ID format settings for all resource types in a specific
// Region. This request is useful for performing a quick audit to determine
// whether a specific Region is fully opted in for longer IDs (17-character
// IDs).
//
// This request only returns information about resource types that support longer
// IDs.
//
// The following resource types support longer IDs: bundle | conversion-task
// | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association
// | export-task | flow-log | image | import-task | instance | internet-gateway
// | network-acl | network-acl-association | network-interface | network-interface-attachment
// | prefix-list | reservation | route-table | route-table-association | security-group
// | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association
// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAggregateIdFormat for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat
func (c *EC2) DescribeAggregateIdFormat(input *DescribeAggregateIdFormatInput) (*DescribeAggregateIdFormatOutput, error) {
	req, out := c.DescribeAggregateIdFormatRequest(input)
	return out, req.Send()
}

// DescribeAggregateIdFormatWithContext is the same as DescribeAggregateIdFormat with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregateIdFormat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAggregateIdFormatWithContext(ctx aws.Context, input *DescribeAggregateIdFormatInput, opts ...request.Option) (*DescribeAggregateIdFormatOutput, error) {
	req, out := c.DescribeAggregateIdFormatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAvailabilityZones = "DescribeAvailabilityZones"

// DescribeAvailabilityZonesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAvailabilityZones operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAvailabilityZones for more information on using the DescribeAvailabilityZones
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAvailabilityZonesRequest method.
//    req, resp := client.DescribeAvailabilityZonesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones
func (c *EC2) DescribeAvailabilityZonesRequest(input *DescribeAvailabilityZonesInput) (req *request.Request, output *DescribeAvailabilityZonesOutput) {
	op := &request.Operation{
		Name:       opDescribeAvailabilityZones,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailabilityZonesInput{}
	}

	output = &DescribeAvailabilityZonesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAvailabilityZones API operation for Amazon Elastic Compute Cloud.
//
// Describes the Availability Zones, Local Zones, and Wavelength Zones that
// are available to you. If there is an event impacting a zone, you can use
// this request to view the state and any provided messages for that zone.
//
// For more information about Availability Zones, Local Zones, and Wavelength
// Zones, see Regions, Zones and Outposts (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAvailabilityZones for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones
func (c *EC2) DescribeAvailabilityZones(input *DescribeAvailabilityZonesInput) (*DescribeAvailabilityZonesOutput, error) {
	req, out := c.DescribeAvailabilityZonesRequest(input)
	return out, req.Send()
}

// DescribeAvailabilityZonesWithContext is the same as DescribeAvailabilityZones with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAvailabilityZones for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAvailabilityZonesWithContext(ctx aws.Context, input *DescribeAvailabilityZonesInput, opts ...request.Option) (*DescribeAvailabilityZonesOutput, error) {
	req, out := c.DescribeAvailabilityZonesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBundleTasks = "DescribeBundleTasks"

// DescribeBundleTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBundleTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBundleTasks for more information on using the DescribeBundleTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBundleTasksRequest method.
//    req, resp := client.DescribeBundleTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks
func (c *EC2) DescribeBundleTasksRequest(input *DescribeBundleTasksInput) (req *request.Request, output *DescribeBundleTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeBundleTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBundleTasksInput{}
	}

	output = &DescribeBundleTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBundleTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified bundle tasks or all of your bundle tasks.
//
// Completed bundle tasks are listed for only a limited time. If your bundle
// task is no longer in the list, you can still register an AMI from it. Just
// use RegisterImage with the Amazon S3 bucket name and image manifest name
// you provided to the bundle task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeBundleTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks
func (c *EC2) DescribeBundleTasks(input *DescribeBundleTasksInput) (*DescribeBundleTasksOutput, error) {
	req, out := c.DescribeBundleTasksRequest(input)
	return out, req.Send()
}

// DescribeBundleTasksWithContext is the same as DescribeBundleTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBundleTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeBundleTasksWithContext(ctx aws.Context, input *DescribeBundleTasksInput, opts ...request.Option) (*DescribeBundleTasksOutput, error) {
	req, out := c.DescribeBundleTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeByoipCidrs = "DescribeByoipCidrs"

// DescribeByoipCidrsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeByoipCidrs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeByoipCidrs for more information on using the DescribeByoipCidrs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeByoipCidrsRequest method.
//    req, resp := client.DescribeByoipCidrsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs
func (c *EC2) DescribeByoipCidrsRequest(input *DescribeByoipCidrsInput) (req *request.Request, output *DescribeByoipCidrsOutput) {
	op := &request.Operation{
		Name:       opDescribeByoipCidrs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeByoipCidrsInput{}
	}

	output = &DescribeByoipCidrsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeByoipCidrs API operation for Amazon Elastic Compute Cloud.
//
// Describes the IP address ranges that were specified in calls to ProvisionByoipCidr.
//
// To describe the address pools that were created when you provisioned the
// address ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeByoipCidrs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs
func (c *EC2) DescribeByoipCidrs(input *DescribeByoipCidrsInput) (*DescribeByoipCidrsOutput, error) {
	req, out := c.DescribeByoipCidrsRequest(input)
	return out, req.Send()
}

// DescribeByoipCidrsWithContext is the same as DescribeByoipCidrs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeByoipCidrs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeByoipCidrsWithContext(ctx aws.Context, input *DescribeByoipCidrsInput, opts ...request.Option) (*DescribeByoipCidrsOutput, error) {
	req, out := c.DescribeByoipCidrsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeByoipCidrsPages iterates over the pages of a DescribeByoipCidrs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeByoipCidrs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeByoipCidrs operation.
//    pageNum := 0
//    err := client.DescribeByoipCidrsPages(params,
//        func(page *ec2.DescribeByoipCidrsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeByoipCidrsPages(input *DescribeByoipCidrsInput, fn func(*DescribeByoipCidrsOutput, bool) bool) error {
	return c.DescribeByoipCidrsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeByoipCidrsPagesWithContext same as DescribeByoipCidrsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeByoipCidrsPagesWithContext(ctx aws.Context, input *DescribeByoipCidrsInput, fn func(*DescribeByoipCidrsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeByoipCidrsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeByoipCidrsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeByoipCidrsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCapacityReservations = "DescribeCapacityReservations"

// DescribeCapacityReservationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCapacityReservations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCapacityReservations for more information on using the DescribeCapacityReservations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCapacityReservationsRequest method.
//    req, resp := client.DescribeCapacityReservationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations
func (c *EC2) DescribeCapacityReservationsRequest(input *DescribeCapacityReservationsInput) (req *request.Request, output *DescribeCapacityReservationsOutput) {
	op := &request.Operation{
		Name:       opDescribeCapacityReservations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCapacityReservationsInput{}
	}

	output = &DescribeCapacityReservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCapacityReservations API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your Capacity Reservations. The results describe
// only the Capacity Reservations in the AWS Region that you're currently using.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCapacityReservations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations
func (c *EC2) DescribeCapacityReservations(input *DescribeCapacityReservationsInput) (*DescribeCapacityReservationsOutput, error) {
	req, out := c.DescribeCapacityReservationsRequest(input)
	return out, req.Send()
}

// DescribeCapacityReservationsWithContext is the same as DescribeCapacityReservations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCapacityReservations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCapacityReservationsWithContext(ctx aws.Context, input *DescribeCapacityReservationsInput, opts ...request.Option) (*DescribeCapacityReservationsOutput, error) {
	req, out := c.DescribeCapacityReservationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCapacityReservationsPages iterates over the pages of a DescribeCapacityReservations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCapacityReservations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCapacityReservations operation.
//    pageNum := 0
//    err := client.DescribeCapacityReservationsPages(params,
//        func(page *ec2.DescribeCapacityReservationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeCapacityReservationsPages(input *DescribeCapacityReservationsInput, fn func(*DescribeCapacityReservationsOutput, bool) bool) error {
	return c.DescribeCapacityReservationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCapacityReservationsPagesWithContext same as DescribeCapacityReservationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCapacityReservationsPagesWithContext(ctx aws.Context, input *DescribeCapacityReservationsInput, fn func(*DescribeCapacityReservationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCapacityReservationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCapacityReservationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCapacityReservationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCarrierGateways = "DescribeCarrierGateways"

// DescribeCarrierGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCarrierGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCarrierGateways for more information on using the DescribeCarrierGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCarrierGatewaysRequest method.
//    req, resp := client.DescribeCarrierGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways
func (c *EC2) DescribeCarrierGatewaysRequest(input *DescribeCarrierGatewaysInput) (req *request.Request, output *DescribeCarrierGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeCarrierGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCarrierGatewaysInput{}
	}

	output = &DescribeCarrierGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCarrierGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your carrier gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCarrierGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways
func (c *EC2) DescribeCarrierGateways(input *DescribeCarrierGatewaysInput) (*DescribeCarrierGatewaysOutput, error) {
	req, out := c.DescribeCarrierGatewaysRequest(input)
	return out, req.Send()
}

// DescribeCarrierGatewaysWithContext is the same as DescribeCarrierGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCarrierGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCarrierGatewaysWithContext(ctx aws.Context, input *DescribeCarrierGatewaysInput, opts ...request.Option) (*DescribeCarrierGatewaysOutput, error) {
	req, out := c.DescribeCarrierGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCarrierGatewaysPages iterates over the pages of a DescribeCarrierGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCarrierGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCarrierGateways operation.
//    pageNum := 0
//    err := client.DescribeCarrierGatewaysPages(params,
//        func(page *ec2.DescribeCarrierGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeCarrierGatewaysPages(input *DescribeCarrierGatewaysInput, fn func(*DescribeCarrierGatewaysOutput, bool) bool) error {
	return c.DescribeCarrierGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCarrierGatewaysPagesWithContext same as DescribeCarrierGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCarrierGatewaysPagesWithContext(ctx aws.Context, input *DescribeCarrierGatewaysInput, fn func(*DescribeCarrierGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCarrierGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCarrierGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCarrierGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClassicLinkInstances = "DescribeClassicLinkInstances"

// DescribeClassicLinkInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClassicLinkInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClassicLinkInstances for more information on using the DescribeClassicLinkInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClassicLinkInstancesRequest method.
//    req, resp := client.DescribeClassicLinkInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances
func (c *EC2) DescribeClassicLinkInstancesRequest(input *DescribeClassicLinkInstancesInput) (req *request.Request, output *DescribeClassicLinkInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeClassicLinkInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClassicLinkInstancesInput{}
	}

	output = &DescribeClassicLinkInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClassicLinkInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your linked EC2-Classic instances. This request
// only returns information about EC2-Classic instances linked to a VPC through
// ClassicLink. You cannot use this request to return information about other
// instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClassicLinkInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances
func (c *EC2) DescribeClassicLinkInstances(input *DescribeClassicLinkInstancesInput) (*DescribeClassicLinkInstancesOutput, error) {
	req, out := c.DescribeClassicLinkInstancesRequest(input)
	return out, req.Send()
}

// DescribeClassicLinkInstancesWithContext is the same as DescribeClassicLinkInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClassicLinkInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClassicLinkInstancesWithContext(ctx aws.Context, input *DescribeClassicLinkInstancesInput, opts ...request.Option) (*DescribeClassicLinkInstancesOutput, error) {
	req, out := c.DescribeClassicLinkInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClassicLinkInstancesPages iterates over the pages of a DescribeClassicLinkInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClassicLinkInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClassicLinkInstances operation.
//    pageNum := 0
//    err := client.DescribeClassicLinkInstancesPages(params,
//        func(page *ec2.DescribeClassicLinkInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeClassicLinkInstancesPages(input *DescribeClassicLinkInstancesInput, fn func(*DescribeClassicLinkInstancesOutput, bool) bool) error {
	return c.DescribeClassicLinkInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClassicLinkInstancesPagesWithContext same as DescribeClassicLinkInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClassicLinkInstancesPagesWithContext(ctx aws.Context, input *DescribeClassicLinkInstancesInput, fn func(*DescribeClassicLinkInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClassicLinkInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClassicLinkInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClassicLinkInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnAuthorizationRules = "DescribeClientVpnAuthorizationRules"

// DescribeClientVpnAuthorizationRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnAuthorizationRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnAuthorizationRules for more information on using the DescribeClientVpnAuthorizationRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClientVpnAuthorizationRulesRequest method.
//    req, resp := client.DescribeClientVpnAuthorizationRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules
func (c *EC2) DescribeClientVpnAuthorizationRulesRequest(input *DescribeClientVpnAuthorizationRulesInput) (req *request.Request, output *DescribeClientVpnAuthorizationRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnAuthorizationRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnAuthorizationRulesInput{}
	}

	output = &DescribeClientVpnAuthorizationRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnAuthorizationRules API operation for Amazon Elastic Compute Cloud.
//
// Describes the authorization rules for a specified Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnAuthorizationRules for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules
func (c *EC2) DescribeClientVpnAuthorizationRules(input *DescribeClientVpnAuthorizationRulesInput) (*DescribeClientVpnAuthorizationRulesOutput, error) {
	req, out := c.DescribeClientVpnAuthorizationRulesRequest(input)
	return out, req.Send()
}

// DescribeClientVpnAuthorizationRulesWithContext is the same as DescribeClientVpnAuthorizationRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnAuthorizationRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnAuthorizationRulesWithContext(ctx aws.Context, input *DescribeClientVpnAuthorizationRulesInput, opts ...request.Option) (*DescribeClientVpnAuthorizationRulesOutput, error) {
	req, out := c.DescribeClientVpnAuthorizationRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnAuthorizationRulesPages iterates over the pages of a DescribeClientVpnAuthorizationRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnAuthorizationRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClientVpnAuthorizationRules operation.
//    pageNum := 0
//    err := client.DescribeClientVpnAuthorizationRulesPages(params,
//        func(page *ec2.DescribeClientVpnAuthorizationRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeClientVpnAuthorizationRulesPages(input *DescribeClientVpnAuthorizationRulesInput, fn func(*DescribeClientVpnAuthorizationRulesOutput, bool) bool) error {
	return c.DescribeClientVpnAuthorizationRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnAuthorizationRulesPagesWithContext same as DescribeClientVpnAuthorizationRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnAuthorizationRulesPagesWithContext(ctx aws.Context, input *DescribeClientVpnAuthorizationRulesInput, fn func(*DescribeClientVpnAuthorizationRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnAuthorizationRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnAuthorizationRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnAuthorizationRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnConnections = "DescribeClientVpnConnections"

// DescribeClientVpnConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnConnections for more information on using the DescribeClientVpnConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClientVpnConnectionsRequest method.
//    req, resp := client.DescribeClientVpnConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections
func (c *EC2) DescribeClientVpnConnectionsRequest(input *DescribeClientVpnConnectionsInput) (req *request.Request, output *DescribeClientVpnConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnConnectionsInput{}
	}

	output = &DescribeClientVpnConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnConnections API operation for Amazon Elastic Compute Cloud.
//
// Describes active client connections and connections that have been terminated
// within the last 60 minutes for the specified Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnConnections for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections
func (c *EC2) DescribeClientVpnConnections(input *DescribeClientVpnConnectionsInput) (*DescribeClientVpnConnectionsOutput, error) {
	req, out := c.DescribeClientVpnConnectionsRequest(input)
	return out, req.Send()
}

// DescribeClientVpnConnectionsWithContext is the same as DescribeClientVpnConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnConnectionsWithContext(ctx aws.Context, input *DescribeClientVpnConnectionsInput, opts ...request.Option) (*DescribeClientVpnConnectionsOutput, error) {
	req, out := c.DescribeClientVpnConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnConnectionsPages iterates over the pages of a DescribeClientVpnConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClientVpnConnections operation.
//    pageNum := 0
//    err := client.DescribeClientVpnConnectionsPages(params,
//        func(page *ec2.DescribeClientVpnConnectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeClientVpnConnectionsPages(input *DescribeClientVpnConnectionsInput, fn func(*DescribeClientVpnConnectionsOutput, bool) bool) error {
	return c.DescribeClientVpnConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnConnectionsPagesWithContext same as DescribeClientVpnConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnConnectionsPagesWithContext(ctx aws.Context, input *DescribeClientVpnConnectionsInput, fn func(*DescribeClientVpnConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnEndpoints = "DescribeClientVpnEndpoints"

// DescribeClientVpnEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnEndpoints for more information on using the DescribeClientVpnEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClientVpnEndpointsRequest method.
//    req, resp := client.DescribeClientVpnEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints
func (c *EC2) DescribeClientVpnEndpointsRequest(input *DescribeClientVpnEndpointsInput) (req *request.Request, output *DescribeClientVpnEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnEndpointsInput{}
	}

	output = &DescribeClientVpnEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnEndpoints API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more Client VPN endpoints in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnEndpoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints
func (c *EC2) DescribeClientVpnEndpoints(input *DescribeClientVpnEndpointsInput) (*DescribeClientVpnEndpointsOutput, error) {
	req, out := c.DescribeClientVpnEndpointsRequest(input)
	return out, req.Send()
}

// DescribeClientVpnEndpointsWithContext is the same as DescribeClientVpnEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnEndpointsWithContext(ctx aws.Context, input *DescribeClientVpnEndpointsInput, opts ...request.Option) (*DescribeClientVpnEndpointsOutput, error) {
	req, out := c.DescribeClientVpnEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnEndpointsPages iterates over the pages of a DescribeClientVpnEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClientVpnEndpoints operation.
//    pageNum := 0
//    err := client.DescribeClientVpnEndpointsPages(params,
//        func(page *ec2.DescribeClientVpnEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeClientVpnEndpointsPages(input *DescribeClientVpnEndpointsInput, fn func(*DescribeClientVpnEndpointsOutput, bool) bool) error {
	return c.DescribeClientVpnEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnEndpointsPagesWithContext same as DescribeClientVpnEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnEndpointsPagesWithContext(ctx aws.Context, input *DescribeClientVpnEndpointsInput, fn func(*DescribeClientVpnEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnRoutes = "DescribeClientVpnRoutes"

// DescribeClientVpnRoutesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnRoutes for more information on using the DescribeClientVpnRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClientVpnRoutesRequest method.
//    req, resp := client.DescribeClientVpnRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes
func (c *EC2) DescribeClientVpnRoutesRequest(input *DescribeClientVpnRoutesInput) (req *request.Request, output *DescribeClientVpnRoutesOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnRoutes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnRoutesInput{}
	}

	output = &DescribeClientVpnRoutesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnRoutes API operation for Amazon Elastic Compute Cloud.
//
// Describes the routes for the specified Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnRoutes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes
func (c *EC2) DescribeClientVpnRoutes(input *DescribeClientVpnRoutesInput) (*DescribeClientVpnRoutesOutput, error) {
	req, out := c.DescribeClientVpnRoutesRequest(input)
	return out, req.Send()
}

// DescribeClientVpnRoutesWithContext is the same as DescribeClientVpnRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnRoutesWithContext(ctx aws.Context, input *DescribeClientVpnRoutesInput, opts ...request.Option) (*DescribeClientVpnRoutesOutput, error) {
	req, out := c.DescribeClientVpnRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnRoutesPages iterates over the pages of a DescribeClientVpnRoutes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnRoutes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClientVpnRoutes operation.
//    pageNum := 0
//    err := client.DescribeClientVpnRoutesPages(params,
//        func(page *ec2.DescribeClientVpnRoutesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeClientVpnRoutesPages(input *DescribeClientVpnRoutesInput, fn func(*DescribeClientVpnRoutesOutput, bool) bool) error {
	return c.DescribeClientVpnRoutesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnRoutesPagesWithContext same as DescribeClientVpnRoutesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnRoutesPagesWithContext(ctx aws.Context, input *DescribeClientVpnRoutesInput, fn func(*DescribeClientVpnRoutesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnRoutesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnRoutesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnRoutesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnTargetNetworks = "DescribeClientVpnTargetNetworks"

// DescribeClientVpnTargetNetworksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnTargetNetworks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnTargetNetworks for more information on using the DescribeClientVpnTargetNetworks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClientVpnTargetNetworksRequest method.
//    req, resp := client.DescribeClientVpnTargetNetworksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks
func (c *EC2) DescribeClientVpnTargetNetworksRequest(input *DescribeClientVpnTargetNetworksInput) (req *request.Request, output *DescribeClientVpnTargetNetworksOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnTargetNetworks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnTargetNetworksInput{}
	}

	output = &DescribeClientVpnTargetNetworksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnTargetNetworks API operation for Amazon Elastic Compute Cloud.
//
// Describes the target networks associated with the specified Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnTargetNetworks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks
func (c *EC2) DescribeClientVpnTargetNetworks(input *DescribeClientVpnTargetNetworksInput) (*DescribeClientVpnTargetNetworksOutput, error) {
	req, out := c.DescribeClientVpnTargetNetworksRequest(input)
	return out, req.Send()
}

// DescribeClientVpnTargetNetworksWithContext is the same as DescribeClientVpnTargetNetworks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnTargetNetworks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnTargetNetworksWithContext(ctx aws.Context, input *DescribeClientVpnTargetNetworksInput, opts ...request.Option) (*DescribeClientVpnTargetNetworksOutput, error) {
	req, out := c.DescribeClientVpnTargetNetworksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnTargetNetworksPages iterates over the pages of a DescribeClientVpnTargetNetworks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnTargetNetworks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClientVpnTargetNetworks operation.
//    pageNum := 0
//    err := client.DescribeClientVpnTargetNetworksPages(params,
//        func(page *ec2.DescribeClientVpnTargetNetworksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeClientVpnTargetNetworksPages(input *DescribeClientVpnTargetNetworksInput, fn func(*DescribeClientVpnTargetNetworksOutput, bool) bool) error {
	return c.DescribeClientVpnTargetNetworksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnTargetNetworksPagesWithContext same as DescribeClientVpnTargetNetworksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnTargetNetworksPagesWithContext(ctx aws.Context, input *DescribeClientVpnTargetNetworksInput, fn func(*DescribeClientVpnTargetNetworksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnTargetNetworksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnTargetNetworksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnTargetNetworksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCoipPools = "DescribeCoipPools"

// DescribeCoipPoolsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCoipPools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCoipPools for more information on using the DescribeCoipPools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCoipPoolsRequest method.
//    req, resp := client.DescribeCoipPoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPools
func (c *EC2) DescribeCoipPoolsRequest(input *DescribeCoipPoolsInput) (req *request.Request, output *DescribeCoipPoolsOutput) {
	op := &request.Operation{
		Name:       opDescribeCoipPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCoipPoolsInput{}
	}

	output = &DescribeCoipPoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCoipPools API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified customer-owned address pools or all of your customer-owned
// address pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCoipPools for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPools
func (c *EC2) DescribeCoipPools(input *DescribeCoipPoolsInput) (*DescribeCoipPoolsOutput, error) {
	req, out := c.DescribeCoipPoolsRequest(input)
	return out, req.Send()
}

// DescribeCoipPoolsWithContext is the same as DescribeCoipPools with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCoipPools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCoipPoolsWithContext(ctx aws.Context, input *DescribeCoipPoolsInput, opts ...request.Option) (*DescribeCoipPoolsOutput, error) {
	req, out := c.DescribeCoipPoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCoipPoolsPages iterates over the pages of a DescribeCoipPools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCoipPools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCoipPools operation.
//    pageNum := 0
//    err := client.DescribeCoipPoolsPages(params,
//        func(page *ec2.DescribeCoipPoolsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeCoipPoolsPages(input *DescribeCoipPoolsInput, fn func(*DescribeCoipPoolsOutput, bool) bool) error {
	return c.DescribeCoipPoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCoipPoolsPagesWithContext same as DescribeCoipPoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCoipPoolsPagesWithContext(ctx aws.Context, input *DescribeCoipPoolsInput, fn func(*DescribeCoipPoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCoipPoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCoipPoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCoipPoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConversionTasks = "DescribeConversionTasks"

// DescribeConversionTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConversionTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConversionTasks for more information on using the DescribeConversionTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConversionTasksRequest method.
//    req, resp := client.DescribeConversionTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks
func (c *EC2) DescribeConversionTasksRequest(input *DescribeConversionTasksInput) (req *request.Request, output *DescribeConversionTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeConversionTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConversionTasksInput{}
	}

	output = &DescribeConversionTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConversionTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified conversion tasks or all your conversion tasks. For
// more information, see the VM Import/Export User Guide (https://docs.aws.amazon.com/vm-import/latest/userguide/).
//
// For information about the import manifest referenced by this API action,
// see VM Import Manifest (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeConversionTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks
func (c *EC2) DescribeConversionTasks(input *DescribeConversionTasksInput) (*DescribeConversionTasksOutput, error) {
	req, out := c.DescribeConversionTasksRequest(input)
	return out, req.Send()
}

// DescribeConversionTasksWithContext is the same as DescribeConversionTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConversionTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeConversionTasksWithContext(ctx aws.Context, input *DescribeConversionTasksInput, opts ...request.Option) (*DescribeConversionTasksOutput, error) {
	req, out := c.DescribeConversionTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomerGateways = "DescribeCustomerGateways"

// DescribeCustomerGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomerGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomerGateways for more information on using the DescribeCustomerGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCustomerGatewaysRequest method.
//    req, resp := client.DescribeCustomerGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways
func (c *EC2) DescribeCustomerGatewaysRequest(input *DescribeCustomerGatewaysInput) (req *request.Request, output *DescribeCustomerGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomerGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomerGatewaysInput{}
	}

	output = &DescribeCustomerGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomerGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your VPN customer gateways.
//
// For more information, see AWS Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the AWS Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCustomerGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways
func (c *EC2) DescribeCustomerGateways(input *DescribeCustomerGatewaysInput) (*DescribeCustomerGatewaysOutput, error) {
	req, out := c.DescribeCustomerGatewaysRequest(input)
	return out, req.Send()
}

// DescribeCustomerGatewaysWithContext is the same as DescribeCustomerGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomerGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCustomerGatewaysWithContext(ctx aws.Context, input *DescribeCustomerGatewaysInput, opts ...request.Option) (*DescribeCustomerGatewaysOutput, error) {
	req, out := c.DescribeCustomerGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDhcpOptions = "DescribeDhcpOptions"

// DescribeDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDhcpOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDhcpOptions for more information on using the DescribeDhcpOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDhcpOptionsRequest method.
//    req, resp := client.DescribeDhcpOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions
func (c *EC2) DescribeDhcpOptionsRequest(input *DescribeDhcpOptionsInput) (req *request.Request, output *DescribeDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDhcpOptionsInput{}
	}

	output = &DescribeDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your DHCP options sets.
//
// For more information, see DHCP Options Sets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeDhcpOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions
func (c *EC2) DescribeDhcpOptions(input *DescribeDhcpOptionsInput) (*DescribeDhcpOptionsOutput, error) {
	req, out := c.DescribeDhcpOptionsRequest(input)
	return out, req.Send()
}

// DescribeDhcpOptionsWithContext is the same as DescribeDhcpOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDhcpOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeDhcpOptionsWithContext(ctx aws.Context, input *DescribeDhcpOptionsInput, opts ...request.Option) (*DescribeDhcpOptionsOutput, error) {
	req, out := c.DescribeDhcpOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDhcpOptionsPages iterates over the pages of a DescribeDhcpOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDhcpOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDhcpOptions operation.
//    pageNum := 0
//    err := client.DescribeDhcpOptionsPages(params,
//        func(page *ec2.DescribeDhcpOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeDhcpOptionsPages(input *DescribeDhcpOptionsInput, fn func(*DescribeDhcpOptionsOutput, bool) bool) error {
	return c.DescribeDhcpOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDhcpOptionsPagesWithContext same as DescribeDhcpOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeDhcpOptionsPagesWithContext(ctx aws.Context, input *DescribeDhcpOptionsInput, fn func(*DescribeDhcpOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDhcpOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDhcpOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDhcpOptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEgressOnlyInternetGateways = "DescribeEgressOnlyInternetGateways"

// DescribeEgressOnlyInternetGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEgressOnlyInternetGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEgressOnlyInternetGateways for more information on using the DescribeEgressOnlyInternetGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEgressOnlyInternetGatewaysRequest method.
//    req, resp := client.DescribeEgressOnlyInternetGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways
func (c *EC2) DescribeEgressOnlyInternetGatewaysRequest(input *DescribeEgressOnlyInternetGatewaysInput) (req *request.Request, output *DescribeEgressOnlyInternetGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeEgressOnlyInternetGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEgressOnlyInternetGatewaysInput{}
	}

	output = &DescribeEgressOnlyInternetGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEgressOnlyInternetGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your egress-only internet gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeEgressOnlyInternetGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways
func (c *EC2) DescribeEgressOnlyInternetGateways(input *DescribeEgressOnlyInternetGatewaysInput) (*DescribeEgressOnlyInternetGatewaysOutput, error) {
	req, out := c.DescribeEgressOnlyInternetGatewaysRequest(input)
	return out, req.Send()
}

// DescribeEgressOnlyInternetGatewaysWithContext is the same as DescribeEgressOnlyInternetGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEgressOnlyInternetGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeEgressOnlyInternetGatewaysWithContext(ctx aws.Context, input *DescribeEgressOnlyInternetGatewaysInput, opts ...request.Option) (*DescribeEgressOnlyInternetGatewaysOutput, error) {
	req, out := c.DescribeEgressOnlyInternetGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEgressOnlyInternetGatewaysPages iterates over the pages of a DescribeEgressOnlyInternetGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEgressOnlyInternetGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEgressOnlyInternetGateways operation.
//    pageNum := 0
//    err := client.DescribeEgressOnlyInternetGatewaysPages(params,
//        func(page *ec2.DescribeEgressOnlyInternetGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeEgressOnlyInternetGatewaysPages(input *DescribeEgressOnlyInternetGatewaysInput, fn func(*DescribeEgressOnlyInternetGatewaysOutput, bool) bool) error {
	return c.DescribeEgressOnlyInternetGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEgressOnlyInternetGatewaysPagesWithContext same as DescribeEgressOnlyInternetGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeEgressOnlyInternetGatewaysPagesWithContext(ctx aws.Context, input *DescribeEgressOnlyInternetGatewaysInput, fn func(*DescribeEgressOnlyInternetGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEgressOnlyInternetGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEgressOnlyInternetGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEgressOnlyInternetGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeElasticGpus = "DescribeElasticGpus"

// DescribeElasticGpusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticGpus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticGpus for more information on using the DescribeElasticGpus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticGpusRequest method.
//    req, resp := client.DescribeElasticGpusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus
func (c *EC2) DescribeElasticGpusRequest(input *DescribeElasticGpusInput) (req *request.Request, output *DescribeElasticGpusOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticGpus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeElasticGpusInput{}
	}

	output = &DescribeElasticGpusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticGpus API operation for Amazon Elastic Compute Cloud.
//
// Describes the Elastic Graphics accelerator associated with your instances.
// For more information about Elastic Graphics, see Amazon Elastic Graphics
// (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeElasticGpus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus
func (c *EC2) DescribeElasticGpus(input *DescribeElasticGpusInput) (*DescribeElasticGpusOutput, error) {
	req, out := c.DescribeElasticGpusRequest(input)
	return out, req.Send()
}

// DescribeElasticGpusWithContext is the same as DescribeElasticGpus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticGpus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeElasticGpusWithContext(ctx aws.Context, input *DescribeElasticGpusInput, opts ...request.Option) (*DescribeElasticGpusOutput, error) {
	req, out := c.DescribeElasticGpusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExportImageTasks = "DescribeExportImageTasks"

// DescribeExportImageTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportImageTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExportImageTasks for more information on using the DescribeExportImageTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExportImageTasksRequest method.
//    req, resp := client.DescribeExportImageTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks
func (c *EC2) DescribeExportImageTasksRequest(input *DescribeExportImageTasksInput) (req *request.Request, output *DescribeExportImageTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeExportImageTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeExportImageTasksInput{}
	}

	output = &DescribeExportImageTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportImageTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified export image tasks or all of your export image tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeExportImageTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks
func (c *EC2) DescribeExportImageTasks(input *DescribeExportImageTasksInput) (*DescribeExportImageTasksOutput, error) {
	req, out := c.DescribeExportImageTasksRequest(input)
	return out, req.Send()
}

// DescribeExportImageTasksWithContext is the same as DescribeExportImageTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExportImageTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeExportImageTasksWithContext(ctx aws.Context, input *DescribeExportImageTasksInput, opts ...request.Option) (*DescribeExportImageTasksOutput, error) {
	req, out := c.DescribeExportImageTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeExportImageTasksPages iterates over the pages of a DescribeExportImageTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeExportImageTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeExportImageTasks operation.
//    pageNum := 0
//    err := client.DescribeExportImageTasksPages(params,
//        func(page *ec2.DescribeExportImageTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeExportImageTasksPages(input *DescribeExportImageTasksInput, fn func(*DescribeExportImageTasksOutput, bool) bool) error {
	return c.DescribeExportImageTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeExportImageTasksPagesWithContext same as DescribeExportImageTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeExportImageTasksPagesWithContext(ctx aws.Context, input *DescribeExportImageTasksInput, fn func(*DescribeExportImageTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeExportImageTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeExportImageTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeExportImageTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeExportTasks = "DescribeExportTasks"

// DescribeExportTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExportTasks for more information on using the DescribeExportTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExportTasksRequest method.
//    req, resp := client.DescribeExportTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks
func (c *EC2) DescribeExportTasksRequest(input *DescribeExportTasksInput) (req *request.Request, output *DescribeExportTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeExportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportTasksInput{}
	}

	output = &DescribeExportTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified export instance tasks or all of your export instance
// tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeExportTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks
func (c *EC2) DescribeExportTasks(input *DescribeExportTasksInput) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	return out, req.Send()
}

// DescribeExportTasksWithContext is the same as DescribeExportTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExportTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeExportTasksWithContext(ctx aws.Context, input *DescribeExportTasksInput, opts ...request.Option) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFastSnapshotRestores = "DescribeFastSnapshotRestores"

// DescribeFastSnapshotRestoresRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFastSnapshotRestores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFastSnapshotRestores for more information on using the DescribeFastSnapshotRestores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFastSnapshotRestoresRequest method.
//    req, resp := client.DescribeFastSnapshotRestoresRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestores
func (c *EC2) DescribeFastSnapshotRestoresRequest(input *DescribeFastSnapshotRestoresInput) (req *request.Request, output *DescribeFastSnapshotRestoresOutput) {
	op := &request.Operation{
		Name:       opDescribeFastSnapshotRestores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFastSnapshotRestoresInput{}
	}

	output = &DescribeFastSnapshotRestoresOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFastSnapshotRestores API operation for Amazon Elastic Compute Cloud.
//
// Describes the state of fast snapshot restores for your snapshots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFastSnapshotRestores for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestores
func (c *EC2) DescribeFastSnapshotRestores(input *DescribeFastSnapshotRestoresInput) (*DescribeFastSnapshotRestoresOutput, error) {
	req, out := c.DescribeFastSnapshotRestoresRequest(input)
	return out, req.Send()
}

// DescribeFastSnapshotRestoresWithContext is the same as DescribeFastSnapshotRestores with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFastSnapshotRestores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFastSnapshotRestoresWithContext(ctx aws.Context, input *DescribeFastSnapshotRestoresInput, opts ...request.Option) (*DescribeFastSnapshotRestoresOutput, error) {
	req, out := c.DescribeFastSnapshotRestoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFastSnapshotRestoresPages iterates over the pages of a DescribeFastSnapshotRestores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFastSnapshotRestores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeFastSnapshotRestores operation.
//    pageNum := 0
//    err := client.DescribeFastSnapshotRestoresPages(params,
//        func(page *ec2.DescribeFastSnapshotRestoresOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeFastSnapshotRestoresPages(input *DescribeFastSnapshotRestoresInput, fn func(*DescribeFastSnapshotRestoresOutput, bool) bool) error {
	return c.DescribeFastSnapshotRestoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFastSnapshotRestoresPagesWithContext same as DescribeFastSnapshotRestoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFastSnapshotRestoresPagesWithContext(ctx aws.Context, input *DescribeFastSnapshotRestoresInput, fn func(*DescribeFastSnapshotRestoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFastSnapshotRestoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFastSnapshotRestoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFastSnapshotRestoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetHistory = "DescribeFleetHistory"

// DescribeFleetHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetHistory for more information on using the DescribeFleetHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetHistoryRequest method.
//    req, resp := client.DescribeFleetHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistory
func (c *EC2) DescribeFleetHistoryRequest(input *DescribeFleetHistoryInput) (req *request.Request, output *DescribeFleetHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetHistoryInput{}
	}

	output = &DescribeFleetHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetHistory API operation for Amazon Elastic Compute Cloud.
//
// Describes the events for the specified EC2 Fleet during the specified time.
//
// EC2 Fleet events are delayed by up to 30 seconds before they can be described.
// This ensures that you can query by the last evaluated time and not miss a
// recorded event. EC2 Fleet events are available for 48 hours.
//
// For more information, see Monitoring your EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFleetHistory for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistory
func (c *EC2) DescribeFleetHistory(input *DescribeFleetHistoryInput) (*DescribeFleetHistoryOutput, error) {
	req, out := c.DescribeFleetHistoryRequest(input)
	return out, req.Send()
}

// DescribeFleetHistoryWithContext is the same as DescribeFleetHistory with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFleetHistoryWithContext(ctx aws.Context, input *DescribeFleetHistoryInput, opts ...request.Option) (*DescribeFleetHistoryOutput, error) {
	req, out := c.DescribeFleetHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetInstances = "DescribeFleetInstances"

// DescribeFleetInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetInstances for more information on using the DescribeFleetInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetInstancesRequest method.
//    req, resp := client.DescribeFleetInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstances
func (c *EC2) DescribeFleetInstancesRequest(input *DescribeFleetInstancesInput) (req *request.Request, output *DescribeFleetInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetInstancesInput{}
	}

	output = &DescribeFleetInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes the running instances for the specified EC2 Fleet.
//
// For more information, see Monitoring your EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFleetInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstances
func (c *EC2) DescribeFleetInstances(input *DescribeFleetInstancesInput) (*DescribeFleetInstancesOutput, error) {
	req, out := c.DescribeFleetInstancesRequest(input)
	return out, req.Send()
}

// DescribeFleetInstancesWithContext is the same as DescribeFleetInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFleetInstancesWithContext(ctx aws.Context, input *DescribeFleetInstancesInput, opts ...request.Option) (*DescribeFleetInstancesOutput, error) {
	req, out := c.DescribeFleetInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleets = "DescribeFleets"

// DescribeFleetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleets for more information on using the DescribeFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetsRequest method.
//    req, resp := client.DescribeFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets
func (c *EC2) DescribeFleetsRequest(input *DescribeFleetsInput) (req *request.Request, output *DescribeFleetsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetsInput{}
	}

	output = &DescribeFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleets API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified EC2 Fleets or all of your EC2 Fleets.
//
// For more information, see Monitoring your EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFleets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets
func (c *EC2) DescribeFleets(input *DescribeFleetsInput) (*DescribeFleetsOutput, error) {
	req, out := c.DescribeFleetsRequest(input)
	return out, req.Send()
}

// DescribeFleetsWithContext is the same as DescribeFleets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFleetsWithContext(ctx aws.Context, input *DescribeFleetsInput, opts ...request.Option) (*DescribeFleetsOutput, error) {
	req, out := c.DescribeFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetsPages iterates over the pages of a DescribeFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeFleets operation.
//    pageNum := 0
//    err := client.DescribeFleetsPages(params,
//        func(page *ec2.DescribeFleetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeFleetsPages(input *DescribeFleetsInput, fn func(*DescribeFleetsOutput, bool) bool) error {
	return c.DescribeFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetsPagesWithContext same as DescribeFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFleetsPagesWithContext(ctx aws.Context, input *DescribeFleetsInput, fn func(*DescribeFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFlowLogs = "DescribeFlowLogs"

// DescribeFlowLogsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlowLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlowLogs for more information on using the DescribeFlowLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFlowLogsRequest method.
//    req, resp := client.DescribeFlowLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs
func (c *EC2) DescribeFlowLogsRequest(input *DescribeFlowLogsInput) (req *request.Request, output *DescribeFlowLogsOutput) {
	op := &request.Operation{
		Name:       opDescribeFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFlowLogsInput{}
	}

	output = &DescribeFlowLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlowLogs API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more flow logs. To view the information in your flow logs
// (the log streams for the network interfaces), you must use the CloudWatch
// Logs console or the CloudWatch Logs API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFlowLogs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs
func (c *EC2) DescribeFlowLogs(input *DescribeFlowLogsInput) (*DescribeFlowLogsOutput, error) {
	req, out := c.DescribeFlowLogsRequest(input)
	return out, req.Send()
}

// DescribeFlowLogsWithContext is the same as DescribeFlowLogs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlowLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFlowLogsWithContext(ctx aws.Context, input *DescribeFlowLogsInput, opts ...request.Option) (*DescribeFlowLogsOutput, error) {
	req, out := c.DescribeFlowLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFlowLogsPages iterates over the pages of a DescribeFlowLogs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFlowLogs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeFlowLogs operation.
//    pageNum := 0
//    err := client.DescribeFlowLogsPages(params,
//        func(page *ec2.DescribeFlowLogsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeFlowLogsPages(input *DescribeFlowLogsInput, fn func(*DescribeFlowLogsOutput, bool) bool) error {
	return c.DescribeFlowLogsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFlowLogsPagesWithContext same as DescribeFlowLogsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFlowLogsPagesWithContext(ctx aws.Context, input *DescribeFlowLogsInput, fn func(*DescribeFlowLogsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFlowLogsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFlowLogsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFlowLogsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFpgaImageAttribute = "DescribeFpgaImageAttribute"

// DescribeFpgaImageAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFpgaImageAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFpgaImageAttribute for more information on using the DescribeFpgaImageAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFpgaImageAttributeRequest method.
//    req, resp := client.DescribeFpgaImageAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute
func (c *EC2) DescribeFpgaImageAttributeRequest(input *DescribeFpgaImageAttributeInput) (req *request.Request, output *DescribeFpgaImageAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeFpgaImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFpgaImageAttributeInput{}
	}

	output = &DescribeFpgaImageAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFpgaImageAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified Amazon FPGA Image (AFI).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFpgaImageAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute
func (c *EC2) DescribeFpgaImageAttribute(input *DescribeFpgaImageAttributeInput) (*DescribeFpgaImageAttributeOutput, error) {
	req, out := c.DescribeFpgaImageAttributeRequest(input)
	return out, req.Send()
}

// DescribeFpgaImageAttributeWithContext is the same as DescribeFpgaImageAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFpgaImageAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFpgaImageAttributeWithContext(ctx aws.Context, input *DescribeFpgaImageAttributeInput, opts ...request.Option) (*DescribeFpgaImageAttributeOutput, error) {
	req, out := c.DescribeFpgaImageAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFpgaImages = "DescribeFpgaImages"

// DescribeFpgaImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFpgaImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFpgaImages for more information on using the DescribeFpgaImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFpgaImagesRequest method.
//    req, resp := client.DescribeFpgaImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages
func (c *EC2) DescribeFpgaImagesRequest(input *DescribeFpgaImagesInput) (req *request.Request, output *DescribeFpgaImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeFpgaImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFpgaImagesInput{}
	}

	output = &DescribeFpgaImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFpgaImages API operation for Amazon Elastic Compute Cloud.
//
// Describes the Amazon FPGA Images (AFIs) available to you. These include public
// AFIs, private AFIs that you own, and AFIs owned by other AWS accounts for
// which you have load permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFpgaImages for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages
func (c *EC2) DescribeFpgaImages(input *DescribeFpgaImagesInput) (*DescribeFpgaImagesOutput, error) {
	req, out := c.DescribeFpgaImagesRequest(input)
	return out, req.Send()
}

// DescribeFpgaImagesWithContext is the same as DescribeFpgaImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFpgaImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFpgaImagesWithContext(ctx aws.Context, input *DescribeFpgaImagesInput, opts ...request.Option) (*DescribeFpgaImagesOutput, error) {
	req, out := c.DescribeFpgaImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFpgaImagesPages iterates over the pages of a DescribeFpgaImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFpgaImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeFpgaImages operation.
//    pageNum := 0
//    err := client.DescribeFpgaImagesPages(params,
//        func(page *ec2.DescribeFpgaImagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeFpgaImagesPages(input *DescribeFpgaImagesInput, fn func(*DescribeFpgaImagesOutput, bool) bool) error {
	return c.DescribeFpgaImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFpgaImagesPagesWithContext same as DescribeFpgaImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFpgaImagesPagesWithContext(ctx aws.Context, input *DescribeFpgaImagesInput, fn func(*DescribeFpgaImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFpgaImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFpgaImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFpgaImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHostReservationOfferings = "DescribeHostReservationOfferings"

// DescribeHostReservationOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHostReservationOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHostReservationOfferings for more information on using the DescribeHostReservationOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHostReservationOfferingsRequest method.
//    req, resp := client.DescribeHostReservationOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings
func (c *EC2) DescribeHostReservationOfferingsRequest(input *DescribeHostReservationOfferingsInput) (req *request.Request, output *DescribeHostReservationOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeHostReservationOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHostReservationOfferingsInput{}
	}

	output = &DescribeHostReservationOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHostReservationOfferings API operation for Amazon Elastic Compute Cloud.
//
// Describes the Dedicated Host reservations that are available to purchase.
//
// The results describe all of the Dedicated Host reservation offerings, including
// offerings that might not match the instance family and Region of your Dedicated
// Hosts. When purchasing an offering, ensure that the instance family and Region
// of the offering matches that of the Dedicated Hosts with which it is to be
// associated. For more information about supported instance types, see Dedicated
// Hosts (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeHostReservationOfferings for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings
func (c *EC2) DescribeHostReservationOfferings(input *DescribeHostReservationOfferingsInput) (*DescribeHostReservationOfferingsOutput, error) {
	req, out := c.DescribeHostReservationOfferingsRequest(input)
	return out, req.Send()
}

// DescribeHostReservationOfferingsWithContext is the same as DescribeHostReservationOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHostReservationOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostReservationOfferingsWithContext(ctx aws.Context, input *DescribeHostReservationOfferingsInput, opts ...request.Option) (*DescribeHostReservationOfferingsOutput, error) {
	req, out := c.DescribeHostReservationOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeHostReservationOfferingsPages iterates over the pages of a DescribeHostReservationOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHostReservationOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeHostReservationOfferings operation.
//    pageNum := 0
//    err := client.DescribeHostReservationOfferingsPages(params,
//        func(page *ec2.DescribeHostReservationOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeHostReservationOfferingsPages(input *DescribeHostReservationOfferingsInput, fn func(*DescribeHostReservationOfferingsOutput, bool) bool) error {
	return c.DescribeHostReservationOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeHostReservationOfferingsPagesWithContext same as DescribeHostReservationOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostReservationOfferingsPagesWithContext(ctx aws.Context, input *DescribeHostReservationOfferingsInput, fn func(*DescribeHostReservationOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeHostReservationOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeHostReservationOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeHostReservationOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHostReservations = "DescribeHostReservations"

// DescribeHostReservationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHostReservations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHostReservations for more information on using the DescribeHostReservations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHostReservationsRequest method.
//    req, resp := client.DescribeHostReservationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations
func (c *EC2) DescribeHostReservationsRequest(input *DescribeHostReservationsInput) (req *request.Request, output *DescribeHostReservationsOutput) {
	op := &request.Operation{
		Name:       opDescribeHostReservations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHostReservationsInput{}
	}

	output = &DescribeHostReservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHostReservations API operation for Amazon Elastic Compute Cloud.
//
// Describes reservations that are associated with Dedicated Hosts in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeHostReservations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations
func (c *EC2) DescribeHostReservations(input *DescribeHostReservationsInput) (*DescribeHostReservationsOutput, error) {
	req, out := c.DescribeHostReservationsRequest(input)
	return out, req.Send()
}

// DescribeHostReservationsWithContext is the same as DescribeHostReservations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHostReservations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostReservationsWithContext(ctx aws.Context, input *DescribeHostReservationsInput, opts ...request.Option) (*DescribeHostReservationsOutput, error) {
	req, out := c.DescribeHostReservationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeHostReservationsPages iterates over the pages of a DescribeHostReservations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHostReservations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeHostReservations operation.
//    pageNum := 0
//    err := client.DescribeHostReservationsPages(params,
//        func(page *ec2.DescribeHostReservationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeHostReservationsPages(input *DescribeHostReservationsInput, fn func(*DescribeHostReservationsOutput, bool) bool) error {
	return c.DescribeHostReservationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeHostReservationsPagesWithContext same as DescribeHostReservationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostReservationsPagesWithContext(ctx aws.Context, input *DescribeHostReservationsInput, fn func(*DescribeHostReservationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeHostReservationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeHostReservationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeHostReservationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHosts = "DescribeHosts"

// DescribeHostsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHosts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHosts for more information on using the DescribeHosts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHostsRequest method.
//    req, resp := client.DescribeHostsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts
func (c *EC2) DescribeHostsRequest(input *DescribeHostsInput) (req *request.Request, output *DescribeHostsOutput) {
	op := &request.Operation{
		Name:       opDescribeHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHostsInput{}
	}

	output = &DescribeHostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHosts API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified Dedicated Hosts or all your Dedicated Hosts.
//
// The results describe only the Dedicated Hosts in the Region you're currently
// using. All listed instances consume capacity on your Dedicated Host. Dedicated
// Hosts that have recently been released are listed with the state released.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeHosts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts
func (c *EC2) DescribeHosts(input *DescribeHostsInput) (*DescribeHostsOutput, error) {
	req, out := c.DescribeHostsRequest(input)
	return out, req.Send()
}

// DescribeHostsWithContext is the same as DescribeHosts with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHosts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostsWithContext(ctx aws.Context, input *DescribeHostsInput, opts ...request.Option) (*DescribeHostsOutput, error) {
	req, out := c.DescribeHostsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeHostsPages iterates over the pages of a DescribeHosts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHosts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeHosts operation.
//    pageNum := 0
//    err := client.DescribeHostsPages(params,
//        func(page *ec2.DescribeHostsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeHostsPages(input *DescribeHostsInput, fn func(*DescribeHostsOutput, bool) bool) error {
	return c.DescribeHostsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeHostsPagesWithContext same as DescribeHostsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostsPagesWithContext(ctx aws.Context, input *DescribeHostsInput, fn func(*DescribeHostsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeHostsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeHostsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeHostsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeIamInstanceProfileAssociations = "DescribeIamInstanceProfileAssociations"

// DescribeIamInstanceProfileAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIamInstanceProfileAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIamInstanceProfileAssociations for more information on using the DescribeIamInstanceProfileAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIamInstanceProfileAssociationsRequest method.
//    req, resp := client.DescribeIamInstanceProfileAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations
func (c *EC2) DescribeIamInstanceProfileAssociationsRequest(input *DescribeIamInstanceProfileAssociationsInput) (req *request.Request, output *DescribeIamInstanceProfileAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeIamInstanceProfileAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeIamInstanceProfileAssociationsInput{}
	}

	output = &DescribeIamInstanceProfileAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIamInstanceProfileAssociations API operation for Amazon Elastic Compute Cloud.
//
// Describes your IAM instance profile associations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeIamInstanceProfileAssociations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations
func (c *EC2) DescribeIamInstanceProfileAssociations(input *DescribeIamInstanceProfileAssociationsInput) (*DescribeIamInstanceProfileAssociationsOutput, error) {
	req, out := c.DescribeIamInstanceProfileAssociationsRequest(input)
	return out, req.Send()
}

// DescribeIamInstanceProfileAssociationsWithContext is the same as DescribeIamInstanceProfileAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIamInstanceProfileAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIamInstanceProfileAssociationsWithContext(ctx aws.Context, input *DescribeIamInstanceProfileAssociationsInput, opts ...request.Option) (*DescribeIamInstanceProfileAssociationsOutput, error) {
	req, out := c.DescribeIamInstanceProfileAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeIamInstanceProfileAssociationsPages iterates over the pages of a DescribeIamInstanceProfileAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeIamInstanceProfileAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeIamInstanceProfileAssociations operation.
//    pageNum := 0
//    err := client.DescribeIamInstanceProfileAssociationsPages(params,
//        func(page *ec2.DescribeIamInstanceProfileAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeIamInstanceProfileAssociationsPages(input *DescribeIamInstanceProfileAssociationsInput, fn func(*DescribeIamInstanceProfileAssociationsOutput, bool) bool) error {
	return c.DescribeIamInstanceProfileAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeIamInstanceProfileAssociationsPagesWithContext same as DescribeIamInstanceProfileAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIamInstanceProfileAssociationsPagesWithContext(ctx aws.Context, input *DescribeIamInstanceProfileAssociationsInput, fn func(*DescribeIamInstanceProfileAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeIamInstanceProfileAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeIamInstanceProfileAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeIamInstanceProfileAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeIdFormat = "DescribeIdFormat"

// DescribeIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdFormat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdFormat for more information on using the DescribeIdFormat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIdFormatRequest method.
//    req, resp := client.DescribeIdFormatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat
func (c *EC2) DescribeIdFormatRequest(input *DescribeIdFormatInput) (req *request.Request, output *DescribeIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribeIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdFormatInput{}
	}

	output = &DescribeIdFormatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Describes the ID format settings for your resources on a per-Region basis,
// for example, to view which resource types are enabled for longer IDs. This
// request only returns information about resource types whose ID formats can
// be modified; it does not return information about other resource types.
//
// The following resource types support longer IDs: bundle | conversion-task
// | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association
// | export-task | flow-log | image | import-task | instance | internet-gateway
// | network-acl | network-acl-association | network-interface | network-interface-attachment
// | prefix-list | reservation | route-table | route-table-association | security-group
// | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association
// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
//
// These settings apply to the IAM user who makes the request; they do not apply
// to the entire AWS account. By default, an IAM user defaults to the same settings
// as the root user, unless they explicitly override the settings by running
// the ModifyIdFormat command. Resources created with longer IDs are visible
// to all IAM users, regardless of these settings and provided that they have
// permission to use the relevant Describe command for the resource type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeIdFormat for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat
func (c *EC2) DescribeIdFormat(input *DescribeIdFormatInput) (*DescribeIdFormatOutput, error) {
	req, out := c.DescribeIdFormatRequest(input)
	return out, req.Send()
}

// DescribeIdFormatWithContext is the same as DescribeIdFormat with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdFormat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIdFormatWithContext(ctx aws.Context, input *DescribeIdFormatInput, opts ...request.Option) (*DescribeIdFormatOutput, error) {
	req, out := c.DescribeIdFormatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityIdFormat = "DescribeIdentityIdFormat"

// DescribeIdentityIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityIdFormat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityIdFormat for more information on using the DescribeIdentityIdFormat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIdentityIdFormatRequest method.
//    req, resp := client.DescribeIdentityIdFormatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat
func (c *EC2) DescribeIdentityIdFormatRequest(input *DescribeIdentityIdFormatInput) (req *request.Request, output *DescribeIdentityIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityIdFormatInput{}
	}

	output = &DescribeIdentityIdFormatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Describes the ID format settings for resources for the specified IAM user,
// IAM role, or root user. For example, you can view the resource types that
// are enabled for longer IDs. This request only returns information about resource
// types whose ID formats can be modified; it does not return information about
// other resource types. For more information, see Resource IDs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// The following resource types support longer IDs: bundle | conversion-task
// | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association
// | export-task | flow-log | image | import-task | instance | internet-gateway
// | network-acl | network-acl-association | network-interface | network-interface-attachment
// | prefix-list | reservation | route-table | route-table-association | security-group
// | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association
// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
//
// These settings apply to the principal specified in the request. They do not
// apply to the principal that makes the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeIdentityIdFormat for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat
func (c *EC2) DescribeIdentityIdFormat(input *DescribeIdentityIdFormatInput) (*DescribeIdentityIdFormatOutput, error) {
	req, out := c.DescribeIdentityIdFormatRequest(input)
	return out, req.Send()
}

// DescribeIdentityIdFormatWithContext is the same as DescribeIdentityIdFormat with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityIdFormat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIdentityIdFormatWithContext(ctx aws.Context, input *DescribeIdentityIdFormatInput, opts ...request.Option) (*DescribeIdentityIdFormatOutput, error) {
	req, out := c.DescribeIdentityIdFormatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImageAttribute = "DescribeImageAttribute"

// DescribeImageAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImageAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImageAttribute for more information on using the DescribeImageAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImageAttributeRequest method.
//    req, resp := client.DescribeImageAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute
func (c *EC2) DescribeImageAttributeRequest(input *DescribeImageAttributeInput) (req *request.Request, output *DescribeImageAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageAttributeInput{}
	}

	output = &DescribeImageAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImageAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified AMI. You can specify only
// one attribute at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImageAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute
func (c *EC2) DescribeImageAttribute(input *DescribeImageAttributeInput) (*DescribeImageAttributeOutput, error) {
	req, out := c.DescribeImageAttributeRequest(input)
	return out, req.Send()
}

// DescribeImageAttributeWithContext is the same as DescribeImageAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImageAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImageAttributeWithContext(ctx aws.Context, input *DescribeImageAttributeInput, opts ...request.Option) (*DescribeImageAttributeOutput, error) {
	req, out := c.DescribeImageAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImages for more information on using the DescribeImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImagesRequest method.
//    req, resp := client.DescribeImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages
func (c *EC2) DescribeImagesRequest(input *DescribeImagesInput) (req *request.Request, output *DescribeImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	output = &DescribeImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImages API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified images (AMIs, AKIs, and ARIs) available to you or
// all of the images available to you.
//
// The images available to you include public images, private images that you
// own, and private images owned by other AWS accounts for which you have explicit
// launch permissions.
//
// Recently deregistered images appear in the returned results for a short interval
// and then return empty results. After all instances that reference a deregistered
// AMI are terminated, specifying the ID of the image results in an error indicating
// that the AMI ID cannot be found.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImages for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages
func (c *EC2) DescribeImages(input *DescribeImagesInput) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	return out, req.Send()
}

// DescribeImagesWithContext is the same as DescribeImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImagesWithContext(ctx aws.Context, input *DescribeImagesInput, opts ...request.Option) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImportImageTasks = "DescribeImportImageTasks"

// DescribeImportImageTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImportImageTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImportImageTasks for more information on using the DescribeImportImageTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImportImageTasksRequest method.
//    req, resp := client.DescribeImportImageTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks
func (c *EC2) DescribeImportImageTasksRequest(input *DescribeImportImageTasksInput) (req *request.Request, output *DescribeImportImageTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeImportImageTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImportImageTasksInput{}
	}

	output = &DescribeImportImageTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImportImageTasks API operation for Amazon Elastic Compute Cloud.
//
// Displays details about an import virtual machine or import snapshot tasks
// that are already created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImportImageTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks
func (c *EC2) DescribeImportImageTasks(input *DescribeImportImageTasksInput) (*DescribeImportImageTasksOutput, error) {
	req, out := c.DescribeImportImageTasksRequest(input)
	return out, req.Send()
}

// DescribeImportImageTasksWithContext is the same as DescribeImportImageTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImportImageTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImportImageTasksWithContext(ctx aws.Context, input *DescribeImportImageTasksInput, opts ...request.Option) (*DescribeImportImageTasksOutput, error) {
	req, out := c.DescribeImportImageTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImportImageTasksPages iterates over the pages of a DescribeImportImageTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImportImageTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeImportImageTasks operation.
//    pageNum := 0
//    err := client.DescribeImportImageTasksPages(params,
//        func(page *ec2.DescribeImportImageTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeImportImageTasksPages(input *DescribeImportImageTasksInput, fn func(*DescribeImportImageTasksOutput, bool) bool) error {
	return c.DescribeImportImageTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImportImageTasksPagesWithContext same as DescribeImportImageTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImportImageTasksPagesWithContext(ctx aws.Context, input *DescribeImportImageTasksInput, fn func(*DescribeImportImageTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImportImageTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImportImageTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeImportImageTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeImportSnapshotTasks = "DescribeImportSnapshotTasks"

// DescribeImportSnapshotTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImportSnapshotTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImportSnapshotTasks for more information on using the DescribeImportSnapshotTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImportSnapshotTasksRequest method.
//    req, resp := client.DescribeImportSnapshotTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks
func (c *EC2) DescribeImportSnapshotTasksRequest(input *DescribeImportSnapshotTasksInput) (req *request.Request, output *DescribeImportSnapshotTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeImportSnapshotTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImportSnapshotTasksInput{}
	}

	output = &DescribeImportSnapshotTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImportSnapshotTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes your import snapshot tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImportSnapshotTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks
func (c *EC2) DescribeImportSnapshotTasks(input *DescribeImportSnapshotTasksInput) (*DescribeImportSnapshotTasksOutput, error) {
	req, out := c.DescribeImportSnapshotTasksRequest(input)
	return out, req.Send()
}

// DescribeImportSnapshotTasksWithContext is the same as DescribeImportSnapshotTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImportSnapshotTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImportSnapshotTasksWithContext(ctx aws.Context, input *DescribeImportSnapshotTasksInput, opts ...request.Option) (*DescribeImportSnapshotTasksOutput, error) {
	req, out := c.DescribeImportSnapshotTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImportSnapshotTasksPages iterates over the pages of a DescribeImportSnapshotTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImportSnapshotTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeImportSnapshotTasks operation.
//    pageNum := 0
//    err := client.DescribeImportSnapshotTasksPages(params,
//        func(page *ec2.DescribeImportSnapshotTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeImportSnapshotTasksPages(input *DescribeImportSnapshotTasksInput, fn func(*DescribeImportSnapshotTasksOutput, bool) bool) error {
	return c.DescribeImportSnapshotTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImportSnapshotTasksPagesWithContext same as DescribeImportSnapshotTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImportSnapshotTasksPagesWithContext(ctx aws.Context, input *DescribeImportSnapshotTasksInput, fn func(*DescribeImportSnapshotTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImportSnapshotTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImportSnapshotTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeImportSnapshotTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceAttribute = "DescribeInstanceAttribute"

// DescribeInstanceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceAttribute for more information on using the DescribeInstanceAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceAttributeRequest method.
//    req, resp := client.DescribeInstanceAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute
func (c *EC2) DescribeInstanceAttributeRequest(input *DescribeInstanceAttributeInput) (req *request.Request, output *DescribeInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceAttributeInput{}
	}

	output = &DescribeInstanceAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified instance. You can specify
// only one attribute at a time. Valid attribute values are: instanceType |
// kernel | ramdisk | userData | disableApiTermination | instanceInitiatedShutdownBehavior
// | rootDeviceName | blockDeviceMapping | productCodes | sourceDestCheck |
// groupSet | ebsOptimized | sriovNetSupport
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute
func (c *EC2) DescribeInstanceAttribute(input *DescribeInstanceAttributeInput) (*DescribeInstanceAttributeOutput, error) {
	req, out := c.DescribeInstanceAttributeRequest(input)
	return out, req.Send()
}

// DescribeInstanceAttributeWithContext is the same as DescribeInstanceAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceAttributeWithContext(ctx aws.Context, input *DescribeInstanceAttributeInput, opts ...request.Option) (*DescribeInstanceAttributeOutput, error) {
	req, out := c.DescribeInstanceAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceCreditSpecifications = "DescribeInstanceCreditSpecifications"

// DescribeInstanceCreditSpecificationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceCreditSpecifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceCreditSpecifications for more information on using the DescribeInstanceCreditSpecifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceCreditSpecificationsRequest method.
//    req, resp := client.DescribeInstanceCreditSpecificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecifications
func (c *EC2) DescribeInstanceCreditSpecificationsRequest(input *DescribeInstanceCreditSpecificationsInput) (req *request.Request, output *DescribeInstanceCreditSpecificationsOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceCreditSpecifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceCreditSpecificationsInput{}
	}

	output = &DescribeInstanceCreditSpecificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceCreditSpecifications API operation for Amazon Elastic Compute Cloud.
//
// Describes the credit option for CPU usage of the specified burstable performance
// instances. The credit options are standard and unlimited.
//
// If you do not specify an instance ID, Amazon EC2 returns burstable performance
// instances with the unlimited credit option, as well as instances that were
// previously configured as T2, T3, and T3a with the unlimited credit option.
// For example, if you resize a T2 instance, while it is configured as unlimited,
// to an M4 instance, Amazon EC2 returns the M4 instance.
//
// If you specify one or more instance IDs, Amazon EC2 returns the credit option
// (standard or unlimited) of those instances. If you specify an instance ID
// that is not valid, such as an instance that is not a burstable performance
// instance, an error is returned.
//
// Recently terminated instances might appear in the returned results. This
// interval is usually less than one hour.
//
// If an Availability Zone is experiencing a service disruption and you specify
// instance IDs in the affected zone, or do not specify any instance IDs at
// all, the call fails. If you specify only instance IDs in an unaffected zone,
// the call works normally.
//
// For more information, see Burstable performance instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceCreditSpecifications for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecifications
func (c *EC2) DescribeInstanceCreditSpecifications(input *DescribeInstanceCreditSpecificationsInput) (*DescribeInstanceCreditSpecificationsOutput, error) {
	req, out := c.DescribeInstanceCreditSpecificationsRequest(input)
	return out, req.Send()
}

// DescribeInstanceCreditSpecificationsWithContext is the same as DescribeInstanceCreditSpecifications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceCreditSpecifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceCreditSpecificationsWithContext(ctx aws.Context, input *DescribeInstanceCreditSpecificationsInput, opts ...request.Option) (*DescribeInstanceCreditSpecificationsOutput, error) {
	req, out := c.DescribeInstanceCreditSpecificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstanceCreditSpecificationsPages iterates over the pages of a DescribeInstanceCreditSpecifications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceCreditSpecifications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstanceCreditSpecifications operation.
//    pageNum := 0
//    err := client.DescribeInstanceCreditSpecificationsPages(params,
//        func(page *ec2.DescribeInstanceCreditSpecificationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeInstanceCreditSpecificationsPages(input *DescribeInstanceCreditSpecificationsInput, fn func(*DescribeInstanceCreditSpecificationsOutput, bool) bool) error {
	return c.DescribeInstanceCreditSpecificationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstanceCreditSpecificationsPagesWithContext same as DescribeInstanceCreditSpecificationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceCreditSpecificationsPagesWithContext(ctx aws.Context, input *DescribeInstanceCreditSpecificationsInput, fn func(*DescribeInstanceCreditSpecificationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstanceCreditSpecificationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstanceCreditSpecificationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstanceCreditSpecificationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceEventNotificationAttributes = "DescribeInstanceEventNotificationAttributes"

// DescribeInstanceEventNotificationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceEventNotificationAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceEventNotificationAttributes for more information on using the DescribeInstanceEventNotificationAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceEventNotificationAttributesRequest method.
//    req, resp := client.DescribeInstanceEventNotificationAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributes
func (c *EC2) DescribeInstanceEventNotificationAttributesRequest(input *DescribeInstanceEventNotificationAttributesInput) (req *request.Request, output *DescribeInstanceEventNotificationAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceEventNotificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceEventNotificationAttributesInput{}
	}

	output = &DescribeInstanceEventNotificationAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceEventNotificationAttributes API operation for Amazon Elastic Compute Cloud.
//
// Describes the tag keys that are registered to appear in scheduled event notifications
// for resources in the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceEventNotificationAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributes
func (c *EC2) DescribeInstanceEventNotificationAttributes(input *DescribeInstanceEventNotificationAttributesInput) (*DescribeInstanceEventNotificationAttributesOutput, error) {
	req, out := c.DescribeInstanceEventNotificationAttributesRequest(input)
	return out, req.Send()
}

// DescribeInstanceEventNotificationAttributesWithContext is the same as DescribeInstanceEventNotificationAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceEventNotificationAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceEventNotificationAttributesWithContext(ctx aws.Context, input *DescribeInstanceEventNotificationAttributesInput, opts ...request.Option) (*DescribeInstanceEventNotificationAttributesOutput, error) {
	req, out := c.DescribeInstanceEventNotificationAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceStatus = "DescribeInstanceStatus"

// DescribeInstanceStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceStatus for more information on using the DescribeInstanceStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceStatusRequest method.
//    req, resp := client.DescribeInstanceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus
func (c *EC2) DescribeInstanceStatusRequest(input *DescribeInstanceStatusInput) (req *request.Request, output *DescribeInstanceStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceStatusInput{}
	}

	output = &DescribeInstanceStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceStatus API operation for Amazon Elastic Compute Cloud.
//
// Describes the status of the specified instances or all of your instances.
// By default, only running instances are described, unless you specifically
// indicate to return the status of all instances.
//
// Instance status includes the following components:
//
//    * Status checks - Amazon EC2 performs status checks on running EC2 instances
//    to identify hardware and software issues. For more information, see Status
//    checks for your instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html)
//    and Troubleshooting instances with failed status checks (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html)
//    in the Amazon EC2 User Guide.
//
//    * Scheduled events - Amazon EC2 can schedule events (such as reboot, stop,
//    or terminate) for your instances related to hardware issues, software
//    updates, or system maintenance. For more information, see Scheduled events
//    for your instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html)
//    in the Amazon EC2 User Guide.
//
//    * Instance state - You can manage your instances from the moment you launch
//    them through their termination. For more information, see Instance lifecycle
//    (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html)
//    in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceStatus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus
func (c *EC2) DescribeInstanceStatus(input *DescribeInstanceStatusInput) (*DescribeInstanceStatusOutput, error) {
	req, out := c.DescribeInstanceStatusRequest(input)
	return out, req.Send()
}

// DescribeInstanceStatusWithContext is the same as DescribeInstanceStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceStatusWithContext(ctx aws.Context, input *DescribeInstanceStatusInput, opts ...request.Option) (*DescribeInstanceStatusOutput, error) {
	req, out := c.DescribeInstanceStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstanceStatusPages iterates over the pages of a DescribeInstanceStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstanceStatus operation.
//    pageNum := 0
//    err := client.DescribeInstanceStatusPages(params,
//        func(page *ec2.DescribeInstanceStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeInstanceStatusPages(input *DescribeInstanceStatusInput, fn func(*DescribeInstanceStatusOutput, bool) bool) error {
	return c.DescribeInstanceStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstanceStatusPagesWithContext same as DescribeInstanceStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceStatusPagesWithContext(ctx aws.Context, input *DescribeInstanceStatusInput, fn func(*DescribeInstanceStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstanceStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstanceStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstanceStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceTypeOfferings = "DescribeInstanceTypeOfferings"

// DescribeInstanceTypeOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceTypeOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceTypeOfferings for more information on using the DescribeInstanceTypeOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceTypeOfferingsRequest method.
//    req, resp := client.DescribeInstanceTypeOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferings
func (c *EC2) DescribeInstanceTypeOfferingsRequest(input *DescribeInstanceTypeOfferingsInput) (req *request.Request, output *DescribeInstanceTypeOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceTypeOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceTypeOfferingsInput{}
	}

	output = &DescribeInstanceTypeOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceTypeOfferings API operation for Amazon Elastic Compute Cloud.
//
// Returns a list of all instance types offered. The results can be filtered
// by location (Region or Availability Zone). If no location is specified, the
// instance types offered in the current Region are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceTypeOfferings for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferings
func (c *EC2) DescribeInstanceTypeOfferings(input *DescribeInstanceTypeOfferingsInput) (*DescribeInstanceTypeOfferingsOutput, error) {
	req, out := c.DescribeInstanceTypeOfferingsRequest(input)
	return out, req.Send()
}

// DescribeInstanceTypeOfferingsWithContext is the same as DescribeInstanceTypeOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceTypeOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceTypeOfferingsWithContext(ctx aws.Context, input *DescribeInstanceTypeOfferingsInput, opts ...request.Option) (*DescribeInstanceTypeOfferingsOutput, error) {
	req, out := c.DescribeInstanceTypeOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstanceTypeOfferingsPages iterates over the pages of a DescribeInstanceTypeOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceTypeOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstanceTypeOfferings operation.
//    pageNum := 0
//    err := client.DescribeInstanceTypeOfferingsPages(params,
//        func(page *ec2.DescribeInstanceTypeOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeInstanceTypeOfferingsPages(input *DescribeInstanceTypeOfferingsInput, fn func(*DescribeInstanceTypeOfferingsOutput, bool) bool) error {
	return c.DescribeInstanceTypeOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstanceTypeOfferingsPagesWithContext same as DescribeInstanceTypeOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceTypeOfferingsPagesWithContext(ctx aws.Context, input *DescribeInstanceTypeOfferingsInput, fn func(*DescribeInstanceTypeOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstanceTypeOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstanceTypeOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstanceTypeOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceTypes = "DescribeInstanceTypes"

// DescribeInstanceTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceTypes for more information on using the DescribeInstanceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceTypesRequest method.
//    req, resp := client.DescribeInstanceTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypes
func (c *EC2) DescribeInstanceTypesRequest(input *DescribeInstanceTypesInput) (req *request.Request, output *DescribeInstanceTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceTypesInput{}
	}

	output = &DescribeInstanceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceTypes API operation for Amazon Elastic Compute Cloud.
//
// Describes the details of the instance types that are offered in a location.
// The results can be filtered by the attributes of the instance types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceTypes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypes
func (c *EC2) DescribeInstanceTypes(input *DescribeInstanceTypesInput) (*DescribeInstanceTypesOutput, error) {
	req, out := c.DescribeInstanceTypesRequest(input)
	return out, req.Send()
}

// DescribeInstanceTypesWithContext is the same as DescribeInstanceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceTypesWithContext(ctx aws.Context, input *DescribeInstanceTypesInput, opts ...request.Option) (*DescribeInstanceTypesOutput, error) {
	req, out := c.DescribeInstanceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstanceTypesPages iterates over the pages of a DescribeInstanceTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstanceTypes operation.
//    pageNum := 0
//    err := client.DescribeInstanceTypesPages(params,
//        func(page *ec2.DescribeInstanceTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeInstanceTypesPages(input *DescribeInstanceTypesInput, fn func(*DescribeInstanceTypesOutput, bool) bool) error {
	return c.DescribeInstanceTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstanceTypesPagesWithContext same as DescribeInstanceTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceTypesPagesWithContext(ctx aws.Context, input *DescribeInstanceTypesInput, fn func(*DescribeInstanceTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstanceTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstanceTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstanceTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstances for more information on using the DescribeInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstancesRequest method.
//    req, resp := client.DescribeInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances
func (c *EC2) DescribeInstancesRequest(input *DescribeInstancesInput) (req *request.Request, output *DescribeInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	output = &DescribeInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified instances or all instances.
//
// If you specify instance IDs, the output includes information for only the
// specified instances. If you specify filters, the output includes information
// for only those instances that meet the filter criteria. If you do not specify
// instance IDs or filters, the output includes information for all instances,
// which can affect performance. We recommend that you use pagination to ensure
// that the operation returns quickly and successfully.
//
// If you specify an instance ID that is not valid, an error is returned. If
// you specify an instance that you do not own, it is not included in the output.
//
// Recently terminated instances might appear in the returned results. This
// interval is usually less than one hour.
//
// If you describe instances in the rare case where an Availability Zone is
// experiencing a service disruption and you specify instance IDs that are in
// the affected zone, or do not specify any instance IDs at all, the call fails.
// If you describe instances and specify only instance IDs that are in an unaffected
// zone, the call works normally.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances
func (c *EC2) DescribeInstances(input *DescribeInstancesInput) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	return out, req.Send()
}

// DescribeInstancesWithContext is the same as DescribeInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstancesWithContext(ctx aws.Context, input *DescribeInstancesInput, opts ...request.Option) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstancesPages iterates over the pages of a DescribeInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstances operation.
//    pageNum := 0
//    err := client.DescribeInstancesPages(params,
//        func(page *ec2.DescribeInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeInstancesPages(input *DescribeInstancesInput, fn func(*DescribeInstancesOutput, bool) bool) error {
	return c.DescribeInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstancesPagesWithContext same as DescribeInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstancesPagesWithContext(ctx aws.Context, input *DescribeInstancesInput, fn func(*DescribeInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInternetGateways = "DescribeInternetGateways"

// DescribeInternetGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInternetGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInternetGateways for more information on using the DescribeInternetGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInternetGatewaysRequest method.
//    req, resp := client.DescribeInternetGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways
func (c *EC2) DescribeInternetGatewaysRequest(input *DescribeInternetGatewaysInput) (req *request.Request, output *DescribeInternetGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeInternetGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInternetGatewaysInput{}
	}

	output = &DescribeInternetGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInternetGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your internet gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInternetGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways
func (c *EC2) DescribeInternetGateways(input *DescribeInternetGatewaysInput) (*DescribeInternetGatewaysOutput, error) {
	req, out := c.DescribeInternetGatewaysRequest(input)
	return out, req.Send()
}

// DescribeInternetGatewaysWithContext is the same as DescribeInternetGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInternetGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInternetGatewaysWithContext(ctx aws.Context, input *DescribeInternetGatewaysInput, opts ...request.Option) (*DescribeInternetGatewaysOutput, error) {
	req, out := c.DescribeInternetGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInternetGatewaysPages iterates over the pages of a DescribeInternetGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInternetGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInternetGateways operation.
//    pageNum := 0
//    err := client.DescribeInternetGatewaysPages(params,
//        func(page *ec2.DescribeInternetGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeInternetGatewaysPages(input *DescribeInternetGatewaysInput, fn func(*DescribeInternetGatewaysOutput, bool) bool) error {
	return c.DescribeInternetGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInternetGatewaysPagesWithContext same as DescribeInternetGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInternetGatewaysPagesWithContext(ctx aws.Context, input *DescribeInternetGatewaysInput, fn func(*DescribeInternetGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInternetGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInternetGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInternetGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeIpv6Pools = "DescribeIpv6Pools"

// DescribeIpv6PoolsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIpv6Pools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIpv6Pools for more information on using the DescribeIpv6Pools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIpv6PoolsRequest method.
//    req, resp := client.DescribeIpv6PoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpv6Pools
func (c *EC2) DescribeIpv6PoolsRequest(input *DescribeIpv6PoolsInput) (req *request.Request, output *DescribeIpv6PoolsOutput) {
	op := &request.Operation{
		Name:       opDescribeIpv6Pools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeIpv6PoolsInput{}
	}

	output = &DescribeIpv6PoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIpv6Pools API operation for Amazon Elastic Compute Cloud.
//
// Describes your IPv6 address pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeIpv6Pools for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpv6Pools
func (c *EC2) DescribeIpv6Pools(input *DescribeIpv6PoolsInput) (*DescribeIpv6PoolsOutput, error) {
	req, out := c.DescribeIpv6PoolsRequest(input)
	return out, req.Send()
}

// DescribeIpv6PoolsWithContext is the same as DescribeIpv6Pools with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIpv6Pools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIpv6PoolsWithContext(ctx aws.Context, input *DescribeIpv6PoolsInput, opts ...request.Option) (*DescribeIpv6PoolsOutput, error) {
	req, out := c.DescribeIpv6PoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeIpv6PoolsPages iterates over the pages of a DescribeIpv6Pools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeIpv6Pools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeIpv6Pools operation.
//    pageNum := 0
//    err := client.DescribeIpv6PoolsPages(params,
//        func(page *ec2.DescribeIpv6PoolsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeIpv6PoolsPages(input *DescribeIpv6PoolsInput, fn func(*DescribeIpv6PoolsOutput, bool) bool) error {
	return c.DescribeIpv6PoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeIpv6PoolsPagesWithContext same as DescribeIpv6PoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIpv6PoolsPagesWithContext(ctx aws.Context, input *DescribeIpv6PoolsInput, fn func(*DescribeIpv6PoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeIpv6PoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeIpv6PoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeIpv6PoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeKeyPairs = "DescribeKeyPairs"

// DescribeKeyPairsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKeyPairs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeKeyPairs for more information on using the DescribeKeyPairs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeKeyPairsRequest method.
//    req, resp := client.DescribeKeyPairsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs
func (c *EC2) DescribeKeyPairsRequest(input *DescribeKeyPairsInput) (req *request.Request, output *DescribeKeyPairsOutput) {
	op := &request.Operation{
		Name:       opDescribeKeyPairs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyPairsInput{}
	}

	output = &DescribeKeyPairsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeKeyPairs API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified key pairs or all of your key pairs.
//
// For more information about key pairs, see Key Pairs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeKeyPairs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs
func (c *EC2) DescribeKeyPairs(input *DescribeKeyPairsInput) (*DescribeKeyPairsOutput, error) {
	req, out := c.DescribeKeyPairsRequest(input)
	return out, req.Send()
}

// DescribeKeyPairsWithContext is the same as DescribeKeyPairs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKeyPairs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeKeyPairsWithContext(ctx aws.Context, input *DescribeKeyPairsInput, opts ...request.Option) (*DescribeKeyPairsOutput, error) {
	req, out := c.DescribeKeyPairsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLaunchTemplateVersions = "DescribeLaunchTemplateVersions"

// DescribeLaunchTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLaunchTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLaunchTemplateVersions for more information on using the DescribeLaunchTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLaunchTemplateVersionsRequest method.
//    req, resp := client.DescribeLaunchTemplateVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplateVersions
func (c *EC2) DescribeLaunchTemplateVersionsRequest(input *DescribeLaunchTemplateVersionsInput) (req *request.Request, output *DescribeLaunchTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeLaunchTemplateVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLaunchTemplateVersionsInput{}
	}

	output = &DescribeLaunchTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLaunchTemplateVersions API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more versions of a specified launch template. You can describe
// all versions, individual versions, or a range of versions. You can also describe
// all the latest versions or all the default versions of all the launch templates
// in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeLaunchTemplateVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplateVersions
func (c *EC2) DescribeLaunchTemplateVersions(input *DescribeLaunchTemplateVersionsInput) (*DescribeLaunchTemplateVersionsOutput, error) {
	req, out := c.DescribeLaunchTemplateVersionsRequest(input)
	return out, req.Send()
}

// DescribeLaunchTemplateVersionsWithContext is the same as DescribeLaunchTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLaunchTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLaunchTemplateVersionsWithContext(ctx aws.Context, input *DescribeLaunchTemplateVersionsInput, opts ...request.Option) (*DescribeLaunchTemplateVersionsOutput, error) {
	req, out := c.DescribeLaunchTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLaunchTemplateVersionsPages iterates over the pages of a DescribeLaunchTemplateVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLaunchTemplateVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLaunchTemplateVersions operation.
//    pageNum := 0
//    err := client.DescribeLaunchTemplateVersionsPages(params,
//        func(page *ec2.DescribeLaunchTemplateVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeLaunchTemplateVersionsPages(input *DescribeLaunchTemplateVersionsInput, fn func(*DescribeLaunchTemplateVersionsOutput, bool) bool) error {
	return c.DescribeLaunchTemplateVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLaunchTemplateVersionsPagesWithContext same as DescribeLaunchTemplateVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLaunchTemplateVersionsPagesWithContext(ctx aws.Context, input *DescribeLaunchTemplateVersionsInput, fn func(*DescribeLaunchTemplateVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLaunchTemplateVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLaunchTemplateVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLaunchTemplateVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLaunchTemplates = "DescribeLaunchTemplates"

// DescribeLaunchTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLaunchTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLaunchTemplates for more information on using the DescribeLaunchTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLaunchTemplatesRequest method.
//    req, resp := client.DescribeLaunchTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplates
func (c *EC2) DescribeLaunchTemplatesRequest(input *DescribeLaunchTemplatesInput) (req *request.Request, output *DescribeLaunchTemplatesOutput) {
	op := &request.Operation{
		Name:       opDescribeLaunchTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLaunchTemplatesInput{}
	}

	output = &DescribeLaunchTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLaunchTemplates API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more launch templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeLaunchTemplates for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplates
func (c *EC2) DescribeLaunchTemplates(input *DescribeLaunchTemplatesInput) (*DescribeLaunchTemplatesOutput, error) {
	req, out := c.DescribeLaunchTemplatesRequest(input)
	return out, req.Send()
}

// DescribeLaunchTemplatesWithContext is the same as DescribeLaunchTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLaunchTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLaunchTemplatesWithContext(ctx aws.Context, input *DescribeLaunchTemplatesInput, opts ...request.Option) (*DescribeLaunchTemplatesOutput, error) {
	req, out := c.DescribeLaunchTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLaunchTemplatesPages iterates over the pages of a DescribeLaunchTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLaunchTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLaunchTemplates operation.
//    pageNum := 0
//    err := client.DescribeLaunchTemplatesPages(params,
//        func(page *ec2.DescribeLaunchTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeLaunchTemplatesPages(input *DescribeLaunchTemplatesInput, fn func(*DescribeLaunchTemplatesOutput, bool) bool) error {
	return c.DescribeLaunchTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLaunchTemplatesPagesWithContext same as DescribeLaunchTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLaunchTemplatesPagesWithContext(ctx aws.Context, input *DescribeLaunchTemplatesInput, fn func(*DescribeLaunchTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLaunchTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLaunchTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLaunchTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations = "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations"

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations for more information on using the DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest method.
//    req, resp := client.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
func (c *EC2) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(input *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) (req *request.Request, output *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput{}
	}

	output = &DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations API operation for Amazon Elastic Compute Cloud.
//
// Describes the associations between virtual interface groups and local gateway
// route tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
func (c *EC2) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(input *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) (*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput, error) {
	req, out := c.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(input)
	return out, req.Send()
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext is the same as DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext(ctx aws.Context, input *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput, opts ...request.Option) (*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput, error) {
	req, out := c.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages iterates over the pages of a DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations operation.
//    pageNum := 0
//    err := client.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages(params,
//        func(page *ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages(input *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput, fn func(*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput, bool) bool) error {
	return c.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext same as DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext(ctx aws.Context, input *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput, fn func(*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLocalGatewayRouteTableVpcAssociations = "DescribeLocalGatewayRouteTableVpcAssociations"

// DescribeLocalGatewayRouteTableVpcAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocalGatewayRouteTableVpcAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocalGatewayRouteTableVpcAssociations for more information on using the DescribeLocalGatewayRouteTableVpcAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocalGatewayRouteTableVpcAssociationsRequest method.
//    req, resp := client.DescribeLocalGatewayRouteTableVpcAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVpcAssociations
func (c *EC2) DescribeLocalGatewayRouteTableVpcAssociationsRequest(input *DescribeLocalGatewayRouteTableVpcAssociationsInput) (req *request.Request, output *DescribeLocalGatewayRouteTableVpcAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocalGatewayRouteTableVpcAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLocalGatewayRouteTableVpcAssociationsInput{}
	}

	output = &DescribeLocalGatewayRouteTableVpcAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocalGatewayRouteTableVpcAssociations API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified associations between VPCs and local gateway route
// tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeLocalGatewayRouteTableVpcAssociations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVpcAssociations
func (c *EC2) DescribeLocalGatewayRouteTableVpcAssociations(input *DescribeLocalGatewayRouteTableVpcAssociationsInput) (*DescribeLocalGatewayRouteTableVpcAssociationsOutput, error) {
	req, out := c.DescribeLocalGatewayRouteTableVpcAssociationsRequest(input)
	return out, req.Send()
}

// DescribeLocalGatewayRouteTableVpcAssociationsWithContext is the same as DescribeLocalGatewayRouteTableVpcAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocalGatewayRouteTableVpcAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayRouteTableVpcAssociationsWithContext(ctx aws.Context, input *DescribeLocalGatewayRouteTableVpcAssociationsInput, opts ...request.Option) (*DescribeLocalGatewayRouteTableVpcAssociationsOutput, error) {
	req, out := c.DescribeLocalGatewayRouteTableVpcAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLocalGatewayRouteTableVpcAssociationsPages iterates over the pages of a DescribeLocalGatewayRouteTableVpcAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLocalGatewayRouteTableVpcAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLocalGatewayRouteTableVpcAssociations operation.
//    pageNum := 0
//    err := client.DescribeLocalGatewayRouteTableVpcAssociationsPages(params,
//        func(page *ec2.DescribeLocalGatewayRouteTableVpcAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeLocalGatewayRouteTableVpcAssociationsPages(input *DescribeLocalGatewayRouteTableVpcAssociationsInput, fn func(*DescribeLocalGatewayRouteTableVpcAssociationsOutput, bool) bool) error {
	return c.DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext same as DescribeLocalGatewayRouteTableVpcAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext(ctx aws.Context, input *DescribeLocalGatewayRouteTableVpcAssociationsInput, fn func(*DescribeLocalGatewayRouteTableVpcAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLocalGatewayRouteTableVpcAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLocalGatewayRouteTableVpcAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLocalGatewayRouteTableVpcAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLocalGatewayRouteTables = "DescribeLocalGatewayRouteTables"

// DescribeLocalGatewayRouteTablesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocalGatewayRouteTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocalGatewayRouteTables for more information on using the DescribeLocalGatewayRouteTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocalGatewayRouteTablesRequest method.
//    req, resp := client.DescribeLocalGatewayRouteTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTables
func (c *EC2) DescribeLocalGatewayRouteTablesRequest(input *DescribeLocalGatewayRouteTablesInput) (req *request.Request, output *DescribeLocalGatewayRouteTablesOutput) {
	op := &request.Operation{
		Name:       opDescribeLocalGatewayRouteTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLocalGatewayRouteTablesInput{}
	}

	output = &DescribeLocalGatewayRouteTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocalGatewayRouteTables API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more local gateway route tables. By default, all local gateway
// route tables are described. Alternatively, you can filter the results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeLocalGatewayRouteTables for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTables
func (c *EC2) DescribeLocalGatewayRouteTables(input *DescribeLocalGatewayRouteTablesInput) (*DescribeLocalGatewayRouteTablesOutput, error) {
	req, out := c.DescribeLocalGatewayRouteTablesRequest(input)
	return out, req.Send()
}

// DescribeLocalGatewayRouteTablesWithContext is the same as DescribeLocalGatewayRouteTables with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocalGatewayRouteTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayRouteTablesWithContext(ctx aws.Context, input *DescribeLocalGatewayRouteTablesInput, opts ...request.Option) (*DescribeLocalGatewayRouteTablesOutput, error) {
	req, out := c.DescribeLocalGatewayRouteTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLocalGatewayRouteTablesPages iterates over the pages of a DescribeLocalGatewayRouteTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLocalGatewayRouteTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLocalGatewayRouteTables operation.
//    pageNum := 0
//    err := client.DescribeLocalGatewayRouteTablesPages(params,
//        func(page *ec2.DescribeLocalGatewayRouteTablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeLocalGatewayRouteTablesPages(input *DescribeLocalGatewayRouteTablesInput, fn func(*DescribeLocalGatewayRouteTablesOutput, bool) bool) error {
	return c.DescribeLocalGatewayRouteTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLocalGatewayRouteTablesPagesWithContext same as DescribeLocalGatewayRouteTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayRouteTablesPagesWithContext(ctx aws.Context, input *DescribeLocalGatewayRouteTablesInput, fn func(*DescribeLocalGatewayRouteTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLocalGatewayRouteTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLocalGatewayRouteTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLocalGatewayRouteTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLocalGatewayVirtualInterfaceGroups = "DescribeLocalGatewayVirtualInterfaceGroups"

// DescribeLocalGatewayVirtualInterfaceGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocalGatewayVirtualInterfaceGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocalGatewayVirtualInterfaceGroups for more information on using the DescribeLocalGatewayVirtualInterfaceGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocalGatewayVirtualInterfaceGroupsRequest method.
//    req, resp := client.DescribeLocalGatewayVirtualInterfaceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaceGroups
func (c *EC2) DescribeLocalGatewayVirtualInterfaceGroupsRequest(input *DescribeLocalGatewayVirtualInterfaceGroupsInput) (req *request.Request, output *DescribeLocalGatewayVirtualInterfaceGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocalGatewayVirtualInterfaceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLocalGatewayVirtualInterfaceGroupsInput{}
	}

	output = &DescribeLocalGatewayVirtualInterfaceGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocalGatewayVirtualInterfaceGroups API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified local gateway virtual interface groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeLocalGatewayVirtualInterfaceGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaceGroups
func (c *EC2) DescribeLocalGatewayVirtualInterfaceGroups(input *DescribeLocalGatewayVirtualInterfaceGroupsInput) (*DescribeLocalGatewayVirtualInterfaceGroupsOutput, error) {
	req, out := c.DescribeLocalGatewayVirtualInterfaceGroupsRequest(input)
	return out, req.Send()
}

// DescribeLocalGatewayVirtualInterfaceGroupsWithContext is the same as DescribeLocalGatewayVirtualInterfaceGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocalGatewayVirtualInterfaceGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayVirtualInterfaceGroupsWithContext(ctx aws.Context, input *DescribeLocalGatewayVirtualInterfaceGroupsInput, opts ...request.Option) (*DescribeLocalGatewayVirtualInterfaceGroupsOutput, error) {
	req, out := c.DescribeLocalGatewayVirtualInterfaceGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLocalGatewayVirtualInterfaceGroupsPages iterates over the pages of a DescribeLocalGatewayVirtualInterfaceGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLocalGatewayVirtualInterfaceGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLocalGatewayVirtualInterfaceGroups operation.
//    pageNum := 0
//    err := client.DescribeLocalGatewayVirtualInterfaceGroupsPages(params,
//        func(page *ec2.DescribeLocalGatewayVirtualInterfaceGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeLocalGatewayVirtualInterfaceGroupsPages(input *DescribeLocalGatewayVirtualInterfaceGroupsInput, fn func(*DescribeLocalGatewayVirtualInterfaceGroupsOutput, bool) bool) error {
	return c.DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext same as DescribeLocalGatewayVirtualInterfaceGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext(ctx aws.Context, input *DescribeLocalGatewayVirtualInterfaceGroupsInput, fn func(*DescribeLocalGatewayVirtualInterfaceGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLocalGatewayVirtualInterfaceGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLocalGatewayVirtualInterfaceGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLocalGatewayVirtualInterfaceGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLocalGatewayVirtualInterfaces = "DescribeLocalGatewayVirtualInterfaces"

// DescribeLocalGatewayVirtualInterfacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocalGatewayVirtualInterfaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocalGatewayVirtualInterfaces for more information on using the DescribeLocalGatewayVirtualInterfaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocalGatewayVirtualInterfacesRequest method.
//    req, resp := client.DescribeLocalGatewayVirtualInterfacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaces
func (c *EC2) DescribeLocalGatewayVirtualInterfacesRequest(input *DescribeLocalGatewayVirtualInterfacesInput) (req *request.Request, output *DescribeLocalGatewayVirtualInterfacesOutput) {
	op := &request.Operation{
		Name:       opDescribeLocalGatewayVirtualInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLocalGatewayVirtualInterfacesInput{}
	}

	output = &DescribeLocalGatewayVirtualInterfacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocalGatewayVirtualInterfaces API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified local gateway virtual interfaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeLocalGatewayVirtualInterfaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaces
func (c *EC2) DescribeLocalGatewayVirtualInterfaces(input *DescribeLocalGatewayVirtualInterfacesInput) (*DescribeLocalGatewayVirtualInterfacesOutput, error) {
	req, out := c.DescribeLocalGatewayVirtualInterfacesRequest(input)
	return out, req.Send()
}

// DescribeLocalGatewayVirtualInterfacesWithContext is the same as DescribeLocalGatewayVirtualInterfaces with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocalGatewayVirtualInterfaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayVirtualInterfacesWithContext(ctx aws.Context, input *DescribeLocalGatewayVirtualInterfacesInput, opts ...request.Option) (*DescribeLocalGatewayVirtualInterfacesOutput, error) {
	req, out := c.DescribeLocalGatewayVirtualInterfacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLocalGatewayVirtualInterfacesPages iterates over the pages of a DescribeLocalGatewayVirtualInterfaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLocalGatewayVirtualInterfaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLocalGatewayVirtualInterfaces operation.
//    pageNum := 0
//    err := client.DescribeLocalGatewayVirtualInterfacesPages(params,
//        func(page *ec2.DescribeLocalGatewayVirtualInterfacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeLocalGatewayVirtualInterfacesPages(input *DescribeLocalGatewayVirtualInterfacesInput, fn func(*DescribeLocalGatewayVirtualInterfacesOutput, bool) bool) error {
	return c.DescribeLocalGatewayVirtualInterfacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLocalGatewayVirtualInterfacesPagesWithContext same as DescribeLocalGatewayVirtualInterfacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewayVirtualInterfacesPagesWithContext(ctx aws.Context, input *DescribeLocalGatewayVirtualInterfacesInput, fn func(*DescribeLocalGatewayVirtualInterfacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLocalGatewayVirtualInterfacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLocalGatewayVirtualInterfacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLocalGatewayVirtualInterfacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLocalGateways = "DescribeLocalGateways"

// DescribeLocalGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocalGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocalGateways for more information on using the DescribeLocalGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocalGatewaysRequest method.
//    req, resp := client.DescribeLocalGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGateways
func (c *EC2) DescribeLocalGatewaysRequest(input *DescribeLocalGatewaysInput) (req *request.Request, output *DescribeLocalGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeLocalGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLocalGatewaysInput{}
	}

	output = &DescribeLocalGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocalGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more local gateways. By default, all local gateways are
// described. Alternatively, you can filter the results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeLocalGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGateways
func (c *EC2) DescribeLocalGateways(input *DescribeLocalGatewaysInput) (*DescribeLocalGatewaysOutput, error) {
	req, out := c.DescribeLocalGatewaysRequest(input)
	return out, req.Send()
}

// DescribeLocalGatewaysWithContext is the same as DescribeLocalGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocalGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewaysWithContext(ctx aws.Context, input *DescribeLocalGatewaysInput, opts ...request.Option) (*DescribeLocalGatewaysOutput, error) {
	req, out := c.DescribeLocalGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLocalGatewaysPages iterates over the pages of a DescribeLocalGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLocalGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLocalGateways operation.
//    pageNum := 0
//    err := client.DescribeLocalGatewaysPages(params,
//        func(page *ec2.DescribeLocalGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeLocalGatewaysPages(input *DescribeLocalGatewaysInput, fn func(*DescribeLocalGatewaysOutput, bool) bool) error {
	return c.DescribeLocalGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLocalGatewaysPagesWithContext same as DescribeLocalGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeLocalGatewaysPagesWithContext(ctx aws.Context, input *DescribeLocalGatewaysInput, fn func(*DescribeLocalGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLocalGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLocalGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLocalGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeManagedPrefixLists = "DescribeManagedPrefixLists"

// DescribeManagedPrefixListsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeManagedPrefixLists operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeManagedPrefixLists for more information on using the DescribeManagedPrefixLists
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeManagedPrefixListsRequest method.
//    req, resp := client.DescribeManagedPrefixListsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeManagedPrefixLists
func (c *EC2) DescribeManagedPrefixListsRequest(input *DescribeManagedPrefixListsInput) (req *request.Request, output *DescribeManagedPrefixListsOutput) {
	op := &request.Operation{
		Name:       opDescribeManagedPrefixLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeManagedPrefixListsInput{}
	}

	output = &DescribeManagedPrefixListsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeManagedPrefixLists API operation for Amazon Elastic Compute Cloud.
//
// Describes your managed prefix lists and any AWS-managed prefix lists.
//
// To view the entries for your prefix list, use GetManagedPrefixListEntries.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeManagedPrefixLists for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeManagedPrefixLists
func (c *EC2) DescribeManagedPrefixLists(input *DescribeManagedPrefixListsInput) (*DescribeManagedPrefixListsOutput, error) {
	req, out := c.DescribeManagedPrefixListsRequest(input)
	return out, req.Send()
}

// DescribeManagedPrefixListsWithContext is the same as DescribeManagedPrefixLists with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeManagedPrefixLists for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeManagedPrefixListsWithContext(ctx aws.Context, input *DescribeManagedPrefixListsInput, opts ...request.Option) (*DescribeManagedPrefixListsOutput, error) {
	req, out := c.DescribeManagedPrefixListsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeManagedPrefixListsPages iterates over the pages of a DescribeManagedPrefixLists operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeManagedPrefixLists method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeManagedPrefixLists operation.
//    pageNum := 0
//    err := client.DescribeManagedPrefixListsPages(params,
//        func(page *ec2.DescribeManagedPrefixListsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeManagedPrefixListsPages(input *DescribeManagedPrefixListsInput, fn func(*DescribeManagedPrefixListsOutput, bool) bool) error {
	return c.DescribeManagedPrefixListsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeManagedPrefixListsPagesWithContext same as DescribeManagedPrefixListsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeManagedPrefixListsPagesWithContext(ctx aws.Context, input *DescribeManagedPrefixListsInput, fn func(*DescribeManagedPrefixListsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeManagedPrefixListsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeManagedPrefixListsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeManagedPrefixListsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMovingAddresses = "DescribeMovingAddresses"

// DescribeMovingAddressesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMovingAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMovingAddresses for more information on using the DescribeMovingAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMovingAddressesRequest method.
//    req, resp := client.DescribeMovingAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses
func (c *EC2) DescribeMovingAddressesRequest(input *DescribeMovingAddressesInput) (req *request.Request, output *DescribeMovingAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeMovingAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMovingAddressesInput{}
	}

	output = &DescribeMovingAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMovingAddresses API operation for Amazon Elastic Compute Cloud.
//
// Describes your Elastic IP addresses that are being moved to the EC2-VPC platform,
// or that are being restored to the EC2-Classic platform. This request does
// not return information about any other Elastic IP addresses in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeMovingAddresses for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses
func (c *EC2) DescribeMovingAddresses(input *DescribeMovingAddressesInput) (*DescribeMovingAddressesOutput, error) {
	req, out := c.DescribeMovingAddressesRequest(input)
	return out, req.Send()
}

// DescribeMovingAddressesWithContext is the same as DescribeMovingAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMovingAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeMovingAddressesWithContext(ctx aws.Context, input *DescribeMovingAddressesInput, opts ...request.Option) (*DescribeMovingAddressesOutput, error) {
	req, out := c.DescribeMovingAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMovingAddressesPages iterates over the pages of a DescribeMovingAddresses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMovingAddresses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeMovingAddresses operation.
//    pageNum := 0
//    err := client.DescribeMovingAddressesPages(params,
//        func(page *ec2.DescribeMovingAddressesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeMovingAddressesPages(input *DescribeMovingAddressesInput, fn func(*DescribeMovingAddressesOutput, bool) bool) error {
	return c.DescribeMovingAddressesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMovingAddressesPagesWithContext same as DescribeMovingAddressesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeMovingAddressesPagesWithContext(ctx aws.Context, input *DescribeMovingAddressesInput, fn func(*DescribeMovingAddressesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMovingAddressesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMovingAddressesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMovingAddressesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeNatGateways = "DescribeNatGateways"

// DescribeNatGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNatGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNatGateways for more information on using the DescribeNatGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNatGatewaysRequest method.
//    req, resp := client.DescribeNatGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways
func (c *EC2) DescribeNatGatewaysRequest(input *DescribeNatGatewaysInput) (req *request.Request, output *DescribeNatGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeNatGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNatGatewaysInput{}
	}

	output = &DescribeNatGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNatGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your NAT gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNatGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways
func (c *EC2) DescribeNatGateways(input *DescribeNatGatewaysInput) (*DescribeNatGatewaysOutput, error) {
	req, out := c.DescribeNatGatewaysRequest(input)
	return out, req.Send()
}

// DescribeNatGatewaysWithContext is the same as DescribeNatGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNatGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNatGatewaysWithContext(ctx aws.Context, input *DescribeNatGatewaysInput, opts ...request.Option) (*DescribeNatGatewaysOutput, error) {
	req, out := c.DescribeNatGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeNatGatewaysPages iterates over the pages of a DescribeNatGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNatGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNatGateways operation.
//    pageNum := 0
//    err := client.DescribeNatGatewaysPages(params,
//        func(page *ec2.DescribeNatGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeNatGatewaysPages(input *DescribeNatGatewaysInput, fn func(*DescribeNatGatewaysOutput, bool) bool) error {
	return c.DescribeNatGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeNatGatewaysPagesWithContext same as DescribeNatGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNatGatewaysPagesWithContext(ctx aws.Context, input *DescribeNatGatewaysInput, fn func(*DescribeNatGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeNatGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeNatGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeNatGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeNetworkAcls = "DescribeNetworkAcls"

// DescribeNetworkAclsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNetworkAcls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNetworkAcls for more information on using the DescribeNetworkAcls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNetworkAclsRequest method.
//    req, resp := client.DescribeNetworkAclsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls
func (c *EC2) DescribeNetworkAclsRequest(input *DescribeNetworkAclsInput) (req *request.Request, output *DescribeNetworkAclsOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkAcls,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNetworkAclsInput{}
	}

	output = &DescribeNetworkAclsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNetworkAcls API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your network ACLs.
//
// For more information, see Network ACLs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNetworkAcls for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls
func (c *EC2) DescribeNetworkAcls(input *DescribeNetworkAclsInput) (*DescribeNetworkAclsOutput, error) {
	req, out := c.DescribeNetworkAclsRequest(input)
	return out, req.Send()
}

// DescribeNetworkAclsWithContext is the same as DescribeNetworkAcls with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNetworkAcls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkAclsWithContext(ctx aws.Context, input *DescribeNetworkAclsInput, opts ...request.Option) (*DescribeNetworkAclsOutput, error) {
	req, out := c.DescribeNetworkAclsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeNetworkAclsPages iterates over the pages of a DescribeNetworkAcls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNetworkAcls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNetworkAcls operation.
//    pageNum := 0
//    err := client.DescribeNetworkAclsPages(params,
//        func(page *ec2.DescribeNetworkAclsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeNetworkAclsPages(input *DescribeNetworkAclsInput, fn func(*DescribeNetworkAclsOutput, bool) bool) error {
	return c.DescribeNetworkAclsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeNetworkAclsPagesWithContext same as DescribeNetworkAclsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkAclsPagesWithContext(ctx aws.Context, input *DescribeNetworkAclsInput, fn func(*DescribeNetworkAclsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeNetworkAclsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeNetworkAclsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeNetworkAclsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeNetworkInsightsAnalyses = "DescribeNetworkInsightsAnalyses"

// DescribeNetworkInsightsAnalysesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNetworkInsightsAnalyses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNetworkInsightsAnalyses for more information on using the DescribeNetworkInsightsAnalyses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNetworkInsightsAnalysesRequest method.
//    req, resp := client.DescribeNetworkInsightsAnalysesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAnalyses
func (c *EC2) DescribeNetworkInsightsAnalysesRequest(input *DescribeNetworkInsightsAnalysesInput) (req *request.Request, output *DescribeNetworkInsightsAnalysesOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkInsightsAnalyses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNetworkInsightsAnalysesInput{}
	}

	output = &DescribeNetworkInsightsAnalysesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNetworkInsightsAnalyses API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your network insights analyses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNetworkInsightsAnalyses for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAnalyses
func (c *EC2) DescribeNetworkInsightsAnalyses(input *DescribeNetworkInsightsAnalysesInput) (*DescribeNetworkInsightsAnalysesOutput, error) {
	req, out := c.DescribeNetworkInsightsAnalysesRequest(input)
	return out, req.Send()
}

// DescribeNetworkInsightsAnalysesWithContext is the same as DescribeNetworkInsightsAnalyses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNetworkInsightsAnalyses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkInsightsAnalysesWithContext(ctx aws.Context, input *DescribeNetworkInsightsAnalysesInput, opts ...request.Option) (*DescribeNetworkInsightsAnalysesOutput, error) {
	req, out := c.DescribeNetworkInsightsAnalysesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeNetworkInsightsAnalysesPages iterates over the pages of a DescribeNetworkInsightsAnalyses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNetworkInsightsAnalyses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNetworkInsightsAnalyses operation.
//    pageNum := 0
//    err := client.DescribeNetworkInsightsAnalysesPages(params,
//        func(page *ec2.DescribeNetworkInsightsAnalysesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeNetworkInsightsAnalysesPages(input *DescribeNetworkInsightsAnalysesInput, fn func(*DescribeNetworkInsightsAnalysesOutput, bool) bool) error {
	return c.DescribeNetworkInsightsAnalysesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeNetworkInsightsAnalysesPagesWithContext same as DescribeNetworkInsightsAnalysesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkInsightsAnalysesPagesWithContext(ctx aws.Context, input *DescribeNetworkInsightsAnalysesInput, fn func(*DescribeNetworkInsightsAnalysesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeNetworkInsightsAnalysesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeNetworkInsightsAnalysesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeNetworkInsightsAnalysesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeNetworkInsightsPaths = "DescribeNetworkInsightsPaths"

// DescribeNetworkInsightsPathsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNetworkInsightsPaths operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNetworkInsightsPaths for more information on using the DescribeNetworkInsightsPaths
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNetworkInsightsPathsRequest method.
//    req, resp := client.DescribeNetworkInsightsPathsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsPaths
func (c *EC2) DescribeNetworkInsightsPathsRequest(input *DescribeNetworkInsightsPathsInput) (req *request.Request, output *DescribeNetworkInsightsPathsOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkInsightsPaths,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNetworkInsightsPathsInput{}
	}

	output = &DescribeNetworkInsightsPathsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNetworkInsightsPaths API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your paths.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNetworkInsightsPaths for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsPaths
func (c *EC2) DescribeNetworkInsightsPaths(input *DescribeNetworkInsightsPathsInput) (*DescribeNetworkInsightsPathsOutput, error) {
	req, out := c.DescribeNetworkInsightsPathsRequest(input)
	return out, req.Send()
}

// DescribeNetworkInsightsPathsWithContext is the same as DescribeNetworkInsightsPaths with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNetworkInsightsPaths for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkInsightsPathsWithContext(ctx aws.Context, input *DescribeNetworkInsightsPathsInput, opts ...request.Option) (*DescribeNetworkInsightsPathsOutput, error) {
	req, out := c.DescribeNetworkInsightsPathsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeNetworkInsightsPathsPages iterates over the pages of a DescribeNetworkInsightsPaths operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNetworkInsightsPaths method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNetworkInsightsPaths operation.
//    pageNum := 0
//    err := client.DescribeNetworkInsightsPathsPages(params,
//        func(page *ec2.DescribeNetworkInsightsPathsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeNetworkInsightsPathsPages(input *DescribeNetworkInsightsPathsInput, fn func(*DescribeNetworkInsightsPathsOutput, bool) bool) error {
	return c.DescribeNetworkInsightsPathsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeNetworkInsightsPathsPagesWithContext same as DescribeNetworkInsightsPathsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkInsightsPathsPagesWithContext(ctx aws.Context, input *DescribeNetworkInsightsPathsInput, fn func(*DescribeNetworkInsightsPathsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeNetworkInsightsPathsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeNetworkInsightsPathsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeNetworkInsightsPathsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeNetworkInterfaceAttribute = "DescribeNetworkInterfaceAttribute"

// DescribeNetworkInterfaceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNetworkInterfaceAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNetworkInterfaceAttribute for more information on using the DescribeNetworkInterfaceAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNetworkInterfaceAttributeRequest method.
//    req, resp := client.DescribeNetworkInterfaceAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttribute
func (c *EC2) DescribeNetworkInterfaceAttributeRequest(input *DescribeNetworkInterfaceAttributeInput) (req *request.Request, output *DescribeNetworkInterfaceAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkInterfaceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNetworkInterfaceAttributeInput{}
	}

	output = &DescribeNetworkInterfaceAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNetworkInterfaceAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes a network interface attribute. You can specify only one attribute
// at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNetworkInterfaceAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttribute
func (c *EC2) DescribeNetworkInterfaceAttribute(input *DescribeNetworkInterfaceAttributeInput) (*DescribeNetworkInterfaceAttributeOutput, error) {
	req, out := c.DescribeNetworkInterfaceAttributeRequest(input)
	return out, req.Send()
}

// DescribeNetworkInterfaceAttributeWithContext is the same as DescribeNetworkInterfaceAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNetworkInterfaceAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkInterfaceAttributeWithContext(ctx aws.Context, input *DescribeNetworkInterfaceAttributeInput, opts ...request.Option) (*DescribeNetworkInterfaceAttributeOutput, error) {
	req, out := c.DescribeNetworkInterfaceAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNetworkInterfacePermissions = "DescribeNetworkInterfacePermissions"

// DescribeNetworkInterfacePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNetworkInterfacePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNetworkInterfacePermissions for more information on using the DescribeNetworkInterfacePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNetworkInterfacePermissionsRequest method.
//    req, resp := client.DescribeNetworkInterfacePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissions
func (c *EC2) DescribeNetworkInterfacePermissionsRequest(input *DescribeNetworkInterfacePermissionsInput) (req *request.Request, output *DescribeNetworkInterfacePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkInterfacePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNetworkInterfacePermissionsInput{}
	}

	output = &DescribeNetworkInterfacePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNetworkInterfacePermissions API operation for Amazon Elastic Compute Cloud.
//
// Describes the permissions for your network interfaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNetworkInterfacePermissions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissions
func (c *EC2) DescribeNetworkInterfacePermissions(input *DescribeNetworkInterfacePermissionsInput) (*DescribeNetworkInterfacePermissionsOutput, error) {
	req, out := c.DescribeNetworkInterfacePermissionsRequest(input)
	return out, req.Send()
}

// DescribeNetworkInterfacePermissionsWithContext is the same as DescribeNetworkInterfacePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNetworkInterfacePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkInterfacePermissionsWithContext(ctx aws.Context, input *DescribeNetworkInterfacePermissionsInput, opts ...request.Option) (*DescribeNetworkInterfacePermissionsOutput, error) {
	req, out := c.DescribeNetworkInterfacePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeNetworkInterfacePermissionsPages iterates over the pages of a DescribeNetworkInterfacePermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNetworkInterfacePermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNetworkInterfacePermissions operation.
//    pageNum := 0
//    err := client.DescribeNetworkInterfacePermissionsPages(params,
//        func(page *ec2.DescribeNetworkInterfacePermissionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeNetworkInterfacePermissionsPages(input *DescribeNetworkInterfacePermissionsInput, fn func(*DescribeNetworkInterfacePermissionsOutput, bool) bool) error {
	return c.DescribeNetworkInterfacePermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeNetworkInterfacePermissionsPagesWithContext same as DescribeNetworkInterfacePermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkInterfacePermissionsPagesWithContext(ctx aws.Context, input *DescribeNetworkInterfacePermissionsInput, fn func(*DescribeNetworkInterfacePermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeNetworkInterfacePermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeNetworkInterfacePermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeNetworkInterfacePermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeNetworkInterfaces = "DescribeNetworkInterfaces"

// DescribeNetworkInterfacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNetworkInterfaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNetworkInterfaces for more information on using the DescribeNetworkInterfaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNetworkInterfacesRequest method.
//    req, resp := client.DescribeNetworkInterfacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces
func (c *EC2) DescribeNetworkInterfacesRequest(input *DescribeNetworkInterfacesInput) (req *request.Request, output *DescribeNetworkInterfacesOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNetworkInterfacesInput{}
	}

	output = &DescribeNetworkInterfacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNetworkInterfaces API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your network interfaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNetworkInterfaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces
func (c *EC2) DescribeNetworkInterfaces(input *DescribeNetworkInterfacesInput) (*DescribeNetworkInterfacesOutput, error) {
	req, out := c.DescribeNetworkInterfacesRequest(input)
	return out, req.Send()
}

// DescribeNetworkInterfacesWithContext is the same as DescribeNetworkInterfaces with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNetworkInterfaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkInterfacesWithContext(ctx aws.Context, input *DescribeNetworkInterfacesInput, opts ...request.Option) (*DescribeNetworkInterfacesOutput, error) {
	req, out := c.DescribeNetworkInterfacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeNetworkInterfacesPages iterates over the pages of a DescribeNetworkInterfaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNetworkInterfaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNetworkInterfaces operation.
//    pageNum := 0
//    err := client.DescribeNetworkInterfacesPages(params,
//        func(page *ec2.DescribeNetworkInterfacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeNetworkInterfacesPages(input *DescribeNetworkInterfacesInput, fn func(*DescribeNetworkInterfacesOutput, bool) bool) error {
	return c.DescribeNetworkInterfacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeNetworkInterfacesPagesWithContext same as DescribeNetworkInterfacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeNetworkInterfacesPagesWithContext(ctx aws.Context, input *DescribeNetworkInterfacesInput, fn func(*DescribeNetworkInterfacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeNetworkInterfacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeNetworkInterfacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeNetworkInterfacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePlacementGroups = "DescribePlacementGroups"

// DescribePlacementGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlacementGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePlacementGroups for more information on using the DescribePlacementGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePlacementGroupsRequest method.
//    req, resp := client.DescribePlacementGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroups
func (c *EC2) DescribePlacementGroupsRequest(input *DescribePlacementGroupsInput) (req *request.Request, output *DescribePlacementGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribePlacementGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePlacementGroupsInput{}
	}

	output = &DescribePlacementGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePlacementGroups API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified placement groups or all of your placement groups.
// For more information, see Placement groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribePlacementGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroups
func (c *EC2) DescribePlacementGroups(input *DescribePlacementGroupsInput) (*DescribePlacementGroupsOutput, error) {
	req, out := c.DescribePlacementGroupsRequest(input)
	return out, req.Send()
}

// DescribePlacementGroupsWithContext is the same as DescribePlacementGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlacementGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribePlacementGroupsWithContext(ctx aws.Context, input *DescribePlacementGroupsInput, opts ...request.Option) (*DescribePlacementGroupsOutput, error) {
	req, out := c.DescribePlacementGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePrefixLists = "DescribePrefixLists"

// DescribePrefixListsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePrefixLists operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePrefixLists for more information on using the DescribePrefixLists
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePrefixListsRequest method.
//    req, resp := client.DescribePrefixListsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists
func (c *EC2) DescribePrefixListsRequest(input *DescribePrefixListsInput) (req *request.Request, output *DescribePrefixListsOutput) {
	op := &request.Operation{
		Name:       opDescribePrefixLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePrefixListsInput{}
	}

	output = &DescribePrefixListsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePrefixLists API operation for Amazon Elastic Compute Cloud.
//
// Describes available AWS services in a prefix list format, which includes
// the prefix list name and prefix list ID of the service and the IP address
// range for the service.
//
// We recommend that you use DescribeManagedPrefixLists instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribePrefixLists for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists
func (c *EC2) DescribePrefixLists(input *DescribePrefixListsInput) (*DescribePrefixListsOutput, error) {
	req, out := c.DescribePrefixListsRequest(input)
	return out, req.Send()
}

// DescribePrefixListsWithContext is the same as DescribePrefixLists with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePrefixLists for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribePrefixListsWithContext(ctx aws.Context, input *DescribePrefixListsInput, opts ...request.Option) (*DescribePrefixListsOutput, error) {
	req, out := c.DescribePrefixListsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePrefixListsPages iterates over the pages of a DescribePrefixLists operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePrefixLists method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePrefixLists operation.
//    pageNum := 0
//    err := client.DescribePrefixListsPages(params,
//        func(page *ec2.DescribePrefixListsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribePrefixListsPages(input *DescribePrefixListsInput, fn func(*DescribePrefixListsOutput, bool) bool) error {
	return c.DescribePrefixListsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePrefixListsPagesWithContext same as DescribePrefixListsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribePrefixListsPagesWithContext(ctx aws.Context, input *DescribePrefixListsInput, fn func(*DescribePrefixListsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePrefixListsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePrefixListsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePrefixListsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePrincipalIdFormat = "DescribePrincipalIdFormat"

// DescribePrincipalIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the DescribePrincipalIdFormat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePrincipalIdFormat for more information on using the DescribePrincipalIdFormat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePrincipalIdFormatRequest method.
//    req, resp := client.DescribePrincipalIdFormatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrincipalIdFormat
func (c *EC2) DescribePrincipalIdFormatRequest(input *DescribePrincipalIdFormatInput) (req *request.Request, output *DescribePrincipalIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribePrincipalIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePrincipalIdFormatInput{}
	}

	output = &DescribePrincipalIdFormatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePrincipalIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Describes the ID format settings for the root user and all IAM roles and
// IAM users that have explicitly specified a longer ID (17-character ID) preference.
//
// By default, all IAM roles and IAM users default to the same ID settings as
// the root user, unless they explicitly override the settings. This request
// is useful for identifying those IAM users and IAM roles that have overridden
// the default ID settings.
//
// The following resource types support longer IDs: bundle | conversion-task
// | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association
// | export-task | flow-log | image | import-task | instance | internet-gateway
// | network-acl | network-acl-association | network-interface | network-interface-attachment
// | prefix-list | reservation | route-table | route-table-association | security-group
// | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association
// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribePrincipalIdFormat for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrincipalIdFormat
func (c *EC2) DescribePrincipalIdFormat(input *DescribePrincipalIdFormatInput) (*DescribePrincipalIdFormatOutput, error) {
	req, out := c.DescribePrincipalIdFormatRequest(input)
	return out, req.Send()
}

// DescribePrincipalIdFormatWithContext is the same as DescribePrincipalIdFormat with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePrincipalIdFormat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribePrincipalIdFormatWithContext(ctx aws.Context, input *DescribePrincipalIdFormatInput, opts ...request.Option) (*DescribePrincipalIdFormatOutput, error) {
	req, out := c.DescribePrincipalIdFormatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePrincipalIdFormatPages iterates over the pages of a DescribePrincipalIdFormat operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePrincipalIdFormat method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePrincipalIdFormat operation.
//    pageNum := 0
//    err := client.DescribePrincipalIdFormatPages(params,
//        func(page *ec2.DescribePrincipalIdFormatOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribePrincipalIdFormatPages(input *DescribePrincipalIdFormatInput, fn func(*DescribePrincipalIdFormatOutput, bool) bool) error {
	return c.DescribePrincipalIdFormatPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePrincipalIdFormatPagesWithContext same as DescribePrincipalIdFormatPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribePrincipalIdFormatPagesWithContext(ctx aws.Context, input *DescribePrincipalIdFormatInput, fn func(*DescribePrincipalIdFormatOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePrincipalIdFormatInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePrincipalIdFormatRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePrincipalIdFormatOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePublicIpv4Pools = "DescribePublicIpv4Pools"

// DescribePublicIpv4PoolsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePublicIpv4Pools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePublicIpv4Pools for more information on using the DescribePublicIpv4Pools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePublicIpv4PoolsRequest method.
//    req, resp := client.DescribePublicIpv4PoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePublicIpv4Pools
func (c *EC2) DescribePublicIpv4PoolsRequest(input *DescribePublicIpv4PoolsInput) (req *request.Request, output *DescribePublicIpv4PoolsOutput) {
	op := &request.Operation{
		Name:       opDescribePublicIpv4Pools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePublicIpv4PoolsInput{}
	}

	output = &DescribePublicIpv4PoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePublicIpv4Pools API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified IPv4 address pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribePublicIpv4Pools for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePublicIpv4Pools
func (c *EC2) DescribePublicIpv4Pools(input *DescribePublicIpv4PoolsInput) (*DescribePublicIpv4PoolsOutput, error) {
	req, out := c.DescribePublicIpv4PoolsRequest(input)
	return out, req.Send()
}

// DescribePublicIpv4PoolsWithContext is the same as DescribePublicIpv4Pools with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePublicIpv4Pools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribePublicIpv4PoolsWithContext(ctx aws.Context, input *DescribePublicIpv4PoolsInput, opts ...request.Option) (*DescribePublicIpv4PoolsOutput, error) {
	req, out := c.DescribePublicIpv4PoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePublicIpv4PoolsPages iterates over the pages of a DescribePublicIpv4Pools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePublicIpv4Pools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePublicIpv4Pools operation.
//    pageNum := 0
//    err := client.DescribePublicIpv4PoolsPages(params,
//        func(page *ec2.DescribePublicIpv4PoolsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribePublicIpv4PoolsPages(input *DescribePublicIpv4PoolsInput, fn func(*DescribePublicIpv4PoolsOutput, bool) bool) error {
	return c.DescribePublicIpv4PoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePublicIpv4PoolsPagesWithContext same as DescribePublicIpv4PoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribePublicIpv4PoolsPagesWithContext(ctx aws.Context, input *DescribePublicIpv4PoolsInput, fn func(*DescribePublicIpv4PoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePublicIpv4PoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePublicIpv4PoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePublicIpv4PoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRegions = "DescribeRegions"

// DescribeRegionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRegions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRegions for more information on using the DescribeRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRegionsRequest method.
//    req, resp := client.DescribeRegionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegions
func (c *EC2) DescribeRegionsRequest(input *DescribeRegionsInput) (req *request.Request, output *DescribeRegionsOutput) {
	op := &request.Operation{
		Name:       opDescribeRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRegionsInput{}
	}

	output = &DescribeRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRegions API operation for Amazon Elastic Compute Cloud.
//
// Describes the Regions that are enabled for your account, or all Regions.
//
// For a list of the Regions supported by Amazon EC2, see Regions and Endpoints
// (https://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region).
//
// For information about enabling and disabling Regions for your account, see
// Managing AWS Regions (https://docs.aws.amazon.com/general/latest/gr/rande-manage.html)
// in the AWS General Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeRegions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegions
func (c *EC2) DescribeRegions(input *DescribeRegionsInput) (*DescribeRegionsOutput, error) {
	req, out := c.DescribeRegionsRequest(input)
	return out, req.Send()
}

// DescribeRegionsWithContext is the same as DescribeRegions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeRegionsWithContext(ctx aws.Context, input *DescribeRegionsInput, opts ...request.Option) (*DescribeRegionsOutput, error) {
	req, out := c.DescribeRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReservedInstances = "DescribeReservedInstances"

// DescribeReservedInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedInstances for more information on using the DescribeReservedInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedInstancesRequest method.
//    req, resp := client.DescribeReservedInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstances
func (c *EC2) DescribeReservedInstancesRequest(input *DescribeReservedInstancesInput) (req *request.Request, output *DescribeReservedInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReservedInstancesInput{}
	}

	output = &DescribeReservedInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of the Reserved Instances that you purchased.
//
// For more information about Reserved Instances, see Reserved Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeReservedInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstances
func (c *EC2) DescribeReservedInstances(input *DescribeReservedInstancesInput) (*DescribeReservedInstancesOutput, error) {
	req, out := c.DescribeReservedInstancesRequest(input)
	return out, req.Send()
}

// DescribeReservedInstancesWithContext is the same as DescribeReservedInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeReservedInstancesWithContext(ctx aws.Context, input *DescribeReservedInstancesInput, opts ...request.Option) (*DescribeReservedInstancesOutput, error) {
	req, out := c.DescribeReservedInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReservedInstancesListings = "DescribeReservedInstancesListings"

// DescribeReservedInstancesListingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstancesListings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedInstancesListings for more information on using the DescribeReservedInstancesListings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedInstancesListingsRequest method.
//    req, resp := client.DescribeReservedInstancesListingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings
func (c *EC2) DescribeReservedInstancesListingsRequest(input *DescribeReservedInstancesListingsInput) (req *request.Request, output *DescribeReservedInstancesListingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstancesListings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReservedInstancesListingsInput{}
	}

	output = &DescribeReservedInstancesListingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstancesListings API operation for Amazon Elastic Compute Cloud.
//
// Describes your account's Reserved Instance listings in the Reserved Instance
// Marketplace.
//
// The Reserved Instance Marketplace matches sellers who want to resell Reserved
// Instance capacity that they no longer need with buyers who want to purchase
// additional capacity. Reserved Instances bought and sold through the Reserved
// Instance Marketplace work like any other Reserved Instances.
//
// As a seller, you choose to list some or all of your Reserved Instances, and
// you specify the upfront price to receive for them. Your Reserved Instances
// are then listed in the Reserved Instance Marketplace and are available for
// purchase.
//
// As a buyer, you specify the configuration of the Reserved Instance to purchase,
// and the Marketplace matches what you're searching for with what's available.
// The Marketplace first sells the lowest priced Reserved Instances to you,
// and continues to sell available Reserved Instance listings to you until your
// demand is met. You are charged based on the total price of all of the listings
// that you purchase.
//
// For more information, see Reserved Instance Marketplace (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeReservedInstancesListings for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings
func (c *EC2) DescribeReservedInstancesListings(input *DescribeReservedInstancesListingsInput) (*DescribeReservedInstancesListingsOutput, error) {
	req, out := c.DescribeReservedInstancesListingsRequest(input)
	return out, req.Send()
}

// DescribeReservedInstancesListingsWithContext is the same as DescribeReservedInstancesListings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedInstancesListings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeReservedInstancesListingsWithContext(ctx aws.Context, input *DescribeReservedInstancesListingsInput, opts ...request.Option) (*DescribeReservedInstancesListingsOutput, error) {
	req, out := c.DescribeReservedInstancesListingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReservedInstancesModifications = "DescribeReservedInstancesModifications"

// DescribeReservedInstancesModificationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstancesModifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedInstancesModifications for more information on using the DescribeReservedInstancesModifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedInstancesModificationsRequest method.
//    req, resp := client.DescribeReservedInstancesModificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications
func (c *EC2) DescribeReservedInstancesModificationsRequest(input *DescribeReservedInstancesModificationsInput) (req *request.Request, output *DescribeReservedInstancesModificationsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstancesModifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstancesModificationsInput{}
	}

	output = &DescribeReservedInstancesModificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstancesModifications API operation for Amazon Elastic Compute Cloud.
//
// Describes the modifications made to your Reserved Instances. If no parameter
// is specified, information about all your Reserved Instances modification
// requests is returned. If a modification ID is specified, only information
// about the specific modification is returned.
//
// For more information, see Modifying Reserved Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeReservedInstancesModifications for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications
func (c *EC2) DescribeReservedInstancesModifications(input *DescribeReservedInstancesModificationsInput) (*DescribeReservedInstancesModificationsOutput, error) {
	req, out := c.DescribeReservedInstancesModificationsRequest(input)
	return out, req.Send()
}

// DescribeReservedInstancesModificationsWithContext is the same as DescribeReservedInstancesModifications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedInstancesModifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeReservedInstancesModificationsWithContext(ctx aws.Context, input *DescribeReservedInstancesModificationsInput, opts ...request.Option) (*DescribeReservedInstancesModificationsOutput, error) {
	req, out := c.DescribeReservedInstancesModificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedInstancesModificationsPages iterates over the pages of a DescribeReservedInstancesModifications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedInstancesModifications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedInstancesModifications operation.
//    pageNum := 0
//    err := client.DescribeReservedInstancesModificationsPages(params,
//        func(page *ec2.DescribeReservedInstancesModificationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeReservedInstancesModificationsPages(input *DescribeReservedInstancesModificationsInput, fn func(*DescribeReservedInstancesModificationsOutput, bool) bool) error {
	return c.DescribeReservedInstancesModificationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedInstancesModificationsPagesWithContext same as DescribeReservedInstancesModificationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeReservedInstancesModificationsPagesWithContext(ctx aws.Context, input *DescribeReservedInstancesModificationsInput, fn func(*DescribeReservedInstancesModificationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedInstancesModificationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedInstancesModificationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedInstancesModificationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedInstancesOfferings = "DescribeReservedInstancesOfferings"

// DescribeReservedInstancesOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstancesOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedInstancesOfferings for more information on using the DescribeReservedInstancesOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedInstancesOfferingsRequest method.
//    req, resp := client.DescribeReservedInstancesOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings
func (c *EC2) DescribeReservedInstancesOfferingsRequest(input *DescribeReservedInstancesOfferingsInput) (req *request.Request, output *DescribeReservedInstancesOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstancesOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstancesOfferingsInput{}
	}

	output = &DescribeReservedInstancesOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstancesOfferings API operation for Amazon Elastic Compute Cloud.
//
// Describes Reserved Instance offerings that are available for purchase. With
// Reserved Instances, you purchase the right to launch instances for a period
// of time. During that time period, you do not receive insufficient capacity
// errors, and you pay a lower usage rate than the rate charged for On-Demand
// instances for the actual time used.
//
// If you have listed your own Reserved Instances for sale in the Reserved Instance
// Marketplace, they will be excluded from these results. This is to ensure
// that you do not purchase your own Reserved Instances.
//
// For more information, see Reserved Instance Marketplace (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeReservedInstancesOfferings for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings
func (c *EC2) DescribeReservedInstancesOfferings(input *DescribeReservedInstancesOfferingsInput) (*DescribeReservedInstancesOfferingsOutput, error) {
	req, out := c.DescribeReservedInstancesOfferingsRequest(input)
	return out, req.Send()
}

// DescribeReservedInstancesOfferingsWithContext is the same as DescribeReservedInstancesOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedInstancesOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeReservedInstancesOfferingsWithContext(ctx aws.Context, input *DescribeReservedInstancesOfferingsInput, opts ...request.Option) (*DescribeReservedInstancesOfferingsOutput, error) {
	req, out := c.DescribeReservedInstancesOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedInstancesOfferingsPages iterates over the pages of a DescribeReservedInstancesOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedInstancesOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedInstancesOfferings operation.
//    pageNum := 0
//    err := client.DescribeReservedInstancesOfferingsPages(params,
//        func(page *ec2.DescribeReservedInstancesOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeReservedInstancesOfferingsPages(input *DescribeReservedInstancesOfferingsInput, fn func(*DescribeReservedInstancesOfferingsOutput, bool) bool) error {
	return c.DescribeReservedInstancesOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedInstancesOfferingsPagesWithContext same as DescribeReservedInstancesOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeReservedInstancesOfferingsPagesWithContext(ctx aws.Context, input *DescribeReservedInstancesOfferingsInput, fn func(*DescribeReservedInstancesOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedInstancesOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedInstancesOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedInstancesOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRouteTables = "DescribeRouteTables"

// DescribeRouteTablesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRouteTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRouteTables for more information on using the DescribeRouteTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRouteTablesRequest method.
//    req, resp := client.DescribeRouteTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables
func (c *EC2) DescribeRouteTablesRequest(input *DescribeRouteTablesInput) (req *request.Request, output *DescribeRouteTablesOutput) {
	op := &request.Operation{
		Name:       opDescribeRouteTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRouteTablesInput{}
	}

	output = &DescribeRouteTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRouteTables API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your route tables.
//
// Each subnet in your VPC must be associated with a route table. If a subnet
// is not explicitly associated with any route table, it is implicitly associated
// with the main route table. This command does not return the subnet ID for
// implicit associations.
//
// For more information, see Route Tables (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeRouteTables for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables
func (c *EC2) DescribeRouteTables(input *DescribeRouteTablesInput) (*DescribeRouteTablesOutput, error) {
	req, out := c.DescribeRouteTablesRequest(input)
	return out, req.Send()
}

// DescribeRouteTablesWithContext is the same as DescribeRouteTables with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRouteTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeRouteTablesWithContext(ctx aws.Context, input *DescribeRouteTablesInput, opts ...request.Option) (*DescribeRouteTablesOutput, error) {
	req, out := c.DescribeRouteTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRouteTablesPages iterates over the pages of a DescribeRouteTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRouteTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeRouteTables operation.
//    pageNum := 0
//    err := client.DescribeRouteTablesPages(params,
//        func(page *ec2.DescribeRouteTablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeRouteTablesPages(input *DescribeRouteTablesInput, fn func(*DescribeRouteTablesOutput, bool) bool) error {
	return c.DescribeRouteTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRouteTablesPagesWithContext same as DescribeRouteTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeRouteTablesPagesWithContext(ctx aws.Context, input *DescribeRouteTablesInput, fn func(*DescribeRouteTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRouteTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRouteTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRouteTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeScheduledInstanceAvailability = "DescribeScheduledInstanceAvailability"

// DescribeScheduledInstanceAvailabilityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledInstanceAvailability operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScheduledInstanceAvailability for more information on using the DescribeScheduledInstanceAvailability
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduledInstanceAvailabilityRequest method.
//    req, resp := client.DescribeScheduledInstanceAvailabilityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability
func (c *EC2) DescribeScheduledInstanceAvailabilityRequest(input *DescribeScheduledInstanceAvailabilityInput) (req *request.Request, output *DescribeScheduledInstanceAvailabilityOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledInstanceAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduledInstanceAvailabilityInput{}
	}

	output = &DescribeScheduledInstanceAvailabilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledInstanceAvailability API operation for Amazon Elastic Compute Cloud.
//
// Finds available schedules that meet the specified criteria.
//
// You can search for an available schedule no more than 3 months in advance.
// You must meet the minimum required duration of 1,200 hours per year. For
// example, the minimum daily schedule is 4 hours, the minimum weekly schedule
// is 24 hours, and the minimum monthly schedule is 100 hours.
//
// After you find a schedule that meets your needs, call PurchaseScheduledInstances
// to purchase Scheduled Instances with that schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeScheduledInstanceAvailability for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability
func (c *EC2) DescribeScheduledInstanceAvailability(input *DescribeScheduledInstanceAvailabilityInput) (*DescribeScheduledInstanceAvailabilityOutput, error) {
	req, out := c.DescribeScheduledInstanceAvailabilityRequest(input)
	return out, req.Send()
}

// DescribeScheduledInstanceAvailabilityWithContext is the same as DescribeScheduledInstanceAvailability with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScheduledInstanceAvailability for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeScheduledInstanceAvailabilityWithContext(ctx aws.Context, input *DescribeScheduledInstanceAvailabilityInput, opts ...request.Option) (*DescribeScheduledInstanceAvailabilityOutput, error) {
	req, out := c.DescribeScheduledInstanceAvailabilityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScheduledInstanceAvailabilityPages iterates over the pages of a DescribeScheduledInstanceAvailability operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScheduledInstanceAvailability method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScheduledInstanceAvailability operation.
//    pageNum := 0
//    err := client.DescribeScheduledInstanceAvailabilityPages(params,
//        func(page *ec2.DescribeScheduledInstanceAvailabilityOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeScheduledInstanceAvailabilityPages(input *DescribeScheduledInstanceAvailabilityInput, fn func(*DescribeScheduledInstanceAvailabilityOutput, bool) bool) error {
	return c.DescribeScheduledInstanceAvailabilityPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScheduledInstanceAvailabilityPagesWithContext same as DescribeScheduledInstanceAvailabilityPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeScheduledInstanceAvailabilityPagesWithContext(ctx aws.Context, input *DescribeScheduledInstanceAvailabilityInput, fn func(*DescribeScheduledInstanceAvailabilityOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScheduledInstanceAvailabilityInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScheduledInstanceAvailabilityRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScheduledInstanceAvailabilityOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeScheduledInstances = "DescribeScheduledInstances"

// DescribeScheduledInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScheduledInstances for more information on using the DescribeScheduledInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduledInstancesRequest method.
//    req, resp := client.DescribeScheduledInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances
func (c *EC2) DescribeScheduledInstancesRequest(input *DescribeScheduledInstancesInput) (req *request.Request, output *DescribeScheduledInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduledInstancesInput{}
	}

	output = &DescribeScheduledInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified Scheduled Instances or all your Scheduled Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeScheduledInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances
func (c *EC2) DescribeScheduledInstances(input *DescribeScheduledInstancesInput) (*DescribeScheduledInstancesOutput, error) {
	req, out := c.DescribeScheduledInstancesRequest(input)
	return out, req.Send()
}

// DescribeScheduledInstancesWithContext is the same as DescribeScheduledInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScheduledInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeScheduledInstancesWithContext(ctx aws.Context, input *DescribeScheduledInstancesInput, opts ...request.Option) (*DescribeScheduledInstancesOutput, error) {
	req, out := c.DescribeScheduledInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScheduledInstancesPages iterates over the pages of a DescribeScheduledInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScheduledInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScheduledInstances operation.
//    pageNum := 0
//    err := client.DescribeScheduledInstancesPages(params,
//        func(page *ec2.DescribeScheduledInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeScheduledInstancesPages(input *DescribeScheduledInstancesInput, fn func(*DescribeScheduledInstancesOutput, bool) bool) error {
	return c.DescribeScheduledInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScheduledInstancesPagesWithContext same as DescribeScheduledInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeScheduledInstancesPagesWithContext(ctx aws.Context, input *DescribeScheduledInstancesInput, fn func(*DescribeScheduledInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScheduledInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScheduledInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScheduledInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSecurityGroupReferences = "DescribeSecurityGroupReferences"

// DescribeSecurityGroupReferencesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityGroupReferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSecurityGroupReferences for more information on using the DescribeSecurityGroupReferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSecurityGroupReferencesRequest method.
//    req, resp := client.DescribeSecurityGroupReferencesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences
func (c *EC2) DescribeSecurityGroupReferencesRequest(input *DescribeSecurityGroupReferencesInput) (req *request.Request, output *DescribeSecurityGroupReferencesOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityGroupReferences,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecurityGroupReferencesInput{}
	}

	output = &DescribeSecurityGroupReferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecurityGroupReferences API operation for Amazon Elastic Compute Cloud.
//
// [VPC only] Describes the VPCs on the other side of a VPC peering connection
// that are referencing the security groups you've specified in this request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSecurityGroupReferences for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences
func (c *EC2) DescribeSecurityGroupReferences(input *DescribeSecurityGroupReferencesInput) (*DescribeSecurityGroupReferencesOutput, error) {
	req, out := c.DescribeSecurityGroupReferencesRequest(input)
	return out, req.Send()
}

// DescribeSecurityGroupReferencesWithContext is the same as DescribeSecurityGroupReferences with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecurityGroupReferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeSecurityGroupReferencesWithContext(ctx aws.Context, input *DescribeSecurityGroupReferencesInput, opts ...request.Option) (*DescribeSecurityGroupReferencesOutput, error) {
	req, out := c.DescribeSecurityGroupReferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecurityGroups = "DescribeSecurityGroups"

// DescribeSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSecurityGroups for more information on using the DescribeSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSecurityGroupsRequest method.
//    req, resp := client.DescribeSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups
func (c *EC2) DescribeSecurityGroupsRequest(input *DescribeSecurityGroupsInput) (req *request.Request, output *DescribeSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSecurityGroupsInput{}
	}

	output = &DescribeSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecurityGroups API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified security groups or all of your security groups.
//
// A security group is for use with instances either in the EC2-Classic platform
// or in a specific VPC. For more information, see Amazon EC2 Security Groups
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
// in the Amazon Elastic Compute Cloud User Guide and Security Groups for Your
// VPC (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSecurityGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups
func (c *EC2) DescribeSecurityGroups(input *DescribeSecurityGroupsInput) (*DescribeSecurityGroupsOutput, error) {
	req, out := c.DescribeSecurityGroupsRequest(input)
	return out, req.Send()
}

// DescribeSecurityGroupsWithContext is the same as DescribeSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeSecurityGroupsWithContext(ctx aws.Context, input *DescribeSecurityGroupsInput, opts ...request.Option) (*DescribeSecurityGroupsOutput, error) {
	req, out := c.DescribeSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSecurityGroupsPages iterates over the pages of a DescribeSecurityGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSecurityGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSecurityGroups operation.
//    pageNum := 0
//    err := client.DescribeSecurityGroupsPages(params,
//        func(page *ec2.DescribeSecurityGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeSecurityGroupsPages(input *DescribeSecurityGroupsInput, fn func(*DescribeSecurityGroupsOutput, bool) bool) error {
	return c.DescribeSecurityGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSecurityGroupsPagesWithContext same as DescribeSecurityGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeSecurityGroupsPagesWithContext(ctx aws.Context, input *DescribeSecurityGroupsInput, fn func(*DescribeSecurityGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSecurityGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSecurityGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSecurityGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSnapshotAttribute = "DescribeSnapshotAttribute"

// DescribeSnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshotAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSnapshotAttribute for more information on using the DescribeSnapshotAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSnapshotAttributeRequest method.
//    req, resp := client.DescribeSnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttribute
func (c *EC2) DescribeSnapshotAttributeRequest(input *DescribeSnapshotAttributeInput) (req *request.Request, output *DescribeSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotAttributeInput{}
	}

	output = &DescribeSnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshotAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified snapshot. You can specify
// only one attribute at a time.
//
// For more information about EBS snapshots, see Amazon EBS snapshots (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSnapshotAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttribute
func (c *EC2) DescribeSnapshotAttribute(input *DescribeSnapshotAttributeInput) (*DescribeSnapshotAttributeOutput, error) {
	req, out := c.DescribeSnapshotAttributeRequest(input)
	return out, req.Send()
}

// DescribeSnapshotAttributeWithContext is the same as DescribeSnapshotAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSnapshotAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeSnapshotAttributeWithContext(ctx aws.Context, input *DescribeSnapshotAttributeInput, opts ...request.Option) (*DescribeSnapshotAttributeOutput, error) {
	req, out := c.DescribeSnapshotAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSnapshots = "DescribeSnapshots"

// DescribeSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSnapshots for more information on using the DescribeSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSnapshotsRequest method.
//    req, resp := client.DescribeSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots
func (c *EC2) DescribeSnapshotsRequest(input *DescribeSnapshotsInput) (req *request.Request, output *DescribeSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSnapshotsInput{}
	}

	output = &DescribeSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshots API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified EBS snapshots available to you or all of the EBS
// snapshots available to you.
//
// The snapshots available to you include public snapshots, private snapshots
// that you own, and private snapshots owned by other AWS accounts for which
// you have explicit create volume permissions.
//
// The create volume permissions fall into the following categories:
//
//    * public: The owner of the snapshot granted create volume permissions
//    for the snapshot to the all group. All AWS accounts have create volume
//    permissions for these snapshots.
//
//    * explicit: The owner of the snapshot granted create volume permissions
//    to a specific AWS account.
//
//    * implicit: An AWS account has implicit create volume permissions for
//    all snapshots it owns.
//
// The list of snapshots returned can be filtered by specifying snapshot IDs,
// snapshot owners, or AWS accounts with create volume permissions. If no options
// are specified, Amazon EC2 returns all snapshots for which you have create
// volume permissions.
//
// If you specify one or more snapshot IDs, only snapshots that have the specified
// IDs are returned. If you specify an invalid snapshot ID, an error is returned.
// If you specify a snapshot ID for which you do not have access, it is not
// included in the returned results.
//
// If you specify one or more snapshot owners using the OwnerIds option, only
// snapshots from the specified owners and for which you have access are returned.
// The results can include the AWS account IDs of the specified owners, amazon
// for snapshots owned by Amazon, or self for snapshots that you own.
//
// If you specify a list of restorable users, only snapshots with create snapshot
// permissions for those users are returned. You can specify AWS account IDs
// (if you own the snapshots), self for snapshots for which you own or have
// explicit permissions, or all for public snapshots.
//
// If you are describing a long list of snapshots, we recommend that you paginate
// the output to make the list more manageable. The MaxResults parameter sets
// the maximum number of results returned in a single page. If the list of results
// exceeds your MaxResults value, then that number of results is returned along
// with a NextToken value that can be passed to a subsequent DescribeSnapshots
// request to retrieve the remaining results.
//
// To get the state of fast snapshot restores for a snapshot, use DescribeFastSnapshotRestores.
//
// For more information about EBS snapshots, see Amazon EBS snapshots (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSnapshots for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots
func (c *EC2) DescribeSnapshots(input *DescribeSnapshotsInput) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeSnapshotsWithContext is the same as DescribeSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeSnapshotsWithContext(ctx aws.Context, input *DescribeSnapshotsInput, opts ...request.Option) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSnapshotsPages iterates over the pages of a DescribeSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSnapshots operation.
//    pageNum := 0
//    err := client.DescribeSnapshotsPages(params,
//        func(page *ec2.DescribeSnapshotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeSnapshotsPages(input *DescribeSnapshotsInput, fn func(*DescribeSnapshotsOutput, bool) bool) error {
	return c.DescribeSnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSnapshotsPagesWithContext same as DescribeSnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeSnapshotsPagesWithContext(ctx aws.Context, input *DescribeSnapshotsInput, fn func(*DescribeSnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSnapshotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSpotDatafeedSubscription = "DescribeSpotDatafeedSubscription"

// DescribeSpotDatafeedSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpotDatafeedSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSpotDatafeedSubscription for more information on using the DescribeSpotDatafeedSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSpotDatafeedSubscriptionRequest method.
//    req, resp := client.DescribeSpotDatafeedSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscription
func (c *EC2) DescribeSpotDatafeedSubscriptionRequest(input *DescribeSpotDatafeedSubscriptionInput) (req *request.Request, output *DescribeSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotDatafeedSubscriptionInput{}
	}

	output = &DescribeSpotDatafeedSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpotDatafeedSubscription API operation for Amazon Elastic Compute Cloud.
//
// Describes the data feed for Spot Instances. For more information, see Spot
// Instance data feed (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
// in the Amazon EC2 User Guide for Linux Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSpotDatafeedSubscription for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscription
func (c *EC2) DescribeSpotDatafeedSubscription(input *DescribeSpotDatafeedSubscriptionInput) (*DescribeSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DescribeSpotDatafeedSubscriptionRequest(input)
	return out, req.Send()
}

// DescribeSpotDatafeedSubscriptionWithContext is the same as DescribeSpotDatafeedSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSpotDatafeedSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeSpotDatafeedSubscriptionWithContext(ctx aws.Context, input *DescribeSpotDatafeedSubscriptionInput, opts ...request.Option) (*DescribeSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DescribeSpotDatafeedSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSpotFleetInstances = "DescribeSpotFleetInstances"

// DescribeSpotFleetInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpotFleetInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSpotFleetInstances for more information on using the DescribeSpotFleetInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSpotFleetInstancesRequest method.
//    req, resp := client.DescribeSpotFleetInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances
func (c *EC2) DescribeSpotFleetInstancesRequest(input *DescribeSpotFleetInstancesInput) (req *request.Request, output *DescribeSpotFleetInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotFleetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotFleetInstancesInput{}
	}

	output = &DescribeSpotFleetInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpotFleetInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes the running instances for the specified Spot Fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSpotFleetInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances
func (c *EC2) DescribeSpotFleetInstances(input *DescribeSpotFleetInstancesInput) (*DescribeSpotFleetInstancesOutput, error) {
	req, out := c.DescribeSpotFleetInstancesRequest(input)
	return out, req.Send()
}

// DescribeSpotFleetInstancesWithContext is the same as DescribeSpotFleetInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSpotFleetInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeSpotFleetInstancesWithContext(ctx aws.Context, input *DescribeSpotFleetInstancesInput, opts ...request.Option) (*DescribeSpotFleetInstancesOutput, error) {
	req, out := c.DescribeSpotFleetInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSpotFleetRequestHistory = "DescribeSpotFleetRequestHistory"

// DescribeSpotFleetRequestHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpotFleetRequestHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSpotFleetRequestHistory for more information on using the DescribeSpotFleetRequestHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSpotFleetRequestHistoryRequest method.
//    req, resp := client.DescribeSpotFleetRequestHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistory
func (c *EC2) DescribeSpotFleetRequestHistoryRequest(input *DescribeSpotFleetRequestHistoryInput) (req *request.Request, output *DescribeSpotFleetRequestHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotFleetRequestHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotFleetRequestHistoryInput{}
	}

	output = &DescribeSpotFleetRequestHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpotFleetRequestHistory API operation for Amazon Elastic Compute Cloud.
//
// Describes the events for the specified Spot Fleet request during the specified
// time.
//
// Spot Fleet events are delayed by up to 30 seconds before they can be described.
// This ensures that you can query by the last evaluated time and not miss a
// recorded event. Spot Fleet events are available for 48 hours.
//
// Returns awserr.Error