// Copyright (c) 2016, 2018, 2019, Oracle and/or its affiliates. All rights reserved.
// Code generated. DO NOT EDIT.

// Core Services API
//
// API covering the Networking (https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/overview.htm),
// Compute (https://docs.cloud.oracle.com/iaas/Content/Compute/Concepts/computeoverview.htm), and
// Block Volume (https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/overview.htm) services. Use this API
// to manage resources such as virtual cloud networks (VCNs), compute instances, and
// block storage volumes.
//

package core

import (
	"github.com/oracle/oci-go-sdk/common"
)

// DedicatedVmHostInstanceSummary Condensed instance data when listing instances on a dedicated VM host.
type DedicatedVmHostInstanceSummary struct {

	// The availability domain the virtual machine instance is running in.
	// Example: `Uocm:PHX-AD-1`
	AvailabilityDomain *string `mandatory:"true" json:"availabilityDomain"`

	// The OCID of the compartment that contains the virtual machine instance.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// The OCID of the virtual machine instance.
	InstanceId *string `mandatory:"true" json:"instanceId"`

	// The shape of the VM instance.
	Shape *string `mandatory:"true" json:"shape"`

	// The date and time the virtual machine instance was created, in the format defined by RFC3339.
	// Example: `2016-08-25T21:10:29.600Z`
	TimeCreated *common.SDKTime `mandatory:"true" json:"timeCreated"`
}

func (m DedicatedVmHostInstanceSummary) String() string {
	return common.PointerString(m)
}
