// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sso

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type LogoutInput struct {
	_ struct{} `type:"structure"`

	// The token issued by the CreateToken API call. For more information, see CreateToken
	// (https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html)
	// in the AWS SSO OIDC API Reference Guide.
	//
	// AccessToken is a required field
	AccessToken *string `location:"header" locationName:"x-amz-sso_bearer_token" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s LogoutInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogoutInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LogoutInput"}

	if s.AccessToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogoutInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccessToken != nil {
		v := *s.AccessToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-sso_bearer_token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type LogoutOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s LogoutOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogoutOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opLogout = "Logout"

// LogoutRequest returns a request value for making API operation for
// AWS Single Sign-On.
//
// Removes the client- and server-side session that is associated with the user.
//
//    // Example sending a request using LogoutRequest.
//    req := client.LogoutRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/Logout
func (c *Client) LogoutRequest(input *LogoutInput) LogoutRequest {
	op := &aws.Operation{
		Name:       opLogout,
		HTTPMethod: "POST",
		HTTPPath:   "/logout",
	}

	if input == nil {
		input = &LogoutInput{}
	}

	req := c.newRequest(op, input, &LogoutOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	req.Config.Credentials = aws.AnonymousCredentials
	return LogoutRequest{Request: req, Input: input, Copy: c.LogoutRequest}
}

// LogoutRequest is the request type for the
// Logout API operation.
type LogoutRequest struct {
	*aws.Request
	Input *LogoutInput
	Copy  func(*LogoutInput) LogoutRequest
}

// Send marshals and sends the Logout API request.
func (r LogoutRequest) Send(ctx context.Context) (*LogoutResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &LogoutResponse{
		LogoutOutput: r.Request.Data.(*LogoutOutput),
		response:     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// LogoutResponse is the response type for the
// Logout API operation.
type LogoutResponse struct {
	*LogoutOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Logout request.
func (r *LogoutResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
