package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterCerts invokes the cs.DescribeClusterCerts API synchronously
// api document: https://help.aliyun.com/api/cs/describeclustercerts.html
func (client *Client) DescribeClusterCerts(request *DescribeClusterCertsRequest) (response *DescribeClusterCertsResponse, err error) {
	response = CreateDescribeClusterCertsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterCertsWithChan invokes the cs.DescribeClusterCerts API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclustercerts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterCertsWithChan(request *DescribeClusterCertsRequest) (<-chan *DescribeClusterCertsResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterCertsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterCerts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterCertsWithCallback invokes the cs.DescribeClusterCerts API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclustercerts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterCertsWithCallback(request *DescribeClusterCertsRequest, callback func(response *DescribeClusterCertsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterCertsResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterCerts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterCertsRequest is the request struct for api DescribeClusterCerts
type DescribeClusterCertsRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// DescribeClusterCertsResponse is the response struct for api DescribeClusterCerts
type DescribeClusterCertsResponse struct {
	*responses.BaseResponse
}

// CreateDescribeClusterCertsRequest creates a request to invoke DescribeClusterCerts API
func CreateDescribeClusterCertsRequest() (request *DescribeClusterCertsRequest) {
	request = &DescribeClusterCertsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusterCerts", "/clusters/[ClusterId]/certs", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeClusterCertsResponse creates a response to parse from DescribeClusterCerts response
func CreateDescribeClusterCertsResponse() (response *DescribeClusterCertsResponse) {
	response = &DescribeClusterCertsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
