package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMonthlyServiceStatus invokes the r_kvstore.DescribeMonthlyServiceStatus API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/describemonthlyservicestatus.html
func (client *Client) DescribeMonthlyServiceStatus(request *DescribeMonthlyServiceStatusRequest) (response *DescribeMonthlyServiceStatusResponse, err error) {
	response = CreateDescribeMonthlyServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMonthlyServiceStatusWithChan invokes the r_kvstore.DescribeMonthlyServiceStatus API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describemonthlyservicestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMonthlyServiceStatusWithChan(request *DescribeMonthlyServiceStatusRequest) (<-chan *DescribeMonthlyServiceStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeMonthlyServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMonthlyServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMonthlyServiceStatusWithCallback invokes the r_kvstore.DescribeMonthlyServiceStatus API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describemonthlyservicestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMonthlyServiceStatusWithCallback(request *DescribeMonthlyServiceStatusRequest, callback func(response *DescribeMonthlyServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMonthlyServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeMonthlyServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMonthlyServiceStatusRequest is the request struct for api DescribeMonthlyServiceStatus
type DescribeMonthlyServiceStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Month                string           `position:"Query" name:"Month"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	InstanceIds          string           `position:"Query" name:"InstanceIds"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeMonthlyServiceStatusResponse is the response struct for api DescribeMonthlyServiceStatus
type DescribeMonthlyServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	TotalCount       int64            `json:"TotalCount" xml:"TotalCount"`
	InstanceSLAInfos InstanceSLAInfos `json:"InstanceSLAInfos" xml:"InstanceSLAInfos"`
}

// CreateDescribeMonthlyServiceStatusRequest creates a request to invoke DescribeMonthlyServiceStatus API
func CreateDescribeMonthlyServiceStatusRequest() (request *DescribeMonthlyServiceStatusRequest) {
	request = &DescribeMonthlyServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeMonthlyServiceStatus", "redisa", "openAPI")
	return
}

// CreateDescribeMonthlyServiceStatusResponse creates a response to parse from DescribeMonthlyServiceStatus response
func CreateDescribeMonthlyServiceStatusResponse() (response *DescribeMonthlyServiceStatusResponse) {
	response = &DescribeMonthlyServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
