package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachNetworkOptimizationSags invokes the smartag.AttachNetworkOptimizationSags API synchronously
// api document: https://help.aliyun.com/api/smartag/attachnetworkoptimizationsags.html
func (client *Client) AttachNetworkOptimizationSags(request *AttachNetworkOptimizationSagsRequest) (response *AttachNetworkOptimizationSagsResponse, err error) {
	response = CreateAttachNetworkOptimizationSagsResponse()
	err = client.DoAction(request, response)
	return
}

// AttachNetworkOptimizationSagsWithChan invokes the smartag.AttachNetworkOptimizationSags API asynchronously
// api document: https://help.aliyun.com/api/smartag/attachnetworkoptimizationsags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AttachNetworkOptimizationSagsWithChan(request *AttachNetworkOptimizationSagsRequest) (<-chan *AttachNetworkOptimizationSagsResponse, <-chan error) {
	responseChan := make(chan *AttachNetworkOptimizationSagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachNetworkOptimizationSags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachNetworkOptimizationSagsWithCallback invokes the smartag.AttachNetworkOptimizationSags API asynchronously
// api document: https://help.aliyun.com/api/smartag/attachnetworkoptimizationsags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AttachNetworkOptimizationSagsWithCallback(request *AttachNetworkOptimizationSagsRequest, callback func(response *AttachNetworkOptimizationSagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachNetworkOptimizationSagsResponse
		var err error
		defer close(result)
		response, err = client.AttachNetworkOptimizationSags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachNetworkOptimizationSagsRequest is the request struct for api AttachNetworkOptimizationSags
type AttachNetworkOptimizationSagsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	NetworkOptId         string           `position:"Query" name:"NetworkOptId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	SmartAGIds           *[]string        `position:"Query" name:"SmartAGIds"  type:"Repeated"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// AttachNetworkOptimizationSagsResponse is the response struct for api AttachNetworkOptimizationSags
type AttachNetworkOptimizationSagsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachNetworkOptimizationSagsRequest creates a request to invoke AttachNetworkOptimizationSags API
func CreateAttachNetworkOptimizationSagsRequest() (request *AttachNetworkOptimizationSagsRequest) {
	request = &AttachNetworkOptimizationSagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "AttachNetworkOptimizationSags", "smartag", "openAPI")
	return
}

// CreateAttachNetworkOptimizationSagsResponse creates a response to parse from AttachNetworkOptimizationSags response
func CreateAttachNetworkOptimizationSagsResponse() (response *AttachNetworkOptimizationSagsResponse) {
	response = &AttachNetworkOptimizationSagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
