/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// S3XLister helps list S3Xs.
type S3XLister interface {
	// List lists all S3Xs in the indexer.
	List(selector labels.Selector) (ret []*v1.S3X, err error)
	// S3Xs returns an object that can list and get S3Xs.
	S3Xs(namespace string) S3XNamespaceLister
	S3XListerExpansion
}

// s3XLister implements the S3XLister interface.
type s3XLister struct {
	indexer cache.Indexer
}

// NewS3XLister returns a new S3XLister.
func NewS3XLister(indexer cache.Indexer) S3XLister {
	return &s3XLister{indexer: indexer}
}

// List lists all S3Xs in the indexer.
func (s *s3XLister) List(selector labels.Selector) (ret []*v1.S3X, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.S3X))
	})
	return ret, err
}

// S3Xs returns an object that can list and get S3Xs.
func (s *s3XLister) S3Xs(namespace string) S3XNamespaceLister {
	return s3XNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// S3XNamespaceLister helps list and get S3Xs.
type S3XNamespaceLister interface {
	// List lists all S3Xs in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.S3X, err error)
	// Get retrieves the S3X from the indexer for a given namespace and name.
	Get(name string) (*v1.S3X, error)
	S3XNamespaceListerExpansion
}

// s3XNamespaceLister implements the S3XNamespaceLister
// interface.
type s3XNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all S3Xs in the indexer for a given namespace.
func (s s3XNamespaceLister) List(selector labels.Selector) (ret []*v1.S3X, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.S3X))
	})
	return ret, err
}

// Get retrieves the S3X from the indexer for a given namespace and name.
func (s s3XNamespaceLister) Get(name string) (*v1.S3X, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("s3x"), name)
	}
	return obj.(*v1.S3X), nil
}
