package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBcSchema invokes the baas.DescribeBcSchema API synchronously
// api document: https://help.aliyun.com/api/baas/describebcschema.html
func (client *Client) DescribeBcSchema(request *DescribeBcSchemaRequest) (response *DescribeBcSchemaResponse, err error) {
	response = CreateDescribeBcSchemaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBcSchemaWithChan invokes the baas.DescribeBcSchema API asynchronously
// api document: https://help.aliyun.com/api/baas/describebcschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBcSchemaWithChan(request *DescribeBcSchemaRequest) (<-chan *DescribeBcSchemaResponse, <-chan error) {
	responseChan := make(chan *DescribeBcSchemaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBcSchema(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBcSchemaWithCallback invokes the baas.DescribeBcSchema API asynchronously
// api document: https://help.aliyun.com/api/baas/describebcschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBcSchemaWithCallback(request *DescribeBcSchemaRequest, callback func(response *DescribeBcSchemaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBcSchemaResponse
		var err error
		defer close(result)
		response, err = client.DescribeBcSchema(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBcSchemaRequest is the request struct for api DescribeBcSchema
type DescribeBcSchemaRequest struct {
	*requests.RpcRequest
	Bizid string `position:"Body" name:"Bizid"`
}

// DescribeBcSchemaResponse is the response struct for api DescribeBcSchema
type DescribeBcSchemaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeBcSchemaRequest creates a request to invoke DescribeBcSchema API
func CreateDescribeBcSchemaRequest() (request *DescribeBcSchemaRequest) {
	request = &DescribeBcSchemaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeBcSchema", "", "")
	return
}

// CreateDescribeBcSchemaResponse creates a response to parse from DescribeBcSchema response
func CreateDescribeBcSchemaResponse() (response *DescribeBcSchemaResponse) {
	response = &DescribeBcSchemaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
