package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFlowVariableCollection invokes the emr.ModifyFlowVariableCollection API synchronously
// api document: https://help.aliyun.com/api/emr/modifyflowvariablecollection.html
func (client *Client) ModifyFlowVariableCollection(request *ModifyFlowVariableCollectionRequest) (response *ModifyFlowVariableCollectionResponse, err error) {
	response = CreateModifyFlowVariableCollectionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFlowVariableCollectionWithChan invokes the emr.ModifyFlowVariableCollection API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflowvariablecollection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowVariableCollectionWithChan(request *ModifyFlowVariableCollectionRequest) (<-chan *ModifyFlowVariableCollectionResponse, <-chan error) {
	responseChan := make(chan *ModifyFlowVariableCollectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFlowVariableCollection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFlowVariableCollectionWithCallback invokes the emr.ModifyFlowVariableCollection API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflowvariablecollection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowVariableCollectionWithCallback(request *ModifyFlowVariableCollectionRequest, callback func(response *ModifyFlowVariableCollectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFlowVariableCollectionResponse
		var err error
		defer close(result)
		response, err = client.ModifyFlowVariableCollection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFlowVariableCollectionRequest is the request struct for api ModifyFlowVariableCollection
type ModifyFlowVariableCollectionRequest struct {
	*requests.RpcRequest
	Data string `position:"Query" name:"Data"`
}

// ModifyFlowVariableCollectionResponse is the response struct for api ModifyFlowVariableCollection
type ModifyFlowVariableCollectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyFlowVariableCollectionRequest creates a request to invoke ModifyFlowVariableCollection API
func CreateModifyFlowVariableCollectionRequest() (request *ModifyFlowVariableCollectionRequest) {
	request = &ModifyFlowVariableCollectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyFlowVariableCollection", "emr", "openAPI")
	return
}

// CreateModifyFlowVariableCollectionResponse creates a response to parse from ModifyFlowVariableCollection response
func CreateModifyFlowVariableCollectionResponse() (response *ModifyFlowVariableCollectionResponse) {
	response = &ModifyFlowVariableCollectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
