package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetLoadBalancerTCPListenerAttribute invokes the slb.SetLoadBalancerTCPListenerAttribute API synchronously
// api document: https://help.aliyun.com/api/slb/setloadbalancertcplistenerattribute.html
func (client *Client) SetLoadBalancerTCPListenerAttribute(request *SetLoadBalancerTCPListenerAttributeRequest) (response *SetLoadBalancerTCPListenerAttributeResponse, err error) {
	response = CreateSetLoadBalancerTCPListenerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// SetLoadBalancerTCPListenerAttributeWithChan invokes the slb.SetLoadBalancerTCPListenerAttribute API asynchronously
// api document: https://help.aliyun.com/api/slb/setloadbalancertcplistenerattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetLoadBalancerTCPListenerAttributeWithChan(request *SetLoadBalancerTCPListenerAttributeRequest) (<-chan *SetLoadBalancerTCPListenerAttributeResponse, <-chan error) {
	responseChan := make(chan *SetLoadBalancerTCPListenerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetLoadBalancerTCPListenerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetLoadBalancerTCPListenerAttributeWithCallback invokes the slb.SetLoadBalancerTCPListenerAttribute API asynchronously
// api document: https://help.aliyun.com/api/slb/setloadbalancertcplistenerattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetLoadBalancerTCPListenerAttributeWithCallback(request *SetLoadBalancerTCPListenerAttributeRequest, callback func(response *SetLoadBalancerTCPListenerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetLoadBalancerTCPListenerAttributeResponse
		var err error
		defer close(result)
		response, err = client.SetLoadBalancerTCPListenerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetLoadBalancerTCPListenerAttributeRequest is the request struct for api SetLoadBalancerTCPListenerAttribute
type SetLoadBalancerTCPListenerAttributeRequest struct {
	*requests.RpcRequest
	AccessKeyId               string           `position:"Query" name:"access_key_id"`
	HealthCheckConnectTimeout requests.Integer `position:"Query" name:"HealthCheckConnectTimeout"`
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HealthCheckURI            string           `position:"Query" name:"HealthCheckURI"`
	Description               string           `position:"Query" name:"Description"`
	UnhealthyThreshold        requests.Integer `position:"Query" name:"UnhealthyThreshold"`
	HealthyThreshold          requests.Integer `position:"Query" name:"HealthyThreshold"`
	AclStatus                 string           `position:"Query" name:"AclStatus"`
	Scheduler                 string           `position:"Query" name:"Scheduler"`
	AclType                   string           `position:"Query" name:"AclType"`
	MasterSlaveServerGroup    string           `position:"Query" name:"MasterSlaveServerGroup"`
	EstablishedTimeout        requests.Integer `position:"Query" name:"EstablishedTimeout"`
	MaxConnection             requests.Integer `position:"Query" name:"MaxConnection"`
	PersistenceTimeout        requests.Integer `position:"Query" name:"PersistenceTimeout"`
	VpcIds                    string           `position:"Query" name:"VpcIds"`
	VServerGroupId            string           `position:"Query" name:"VServerGroupId"`
	AclId                     string           `position:"Query" name:"AclId"`
	ListenerPort              requests.Integer `position:"Query" name:"ListenerPort"`
	HealthCheckType           string           `position:"Query" name:"HealthCheckType"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth                 requests.Integer `position:"Query" name:"Bandwidth"`
	HealthCheckMethod         string           `position:"Query" name:"HealthCheckMethod"`
	HealthCheckDomain         string           `position:"Query" name:"HealthCheckDomain"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	SynProxy                  string           `position:"Query" name:"SynProxy"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	Tags                      string           `position:"Query" name:"Tags"`
	LoadBalancerId            string           `position:"Query" name:"LoadBalancerId"`
	MasterSlaveServerGroupId  string           `position:"Query" name:"MasterSlaveServerGroupId"`
	HealthCheckInterval       requests.Integer `position:"Query" name:"HealthCheckInterval"`
	HealthCheckConnectPort    requests.Integer `position:"Query" name:"HealthCheckConnectPort"`
	HealthCheckHttpCode       string           `position:"Query" name:"HealthCheckHttpCode"`
	VServerGroup              string           `position:"Query" name:"VServerGroup"`
}

// SetLoadBalancerTCPListenerAttributeResponse is the response struct for api SetLoadBalancerTCPListenerAttribute
type SetLoadBalancerTCPListenerAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetLoadBalancerTCPListenerAttributeRequest creates a request to invoke SetLoadBalancerTCPListenerAttribute API
func CreateSetLoadBalancerTCPListenerAttributeRequest() (request *SetLoadBalancerTCPListenerAttributeRequest) {
	request = &SetLoadBalancerTCPListenerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "SetLoadBalancerTCPListenerAttribute", "slb", "openAPI")
	return
}

// CreateSetLoadBalancerTCPListenerAttributeResponse creates a response to parse from SetLoadBalancerTCPListenerAttribute response
func CreateSetLoadBalancerTCPListenerAttributeResponse() (response *SetLoadBalancerTCPListenerAttributeResponse) {
	response = &SetLoadBalancerTCPListenerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
