---
last_modified_on: "2020-08-31"
$schema: ".schema.json"
title: "Switching to the MPL 2.0 License"
description: "The Vector project has switched to the Mozilla Public License 2.0"
author_github: "https://github.com/binarylogic"
pr_numbers: [1314]
release: "0.11.0"
hide_on_release_notes: true
tags: ["type: announcement"]
---

Vector has switched to the [Mozilla Public License 2.0][urls.mpl_20], a
a weak copyleft license used by other popular open-source projects, such as
[Terraform][urls.terraform_license] and [Consul][urls.consul_license].

## Why?

[This excellent article][urls.mpl_20_post] by Julien Ponge describes the license
well, and the [Mozilla MPL 2.0 FAQ][urls.mpl_faq] offers a more in-depth
analysis:

> Like all other free and open source software, software available under the MPL
> is available for anyone (including individuals and companies) to use for any
> purpose. The MPL only creates obligations for you if you want to distribute
> the software outside your organization.

We love open-source, and we feel this license more accurately embodies the
spirit of open-source by requiring _direct_ Vector code changes (not code around
it) to be made in the open. This ensures that the entire Vector community
benefits from changes. A fundamental princple of open-source.

## Does it restrict usage?

No! It is not our intent to restrict Vector usage or distribution in any way,
now or in the future.

[urls.consul_license]: https://github.com/hashicorp/consul/blob/master/LICENSE
[urls.mpl_20]: https://www.mozilla.org/en-US/MPL/2.0/
[urls.mpl_20_post]: https://julien.ponge.org/blog/mozilla-public-license-v2-a-good-middleground/
[urls.mpl_faq]: https://www.mozilla.org/en-US/MPL/2.0/FAQ/
[urls.terraform_license]: https://github.com/hashicorp/terraform/blob/master/LICENSE
