---
last_modified_on: "2021-04-21"
$schema: ".schema.json"
title: "Adding the `abort` keyword to VRL"
description: "Aborting processing of events in `remap`"
author_github: "https://github.com/jszwedko"
pr_numbers: [6723]
release: "0.13.0"
hide_on_release_notes: false
tags: ["type: new feature", "domain: remap" ]
---

Vector 0.13 introduces a new [`abort` expression][abort] to the [Vector Remap
Language (VRL)][vrl]. This expression can be used to abort processing in
a [`remap` transform][remap]. This is useful for aborting processing of invalid
events.

By default, events that encounter an `abort` expression will be dropped by the
[`remap` transform][remap], but this behavior can be modified to simply pass
along the unmodified event to the next transform by setting `drop_on_abort` to
`false`.

## Example

As an example, the `abort` expression can be used if you want to do some
validation on the event before processing it, discarding any invalid events.

Given a config of:

```toml
[sources.in]
  type = "generator"
  format = "shuffle"
  interval = 1.0
  lines = ['{ "message": "valid message", "type": "ok"}', '{ "message": "invalid message", "type": "unknown"}']

[transforms.remap]
  type = "remap"
  inputs = ["in"]
  source = """
    . |= object!(parse_json!(string!(.message)))
    if .type != "ok" {
      abort # unknown type
    }
  """

[sinks.out]
  type = "console"
  inputs = ["remap"]
  encoding.codec = "json"
```

You would expect to see something like:

```json
{"message":"valid message","timestamp":"2021-04-20T20:26:05.214875Z","type":"ok"}
{"message":"valid message","timestamp":"2021-04-20T20:26:06.213879Z","type":"ok"}
{"message":"valid message","timestamp":"2021-04-20T20:26:07.214254Z","type":"ok"}
{"message":"valid message","timestamp":"2021-04-20T20:26:08.215219Z","type":"ok"}
```

That is, that all of the events that don't have a `type` of `ok`, would be
dropped.

[abort]: /docs/reference/vrl/expressions/#index
[remap]: /docs/reference/configuration/tranforms/remap
[vrl]: /docs/reference/vrl/
