---
title: Deployment Strategies
description: The various strategies used to deploy Vector across your infrastructure.
sidebar_label: Strategies
---

Vector is designed to be the single and only tool needed to get data from A to
B. This means Vector can be deployed as a [daemon](#daemon),
[sidecar](#sidecar), or a [service](#service). You combine these strategies to
form [topologies][docs.topologies] which are covered in the
[next section][docs.topologies]. In this section we'll cover each strategy in
detail and help you understand when to use each.

## Daemon

The [daemon deployment strategy][docs.strategies#daemon] is designed for data
collection on a single host. Vector runs in the background, in its own process,
collecting _all_ data for that host.
Typically data is collected from a process manager, such as Journald via
Vector's [`journald` source][docs.sources.journald], but can be collected
through any of Vector's [sources][docs.sources].
The following diagram demonstrates how it works.

<DaemonDiagram
  platformName={null}
  sourceName={null}
  sinkName={null} />

### When to use

- You are responsible for the host machine and have the ability to install
  Vector directly on the host.
- You are operationally proficient and understand how to reliably install,
  manage, and configure software.
- You want a single robust solution for collecting and shipping your
  observability data on each host.

### When NOT to use

- You do not control the host machine or environment.
- You do not feel comfortable installing, managing, and configuring host-level
  software.
- You want to shift responsibility of collecting and shipping observability data
  to each service owner.

## Sidecar

The [sidecar deployment strategy][docs.strategies#sidecar] is designed to
collect data from a _single_ service. Vector has a tight 1 to 1 coupling with
each service. Typically data is collected by tailing local files via Vector's
[`file` source][docs.sources.file], but can be collected through any of Vector's
[sources][docs.sources]. The following diagram demonstrates how it works.

<SidecarDiagram
  platformName={null}
  sourceName={null}
  sinkName={null} />

### When to use

- You are not responsible for the host machine and do not have the ability to
  install Vector directly on the host.
- You want to couple data collection with each service, shifting responsibility
  to the service owner.
- You find it simpler for each service to have it own specific Vector
  instance and configuration file.

### When NOT to use

- You do not like the idea of having multiple Vector instances on a
  single host.

## Service

The [service deployment strategy][docs.strategies#service] treats Vector like a
separate service. It is designed to receive data from an upstream source and
fan-out to one or more destinations.
Typically, upstream sources are other Vector instances sending data via the
[`vector` sink][docs.sinks.vector], but can be collected through any of Vector's
[sources][docs.sources].
The following diagram demonstrates how it works.

<ServiceDiagram
  platformName={null}
  sourceName={null}
  sinkName={null} />

### When to use

- You need to batch data to optimize throughput and reduce the downstream
  request rate.
- You want to perform operations across multiple hosts, such as aggregating
  data in a global context.
- Vector is a stream consumer, continually pulling data from services like
  Kafka, Kinesis, or SQS.
- You are receiving data from other upstream Vector instances via the
  [`vector` sink][docs.sinks.vector].

### When NOT to use

- Your downstream services support streaming where each individual host can
  write data directly to the services.
- You do not need to perform operations across multiple hosts.

[docs.sinks.vector]: /docs/reference/sinks/vector/
[docs.sources.file]: /docs/reference/sources/file/
[docs.sources.journald]: /docs/reference/sources/journald/
[docs.sources]: /docs/reference/sources/
[docs.strategies#daemon]: /docs/setup/deployment/strategies/#daemon
[docs.strategies#service]: /docs/setup/deployment/strategies/#service
[docs.strategies#sidecar]: /docs/setup/deployment/strategies/#sidecar
[docs.topologies]: /docs/setup/deployment/topologies/
