package metadata

releases: "0.10.0": {
	date:     "2020-07-23"
	codename: "Lamport Clock"

	whats_next: [
		{
			title:       "Kubernetes! ⎈"
			description: "We're doing this integration right. We've been alpha testing with a number of large clusters and we've honed in on a very high-quality approach that reflects the UX Vector is going after. You can learn more in our [Kubernetes Integration RFC][urls.pr_2222]. Do you want to beta test? [Tell us!][urls.vector_chat]"
		},
		{
			title:       "WASM plugins 🔌"
			description: "This release included an experimental implementation of a WASM transform behind a `wasm` build flag. We plan to stabilize WASM transforms, as well as add [WASM][urls.wasm] sinks and sources, enabling you to extend Vector in the language of your choice with little performance penalty. ❤️ WASM. Check out the [WASM Plugin RFC][urls.pr_2341] for more info."
		},
		{
			title:       "Dynamic HTTP Rate-Limiting (AIMD)"
			description: "Fiddling with rate-limits is a frustrating endaevor. If you set them too high you risk overwhelming the service; too low and you're unecessarily limiting throughput. What happens if you deploy a few more Vector instances? Vector is planning to solve this by automatically detecting the optimal rate limits, taking inspiration from TCP congestional control algorithms. Check out the [Dynamic HTTP Rate Limiting RFC][urls.pr_2329]."
		},
	]

	commits: [
		{sha: "591114c96e8c6e4d0470c5419f77c6faf2524ade", date: "2020-04-21 19:50:49 +0000", description: "Add `sourcetype`", pr_number:                                                                  2318, scopes: ["splunk_hec sink"], type:                            "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   45, deletions_count:    0},
		{sha: "020ee000b0b21d9d56fbc2b81b2fbb43b4c780e9", date: "2020-04-21 16:28:51 +0000", description: "Remove `proptest` dep", pr_number:                                                             2379, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Lucio Franco", files_count:            2, insertions_count:   0, deletions_count:     58},
		{sha: "639a21d07fe049735b174bc96cd78fae5b995a23", date: "2020-04-21 14:49:20 +0000", description: "New `generator` source", pr_number:                                                            2286, scopes: ["new source"], type:                                 "feat", breaking_change:        false, author: "Bruce Guenter", files_count:           17, insertions_count:  546, deletions_count:   6},
		{sha: "4c8d5a1921815a9efac9f9d40f97fb9c4a44e437", date: "2020-04-21 16:57:51 +0000", description: "Bump cargo.toml version to `0.10.0`", pr_number:                                               2386, scopes: [], type:                                             "chore", breaking_change:       false, author: "Lucio Franco", files_count:            2, insertions_count:   2, deletions_count:     2},
		{sha: "397a20d6dcf413ad66c248a8427c580f30e2a783", date: "2020-04-21 16:03:39 +0000", description: "carve a seam around leveldb", pr_number:                                                       2363, scopes: ["buffers"], type:                                    "chore", breaking_change:       false, author: "Luke Steensen", files_count:           3, insertions_count:   172, deletions_count:   109},
		{sha: "5ad6db51805e1225a6ecf3dfed4ce13a63ab587b", date: "2020-04-21 17:29:31 +0000", description: "Correct timer example errors", pr_number:                                                      2391, scopes: ["lua transform"], type:                              "docs", breaking_change:        false, author: "Binary Logic", files_count:            11, insertions_count:  139, deletions_count:   183},
		{sha: "bcf1bfd2ea371d4414f9762790b22efcd1fc00b9", date: "2020-04-21 22:05:58 +0000", description: "Add authentication section", pr_number:                                                        2399, scopes: ["gcp provider"], type:                               "docs", breaking_change:        false, author: "Binary Logic", files_count:            5, insertions_count:   72, deletions_count:    14},
		{sha: "21ff9b55f6a9298889bb8b0c4f440282f1fb9197", date: "2020-04-22 17:21:29 +0000", description: "Upgrade `service` and `retries` in sink util", pr_number:                                      2362, scopes: ["networking"], type:                                 "chore", breaking_change:       false, author: "Lucio Franco", files_count:            7, insertions_count:   598, deletions_count:   125},
		{sha: "632f62c61defb7970b5d29dc11050a595e8848b2", date: "2020-04-22 17:59:33 +0000", description: "Schema Guide", pr_number:                                                                      1745, scopes: ["config"], type:                                     "docs", breaking_change:        false, author: "Ana Hobden", files_count:              3, insertions_count:   683, deletions_count:   0},
		{sha: "14c9ae89bd6204ceb952f871e380507d06792f86", date: "2020-04-23 15:27:51 +0000", description: "Upgrade rustc 1.43.0", pr_number:                                                              2422, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Lucio Franco", files_count:            1, insertions_count:   1, deletions_count:     1},
		{sha: "e20ed1d5b9638cef0eb6392d0c485b20a0b312cb", date: "2020-04-24 12:08:18 +0000", description: "Cancel previous builds automatically", pr_number:                                              2442, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            4, insertions_count:   19, deletions_count:    3},
		{sha: "55d8c9f1dabf75ce7b198ef26761d0707d4b2b6b", date: "2020-04-24 16:34:38 +0000", description: "Optimize CI test workflow with slim builds", pr_number:                                        2440, scopes: ["operations"], type:                                 "feat", breaking_change:        false, author: "Binary Logic", files_count:            3, insertions_count:   147, deletions_count:   89},
		{sha: "86d8f7f68bd55b30f817a938e8511ae35642906a", date: "2020-04-26 14:38:17 +0000", description: "Stylize tests/Makefile", pr_number:                                                            2450, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            1, insertions_count:   90, deletions_count:    80},
		{sha: "2593a8a627985c9a78daa99d75f53ab4b43395e7", date: "2020-04-26 14:49:47 +0000", description: "Use specific target names in Makefile", pr_number:                                             2451, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            2, insertions_count:   645, deletions_count:   621},
		{sha: "509567996e2fb0b0454fb7b317785065db4fcc97", date: "2020-04-26 15:17:34 +0000", description: "Allow the invocation of local script from the tests/Makefile", pr_number:                      2452, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            3, insertions_count:   59, deletions_count:    5},
		{sha: "980798ab0a94fe58097930d1d6060fe762261b17", date: "2020-04-26 18:24:35 +0000", description: "Point CI GHA workflow to tests/Makefile", pr_number:                                           2453, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            18, insertions_count:  377, deletions_count:   198},
		{sha: "c2d947b60aa3990ba9a3d9dcb84707f7d39a693c", date: "2020-04-26 19:30:15 +0000", description: "Add missing loki integration test", pr_number:                                                 2457, scopes: [], type:                                             "chore", breaking_change:       false, author: "Binary Logic", files_count:            4, insertions_count:   23, deletions_count:    0},
		{sha: "ce7699a34078355ee54bccbea1aba039545c5147", date: "2020-04-26 20:34:58 +0000", description: "Add aws-integration-tests & gcp-integration-tests feature", pr_number:                         2458, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            10, insertions_count:  23, deletions_count:    26},
		{sha: "874f36d2d6dec52d74b43818d144393e678d7a0f", date: "2020-04-26 23:57:56 +0000", description: "Point nightly GHA workflow to tests/Makefile", pr_number:                                      2456, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            5, insertions_count:   224, deletions_count:   127},
		{sha: "0ff1bf36f313e9a0498b2e6a95d7860e918d886e", date: "2020-04-27 01:14:25 +0000", description: "Remove old kubernetes tests", pr_number:                                                       2462, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Binary Logic", files_count:            3, insertions_count:   1, deletions_count:     155},
		{sha: "a38ca109ded52378f89c25d61673ad2af1fd767a", date: "2020-04-27 08:52:11 +0000", description: "Move /tests/Makefile to /Makefile", pr_number:                                                 2460, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            11, insertions_count:  279, deletions_count:   444},
		{sha: "cd1d3b752b0d7abdecfa0e77b59dc33150a18908", date: "2020-04-27 11:26:42 +0000", description: "Ignore `RUSTSEC-2020-0014`", pr_number:                                                        2465, scopes: ["security"], type:                                   "chore", breaking_change:       false, author: "Lucio Franco", files_count:            1, insertions_count:   2, deletions_count:     0},
		{sha: "65d3973ecec71343f03038d5b23acf64dcc07f25", date: "2020-04-27 11:54:00 +0000", description: "Add rpm builds to nightly workflow", pr_number:                                                2463, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            1, insertions_count:   47, deletions_count:    0},
		{sha: "5d40749dc25fcf4b62e8dc30dc9e3bd0865ced6a", date: "2020-04-27 12:40:03 +0000", description: "Upgrade `snafu` to `0.6`", pr_number:                                                          2466, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Lucio Franco", files_count:            2, insertions_count:   11, deletions_count:    19},
		{sha: "03c1947e025fbe01aec1d85071520087a29e0bc7", date: "2020-04-27 14:14:18 +0000", description: "Fix unit test failure in CI", pr_number:                                                       2470, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            1, insertions_count:   1, deletions_count:     1},
		{sha: "0f3c187af8656e47cbc228ab2db52683248cae25", date: "2020-04-27 22:21:38 +0000", description: "Fix typo at nightly CI workflow", pr_number:                                                   2472, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   3, deletions_count:     3},
		{sha: "a8b631eecdb0b73942b1880a6322787a8c838b1c", date: "2020-04-27 14:59:45 +0000", description: "add new isolated buffer benchmarks", pr_number:                                                2447, scopes: ["buffers"], type:                                    "chore", breaking_change:       false, author: "Luke Steensen", files_count:           3, insertions_count:   209, deletions_count:   5},
		{sha: "f3a5814a97f9cca746bc845709372659a7739d72", date: "2020-04-27 22:28:48 +0000", description: "Fix nightly builds", pr_number:                                                                2471, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            8, insertions_count:   258, deletions_count:   158},
		{sha: "d0d2d53f55bae6800fa200d4e567d25f11b0e80e", date: "2020-04-28 13:47:20 +0000", description: "add profiling instructions", pr_number:                                                        2416, scopes: [], type:                                             "docs", breaking_change:        false, author: "Luke Steensen", files_count:           1, insertions_count:   77, deletions_count:    0},
		{sha: "c39b89fe13b23b9f7698b8fb774376b2720feffc", date: "2020-04-28 13:43:08 +0000", description: "Encoding config accessor visibility reduction", pr_number:                                     2153, scopes: [], type:                                             "chore", breaking_change:       false, author: "Ana Hobden", files_count:              17, insertions_count:  411, deletions_count:   354},
		{sha: "6b44597fa84ea4efe5835837f445cd9cae0e386f", date: "2020-04-29 15:25:17 +0000", description: "Fix local unit test execution", pr_number:                                                     2490, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Matthias", files_count:                1, insertions_count:   5, deletions_count:     1},
		{sha: "338c83d091452804206e141a0001757ad1db8b78", date: "2020-04-29 16:53:09 +0000", description: "Fix some typos in contribution documentation", pr_number:                                      2494, scopes: [], type:                                             "docs", breaking_change:        false, author: "Matthias", files_count:                1, insertions_count:   10, deletions_count:    11},
		{sha: "89edb5acc50a13dccbd985dce33dcfab51c8556a", date: "2020-04-29 11:46:53 +0000", description: "Update `request.retry_limit` default to 18446744073709551615", pr_number:                      2498, scopes: [], type:                                             "docs", breaking_change:        false, author: "Binary Logic", files_count:            66, insertions_count:  346, deletions_count:   285},
		{sha: "fa371f5c3a4835f5169eb380e5dec290b718682a", date: "2020-04-29 20:35:37 +0000", description: "Prevent docker from creating directories and files as root", pr_number:                        2486, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 6, insertions_count:   85, deletions_count:    15},
		{sha: "58a551d5487e871b4116610330f4afa471c0a3f4", date: "2020-04-29 12:40:52 +0000", description: "Add `overwrite` option", pr_number:                                                            2485, scopes: ["add_fields transform", "add_tags transform"], type: "chore", breaking_change:       false, author: "Ana Hobden", files_count:              9, insertions_count:   177, deletions_count:   21},
		{sha: "3905c2803f9c409d751f98bc28653fa228df3b01", date: "2020-04-30 11:36:12 +0000", description: "Finish git merge", pr_number:                                                                  2502, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      2, insertions_count:   0, deletions_count:     8},
		{sha: "0903f68eb6a96dcf164ef55dddccb20f8f14d0df", date: "2020-04-30 10:14:10 +0000", description: "Fix batch options", pr_number:                                                                 2397, scopes: ["aws_cloudwatch_logs sink"], type:                   "docs", breaking_change:        false, author: "Lucio Franco", files_count:            4, insertions_count:   17, deletions_count:    17},
		{sha: "cfc418e69476e383c8786c3de8191a5a7eaeb732", date: "2020-04-30 12:27:19 +0000", description: "Temporarily remove Kubernetes components to clear the way for the new integration", pr_number: 2488, scopes: [], type:                                             "chore", breaking_change:       false, author: "Binary Logic", files_count:            15, insertions_count:  1, deletions_count:     3599},
		{sha: "ed8abcd2dbf17b95cb015a345d4bbe46af33e0ba", date: "2020-04-30 10:41:14 +0000", description: "RFC #1858 - 2020-04-06 - Automatic rate limit adjustment", pr_number:                          2329, scopes: [], type:                                             "chore", breaking_change:       false, author: "Bruce Guenter", files_count:           1, insertions_count:   327, deletions_count:   0},
		{sha: "fb489a72543b986dcb5a9420581ed3d203eaecb0", date: "2020-04-30 13:41:06 +0000", description: "Kubernetes Integration RFC", pr_number:                                                        2222, scopes: [], type:                                             "chore", breaking_change:       false, author: "Binary Logic", files_count:            4, insertions_count:   4429, deletions_count:  0},
		{sha: "0d4d6b6e0579e5562591b06193aaae1ea41caf13", date: "2020-05-01 18:35:38 +0000", description: "Add retries to the verification of the release artifacts", pr_number:                          2509, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Alexander Rodin", files_count:         2, insertions_count:   35, deletions_count:    9},
		{sha: "9fd3831ef66bd28c8a794507b346ed832c9b5aa6", date: "2020-05-01 19:34:40 +0000", description: "RPM build fix", pr_number:                                                                     2522, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 2, insertions_count:   32, deletions_count:    14},
		{sha: "7d33ddc9ee4e59da09c847f3c5492609e4e50354", date: "2020-05-01 20:20:30 +0000", description: "do not create /LICENSE and /README.md at RPM package", pr_number:                              2524, scopes: ["rpm platform"], type:                               "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   2, deletions_count:     4},
		{sha: "e01fc0b69c335efb426aaee30dc9bec442c99ea2", date: "2020-05-01 20:54:20 +0000", description: "Dynamically derive the list of paths to create at target", pr_number:                          2525, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   1, deletions_count:     22},
		{sha: "8d1f6205e1b262d6111b1d27df0c1f95fe7b6563", date: "2020-05-01 14:12:17 +0000", description: "Run entire healthcheck lazily", pr_number:                                                     2501, scopes: ["kafka sink"], type:                                 "fix", breaking_change:         false, author: "Lucio Franco", files_count:            1, insertions_count:   3, deletions_count:     1},
		{sha: "2937c46e0f8f061c120a8c21840cc3101434266c", date: "2020-05-01 14:12:35 +0000", description: "Properly detect shutdown", pr_number:                                                          2429, scopes: ["socket sink"], type:                                "fix", breaking_change:         false, author: "Lucio Franco", files_count:            3, insertions_count:   142, deletions_count:   6},
		{sha: "105ab797c02e0b6787fd56667d020beb80df3e88", date: "2020-05-01 14:37:02 +0000", description: "Align Github Actions workflows with the files changed", pr_number:                             2517, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            7, insertions_count:   130, deletions_count:   99},
		{sha: "4b0da62cdd66a464ba9479f012cda2f4f16e2a9f", date: "2020-05-03 22:43:00 +0000", description: "replace OrigID with OrgID", pr_number:                                                         2536, scopes: ["loki sink"], type:                                  "fix", breaking_change:         false, author: "Alexandre NICOLAIE", files_count:      1, insertions_count:   1, deletions_count:     1},
		{sha: "1fc8869ac1f58f20ef3b53186bfb1ae4f5506383", date: "2020-05-04 22:46:16 +0000", description: "Iterate over target dirs to avoid missing mapall command on macOS", pr_number:                 2539, scopes: ["operations"], type:                                 "fix", breaking_change:         false, author: "Matthias", files_count:                1, insertions_count:   10, deletions_count:    6},
		{sha: "e888f3b12f21d5d7d7c50f8bde893950ca631105", date: "2020-05-04 23:33:17 +0000", description: "Shutdown Vector if all sources finish", pr_number:                                             2533, scopes: ["topology"], type:                                   "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:      4, insertions_count:   70, deletions_count:    6},
		{sha: "d187a7b4cf6989b5aa1a251a1c9f736c44983675", date: "2020-05-04 16:43:21 +0000", description: "add batching to disk buffer reads", pr_number:                                                 2481, scopes: ["buffers"], type:                                    "perf", breaking_change:        false, author: "Luke Steensen", files_count:           1, insertions_count:   16, deletions_count:    9},
		{sha: "ec2ec165b95b3022ca4615fb2eb29b5953ad1a29", date: "2020-05-04 16:26:33 +0000", description: "Add support for negating conditions in check_fields", pr_number:                               2514, scopes: ["filter transform", "swimlanes transform"], type:    "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:           6, insertions_count:   161, deletions_count:   4},
		{sha: "a9090b6bc5a8bcd4ce2928eb588e3b1da8e8e9ba", date: "2020-05-05 11:01:46 +0000", description: "Upgrade deny action", pr_number:                                                               2544, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Lucio Franco", files_count:            1, insertions_count:   1, deletions_count:     1},
		{sha: "b5c6bbe5700be1084c32b84d58a1a63f21ce816b", date: "2020-05-05 11:20:28 +0000", description: "Fix rustfmt", pr_number:                                                                       2545, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Lucio Franco", files_count:            1, insertions_count:   2, deletions_count:     0},
		{sha: "61c03b65118359e1fd729a0e23f5925c5306f87b", date: "2020-05-05 09:32:16 +0000", description: "Add explicit AWS region", pr_number:                                                           2532, scopes: ["elasticsearch sink"], type:                         "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:           5, insertions_count:   134, deletions_count:   21},
		{sha: "4089b39a6c06b54a2d62d141d70230ed140e9b83", date: "2020-05-05 15:10:39 +0000", description: "Upgrade openssl to `1.1.1g`", pr_number:                                                       2546, scopes: ["security"], type:                                   "chore", breaking_change:       false, author: "Lucio Franco", files_count:            1, insertions_count:   4, deletions_count:     4},
		{sha: "70085092e04cf35315375cf1083c363f8677ca9e", date: "2020-05-05 15:57:40 +0000", description: "Disable `check-version` check", pr_number:                                                     2548, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Lucio Franco", files_count:            1, insertions_count:   6, deletions_count:     5},
		{sha: "3e4360a2db28b1837e49933e3a6a23b29f97b136", date: "2020-05-05 23:32:12 +0000", description: "Add shellcheck to CI and correct scripts", pr_number:                                          2482, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 49, insertions_count:  419, deletions_count:   360},
		{sha: "a084309ba69e09e415dbb2eccdbcddd03438c9b8", date: "2020-05-06 02:00:58 +0000", description: "Remove the .github/workflows/install-script.yml", pr_number:                                   2549, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   0, deletions_count:     17},
		{sha: "a61ab97208c5b40c4cc242ac69d395e11b263838", date: "2020-05-05 17:32:16 +0000", description: "Add support for include/exclude units", pr_number:                                             2540, scopes: ["journald source"], type:                            "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:           4, insertions_count:   195, deletions_count:   58},
		{sha: "746792f79f64316214de9fee8d7ba6dfaf6f6cae", date: "2020-05-06 10:18:04 +0000", description: "Wire `ShutdownSignal`", pr_number:                                                             2366, scopes: ["stdin source"], type:                               "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   111, deletions_count:   40},
		{sha: "505b688fa0c596d77e8de5c870894f399b818c51", date: "2020-05-06 12:24:51 +0000", description: "Use post requests", pr_number:                                                                 2547, scopes: ["datadog_metrics sink"], type:                       "fix", breaking_change:         false, author: "Lucio Franco", files_count:            1, insertions_count:   67, deletions_count:    10},
		{sha: "4026a74c7a7bfb1986c8bcb5d13600c937715290", date: "2020-05-06 16:09:56 +0000", description: "Upgrade internal rusoto utilities", pr_number:                                                 2555, scopes: ["sinks"], type:                                      "chore", breaking_change:       false, author: "Lucio Franco", files_count:            3, insertions_count:   292, deletions_count:   2},
		{sha: "a2681967063bedfe5eb9f0754b7e197ad14bc885", date: "2020-05-07 15:21:57 +0000", description: "Kubernetes test procedure", pr_number:                                                         2487, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 9, insertions_count:   315, deletions_count:   8},
		{sha: "3a2b5264eaaebf18edb50a4f8a05b59d91ec7aff", date: "2020-05-07 16:00:08 +0000", description: "Upgrade to rustc `1.43.1`", pr_number:                                                         2563, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Lucio Franco", files_count:            1, insertions_count:   1, deletions_count:     1},
		{sha: "234045737b7e695984a7128a3f6afa1e81f120f6", date: "2020-05-11 17:42:16 +0000", description: "Set minimal supported Kubernetes version", pr_number:                                          2510, scopes: [], type:                                             "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   7, deletions_count:     0},
		{sha: "2bb9384585dc7b75b77ec08e594e9fa1b742b99b", date: "2020-05-11 19:22:08 +0000", description: "Send time in <sec>.<ms> format", pr_number:                                                    2570, scopes: ["splunk_hec sink"], type:                            "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:         2, insertions_count:   54, deletions_count:    24},
		{sha: "bda112212cc31cf4ee00788d8199158c78a413d3", date: "2020-05-11 19:24:19 +0000", description: "Improve check-advisories CI job", pr_number:                                                   2571, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         2, insertions_count:   1, deletions_count:     2},
		{sha: "184ee0cc29a9870d8cef7d5158293299833242c7", date: "2020-05-11 20:57:38 +0000", description: "Force disable k8s tests in CI", pr_number:                                                     2574, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   2, deletions_count:     1},
		{sha: "c35a0e9c8d31bd77cd8850523c5486ce48535f40", date: "2020-05-11 17:09:12 +0000", description: "Add `BatchedHttpSink` back to `http2`", pr_number:                                             2573, scopes: ["sinks"], type:                                      "chore", breaking_change:       false, author: "Lucio Franco", files_count:            1, insertions_count:   138, deletions_count:   1},
		{sha: "a43aaaae839bd4c4b6ba0e5e83da3a32793872fd", date: "2020-05-11 19:51:08 +0000", description: "Upgrade `clickhouse`", pr_number:                                                              2578, scopes: ["clickhouse sink"], type:                            "chore", breaking_change:       false, author: "Lucio Franco", files_count:            2, insertions_count:   34, deletions_count:    31},
		{sha: "8d2a54f71b3ef6004c2902e55530f9eb58c8ea3f", date: "2020-05-12 17:27:49 +0000", description: "Copying docker images directly to minikube VMs", pr_number:                                    2575, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 3, insertions_count:   76, deletions_count:    11},
		{sha: "1b732b42b159930bb0d3db5d7df1337596768fdc", date: "2020-05-12 15:31:08 +0000", description: "remove superfluous warning", pr_number:                                                        2583, scopes: ["humio_logs sink"], type:                            "fix", breaking_change:         false, author: "Luke Steensen", files_count:           1, insertions_count:   0, deletions_count:     3},
		{sha: "4392307dee63d0d6852d8ed13bd68b87a5b0898d", date: "2020-05-12 16:00:10 +0000", description: "remove unused import", pr_number:                                                              2582, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Luke Steensen", files_count:           1, insertions_count:   1, deletions_count:     1},
		{sha: "9fa5847b281a94d1b0c4e1b6031674f9fa9b0d6a", date: "2020-05-12 20:44:36 +0000", description: "remove id key from body", pr_number:                                                           2581, scopes: ["elasticsearch sink"], type:                         "fix", breaking_change:         false, author: "Luke Steensen", files_count:           3, insertions_count:   17, deletions_count:    14},
		{sha: "2c8a818aec48d3eab662a24245e006e157b7643a", date: "2020-05-13 08:34:58 +0000", description: "Fix `units`/`include_units` switch ", pr_number:                                               2567, scopes: ["journald source"], type:                            "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   3, deletions_count:     3},
		{sha: "0e878251716da1434e32320a835b3d3763f580fb", date: "2020-05-13 08:50:10 +0000", description: "Test `vector` shutdown", pr_number:                                                            2558, scopes: ["topology"], type:                                   "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      13, insertions_count:  497, deletions_count:   24},
		{sha: "a61e0d5e947b9ee85b8778bb362c220146705777", date: "2020-05-13 11:29:53 +0000", description: "Mark GeneratorConfig::repeat with #[allow(dead_code)]", pr_number:                             2586, scopes: [], type:                                             "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   1, deletions_count:     0},
		{sha: "aa67dfe65e33bbf8e686add0ee0a5645a5f13f0f", date: "2020-05-13 13:03:10 +0000", description: "Update shutdown deadlines", pr_number:                                                         2534, scopes: ["topology"], type:                                   "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   11, deletions_count:    12},
		{sha: "6858984ca4fb107ee05eaa9bd008747514f6b4de", date: "2020-05-13 13:53:40 +0000", description: "Use `localhost` for `prometheus` shutdown test", pr_number:                                    2589, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   7, deletions_count:     2},
		{sha: "b26a0e984aa5955743c1c0d6cd53c383a58534d3", date: "2020-05-13 18:10:10 +0000", description: "Generalize file server around paths provider", pr_number:                                      2541, scopes: [], type:                                             "chore", breaking_change:       false, author: "MOZGIII", files_count:                 6, insertions_count:   168, deletions_count:   89},
		{sha: "c4e6de5b4cffc4aeee6c8c5cd4129fd110a0fc20", date: "2020-05-13 09:59:26 +0000", description: "Fix possible infinite loop decoding too-long lines", pr_number:                                2587, scopes: ["socket sink"], type:                                "fix", breaking_change:         false, author: "Bruce Guenter", files_count:           2, insertions_count:   45, deletions_count:    28},
		{sha: "0cdc500049ac6f587767105ce60bbc9a30458305", date: "2020-05-13 21:50:14 +0000", description: "Add RegexSet support to regex", pr_number:                                                     2493, scopes: ["regex_parser transform"], type:                     "enhancement", breaking_change: false, author: "Matthias", files_count:                8, insertions_count:   161, deletions_count:   55},
		{sha: "d93eea0e37af25f5a650f9497f2c636d6228efff", date: "2020-05-13 23:07:42 +0000", description: "Fix default values for buffer", pr_number:                                                     2590, scopes: ["config"], type:                                     "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         1, insertions_count:   62, deletions_count:    2},
		{sha: "3f0012e789b0b9a00d5c3a9c6994110cef64dbef", date: "2020-05-13 16:13:53 +0000", description: "Allow removed keys to be used for partitioning", pr_number:                                    2591, scopes: ["aws_s3 sink"], type:                                "fix", breaking_change:         false, author: "Lucio Franco", files_count:            1, insertions_count:   25, deletions_count:    1},
		{sha: "484ba4cda42db38330698eacd05c781e212861d6", date: "2020-05-13 18:38:34 +0000", description: "log parse errors as warnings", pr_number:                                                      2593, scopes: ["json_parser transform"], type:                      "enhancement", breaking_change: false, author: "Luke Steensen", files_count:           1, insertions_count:   1, deletions_count:     1},
		{sha: "97b589ab5f54393c1919cf644fad814ab705325b", date: "2020-05-14 03:32:32 +0000", description: "Mute k8s tests", pr_number:                                                                    2594, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   3, deletions_count:     0},
		{sha: "0a0f8d5b6478237d7402ca9e356c9ff4ea6f8497", date: "2020-05-14 16:36:00 +0000", description: "Fix newline for check-fmt", pr_number:                                                         2602, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         1, insertions_count:   1, deletions_count:     1},
		{sha: "c02a0f77d328e1d4fee02095a2f1abfb4c3c09a7", date: "2020-05-14 15:25:22 +0000", description: "Add support for templates in the topic config", pr_number:                                     2598, scopes: ["kafka sink"], type:                                 "feat", breaking_change:        false, author: "Bruce Guenter", files_count:           4, insertions_count:   25, deletions_count:    8},
		{sha: "c39377cebd7809c25940d2578f49571735ac4aae", date: "2020-05-15 18:13:38 +0000", description: "Error on auth section and Auth header", pr_number:                                             2611, scopes: ["http sink"], type:                                  "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         1, insertions_count:   34, deletions_count:    4},
		{sha: "43af8d01f6c966a65c35f12b2ef7d309ecb4c326", date: "2020-05-15 14:02:07 +0000", description: "Enable tls by default", pr_number:                                                             2527, scopes: ["datadog_logs sink"], type:                          "fix", breaking_change:         false, author: "Lucio Franco", files_count:            1, insertions_count:   13, deletions_count:    15},
		{sha: "1eaee144b7be0da821c172486f3079f8e5e7c5a4", date: "2020-05-15 12:13:04 +0000", description: "Fixup loki tests", pr_number:                                                                  2613, scopes: ["tests"], type:                                      "fix", breaking_change:         false, author: "Ana Hobden", files_count:              3, insertions_count:   3, deletions_count:     3},
		{sha: "e5e5b06c7ec80905302b73407f1255a9aac4a5ea", date: "2020-05-18 17:53:45 +0000", description: "Fix invalid link in JSON Parser transform", pr_number:                                         2624, scopes: [], type:                                             "docs", breaking_change:        false, author: "Kirill Fomichev", files_count:         2, insertions_count:   3, deletions_count:     5},
		{sha: "f758963ad28a698a35d772ea8d0cea3d9c2ef46c", date: "2020-05-18 19:17:37 +0000", description: "Build archives, DEB, and RPM packages with glibc", pr_number:                                  2518, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Alexander Rodin", files_count:         13, insertions_count:  136, deletions_count:   74},
		{sha: "6281932469d9bcef34edaf672b52edc804d49732", date: "2020-05-19 11:16:28 +0000", description: "Remove race between sink and source", pr_number:                                               2619, scopes: ["tests"], type:                                      "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:      2, insertions_count:   45, deletions_count:    18},
		{sha: "b2eaa5673caa2cead25e47b1c0536b6894433077", date: "2020-05-20 00:55:27 +0000", description: "Replace http:// to https://", pr_number:                                                       2646, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         45, insertions_count:  88, deletions_count:    88},
		{sha: "6d420f852e959f822c60c09b5466317d3438f62d", date: "2020-05-20 19:04:10 +0000", description: "Fix the bug with channel closing at file server", pr_number:                                   2652, scopes: ["file source"], type:                                "fix", breaking_change:         false, author: "MOZGIII", files_count:                 3, insertions_count:   31, deletions_count:    17},
		{sha: "741690a7e8dc50f9aecf5fe451d1a1fa4b0046c0", date: "2020-05-20 23:25:10 +0000", description: "Instrument few more components with metrics", pr_number:                                       2620, scopes: ["internal_metrics source"], type:                    "feat", breaking_change:        false, author: "Alex", files_count:                    9, insertions_count:   158, deletions_count:   9},
		{sha: "6a4ac1723b845c083d33cfe6eb683c6e7531ffee", date: "2020-05-20 15:03:19 +0000", description: "Fix the Kafka TLS key parameter handling", pr_number:                                          2658, scopes: ["kafka sink", "kafa source"], type:                  "fix", breaking_change:         false, author: "Bruce Guenter", files_count:           2, insertions_count:   22, deletions_count:    2},
		{sha: "9f9ec375f5f4a2947041f9c3528f13ab17ac1e2b", date: "2020-05-20 17:23:53 +0000", description: "add bearer auth strategy", pr_number:                                                          2607, scopes: ["http sink"], type:                                  "enhancement", breaking_change: false, author: "Luke Steensen", files_count:           9, insertions_count:   149, deletions_count:   14},
		{sha: "4a5c201428e20e4ab3aed7f88e7e124124a64719", date: "2020-05-21 01:42:38 +0000", description: "Check if `transform`/`sink` is present", pr_number:                                            2617, scopes: ["topology"], type:                                   "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   110, deletions_count:   13},
		{sha: "5d993333eb67bc05996cf6d77e94296a27bc537e", date: "2020-05-21 17:46:21 +0000", description: "Add uint type", pr_number:                                                                     2659, scopes: [], type:                                             "docs", breaking_change:        false, author: "Kirill Fomichev", files_count:         67, insertions_count:  586, deletions_count:   585},
		{sha: "1d8e88057f68d9cf9292ddc9edb69a7f8d3b3f92", date: "2020-05-22 02:13:16 +0000", description: "Debug package-deb", pr_number:                                                                 2665, scopes: ["dpkg platform"], type:                              "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   1, deletions_count:     0},
		{sha: "e0761a9681da6b7e8cb69c750c41a7be89d24fed", date: "2020-05-24 20:28:28 +0000", description: "Shutdown starting from `tcp` and `unix` sockets ", pr_number:                                  2618, scopes: ["sources"], type:                                    "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:      10, insertions_count:  366, deletions_count:   101},
		{sha: "2a4181c6c65ad1606d31c5fe9408964656a3bc7e", date: "2020-05-25 16:53:32 +0000", description: "Improve compression option", pr_number:                                                        2637, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         33, insertions_count:  315, deletions_count:   271},
		{sha: "54ab97f632b0054e464426c9a088d492dec8d0ec", date: "2020-05-25 07:37:03 +0000", description: "Rate limit TCP connection errors, downgrade their severity", pr_number:                        2669, scopes: ["vector source"], type:                              "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   1, deletions_count:     1},
		{sha: "fcff9e8989ef8c1f7ed69fad6fee23d4cb9d4d31", date: "2020-05-25 16:41:17 +0000", description: "Avoid hanging on timers", pr_number:                                                           2672, scopes: ["lua transform"], type:                              "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      5, insertions_count:   120, deletions_count:   4},
		{sha: "b88207cbb5d333e418fdcbe42e9a0bb1e390c6ab", date: "2020-05-25 16:44:56 +0000", description: "Initial `influxdb_logs` sink implementation", pr_number:                                       2474, scopes: ["new sink"], type:                                   "feat", breaking_change:        false, author: "Jakub Bednář", files_count:            41, insertions_count:  5582, deletions_count:  1447},
		{sha: "5904a3e2e6011b1bc616ef236528d3c320f04a3a", date: "2020-05-25 20:09:38 +0000", description: "Fix buffer compression", pr_number:                                                            2679, scopes: ["influxdb_logs sink"], type:                         "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:         1, insertions_count:   10, deletions_count:    3},
		{sha: "77002bbacde7562bc78843eb3a831e3ed5a657eb", date: "2020-05-26 02:37:36 +0000", description: "Display free space at package deb task", pr_number:                                            2686, scopes: ["dpkg platform"], type:                              "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   3, deletions_count:     0},
		{sha: "b0746e5f8d304bcc23a0b2121239e68263da667f", date: "2020-05-26 13:36:27 +0000", description: "bump activesupport from 6.0.2.1 to 6.0.3.1 in /scripts", pr_number:                            2689, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot[bot]", files_count:         1, insertions_count:   7, deletions_count:     7},
		{sha: "ad5575a94a8dbf4a0c0f408bfe4b9160450818ef", date: "2020-05-27 20:39:29 +0000", description: "Upgrade `HttpSink` based sinks", pr_number:                                                    2688, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         20, insertions_count:  324, deletions_count:   300},
		{sha: "c4787acb8846f2492c1a0f923ea4acc0823112d2", date: "2020-05-27 11:58:19 +0000", description: "Add support for loading multiple CAs", pr_number:                                              2616, scopes: ["security"], type:                                   "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:           7, insertions_count:   286, deletions_count:   73},
		{sha: "29735f052cbea36db06d6db4db137114294ad50c", date: "2020-05-27 14:05:25 +0000", description: "Three KafkaCompression typos in tests", pr_number:                                             2694, scopes: ["kafka sink"], type:                                 "fix", breaking_change:         false, author: "Bruce Guenter", files_count:           1, insertions_count:   3, deletions_count:     3},
		{sha: "92ce87953af8d5f235187b7ee6c8309d4d4d623f", date: "2020-05-28 01:37:43 +0000", description: "Fix default host value", pr_number:                                                            2683, scopes: ["humio_logs sink"], type:                            "docs", breaking_change:        false, author: "Kirill Fomichev", files_count:         3, insertions_count:   5, deletions_count:     5},
		{sha: "a7d760307f6126c8c24a8cd43fe07f46c3fcc637", date: "2020-05-28 17:18:16 +0000", description: "Cleanup the leftovers of the old k8s implementation", pr_number:                               2676, scopes: [], type:                                             "chore", breaking_change:       false, author: "MOZGIII", files_count:                 9, insertions_count:   5, deletions_count:     133},
		{sha: "19dd0a0589faf976c831fd3f9e8d961e3064e47d", date: "2020-05-28 11:16:31 +0000", description: "RFC #2341 - 2020-04-15 - WASM Plugins Support", pr_number:                                     2341, scopes: [], type:                                             "chore", breaking_change:       false, author: "Ana Hobden", files_count:              3, insertions_count:   1388, deletions_count:  0},
		{sha: "cacfb9319adb0d802894b1f187367a18f26d8773", date: "2020-05-28 15:16:54 +0000", description: "Reorder Tower service layers", pr_number:                                                      2703, scopes: [], type:                                             "chore", breaking_change:       false, author: "Bruce Guenter", files_count:           1, insertions_count:   2, deletions_count:     2},
		{sha: "c86d9a095234af0a08d9d2684b2eb9b84cedf3a8", date: "2020-05-29 01:35:55 +0000", description: "A script to install git hooks", pr_number:                                                     2650, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 2, insertions_count:   16, deletions_count:    1},
		{sha: "f6e0eb2eb87fe874d56261d61522fdc2928d8966", date: "2020-05-28 15:52:48 +0000", description: "Add `hostname` and `source_ip`", pr_number:                                                    2663, scopes: ["syslog source"], type:                              "chore", breaking_change:       false, author: "Ana Hobden", files_count:              4, insertions_count:   93, deletions_count:    204},
		{sha: "1fbd2ffd87125390a2441b14bb5efbda6c2e1e92", date: "2020-05-29 08:59:51 +0000", description: "Add dev workflow simplification rfc", pr_number:                                               2685, scopes: ["platforms"], type:                                  "feat", breaking_change:        false, author: "Ana Hobden", files_count:              1, insertions_count:   253, deletions_count:   0},
		{sha: "ce25c9446c7326dd20ebef88089ea59ab98d7b71", date: "2020-05-29 12:49:18 +0000", description: "Update syslog_loose to 0.3.0", pr_number:                                                      2709, scopes: ["syslog source"], type:                              "chore", breaking_change:       false, author: "Ana Hobden", files_count:              3, insertions_count:   6, deletions_count:     6},
		{sha: "8e8339fb8682e49c8b64bd6db1b6a3bfac8100bb", date: "2020-06-02 17:07:03 +0000", description: "Fix data_dir default value in global options", pr_number:                                      2720, scopes: [], type:                                             "docs", breaking_change:        false, author: "Kirill Fomichev", files_count:         3, insertions_count:   9, deletions_count:     6},
		{sha: "94c6bdc7ff2013a17cdd07ca8eff039891c5f028", date: "2020-06-02 18:22:22 +0000", description: "Remove extra slash on Uri join", pr_number:                                                    2711, scopes: ["splunk_hec sink"], type:                            "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:         1, insertions_count:   17, deletions_count:    10},
		{sha: "ac62a2ac65ea6a60cfde3debb312f2528a7f1e0b", date: "2020-06-02 19:02:15 +0000", description: "Use `test_util::runtime()` in tests", pr_number:                                               2715, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      31, insertions_count:  145, deletions_count:   147},
		{sha: "3c3b8021e49a445f0c7d69b2e21b227be65cd075", date: "2020-06-02 19:07:37 +0000", description: "Test with `default` feature in CI", pr_number:                                                 2721, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      6, insertions_count:   46, deletions_count:    3},
		{sha: "1c27da72c959419c36f44ed1aa53a1c1668bc196", date: "2020-06-02 18:21:13 +0000", description: "Fix check-markdown job", pr_number:                                                            2727, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            3, insertions_count:   29, deletions_count:    16},
		{sha: "724e830f2085c58101ad3160dffee3a609f6c7d6", date: "2020-06-02 16:25:15 +0000", description: "Add support for inline TLS keys", pr_number:                                                   2724, scopes: ["networking"], type:                                 "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:           28, insertions_count:  800, deletions_count:   715},
		{sha: "f697d46f5b6b2bd69f42721d4f59e7752e454346", date: "2020-06-02 18:26:54 +0000", description: "Split website workflow into generate and blog", pr_number:                                     2728, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Binary Logic", files_count:            2, insertions_count:   31, deletions_count:    10},
		{sha: "d5e988a1bd402a84d736de3b61594c43a9a646c5", date: "2020-06-03 02:34:52 +0000", description: "Add compression to humio and new_relic", pr_number:                                            2682, scopes: ["humio sink", "new relic sink"], type:               "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:         7, insertions_count:   112, deletions_count:   2},
		{sha: "12480b546614824a06e4415b723923e5e73dd9df", date: "2020-06-04 22:23:06 +0000", description: "Only log `200`-`299` responses as successful", pr_number:                                      2714, scopes: ["sinks"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      8, insertions_count:   52, deletions_count:    15},
		{sha: "35b7e563faca817950dd947803f606f0a4fc4d3e", date: "2020-06-05 19:34:36 +0000", description: "Fix wrong example in tokenizer module (version 0.9.1)", pr_number:                             2716, scopes: [], type:                                             "docs", breaking_change:        false, author: "xluffy", files_count:                  2, insertions_count:   3, deletions_count:     3},
		{sha: "4c77fc18af8db47db6138f149b45b1d4ced4354b", date: "2020-06-05 18:10:49 +0000", description: "Fix integration test", pr_number:                                                              2698, scopes: ["kafka sink"], type:                                 "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         1, insertions_count:   1, deletions_count:     1},
		{sha: "54093b76eb06a077b70c0f1d98b53f5c85cd981b", date: "2020-06-05 11:11:42 +0000", description: "Add new EncodingConfig", pr_number:                                                            2671, scopes: ["pulsar sink"], type:                                "fix", breaking_change:         false, author: "Evan Cameron", files_count:            1, insertions_count:   14, deletions_count:    11},
		{sha: "57c3d91abbf5fc33d4473d7557d5b1248b7620bf", date: "2020-06-07 19:36:18 +0000", description: "Upgrade `hyper`", pr_number:                                                                   2754, scopes: ["prometheus sink"], type:                            "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   25, deletions_count:    19},
		{sha: "88aac3c6daf0480d2a4f03b0957462a2b06cb44a", date: "2020-06-07 21:49:37 +0000", description: "Add into", pr_number:                                                                          2759, scopes: ["pulsar sink"], type:                                "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   1, deletions_count:     1},
		{sha: "0d750f0804beccd59533a5ded16d24be7e9efd77", date: "2020-06-08 00:57:27 +0000", description: "Upgrade `hyper`", pr_number:                                                                   2761, scopes: ["splunk_hec source"], type:                          "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   11, deletions_count:    11},
		{sha: "c56b365d53c161dd499c41f04bd15bb7c08a4d8b", date: "2020-06-08 10:24:23 +0000", description: "Upgrade `hyper`", pr_number:                                                                   2758, scopes: ["gcp_cloud_storage sink"], type:                     "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      3, insertions_count:   106, deletions_count:   39},
		{sha: "ee86731a755abe3c5d119f78dd89bae0eaaca6e8", date: "2020-06-08 17:20:48 +0000", description: "Updade rusoto", pr_number:                                                                     2735, scopes: ["aws_kinesis_firehose sink"], type:                  "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         8, insertions_count:   628, deletions_count:   166},
		{sha: "3d5177cc4dd28df31fc38c39287177cadaa1f9d0", date: "2020-06-08 11:28:25 +0000", description: "increment request id", pr_number:                                                              2765, scopes: ["sinks"], type:                                      "fix", breaking_change:         false, author: "Luke Steensen", files_count:           1, insertions_count:   2, deletions_count:     1},
		{sha: "569c066397d51d6be903fc5a7567c9619b705f9a", date: "2020-06-08 11:07:29 +0000", description: "Handle templates with invalid strftime elements", pr_number:                                   2737, scopes: ["config"], type:                                     "fix", breaking_change:         false, author: "Bruce Guenter", files_count:           12, insertions_count:  183, deletions_count:   92},
		{sha: "654a5addb3808aac7a117b77cafac7785d2dcd3f", date: "2020-06-08 20:26:38 +0000", description: "Make throttling errors retryable", pr_number:                                                  2752, scopes: ["aws_cloudwatch_sink"], type:                        "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:         1, insertions_count:   8, deletions_count:     0},
		{sha: "4ff1774a10a9a4ace5cdb14977d5aeef0bb20ea5", date: "2020-06-08 22:29:51 +0000", description: "Add clippy to CI", pr_number:                                                                  2576, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         15, insertions_count:  130, deletions_count:   3},
		{sha: "d6962ee12e60944be5501409a8b4443b33b694d8", date: "2020-06-09 00:16:30 +0000", description: "Upgrade `hyper`", pr_number:                                                                   2760, scopes: ["influxdb_metrics sink"], type:                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      2, insertions_count:   27, deletions_count:    23},
		{sha: "23ba0dc395c5af4b64babb0e27a308d8b246c85d", date: "2020-06-08 18:17:25 +0000", description: "bump websocket-extensions from 0.1.3 to 0.1.4 in /website", pr_number:                         2756, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot[bot]", files_count:         1, insertions_count:   3, deletions_count:     3},
		{sha: "3163beea3722a8ef765ce90524c330a6f6200988", date: "2020-06-09 12:34:35 +0000", description: "Upgrade `hyper`", pr_number:                                                                   2762, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      8, insertions_count:   115, deletions_count:   131},
		{sha: "6502b1f811d1f35b3694a9cf911681d280491a1c", date: "2020-06-09 18:12:34 +0000", description: "Upgrade `hyper`", pr_number:                                                                   2763, scopes: ["aws_ec2_metadata transform"], type:                 "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   25, deletions_count:    15},
		{sha: "d36c0a42407e1db52022b28dd4fa0d3030f5899a", date: "2020-06-09 18:16:07 +0000", description: "add pipeline config", pr_number:                                                               2734, scopes: ["elasticsearch sink"], type:                         "enhancement", breaking_change: false, author: "francesco palazzini", files_count:     4, insertions_count:   61, deletions_count:    1},
		{sha: "2132d6ee5de752a18c559c2d30f736b412fb8514", date: "2020-06-10 12:25:08 +0000", description: "Consolidate and beautify `validate` ", pr_number:                                              2622, scopes: ["cli"], type:                                        "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:      14, insertions_count:  500, deletions_count:   266},
		{sha: "fd1ddefd4304de3f16542cc871ec8f65f13b2535", date: "2020-06-10 10:44:34 +0000", description: "Drop excessive large events", pr_number:                                                       2770, scopes: ["aws_cloudwatch_logs sink"], type:                   "fix", breaking_change:         false, author: "Bruce Guenter", files_count:           1, insertions_count:   37, deletions_count:    24},
		{sha: "6137b3d82599aa41a653c3bd2c61b8733f8df1ac", date: "2020-06-10 21:30:06 +0000", description: "Convert pipe to variables to debug 141 (broken pipe) error", pr_number:                        2772, scopes: ["dpkg platform"], type:                              "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   5, deletions_count:     4},
		{sha: "5706d2a7076ebee4d10b8d5caf8d90fb68ddda4a", date: "2020-06-11 10:06:49 +0000", description: "Introduce WASM Plugins", pr_number:                                                            2006, scopes: ["new transform"], type:                              "feat", breaking_change:        false, author: "Ana Hobden", files_count:              105, insertions_count: 4214, deletions_count:  58},
		{sha: "d518c29dd244e60c5c2a940670104c4259693d4a", date: "2020-06-11 14:32:59 +0000", description: "upgrade tower-limit to fix rate limiting", pr_number:                                          2779, scopes: ["sinks"], type:                                      "fix", breaking_change:         false, author: "Luke Steensen", files_count:           1, insertions_count:   2, deletions_count:     2},
		{sha: "71f0d07ae0a39940c3c7c0ef90dc55c157343485", date: "2020-06-11 14:54:36 +0000", description: "Introduce Dev Workflow improvements", pr_number:                                               2723, scopes: ["operations"], type:                                 "feat", breaking_change:        false, author: "Ana Hobden", files_count:              46, insertions_count:  1395, deletions_count:  846},
		{sha: "03ca67662342a43d9fb2a83c301464747742ac05", date: "2020-06-12 18:10:59 +0000", description: "Log when components finish normally", pr_number:                                               2801, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   5, deletions_count:     3},
		{sha: "e7e1b39c75992d406cb90cfeafce5bdef8625e3e", date: "2020-06-12 22:17:58 +0000", description: "fix aws integration tests ci", pr_number:                                                      2792, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         4, insertions_count:   35, deletions_count:    33},
		{sha: "a1d8d8de56f3b63d4aae41536d17914792039695", date: "2020-06-13 10:36:01 +0000", description: "tower update", pr_number:                                                                      2805, scopes: ["statsd sink"], type:                                "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         1, insertions_count:   24, deletions_count:    17},
		{sha: "61599531c8b2b7f4f1d9e01bd5126820b87a171a", date: "2020-06-13 10:42:21 +0000", description: "update rusoto to 0.44.0", pr_number:                                                           2806, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         6, insertions_count:   359, deletions_count:   336},
		{sha: "9efa014dd303301640f73fc930ef939a42fdb666", date: "2020-06-13 19:56:02 +0000", description: "Don't finish when timers finish", pr_number:                                                   2809, scopes: ["lua transform"], type:                              "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      2, insertions_count:   40, deletions_count:    4},
		{sha: "c71b5b55ae00ddbd888fbae78c479f261c2e305a", date: "2020-06-14 18:28:03 +0000", description: "Update hyper", pr_number:                                                                      2808, scopes: ["prometheus source"], type:                          "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      5, insertions_count:   32, deletions_count:    23},
		{sha: "1d3fa878a8ac3258cfa3dffe550cb850b6a1e656", date: "2020-06-15 13:17:12 +0000", description: "Update hyper in tests", pr_number:                                                             2817, scopes: ["prometheus source"], type:                          "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   23, deletions_count:    15},
		{sha: "55587bebd915a2a7b80c1fa74a18a63d53f99cd7", date: "2020-06-15 06:44:35 +0000", description: "bump regex from 1.3.5 to 1.3.9", pr_number:                                                    2818, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 2, insertions_count:   5, deletions_count:     5},
		{sha: "151e7584ef8d1ab4eaf7f7a6a4ac843db48b8755", date: "2020-06-15 18:34:39 +0000", description: "update goauth to new futures", pr_number:                                                      2819, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         3, insertions_count:   95, deletions_count:    20},
		{sha: "60d1eea7b096876e995b8326128595fefb398882", date: "2020-06-15 08:44:02 +0000", description: "Note on wasm", pr_number:                                                                      2804, scopes: ["wasm transform"], type:                             "docs", breaking_change:        false, author: "Ana Hobden", files_count:              6, insertions_count:   28, deletions_count:    2},
		{sha: "4ff2772444f21f8b4071e40200e1598616cdbd99", date: "2020-06-15 18:48:34 +0000", description: "improve time validation in tests", pr_number:                                                  2803, scopes: ["humio_logs sink"], type:                            "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         2, insertions_count:   12, deletions_count:    3},
		{sha: "11c29d5ea32108672e329de584bc669f5be8de09", date: "2020-06-15 11:57:36 +0000", description: "Adding list of string as filter option", pr_number:                                            2745, scopes: ["filter transform"], type:                           "feat", breaking_change:        false, author: "Bill", files_count:                    6, insertions_count:   286, deletions_count:   76},
		{sha: "18717d642ebdbdb4ba22a23dd9b0256ad12a8703", date: "2020-06-15 19:30:30 +0000", description: "Bump rust-toolchain to 1.44.0", pr_number:                                                     2813, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "MOZGIII", files_count:                 6, insertions_count:   6, deletions_count:     10},
		{sha: "fcf3868c0005a449080beb298c8526bf5587b232", date: "2020-06-15 10:45:28 +0000", description: "bump maxminddb from 0.13.0 to 0.14.0", pr_number:                                              2791, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 2, insertions_count:   3, deletions_count:     3},
		{sha: "3e2ab7da5554a554d31f4f05526d0f562d5a309e", date: "2020-06-15 10:47:30 +0000", description: "bump tokio-codec from 0.1.1 to 0.1.2", pr_number:                                              2783, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 2, insertions_count:   3, deletions_count:     3},
		{sha: "bb1241a765a116df8c1582a447d5e168b790f56b", date: "2020-06-15 21:19:21 +0000", description: "Add missed option", pr_number:                                                                 2662, scopes: [], type:                                             "docs", breaking_change:        false, author: "Kirill Fomichev", files_count:         7, insertions_count:   80, deletions_count:    18},
		{sha: "f9cb2186ed2254a9b87c2a9fa5f33c5fc6dabc94", date: "2020-06-15 12:40:13 +0000", description: "Add severity key", pr_number:                                                                  2732, scopes: ["gcp_stackdriver_logs sink"], type:                  "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:           6, insertions_count:   228, deletions_count:   6},
		{sha: "1603fdc4dba0ba49a20b277bb03bfa4522bffed4", date: "2020-06-16 20:21:02 +0000", description: "Fix tcp+tls hang on tcp detect read", pr_number:                                               2566, scopes: ["socket sink"], type:                                "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         8, insertions_count:   92, deletions_count:    68},
		{sha: "6d15ec5a78f84641bba152cc924f0f7b098c899c", date: "2020-06-16 13:58:06 +0000", description: "RFC #2768 - 2020-06-12 - Batch and Buffer Rework", pr_number:                                  2802, scopes: [], type:                                             "chore", breaking_change:       false, author: "Bruce Guenter", files_count:           1, insertions_count:   133, deletions_count:   0},
		{sha: "267019ee140d4f4975f4de9706a8daef428b9780", date: "2020-06-16 15:47:02 +0000", description: "Fix typo integration tests", pr_number:                                                        2832, scopes: ["kafka sink"], type:                                 "fix", breaking_change:         false, author: "Bruce Guenter", files_count:           1, insertions_count:   1, deletions_count:     1},
		{sha: "6d4a8f4a70af95bffb6564175f7a0a43e1d524d9", date: "2020-06-17 13:39:01 +0000", description: "Allow disconnected components, and split `start` step", pr_number:                             2793, scopes: ["topology"], type:                                   "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   153, deletions_count:   46},
		{sha: "b5de68d7f7b7299e6789f89f74ae20f41d3cd6ce", date: "2020-06-17 12:35:20 +0000", description: "More usable event RFC", pr_number:                                                             2692, scopes: ["operations"], type:                                 "feat", breaking_change:        false, author: "Ana Hobden", files_count:              1, insertions_count:   222, deletions_count:   0},
		{sha: "3ee64020dd9673cef0a8eab9605fe590b9948708", date: "2020-06-17 12:43:58 +0000", description: "Fix names of RFCs.", pr_number:                                                                2839, scopes: [], type:                                             "chore", breaking_change:       false, author: "Ana Hobden", files_count:              4, insertions_count:   2, deletions_count:     2},
		{sha: "6819865a7550d32a2cbdc30de7b66c13b5a5cee3", date: "2020-06-17 15:38:26 +0000", description: "bump typetag from 0.1.4 to 0.1.5", pr_number:                                                  2835, scopes: [], type:                                             "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   4, deletions_count:     4},
		{sha: "2ddf266397f8c67ccc3e77d8ab5ebe2849d4d62e", date: "2020-06-17 16:36:21 +0000", description: "bump assert_cmd from 0.11.1 to 1.0.1", pr_number:                                              2829, scopes: [], type:                                             "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 3, insertions_count:   16, deletions_count:    18},
		{sha: "4c3ba3e4bf09b259e446d2c13b50678552731f02", date: "2020-06-17 17:22:53 +0000", description: "Use flat JSON parser inserts, add regression test.", pr_number:                                2823, scopes: ["json_parser transform"], type:                      "chore", breaking_change:       false, author: "Ana Hobden", files_count:              2, insertions_count:   34, deletions_count:    1},
		{sha: "c0438da3c166d3718b8275d2a5858d8fb1767435", date: "2020-06-17 17:23:36 +0000", description: "bump criterion from 0.3.1 to 0.3.2", pr_number:                                                2827, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 3, insertions_count:   22, deletions_count:    61},
		{sha: "947dc0e777ab617119d9317fc3143f8808ead09d", date: "2020-06-18 08:01:38 +0000", description: "update rusoto ", pr_number:                                                                    2830, scopes: ["aws_cloudwatch_logs sink"], type:                   "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         32, insertions_count:  398, deletions_count:   1458},
		{sha: "22ec017d7c6ce0727c35afbccc1b025484dd9c04", date: "2020-06-18 13:34:12 +0000", description: "Make encoding optional", pr_number:                                                            2796, scopes: ["loki sink"], type:                                  "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      2, insertions_count:   8, deletions_count:     8},
		{sha: "49de96d1aedbc87cc23d98a72d39b6745d24c49c", date: "2020-06-18 14:32:24 +0000", description: "Remove custom DNS resolution", pr_number:                                                      2812, scopes: ["networking"], type:                                 "chore", breaking_change:       true, author:  "Kruno Tomola Fabro", files_count:      16, insertions_count:  89, deletions_count:    410},
		{sha: "fa040ac0504c6bf5d50be592e2f8946bf88b4414", date: "2020-06-18 15:43:07 +0000", description: "Finish `hyper` upgrade", pr_number:                                                            2852, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      28, insertions_count:  59, deletions_count:    83},
		{sha: "e48ea7fab3da98bd7b8d997ba5eef09c4b769f2b", date: "2020-06-18 15:45:17 +0000", description: "Properly synchronize file updates in `watcher` test", pr_number:                               2853, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   1, deletions_count:     1},
		{sha: "1f3cb4cc0c755adf5a023a2cb6eeff277e1dc730", date: "2020-06-18 18:22:42 +0000", description: "warp update", pr_number:                                                                       2837, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         9, insertions_count:   204, deletions_count:   144},
		{sha: "a0589e9326ac3367961712fb3b8bf9927e2e428a", date: "2020-06-18 09:41:49 +0000", description: "Fix release verification.", pr_number:                                                         2847, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   1, deletions_count:     1},
		{sha: "fb6f6e89d094f973b6f03b812198294638e0a0dc", date: "2020-06-18 23:32:02 +0000", description: "Use to_raw_value instead of to_string in JsonArrayBuffer", pr_number:                          2860, scopes: ["sinks"], type:                                      "enhancement", breaking_change: false, author: "Nazar Mishturak", files_count:         1, insertions_count:   3, deletions_count:     4},
		{sha: "865c8ba5bf6618097d40035df5642f354a581f28", date: "2020-06-18 20:15:03 +0000", description: "address potential deadlock", pr_number:                                                        2838, scopes: ["sinks"], type:                                      "fix", breaking_change:         false, author: "Luke Steensen", files_count:           1, insertions_count:   6, deletions_count:     6},
		{sha: "ed1afd14d0222c2d7ba9df1487e7592a4f2adee4", date: "2020-06-19 09:46:19 +0000", description: "Add content options", pr_number:                                                               2848, scopes: ["aws_s3 sink"], type:                                "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:         4, insertions_count:   102, deletions_count:   4},
		{sha: "cdebd75c0c0d0648de8f96a4503d1df6128d07f8", date: "2020-06-19 11:58:02 +0000", description: "file-source bytes update", pr_number:                                                          2865, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         5, insertions_count:   25, deletions_count:    10},
		{sha: "4e5429b14fbdea5114755c447c8324fbaaac08ca", date: "2020-06-19 14:03:06 +0000", description: "Use `i` for unsigned ints on Influx v1", pr_number:                                            2868, scopes: ["influxdb_metrics sink"], type:                      "fix", breaking_change:         false, author: "Marcus Griep", files_count:            3, insertions_count:   292, deletions_count:   27},
		{sha: "e84ff7579511f1b7302348f237c6aa06710f33b4", date: "2020-06-19 22:28:34 +0000", description: "fix wrap path", pr_number:                                                                     2873, scopes: ["splunk_hec source"], type:                          "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:         1, insertions_count:   9, deletions_count:     23},
		{sha: "5e00483d8b84b114910bf9aba55238151c329f71", date: "2020-06-20 00:31:03 +0000", description: "Show client errors as warning logs", pr_number:                                                2825, scopes: ["elasticsearch sink"], type:                         "enhancement", breaking_change: false, author: "Tristan Keen", files_count:            1, insertions_count:   57, deletions_count:    6},
		{sha: "6963b5807a79dcef54423e7436d794e979cadb5a", date: "2020-06-20 17:16:53 +0000", description: "Shutdown write side only in test `tcp_stream_detects_disconnect`", pr_number:                  2857, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   4, deletions_count:     3},
		{sha: "a5a60c89a5f4138b71330ee40ac82cb15e2fa879", date: "2020-06-21 23:23:47 +0000", description: "Bump rust-toolchain to 1.44.1", pr_number:                                                     2874, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         1, insertions_count:   1, deletions_count:     1},
		{sha: "257440183c2c38c7445a9a468ddd803d03d912df", date: "2020-06-22 14:06:06 +0000", description: "Fix command for integration tests", pr_number:                                                 2834, scopes: ["kafka sink"], type:                                 "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         4, insertions_count:   5, deletions_count:     7},
		{sha: "c293c492e97a7249822be4907f6bab84414dae7d", date: "2020-06-23 07:07:50 +0000", description: "remove outdated uri code", pr_number:                                                          2889, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         8, insertions_count:   11, deletions_count:    19},
		{sha: "a7486664de540a73c244324e5a093b388a7bb7ee", date: "2020-06-24 11:08:43 +0000", description: "Adding a condition to filter using IP CIDR", pr_number:                                        2831, scopes: ["filter transform"], type:                           "feat", breaking_change:        false, author: "Bill", files_count:                    9, insertions_count:   277, deletions_count:   3},
		{sha: "7cd8c7fc43bd80ab8ef45069190947a3f8ca93e4", date: "2020-06-24 18:12:03 +0000", description: "remove contextual QA checklist", pr_number:                                                    2898, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         2, insertions_count:   0, deletions_count:     24},
		{sha: "be4ecfbfbea9420f542fd77a9118c8a3e84c1f7a", date: "2020-06-24 17:37:24 +0000", description: "Adjust buffering tests", pr_number:                                                            2862, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      2, insertions_count:   49, deletions_count:    40},
		{sha: "aaa4fc1a158ad3d714af9fa8efdf54ca7047c698", date: "2020-06-24 17:37:31 +0000", description: "Remove `trust-dns` dependecies", pr_number:                                                    2884, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      2, insertions_count:   1, deletions_count:     152},
		{sha: "da94162850b609b4e6d5d23edde9e0e2abc33624", date: "2020-06-24 22:54:46 +0000", description: "make HttpSink::build_request async", pr_number:                                                2888, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         14, insertions_count:  135, deletions_count:   76},
		{sha: "5e5d806b31b8db02e918da84b72ba9ac93071b8e", date: "2020-06-24 22:56:58 +0000", description: "add assume_role to aws auth", pr_number:                                                       2895, scopes: ["elasticsearch sink"], type:                         "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:         5, insertions_count:   48, deletions_count:    12},
		{sha: "68d3d39fa64936dd484ebcab23d734a621cfa94c", date: "2020-06-25 10:09:38 +0000", description: "Adding spaces to condition docs", pr_number:                                                   2901, scopes: [], type:                                             "docs", breaking_change:        false, author: "Bill", files_count:                    5, insertions_count:   43, deletions_count:    43},
		{sha: "6517265bf97364d9f7176f8cb7e60d060be7f209", date: "2020-06-25 18:38:23 +0000", description: "refresh aws creds when required", pr_number:                                                   2859, scopes: ["elasticsearch sink"], type:                         "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:         2, insertions_count:   42, deletions_count:    28},
		{sha: "dc70fc5eb8b9d50238536ed2aabf43cf690105f3", date: "2020-06-25 20:28:31 +0000", description: "reduce http:0.1 usage", pr_number:                                                             2905, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         33, insertions_count:  110, deletions_count:   175},
		{sha: "832f25b10e5254fd026c498e41c25a047017fefb", date: "2020-06-27 11:03:29 +0000", description: "Add SASL to kafka", pr_number:                                                                 2897, scopes: ["kafka source", "kafka sink"], type:                 "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:         13, insertions_count:  511, deletions_count:   107},
		{sha: "3d11c34703bdaed580e2e42ff8a28024ea504d40", date: "2020-06-29 17:34:11 +0000", description: "remove native-tls", pr_number:                                                                 2912, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         3, insertions_count:   2, deletions_count:     2},
		{sha: "d2fe5279087ceb3dddd561c3b3d01959fad59006", date: "2020-06-29 12:08:28 +0000", description: "Batch buffer rework", pr_number:                                                               2866, scopes: ["sinks"], type:                                      "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:           73, insertions_count:  1532, deletions_count:  680},
		{sha: "4ee8ea039c1f8b5fa2d08248748d994d45d17bbf", date: "2020-06-29 11:50:06 +0000", description: "Fixup sasl related knobs", pr_number:                                                          2915, scopes: ["kafka kink"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              3, insertions_count:   17, deletions_count:    10},
		{sha: "abd8d806fb05b373cb0a027fe2384e083cb8ff74", date: "2020-06-29 17:08:47 +0000", description: "Allow remapping priority numbers to words", pr_number:                                         2751, scopes: ["journald source"], type:                            "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:           4, insertions_count:   89, deletions_count:    8},
		{sha: "cd7404091459802d709b5a393f7b4827ddc100fc", date: "2020-06-30 09:13:45 +0000", description: "Handle and enforce batch.max_bytes", pr_number:                                                2916, scopes: ["aws_cloudwatch_logs sink"], type:                   "fix", breaking_change:         false, author: "Bruce Guenter", files_count:           13, insertions_count:  270, deletions_count:   78},
		{sha: "079c360ca6ab1b5a80ea551146cba7596513de81", date: "2020-06-30 09:14:43 +0000", description: "Remove two unneeded files", pr_number:                                                         2918, scopes: [], type:                                             "chore", breaking_change:       false, author: "Bruce Guenter", files_count:           2, insertions_count:   0, deletions_count:     12},
		{sha: "25ee24cc4ae2dee25852b05b0dc3a208c554f066", date: "2020-07-01 01:02:47 +0000", description: "Add Fingerprinter::FirstLineChecksum", pr_number:                                              2904, scopes: ["file source"], type:                                "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   96, deletions_count:    0},
		{sha: "02c30220d6a2a34425b33fc25490a3520d748282", date: "2020-07-01 15:23:55 +0000", description: "Architecture Revisit RFC", pr_number:                                                          2855, scopes: [], type:                                             "chore", breaking_change:       false, author: "Luke Steensen", files_count:           2, insertions_count:   504, deletions_count:   0},
		{sha: "01b37785f38159388636ff9954a3675c1ae0d049", date: "2020-07-05 14:25:02 +0000", description: "Option to remove file after some time of reaching `eof`", pr_number:                           2908, scopes: ["file source"], type:                                "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:      6, insertions_count:   126, deletions_count:   6},
		{sha: "c34607e8f060ad7648c72983180b57737b14ed0b", date: "2020-07-06 17:23:21 +0000", description: "move reqwest to dev-dependencies ", pr_number:                                                 2952, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         18, insertions_count:  1081, deletions_count:  1164},
		{sha: "f69c26356fe4d37b0bf4c4bae321d58970e0df31", date: "2020-07-06 17:33:16 +0000", description: "add compression option for aws sinks", pr_number:                                              2953, scopes: ["sinks"], type:                                      "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:         17, insertions_count:  417, deletions_count:   282},
		{sha: "35330c77049c928adfaad755743aca4c2bcd47f3", date: "2020-07-06 18:41:22 +0000", description: "disable sasl feature", pr_number:                                                              2930, scopes: ["kafka sink"], type:                                 "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         6, insertions_count:   24, deletions_count:    29},
		{sha: "aa9a38c515bbd4dd0b5beed509053ce18247548c", date: "2020-07-07 19:52:53 +0000", description: "Construct tcp healthcheck with TLS", pr_number:                                                2958, scopes: ["sinks"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      5, insertions_count:   47, deletions_count:    28},
		{sha: "07f5268355018a740b7c8df59ec4a7c10fc64169", date: "2020-07-07 11:25:42 +0000", description: "Move the builder to centos 7", pr_number:                                                      2824, scopes: ["platforms"], type:                                  "chore", breaking_change:       false, author: "Ana Hobden", files_count:              4, insertions_count:   38, deletions_count:    10},
		{sha: "4202a963723b4e5ec548e9dfe518e725a28c7885", date: "2020-07-07 13:26:01 +0000", description: "move topology building into tokio context, take 2", pr_number:                                 2964, scopes: [], type:                                             "chore", breaking_change:       false, author: "Luke Steensen", files_count:           56, insertions_count:  810, deletions_count:   791},
		{sha: "d1d7d1a6776018c7b2fd138765a2c9eab20038df", date: "2020-07-07 21:34:44 +0000", description: "upgrade to bollard", pr_number:                                                                2951, scopes: ["docker source"], type:                              "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         3, insertions_count:   967, deletions_count:   1099},
		{sha: "b5e0eb76c9e90234c5487817cf4eac3470472967", date: "2020-07-07 20:41:25 +0000", description: "Extract timestamp from event", pr_number:                                                      2956, scopes: ["kafka source"], type:                               "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:      4, insertions_count:   51, deletions_count:    14},
		{sha: "349ad526c8e86b3b271ee7bb04134d15a2c1566f", date: "2020-07-08 10:08:57 +0000", description: "remove some allowed clippy rules", pr_number:                                                  2959, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         107, insertions_count: 491, deletions_count:   640},
		{sha: "16ed04d2f39f7268eda2eaade9368612eb6d06aa", date: "2020-07-08 08:50:29 +0000", description: "Move over homebrew/s3 release jobs", pr_number:                                                2869, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   417, deletions_count:   0},
		{sha: "59c4132a77556b62be5b1ee07dbdd74194c08c3f", date: "2020-07-08 18:54:47 +0000", description: "Add smoke tests to docker images", pr_number:                                                  2974, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 2, insertions_count:   6, deletions_count:     0},
		{sha: "466bf49d3e580a48f082f12c098e4b2b6459d2a1", date: "2020-07-08 11:03:57 +0000", description: "bump nom from 5.1.0 to 5.1.2", pr_number:                                                      2967, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 2, insertions_count:   15, deletions_count:    30},
		{sha: "3c1ba1ba4eed48eb15cd45cea8635d3077f4da20", date: "2020-07-08 11:57:26 +0000", description: "Update README.md", pr_number:                                                                  2976, scopes: [], type:                                             "chore", breaking_change:       false, author: "Eugene Marinelli", files_count:        3, insertions_count:   3, deletions_count:     3},
		{sha: "ae53b889406942dd404578fc84d2675ea2e282ac", date: "2020-07-08 12:45:30 +0000", description: "bump scan_fmt from 0.2.4 to 0.2.5", pr_number:                                                 2849, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 2, insertions_count:   3, deletions_count:     3},
		{sha: "fe6f9c29299f4dd45824ba9700aa3dc76de46ab7", date: "2020-07-08 14:30:23 +0000", description: "Configure dependabot to use correct issue names", pr_number:                                   2821, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Ana Hobden", files_count:              4, insertions_count:   45, deletions_count:    4},
		{sha: "bf3df05f132bebe9bb3e993318fb19a14d50273f", date: "2020-07-08 14:39:26 +0000", description: "Fixup dependabot config", pr_number:                                                           2980, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   2, deletions_count:     2},
		{sha: "448b64139b8a5440cc0c885f3e9cd9635a2d8be4", date: "2020-07-08 15:01:31 +0000", description: "bump built from 0.3.2 to 0.4.2", pr_number:                                                    2850, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 3, insertions_count:   22, deletions_count:    10},
		{sha: "863923b359afeb61742f88284e844f395f52afa2", date: "2020-07-08 15:34:05 +0000", description: "Make environment use ubuntu 20.04", pr_number:                                                 2971, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              15, insertions_count:  213, deletions_count:   418},
		{sha: "3702885aa8092eb9b2a4c666800dcb7c2346c818", date: "2020-07-08 15:42:35 +0000", description: "bump @types/fs-extra from 8.1.0 to 8.1.1 in /website", pr_number:                              2986, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   3, deletions_count:     3},
		{sha: "c8c8aaa399e134d88c9c4ae62b7a9ed8c750be6f", date: "2020-07-08 16:07:52 +0000", description: "bump yard from 0.9.24 to 0.9.25 in /scripts", pr_number:                                       2981, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   1, deletions_count:     1},
		{sha: "7aba11cf95660936d338068b77bcf422adaba78c", date: "2020-07-08 16:11:03 +0000", description: "bump @types/lodash from 4.14.150 to 4.14.157 in /website", pr_number:                          2988, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   3, deletions_count:     3},
		{sha: "60eddc87fea0869023eb1b193e5d6b8f18dcaac0", date: "2020-07-08 16:12:00 +0000", description: "Fix dependency label to be longer again.", pr_number:                                          2990, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   2, deletions_count:     2},
		{sha: "25d0aa1855938b549e9cfa42c38c6a22f7951c60", date: "2020-07-08 16:57:12 +0000", description: "bump qs from 6.9.3 to 6.9.4 in /website", pr_number:                                           2982, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   3, deletions_count:     3},
		{sha: "472d3b6181f1480ab49e70c5efa0522be7e7038b", date: "2020-07-09 17:12:28 +0000", description: "Add smoke test for cmark-gfm at builder", pr_number:                                           2995, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "MOZGIII", files_count:                 1, insertions_count:   2, deletions_count:     1},
		{sha: "d78ffbfb59a14624621d42303bd5ce40f06c6f05", date: "2020-07-09 17:32:13 +0000", description: "Fix the cmark-gfm installation at builder image", pr_number:                                   2996, scopes: ["operations"], type:                                 "fix", breaking_change:         false, author: "MOZGIII", files_count:                 1, insertions_count:   1, deletions_count:     0},
		{sha: "1cd6e0697a51a22381a7b7eceda9c0e172b0504b", date: "2020-07-09 18:14:27 +0000", description: "Use perl rename at builder", pr_number:                                                        2999, scopes: ["operations"], type:                                 "fix", breaking_change:         false, author: "MOZGIII", files_count:                 1, insertions_count:   4, deletions_count:     1},
		{sha: "caa68d812bcd456ecd0de685e09d60f12463350d", date: "2020-07-09 14:02:04 +0000", description: "Add musl and glibc support to install.sh", pr_number:                                          2969, scopes: ["operations"], type:                                 "enhancement", breaking_change: false, author: "Ana Hobden", files_count:              2, insertions_count:   17, deletions_count:    2},
		{sha: "969b52de850196a4f4010d2a719a25d26d4aebc3", date: "2020-07-10 16:48:29 +0000", description: "remove outdated security advisories", pr_number:                                               3009, scopes: ["security"], type:                                   "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         1, insertions_count:   0, deletions_count:     3},
		{sha: "e5d828374b53ba952a36991db6214b90b2d61424", date: "2020-07-10 07:07:29 +0000", description: "Make dependabot only cover Rust code", pr_number:                                              3003, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   0, deletions_count:     26},
		{sha: "8fec89e3fc64543e63167fff4e2f8208114cbf0f", date: "2020-07-10 09:34:03 +0000", description: "Fix filter_unit_works_correctly test", pr_number:                                              3005, scopes: ["journald source"], type:                            "chore", breaking_change:       false, author: "Bruce Guenter", files_count:           1, insertions_count:   1, deletions_count:     1},
		{sha: "37790157c61ea630635f88da81564937cfb00585", date: "2020-07-10 11:08:41 +0000", description: "Fixup release script formats", pr_number:                                                      3002, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   6, deletions_count:     6},
		{sha: "7c61530eb67cd33d45959e71115f613a32991e38", date: "2020-07-10 11:09:52 +0000", description: "Fixup release-s3", pr_number:                                                                  3015, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   1, deletions_count:     1},
		{sha: "9c0ecdbc5478b17503522f826ecb3dbd2bf68e10", date: "2020-07-10 21:36:41 +0000", description: "sync token request", pr_number:                                                                2993, scopes: ["gcp provider"], type:                               "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:         2, insertions_count:   68, deletions_count:    69},
		{sha: "db85e2faf6b590b76eed72530ce9600fbbcc03b6", date: "2020-07-11 00:03:22 +0000", description: "update to 1.0.0-alpha-2", pr_number:                                                           2977, scopes: ["pulsar sink"], type:                                "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         13, insertions_count:  321, deletions_count:   294},
		{sha: "0036ede7448f3b6f849d1f13fc832c24cc522890", date: "2020-07-10 14:04:42 +0000", description: "Remove dead envrc file", pr_number:                                                            3023, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   0, deletions_count:     1},
		{sha: "63792bb8ef63fc560ff436122763a74cab30706b", date: "2020-07-10 14:05:14 +0000", description: "Remove the dns-server options from docs", pr_number:                                           3021, scopes: [], type:                                             "docs", breaking_change:        false, author: "Ana Hobden", files_count:              6, insertions_count:   1, deletions_count:     52},
		{sha: "36efd3970f6931221e5749539c93f218e9147dba", date: "2020-07-10 16:24:08 +0000", description: "Set a proper default for the batch buffer initialization", pr_number:                          3016, scopes: ["loki sink"], type:                                  "fix", breaking_change:         false, author: "Bruce Guenter", files_count:           5, insertions_count:   17, deletions_count:    20},
		{sha: "bb497befcb38793573404e56fda3871ed0ece3c3", date: "2020-07-10 18:28:49 +0000", description: "add reduce transform", pr_number:                                                              2870, scopes: ["new transform"], type:                              "feat", breaking_change:        false, author: "Luke Steensen", files_count:           17, insertions_count:  2496, deletions_count:  3},
		{sha: "ccbb802c010c6109240a14be44b3c30dbae73564", date: "2020-07-11 09:59:29 +0000", description: "update prost", pr_number:                                                                      3017, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         6, insertions_count:   33, deletions_count:    113},
		{sha: "f28b64b9f34f7da81597bb935359e1c4a3658431", date: "2020-07-11 12:53:34 +0000", description: "update crates in lock file after merges", pr_number:                                           3030, scopes: ["deps"], type:                                       "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:         1, insertions_count:   2, deletions_count:     2},
		{sha: "a9a5d3980db07ec51a23648f95721790c0c6397e", date: "2020-07-12 00:11:46 +0000", description: "Accept `octet-counting` encoded messages", pr_number:                                          2955, scopes: ["syslog source"], type:                              "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:      8, insertions_count:   226, deletions_count:   36},
		{sha: "5c88a7c156bf4b0c96c5be329c1fe03e8f838aac", date: "2020-07-11 16:21:53 +0000", description: "Drop 3 more clippy exclusions", pr_number:                                                     3026, scopes: [], type:                                             "chore", breaking_change:       false, author: "Bruce Guenter", files_count:           1, insertions_count:   0, deletions_count:     3},
		{sha: "feb4e44f7d6888e967ed650e8fde824a5d35c166", date: "2020-07-12 01:34:11 +0000", description: "Delete `topology::config::watcher::tests::multi_file_update` ", pr_number:                     3034, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   0, deletions_count:     16},
		{sha: "e3dca13f68773ca690b75395a46aa4b4649b2d44", date: "2020-07-12 01:35:00 +0000", description: "Delete `topology::reload_tests::topology_reuse_old_port` ", pr_number:                         3036, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   0, deletions_count:     38},
		{sha: "20b2c504412c499503729bbf998f805c69de9b76", date: "2020-07-12 01:36:52 +0000", description: "Build `HttpClient` once", pr_number:                                                           3010, scopes: ["sinks"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      14, insertions_count:  114, deletions_count:   155},
		{sha: "2e15006ac26f3699fa10a4811d9da7ad9914d7dc", date: "2020-07-12 18:20:19 +0000", description: "remove tokio-codec crate", pr_number:                                                          3011, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         11, insertions_count:  339, deletions_count:   30},
		{sha: "3848bfd7f23144f2da92775def678c6c750626cd", date: "2020-07-12 17:54:22 +0000", description: "Delete `tests\\tcp::merge` test", pr_number:                                                   3042, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   0, deletions_count:     64},
		{sha: "359adb8c5a2a3040717dd87a2c09e5fdc0185dc9", date: "2020-07-12 17:56:58 +0000", description: "Delete `test_udp_syslog` test", pr_number:                                                     3044, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   1, deletions_count:     65},
		{sha: "9880fbebb38c5bd4bdcbf795b74800794292fe31", date: "2020-07-12 17:58:30 +0000", description: "Delete `test_max_size_resume`", pr_number:                                                     3040, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   2, deletions_count:     63},
		{sha: "752fb6574503da0811d4033289fc45ab974926de", date: "2020-07-12 21:33:27 +0000", description: "bump num_cpus from 1.12.0 to 1.13.0", pr_number:                                               2910, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   2, deletions_count:     2},
		{sha: "680266eef07fa3f76c96ca9ea055bb704457a19a", date: "2020-07-13 06:29:10 +0000", description: "bump serde_json from 1.0.55 to 1.0.56", pr_number:                                             3051, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   2, deletions_count:     2},
		{sha: "23888d1a7aff7629bf601abcaedbc7009f55ad45", date: "2020-07-13 06:37:34 +0000", description: "bump bytesize from 1.0.0 to 1.0.1", pr_number:                                                 3050, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   2, deletions_count:     2},
		{sha: "5d8f535454d9d9e6a166d2466f5f45bd26e8b5e2", date: "2020-07-13 17:36:14 +0000", description: "bump to pulsar-rs 1.0.0", pr_number:                                                           3053, scopes: ["pulsar sink"], type:                                "chore", breaking_change:       false, author: "Alexandre DUVAL", files_count:         3, insertions_count:   5, deletions_count:     5},
		{sha: "cd4620e3a2010259f988769c8a97388a9666f2da", date: "2020-07-13 19:16:50 +0000", description: "reduce std::io::Cursor usage", pr_number:                                                      3038, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         9, insertions_count:   32, deletions_count:    40},
		{sha: "c1ca0295b3cda2fad9bef6b8212a220fc6feeffe", date: "2020-07-13 10:58:46 +0000", description: "Fixup integration test invocations", pr_number:                                                3004, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   2, deletions_count:     3},
		{sha: "e60d96d8d70e6d14118b4330eb5ccaa131afa896", date: "2020-07-13 12:30:43 +0000", description: "Fix broken `make generate`", pr_number:                                                        3058, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              485, insertions_count: 566, deletions_count:   999},
		{sha: "7aef527df7cdc3c2abb330a22911c94c62b1010c", date: "2020-07-14 09:15:51 +0000", description: "bump bollard from 0.7.0 to 0.7.1", pr_number:                                                  3048, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 2, insertions_count:   5, deletions_count:     5},
		{sha: "dc5c6cc7f38564d8ccb4f0774c0e398428428973", date: "2020-07-14 12:05:45 +0000", description: "Cleanup `generate` command", pr_number:                                                        3046, scopes: ["cli"], type:                                        "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   6, deletions_count:     3},
		{sha: "60a9ded146a2188980c8d31cdd374ebd59b6e6f1", date: "2020-07-14 12:12:07 +0000", description: "Build `aws` sinks clients only once", pr_number:                                               3045, scopes: ["sinks"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      5, insertions_count:   66, deletions_count:    60},
		{sha: "dc564ed54508da96f62de57b33e6b2a994114d3d", date: "2020-07-14 20:20:12 +0000", description: "remove owning_ref", pr_number:                                                                 3059, scopes: ["kafka source"], type:                               "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         3, insertions_count:   166, deletions_count:   131},
		{sha: "ae20875fc7cd4b38dc7215c0b65cb22073490864", date: "2020-07-14 22:45:40 +0000", description: "update runtime_transform", pr_number:                                                          3065, scopes: ["transforms"], type:                                 "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         14, insertions_count:  165, deletions_count:   133},
		{sha: "b8fa14e21885af394586cf2ee7c736646a6ae7e2", date: "2020-07-14 21:55:00 +0000", description: "Add .rustfmt.toml to assist IDE formatters.", pr_number:                                       3063, scopes: [], type:                                             "chore", breaking_change:       false, author: "Harold Dost", files_count:             1, insertions_count:   3, deletions_count:     0},
		{sha: "df65bf9830eaffdcb8798865abb710ad67a8628a", date: "2020-07-14 19:44:15 +0000", description: "add SinkConfig::build_async", pr_number:                                                       3066, scopes: ["sinks"], type:                                      "chore", breaking_change:       false, author: "Luke Steensen", files_count:           11, insertions_count:  132, deletions_count:   121},
		{sha: "0faa07b42276dcdec3e077ff835610ebe865f21f", date: "2020-07-15 16:07:33 +0000", description: "adjust log event in coercer transform", pr_number:                                             3072, scopes: ["docs"], type:                                       "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:         2, insertions_count:   3, deletions_count:     3},
		{sha: "64d7dc8d215c25e61d3e4937ac748a8342a6afad", date: "2020-07-15 07:34:20 +0000", description: "Remove CircleCI", pr_number:                                                                   3001, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   0, deletions_count:     967},
		{sha: "30123d970e586a634cae729b37fe918bd5b13fd2", date: "2020-07-15 07:35:03 +0000", description: "bump flate2 from 1.0.13 to 1.0.16", pr_number:                                                 3049, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   8, deletions_count:     8},
		{sha: "2e29c36d8225c6fa82419932e88f92372c755847", date: "2020-07-15 21:59:31 +0000", description: "fix endpoint strip for aws region", pr_number:                                                 3070, scopes: ["sinks"], type:                                      "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         1, insertions_count:   19, deletions_count:    1},
		{sha: "4866bded3c73d4340cb114efd73de3e872b5906f", date: "2020-07-15 14:29:20 +0000", description: "Add sync-install to GA", pr_number:                                                            3056, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              2, insertions_count:   18, deletions_count:    3},
		{sha: "efcf4b934aa83bd41d2bc54e8dc5bb3a64a78266", date: "2020-07-15 16:01:02 +0000", description: "bump tokio-uds from 0.2.5 to 0.2.7", pr_number:                                                2946, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   2, deletions_count:     2},
		{sha: "0b9e4cc40dc7e5c19a2451993da29c78e38f858a", date: "2020-07-15 19:02:35 +0000", description: "improve array handling", pr_number:                                                            3076, scopes: ["reduce transform"], type:                           "fix", breaking_change:         false, author: "Luke Steensen", files_count:           2, insertions_count:   132, deletions_count:   14},
		{sha: "ff1884062e09956a7696a644f80c401e593d3e6f", date: "2020-07-16 08:11:25 +0000", description: "Fix warning message due .rustfmt.toml", pr_number:                                             3075, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         1, insertions_count:   2, deletions_count:     1},
		{sha: "6e097287b82ac48651649695593b3c7533873de1", date: "2020-07-16 09:13:51 +0000", description: "Drop the batch byte size limit", pr_number:                                                    3025, scopes: ["loki sink"], type:                                  "fix", breaking_change:         false, author: "Bruce Guenter", files_count:           4, insertions_count:   5, deletions_count:     39},
		{sha: "ca6df186b089b3535eecf609e1aaf54aed4c4df3", date: "2020-07-16 20:41:25 +0000", description: "use localstack instead minio", pr_number:                                                      3073, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         2, insertions_count:   4, deletions_count:     20},
		{sha: "3af6816cceafcd6af56d5f8e9286915b50a8025f", date: "2020-07-16 11:18:40 +0000", description: "bump inventory from 0.1.5 to 0.1.7", pr_number:                                                2851, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot-preview[bot]", files_count: 1, insertions_count:   4, deletions_count:     4},
		{sha: "59871fd3f54bd4710d14fde4089088dcb2932d81", date: "2020-07-16 11:51:19 +0000", description: "Reenable sasl", pr_number:                                                                     3081, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "Ana Hobden", files_count:              8, insertions_count:   56, deletions_count:    36},
		{sha: "773e5e5c85c5d5849e306783468e4cfb7fd82f74", date: "2020-07-16 14:26:19 +0000", description: "append instead of overwriting files", pr_number:                                               3084, scopes: ["file sink"], type:                                  "fix", breaking_change:         false, author: "Luke Steensen", files_count:           1, insertions_count:   43, deletions_count:    0},
		{sha: "1de26d27ed36062e58c702e4c5af168175d4ca87", date: "2020-07-16 16:26:39 +0000", description: "stop logging every received event", pr_number:                                                 3085, scopes: ["elasticsearch sink"], type:                         "fix", breaking_change:         false, author: "Luke Steensen", files_count:           2, insertions_count:   7, deletions_count:     2},
		{sha: "e31f20da83114449109c3a9f14a9ac097da28dfb", date: "2020-07-19 21:41:16 +0000", description: "Remove `tcp_graceful_shutdown` ", pr_number:                                                   3103, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   0, deletions_count:     111},
		{sha: "f37f2e0ce3d94679bf88ba5826b43e705977bfdc", date: "2020-07-19 21:42:21 +0000", description: "Remove `s3_waits_for_full_batch_or_timeout_before_sending`", pr_number:                        3105, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   0, deletions_count:     70},
		{sha: "75b89d490c17f9985089237111e83e4e8c5f71df", date: "2020-07-20 20:57:33 +0000", description: "Bump rust-toolchain to 1.45.0", pr_number:                                                     3089, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:         7, insertions_count:   18, deletions_count:    18},
		{sha: "876b4104c2009b8e7be71a6c90c4c0f810a90c76", date: "2020-07-20 14:03:22 +0000", description: "Docker debian packages systemd", pr_number:                                                    3129, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   3, deletions_count:     3},
		{sha: "ed9006f783445c1636fb50a56fae1fffec4ab1e3", date: "2020-07-20 15:38:34 +0000", description: "Add Rust 2018 edition tag to .rustfmt.toml", pr_number:                                        3120, scopes: [], type:                                             "chore", breaking_change:       false, author: "Bruce Guenter", files_count:           1, insertions_count:   1, deletions_count:     0},
		{sha: "1c91ed0883f6743f471095cdad2ec570f1e74bee", date: "2020-07-20 15:22:41 +0000", description: "Debian buster is stable, not sid", pr_number:                                                  3131, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   2, deletions_count:     2},
		{sha: "129a861500f435f94e4b4153f49f1f821715ee46", date: "2020-07-20 23:52:26 +0000", description: "bump lodash from 4.17.15 to 4.17.19 in /website", pr_number:                                   3098, scopes: ["deps"], type:                                       "chore", breaking_change:       false, author: "dependabot[bot]", files_count:         1, insertions_count:   3, deletions_count:     3},
		{sha: "5885c7d579ebd95e231589da38056db476d6040c", date: "2020-07-21 12:53:47 +0000", description: "Update benches", pr_number:                                                                    3107, scopes: ["tests"], type:                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   16, deletions_count:    14},
		{sha: "bfb0fcaa89a118913547ad01c6c2a98fdec29cf7", date: "2020-07-21 13:50:27 +0000", description: "Remove tokio 0.1 from shutdown", pr_number:                                                    3106, scopes: [], type:                                             "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:      1, insertions_count:   18, deletions_count:    21},
		{sha: "b6004be220b2071093a066bb16449f1a4e5814ba", date: "2020-07-21 09:32:09 +0000", description: "Update cidr-utils", pr_number:                                                                 3139, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              2, insertions_count:   7, deletions_count:     7},
		{sha: "3b8bf31a4f6cd5a47016bba934e16aabe04c18ff", date: "2020-07-21 10:26:37 +0000", description: "Pin back Rust 1.45 until after 0.10.0", pr_number:                                             3142, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              2, insertions_count:   2, deletions_count:     2},
		{sha: "675ad3be743cc754197e108d2da4427d636dd682", date: "2020-07-21 11:25:33 +0000", description: "Fixup clippy issues from 1.44 rollback", pr_number:                                            3143, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   1, deletions_count:     1},
		{sha: "22fa53afbef21189d7eb8c7eea68864fc494fa93", date: "2020-07-21 12:34:52 +0000", description: "Prepare v0.10.0", pr_number:                                                                   3022, scopes: [], type:                                             "chore", breaking_change:       false, author: "Ana Hobden", files_count:              42, insertions_count:  14414, deletions_count: 140},
		{sha: "c6d0cad0fe058ad7a5a5603410d03ff2d4b321c5", date: "2020-07-22 09:51:17 +0000", description: "Fixup release-homebrew", pr_number:                                                            3158, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   1, deletions_count:     1},
		{sha: "680b7eeb5cfcbd6f7a338591270066560c5397ab", date: "2020-07-22 09:35:22 +0000", description: "Fixup version invocation to not have info", pr_number:                                         3153, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   1, deletions_count:     1},
		{sha: "341183a2034493ad2f7236c07e1f35d546fca514", date: "2020-07-22 09:35:03 +0000", description: "Fixup release s3 job", pr_number:                                                              3155, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              1, insertions_count:   1, deletions_count:     1},
		{sha: "19e62802df15dc21f6c4f2e3f94f1e5bbe9437e4", date: "2020-07-22 11:13:37 +0000", description: "Fixup release commit", pr_number:                                                              3163, scopes: ["operations"], type:                                 "chore", breaking_change:       false, author: "Ana Hobden", files_count:              2, insertions_count:   11, deletions_count:    1},
	]
}
