package metadata

releases: "0.9.0": {
	date:     "2020-04-17"
	codename: "The Homestretch"

	whats_next: [
		{
			title:       "Kubernetes!"
			description: "We're doing this integration right. We've been alpha testing with a number of large clusters and we've honed in on a very high-quality approach that reflects the UX Vector is going after. You can learn more in our [Kubernetes Integration RFC][urls.pr_2222]. Feedback is welcome!"
		},
		{
			title:       "WASM Driven Plugin Architecture"
			description: "This release included an overhaul of our [`lua` transform][docs.transforms.lua], which represents a big step towards making Vector more flexible. Lua is an excellent language when you need some quick scripting capabilities. But what if you need something more powerful? Like writing your own custom source, transform, or sink? Vector plans to solve this with [WASM][urls.wasm] foreign module support, enabling you to extend Vector in the language of your choice with little performance penalty. ❤️ WASM. Check out the [WASM Foreign Module Support RFC][urls.pr_2341] for more info."
		},
		{
			title:       "Dynamic HTTP Rate-Limiting (AIMD)"
			description: "Fiddling with rate-limits is a frustratin endaevor. If you set them too high you risk overwhelming the service; too low and you're unecessarily limiting throughput. And what happens if you deploy a few more Vector instances? Vector is planning to solve this by automatically detecting the optimal rate limits, taking inspiration from TCP congestional control algorithms. Check out the [Dynamic HTTP Rate Limiting RFC][urls.pr_2329]."
		},
		{
			title:       "Vector Observability"
			description: "Did you know this release includes a new hidden `internal` source that emits metrics reflecting Vector's own internal state? 👀 We didn't highlight this source because we have not finished instrumenting Vector and we'll be changing the internal schema used.\n\nFun fact, we took an event-driven approach to Vector's internal observability, which we strongly believe in. We want Vector to be a good example of our own advice. Checkout the [Event-Driven Observability RFC][urls.pr_2093]."
		},
	]

	commits: [
		{sha: "177bd7de7e38a24c4a6092c85b8f5eb9d0f5386f", date: "2020-02-25 21:55:37 +0000", description: "Allow setting individual `log_schema.*` options", pr_number:                                                                         1923, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:    11, deletions_count:    1},
		{sha: "12cc1ca32d56853a99ff6916dcca49466e881dc4", date: "2020-02-26 10:31:46 +0000", description: "Restructure getting started guide", pr_number:                                                                                       1854, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Ashley Jeffs", files_count:       1, insertions_count:    198, deletions_count:   78},
		{sha: "fb4bab3b95e6e5eecb7a1a4a5838c76b519f1edb", date: "2020-02-26 14:07:37 +0000", description: "Add behavior test for the `merge` transform", pr_number:                                                                             1820, scopes: ["testing"], type:                                            "chore", breaking_change:       false, author: "MOZGIII", files_count:            1, insertions_count:    71, deletions_count:    0},
		{sha: "33d529feb01e37e98bec3761604a1ca125b3c3df", date: "2020-02-26 08:43:47 +0000", description: "Add TLS support to socket, syslog, and vector sources", pr_number:                                                                   1892, scopes: ["socket source", "syslog source", "vector source"], type:    "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      18, insertions_count:   890, deletions_count:   50},
		{sha: "38864efa4152a1f44154431bf250ddf1c67b91c6", date: "2020-02-26 18:00:02 +0000", description: "Replace `flatten`/`unflatten` by native nesting", pr_number:                                                                         1902, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    35, insertions_count:   1083, deletions_count:  662},
		{sha: "d610ee18801f7306be49841b93ccc02aac926d75", date: "2020-02-26 19:09:59 +0000", description: "Upgrade rdkafka to 0.23.1", pr_number:                                                                                               1928, scopes: [], type:                                                     "chore", breaking_change:       false, author: "MOZGIII", files_count:            4, insertions_count:    94, deletions_count:    33},
		{sha: "271bcbd13d81e728b814d1273784147e5647a2b5", date: "2020-02-26 20:08:19 +0000", description: "Upgrade lib/file-source to futures 0.3", pr_number:                                                                                  1934, scopes: [], type:                                                     "chore", breaking_change:       false, author: "MOZGIII", files_count:            4, insertions_count:    14, deletions_count:    14},
		{sha: "0b92159518732a27837ca1142884ab9a7d34de84", date: "2020-02-26 20:35:49 +0000", description: "Rename futures to futures01", pr_number:                                                                                             1933, scopes: ["dependencies"], type:                                       "chore", breaking_change:       false, author: "MOZGIII", files_count:            87, insertions_count:   231, deletions_count:   229},
		{sha: "45b88d47ea8f01605d8e2e5ba7cf8f011f637853", date: "2020-02-26 12:07:44 +0000", description: "Rewrite to use HttpSink and JsonArrayBuffer", pr_number:                                                                             1925, scopes: ["gcp_pubsub sink"], type:                                    "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      1, insertions_count:    81, deletions_count:    114},
		{sha: "6b5a5e238f266286227695b488a4266f1fd73bba", date: "2020-02-26 15:01:18 +0000", description: "Allow transforms to implement `Stream`", pr_number:                                                                                  1938, scopes: ["topology"], type:                                           "chore", breaking_change:       false, author: "Lucio Franco", files_count:       2, insertions_count:    24, deletions_count:    8},
		{sha: "5df7c74c6206ddc33afe3c1840e62258bae9baf2", date: "2020-02-26 19:48:41 +0000", description: "Improve Vector README to clarify purpose and position", pr_number:                                                                   1943, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Binary Logic", files_count:       7, insertions_count:    216, deletions_count:   72},
		{sha: "c9a4fcfe9f9e3e042497a94259dc492dd62b3eef", date: "2020-02-27 11:32:48 +0000", description: "Add advanced configs guide", pr_number:                                                                                              1774, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Ashley Jeffs", files_count:       4, insertions_count:    182, deletions_count:   0},
		{sha: "b6d197a5b959ce45cd8a4c952c360bfa1c6c22c0", date: "2020-02-27 11:51:30 +0000", description: "Add docs for NixOS", pr_number:                                                                                                      1946, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Binary Logic", files_count:       14, insertions_count:   323, deletions_count:   2},
		{sha: "5e02ace8c08e9eb703b63908ada9a7663f686faa", date: "2020-02-28 09:27:46 +0000", description: "Increase test logs size", pr_number:                                                                                                 1949, scopes: ["tests"], type:                                              "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:    27, deletions_count:    22},
		{sha: "1fca6dcd0cd7f94785448128eb2f06d9dccc0bd4", date: "2020-02-28 08:35:00 +0000", description: "Default to `check_fields` condition when specifying conditions", pr_number:                                                          1947, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Ashley Jeffs", files_count:       18, insertions_count:   30, deletions_count:    41},
		{sha: "5ecbc2843ce8f61553943837782e296031b025e1", date: "2020-02-28 10:47:04 +0000", description: "Add `is_log` and `is_metric` conditions", pr_number:                                                                                 1950, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Ashley Jeffs", files_count:       8, insertions_count:    177, deletions_count:   15},
		{sha: "a2b1ef7479c3b49b9734be9dd0f9438ad343a478", date: "2020-02-28 10:30:59 +0000", description: "Add `--log-format` CLI option", pr_number:                                                                                           1908, scopes: ["cli"], type:                                                "feat", breaking_change:        false, author: "Lucio Franco", files_count:       4, insertions_count:    60, deletions_count:    14},
		{sha: "f07a3d22c9bba01612cc330abaff928df7dce8b2", date: "2020-02-28 19:01:49 +0000", description: "Create feature flags for all components enabling custom Vector builds", pr_number:                                                   1924, scopes: ["operations"], type:                                         "enhancement", breaking_change: false, author: "Alexander Rodin", files_count:    32, insertions_count:   619, deletions_count:   71},
		{sha: "fdae428c4b8aca0c748ba20ff08478062d327a4b", date: "2020-02-28 20:48:55 +0000", description: "Add TEST_LOG to test-stable CI job", pr_number:                                                                                      1937, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "MOZGIII", files_count:            2, insertions_count:    5, deletions_count:     0},
		{sha: "e4c83635166e777e53e4813448258c7fbcd6820a", date: "2020-02-28 13:03:15 +0000", description: "Check kube and docker code", pr_number:                                                                                              1914, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Lucio Franco", files_count:       2, insertions_count:    2, deletions_count:     2},
		{sha: "560fd106fc9a60c12ddf2c32e31ad4f2031ff1f5", date: "2020-02-28 21:55:08 +0000", description: "Upgrade to Rust 1.41.1", pr_number:                                                                                                  1958, scopes: ["dependencies"], type:                                       "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    1, deletions_count:     1},
		{sha: "1944ae977dd4143004434589ce4f27cb2714cbaf", date: "2020-03-02 18:34:25 +0000", description: "Initial `http` source implementation", pr_number:                                                                                    1650, scopes: ["new source"], type:                                         "feat", breaking_change:        false, author: "gedkins", files_count:            16, insertions_count:   887, deletions_count:   5},
		{sha: "e3cf8a7ef7712b054e0e37ca2caaa8e7933678ff", date: "2020-03-03 13:24:09 +0000", description: "Remove Google Analytics", pr_number:                                                                                                 1976, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Binary Logic", files_count:       1, insertions_count:    0, deletions_count:     3},
		{sha: "9d6c7e3288e013aedd672c7832b46e1291ea01ec", date: "2020-03-03 14:16:28 +0000", description: "Add Privacy Policy", pr_number:                                                                                                      1977, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       8, insertions_count:    95, deletions_count:    4},
		{sha: "8d93004cf95163695eb83778090c18369f7c3bf0", date: "2020-03-04 09:14:00 +0000", description: "Add `--fragment` flag to `generate` subcmd", pr_number:                                                                              1956, scopes: ["cli"], type:                                                "enhancement", breaking_change: false, author: "Ashley Jeffs", files_count:       1, insertions_count:    40, deletions_count:    12},
		{sha: "f81b205a82976e46a2dfe7e3f4422ae1563f51d7", date: "2020-03-04 09:14:51 +0000", description: "Allow names in `generate` subcmd expression", pr_number:                                                                             1955, scopes: ["cli"], type:                                                "enhancement", breaking_change: false, author: "Ashley Jeffs", files_count:       1, insertions_count:    65, deletions_count:    12},
		{sha: "f5663be4b0d90809ef9d73dc18d26844d82f500e", date: "2020-03-04 15:53:57 +0000", description: "Add `check-component-features` target to the main Makefile", pr_number:                                                              1981, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    3, deletions_count:     0},
		{sha: "b22e4d39a60b3e35e605d1f3997c32e14886853d", date: "2020-03-04 11:09:59 +0000", description: "Add TLS support", pr_number:                                                                                                         1968, scopes: ["logplex source", "splunk_hec source"], type:                "enhancement", breaking_change: false, author: "Lucio Franco", files_count:       15, insertions_count:   731, deletions_count:   196},
		{sha: "23968607e2382561e94b0f5f56b634bf02b046bd", date: "2020-03-04 18:36:16 +0000", description: "Add new `encoding.only_fields` and `encoding.except_fields` options", pr_number:                                                     1915, scopes: ["sinks"], type:                                              "enhancement", breaking_change: false, author: "Ana Hobden", files_count:         72, insertions_count:   4148, deletions_count:  652},
		{sha: "af7756389127cf51acdab175f67c573af6ef921d", date: "2020-03-05 12:48:59 +0000", description: "Add RFC process", pr_number:                                                                                                         1961, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       3, insertions_count:    140, deletions_count:   21},
		{sha: "9f793a7fc929a346ae726fce19efd7279b6f241e", date: "2020-03-06 10:40:32 +0000", description: "Move all TLS support over to openssl", pr_number:                                                                                    1986, scopes: ["networking"], type:                                         "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      36, insertions_count:   776, deletions_count:   374},
		{sha: "179801c8c09c06dd0759291815aca21a1ca794c5", date: "2020-03-07 00:49:04 +0000", description: "Describe dot notation in the docs", pr_number:                                                                                       1996, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Alexander Rodin", files_count:    3, insertions_count:    69, deletions_count:    8},
		{sha: "3beb67e10c355af2d7bb69bba2fc1b56ac11aa85", date: "2020-03-09 15:35:03 +0000", description: "Add `contains` and `prefix` predicates", pr_number:                                                                                  1997, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Ashley Jeffs", files_count:       5, insertions_count:    295, deletions_count:   4},
		{sha: "50a171b19ccb86a8f3559975e154033a627e8c3f", date: "2020-03-09 13:49:27 +0000", description: "Update examples to use inline TOML", pr_number:                                                                                      2004, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Binary Logic", files_count:       158, insertions_count:  3362, deletions_count:  2841},
		{sha: "eeffdb08cad3f0956a8ff6079aeb5a57ebf5220c", date: "2020-03-09 12:21:42 +0000", description: "Add support for compression", pr_number:                                                                                             1969, scopes: ["kafka sink"], type:                                         "feat", breaking_change:        false, author: "Bruce Guenter", files_count:      14, insertions_count:   172, deletions_count:   87},
		{sha: "c86708675d1356fcbc512ec15174bf12d842c121", date: "2020-03-09 17:57:39 +0000", description: "Cleanup field requirements", pr_number:                                                                                              2013, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Binary Logic", files_count:       98, insertions_count:   1908, deletions_count:  1882},
		{sha: "33c6345b1026021b5a94b932c42f20c97c66e8d8", date: "2020-03-09 21:07:19 +0000", description: "Fix examples and clarify nested behavior", pr_number:                                                                                1905, scopes: ["rename_fields transform"], type:                            "docs", breaking_change:        false, author: "Binary Logic", files_count:       31, insertions_count:   485, deletions_count:   221},
		{sha: "303ab5362eec135a5858c3caaa4f43f8f048a1b1", date: "2020-03-10 10:18:26 +0000", description: "Pull fresh containers on test", pr_number:                                                                                           2019, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Lucio Franco", files_count:       1, insertions_count:    1, deletions_count:     0},
		{sha: "aa523b00977c89a44d7cbb17e7e7d0bf3e179c1a", date: "2020-03-10 19:30:09 +0000", description: "Fix race condition in test", pr_number:                                                                                              2026, scopes: ["statsd sink"], type:                                        "chore", breaking_change:       false, author: "Lucio Franco", files_count:       1, insertions_count:    7, deletions_count:     0},
		{sha: "0eb5023fc3136d97fad0353ff74fc865b24be96e", date: "2020-03-10 22:10:08 +0000", description: "Refactor to use util/HttpSource", pr_number:                                                                                         2014, scopes: ["logplex source"], type:                                     "chore", breaking_change:       false, author: "Bill", files_count:               1, insertions_count:    70, deletions_count:    52},
		{sha: "532c048e8cbced42b2699b6120f0981eff73c58e", date: "2020-03-10 20:44:45 +0000", description: "Initial `dedupe` transform implementation", pr_number:                                                                               1848, scopes: ["new transform"], type:                                      "feat", breaking_change:        false, author: "Spencer T Brody", files_count:    15, insertions_count:   1108, deletions_count:  2},
		{sha: "b2d303d0f8c004dd0d9437c35f11eb9554bf4093", date: "2020-03-10 21:53:22 +0000", description: "Initial 'tag_cardinality_limit' transform implementation", pr_number:                                                                1959, scopes: ["new transform"], type:                                      "feat", breaking_change:        false, author: "Spencer T Brody", files_count:    14, insertions_count:   1066, deletions_count:  2},
		{sha: "dec0430fddf2a6603dc4d6fc08b2f45e7ccaa974", date: "2020-03-11 11:47:26 +0000", description: "Reshuffle timeout in test", pr_number:                                                                                               2035, scopes: ["statsd sink"], type:                                        "chore", breaking_change:       false, author: "Lucio Franco", files_count:       1, insertions_count:    8, deletions_count:     6},
		{sha: "0d9c2c98b8dfcb24ee08c0d0e536238208fe44dd", date: "2020-03-11 12:13:28 +0000", description: "Refactor internal http client", pr_number:                                                                                           2029, scopes: ["networking"], type:                                         "chore", breaking_change:       false, author: "Lucio Franco", files_count:       18, insertions_count:   490, deletions_count:   333},
		{sha: "6be3986d8d451f6630a679cd180d7434f706d66a", date: "2020-03-11 10:44:28 +0000", description: "Add support for TLS", pr_number:                                                                                                     2025, scopes: ["vector sink"], type:                                        "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      5, insertions_count:    322, deletions_count:   13},
		{sha: "8e4986d21497a0dcc2ad87e517df6a50feb23086", date: "2020-03-11 20:38:22 +0000", description: "Add PR checklist", pr_number:                                                                                                        2010, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       3, insertions_count:    29, deletions_count:    0},
		{sha: "1de3f2f2900c63390cde2a81a28c51ff6652ab7c", date: "2020-03-12 11:38:53 +0000", description: "Initial `papertrail` sink implementation", pr_number:                                                                                1835, scopes: ["new sink"], type:                                           "feat", breaking_change:        false, author: "Lucio Franco", files_count:       15, insertions_count:   773, deletions_count:   1},
		{sha: "f12df1571869a4014c39eff4b413555c0a54e05d", date: "2020-03-12 11:52:29 +0000", description: "Upgrade to rustc `1.42.0`", pr_number:                                                                                               2043, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Lucio Franco", files_count:       1, insertions_count:    1, deletions_count:     1},
		{sha: "9e5e20f1c7667d1a890e7effcb83ebf86881dd62", date: "2020-03-12 13:42:55 +0000", description: "Add markdown linting", pr_number:                                                                                                    2020, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       136, insertions_count:  4009, deletions_count:  1191},
		{sha: "31ee4126f750b1cd182baeab70fde05d88c139d9", date: "2020-03-12 14:02:30 +0000", description: "Add `timeout` query parameter", pr_number:                                                                                           2038, scopes: ["elasticsearch sink"], type:                                 "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      1, insertions_count:    2, deletions_count:     1},
		{sha: "4d5f36e2f9816b42591dc6f0fba4baa1f6f82d6f", date: "2020-03-12 14:03:30 +0000", description: "Rename `host_field` to `host_key`", pr_number:                                                                                       2037, scopes: ["splunk_hec sink"], type:                                    "chore", breaking_change:       true, author:  "Bruce Guenter", files_count:      4, insertions_count:    53, deletions_count:    9},
		{sha: "73ad2d1195fc14665cb3df2abe62fa9eb3c53112", date: "2020-03-12 14:43:28 +0000", description: "Fix the papertrail docs", pr_number:                                                                                                 2051, scopes: ["papertrail sink"], type:                                    "docs", breaking_change:        false, author: "Bruce Guenter", files_count:      1, insertions_count:    32, deletions_count:    5},
		{sha: "3f33a2d7943f483fc1806c26247c339fbec89fc6", date: "2020-03-12 16:44:31 +0000", description: "Check lockfile over cargo.toml", pr_number:                                                                                          2050, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Lucio Franco", files_count:       1, insertions_count:    1, deletions_count:     1},
		{sha: "18986f2af9eca178d422dc8eab7e66672c2a5337", date: "2020-03-12 17:41:38 +0000", description: "Re-run doc generation", pr_number:                                                                                                   2052, scopes: ["docs"], type:                                               "chore", breaking_change:       false, author: "Lucio Franco", files_count:       1, insertions_count:    5, deletions_count:     1},
		{sha: "23f9fa7cfa3621765b6ddcfb690cd0d2e1182bae", date: "2020-03-13 18:03:36 +0000", description: "Add `target` directory to `.markdownlintignore`", pr_number:                                                                         2054, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    1, deletions_count:     0},
		{sha: "122778d90ffb7644e6811543696c845a1fb0417d", date: "2020-03-13 09:44:02 +0000", description: "Add new `key_field` option", pr_number:                                                                                              2039, scopes: ["sampler transform"], type:                                  "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      6, insertions_count:    112, deletions_count:   16},
		{sha: "034790b921a763b2f78b1b220e415ca560fc0622", date: "2020-03-13 22:03:09 +0000", description: "Fix for \"download source code\" step in install from source", pr_number:                                                            2027, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Yuriy Vasiyarov", files_count:    2, insertions_count:    10, deletions_count:    22},
		{sha: "ffdbacb509d9057c74bbea0ae446f3fd7433a319", date: "2020-03-13 21:10:42 +0000", description: "Improve syslog source example", pr_number:                                                                                           2059, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Binary Logic", files_count:       2, insertions_count:    92, deletions_count:    14},
		{sha: "f3f8567876192202e60c5ac377b98b76a04aba49", date: "2020-03-14 14:27:59 +0000", description: "Fix `check-component-features` test", pr_number:                                                                                     2061, scopes: ["testing"], type:                                            "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    1, deletions_count:     1},
		{sha: "163e001ca0a9de48da31ffd1e4013fb13e6027e3", date: "2020-03-14 10:37:35 +0000", description: "Initial `honeycomb` sink implementation", pr_number:                                                                                 1847, scopes: ["new sink"], type:                                           "feat", breaking_change:        false, author: "Lucio Franco", files_count:       14, insertions_count:   1102, deletions_count:  1},
		{sha: "e4104549ee1c0bd56e3978adf458dfdd5c7c6506", date: "2020-03-16 10:24:29 +0000", description: "Force `symlink` re-evaluation when detecting a changed Vector config", pr_number:                                                    2034, scopes: ["config"], type:                                             "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count: 2, insertions_count:    67, deletions_count:    15},
		{sha: "874c0c079538ce39c8259e1ca477fab49d3acddd", date: "2020-03-16 15:12:43 +0000", description: "Add `version` configuration option", pr_number:                                                                                      2056, scopes: ["lua transform"], type:                                      "enhancement", breaking_change: false, author: "Alexander Rodin", files_count:    9, insertions_count:    755, deletions_count:   38},
		{sha: "606dedbb689c9480c3724df92040edf5217d1b8d", date: "2020-03-16 11:46:51 +0000", description: "Part 1 of `HttpSink` refactor", pr_number:                                                                                           2072, scopes: ["sinks"], type:                                              "chore", breaking_change:       false, author: "Lucio Franco", files_count:       5, insertions_count:    286, deletions_count:   290},
		{sha: "21405209c288ef78fe91ccdb4948b972b5d23b5a", date: "2020-03-16 12:23:29 +0000", description: "Ensure white-space dooes not break parsing", pr_number:                                                                              2060, scopes: ["json_parser transform"], type:                              "chore", breaking_change:       false, author: "Binary Logic", files_count:       1, insertions_count:    19, deletions_count:    0},
		{sha: "b237576ceb416a58ec85e8eaefc1b075ef7d1a52", date: "2020-03-16 20:00:01 +0000", description: "Fix insertion to arrays in field path notation", pr_number:                                                                          2062, scopes: ["transforms"], type:                                         "fix", breaking_change:         false, author: "Alexander Rodin", files_count:    2, insertions_count:    35, deletions_count:    7},
		{sha: "7ecec0efc404a326f93d315df07d49632d1bd752", date: "2020-03-16 20:17:20 +0000", description: "Support nested fields and arrays", pr_number:                                                                                        1936, scopes: ["merge transform"], type:                                    "fix", breaking_change:         false, author: "MOZGIII", files_count:            1, insertions_count:    90, deletions_count:    0},
		{sha: "e598e1f5cfa35171da0873e36e65e462f8260701", date: "2020-03-17 00:30:16 +0000", description: "Update tagline", pr_number:                                                                                                          2079, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       7, insertions_count:    9, deletions_count:     9},
		{sha: "c8a5e4f3631a9f483cfcfcb2f25c0d3de6480feb", date: "2020-03-17 14:48:09 +0000", description: "RFC #1999 - 2020-03-06 - API extensions for `lua` transform", pr_number:                                                             2000, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    702, deletions_count:   0},
		{sha: "7dacc02c954d55810e1cfed00e76745f23747f69", date: "2020-03-17 17:01:59 +0000", description: "Support escaping in the field path notation", pr_number:                                                                             2081, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Alexander Rodin", files_count:    3, insertions_count:    22, deletions_count:    0},
		{sha: "45a5cf7b96f39327f5a511d546518dbcb05eba7a", date: "2020-03-17 17:13:48 +0000", description: "Upgrade `regex` dependency", pr_number:                                                                                              2083, scopes: ["dependencies"], type:                                       "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    2, insertions_count:    5, deletions_count:     5},
		{sha: "d93c7240ecbcf0b338df60182c8909ab79d1367c", date: "2020-03-17 10:23:35 +0000", description: "Consolidate \"Configuration\" and \"Options\" sections", pr_number:                                                                  2085, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Binary Logic", files_count:       133, insertions_count:  301, deletions_count:   522},
		{sha: "b9483a9edbb7633ce6b6de2af427b48bef71dee6", date: "2020-03-17 10:26:05 +0000", description: "Upgrade dependencies", pr_number:                                                                                                    2086, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Binary Logic", files_count:       1, insertions_count:    94, deletions_count:    89},
		{sha: "dd55d9d51e2d3b5b12ac63cadd30613b946afa05", date: "2020-03-17 11:28:55 +0000", description: "Part 2 of `HttpSink` refactor", pr_number:                                                                                           2075, scopes: ["sinks"], type:                                              "chore", breaking_change:       false, author: "Lucio Franco", files_count:       3, insertions_count:    228, deletions_count:   212},
		{sha: "07c42a100ca147aef93fa72fdddaca4a2dafd51c", date: "2020-03-17 09:34:09 +0000", description: "Fix handling of message array data", pr_number:                                                                                      2053, scopes: ["journald source"], type:                                    "fix", breaking_change:         false, author: "Bruce Guenter", files_count:      3, insertions_count:    67, deletions_count:    22},
		{sha: "ff7b0fb416878ec40b163d2e2ee5aaf5464e3f15", date: "2020-03-17 19:46:47 +0000", description: "Use `--release` Cargo flag in `make build`", pr_number:                                                                              2087, scopes: ["setup"], type:                                              "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    2, deletions_count:     2},
		{sha: "56bad9d02543fa0861df5262afcb59b09f12580c", date: "2020-03-18 16:23:11 +0000", description: "Pin tag for `loki` Docker image", pr_number:                                                                                         2091, scopes: ["testing"], type:                                            "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    1, deletions_count:     1},
		{sha: "ccd3cf7f08fdad22ca5cbdacf4647e29b4b83798", date: "2020-03-19 02:02:55 +0000", description: "Switch to `tokio-compat` to start the transition to our new async runtime", pr_number:                                               1922, scopes: [], type:                                                     "chore", breaking_change:       false, author: "MOZGIII", files_count:            9, insertions_count:    117, deletions_count:   71},
		{sha: "e596cc1046496640ef6e4e38b58d5cb93cea5760", date: "2020-03-18 16:39:41 +0000", description: "Refactor source shutdown and make it two-phase", pr_number:                                                                          1994, scopes: ["topology"], type:                                           "chore", breaking_change:       false, author: "Spencer T Brody", files_count:    27, insertions_count:   875, deletions_count:   68},
		{sha: "b8f144527bda15e98e4e91d42d8ab6306169af85", date: "2020-03-19 18:12:52 +0000", description: "Add `*_flat` methods for log events", pr_number:                                                                                     2082, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    38, deletions_count:    0},
		{sha: "9716e0bbf8d401e53fbb08492f8fa27611a8d889", date: "2020-03-19 19:50:46 +0000", description: "Upgrade file sink for tokio-compat", pr_number:                                                                                      1988, scopes: ["file sink"], type:                                          "chore", breaking_change:       false, author: "MOZGIII", files_count:            12, insertions_count:   620, deletions_count:   478},
		{sha: "ba2ae6b9352c7499c6858a0257e3f8dd01bb522c", date: "2020-03-19 10:41:35 +0000", description: "Allow native TOML tables", pr_number:                                                                                                2068, scopes: ["add_fields transform"], type:                               "enhancement", breaking_change: false, author: "Ana Hobden", files_count:         3, insertions_count:    54, deletions_count:    50},
		{sha: "99bb140b345e7a1a51dfb2b3596cd9897c7721d2", date: "2020-03-19 22:40:58 +0000", description: "Correct doctest at src/stream.rs", pr_number:                                                                                        2097, scopes: [], type:                                                     "chore", breaking_change:       false, author: "MOZGIII", files_count:            1, insertions_count:    1, deletions_count:     1},
		{sha: "07343ac9d7ad06e9704e5a12b8d96c873a300162", date: "2020-03-19 23:30:59 +0000", description: "Upgrade console sink for tokio 0.2", pr_number:                                                                                      2096, scopes: ["console sink"], type:                                       "chore", breaking_change:       false, author: "MOZGIII", files_count:            8, insertions_count:    75, deletions_count:    34},
		{sha: "c8b47b3230a4b790d8cda0e47265771666581f98", date: "2020-03-19 23:13:15 +0000", description: "Initial `pulsar` sink implementation", pr_number:                                                                                    1665, scopes: ["new sink"], type:                                           "feat", breaking_change:        false, author: "Evan Cameron", files_count:       17, insertions_count:   914, deletions_count:   1},
		{sha: "c800c2c9b166dc78ade84dc22c152c1d0a0fff76", date: "2020-03-20 20:39:37 +0000", description: "Correct Cargo.lock", pr_number:                                                                                                      2105, scopes: [], type:                                                     "chore", breaking_change:       false, author: "MOZGIII", files_count:            1, insertions_count:    2, deletions_count:     2},
		{sha: "14c0a632ae09ce22cc3818c5f5ad9f09023571dc", date: "2020-03-20 11:56:59 +0000", description: "Add new `drop_empty` option to drop empty objects automatically", pr_number:                                                         2077, scopes: ["remove_fields transform", "rename_fields transform"], type: "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      11, insertions_count:   321, deletions_count:   48},
		{sha: "9d6be3193dfbb9624d9549137802a7abdde8c40a", date: "2020-03-20 21:33:38 +0000", description: "Fix `x86_64-pc-windows-msvc` build", pr_number:                                                                                      2103, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    2, insertions_count:    6, deletions_count:     4},
		{sha: "1d6928c28bbe0ca929bb00ff98d83dcdd3cf650c", date: "2020-03-20 21:40:09 +0000", description: "Name the time specifiers as `strftime` in the templating docs", pr_number:                                                           2107, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Alexander Rodin", files_count:    15, insertions_count:   22, deletions_count:    22},
		{sha: "838a80bd486e2112f05725d4306dc68b8e5a70c3", date: "2020-03-20 14:15:26 +0000", description: "Make RunningTopology::stop() signal all sources to shut down using the new ShutdownCoordinator (1091)", pr_number:                   2098, scopes: ["topology"], type:                                           "chore", breaking_change:       false, author: "Spencer T Brody", files_count:    6, insertions_count:    255, deletions_count:   157},
		{sha: "2675d77241d7c9d5f6b7203a7d4f95ca0a925991", date: "2020-03-23 20:02:15 +0000", description: "Racy buffering tests correction", pr_number:                                                                                         2106, scopes: [], type:                                                     "chore", breaking_change:       false, author: "MOZGIII", files_count:            5, insertions_count:    439, deletions_count:   298},
		{sha: "3e881bfa2dc6959928aedc0e64e576b86ed8f4b0", date: "2020-03-23 13:50:48 +0000", description: "Initial `datadog_logs` sink implementation", pr_number:                                                                              1832, scopes: ["new sink"], type:                                           "feat", breaking_change:        false, author: "Lucio Franco", files_count:       16, insertions_count:   1082, deletions_count:  7},
		{sha: "ce7bdbaf7155c74f1a4f2e9fd5d50d2c3a92899f", date: "2020-03-23 14:05:42 +0000", description: "Add test harness GH action", pr_number:                                                                                              2028, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Binary Logic", files_count:       2, insertions_count:    142, deletions_count:   0},
		{sha: "9be091bc2497b9df5af948d6d13ed952fe454477", date: "2020-03-23 13:21:20 +0000", description: "TLS reorganization", pr_number:                                                                                                      2101, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      17, insertions_count:   586, deletions_count:   473},
		{sha: "f1bb0c65d5230ea03905cf3741fa11f3ec281b47", date: "2020-03-23 14:53:16 +0000", description: "Rename `gcp_stackdriver_logging` sink to `gcp_stackdriver_logs`", pr_number:                                                         2121, scopes: ["gcp_stackdrive_logging sink"], type:                        "fix", breaking_change:         true, author:  "Bruce Guenter", files_count:      12, insertions_count:   55, deletions_count:    55},
		{sha: "ff4a6dccefc16f56910d49b996f797ef75de1759", date: "2020-03-24 16:28:51 +0000", description: "Support metric events in version 2", pr_number:                                                                                      2095, scopes: ["lua transform"], type:                                      "enhancement", breaking_change: false, author: "Alexander Rodin", files_count:    11, insertions_count:   1254, deletions_count:  130},
		{sha: "0088ebd712f97906bbf6894f0165385cf59a535b", date: "2020-03-24 10:25:29 +0000", description: "Revert \"Use MaybeTlsListener in TcpSource\"", pr_number:                                                                            2129, scopes: ["networking"], type:                                         "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      3, insertions_count:    62, deletions_count:    47},
		{sha: "6edfbc9e7b498bdade9e52d5462b260f50f83792", date: "2020-03-24 13:40:29 +0000", description: "Make LogSchema more optional", pr_number:                                                                                            2113, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Ana Hobden", files_count:         15, insertions_count:   92, deletions_count:    65},
		{sha: "25e76f7e0590fa23d4efd17483949f5df80ca83b", date: "2020-03-24 17:11:33 +0000", description: "Add `User-agent` header to all outgoing HTTP requests", pr_number:                                                                   2130, scopes: ["networking"], type:                                         "enhancement", breaking_change: false, author: "Lucio Franco", files_count:       1, insertions_count:    11, deletions_count:    7},
		{sha: "2121b7dfa3cdaa342e8a7dbcafb8e3531c36f875", date: "2020-03-25 01:59:52 +0000", description: "Rename tokio -> tokio01 and tokio02 -> tokio", pr_number:                                                                            2131, scopes: ["dependencies"], type:                                       "chore", breaking_change:       false, author: "MOZGIII", files_count:            50, insertions_count:   76, deletions_count:    78},
		{sha: "2671cb5f82a89cea1c9d081c3051aa7123017a85", date: "2020-03-24 21:08:00 +0000", description: "Relax PR check list to only fire on important changes", pr_number:                                                                   2136, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Binary Logic", files_count:       1, insertions_count:    0, deletions_count:     6},
		{sha: "fe2e12ce89bc69657851a7a8f4dfeb3b4d334dc8", date: "2020-03-25 16:31:59 +0000", description: "Add new `index` option to specify custom Splunk indexes", pr_number:                                                                 2127, scopes: ["splunk_hec sink"], type:                                    "enhancement", breaking_change: false, author: "Alexander Rodin", files_count:    5, insertions_count:    100, deletions_count:   7},
		{sha: "7ab9df34cdc8e7d0d6155bfbbd58aff61cfaad64", date: "2020-03-25 20:07:09 +0000", description: "Update `bumpalo` dependency in `Cargo.lock`", pr_number:                                                                             2141, scopes: ["dependencies"], type:                                       "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    2, deletions_count:     2},
		{sha: "6443f9c7a6b376d662a2a59b59c433209c9eb872", date: "2020-03-25 12:46:54 +0000", description: "Fix handling of incoming TLS connections", pr_number:                                                                                2146, scopes: ["networking"], type:                                         "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      7, insertions_count:    205, deletions_count:   136},
		{sha: "113bb800937be0f240b92fe95396a9740e7fbb15", date: "2020-03-25 12:31:40 +0000", description: "The `add_fields`, `remove_fields`, and `rename_fields` now produce a debug log when a field is replaced or non-existent", pr_number: 2148, scopes: ["observability"], type:                                      "enhancement", breaking_change: false, author: "Ana Hobden", files_count:         17, insertions_count:   102, deletions_count:   42},
		{sha: "fc19c12027ebaf97764b5538c04e52974381b574", date: "2020-03-25 20:18:54 +0000", description: "Simplify domains for labels, etc", pr_number:                                                                                        2152, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       4, insertions_count:    17, deletions_count:    53},
		{sha: "0a5eccd17973dba291423ae3e151706aa82e1e7e", date: "2020-03-26 17:42:42 +0000", description: "Upstream github-script action at test harness workflow", pr_number:                                                                  2157, scopes: [], type:                                                     "chore", breaking_change:       false, author: "MOZGIII", files_count:            1, insertions_count:    2, deletions_count:     2},
		{sha: "a8ed1f7aa62266bd051c120d5f06cd4c105f8709", date: "2020-03-26 21:09:49 +0000", description: "Switch to upstream repo-permission-check-action", pr_number:                                                                         2158, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "MOZGIII", files_count:            1, insertions_count:    1, deletions_count:     1},
		{sha: "16c714e190f9711810194bf9fd3f48c5730aec2f", date: "2020-03-27 00:13:46 +0000", description: "Add LogEvent::new", pr_number:                                                                                                       2154, scopes: [], type:                                                     "chore", breaking_change:       false, author: "MOZGIII", files_count:            6, insertions_count:    34, deletions_count:    38},
		{sha: "3cb486531d49e1702ea6bbf20c619c3d3476201a", date: "2020-03-27 12:26:47 +0000", description: "Increase default rate limit to allow for higher throughput", pr_number:                                                              2161, scopes: ["aws_s3 sink"], type:                                        "enhancement", breaking_change: false, author: "Lucio Franco", files_count:       4, insertions_count:    14, deletions_count:    14},
		{sha: "068f289ffca61e5631237760c88deaf90ca0ab24", date: "2020-03-27 10:49:02 +0000", description: "Add support for UDP mode", pr_number:                                                                                                2162, scopes: ["socket sink"], type:                                        "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      8, insertions_count:    304, deletions_count:   40},
		{sha: "53ae00b610a526050a6f90121d91c3b100a386f7", date: "2020-03-27 15:58:49 +0000", description: "Remove package managers from install script", pr_number:                                                                             2165, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       1, insertions_count:    5, deletions_count:     118},
		{sha: "de932f7f2a345923476bbaef1cbd44d91ce06870", date: "2020-03-27 22:59:40 +0000", description: "Support ARM architectures in the install script", pr_number:                                                                         2167, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    6, deletions_count:     0},
		{sha: "f2f9b269d9f9dfe9b1d2af60821711c4c101cdd9", date: "2020-03-28 19:08:04 +0000", description: "Make config on the main page pass `vector validate`", pr_number:                                                                     2168, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Alexander Rodin", files_count:    1, insertions_count:    6, deletions_count:     5},
		{sha: "49cac24a70f5530507bf50d977edbcecc9df2c4f", date: "2020-03-28 20:32:11 +0000", description: "Disable duplicated version output in `make version`", pr_number:                                                                     2169, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    0, deletions_count:     1},
		{sha: "402e8c3ae0af6bbafa18aea729d684bca78f61cd", date: "2020-03-29 19:52:23 +0000", description: "Enable Kubernetes tests", pr_number:                                                                                                 1970, scopes: ["tests"], type:                                              "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 9, insertions_count:    215, deletions_count:   8},
		{sha: "686919a34b89a295185ce5326855eb2534cd523c", date: "2020-03-30 16:56:55 +0000", description: "Use `UTC` instead of `Europe/London` in ClickHouse tests", pr_number:                                                                2178, scopes: ["tests"], type:                                              "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    2, deletions_count:     2},
		{sha: "9b5dd8b48ae4ce4930cac0328cd11ad48ad89e57", date: "2020-03-30 10:20:08 +0000", description: "Add support for `tls.verify_hostname` in HTTP based sinks", pr_number:                                                               2164, scopes: ["networking"], type:                                         "enhancement", breaking_change: false, author: "Lucio Franco", files_count:       15, insertions_count:   251, deletions_count:   9},
		{sha: "8ac0fdebcbacf04a6bf72a3314f414520ef306b2", date: "2020-03-30 10:46:59 +0000", description: "Add `have: *` labels", pr_number:                                                                                                    2179, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       2, insertions_count:    112, deletions_count:   0},
		{sha: "7b2ff837cf550f3721b8b187432d9e33229d7ea1", date: "2020-03-30 11:17:11 +0000", description: "Rename `prefix` condition predicate to `starts_with`", pr_number:                                                                    2181, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      5, insertions_count:    71, deletions_count:    21},
		{sha: "e06aff56ac8cd7f041795262a812b74552bb96c7", date: "2020-03-31 09:05:05 +0000", description: "Add new `ends_with` condition predicate", pr_number:                                                                                 2183, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      5, insertions_count:    150, deletions_count:   0},
		{sha: "9b2d89572e54988a339c51bb26a47fb6205286e2", date: "2020-03-31 13:33:44 +0000", description: "Add new guides section", pr_number:                                                                                                  2132, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Binary Logic", files_count:       1118, insertions_count: 74832, deletions_count: 6156},
		{sha: "1525ef63c32884069ddb782e1397cbb6892dc0b9", date: "2020-03-31 17:27:41 +0000", description: "Check for and log partial ingestion failures", pr_number:                                                                            2185, scopes: ["elasticsearch sink"], type:                                 "feat", breaking_change:        false, author: "Bruce Guenter", files_count:      2, insertions_count:    180, deletions_count:   44},
		{sha: "2463e1330237d98e0f111c796724423010b6b222", date: "2020-03-31 18:08:24 +0000", description: "Initial `filter` transform implementation", pr_number:                                                                               2088, scopes: ["new transform"], type:                                      "feat", breaking_change:        false, author: "Bruce Guenter", files_count:      21, insertions_count:   686, deletions_count:   22},
		{sha: "ef86f521a4cf3dc63ae33902e3a43fb2e30c261d", date: "2020-04-01 08:26:38 +0000", description: "Deprecate in favor of the new `filter` transform", pr_number:                                                                        2195, scopes: ["field_filter transform"], type:                             "enhancement", breaking_change: false, author: "Binary Logic", files_count:       13, insertions_count:   12, deletions_count:    326},
		{sha: "a73222e591eabf3e95a0467712bcdaf2855fae99", date: "2020-04-01 10:29:17 +0000", description: "Update to Docusaurus 2.0.0-alpha.49", pr_number:                                                                                     2196, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Binary Logic", files_count:       443, insertions_count:  1681, deletions_count:  2029},
		{sha: "a2ea56c9cb152d458a14f562ada6c04f126b3ebc", date: "2020-04-01 13:15:20 +0000", description: "Refactor internal sinks and simplify", pr_number:                                                                                    2111, scopes: ["sinks"], type:                                              "chore", breaking_change:       false, author: "Lucio Franco", files_count:       38, insertions_count:   1748, deletions_count:  1245},
		{sha: "9add2cbe5357167393c4c8bb0b73a1377d58acda", date: "2020-04-01 19:41:57 +0000", description: "Inital `kubernetes_pod_metadata` transform implementation", pr_number:                                                               1888, scopes: ["new transform"], type:                                      "feat", breaking_change:        false, author: "Kruno Tomola Fabro", files_count: 109, insertions_count:  2229, deletions_count:  2696},
		{sha: "9b8ba8edf4f857e0305eb1157bb0a6e8fe56490e", date: "2020-04-01 14:24:12 +0000", description: "Add new `regex` condition predicate", pr_number:                                                                                     2198, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      8, insertions_count:    223, deletions_count:   4},
		{sha: "029c0bf6cd0359f08bc7cef99eb4ca6502a52252", date: "2020-04-01 14:25:13 +0000", description: "Warn that old `field_filter` transform is deprecated", pr_number:                                                                    2197, scopes: ["observability"], type:                                      "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      1, insertions_count:    4, deletions_count:     0},
		{sha: "ddd54782d5eeac8f91c7841a3cb29d66ab169e95", date: "2020-04-01 14:37:04 +0000", description: "Add new `target_field` option", pr_number:                                                                                           2023, scopes: ["regex_parser transform"], type:                             "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      5, insertions_count:    289, deletions_count:   79},
		{sha: "dd9e328faf7b41269cd87ce45b668c1dcd610f92", date: "2020-04-02 00:13:22 +0000", description: "Rename map_values_array to array_values_insertion_order test at discriminant", pr_number:                                            2140, scopes: ["testing"], type:                                            "chore", breaking_change:       false, author: "MOZGIII", files_count:            1, insertions_count:    1, deletions_count:     1},
		{sha: "45f3c09bc8bad8e05429b9c86eab5c34ed8f5928", date: "2020-04-01 18:36:57 +0000", description: "add event-driven observability rfc", pr_number:                                                                                      2093, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Luke Steensen", files_count:      1, insertions_count:    275, deletions_count:   0},
		{sha: "f26b0add310476ad58eb80fcb43e240737fdb617", date: "2020-04-02 09:56:34 +0000", description: "Fix `make generate` command", pr_number:                                                                                             2205, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Binary Logic", files_count:       2, insertions_count:    1, deletions_count:     2},
		{sha: "490f984763c33cf38d0b39545c8354109da22e38", date: "2020-04-02 10:44:15 +0000", description: "Add missing `compression` option and…", pr_number:                                                                                   2206, scopes: ["elasticsearch sink"], type:                                 "docs", breaking_change:        false, author: "Binary Logic", files_count:       6, insertions_count:    159, deletions_count:   30},
		{sha: "6d17361cadccafb470083cbd54ee84d68129b8ed", date: "2020-04-02 11:56:52 +0000", description: "Improve Windows Makefile support", pr_number:                                                                                        2150, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Ana Hobden", files_count:         1, insertions_count:    12, deletions_count:    4},
		{sha: "c38aeb298e47d34cc4b19af290fb8d6b46589c91", date: "2020-04-02 23:26:59 +0000", description: "Lift the internal thread limit to enable full concurrency", pr_number:                                                               2145, scopes: [], type:                                                     "perf", breaking_change:        false, author: "MOZGIII", files_count:            1, insertions_count:    4, deletions_count:     5},
		{sha: "5ec77297736c14b291d7b18bc425cf91fd8629e8", date: "2020-04-02 21:54:54 +0000", description: "minor fixes in Loki sink documentation", pr_number:                                                                                  2211, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Brad Fritz", files_count:         2, insertions_count:    10, deletions_count:    10},
		{sha: "1136cb5af597e10b6387c75451ee477c4aca45d4", date: "2020-04-02 22:03:26 +0000", description: "fix \"issie\" typo", pr_number:                                                                                                      2212, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Brad Fritz", files_count:         20, insertions_count:   38, deletions_count:    38},
		{sha: "b3450b3be8775a830bac9e734c1bbb37820adf6a", date: "2020-04-03 09:27:55 +0000", description: "Detect TCP disconnects earlier", pr_number:                                                                                          2209, scopes: ["networking"], type:                                         "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      2, insertions_count:    52, deletions_count:    15},
		{sha: "8d110c0a03edb5faf02a8be8854d1a77148daee9", date: "2020-04-03 10:55:15 +0000", description: "disable flaky test", pr_number:                                                                                                      2215, scopes: ["topology"], type:                                           "chore", breaking_change:       false, author: "Luke Steensen", files_count:      1, insertions_count:    1, deletions_count:     0},
		{sha: "1d31f2bc76b20cd0da7ebc1b4838e8014078b061", date: "2020-04-03 20:43:35 +0000", description: "Fix disk pressure ", pr_number:                                                                                                      2217, scopes: ["tests"], type:                                              "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:    2, deletions_count:     2},
		{sha: "eb60ce21c16514c039e5ffe59edc24c5291ca752", date: "2020-04-05 09:56:35 +0000", description: "Fix sitemap URLs and CSS layouts", pr_number:                                                                                        2229, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Binary Logic", files_count:       36, insertions_count:   753, deletions_count:   424},
		{sha: "906d6db0177ecfdb27020d0a85bcf4b65e43ee57", date: "2020-04-05 11:54:15 +0000", description: "RPM for aarch64 was using armv7", pr_number:                                                                                         2220, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Brad Fritz", files_count:         1, insertions_count:    1, deletions_count:     1},
		{sha: "e0a2451787fcca948cbc27fb0e25482a5ababa96", date: "2020-04-05 12:28:19 +0000", description: "Default `compression` to `none`", pr_number:                                                                                         2219, scopes: ["elasticsearch sink"], type:                                 "fix", breaking_change:         true, author:  "Bruce Guenter", files_count:      154, insertions_count:  1651, deletions_count:  90},
		{sha: "30808b5d3bd6b2bde6aed454a61ee36642473262", date: "2020-04-06 15:06:48 +0000", description: "Add field tests", pr_number:                                                                                                         2213, scopes: ["kubernetes_pod_metadata transform"], type:                  "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 2, insertions_count:    135, deletions_count:   20},
		{sha: "22cff2e9b74f60ef5e2e486576e7f695695076b8", date: "2020-04-06 20:18:28 +0000", description: "Add `-qqq` command line flag to disable logs", pr_number:                                                                            2230, scopes: ["cli"], type:                                                "feat", breaking_change:        false, author: "Felix", files_count:              3, insertions_count:    20, deletions_count:    15},
		{sha: "23d2ef5229a5a6979c0174e573960d3a1e101392", date: "2020-04-06 15:00:24 +0000", description: "Add basic module docs", pr_number:                                                                                                   2233, scopes: ["topology"], type:                                           "chore", breaking_change:       false, author: "Lucio Franco", files_count:       1, insertions_count:    8, deletions_count:     0},
		{sha: "130df3199139bfa84648d235ed34a0c292f2cfa8", date: "2020-04-06 15:47:59 +0000", description: "Pass `tls` settings to healthcheck", pr_number:                                                                                      2234, scopes: ["loki sink"], type:                                          "fix", breaking_change:         false, author: "Lucio Franco", files_count:       1, insertions_count:    2, deletions_count:     1},
		{sha: "6dde571f89638ecc28f5c633415febff0729e198", date: "2020-04-06 23:16:43 +0000", description: "Don't use `buildx` plugin by default", pr_number:                                                                                    2239, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    3, insertions_count:    25, deletions_count:    13},
		{sha: "7d9ebc3d580eff9d12f31563306d0d8bf3285248", date: "2020-04-06 16:38:58 +0000", description: "Add verify cert notes", pr_number:                                                                                                   2240, scopes: ["security"], type:                                           "docs", breaking_change:        false, author: "Lucio Franco", files_count:       31, insertions_count:   216, deletions_count:   54},
		{sha: "5890e2468e1d4c2a48e02c7d5235e9b9f65a29fc", date: "2020-04-07 10:22:18 +0000", description: "Pass `tls` settings to healthcheck", pr_number:                                                                                      2238, scopes: ["influxdb_metrics sink"], type:                              "fix", breaking_change:         false, author: "Lucio Franco", files_count:       1, insertions_count:    21, deletions_count:    11},
		{sha: "0d0a8fab60439834e6be155f4c0b616bfd77faec", date: "2020-04-07 18:34:59 +0000", description: "Implement all hooks and timers in version 2 ", pr_number:                                                                            2126, scopes: ["lua transform"], type:                                      "enhancement", breaking_change: false, author: "Alexander Rodin", files_count:    85, insertions_count:   5940, deletions_count:  4060},
		{sha: "2f803293dbbe793c4a849b344feb5e4ae6d52e1b", date: "2020-04-07 20:53:16 +0000", description: "Support metric events", pr_number:                                                                                                   2245, scopes: ["vector source", "vector sink"], type:                       "enhancement", breaking_change: false, author: "Alexander Rodin", files_count:    6, insertions_count:    28, deletions_count:    13},
		{sha: "e4c383881b7727289a87327fcd081b1f366952a6", date: "2020-04-07 21:48:50 +0000", description: "Fix link to the Docker platform on the main page", pr_number:                                                                        2249, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    1, deletions_count:     1},
		{sha: "11a898c824ca2955c75a4d58e87081bfb4bb2f2e", date: "2020-04-07 22:23:19 +0000", description: "Document default value for `acl`", pr_number:                                                                                        2252, scopes: ["gcp_cloud_storage sink"], type:                             "docs", breaking_change:        false, author: "Alexander Rodin", files_count:    3, insertions_count:    5, deletions_count:     4},
		{sha: "230cd45552021ea499d47d6b39f74730dbdc2a40", date: "2020-04-07 15:31:22 +0000", description: "Improve `logfmt_parser` docs and examples", pr_number:                                                                               2251, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Binary Logic", files_count:       25, insertions_count:   834, deletions_count:   525},
		{sha: "febbdfb39546c15a430b808226a03ad5a5bc41ec", date: "2020-04-07 22:58:54 +0000", description: "Use external tagging for metrics serialization", pr_number:                                                                          2231, scopes: ["ux"], type:                                                 "enhancement", breaking_change: true, author:  "Alexander Rodin", files_count:    7, insertions_count:    183, deletions_count:   232},
		{sha: "a9efeb9c8a45209c0fb64f0d043500a19f41fa7f", date: "2020-04-08 17:10:31 +0000", description: "Use cat with heredoc instead of echo and quotes", pr_number:                                                                         2262, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "MOZGIII", files_count:            1, insertions_count:    1, deletions_count:     1},
		{sha: "f9c4b4ba1282d7cd4cc3b773305e611beac7a99f", date: "2020-04-08 16:19:14 +0000", description: "Add `source_key` and `source_type_key` to…", pr_number:                                                                              2244, scopes: ["config"], type:                                             "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 6, insertions_count:    198, deletions_count:   2},
		{sha: "6b7cc0cf1009ecb1c62c7d1458945203a9ea5f48", date: "2020-04-08 22:52:35 +0000", description: "Use kebab case for ACL encoding", pr_number:                                                                                         2259, scopes: ["gcp_cloud_storage sink"], type:                             "fix", breaking_change:         false, author: "Alexander Rodin", files_count:    1, insertions_count:    1, deletions_count:     1},
		{sha: "5111f3a5b522fa06ca2ddf321e668246a78dc9fa", date: "2020-04-08 15:23:05 +0000", description: "Initial `internal` metrics source implementation", pr_number:                                                                        1953, scopes: ["new source"], type:                                         "feat", breaking_change:        false, author: "Luke Steensen", files_count:      38, insertions_count:   1332, deletions_count:  654},
		{sha: "308351a572c5e881454c6d73b8a9d6c92eac9a9e", date: "2020-04-08 16:42:27 +0000", description: "Accept metrics as input", pr_number:                                                                                                 2267, scopes: ["filter transform"], type:                                   "enhancement", breaking_change: false, author: "Binary Logic", files_count:       6, insertions_count:    34, deletions_count:    15},
		{sha: "04e2bf3abef0af3a9398f6c97f917c3658fd993f", date: "2020-04-08 23:54:49 +0000", description: "Fix healthchecks", pr_number:                                                                                                        2276, scopes: ["aws_kinesis_firehose sink"], type:                          "fix", breaking_change:         false, author: "Alexander Rodin", files_count:    1, insertions_count:    13, deletions_count:    16},
		{sha: "162e064e6c57c7b38d010893c041728ba40adb0a", date: "2020-04-08 18:53:35 +0000", description: "Only run required requests based on the supplied `fields`", pr_number:                                                               2265, scopes: ["aws_ec2_metadata transform"], type:                         "fix", breaking_change:         false, author: "Lucio Franco", files_count:       1, insertions_count:    35, deletions_count:    48},
		{sha: "e9192ad2b2755c3bd1ee59f6b13f255ac4efd8f3", date: "2020-04-09 12:40:00 +0000", description: "Set `search_dirs` to config dirs by default", pr_number:                                                                             2274, scopes: ["lua transform"], type:                                      "enhancement", breaking_change: true, author:  "Alexander Rodin", files_count:    7, insertions_count:    42, deletions_count:    13},
		{sha: "90f55ff7ae3222c05971482b72c4715d29a83ac9", date: "2020-04-09 14:19:17 +0000", description: "Add blog post on how we test vector", pr_number:                                                                                     1363, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Luke Steensen", files_count:      14, insertions_count:   492, deletions_count:   19},
		{sha: "0b1ca4efe31e04d2c7c4e61e40112833dc3eb372", date: "2020-04-09 15:12:30 +0000", description: "Make ACL optional", pr_number:                                                                                                       2283, scopes: ["gcp_cloud_storage sink"], type:                             "enhancement", breaking_change: true, author:  "Bruce Guenter", files_count:      4, insertions_count:    18, deletions_count:    12},
		{sha: "6d4d3b48b1563ef30f312eb7e2a4ef4f9df84652", date: "2020-04-10 09:41:25 +0000", description: "Add elegant shutdown behavior", pr_number:                                                                                           2260, scopes: ["docker source"], type:                                      "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:    14, deletions_count:    5},
		{sha: "5f78ebb7c3e21f878859b72dff6450c45c7359dc", date: "2020-04-10 13:13:35 +0000", description: "Make `RuntimeTransform` trait available for all transforms", pr_number:                                                              2281, scopes: ["transforms"], type:                                         "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    4, insertions_count:    13, deletions_count:    8},
		{sha: "e0805cc76343a218ed610f84c174a184f39098e8", date: "2020-04-10 09:01:14 +0000", description: "correct typo in testing post", pr_number:                                                                                            2291, scopes: ["website"], type:                                            "fix", breaking_change:         false, author: "Luke Steensen", files_count:      2, insertions_count:    5, deletions_count:     5},
		{sha: "eb3e71e53699bbd8de90018c4dc0f803048a4178", date: "2020-04-10 11:02:44 +0000", description: "small fixes for testing post", pr_number:                                                                                            2292, scopes: ["website"], type:                                            "fix", breaking_change:         false, author: "Luke Steensen", files_count:      5, insertions_count:    8, deletions_count:     7},
		{sha: "a85197d8a1dfeee7b705dd996516510d4dd60431", date: "2020-04-10 14:16:16 +0000", description: "Run healthcheck in rt context", pr_number:                                                                                           2288, scopes: ["kafka sink"], type:                                         "fix", breaking_change:         false, author: "Lucio Franco", files_count:       3, insertions_count:    45, deletions_count:    7},
		{sha: "b6e53d52249370e8b5bd4006fca674c3c99b8302", date: "2020-04-10 17:49:22 +0000", description: "Start removing Atom from the hot path", pr_number:                                                                                   2295, scopes: [], type:                                                     "perf", breaking_change:        false, author: "Luke Steensen", files_count:      17, insertions_count:   92, deletions_count:    98},
		{sha: "9d97e1ea53a24fcba4dda28406a48b642a42db09", date: "2020-04-11 02:32:14 +0000", description: "Add a CSV parsing guide", pr_number:                                                                                                 2285, scopes: ["lua transform"], type:                                      "docs", breaking_change:        false, author: "Alexander Rodin", files_count:    8, insertions_count:    588, deletions_count:   1},
		{sha: "b477981125866e6d3467cd12214e5049285c89b4", date: "2020-04-11 23:21:27 +0000", description: "Add fast path and caching api to event insert", pr_number:                                                                           2296, scopes: [], type:                                                     "perf", breaking_change:        false, author: "Luke Steensen", files_count:      5, insertions_count:    67, deletions_count:    13},
		{sha: "bc48a21e95a9802a5cf57326b4be1c383c567e27", date: "2020-04-13 15:26:12 +0000", description: "Enable Rust codegen LTO for test harness", pr_number:                                                                                2310, scopes: ["tests"], type:                                              "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    1, deletions_count:     1},
		{sha: "e4d012df9210a22fe95729f8f98127e8cb050ece", date: "2020-04-13 13:26:56 +0000", description: "Upgrade http client to hyper 0.13", pr_number:                                                                                       2294, scopes: ["networking"], type:                                         "chore", breaking_change:       false, author: "Lucio Franco", files_count:       6, insertions_count:    582, deletions_count:   25},
		{sha: "23f1781f39d98315106455309a3251aaa88eeff0", date: "2020-04-13 14:15:47 +0000", description: "Fix Windows metrics", pr_number:                                                                                                     2309, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Ana Hobden", files_count:         1, insertions_count:    0, deletions_count:     1},
		{sha: "dfe4620245bffddc066ccfe47a4ab9d70e6d9649", date: "2020-04-14 13:20:55 +0000", description: "Add `source_type` field", pr_number:                                                                                                 2298, scopes: ["sources"], type:                                            "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 17, insertions_count:   213, deletions_count:   7},
		{sha: "fb8ae10f193c1990259500941ddd90f01472063e", date: "2020-04-14 19:11:17 +0000", description: "Add `lto = true` and `codegen-units=1` to `Cargo.toml`", pr_number:                                                                  2321, scopes: [], type:                                                     "perf", breaking_change:        false, author: "Alexander Rodin", files_count:    4, insertions_count:    5, deletions_count:     22},
		{sha: "e8723f5eda7cbf0986b8f4b45c9ac394ef2b6f3b", date: "2020-04-14 19:44:31 +0000", description: "Sort events by timestamp", pr_number:                                                                                                2320, scopes: ["aws_cloudwatch_logs sink"], type:                           "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count: 2, insertions_count:    78, deletions_count:    2},
		{sha: "5d7421f07080bfd7e7563ebb326f4b0281d65508", date: "2020-04-14 20:50:16 +0000", description: "Add /highlights section and rework release notes", pr_number:                                                                        2317, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Binary Logic", files_count:       302, insertions_count:  7552, deletions_count:  3485},
		{sha: "1b4c0014247e69aec6761e544bfae6cd29f6acae", date: "2020-04-15 06:32:47 +0000", description: "Wire ShutdownSignal in `trait HttpSource`", pr_number:                                                                               2290, scopes: ["sources"], type:                                            "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 3, insertions_count:    15, deletions_count:    16},
		{sha: "b43fdecfed76081b86cf2d04a933787d33bd5455", date: "2020-04-15 06:35:56 +0000", description: "Show possible values for `--log-format`, `--color`, and `--format`", pr_number:                                                      2300, scopes: ["cli"], type:                                                "enhancement", breaking_change: false, author: "Felix", files_count:              4, insertions_count:    47, deletions_count:    23},
		{sha: "6cb49ce04aefe69dfdac6e489001990a31c7343a", date: "2020-04-15 07:36:24 +0000", description: "Clarify dependencies of the `package-*` job in `make hel…", pr_number:                                                               2324, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    2, deletions_count:     2},
		{sha: "36892068ca48b470f6a16f35e1a57753074f32ca", date: "2020-04-15 06:41:11 +0000", description: "Remove `log_schema.source_key`", pr_number:                                                                                          2297, scopes: ["config"], type:                                             "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 7, insertions_count:    2, deletions_count:     112},
		{sha: "e2eb9e7da20337e3522e9f4ad5ca9b049e8c26e2", date: "2020-04-14 21:41:47 +0000", description: "Add Twitter author tags", pr_number:                                                                                                 2299, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Ana Hobden", files_count:         1, insertions_count:    6, deletions_count:     0},
		{sha: "b152b53e8ec709c0ff9eb64e64d0f8b9a4cb0441", date: "2020-04-15 18:21:52 +0000", description: "Improve topology shutdown logs", pr_number:                                                                                          2345, scopes: ["topology"], type:                                           "enhancement", breaking_change: false, author: "Lucio Franco", files_count:       1, insertions_count:    13, deletions_count:    2},
		{sha: "de0d6f6c4e6c23f4fea460835b22d7ecc175fde4", date: "2020-04-15 18:42:27 +0000", description: "Reduce credentials fetch timeout", pr_number:                                                                                        2342, scopes: ["sinks"], type:                                              "fix", breaking_change:         false, author: "Lucio Franco", files_count:       1, insertions_count:    13, deletions_count:    6},
		{sha: "148abb54c4b62c375369f96e33f8f0bfea620c41", date: "2020-04-16 16:29:15 +0000", description: "Don't require `isdst`, `wday`, `yday` in timestamps", pr_number:                                                                     2335, scopes: ["lua transform"], type:                                      "fix", breaking_change:         false, author: "Alexander Rodin", files_count:    1, insertions_count:    1, deletions_count:     3},
		{sha: "60385ec2dd58ecbb8d449dea50981dd9afc3f84e", date: "2020-04-16 09:32:47 +0000", description: "Bump `tower-limit 0.1.2`", pr_number:                                                                                                2346, scopes: ["dependencies"], type:                                       "chore", breaking_change:       false, author: "Lucio Franco", files_count:       1, insertions_count:    3, deletions_count:     3},
		{sha: "f14ba50cbd3bad22b3aa5aadd60f83ccf7319ded", date: "2020-04-16 16:33:15 +0000", description: "Use only the filename part of the paths to extract dates", pr_number:                                                                2347, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Alexander Rodin", files_count:    1, insertions_count:    1, deletions_count:     1},
		{sha: "19bff5ca961d304744b2586f27ac24e3616a7024", date: "2020-04-16 21:56:11 +0000", description: "Add a guide about merging multi-line events", pr_number:                                                                             2354, scopes: ["lua transform"], type:                                      "docs", breaking_change:        false, author: "Alexander Rodin", files_count:    5, insertions_count:    1321, deletions_count:  0},
		{sha: "225bee0537660cfa84d33cedce48e0926c533672", date: "2020-04-17 10:50:47 +0000", description: "Add highlights section to contributing", pr_number:                                                                                  2348, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Binary Logic", files_count:       1, insertions_count:    50, deletions_count:    0},
		{sha: "b94373a614fdfb0a8baf231450d44fb0155b99c6", date: "2020-04-17 16:55:17 +0000", description: "fix typo 'desigend'", pr_number:                                                                                                     2350, scopes: [], type:                                                     "docs", breaking_change:        false, author: "Erwan D", files_count:            134, insertions_count:  267, deletions_count:   267},
		{sha: "d77a2f59e7ad18a28d4be90cc3da40e8ca49fe4f", date: "2020-04-17 17:57:38 +0000", description: "Cache paths for parsed fields", pr_number:                                                                                           2325, scopes: ["tokenizer transform"], type:                                "perf", breaking_change:        false, author: "Alexander Rodin", files_count:    2, insertions_count:    9, deletions_count:     7},
		{sha: "7c6608df02259778aaa3cc7770d96c6aabd75669", date: "2020-04-17 11:57:04 +0000", description: "Update Ana bio", pr_number:                                                                                                          2360, scopes: ["website"], type:                                            "chore", breaking_change:       false, author: "Ana Hobden", files_count:         2, insertions_count:    9, deletions_count:     5},
		{sha: "72da605fd619c0321d9c8ffd176680f225ca88d5", date: "2020-04-17 12:06:36 +0000", description: "Migrate some PR checks to Github Actions from Circle", pr_number:                                                                    2352, scopes: ["platforms"], type:                                          "chore", breaking_change:       false, author: "Ana Hobden", files_count:         5, insertions_count:    205, deletions_count:   120},
		{sha: "6b95f7e17e4af25c689a108cd3fa6941d97d5593", date: "2020-04-17 13:47:27 +0000", description: "Add support for instance accounts", pr_number:                                                                                       2351, scopes: ["gcp provider"], type:                                       "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      11, insertions_count:   114, deletions_count:   39},
		{sha: "7ea0eed5ee4c24df66efba60403ecf0b5486ebb4", date: "2020-04-18 11:35:30 +0000", description: "Wire in new `ShutdownSignal` for improved shutdown", pr_number:                                                                      2261, scopes: ["file source"], type:                                        "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 4, insertions_count:    139, deletions_count:   94},
		{sha: "9c9def9d7d9f6d2319ec31241632f521d8e597d4", date: "2020-04-18 10:29:23 +0000", description: "Allow creation race of groups and streams", pr_number:                                                                               2355, scopes: ["aws_cloudwatch_logs sink"], type:                           "fix", breaking_change:         false, author: "Lucio Franco", files_count:       1, insertions_count:    26, deletions_count:    2},
		{sha: "f119d617293e81a2f7093dac549cd8ac5c26303f", date: "2020-04-18 15:47:29 +0000", description: "Only run CI workflow when relevant files change", pr_number:                                                                         2369, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       1, insertions_count:    65, deletions_count:    60},
		{sha: "32e73588a7e2b3e9fd80f3eb0184339405b044fc", date: "2020-04-19 12:48:00 +0000", description: "Fix tests", pr_number:                                                                                                               2372, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:    14, deletions_count:    4},
		{sha: "fde51c235f6d3c205a34a768c9df9e3f5e537dd5", date: "2020-04-19 21:21:23 +0000", description: "Add nightly GH action workflow", pr_number:                                                                                          2370, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Binary Logic", files_count:       6, insertions_count:    246, deletions_count:   86},
		{sha: "c59eedf0943f7b02295c75907fbf3024bd884f11", date: "2020-04-19 21:37:28 +0000", description: "Move /test-data to /tests/data", pr_number:                                                                                          2375, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       6, insertions_count:    4, deletions_count:     5},
		{sha: "e041007b0849c8de0e1b80272e1875d413a5aad8", date: "2020-04-20 12:57:02 +0000", description: "Run ci workflow on pull requests only", pr_number:                                                                                   2378, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Binary Logic", files_count:       1, insertions_count:    16, deletions_count:    1},
		{sha: "8442531f7190e30820be157be21be77bd9c27a15", date: "2020-04-20 19:15:22 +0000", description: "Wire in new `ShutdownSignal` for improved shutdown", pr_number:                                                                      2373, scopes: ["splunk_hec source"], type:                                  "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:    22, deletions_count:    50},
		{sha: "806f24664147d71ab866ef156d9f3762bac7992c", date: "2020-04-20 19:17:28 +0000", description: "Wire in `ShutdownSignal` for improved shutdown", pr_number:                                                                          2364, scopes: ["journald source"], type:                                    "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 3, insertions_count:    57, deletions_count:    52},
		{sha: "512cb2ebb3f85997ef5b9966e1b501d531125c35", date: "2020-04-20 19:20:14 +0000", description: "Wire in new `ShutdownSignal` for improved shutdown", pr_number:                                                                      2365, scopes: ["sources"], type:                                            "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 7, insertions_count:    50, deletions_count:    18},
		{sha: "b7af16744363667c75948cbbf1b197a21f237324", date: "2020-04-20 10:55:19 +0000", description: "Reenable component feature check", pr_number:                                                                                        2371, scopes: ["platforms"], type:                                          "chore", breaking_change:       false, author: "Ana Hobden", files_count:         3, insertions_count:    36, deletions_count:    12},
		{sha: "ec30c6166b69e2a91514440347abf090a52fd6e9", date: "2020-04-20 13:21:43 +0000", description: "support sub-second timestamp resolution", pr_number:                                                                                 2333, scopes: ["lua transform"], type:                                      "fix", breaking_change:         false, author: "Joe Schafer", files_count:        4, insertions_count:    77, deletions_count:    9},
		{sha: "74126709debf66fc576a1a064244be98e223a0a6", date: "2020-04-20 13:29:30 +0000", description: "Optimize binaries in `test-stable` CI to reduce binary sizes. This should make it more stable.", pr_number:                          2380, scopes: ["operations"], type:                                         "chore", breaking_change:       false, author: "Ana Hobden", files_count:         1, insertions_count:    14, deletions_count:    0},
		{sha: "514f8b1ed5596691e4f083657a61ffe935b06b7f", date: "2020-04-20 16:29:54 +0000", description: "Prepare 0.9.0", pr_number:                                                                                                           2353, scopes: [], type:                                                     "chore", breaking_change:       false, author: "Binary Logic", files_count:       119, insertions_count:  27658, deletions_count: 16436},
	]
}
