package metadata

urls: {
	affine_type_system:                                       "\(wikipedia)/wiki/Substructural_type_system#Affine_type_systems"
	adaptive_request_concurrency_post:                        "/blog/adaptive-request-concurrency/"
	amazon_linux:                                             "https://aws.amazon.com/amazon-linux-ami/"
	ansi_escape_codes:                                        "\(wikipedia)/wiki/ANSI_escape_code"
	apache:                                                   "https://httpd.apache.org"
	apache_common:                                            "\(apache)/docs/1.3/logs.html#common"
	apache_combined:                                          "\(apache)/docs/1.3/logs.html#combined"
	apache_error:                                             "\(apache)/docs/1.3/logs.html#errorlog"
	apache_extended_status:                                   "\(apache)/docs/current/mod/core.html#extendedstatus"
	apache_install:                                           "\(apache)/docs/current/install.html"
	apache_mod_status:                                        "http://httpd.apache.org/docs/current/mod/mod_status.html"
	apt:                                                      "\(wikipedia)/wiki/APT_(software)"
	arm:                                                      "\(wikipedia)/wiki/ARM_architecture"
	aws_access_keys:                                          "\(aws_docs)/IAM/latest/UserGuide/id_credentials_access-keys.html"
	aws_arm_g2_announcement:                                  "https://aws.amazon.com/about-aws/whats-new/2019/12/announcing-new-amazon-ec2-m6g-c6g-and-r6g-instances-powered-by-next-generation-arm-based-aws-graviton2-processors/"
	aws_athena:                                               "https://aws.amazon.com/athena/"
	aws_athena_console:                                       "https://console.aws.amazon.com/athena/home"
	aws_canonical_user_id:                                    "\(aws_docs)/general/latest/gr/acct-identifiers.html#FindingCanonicalId"
	aws_cloudwatch:                                           "https://aws.amazon.com/cloudwatch/"
	aws_cloudwatch_logs:                                      "\(aws_docs)/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html"
	aws_cloudwatch_logs_api:                                  "\(aws_docs)/AmazonCloudWatchLogs/latest/APIReference/Welcome.html"
	aws_cloudwatch_logs_firehose:                             "\(aws_docs)/firehose/latest/dev/writing-with-cloudwatch-logs.html"
	aws_cloudwatch_logs_group_name:                           "\(aws_docs)/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html"
	aws_cloudwatch_logs_service_limits:                       "\(aws_docs)/AmazonCloudWatch/latest/logs/cloudwatch_limits_cwl.html"
	aws_cloudwatch_logs_sink_source:                          "\(vector_repo)/blob/master/src/sinks/aws_cloudwatch_logs/"
	aws_cloudwatch_logs_stream_name:                          "\(aws_docs)/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html"
	aws_cloudwatch_logs_regions:                              "\(aws_docs)/general/latest/gr/rande.html#cwl_region"
	aws_cloudwatch_logs_s3_export:                            "\(aws_docs)/AmazonCloudWatch/latest/logs/S3Export.html"
	aws_cloudwatch_logs_subscriptions:                        "\(aws_docs)/AmazonCloudWatch/latest/logs/SubscriptionFilters.html"
	aws_cloudwatch_logs_subscriptions_firehose:               "\(aws_docs)/AmazonCloudWatch/latest/logs/SubscriptionFilters.html#FirehoseExample"
	aws_cloudwatch_metrics:                                   "\(aws_docs)/AmazonCloudWatch/latest/monitoring/working_with_metrics.html"
	aws_cloudwatch_metrics_api:                               "\(aws_docs)/AmazonCloudWatch/latest/APIReference/API_PutMetricData.html"
	aws_cloudwatch_metrics_service_limits:                    "\(aws_docs)/en_pv/AmazonCloudWatch/latest/monitoring/cloudwatch_limits.html"
	aws_cloudwatch_metrics_regions:                           "\(aws_docs)/general/latest/gr/rande.html#cw_region"
	aws_credential_process:                                   "\(aws_docs)/cli/latest/userguide/cli-configure-sourcing-external.html"
	aws_credentials_file:                                     "\(aws_docs)/cli/latest/userguide/cli-configure-files.html"
	aws_docs:                                                 "https://docs.aws.amazon.com"
	aws_elasticsearch:                                        "https://aws.amazon.com/elasticsearch-service/"
	aws_elasticsearch_regions:                                "\(aws_docs)/general/latest/gr/rande.html#elasticsearch-service-regions"
	aws_ec2_instance_metadata:                                "\(aws_docs)/AWSEC2/latest/UserGuide/ec2-instance-metadata.html"
	aws_ecs:                                                  "https://aws.amazon.com/ecs/"
	aws_ecs_task_metadata:                                    "\(aws_docs)/AmazonECS/latest/developerguide/task-metadata-endpoint.html"
	aws_elb:                                                  "https://aws.amazon.com/elasticloadbalancing/"
	aws_elb_access_format:                                    "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-access-logs.html#access-log-entry-examples"
	aws_elb_https:                                            "\(aws_docs)/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html"
	aws_iam:                                                  "\(aws_docs)/IAM/latest/UserGuide/introduction.html"
	aws_iam_role:                                             "\(aws_docs)/IAM/latest/UserGuide/id_roles.html"
	aws_imds_v1_security_problems:                            "https://aws.amazon.com/blogs/security/defense-in-depth-open-firewalls-reverse-proxies-ssrf-vulnerabilities-ec2-instance-metadata-service/"
	aws_kinesis_firehose:                                     "https://aws.amazon.com/kinesis/data-firehose/"
	aws_kinesis_firehose_http_protocol:                       "\(aws_docs)/firehose/latest/dev/create-destination.html#create-destination-http"
	aws_firehose_http_request_spec:                           "\(aws_docs)/firehose/latest/dev/httpdeliveryrequestresponse.html"
	aws_kinesis_firehose_api:                                 "\(aws_docs)/firehose/latest/APIReference/API_PutRecordBatch.html"
	aws_kinesis_firehose_service_limits:                      "\(aws_docs)/firehose/latest/dev/limits.html"
	aws_kinesis_firehose_http_setup:                          "https://aws.amazon.com/blogs/big-data/stream-data-to-an-http-endpoint-with-amazon-kinesis-data-firehose/"
	aws_kinesis_partition_key:                                "\(aws_docs)/kinesis/latest/APIReference/API_PutRecordsRequestEntry.html#Streams-Type-PutRecordsRequestEntry-PartitionKey"
	aws_kinesis_streams:                                      "https://aws.amazon.com/kinesis/data-streams/"
	aws_kinesis_streams_api:                                  "\(aws_docs)/kinesis/latest/APIReference/API_PutRecords.html"
	aws_kinesis_streams_service_limits:                       "\(aws_docs)/streams/latest/dev/service-sizes-and-limits.html"
	aws_kinesis_split_shards:                                 "\(aws_docs)/streams/latest/dev/kinesis-using-sdk-java-resharding-split.html"
	aws_regions:                                              "\(aws_docs)/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
	aws_s3:                                                   "https://aws.amazon.com/s3/"
	aws_s3_acl:                                               "\(aws_docs)/AmazonS3/latest/dev/acl-overview.html"
	aws_s3_bucket_notifications_to_sqs:                       "\(aws_docs)/AmazonS3/latest/dev/ways-to-add-notification-config-to-bucket.html"
	aws_s3_canned_acl:                                        "\(aws_docs)/AmazonS3/latest/dev/acl-overview.html#canned-acl"
	aws_s3_cross_account_tutorial:                            "\(aws_docs)/AmazonS3/latest/dev/example-walkthroughs-managing-access-example3.html"
	aws_s3_endpoints:                                         "\(aws_docs)/general/latest/gr/rande.html#s3_endpoint"
	aws_s3_grantee:                                           "\(aws_docs)/AmazonS3/latest/dev/acl-overview.html#specifying-grantee"
	aws_s3_metadata:                                          "\(aws_docs)/AmazonS3/latest/dev/UsingMetadata.html#object-metadata"
	aws_s3_regions:                                           "\(aws_docs)/general/latest/gr/rande.html#s3_region"
	aws_s3_server_access_logs:                                "\(aws_docs)/AmazonS3/latest/dev/ServerLogs.html"
	aws_s3_service_limits:                                    "\(aws_docs)/streams/latest/dev/service-sizes-and-limits.html"
	aws_s3_sse:                                               "\(aws_docs)/AmazonS3/latest/dev/UsingServerSideEncryption.html"
	aws_s3_storage_classes:                                   "https://aws.amazon.com/s3/storage-classes/"
	aws_s3_tags:                                              "\(aws_docs)/AmazonS3/latest/user-guide/add-object-tags.html"
	aws_sqs:                                                  "https://aws.amazon.com/sqs/"
	aws_sqs_api:                                              "\(aws_docs)/AWSSimpleQueueService/latest/APIReference/Welcome.html"
	aws_sqs_create:                                           "\(aws_docs)/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-create-queue.html"
	aws_vpc_flow_logs:                                        "\(aws_docs)/vpc/latest/userguide/flow-logs.html"
	azure_monitor:                                            "https://azure.microsoft.com/en-us/services/monitor/"
	azure_monitor_logs_endpoints:                             "https://docs.microsoft.com/en-us/rest/api/monitor/"
	base64:                                                   "\(wikipedia)/wiki/Base64"
	base64_padding:                                           "\(wikipedia)/wiki/Base64#Output_padding"
	base64_standard:                                          "https://tools.ietf.org/html/rfc4648#section-4"
	base64_url_safe:                                          "\(wikipedia)/wiki/Base64#URL_applications"
	basic_auth:                                               "\(wikipedia)/wiki/Basic_access_authentication"
	big_query_streaming:                                      "https://cloud.google.com/bigquery/streaming-data-into-bigquery"
	b_tree_map:                                               "https://doc.rust-lang.org/std/collections/struct.BTreeMap.html"
	cargo_audit:                                              "\(github)/RustSec/cargo-audit"
	centos:                                                   "https://www.centos.org/"
	chrono_time_formats:                                      "https://docs.rs/chrono/latest/chrono/format/strftime/index.html#specifiers"
	cgroups_limit_resources:                                  "https://the.binbashtheory.com/control-resources-cgroups/"
	clickhouse:                                               "https://clickhouse.yandex/"
	clickhouse_http:                                          "https://clickhouse.yandex/docs/en/interfaces/http/"
	cloudsmith:                                               "https://cloudsmith.io/~timber/repos/vector/packages/"
	cloudsmith_apt:                                           "https://cloudsmith.io/~timber/repos/vector/setup/#formats-deb"
	cloudsmith_yum:                                           "https://cloudsmith.io/~timber/repos/vector/setup/#formats-rpm"
	console:                                                  "\(wikipedia)/wiki/System_console"
	conventional_commits:                                     "https://www.conventionalcommits.org"
	contributing:                                             "\(vector_repo)/blob/master/CONTRIBUTING.md#setup"
	crc:                                                      "\(wikipedia)/wiki/Cyclic_redundancy_check"
	ctime:                                                    "https://www.cplusplus.com/reference/ctime"
	cue:                                                      "https://cuelang.org/"
	dag:                                                      "\(wikipedia)/wiki/Directed_acyclic_graph"
	datadog:                                                  "https://www.datadoghq.com"
	datadog_agent:                                            "https://github.com/DataDog/datadog-agent"
	datadog_distribution:                                     "\(datadog_docs)/developers/metrics/types/?tab=distribution#definition"
	datadog_docs:                                             "https://docs.datadoghq.com"
	datadog_logs:                                             "\(datadog_docs)/logs/"
	datadog_logs_endpoints:                                   "\(datadog_docs)/logs/log_collection/?tab=http#datadog-logs-endpoints"
	datadog_metrics:                                          "\(datadog_docs)/metrics/"
	datadog_metrics_endpoints:                                "\(datadog_docs)/api/v1/metrics/"
	date:                                                     "https://man7.org/linux/man-pages/man1/date.1.html"
	debian:                                                   "https://www.debian.org/"
	debian_system_groups:                                     "https://wiki.debian.org/SystemGroups"
	default_configuration:                                    "\(vector_repo)/blob/master/config/vector.toml"
	docker:                                                   "https://www.docker.com/"
	docker_alpine:                                            "\(docker_hub)/_/alpine"
	docker_cli:                                               "\(docker_docs)/engine/reference/commandline/cli/"
	docker_debian:                                            "\(docker_hub)/_/debian"
	docker_daemon:                                            "\(docker_docs)/engine/docker-overview/#the-docker-daemon"
	docker_daemon_socket_option:                              "\(docker_docs)/engine/reference/commandline/dockerd/#daemon-socket-option"
	docker_docs:                                              "https://docs.docker.com"
	docker_dns:                                               "\(docker_docs)/config/containers/container-networking/#dns-services"
	docker_engine:                                            "\(docker_docs)/engine/"
	docker_engine_api:                                        "\(docker_docs)/engine/api/"
	docker_env_vars:                                          "\(docker_docs)/engine/reference/commandline/cli/#environment-variables"
	docker_networking:                                        "\(docker_docs)/network/network-tutorial-host/"
	docker_hub:                                               "https://hub.docker.com"
	docker_hub_vector:                                        "\(docker_hub)/r/timberio/vector"
	docker_logging_driver_journald:                           "\(docker_docs)/config/containers/logging/journald/"
	docker_logging_driver_json_file:                          "\(docker_docs)/config/containers/logging/json-file/"
	docker_logging_driver_local:                              "\(docker_docs)/config/containers/logging/local/"
	docker_logging_driver_splunk:                             "\(docker_docs)/config/containers/logging/splunk/"
	docker_logging_driver_syslog:                             "\(docker_docs)/config/containers/logging/syslog/"
	docker_logging_drivers:                                   "\(docker_docs)/config/containers/logging/configure/"
	docker_object_labels:                                     "\(docker_docs)/config/labels-custom-metadata/"
	docker_setup:                                             "\(docker_docs)/get-docker/"
	dockerfile:                                               "\(vector_repo)/blob/master/Dockerfile"
	dogstatsd:                                                "\(datadog_docs)/developers/dogstatsd/?tab=hostagent"
	dpkg:                                                     "https://wiki.debian.org/dpkg"
	dry_code:                                                 "\(wikipedia)/wiki/Don%27t_repeat_yourself"
	cidr:                                                     "\(wikipedia)/wiki/Classless_Inter-Domain_Routing"
	elasticsearch:                                            "https://www.elastic.co/products/elasticsearch"
	elasticsearch_bulk:                                       "https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-bulk.html"
	elasticsearch_data_streams:                               "https://www.elastic.co/guide/en/elasticsearch/reference/current/data-streams.html"
	elasticsearch_id_field:                                   "https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-id-field.html"
	elasticsearch_id_performance:                             "https://www.elastic.co/guide/en/elasticsearch/reference/master/tune-for-indexing-speed.html#_use_auto_generated_ids"
	elasticsearch_ignore_malformed:                           "https://www.elastic.co/guide/en/elasticsearch/reference/current/ignore-malformed.html"
	encoding_charset_labels:                                  "https://encoding.spec.whatwg.org/#concept-encoding-get"
	encoding_standard:                                        "https://encoding.spec.whatwg.org/"
	endler_dev:                                               "https://endler.dev/"
	eof:                                                      "\(wikipedia)/wiki/End-of-file#EOF_character"
	etsy:                                                     "https://www.etsy.com"
	event_proto:                                              "\(vector_repo)/blob/master/lib/vector-core/proto/event.proto"
	exit_codes:                                               "https://docs.rs/exitcode/latest/exitcode/#constants"
	externally_tagged_representation:                         "https://serde.rs/enum-representations.html#externally-tagged"
	fail_safe:                                                "https://en.wikipedia.org/wiki/Fail-safe"
	ffi:                                                      "https://en.wikipedia.org/wiki/Foreign_function_interface"
	file:                                                     "\(wikipedia)/wiki/Computer_file"
	file_system:                                              "\(wikipedia)/wiki/File_system"
	freebsd:                                                  "https://www.freebsd.org/"
	gcp_authentication:                                       "https://cloud.google.com/docs/authentication/"
	gcp_authentication_api_key:                               "https://cloud.google.com/docs/authentication/api-keys"
	gcp_authentication_server_to_server:                      "https://cloud.google.com/docs/authentication/production"
	gcp_authentication_service_account:                       "https://cloud.google.com/docs/authentication/production#obtaining_and_providing_service_account_credentials_manually"
	gcp_cloud_storage:                                        "https://cloud.google.com/storage"
	gcp_folders:                                              "https://cloud.google.com/resource-manager/docs/creating-managing-folders"
	gcp_pubsub:                                               "https://cloud.google.com/pubsub/"
	gcp_pubsub_rest:                                          "https://cloud.google.com/pubsub/docs/reference/rest/"
	gcp_projects:                                             "https://cloud.google.com/resource-manager/docs/creating-managing-projects"
	gcp_resources:                                            "https://cloud.google.com/monitoring/api/resources"
	gcp_stackdriver:                                          "https://cloud.google.com/products/operations"
	gcp_stackdriver_logging:                                  "https://cloud.google.com/logging/docs/reference/v2/rest/"
	gcp_stackdriver_logging_rest:                             "https://cloud.google.com/logging/"
	gcp_stackdriver_metrics:                                  "https://cloud.google.com/monitoring/api/ref_v3/rest/"
	gcp_stackdriver_metrics_rest:                             "https://monitoring.googleapis.com/"
	gcp_stackdriver_severity:                                 "https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry#logseverity"
	gcp_xml_interface:                                        "https://cloud.google.com/storage/docs/xml-api/overview"
	gcs_predefined_acl:                                       "https://cloud.google.com/storage/docs/access-control/lists#predefined-acl"
	gcs_storage_classes:                                      "https://cloud.google.com/storage/docs/storage-classes"
	gcs_custom_metadata:                                      "https://cloud.google.com/storage/docs/metadata#custom-metadata"
	git:                                                      "https://git-scm.com/"
	github:                                                   "https://github.com"
	github_protected_branches:                                "https://help.github.com/en/github/administering-a-repository/about-protected-branches"
	github_sign_commits:                                      "https://help.github.com/en/github/authenticating-to-github/signing-commits"
	globbing:                                                 "\(wikipedia)/wiki/Glob_(programming)"
	glog:                                                     "\(github)/google/glog"
	gnu_allocator:                                            "https://www.gnu.org/software/libc/manual/html_node/The-GNU-Allocator.html"
	graphql:                                                  "https://graphql.org"
	graphql_playground:                                       "\(github)/graphql/graphql-playground"
	grok:                                                     "https://grokdebug.herokuapp.com/"
	grok_debugger:                                            "https://grokdebug.herokuapp.com/"
	grok_patterns:                                            "\(github)/daschl/grok/tree/master/patterns"
	gzip:                                                     "https://www.gzip.org/"
	haproxy:                                                  "https://www.haproxy.org/"
	helm:                                                     "https://helm.sh/"
	heroku:                                                   "https://www.heroku.com"
	heroku_http_log_drain:                                    "https://devcenter.heroku.com/articles/log-drains#https-drains"
	heroku_start:                                             "https://devcenter.heroku.com/start"
	homebrew:                                                 "https://brew.sh/"
	homebrew_services:                                        "\(github)/Homebrew/homebrew-services"
	honeycomb:                                                "https://honeycomb.io"
	honeycomb_batch:                                          "https://docs.honeycomb.io/api/events/#batched-events"
	honeycomb_signup:                                         "https://ui.honeycomb.io/signup"
	host:                                                     "\(wikipedia)/wiki/Host_(network)"
	http:                                                     "https://www.w3.org/Protocols/"
	http_client:                                              "\(wikipedia)/wiki/Hypertext_Transfer_Protocol#Client_request"
	http_server:                                              "\(wikipedia)/wiki/Web_server"
	humio:                                                    "https://humio.com"
	humio_hec:                                                "https://docs.humio.com/integrations/data-shippers/hec/"
	iam_instance_profile:                                     "\(aws_docs)/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html"
	iana_time_zone_format:                                    "\(wikipedia)/wiki/Tz_database#Names_of_time_zones"
	iana_time_zones:                                          "\(wikipedia)/wiki/List_of_tz_database_time_zones"
	ieee_754:                                                 "\(wikipedia)/wiki/IEEE_754"
	ietf_rfc_6750:                                            "https://tools.ietf.org/html/rfc6750"
	initd:                                                    "https://bash.cyberciti.biz/guide//etc/init.d"
	influxdb:                                                 "https://www.influxdata.com/products/influxdb-overview/"
	influxdb_http_api_v1:                                     "https://docs.influxdata.com/influxdb/latest/tools/api/#write-http-endpoint"
	influxdb_http_api_v2:                                     "https://v2.docs.influxdata.com/v2.0/api/#tag/Write"
	influxdb_authentication_token:                            "https://v2.docs.influxdata.com/v2.0/security/tokens/"
	influxdb_line_protocol:                                   "https://v2.docs.influxdata.com/v2.0/reference/syntax/line-protocol/"
	inode:                                                    "\(wikipedia)/wiki/Inode"
	iso_8601:                                                 "\(wikipedia)/wiki/ISO_8601"
	iso3166_2:                                                "\(wikipedia)/wiki/ISO_3166-2"
	issue_1694:                                               "\(vector_repo)/issues/1694"
	jemalloc:                                                 "\(github)/jemalloc/jemalloc"
	journald:                                                 "https://www.freedesktop.org/software/systemd/man/systemd-journald.service.html"
	json:                                                     "\(wikipedia)/wiki/JSON"
	json_types:                                               "\(wikipedia)/wiki/JSON#Data_types_and_syntax"
	jsonnet:                                                  "https://jsonnet.org/"
	kafka:                                                    "https://kafka.apache.org/"
	kafka_partitioning_docs:                                  "https://cwiki.apache.org/confluence/display/KAFKA/A+Guide+To+The+Kafka+Protocol#AGuideToTheKafkaProtocol-Partitioningandbootstrapping"
	kafka_protocol:                                           "https://kafka.apache.org/protocol"
	kafka_sasl:                                               "https://docs.confluent.io/current/kafka/authentication_sasl/index.html"
	klog:                                                     "\(github)/kubernetes/klog"
	kubectl:                                                  "\(kubernetes)/docs/reference/kubectl/overview/"
	kubernetes:                                               "https://kubernetes.io"
	kubernetes_accessing_api_from_pod:                        "\(kubernetes)/docs/tasks/access-application-cluster/access-cluster/#accessing-the-api-from-a-pod"
	kubernetes_api:                                           "\(kubernetes)/docs/concepts/overview/kubernetes-api/"
	kubernetes_api_server:                                    "\(kubernetes)/docs/reference/command-line-tools-reference/kube-apiserver/"
	kubernetes_authorization:                                 "\(kubernetes)/docs/reference/access-authn-authz/authorization/"
	kubernetes_daemonset:                                     "\(kubernetes)/docs/concepts/workloads/controllers/daemonset/"
	kubernetes_example_daemonset:                             "\(vector_repo)/blob/master/config/kubernetes/vector-daemonset.yaml"
	kubernetes_limit_resources:                               "\(kubernetes)/docs/tasks/configure-pod-container/assign-cpu-resource/"
	kubernetes_logging_architecture:                          "\(kubernetes)/docs/concepts/cluster-administration/logging/"
	kubernetes_rbac:                                          "\(kubernetes)/docs/reference/access-authn-authz/rbac/"
	kubernetes_request_verbs:                                 "\(kubernetes)/docs/reference/access-authn-authz/authorization/#determine-the-request-verb"
	kubernetes_watch_api:                                     "\(kubernetes)/docs/reference/generated/kubernetes-api/v1.10/#watch-30"
	leveldb:                                                  "\(github)/google/leveldb"
	leveldb_sys_2:                                            "https://crates.io/crates/leveldb-sys"
	leveldb_sys_3:                                            "\(github)/timberio/leveldb-sys/tree/v3.0.0"
	librdkafka:                                               "\(github)/edenhill/librdkafka"
	librdkafka_config:                                        "\(github)/edenhill/librdkafka/blob/master/CONFIGURATION.md"
	linux_capability:                                         "https://man7.org/linux/man-pages/man7/capabilities.7.html"
	logdna:                                                   "https://logdna.com/"
	logfmt:                                                   "https://brandur.org/logfmt"
	loki:                                                     "https://grafana.com/oss/loki/"
	loki_multi_tenancy:                                       "\(github)/grafana/loki/blob/master/docs/operations/multi-tenancy.md"
	log_event_source:                                         "\(vector_repo)/blob/master/src/event/"
	logplex:                                                  "https://devcenter.heroku.com/articles/logplex"
	logplex_protocol:                                         "\(github)/heroku/logplex/blob/master/doc/README.http_drains.md"
	lua:                                                      "https://www.lua.org"
	lua_boolean:                                              "\(lua)/pil/2.2.html"
	lua_csv_repo:                                             "\(github)/geoffleyland/lua-csv"
	lua_csv_view:                                             "\(github)/geoffleyland/lua-csv/blob/09557e4608b02d136b9ae39a8fa0f36328fa1cec/lua/csv.lua"
	lua_csv_raw:                                              "https://raw.githubusercontent.com/geoffleyland/lua-csv/d20cd42d61dc52e7f6bcb13b596ac7a7d4282fbf/lua/csv.lua"
	lua_integer:                                              "https://docs.rs/rlua/latest/rlua/type.Integer.html"
	lua_manual:                                               "\(lua)/manual/5.3/manual.html"
	lua_modules:                                              "\(lua)/manual/5.3/manual.html#6.3"
	lua_modules_tutorial:                                     "http://lua-users.org/wiki/ModulesTutorial"
	lua_number:                                               "https://docs.rs/rlua/latest/rlua/type.Number.html"
	lua_os_date:                                              "\(lua)/manual/5.3/manual.html#pdf-os.date"
	lua_os_time:                                              "\(lua)/manual/5.3/manual.html#pdf-os.time"
	lua_pairs:                                                "\(lua)/manual/5.3/manual.html#pdf-pairs"
	lua_pil:                                                  "\(lua)/pil/"
	lua_require:                                              "\(lua)/manual/5.3/manual.html#pdf-require"
	lua_table:                                                "\(lua)/pil/2.5.html"
	lua_sequence:                                             "\(lua)/pil/11.1.html"
	lua_string:                                               "\(lua)/pil/2.4.html"
	lua_tonumber:                                             "\(lua)/manual/5.3/manual.html#pdf-tonumber"
	lz4:                                                      "https://lz4.github.io/lz4/"
	macos:                                                    "\(wikipedia)/wiki/MacOS"
	magic_bytes:                                              "\(wikipedia)/wiki/List_of_file_signatures"
	mailing_list:                                             "\(vector_website)/community/"
	maxmind:                                                  "https://www.maxmind.com/en/home"
	maxmind_db_file_format:                                   "https://maxmind.github.io/MaxMind-DB/"
	maxmind_geoip2:                                           "https://dev.maxmind.com/geoip/geoip2/downloadable"
	maxmind_geoip2_city:                                      "https://www.maxmind.com/en/geoip2-city"
	maxmind_geoip2_isp:                                       "https://www.maxmind.com/en/geoip2-isp-database"
	maxmind_geolite2_asn:                                     "https://dev.maxmind.com/geoip/geoip2/geolite2/#Download_Access"
	maxmind_geolite2_city:                                    "https://dev.maxmind.com/geoip/geoip2/geolite2/#Download_Access"
	memory_safety:                                            "\(wikipedia)/wiki/Memory_safety"
	memory_safety_bugs:                                       "https://thenewstack.io/microsoft-rust-is-the-industrys-best-chance-at-safe-systems-programming/"
	metric_event_source:                                      "\(vector_repo)/blob/master/src/event/metric.rs"
	mongodb:                                                  "https://www.mongodb.com"
	mongodb_command_server_status:                            "https://docs.mongodb.com/manual/reference/command/serverStatus/"
	mongodb_connection_string_uri_format:                     "https://docs.mongodb.com/manual/reference/connection-string/"
	musl_allocator:                                           "https://musl.libc.org/releases.html"
	musl_builder_docker_image:                                "\(vector_repo)/blob/master/scripts/ci-docker-images/builder-x86_64-unknown-linux-musl/Dockerfile"
	nats:                                                     "https://nats.io/"
	new_bug_report:                                           "\(vector_repo)/issues/new?labels=type%3A+bug"
	new_feature_request:                                      "\(vector_repo)/issues/new?labels=type%3A+new+feature"
	new_relic:                                                "https://newrelic.com/"
	new_relic_log_api:                                        "https://docs.newrelic.com/docs/logs/new-relic-logs/log-api/introduction-log-api"
	new_security_report:                                      "\(vector_repo)/issues/new?labels=domain%3A+security"
	new_sink:                                                 "\(vector_repo)/issues/new?labels=type%3A+new+feature"
	new_source:                                               "\(vector_repo)/issues/new?labels=type%3A+new+feature"
	new_target:                                               "\(vector_repo)/issues/new?labels=type%3A+task&labels=domain%3A+operations"
	new_transform:                                            "\(vector_repo)/issues/new?labels=type%3A+new+feature"
	nginx:                                                    "https://www.nginx.com/"
	nginx_combined:                                           "https://nginx.org/en/docs/http/ngx_http_log_module.html"
	nginx_error:                                              "https://github.com/nginx/nginx/blob/branches/stable-1.18/src/core/ngx_log.c#L102"
	nginx_stub_status_module:                                 "http://nginx.org/en/docs/http/ngx_http_stub_status_module.html"
	nix:                                                      "https://nixos.org/nix/"
	nixos:                                                    "https://nixos.org/"
	nixpkgs_9682:                                             "\(github)/NixOS/nixpkgs/issues/9682"
	openssl:                                                  "https://www.openssl.org/"
	order_of_ops:                                             "\(wikipedia)/wiki/Order_of_operations"
	papertrail:                                               "https://www.papertrail.com/"
	papertrail_syslog:                                        "https://help.papertrailapp.com/kb/how-it-works/http-api/#submitting-log-messages"
	perl_windows:                                             "https://www.perl.org/get.html#win32"
	posix_acls:                                               "https://www.usenix.org/legacy/publications/library/proceedings/usenix03/tech/freenix03/full_papers/gruenbacher/gruenbacher_html/main.html"
	postgresql:                                               "https://www.postgresql.org/"
	postgresql_csvlog:                                        "https://www.postgresql.org/docs/current/runtime-config-logging.html#RUNTIME-CONFIG-LOGGING-CSVLOG"
	postgresql_matching:                                      "https://www.postgresql.org/docs/current/functions-matching.html#FUNCTIONS-POSIX-REGEXP"
	prometheus:                                               "https://prometheus.io/"
	prometheus_client:                                        "https://prometheus.io/docs/instrumenting/clientlibs/"
	prometheus_counter:                                       "https://prometheus.io/docs/concepts/metric_types/#counter"
	prometheus_gauge:                                         "https://prometheus.io/docs/concepts/metric_types/#gauge"
	prometheus_high_cardinality:                              "https://prometheus.io/docs/practices/naming/#labels"
	prometheus_histogram:                                     "https://prometheus.io/docs/concepts/metric_types/#histogram"
	prometheus_histograms_guide:                              "https://prometheus.io/docs/practices/histograms/"
	prometheus_summary:                                       "https://prometheus.io/docs/concepts/metric_types/#summary"
	prometheus_text_based_exposition_format:                  "\(github)/prometheus/docs/blob/master/content/docs/instrumenting/exposition_formats.md#text-based-format"
	prometheus_metric_naming:                                 "https://prometheus.io/docs/practices/naming/#metric-names"
	prometheus_remote_integrations:                           "https://prometheus.io/docs/operating/integrations/#remote-endpoints-and-storage"
	prometheus_remote_write:                                  "https://prometheus.io/docs/prometheus/latest/configuration/configuration/#remote_write"
	protobuf:                                                 "https://developers.google.com/protocol-buffers"
	pulsar:                                                   "https://pulsar.apache.org/"
	pulsar_protocol:                                          "https://pulsar.apache.org/docs/en/develop-binary-protocol/"
	raspbian:                                                 "https://www.raspbian.org/"
	rdkafka:                                                  "\(github)/edenhill/librdkafka"
	regex:                                                    "\(wikipedia)/wiki/Regular_expression"
	regex_grouping_and_flags:                                 "https://docs.rs/regex/latest/regex/#grouping-and-flags"
	regex_tester:                                             "https://rustexp.lpil.uk/"
	rfc_822:                                                  "https://tools.ietf.org/html/rfc822#section-5"
	rfc_2064:                                                 "\(vector_repo)/blob/master/rfcs/2020-03-17-2064-event-driven-observability.md"
	rfc_2822:                                                 "https://tools.ietf.org/html/rfc2822#section-3.3"
	rfc_3339:                                                 "https://tools.ietf.org/html/rfc3339"
	rfc_4180:                                                 "https://tools.ietf.org/html/rfc4180"
	rhel:                                                     "https://www.redhat.com/en/technologies/linux-platforms/enterprise-linux"
	rlua:                                                     "\(github)/kyren/rlua"
	rpm:                                                      "https://rpm.org/"
	rust:                                                     "https://www.rust-lang.org/"
	rust_date_time:                                           "https://docs.rs/chrono/latest/chrono/struct.DateTime.html"
	rust_grok_library:                                        "\(github)/daschl/grok"
	rust_k8s_openapi_crate:                                   "https://docs.rs/k8s-openapi/"
	rust_memory_safety:                                       "https://hacks.mozilla.org/2019/01/fearless-security-memory-safety"
	rust_regex_syntax:                                        "https://docs.rs/regex/latest/regex/#syntax"
	rust_sec:                                                 "https://rustsec.org/"
	rust_subprocess:                                          "https://docs.rs/subprocess"
	rust_target_triples:                                      "https://forge.rust-lang.org/platform-support.html"
	rust_tier_1_platform:                                     "https://forge.rust-lang.org/release/platform-support.html#tier-1"
	rust_tokio:                                               "\(github)/tokio-rs/tokio"
	rustup:                                                   "https://rustup.rs"
	sematext:                                                 "https://sematext.com"
	sematext_create_logs_app:                                 "https://apps.sematext.com/ui/integrations"
	sematext_es:                                              "https://sematext.com/docs/logs/index-events-via-elasticsearch-api/"
	sematext_logsense:                                        "http://www.sematext.com/logsene/"
	sematext_monitoring:                                      "https://sematext.com/docs/monitoring/"
	sematext_registration:                                    "https://apps.sematext.com/ui/registration"
	semver:                                                   "https://semver.org/"
	sha1:                                                     "https://en.wikipedia.org/wiki/SHA-1"
	sha2:                                                     "https://en.wikipedia.org/wiki/SHA-2"
	sha3:                                                     "https://en.wikipedia.org/wiki/SHA-3"
	snake_case:                                               "\(wikipedia)/wiki/Snake_case"
	snappy:                                                   "https://google.github.io/snappy/"
	socket:                                                   "\(wikipedia)/wiki/Network_socket"
	splunk:                                                   "https://www.splunk.com"
	splunk_hec:                                               "https://dev.splunk.com/enterprise/docs/dataapps/httpeventcollector/"
	splunk_hec_event_endpoint:                                "https://docs.splunk.com/Documentation/Splunk/8.0.0/RESTREF/RESTinput#services.2Fcollector.2Fevent"
	splunk_hec_indexed_fields:                                "https://docs.splunk.com/Documentation/Splunk/8.0.0/Data/IFXandHEC"
	splunk_hec_protocol:                                      "https://docs.splunk.com/Documentation/Splunk/8.0.0/Data/HECRESTendpoints"
	splunk_hec_raw_endpoint:                                  "https://docs.splunk.com/Documentation/Splunk/8.0.0/RESTREF/RESTinput#services.2Fcollector.2Fraw"
	splunk_hec_setup:                                         "https://docs.splunk.com/Documentation/Splunk/latest/Data/UsetheHTTPEventCollector"
	standard_streams:                                         "\(wikipedia)/wiki/Standard_streams"
	statsd:                                                   "\(github)/statsd/statsd"
	statsd_multi:                                             "\(github)/statsd/statsd/blob/master/docs/metric_types.md#multi-metric-packets"
	statsd_set:                                               "\(github)/statsd/statsd/blob/master/docs/metric_types.md#sets"
	statsd_udp_protocol:                                      "\(github)/b/statsd_spec"
	stderr:                                                   "\(wikipedia)/wiki/Standard_streams#Standard_error_(stderr)"
	stdin:                                                    "\(wikipedia)/wiki/Standard_streams#Standard_input_(stdin)"
	exec:                                                     "\(wikipedia)/wiki/Exec_(system_call)"
	stdout:                                                   "\(wikipedia)/wiki/Standard_streams#Standard_output_(stdout)"
	stripe_blog_canonical_log_lines:                          "https://stripe.com/blog/canonical-log-lines"
	strptime_specifiers:                                      "https://docs.rs/chrono/latest/chrono/format/strftime/index.html#specifiers"
	syslog:                                                   "\(wikipedia)/wiki/Syslog"
	syslog_3164:                                              "https://tools.ietf.org/html/rfc3164"
	syslog_5424:                                              "https://tools.ietf.org/html/rfc5424"
	syslog_6587:                                              "https://tools.ietf.org/html/rfc6587"
	syslog_facility:                                          "\(wikipedia)/wiki/Syslog#Facility"
	syslog_levels:                                            "\(wikipedia)/wiki/Syslog#Severity_level"
	systemd:                                                  "https://systemd.io/"
	systemd_limit_resources:                                  "https://www.freedesktop.org/software/systemd/man/systemd.resource-control.html"
	systemd_resolved:                                         "https://wiki.archlinux.org/index.php/Systemd-resolved"
	tcp:                                                      "\(wikipedia)/wiki/Transmission_Control_Protocol"
	team:                                                     "/community#team"
	timber:                                                   "https://timber.io"
	toml:                                                     "\(github)/toml-lang/toml"
	toml_array:                                               "\(github)/toml-lang/toml#array"
	toml_table:                                               "\(github)/toml-lang/toml#table"
	toml_types:                                               "\(github)/toml-lang/toml#table-of-contents"
	twelve_factor_app:                                        "https://12factor.net/"
	type_safety:                                              "https://en.wikipedia.org/wiki/Type_safety"
	tz_time_zones:                                            "https://en.wikipedia.org/wiki/List_of_tz_database_time_zones"
	ubuntu:                                                   "https://ubuntu.com/"
	udp:                                                      "\(wikipedia)/wiki/User_Datagram_Protocol"
	uds:                                                      "\(wikipedia)/wiki/Unix_domain_socket"
	unicode_replacement_character:                            "\(wikipedia)/wiki/Specials_(Unicode_block)#Replacement_character"
	unicode_whitespace:                                       "\(wikipedia)/wiki/Unicode_character_property#Whitespace"
	unix_timestamp:                                           "\(wikipedia)/wiki/Unix_time"
	utf8:                                                     "\(wikipedia)/wiki/UTF-8"
	uuidv4:                                                   "\(wikipedia)/wiki/Universally_unique_identifier#Version_4_(random)"
	url:                                                      "https://en.wikipedia.org/wiki/URL"
	us_social_security_number:                                "https://www.ssa.gov/history/ssn/geocard.html"
	vector_aggregator_role:                                   "\(vector_website)/docs/setup/deployment/roles/#aggregator"
	vector_blog:                                              "\(vector_website)/blog/"
	vector_bug_issues:                                        "\(vector_repo)/issues?q=is%3Aopen+is%3Aissue+label%3A%22type%3A+bug%22"
	vector_changelog:                                         "\(vector_repo)/blob/master/CHANGELOG.md"
	vector_chat:                                              "https://chat.vector.dev"
	vector_code_of_conduct:                                   "\(vector_repo)/blob/master/CODE_OF_CONDUCT.md"
	vector_community:                                         "\(vector_website)/community/"
	vector_components:                                        "\(vector_website)/components/"
	vector_configuration:                                     "\(vector_website)/docs/configuration/"
	vector_data_model:                                        "\(vector_website)/docs/about/under-the-hood/architecture/data-model/"
	vector_debian_source_files:                               "\(vector_repo)/tree/master/distribution/debian"
	vector_dedupe_transform:                                  "\(vector_website)/docs/reference/configuration/transforms/dedupe/"
	vector_docker_logs_source:                                "\(vector_website)/docs/reference/configuration/sources/docker_logs/"
	vector_docker_source_files:                               "\(vector_repo)/tree/master/distribution/docker"
	vector_docs:                                              "\(vector_website)/docs/"
	vector_download:                                          "\(vector_website)/releases/latest/download/"
	vector_download_nightly:                                  "\(vector_website)/releases/nightly/download/"
	vector_enriching_transforms:                              "\(vector_website)/components/?functions%5B%5D=enrich"
	vector_exec_source:                                       "\(vector_website)/docs/reference/configuration/sources/exec"
	vector_file_source:                                       "\(vector_website)/docs/reference/configuration/sources/file/"
	vector_generate_arguments_issue:                          "\(vector_repo)/issues/1966"
	vector_guides:                                            "\(vector_website)/guides/"
	vector_glibc_benchmarks:                                  "\(vector_repo)/issues/2313"
	vector_graphql_playground:                                "https://playground.vector.dev:8686/playground"
	vector_highlights:                                        "\(vector_website)/highlights/"
	vector_host_metrics_source:                               "\(vector_website)/docs/reference/configuration/sources/host_metrics/"
	vector_http_auth_token:                                   "\(vector_website)/docs/reference/configuration/sinks/http/#token"
	vector_homebrew:                                          "\(vector_website)/docs/setup/installation/package-managers/homebrew/"
	vector_homebrew_source_files:                             "\(github)/timberio/homebrew-brew/blob/master/Formula/vector.rb"
	vector_http_source:                                       "\(vector_website)/docs/reference/configuration/sources/http/"
	vector_initd_service:                                     "\(vector_repo)/blob/master/distribution/init.d/vector"
	vector_installer:                                         "https://sh.vector.dev"
	vector_issues:                                            "\(vector_repo)/issues"
	vector_journald_source:                                   "\(vector_website)/docs/reference/configuration/sources/journald/"
	vector_kubernetes_logs_source:                            "\(vector_website)/docs/reference/configuration/sources/kubernetes_logs/"
	vector_level_up:                                          "\(vector_website)/guides/level-up/"
	vector_log:                                               "\(vector_website)/docs/about/data-model/log/"
	vector_log_data_types:                                    "\(vector_website)/docs/about/data-model/log/#types"
	vector_lua_rfc:                                           "\(vector_repo)/blob/master/rfcs/2020-03-06-1999-api-extensions-for-lua-transform.md"
	vector_metric:                                            "\(vector_website)/docs/about/data-model/metric/"
	vector_msi_source_files:                                  "\(vector_repo)/tree/master/distribution/msi"
	vector_nightly_builds:                                    "https://packages.timber.io/vector/nightly/latest/"
	vector_nix_package:                                       "\(github)/NixOS/nixpkgs/blob/master/pkgs/tools/misc/vector/default.nix"
	vector_parsing_transforms:                                "\(vector_website)/components/?functions%5B%5D=parse"
	vector_performance:                                       "\(vector_website)/#performance"
	vector_privacy_policy:                                    "\(vector_repo)/blob/master/PRIVACY.md"
	vector_programmable_transforms:                           "\(vector_website)/components/?functions%5B%5D=program"
	vector_pull_requests:                                     "\(vector_repo)/pulls"
	vector_receiving_sources:                                 "\(vector_website)/components/?functions%5B%5D=receive"
	vector_regex_parser:                                      "\(vector_website)/docs/reference/configuration/transforms/regex_parser/"
	vector_releases:                                          "\(vector_website)/releases/latest/"
	vector_release_v0_14_0_full:                              "https://packages.timber.io/vector/v0.14.0"
	vector_release_v0_14_0:                                   "\(vector_website)/releases/v0.14.0/"
	vector_reduce_transform:                                  "\(vector_website)/docs/reference/configuration/transforms/reduce/"
	vector_release_policy:                                    "https://github.com/timberio/vector/blob/master/RELEASING.md"
	vector_remap_transform:                                   "\(vector_website)/docs/reference/configuration/transforms/remap/"
	vector_repo:                                              "\(github)/timberio/vector"
	vector_roadmap:                                           "https://roadmap.vector.dev"
	vector_rpm_source_files:                                  "\(vector_repo)/tree/master/distribution/rpm"
	vector_security_policy:                                   "\(vector_repo)/security/policy"
	vector_semantic_yml:                                      "\(vector_repo)/blob/master/.github/semantic.yml"
	vector_sink:                                              "\(vector_website)/docs/reference/configuration/sinks/vector"
	vector_sinks:                                             "\(vector_website)/docs/reference/configuration/sinks/"
	vector_sink_http_batch:                                   "\(vector_website)/docs/reference/configuration/sinks/http/#batch"
	vector_sink_kafka_sasl:                                   "\(vector_website)/docs/reference/configuration/sources/kafka/#sasl"
	vector_socket_source:                                     "\(vector_website)/docs/reference/configuration/sources/socket/"
	vector_source:                                            "\(vector_website)/docs/reference/configuration/sources/vector/"
	vector_sources:                                           "\(vector_website)/docs/reference/configuration/sources/"
	vector_stars:                                             "\(vector_repo)/stargazers"
	vector_stdin_source:                                      "\(vector_website)/docs/reference/configuration/sources/stdin/"
	vector_systemd_file:                                      "\(vector_repo)/blob/master/distribution/systemd/vector.service"
	vector_test_harness:                                      "\(vector_repo)-test-harness/"
	vector_transform_aws_cloudwatch_logs_subscription_parser: "\(vector_website)/docs/reference/configuration/transforms/aws_cloudwatch_logs_subscription_parser"
	vector_transforms:                                        "\(vector_website)/docs/reference/configuration/transforms/"
	vector_twitter:                                           "https://twitter.com/vectordotdev"
	vector_unit_testing:                                      "\(vector_website)/guides/level-up/unit-testing/"
	vector_version_branches:                                  "\(vector_repo)/branches/all?query=v"
	vector_website:                                           "https://vector.dev"
	vrl_announcement:                                         "\(vector_website)/blog/vector-remap-language"
	vrl_error_handling:                                       "\(vrl_errors_reference)#handling"
	vrl_error_handling_assigning:                             "\(vrl_errors_reference)#assigning"
	vrl_error_handling_coalescing:                            "\(vrl_errors_reference)#coalesing"
	vrl_error_handling_raising:                               "\(vrl_errors_reference)#raising"
	vrl_errors_reference:                                     "\(vrl_reference)errors/"
	vrl_expressions:                                          "\(vrl_reference)expressions/"
	vrl_fail_safety:                                          "\(vrl_reference)#fail-safety"
	vrl_features:                                             "\(vrl_reference)#features"
	vrl_functions:                                            "\(vrl_reference)functions/"
	vrl_literals:                                             "\(vrl_expressions)#literal-expressions"
	vrl_parsing_functions:                                    "\(vrl_functions)#parse-functions"
	vrl_path_expressions:                                     "\(vrl_expressions)#path"
	vrl_performance:                                          "\(vrl_reference)#performance"
	vrl_reference:                                            "\(vector_website)/docs/reference/vrl/"
	vrl_runtime_errors:                                       "\(vrl_errors_reference)#runtime-errors"
	vrl_safety:                                               "\(vrl_reference)#safety"
	vrl_type_safety:                                          "\(vrl_reference)#type-safety"
	vote_feature:                                             "\(vector_repo)/issues?q=is%3Aissue+is%3Aopen+sort%3Areactions-%2B1-desc+label%3A%22Type%3A+New+Feature%22"
	wasm:                                                     "https://webassembly.org/"
	wasm_languages:                                           "\(github)/appcypher/awesome-wasm-langs"
	wikipedia:                                                "https://en.wikipedia.org"
	windows:                                                  "https://www.microsoft.com/en-us/windows"
	windows_installer:                                        "\(wikipedia)/wiki/Windows_Installer"
	windows_service:                                          "https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/new-service"
	yaml:                                                     "https://yaml.org/"
	yum:                                                      "\(wikipedia)/wiki/Yum_(software)"
	zlib:                                                     "https://www.zlib.net"
	zstd:                                                     "https://zstd.net"
}
