// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeConformancePackComplianceInput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// A ConformancePackComplianceFilters object.
	Filters *ConformancePackComplianceFilters `type:"structure"`

	// The maximum number of AWS Config rules within a conformance pack are returned
	// on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePackComplianceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConformancePackComplianceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeConformancePackComplianceInput"}

	if s.ConformancePackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConformancePackName"))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeConformancePackComplianceOutput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Returns a list of ConformancePackRuleCompliance objects.
	//
	// ConformancePackRuleComplianceList is a required field
	ConformancePackRuleComplianceList []ConformancePackRuleCompliance `type:"list" required:"true"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePackComplianceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConformancePackCompliance = "DescribeConformancePackCompliance"

// DescribeConformancePackComplianceRequest returns a request value for making API operation for
// AWS Config.
//
// Returns compliance details for each rule in that conformance pack.
//
// You must provide exact rule names.
//
//    // Example sending a request using DescribeConformancePackComplianceRequest.
//    req := client.DescribeConformancePackComplianceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance
func (c *Client) DescribeConformancePackComplianceRequest(input *DescribeConformancePackComplianceInput) DescribeConformancePackComplianceRequest {
	op := &aws.Operation{
		Name:       opDescribeConformancePackCompliance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConformancePackComplianceInput{}
	}

	req := c.newRequest(op, input, &DescribeConformancePackComplianceOutput{})
	return DescribeConformancePackComplianceRequest{Request: req, Input: input, Copy: c.DescribeConformancePackComplianceRequest}
}

// DescribeConformancePackComplianceRequest is the request type for the
// DescribeConformancePackCompliance API operation.
type DescribeConformancePackComplianceRequest struct {
	*aws.Request
	Input *DescribeConformancePackComplianceInput
	Copy  func(*DescribeConformancePackComplianceInput) DescribeConformancePackComplianceRequest
}

// Send marshals and sends the DescribeConformancePackCompliance API request.
func (r DescribeConformancePackComplianceRequest) Send(ctx context.Context) (*DescribeConformancePackComplianceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConformancePackComplianceResponse{
		DescribeConformancePackComplianceOutput: r.Request.Data.(*DescribeConformancePackComplianceOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConformancePackComplianceResponse is the response type for the
// DescribeConformancePackCompliance API operation.
type DescribeConformancePackComplianceResponse struct {
	*DescribeConformancePackComplianceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConformancePackCompliance request.
func (r *DescribeConformancePackComplianceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
