package migrate

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/migrate/mgmt/2020-01-01/migrate"

// AgentConfiguration ...
type AgentConfiguration struct {
	AgentID                 *string `json:"agentId,omitempty"`
	DependencyAgentID       *string `json:"dependencyAgentId,omitempty"`
	DependencyAgentVersion  *string `json:"dependencyAgentVersion,omitempty"`
	DependencyAgentRevision *string `json:"dependencyAgentRevision,omitempty"`
	// RebootStatus - Possible values include: 'RebootStatusUnknown', 'RebootStatusRebooted', 'RebootStatusNotRebooted'
	RebootStatus     RebootStatus `json:"rebootStatus,omitempty"`
	ClockGranularity *int32       `json:"clockGranularity,omitempty"`
}

// Application application in the guest virtual machine.
type Application struct {
	// Name - READ-ONLY; Name of the Application.
	Name *string `json:"name,omitempty"`
	// Version - READ-ONLY; Version of the Application.
	Version *string `json:"version,omitempty"`
	// Provider - READ-ONLY; Provider of the Application.
	Provider *string `json:"provider,omitempty"`
}

// AppsAndRoles appsAndRoles in the guest virtual machine.
type AppsAndRoles struct {
	// Applications - READ-ONLY; Applications of the AppsAndRoles.
	Applications *[]Application `json:"applications,omitempty"`
	// WebApplications - READ-ONLY; WebApplications of the AppsAndRoles.
	WebApplications *[]WebApplication `json:"webApplications,omitempty"`
	// Features - READ-ONLY; Features of the AppsAndRoles.
	Features *[]Feature `json:"features,omitempty"`
	// SQLServers - READ-ONLY; SQLServers of the AppsAndRoles.
	SQLServers *[]SQLServer `json:"sqlServers,omitempty"`
	// SharePointServers - READ-ONLY; SharePointServers of the AppsAndRoles.
	SharePointServers *[]SharePointServer `json:"sharePointServers,omitempty"`
	// SystemCenters - READ-ONLY; SystemCenters of the AppsAndRoles.
	SystemCenters *[]SystemCenter `json:"systemCenters,omitempty"`
	// BizTalkServers - READ-ONLY; BizTalkServers of the AppsAndRoles.
	BizTalkServers *[]BizTalkServer `json:"bizTalkServers,omitempty"`
	// ExchangeServers - READ-ONLY; ExchangeServers of the AppsAndRoles.
	ExchangeServers *[]ExchangeServer `json:"exchangeServers,omitempty"`
	// OtherDatabases - READ-ONLY; OtherDatabaseServers of the AppsAndRoles.
	OtherDatabases *[]OtherDatabase `json:"otherDatabases,omitempty"`
}

// BizTalkServer bizTalkServer in the guest virtual machine.
type BizTalkServer struct {
	// ProductName - READ-ONLY; ProductName of the BizTalkServer.
	ProductName *string `json:"productName,omitempty"`
	// Status - READ-ONLY; Status of the BizTalkServer.
	Status *string `json:"status,omitempty"`
}

// ErrorDetails error contract returned when some exception occurs in Rest API.
type ErrorDetails struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message.
	Message *string `json:"message,omitempty"`
	// PossibleCauses - READ-ONLY; Possible causes of error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - READ-ONLY; Recommended action to resolve error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// Severity - READ-ONLY; Error severity.
	Severity *string `json:"severity,omitempty"`
	// IsAgentReportedError - READ-ONLY; Value indicating whether the error originated from a agent or not.
	IsAgentReportedError *bool `json:"isAgentReportedError,omitempty"`
	// AgentErrorCode - READ-ONLY; Agent error code.
	AgentErrorCode *string `json:"agentErrorCode,omitempty"`
	// AgentErrorMessage - READ-ONLY; Error message from the agent.
	AgentErrorMessage *string `json:"agentErrorMessage,omitempty"`
	// AgentErrorPossibleCauses - READ-ONLY; Possible causes for the agent error.
	AgentErrorPossibleCauses *string `json:"agentErrorPossibleCauses,omitempty"`
	// AgentErrorRecommendedAction - READ-ONLY; Recommended action for the agent error.
	AgentErrorRecommendedAction *string `json:"agentErrorRecommendedAction,omitempty"`
}

// ExchangeServer exchangeServer in the guest virtual machine.
type ExchangeServer struct {
	// ProductName - READ-ONLY; ProductName of the ExchangeServer.
	ProductName *string `json:"productName,omitempty"`
	// Edition - READ-ONLY; Edition of the ExchangeServer.
	Edition *string `json:"edition,omitempty"`
	// Roles - READ-ONLY; Roles of the ExchangeServer.
	Roles *string `json:"roles,omitempty"`
	// ServicePack - READ-ONLY; ServicePack of the ExchangeServer.
	ServicePack *string `json:"servicePack,omitempty"`
	// Version - READ-ONLY; Version of the ExchangeServer.
	Version *string `json:"version,omitempty"`
}

// Feature feature in the guest virtual machine.
type Feature struct {
	// Name - READ-ONLY; Name of the Feature.
	Name *string `json:"name,omitempty"`
	// FeatureType - READ-ONLY; FeatureType of the Feature.
	FeatureType *string `json:"featureType,omitempty"`
	// Parent - READ-ONLY; Parent of the Feature.
	Parent *string `json:"parent,omitempty"`
	// Status - READ-ONLY; Status of the Feature.
	Status *string `json:"status,omitempty"`
}

// GuestOSDetails data related to a machine's operating system. Serialized and stored as part of Machine
// Rest object.
type GuestOSDetails struct {
	// OsType - Type of the operating system.
	OsType *string `json:"osType,omitempty"`
	// OsName - READ-ONLY; Name of the operating system.
	OsName *string `json:"osName,omitempty"`
	// OsVersion - READ-ONLY; Version of the operating system.
	OsVersion *string `json:"osVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for GuestOSDetails.
func (god GuestOSDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if god.OsType != nil {
		objectMap["osType"] = god.OsType
	}
	return json.Marshal(objectMap)
}

// HealthErrorDetails error contract returned when some exception occurs in Rest API.
type HealthErrorDetails struct {
	// ID - READ-ONLY; Error ID.
	ID *int64 `json:"id,omitempty"`
	// Code - READ-ONLY; Error name.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message.
	Message *string `json:"message,omitempty"`
	// PossibleCauses - READ-ONLY; Possible causes of error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - READ-ONLY; Recommended action to resolve error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// Severity - READ-ONLY; Error severity.
	Severity *string `json:"severity,omitempty"`
	// SummaryMessage - READ-ONLY; Error summary message.
	SummaryMessage *string `json:"summaryMessage,omitempty"`
	// Source - READ-ONLY; Error source.
	Source *string `json:"source,omitempty"`
	// MessageParameters - READ-ONLY; Message parameters.
	MessageParameters map[string]*string `json:"messageParameters"`
}

// MarshalJSON is the custom marshaler for HealthErrorDetails.
func (hed HealthErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// HostingConfiguration ...
type HostingConfiguration struct {
	Provider *string `json:"provider,omitempty"`
}

// HyperVCluster cluster REST Resource.
type HyperVCluster struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Name of the cluster.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/hyperVSites/clusters.
	Type *string `json:"type,omitempty"`
	// Properties - Nested properties of the cluster.
	Properties *HyperVClusterProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVCluster.
func (hvc HyperVCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hvc.Name != nil {
		objectMap["name"] = hvc.Name
	}
	if hvc.Properties != nil {
		objectMap["properties"] = hvc.Properties
	}
	return json.Marshal(objectMap)
}

// HyperVClusterCollection collection of Hyper-V clusters.
type HyperVClusterCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of clusters.
	Value *[]HyperVCluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// HyperVClusterCollectionIterator provides access to a complete listing of HyperVCluster values.
type HyperVClusterCollectionIterator struct {
	i    int
	page HyperVClusterCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HyperVClusterCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVClusterCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HyperVClusterCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HyperVClusterCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HyperVClusterCollectionIterator) Response() HyperVClusterCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HyperVClusterCollectionIterator) Value() HyperVCluster {
	if !iter.page.NotDone() {
		return HyperVCluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HyperVClusterCollectionIterator type.
func NewHyperVClusterCollectionIterator(page HyperVClusterCollectionPage) HyperVClusterCollectionIterator {
	return HyperVClusterCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hvcc HyperVClusterCollection) IsEmpty() bool {
	return hvcc.Value == nil || len(*hvcc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hvcc HyperVClusterCollection) hasNextLink() bool {
	return hvcc.NextLink != nil && len(*hvcc.NextLink) != 0
}

// hyperVClusterCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hvcc HyperVClusterCollection) hyperVClusterCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !hvcc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hvcc.NextLink)))
}

// HyperVClusterCollectionPage contains a page of HyperVCluster values.
type HyperVClusterCollectionPage struct {
	fn   func(context.Context, HyperVClusterCollection) (HyperVClusterCollection, error)
	hvcc HyperVClusterCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HyperVClusterCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVClusterCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hvcc)
		if err != nil {
			return err
		}
		page.hvcc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HyperVClusterCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HyperVClusterCollectionPage) NotDone() bool {
	return !page.hvcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HyperVClusterCollectionPage) Response() HyperVClusterCollection {
	return page.hvcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HyperVClusterCollectionPage) Values() []HyperVCluster {
	if page.hvcc.IsEmpty() {
		return nil
	}
	return *page.hvcc.Value
}

// Creates a new instance of the HyperVClusterCollectionPage type.
func NewHyperVClusterCollectionPage(cur HyperVClusterCollection, getNextPage func(context.Context, HyperVClusterCollection) (HyperVClusterCollection, error)) HyperVClusterCollectionPage {
	return HyperVClusterCollectionPage{
		fn:   getNextPage,
		hvcc: cur,
	}
}

// HyperVClusterProperties class for cluster properties.
type HyperVClusterProperties struct {
	// CreatedTimestamp - READ-ONLY; Timestamp marking Hyper-V cluster creation.
	CreatedTimestamp *string `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Timestamp marking last updated on the Hyper-V cluster.
	UpdatedTimestamp *string `json:"updatedTimestamp,omitempty"`
	// Fqdn - FQDN/IPAddress of the Hyper-V cluster.
	Fqdn *string `json:"fqdn,omitempty"`
	// FunctionalLevel - READ-ONLY; Functional level of the Hyper-V cluster.
	FunctionalLevel *int32 `json:"functionalLevel,omitempty"`
	// Status - READ-ONLY; Status of the Hyper-V cluster.
	Status *string `json:"status,omitempty"`
	// RunAsAccountID - Run as account ID of the Hyper-V cluster.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// HostFqdnList - List of hosts (FQDN) currently being tracked by the cluster.
	HostFqdnList *[]string `json:"hostFqdnList,omitempty"`
	// Errors - READ-ONLY; Errors for Hyper-V clusters.
	Errors *[]HealthErrorDetails `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVClusterProperties.
func (hvcp HyperVClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hvcp.Fqdn != nil {
		objectMap["fqdn"] = hvcp.Fqdn
	}
	if hvcp.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = hvcp.RunAsAccountID
	}
	if hvcp.HostFqdnList != nil {
		objectMap["hostFqdnList"] = hvcp.HostFqdnList
	}
	return json.Marshal(objectMap)
}

// HyperVDisk second level object returned as part of Machine REST resource.
type HyperVDisk struct {
	// InstanceID - READ-ONLY; Id of the disk.
	InstanceID *string `json:"instanceId,omitempty"`
	// VhdID - READ-ONLY; VHD Id of the disk.
	VhdID *string `json:"vhdId,omitempty"`
	// MaxSizeInBytes - READ-ONLY; Bytes allocated for the disk.
	MaxSizeInBytes *int64 `json:"maxSizeInBytes,omitempty"`
	// Name - READ-ONLY; Name of the disk.
	Name *string `json:"name,omitempty"`
	// DiskType - READ-ONLY; Type of the disk.
	DiskType *string `json:"diskType,omitempty"`
	// Lun - READ-ONLY; LUN of the disk.
	Lun *int32 `json:"lun,omitempty"`
	// Path - READ-ONLY; Path of the disk.
	Path *string `json:"path,omitempty"`
}

// HyperVHost host REST Resource.
type HyperVHost struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Name of the host.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/hyperVSites/hosts.
	Type *string `json:"type,omitempty"`
	// Properties - Nested properties.
	Properties *HyperVHostProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVHost.
func (hvh HyperVHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hvh.Name != nil {
		objectMap["name"] = hvh.Name
	}
	if hvh.Properties != nil {
		objectMap["properties"] = hvh.Properties
	}
	return json.Marshal(objectMap)
}

// HyperVHostCollection collection of Hyper-V hosts.
type HyperVHostCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of hosts.
	Value *[]HyperVHost `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// HyperVHostCollectionIterator provides access to a complete listing of HyperVHost values.
type HyperVHostCollectionIterator struct {
	i    int
	page HyperVHostCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HyperVHostCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVHostCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HyperVHostCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HyperVHostCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HyperVHostCollectionIterator) Response() HyperVHostCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HyperVHostCollectionIterator) Value() HyperVHost {
	if !iter.page.NotDone() {
		return HyperVHost{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HyperVHostCollectionIterator type.
func NewHyperVHostCollectionIterator(page HyperVHostCollectionPage) HyperVHostCollectionIterator {
	return HyperVHostCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hvhc HyperVHostCollection) IsEmpty() bool {
	return hvhc.Value == nil || len(*hvhc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hvhc HyperVHostCollection) hasNextLink() bool {
	return hvhc.NextLink != nil && len(*hvhc.NextLink) != 0
}

// hyperVHostCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hvhc HyperVHostCollection) hyperVHostCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !hvhc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hvhc.NextLink)))
}

// HyperVHostCollectionPage contains a page of HyperVHost values.
type HyperVHostCollectionPage struct {
	fn   func(context.Context, HyperVHostCollection) (HyperVHostCollection, error)
	hvhc HyperVHostCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HyperVHostCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVHostCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hvhc)
		if err != nil {
			return err
		}
		page.hvhc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HyperVHostCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HyperVHostCollectionPage) NotDone() bool {
	return !page.hvhc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HyperVHostCollectionPage) Response() HyperVHostCollection {
	return page.hvhc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HyperVHostCollectionPage) Values() []HyperVHost {
	if page.hvhc.IsEmpty() {
		return nil
	}
	return *page.hvhc.Value
}

// Creates a new instance of the HyperVHostCollectionPage type.
func NewHyperVHostCollectionPage(cur HyperVHostCollection, getNextPage func(context.Context, HyperVHostCollection) (HyperVHostCollection, error)) HyperVHostCollectionPage {
	return HyperVHostCollectionPage{
		fn:   getNextPage,
		hvhc: cur,
	}
}

// HyperVHostProperties class for host properties.
type HyperVHostProperties struct {
	// CreatedTimestamp - READ-ONLY; Timestamp marking Hyper-V host creation.
	CreatedTimestamp *string `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Timestamp marking last updated on the Hyper-V host.
	UpdatedTimestamp *string `json:"updatedTimestamp,omitempty"`
	// Fqdn - FQDN/IPAddress of the Hyper-V host.
	Fqdn *string `json:"fqdn,omitempty"`
	// RunAsAccountID - Run as account ID of the Hyper-V host.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// Version - READ-ONLY; Version of the Hyper-V host.
	Version *string `json:"version,omitempty"`
	// Errors - READ-ONLY; Errors for Hyper-V hosts.
	Errors *[]HealthErrorDetails `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVHostProperties.
func (hvhp HyperVHostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hvhp.Fqdn != nil {
		objectMap["fqdn"] = hvhp.Fqdn
	}
	if hvhp.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = hvhp.RunAsAccountID
	}
	return json.Marshal(objectMap)
}

// HypervisorConfiguration ...
type HypervisorConfiguration struct {
	// HypervisorType - Possible values include: 'HypervisorTypeUnknown', 'HypervisorTypeHyperv'
	HypervisorType      HypervisorType `json:"hypervisorType,omitempty"`
	NativeHostMachineID *string        `json:"nativeHostMachineId,omitempty"`
}

// HyperVJob job REST Resource.
type HyperVJob struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Job.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/HyperVSites/Jobs.
	Type *string `json:"type,omitempty"`
	// Properties - READ-ONLY; nested properties of Hyper-V job.
	Properties *JobProperties `json:"properties,omitempty"`
}

// HyperVJobCollection collection of Hyper-V jobs.
type HyperVJobCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of jobs.
	Value *[]HyperVJob `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// HyperVJobCollectionIterator provides access to a complete listing of HyperVJob values.
type HyperVJobCollectionIterator struct {
	i    int
	page HyperVJobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HyperVJobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVJobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HyperVJobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HyperVJobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HyperVJobCollectionIterator) Response() HyperVJobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HyperVJobCollectionIterator) Value() HyperVJob {
	if !iter.page.NotDone() {
		return HyperVJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HyperVJobCollectionIterator type.
func NewHyperVJobCollectionIterator(page HyperVJobCollectionPage) HyperVJobCollectionIterator {
	return HyperVJobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hvjc HyperVJobCollection) IsEmpty() bool {
	return hvjc.Value == nil || len(*hvjc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hvjc HyperVJobCollection) hasNextLink() bool {
	return hvjc.NextLink != nil && len(*hvjc.NextLink) != 0
}

// hyperVJobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hvjc HyperVJobCollection) hyperVJobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !hvjc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hvjc.NextLink)))
}

// HyperVJobCollectionPage contains a page of HyperVJob values.
type HyperVJobCollectionPage struct {
	fn   func(context.Context, HyperVJobCollection) (HyperVJobCollection, error)
	hvjc HyperVJobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HyperVJobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVJobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hvjc)
		if err != nil {
			return err
		}
		page.hvjc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HyperVJobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HyperVJobCollectionPage) NotDone() bool {
	return !page.hvjc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HyperVJobCollectionPage) Response() HyperVJobCollection {
	return page.hvjc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HyperVJobCollectionPage) Values() []HyperVJob {
	if page.hvjc.IsEmpty() {
		return nil
	}
	return *page.hvjc.Value
}

// Creates a new instance of the HyperVJobCollectionPage type.
func NewHyperVJobCollectionPage(cur HyperVJobCollection, getNextPage func(context.Context, HyperVJobCollection) (HyperVJobCollection, error)) HyperVJobCollectionPage {
	return HyperVJobCollectionPage{
		fn:   getNextPage,
		hvjc: cur,
	}
}

// HyperVMachine machine REST Resource.
type HyperVMachine struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Sites.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/HyperVSites/Machines.
	Type *string `json:"type,omitempty"`
	// Properties - READ-ONLY; Nested properties.
	Properties *HyperVMachineProperties `json:"properties,omitempty"`
}

// HyperVMachineCollection collection of Hyper-V machines.
type HyperVMachineCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of machines.
	Value *[]HyperVMachine `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// HyperVMachineCollectionIterator provides access to a complete listing of HyperVMachine values.
type HyperVMachineCollectionIterator struct {
	i    int
	page HyperVMachineCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HyperVMachineCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVMachineCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HyperVMachineCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HyperVMachineCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HyperVMachineCollectionIterator) Response() HyperVMachineCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HyperVMachineCollectionIterator) Value() HyperVMachine {
	if !iter.page.NotDone() {
		return HyperVMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HyperVMachineCollectionIterator type.
func NewHyperVMachineCollectionIterator(page HyperVMachineCollectionPage) HyperVMachineCollectionIterator {
	return HyperVMachineCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hvmc HyperVMachineCollection) IsEmpty() bool {
	return hvmc.Value == nil || len(*hvmc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hvmc HyperVMachineCollection) hasNextLink() bool {
	return hvmc.NextLink != nil && len(*hvmc.NextLink) != 0
}

// hyperVMachineCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hvmc HyperVMachineCollection) hyperVMachineCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !hvmc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hvmc.NextLink)))
}

// HyperVMachineCollectionPage contains a page of HyperVMachine values.
type HyperVMachineCollectionPage struct {
	fn   func(context.Context, HyperVMachineCollection) (HyperVMachineCollection, error)
	hvmc HyperVMachineCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HyperVMachineCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVMachineCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hvmc)
		if err != nil {
			return err
		}
		page.hvmc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HyperVMachineCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HyperVMachineCollectionPage) NotDone() bool {
	return !page.hvmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HyperVMachineCollectionPage) Response() HyperVMachineCollection {
	return page.hvmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HyperVMachineCollectionPage) Values() []HyperVMachine {
	if page.hvmc.IsEmpty() {
		return nil
	}
	return *page.hvmc.Value
}

// Creates a new instance of the HyperVMachineCollectionPage type.
func NewHyperVMachineCollectionPage(cur HyperVMachineCollection, getNextPage func(context.Context, HyperVMachineCollection) (HyperVMachineCollection, error)) HyperVMachineCollectionPage {
	return HyperVMachineCollectionPage{
		fn:   getNextPage,
		hvmc: cur,
	}
}

// HyperVMachineProperties class for machine properties.
type HyperVMachineProperties struct {
	// HostFqdn - READ-ONLY; Host FQDN/IPAddress.
	HostFqdn *string `json:"hostFqdn,omitempty"`
	// HostID - READ-ONLY; Host ARM ID.
	HostID *string `json:"hostId,omitempty"`
	// ClusterFqdn - READ-ONLY; Cluster FQDN/IPAddress.
	ClusterFqdn *string `json:"clusterFqdn,omitempty"`
	// ClusterID - READ-ONLY; Cluster ARM ID.
	ClusterID *string `json:"clusterId,omitempty"`
	// ManagementServerType - READ-ONLY; Management server type of the machine. It is either Host or Cluster.
	ManagementServerType *string `json:"managementServerType,omitempty"`
	// Generation - READ-ONLY; Generation of the virtual machine.
	Generation *int32 `json:"generation,omitempty"`
	// Version - READ-ONLY; VM version.
	Version *string `json:"version,omitempty"`
	// HighAvailability - READ-ONLY; Value indicating whether the VM is highly available. Possible values include: 'HighlyAvailableUnknown', 'HighlyAvailableNo', 'HighlyAvailableYes'
	HighAvailability HighlyAvailable `json:"highAvailability,omitempty"`
	// MaxMemoryMB - READ-ONLY; Max memory of the virtual machine in MB.
	MaxMemoryMB *int32 `json:"maxMemoryMB,omitempty"`
	// Firmware - READ-ONLY; Firmware of the machine.
	Firmware *string `json:"firmware,omitempty"`
	// IsDynamicMemoryEnabled - READ-ONLY; Value indicating whether dynamic memory is enabled for the VM.
	IsDynamicMemoryEnabled *bool `json:"isDynamicMemoryEnabled,omitempty"`
	// Disks - READ-ONLY; Disks attached to the machine.
	Disks *[]HyperVDisk `json:"disks,omitempty"`
	// AppsAndRoles - READ-ONLY; Apps and Roles of the VM.
	AppsAndRoles *AppsAndRoles `json:"appsAndRoles,omitempty"`
	// NetworkAdapters - READ-ONLY; Network adapters attached to the machine.
	NetworkAdapters *[]HyperVNetworkAdapter `json:"networkAdapters,omitempty"`
	// DisplayName - READ-ONLY; Display name of the machine.
	DisplayName *string `json:"displayName,omitempty"`
	// NumberOfProcessorCore - READ-ONLY; Number of Processor Cores allocated for the machine.
	NumberOfProcessorCore *int32 `json:"numberOfProcessorCore,omitempty"`
	// AllocatedMemoryInMB - READ-ONLY; Allocated Memory in MB.
	AllocatedMemoryInMB *float64 `json:"allocatedMemoryInMB,omitempty"`
	// VMConfigurationFileLocation - READ-ONLY; Root location of the VM configuration file.
	VMConfigurationFileLocation *string `json:"vmConfigurationFileLocation,omitempty"`
	// OperatingSystemDetails - READ-ONLY; Operating System Details installed on the machine.
	OperatingSystemDetails *OperatingSystem `json:"operatingSystemDetails,omitempty"`
	// GuestOSDetails - READ-ONLY; Operating System Details extracted from the guest by executing script inside the guest VM.
	GuestOSDetails *GuestOSDetails `json:"guestOSDetails,omitempty"`
	// NumberOfApplications - READ-ONLY; Number of applications installed in the guest VM.
	NumberOfApplications *int32 `json:"numberOfApplications,omitempty"`
	// GuestDetailsDiscoveryTimestamp - READ-ONLY; The last time at which the Guest Details of machine was discovered.
	GuestDetailsDiscoveryTimestamp *date.Time `json:"guestDetailsDiscoveryTimestamp,omitempty"`
	// IsGuestDetailsDiscoveryInProgress - READ-ONLY; Whether Refresh Fabric Layout Guest Details has been completed once. Portal will show discovery in progress, if this value is true.
	IsGuestDetailsDiscoveryInProgress *bool `json:"isGuestDetailsDiscoveryInProgress,omitempty"`
	// CreatedTimestamp - READ-ONLY; Timestamp marking machine creation.
	CreatedTimestamp *string `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Timestamp marking last updated on the machine.
	UpdatedTimestamp *string `json:"updatedTimestamp,omitempty"`
	// InstanceUUID - READ-ONLY; On-premise Instance UUID of the machine.
	InstanceUUID *string `json:"instanceUuid,omitempty"`
	// PowerStatus - READ-ONLY; Machine power status.
	PowerStatus *string `json:"powerStatus,omitempty"`
	// BiosSerialNumber - READ-ONLY; Machine BIOS serial number.
	BiosSerialNumber *string `json:"biosSerialNumber,omitempty"`
	// BiosGUID - READ-ONLY; Machine BIOS GUID.
	BiosGUID *string `json:"biosGuid,omitempty"`
	// VMFqdn - READ-ONLY; Machine FQDN.
	VMFqdn *string `json:"vmFqdn,omitempty"`
	// IsDeleted - READ-ONLY; Value indicating whether VM is deleted.
	IsDeleted *bool `json:"isDeleted,omitempty"`
	// Errors - READ-ONLY; Errors for machine.
	Errors *[]HealthErrorDetails `json:"errors,omitempty"`
}

// HyperVNetworkAdapter second level object represented in responses as part of Machine REST resource.
type HyperVNetworkAdapter struct {
	// NetworkID - READ-ONLY; Network Id.
	NetworkID *string `json:"networkId,omitempty"`
	// SubnetName - READ-ONLY; Name of the VM subnet within the virtual network the NIC is attached to.
	SubnetName *string `json:"subnetName,omitempty"`
	// StaticIPAddress - READ-ONLY; Static IP address.
	StaticIPAddress *string `json:"staticIpAddress,omitempty"`
	// NicType - READ-ONLY; Mac address of the NIC.
	NicType *string `json:"nicType,omitempty"`
	// NicID - READ-ONLY; NIC Id.
	NicID *string `json:"nicId,omitempty"`
	// MacAddress - READ-ONLY; Mac address of the NIC.
	MacAddress *string `json:"macAddress,omitempty"`
	// IPAddressList - READ-ONLY; IP addresses for the machine.
	IPAddressList *[]string `json:"ipAddressList,omitempty"`
	// NetworkName - READ-ONLY; Network Name.
	NetworkName *string `json:"networkName,omitempty"`
	// IPAddressType - READ-ONLY; Type of the IP address.
	IPAddressType *string `json:"ipAddressType,omitempty"`
}

// HyperVRunAsAccount run as account REST Resource.
type HyperVRunAsAccount struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Sites.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/HyperVSites/RunAsAccounts.
	Type *string `json:"type,omitempty"`
	// Properties - READ-ONLY; Nested properties of run as account.
	Properties *RunAsAccountProperties `json:"properties,omitempty"`
}

// HyperVRunAsAccountCollection collection of Hyper-V run as accounts.
type HyperVRunAsAccountCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of run as accounts.
	Value *[]HyperVRunAsAccount `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// HyperVRunAsAccountCollectionIterator provides access to a complete listing of HyperVRunAsAccount values.
type HyperVRunAsAccountCollectionIterator struct {
	i    int
	page HyperVRunAsAccountCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HyperVRunAsAccountCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVRunAsAccountCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HyperVRunAsAccountCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HyperVRunAsAccountCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HyperVRunAsAccountCollectionIterator) Response() HyperVRunAsAccountCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HyperVRunAsAccountCollectionIterator) Value() HyperVRunAsAccount {
	if !iter.page.NotDone() {
		return HyperVRunAsAccount{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HyperVRunAsAccountCollectionIterator type.
func NewHyperVRunAsAccountCollectionIterator(page HyperVRunAsAccountCollectionPage) HyperVRunAsAccountCollectionIterator {
	return HyperVRunAsAccountCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hvraac HyperVRunAsAccountCollection) IsEmpty() bool {
	return hvraac.Value == nil || len(*hvraac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hvraac HyperVRunAsAccountCollection) hasNextLink() bool {
	return hvraac.NextLink != nil && len(*hvraac.NextLink) != 0
}

// hyperVRunAsAccountCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hvraac HyperVRunAsAccountCollection) hyperVRunAsAccountCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !hvraac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hvraac.NextLink)))
}

// HyperVRunAsAccountCollectionPage contains a page of HyperVRunAsAccount values.
type HyperVRunAsAccountCollectionPage struct {
	fn     func(context.Context, HyperVRunAsAccountCollection) (HyperVRunAsAccountCollection, error)
	hvraac HyperVRunAsAccountCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HyperVRunAsAccountCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVRunAsAccountCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hvraac)
		if err != nil {
			return err
		}
		page.hvraac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HyperVRunAsAccountCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HyperVRunAsAccountCollectionPage) NotDone() bool {
	return !page.hvraac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HyperVRunAsAccountCollectionPage) Response() HyperVRunAsAccountCollection {
	return page.hvraac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HyperVRunAsAccountCollectionPage) Values() []HyperVRunAsAccount {
	if page.hvraac.IsEmpty() {
		return nil
	}
	return *page.hvraac.Value
}

// Creates a new instance of the HyperVRunAsAccountCollectionPage type.
func NewHyperVRunAsAccountCollectionPage(cur HyperVRunAsAccountCollection, getNextPage func(context.Context, HyperVRunAsAccountCollection) (HyperVRunAsAccountCollection, error)) HyperVRunAsAccountCollectionPage {
	return HyperVRunAsAccountCollectionPage{
		fn:     getNextPage,
		hvraac: cur,
	}
}

// HyperVSite site REST Resource.
type HyperVSite struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Name of the Hyper-V site.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/HyperVSites.
	Type *string            `json:"type,omitempty"`
	Tags map[string]*string `json:"tags"`
	// ETag - eTag for concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Location - Azure location in which Sites is created.
	Location *string `json:"location,omitempty"`
	// Properties - Nested properties of Hyper-V site.
	Properties *SiteProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVSite.
func (hvs HyperVSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hvs.Name != nil {
		objectMap["name"] = hvs.Name
	}
	if hvs.Tags != nil {
		objectMap["tags"] = hvs.Tags
	}
	if hvs.ETag != nil {
		objectMap["eTag"] = hvs.ETag
	}
	if hvs.Location != nil {
		objectMap["location"] = hvs.Location
	}
	if hvs.Properties != nil {
		objectMap["properties"] = hvs.Properties
	}
	return json.Marshal(objectMap)
}

// HyperVSiteUsage hyper-V site usage.
type HyperVSiteUsage struct {
	autorest.Response `json:"-"`
	// MachineCount - Number of machines discovered in the site.
	MachineCount *int32 `json:"machineCount,omitempty"`
	// RunAsAccountCount - Number of run as accounts in the site.
	RunAsAccountCount *int32 `json:"runAsAccountCount,omitempty"`
	// HostCount - Number of hosts part of the site.
	HostCount *int32 `json:"hostCount,omitempty"`
	// ClusterCount - Number of clusters part of the site.
	ClusterCount *int32 `json:"clusterCount,omitempty"`
}

// Ipv4NetworkInterface ...
type Ipv4NetworkInterface struct {
	IPAddress  *string `json:"ipAddress,omitempty"`
	SubnetMask *string `json:"subnetMask,omitempty"`
}

// Ipv6NetworkInterface ...
type Ipv6NetworkInterface struct {
	IPAddress *string `json:"ipAddress,omitempty"`
}

// JobProperties class for machine properties.
type JobProperties struct {
	// Status - READ-ONLY; Operation status.
	Status *string `json:"status,omitempty"`
	// StartTime - READ-ONLY; Operation start time.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; Operation end time.
	EndTime *string `json:"endTime,omitempty"`
	// DisplayName - READ-ONLY; Display name of the Job.
	DisplayName *string `json:"displayName,omitempty"`
	// ClientRequestID - READ-ONLY; Client request Id used in the operation execution context.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// ActivityID - READ-ONLY; Activity Id used in the operation execution context.
	ActivityID *string `json:"activityId,omitempty"`
	// Errors - READ-ONLY; Errors.
	Errors *[]ErrorDetails `json:"errors,omitempty"`
}

// Machine ...
type Machine struct {
	PropertiesTimestamp *date.Time `json:"properties.timestamp,omitempty"`
	// PropertiesMonitoringState - Possible values include: 'Monitored', 'Discovered'
	PropertiesMonitoringState PropertiesMonitoringState `json:"properties.monitoringState,omitempty"`
	// PropertiesVirtualizationState - Possible values include: 'PropertiesVirtualizationStateUnknown', 'PropertiesVirtualizationStatePhysical', 'PropertiesVirtualizationStateVirtual', 'PropertiesVirtualizationStateHypervisor'
	PropertiesVirtualizationState      PropertiesVirtualizationState  `json:"properties.virtualizationState,omitempty"`
	PropertiesDisplayName              *string                        `json:"properties.displayName,omitempty"`
	PropertiesComputerName             *string                        `json:"properties.computerName,omitempty"`
	PropertiesFullyQualifiedDomainName *string                        `json:"properties.fullyQualifiedDomainName,omitempty"`
	PropertiesBootTime                 *date.Time                     `json:"properties.bootTime,omitempty"`
	PropertiesTimezone                 *Timezone                      `json:"properties.timezone,omitempty"`
	PropertiesAgent                    *AgentConfiguration            `json:"properties.agent,omitempty"`
	PropertiesResources                *MachineResourcesConfiguration `json:"properties.resources,omitempty"`
	PropertiesNetworking               *NetworkConfiguration          `json:"properties.networking,omitempty"`
	PropertiesOperatingSystem          *OperatingSystemConfiguration  `json:"properties.operatingSystem,omitempty"`
	PropertiesVirtualMachine           *VirtualMachineConfiguration   `json:"properties.virtualMachine,omitempty"`
	PropertiesHypervisor               *HypervisorConfiguration       `json:"properties.hypervisor,omitempty"`
	PropertiesHosting                  *HostingConfiguration          `json:"properties.hosting,omitempty"`
	Etag                               *string                        `json:"etag,omitempty"`
	ID                                 *string                        `json:"id,omitempty"`
	Type                               *string                        `json:"type,omitempty"`
	Name                               *string                        `json:"name,omitempty"`
}

// MachineResourcesConfiguration ...
type MachineResourcesConfiguration struct {
	PhysicalMemory *int32 `json:"physicalMemory,omitempty"`
	Cpus           *int32 `json:"cpus,omitempty"`
	CPUSpeed       *int32 `json:"cpuSpeed,omitempty"`
	// CPUSpeedAccuracy - Possible values include: 'Actual', 'Estimated'
	CPUSpeedAccuracy CPUSpeedAccuracy `json:"cpuSpeedAccuracy,omitempty"`
}

// NetworkConfiguration ...
type NetworkConfiguration struct {
	Ipv4Interfaces      *[]Ipv4NetworkInterface `json:"ipv4Interfaces,omitempty"`
	Ipv6Interfaces      *[]Ipv6NetworkInterface `json:"ipv6Interfaces,omitempty"`
	DefaultIpv4Gateways *[]string               `json:"defaultIpv4Gateways,omitempty"`
	MacAddresses        *[]string               `json:"macAddresses,omitempty"`
	DNSNames            *[]string               `json:"dnsNames,omitempty"`
	DNSQuestions        *[]string               `json:"dnsQuestions,omitempty"`
	DNSCanonicalNames   *[]string               `json:"dnsCanonicalNames,omitempty"`
}

// OperatingSystem second level object returned as part of Machine REST resource.
type OperatingSystem struct {
	// OsType - READ-ONLY; Type of the operating system.
	OsType *string `json:"osType,omitempty"`
	// OsName - READ-ONLY; Name of the operating system.
	OsName *string `json:"osName,omitempty"`
	// OsVersion - READ-ONLY; Version of the operating system.
	OsVersion *string `json:"osVersion,omitempty"`
}

// OperatingSystemConfiguration ...
type OperatingSystemConfiguration struct {
	// Family - Possible values include: 'Unknown', 'Windows', 'Linux', 'Solaris', 'Aix'
	Family   Family  `json:"family,omitempty"`
	FullName *string `json:"fullName,omitempty"`
	// Bitness - Possible values include: 'ThreeTwobit', 'SixFourbit'
	Bitness Bitness `json:"bitness,omitempty"`
}

// Operation a REST API operation supported by the provider.
type Operation struct {
	// Name - READ-ONLY; Name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - Displayable properties of the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; Origin of the operation.
	Origin *string `json:"origin,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay displayable properties of the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Provider of the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource operated on by the operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation Type.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationResultList list of API operations.
type OperationResultList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationResultListIterator provides access to a complete listing of Operation values.
type OperationResultListIterator struct {
	i    int
	page OperationResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationResultListIterator) Response() OperationResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationResultListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationResultListIterator type.
func NewOperationResultListIterator(page OperationResultListPage) OperationResultListIterator {
	return OperationResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (orl OperationResultList) IsEmpty() bool {
	return orl.Value == nil || len(*orl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (orl OperationResultList) hasNextLink() bool {
	return orl.NextLink != nil && len(*orl.NextLink) != 0
}

// operationResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (orl OperationResultList) operationResultListPreparer(ctx context.Context) (*http.Request, error) {
	if !orl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(orl.NextLink)))
}

// OperationResultListPage contains a page of Operation values.
type OperationResultListPage struct {
	fn  func(context.Context, OperationResultList) (OperationResultList, error)
	orl OperationResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.orl)
		if err != nil {
			return err
		}
		page.orl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationResultListPage) NotDone() bool {
	return !page.orl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationResultListPage) Response() OperationResultList {
	return page.orl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationResultListPage) Values() []Operation {
	if page.orl.IsEmpty() {
		return nil
	}
	return *page.orl.Value
}

// Creates a new instance of the OperationResultListPage type.
func NewOperationResultListPage(cur OperationResultList, getNextPage func(context.Context, OperationResultList) (OperationResultList, error)) OperationResultListPage {
	return OperationResultListPage{
		fn:  getNextPage,
		orl: cur,
	}
}

// OperationStatus operation status REST resource.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Operation name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Status of the operation. ARM expects the terminal status to be one of Succeeded/ Failed/ Canceled. All other values imply that the operation is still running.
	Status *string `json:"status,omitempty"`
	// StartTime - READ-ONLY; Start time.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; End time.
	EndTime *string `json:"endTime,omitempty"`
	// Error - READ-ONLY; Error stating all error details for the operation.
	Error *OperationStatusError `json:"error,omitempty"`
	// Properties - READ-ONLY; Custom data.
	Properties *OperationStatusProperties `json:"properties,omitempty"`
}

// OperationStatusError class for operation status errors.
type OperationStatusError struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message.
	Message *string `json:"message,omitempty"`
}

// OperationStatusProperties class for operation result properties.
type OperationStatusProperties struct {
	// Result - Result or output of the workflow.
	Result *string `json:"result,omitempty"`
}

// OtherDatabase otherDatabase in the guest virtual machine.
type OtherDatabase struct {
	// DatabaseType - READ-ONLY; DatabaseType of the OtherDatabase.
	DatabaseType *string `json:"databaseType,omitempty"`
	// Instance - READ-ONLY; Instance of the OtherDatabase.
	Instance *string `json:"instance,omitempty"`
	// Version - READ-ONLY; Version of the OtherDatabase.
	Version *string `json:"version,omitempty"`
}

// RunAsAccountProperties class for run as account properties.
type RunAsAccountProperties struct {
	// DisplayName - READ-ONLY; Display name of the run as account.
	DisplayName *string `json:"displayName,omitempty"`
	// CredentialType - READ-ONLY; Credential type of the run as account. Possible values include: 'VMwareFabric', 'HyperVFabric', 'LinuxGuest', 'WindowsGuest', 'LinuxServer', 'WindowsServer'
	CredentialType CredentialType `json:"credentialType,omitempty"`
	// CreatedTimestamp - READ-ONLY; Timestamp marking run as account creation.
	CreatedTimestamp *string `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Timestamp marking last updated on the run as account.
	UpdatedTimestamp *string `json:"updatedTimestamp,omitempty"`
}

// SharePointServer sharePointServer in the guest virtual machine.
type SharePointServer struct {
	// ProductName - READ-ONLY; ProductName of the SharePointServer.
	ProductName *string `json:"productName,omitempty"`
	// IsEnterprise - READ-ONLY; Value indicating whether the SharePointServer is Enterprise.
	IsEnterprise *bool `json:"isEnterprise,omitempty"`
	// Status - READ-ONLY; Status of the SharePointServer.
	Status *string `json:"status,omitempty"`
	// Version - READ-ONLY; Version of the SharePointServer.
	Version *string `json:"version,omitempty"`
}

// SiteAgentProperties class for site agent properties.
type SiteAgentProperties struct {
	// ID - READ-ONLY; ID of the agent.
	ID *string `json:"id,omitempty"`
	// Version - READ-ONLY; Version of the agent.
	Version *string `json:"version,omitempty"`
	// LastHeartBeatUtc - READ-ONLY; Last heartbeat time of the agent in UTC.
	LastHeartBeatUtc *date.Time `json:"lastHeartBeatUtc,omitempty"`
	// KeyVaultURI - Key vault URI.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	// KeyVaultID - Key vault ARM Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteAgentProperties.
func (sap SiteAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sap.KeyVaultURI != nil {
		objectMap["keyVaultUri"] = sap.KeyVaultURI
	}
	if sap.KeyVaultID != nil {
		objectMap["keyVaultId"] = sap.KeyVaultID
	}
	return json.Marshal(objectMap)
}

// SiteHealthSummary site health summary model.
type SiteHealthSummary struct {
	// ApplianceName - READ-ONLY; Appliance name.
	ApplianceName *string `json:"applianceName,omitempty"`
	// ErrorMessage - READ-ONLY; Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// SummaryMessage - READ-ONLY; Summary message.
	SummaryMessage *string `json:"summaryMessage,omitempty"`
	// ErrorID - READ-ONLY; Error Id.
	ErrorID *int64 `json:"errorId,omitempty"`
	// ErrorCode - READ-ONLY; Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// AffectedObjectsCount - Count of affected objects.
	AffectedObjectsCount *int64 `json:"affectedObjectsCount,omitempty"`
	// HitCount - Hit count of the error.
	HitCount *int64 `json:"hitCount,omitempty"`
	// Severity - READ-ONLY; Severity of error.
	Severity *string `json:"severity,omitempty"`
	// RemediationGuidance - READ-ONLY; Remediation guidance.
	RemediationGuidance *string `json:"remediationGuidance,omitempty"`
	// AffectedResourceType - READ-ONLY; Affected resource type.
	AffectedResourceType *string `json:"affectedResourceType,omitempty"`
	// AffectedResources - Affected resources.
	AffectedResources *[]string `json:"affectedResources,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteHealthSummary.
func (shs SiteHealthSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if shs.AffectedObjectsCount != nil {
		objectMap["affectedObjectsCount"] = shs.AffectedObjectsCount
	}
	if shs.HitCount != nil {
		objectMap["hitCount"] = shs.HitCount
	}
	if shs.AffectedResources != nil {
		objectMap["affectedResources"] = shs.AffectedResources
	}
	return json.Marshal(objectMap)
}

// SiteHealthSummaryCollection collection of SiteHealthSummary.
type SiteHealthSummaryCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of SiteHealthSummary.
	Value *[]SiteHealthSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// SiteHealthSummaryCollectionIterator provides access to a complete listing of SiteHealthSummary values.
type SiteHealthSummaryCollectionIterator struct {
	i    int
	page SiteHealthSummaryCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SiteHealthSummaryCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteHealthSummaryCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SiteHealthSummaryCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SiteHealthSummaryCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SiteHealthSummaryCollectionIterator) Response() SiteHealthSummaryCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SiteHealthSummaryCollectionIterator) Value() SiteHealthSummary {
	if !iter.page.NotDone() {
		return SiteHealthSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SiteHealthSummaryCollectionIterator type.
func NewSiteHealthSummaryCollectionIterator(page SiteHealthSummaryCollectionPage) SiteHealthSummaryCollectionIterator {
	return SiteHealthSummaryCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (shsc SiteHealthSummaryCollection) IsEmpty() bool {
	return shsc.Value == nil || len(*shsc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (shsc SiteHealthSummaryCollection) hasNextLink() bool {
	return shsc.NextLink != nil && len(*shsc.NextLink) != 0
}

// siteHealthSummaryCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (shsc SiteHealthSummaryCollection) siteHealthSummaryCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !shsc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(shsc.NextLink)))
}

// SiteHealthSummaryCollectionPage contains a page of SiteHealthSummary values.
type SiteHealthSummaryCollectionPage struct {
	fn   func(context.Context, SiteHealthSummaryCollection) (SiteHealthSummaryCollection, error)
	shsc SiteHealthSummaryCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SiteHealthSummaryCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteHealthSummaryCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.shsc)
		if err != nil {
			return err
		}
		page.shsc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SiteHealthSummaryCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SiteHealthSummaryCollectionPage) NotDone() bool {
	return !page.shsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SiteHealthSummaryCollectionPage) Response() SiteHealthSummaryCollection {
	return page.shsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SiteHealthSummaryCollectionPage) Values() []SiteHealthSummary {
	if page.shsc.IsEmpty() {
		return nil
	}
	return *page.shsc.Value
}

// Creates a new instance of the SiteHealthSummaryCollectionPage type.
func NewSiteHealthSummaryCollectionPage(cur SiteHealthSummaryCollection, getNextPage func(context.Context, SiteHealthSummaryCollection) (SiteHealthSummaryCollection, error)) SiteHealthSummaryCollectionPage {
	return SiteHealthSummaryCollectionPage{
		fn:   getNextPage,
		shsc: cur,
	}
}

// SiteProperties class for site properties.
type SiteProperties struct {
	// ServicePrincipalIdentityDetails - Service principal identity details used by agent for communication to the service.
	ServicePrincipalIdentityDetails *SiteSpnProperties `json:"servicePrincipalIdentityDetails,omitempty"`
	// AgentDetails - On-premises agent details.
	AgentDetails *SiteAgentProperties `json:"agentDetails,omitempty"`
	// ServiceEndpoint - READ-ONLY; Service endpoint.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty"`
	// DiscoverySolutionID - ARM ID of migration hub solution for SDS.
	DiscoverySolutionID *string `json:"discoverySolutionId,omitempty"`
	// ApplianceName - Appliance Name.
	ApplianceName *string `json:"applianceName,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteProperties.
func (sp SiteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.ServicePrincipalIdentityDetails != nil {
		objectMap["servicePrincipalIdentityDetails"] = sp.ServicePrincipalIdentityDetails
	}
	if sp.AgentDetails != nil {
		objectMap["agentDetails"] = sp.AgentDetails
	}
	if sp.DiscoverySolutionID != nil {
		objectMap["discoverySolutionId"] = sp.DiscoverySolutionID
	}
	if sp.ApplianceName != nil {
		objectMap["applianceName"] = sp.ApplianceName
	}
	return json.Marshal(objectMap)
}

// SiteSpnProperties class for site properties.
type SiteSpnProperties struct {
	// TenantID - Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	TenantID *string `json:"tenantId,omitempty"`
	// ApplicationID - Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	ApplicationID *string `json:"applicationId,omitempty"`
	// ObjectID - Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	ObjectID *string `json:"objectId,omitempty"`
	// Audience - Intended audience for the service principal.
	Audience *string `json:"audience,omitempty"`
	// AadAuthority - AAD Authority URL which was used to request the token for the service principal.
	AadAuthority *string `json:"aadAuthority,omitempty"`
	// RawCertData - Raw certificate data for building certificate expiry flows.
	RawCertData *string `json:"rawCertData,omitempty"`
}

// SQLServer sQLServer in the guest virtual machine.
type SQLServer struct {
	// Name - READ-ONLY; Name of the SQLServer.
	Name *string `json:"name,omitempty"`
	// Edition - READ-ONLY; Edition of the SQLServer.
	Edition *string `json:"edition,omitempty"`
	// ServicePack - READ-ONLY; ServicePack of the SQLServer.
	ServicePack *string `json:"servicePack,omitempty"`
	// Version - READ-ONLY; Version of the SQLServer.
	Version *string `json:"version,omitempty"`
	// Clustered - READ-ONLY; Clustered of the SQLServer.
	Clustered *string `json:"clustered,omitempty"`
	// ClusterName - READ-ONLY; ClusterName of the SQLServer.
	ClusterName *string `json:"clusterName,omitempty"`
}

// SystemCenter systemCenter in the guest virtual machine.
type SystemCenter struct {
	// ProductName - READ-ONLY; ProductName of the SystemCenter.
	ProductName *string `json:"productName,omitempty"`
	// Status - READ-ONLY; Status of the SystemCenter.
	Status *string `json:"status,omitempty"`
	// Version - READ-ONLY; Version of the SystemCenter.
	Version *string `json:"version,omitempty"`
}

// Timezone ...
type Timezone struct {
	FullName *string `json:"fullName,omitempty"`
}

// VCenter vCenter REST Resource.
type VCenter struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Name of the vCenter.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/VMWareSites/VCenters.
	Type *string `json:"type,omitempty"`
	// Properties - vCenter nested properties.
	Properties *VCenterProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VCenter.
func (vc VCenter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vc.Name != nil {
		objectMap["name"] = vc.Name
	}
	if vc.Properties != nil {
		objectMap["properties"] = vc.Properties
	}
	return json.Marshal(objectMap)
}

// VCenterCollection collection of vCenter.
type VCenterCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of vCenter.
	Value *[]VCenter `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// VCenterCollectionIterator provides access to a complete listing of VCenter values.
type VCenterCollectionIterator struct {
	i    int
	page VCenterCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VCenterCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VCenterCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VCenterCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VCenterCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VCenterCollectionIterator) Response() VCenterCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VCenterCollectionIterator) Value() VCenter {
	if !iter.page.NotDone() {
		return VCenter{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VCenterCollectionIterator type.
func NewVCenterCollectionIterator(page VCenterCollectionPage) VCenterCollectionIterator {
	return VCenterCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vcc VCenterCollection) IsEmpty() bool {
	return vcc.Value == nil || len(*vcc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vcc VCenterCollection) hasNextLink() bool {
	return vcc.NextLink != nil && len(*vcc.NextLink) != 0
}

// vCenterCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vcc VCenterCollection) vCenterCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !vcc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vcc.NextLink)))
}

// VCenterCollectionPage contains a page of VCenter values.
type VCenterCollectionPage struct {
	fn  func(context.Context, VCenterCollection) (VCenterCollection, error)
	vcc VCenterCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VCenterCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VCenterCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vcc)
		if err != nil {
			return err
		}
		page.vcc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VCenterCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VCenterCollectionPage) NotDone() bool {
	return !page.vcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VCenterCollectionPage) Response() VCenterCollection {
	return page.vcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VCenterCollectionPage) Values() []VCenter {
	if page.vcc.IsEmpty() {
		return nil
	}
	return *page.vcc.Value
}

// Creates a new instance of the VCenterCollectionPage type.
func NewVCenterCollectionPage(cur VCenterCollection, getNextPage func(context.Context, VCenterCollection) (VCenterCollection, error)) VCenterCollectionPage {
	return VCenterCollectionPage{
		fn:  getNextPage,
		vcc: cur,
	}
}

// VCenterProperties class for vCenter properties.
type VCenterProperties struct {
	// CreatedTimestamp - READ-ONLY; Timestamp marking vCenter creation.
	CreatedTimestamp *string `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Timestamp marking last updated on the vCenter.
	UpdatedTimestamp *string `json:"updatedTimestamp,omitempty"`
	// Fqdn - FQDN/IPAddress of the vCenter.
	Fqdn *string `json:"fqdn,omitempty"`
	// Port - Port of the vCenter.
	Port *string `json:"port,omitempty"`
	// RunAsAccountID - Run as account ID of the vCenter.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// Version - READ-ONLY; Version of the vCenter.
	Version *string `json:"version,omitempty"`
	// PerfStatisticsLevel - READ-ONLY; Performance statistics enabled on the vCenter.
	PerfStatisticsLevel *string `json:"perfStatisticsLevel,omitempty"`
	// InstanceUUID - READ-ONLY; Instance UUID of the vCenter.
	InstanceUUID *string `json:"instanceUuid,omitempty"`
	// Errors - READ-ONLY; Error details.
	Errors *[]HealthErrorDetails `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for VCenterProperties.
func (vcp VCenterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcp.Fqdn != nil {
		objectMap["fqdn"] = vcp.Fqdn
	}
	if vcp.Port != nil {
		objectMap["port"] = vcp.Port
	}
	if vcp.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = vcp.RunAsAccountID
	}
	return json.Marshal(objectMap)
}

// VirtualMachineConfiguration ...
type VirtualMachineConfiguration struct {
	// VirtualMachineType - Possible values include: 'VirtualMachineTypeUnknown', 'VirtualMachineTypeHyperv', 'VirtualMachineTypeLdom', 'VirtualMachineTypeLpar', 'VirtualMachineTypeVmware', 'VirtualMachineTypeVirtualPc', 'VirtualMachineTypeXen'
	VirtualMachineType  VirtualMachineType `json:"virtualMachineType,omitempty"`
	NativeMachineID     *string            `json:"nativeMachineId,omitempty"`
	VirtualMachineName  *string            `json:"virtualMachineName,omitempty"`
	NativeHostMachineID *string            `json:"nativeHostMachineId,omitempty"`
}

// VMwareDisk second level object returned as part of Machine REST resource.
type VMwareDisk struct {
	// UUID - READ-ONLY; Disk UUID.
	UUID *string `json:"uuid,omitempty"`
	// Label - READ-ONLY; Label of the disk.
	Label *string `json:"label,omitempty"`
	// DiskProvisioningPolicy - READ-ONLY; The provisioning policy of the disk. It is Thin or Thick or Unknown for the VMWare.
	DiskProvisioningPolicy *string `json:"diskProvisioningPolicy,omitempty"`
	// DiskScrubbingPolicy - READ-ONLY; The scrubbing policy of disks which can be eagerly zeroed or lazily zeroed.
	DiskScrubbingPolicy *string `json:"diskScrubbingPolicy,omitempty"`
	// DiskMode - READ-ONLY; Disk mode property used for identifying independent disks. Possible values include: 'Persistent', 'IndependentPersistent', 'IndependentNonpersistent', 'Nonpersistent', 'Undoable', 'Append'
	DiskMode VirtualDiskMode `json:"diskMode,omitempty"`
	// MaxSizeInBytes - READ-ONLY; Bytes allocated for the disk.
	MaxSizeInBytes *int64 `json:"maxSizeInBytes,omitempty"`
	// Name - READ-ONLY; Name of the disk.
	Name *string `json:"name,omitempty"`
	// DiskType - READ-ONLY; Type of the disk.
	DiskType *string `json:"diskType,omitempty"`
	// Lun - READ-ONLY; LUN of the disk.
	Lun *int32 `json:"lun,omitempty"`
	// Path - READ-ONLY; Path of the disk.
	Path *string `json:"path,omitempty"`
}

// VMwareJob job REST Resource.
type VMwareJob struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the job.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/VMWareSites/Jobs.
	Type *string `json:"type,omitempty"`
	// Properties - READ-ONLY; Nested properties of job.
	Properties *JobProperties `json:"properties,omitempty"`
}

// VMwareJobCollection collection of VMware jobs.
type VMwareJobCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of jobs.
	Value *[]VMwareJob `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// VMwareJobCollectionIterator provides access to a complete listing of VMwareJob values.
type VMwareJobCollectionIterator struct {
	i    int
	page VMwareJobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VMwareJobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMwareJobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VMwareJobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VMwareJobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VMwareJobCollectionIterator) Response() VMwareJobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VMwareJobCollectionIterator) Value() VMwareJob {
	if !iter.page.NotDone() {
		return VMwareJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VMwareJobCollectionIterator type.
func NewVMwareJobCollectionIterator(page VMwareJobCollectionPage) VMwareJobCollectionIterator {
	return VMwareJobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmjc VMwareJobCollection) IsEmpty() bool {
	return vmjc.Value == nil || len(*vmjc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmjc VMwareJobCollection) hasNextLink() bool {
	return vmjc.NextLink != nil && len(*vmjc.NextLink) != 0
}

// vMwareJobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmjc VMwareJobCollection) vMwareJobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !vmjc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmjc.NextLink)))
}

// VMwareJobCollectionPage contains a page of VMwareJob values.
type VMwareJobCollectionPage struct {
	fn   func(context.Context, VMwareJobCollection) (VMwareJobCollection, error)
	vmjc VMwareJobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VMwareJobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMwareJobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmjc)
		if err != nil {
			return err
		}
		page.vmjc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VMwareJobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VMwareJobCollectionPage) NotDone() bool {
	return !page.vmjc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VMwareJobCollectionPage) Response() VMwareJobCollection {
	return page.vmjc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VMwareJobCollectionPage) Values() []VMwareJob {
	if page.vmjc.IsEmpty() {
		return nil
	}
	return *page.vmjc.Value
}

// Creates a new instance of the VMwareJobCollectionPage type.
func NewVMwareJobCollectionPage(cur VMwareJobCollection, getNextPage func(context.Context, VMwareJobCollection) (VMwareJobCollection, error)) VMwareJobCollectionPage {
	return VMwareJobCollectionPage{
		fn:   getNextPage,
		vmjc: cur,
	}
}

// VMwareMachine machine REST Resource.
type VMwareMachine struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Sites.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/VMWareSites/Machines.
	Type *string `json:"type,omitempty"`
	// Properties - READ-ONLY; Nested properties.
	Properties *VMwareMachineProperties `json:"properties,omitempty"`
}

// VMwareMachineCollection collection of VMware machines.
type VMwareMachineCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of machines.
	Value *[]VMwareMachine `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// VMwareMachineCollectionIterator provides access to a complete listing of VMwareMachine values.
type VMwareMachineCollectionIterator struct {
	i    int
	page VMwareMachineCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VMwareMachineCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMwareMachineCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VMwareMachineCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VMwareMachineCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VMwareMachineCollectionIterator) Response() VMwareMachineCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VMwareMachineCollectionIterator) Value() VMwareMachine {
	if !iter.page.NotDone() {
		return VMwareMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VMwareMachineCollectionIterator type.
func NewVMwareMachineCollectionIterator(page VMwareMachineCollectionPage) VMwareMachineCollectionIterator {
	return VMwareMachineCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmmc VMwareMachineCollection) IsEmpty() bool {
	return vmmc.Value == nil || len(*vmmc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmmc VMwareMachineCollection) hasNextLink() bool {
	return vmmc.NextLink != nil && len(*vmmc.NextLink) != 0
}

// vMwareMachineCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmmc VMwareMachineCollection) vMwareMachineCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !vmmc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmmc.NextLink)))
}

// VMwareMachineCollectionPage contains a page of VMwareMachine values.
type VMwareMachineCollectionPage struct {
	fn   func(context.Context, VMwareMachineCollection) (VMwareMachineCollection, error)
	vmmc VMwareMachineCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VMwareMachineCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMwareMachineCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmmc)
		if err != nil {
			return err
		}
		page.vmmc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VMwareMachineCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VMwareMachineCollectionPage) NotDone() bool {
	return !page.vmmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VMwareMachineCollectionPage) Response() VMwareMachineCollection {
	return page.vmmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VMwareMachineCollectionPage) Values() []VMwareMachine {
	if page.vmmc.IsEmpty() {
		return nil
	}
	return *page.vmmc.Value
}

// Creates a new instance of the VMwareMachineCollectionPage type.
func NewVMwareMachineCollectionPage(cur VMwareMachineCollection, getNextPage func(context.Context, VMwareMachineCollection) (VMwareMachineCollection, error)) VMwareMachineCollectionPage {
	return VMwareMachineCollectionPage{
		fn:   getNextPage,
		vmmc: cur,
	}
}

// VMwareMachineProperties class for machine properties.
type VMwareMachineProperties struct {
	// DataCenterScope - READ-ONLY; Scope of the data center.
	DataCenterScope *string `json:"dataCenterScope,omitempty"`
	// Firmware - READ-ONLY; Firmware of the machine.
	Firmware *string `json:"firmware,omitempty"`
	// Description - READ-ONLY; User description of the machine.
	Description *string `json:"description,omitempty"`
	// VCenterFQDN - READ-ONLY; VCenter FQDN/IPAddress.
	VCenterFQDN *string `json:"vCenterFQDN,omitempty"`
	// VCenterID - READ-ONLY; VCenter ARM ID.
	VCenterID *string `json:"vCenterId,omitempty"`
	// VMwareToolsStatus - READ-ONLY; VMware tools status.
	VMwareToolsStatus *string `json:"vMwareToolsStatus,omitempty"`
	// ChangeTrackingSupported - READ-ONLY; Value indicating whether change tracking is supported.
	ChangeTrackingSupported *bool `json:"changeTrackingSupported,omitempty"`
	// ChangeTrackingEnabled - READ-ONLY; Value indicating whether change tracking is enabled.
	ChangeTrackingEnabled *bool `json:"changeTrackingEnabled,omitempty"`
	// MaxSnapshots - READ-ONLY; Maximum number of snapshots for the VM. Default value is -1.
	MaxSnapshots *int32 `json:"maxSnapshots,omitempty"`
	// Disks - READ-ONLY; Disks attached to the machine.
	Disks *[]VMwareDisk `json:"disks,omitempty"`
	// AppsAndRoles - READ-ONLY; Apps And Roles of the VM.
	AppsAndRoles *AppsAndRoles `json:"appsAndRoles,omitempty"`
	// HostInMaintenanceMode - READ-ONLY; Indicates whether the host is in maintenance mode.
	HostInMaintenanceMode *bool `json:"hostInMaintenanceMode,omitempty"`
	// HostName - READ-ONLY; The host name.
	HostName *string `json:"hostName,omitempty"`
	// HostPowerState - READ-ONLY; The host power state.
	HostPowerState *string `json:"hostPowerState,omitempty"`
	// HostVersion - READ-ONLY; The host version.
	HostVersion *string `json:"hostVersion,omitempty"`
	// NetworkAdapters - READ-ONLY; Network adapters attached to the machine.
	NetworkAdapters *[]VMwareNetworkAdapter `json:"networkAdapters,omitempty"`
	// DependencyMapping - READ-ONLY; If dependency mapping feature is enabled or not for the VM.
	DependencyMapping *string `json:"dependencyMapping,omitempty"`
	// DependencyMappingStartTime - READ-ONLY; When dependency mapping collection is last started.
	DependencyMappingStartTime *date.Time `json:"dependencyMappingStartTime,omitempty"`
	// DisplayName - READ-ONLY; Display name of the machine.
	DisplayName *string `json:"displayName,omitempty"`
	// NumberOfProcessorCore - READ-ONLY; Number of Processor Cores allocated for the machine.
	NumberOfProcessorCore *int32 `json:"numberOfProcessorCore,omitempty"`
	// AllocatedMemoryInMB - READ-ONLY; Allocated Memory in MB.
	AllocatedMemoryInMB *float64 `json:"allocatedMemoryInMB,omitempty"`
	// VMConfigurationFileLocation - READ-ONLY; Root location of the VM configuration file.
	VMConfigurationFileLocation *string `json:"vmConfigurationFileLocation,omitempty"`
	// OperatingSystemDetails - READ-ONLY; Operating System Details installed on the machine.
	OperatingSystemDetails *OperatingSystem `json:"operatingSystemDetails,omitempty"`
	// GuestOSDetails - READ-ONLY; Operating System Details extracted from the guest bu executing script inside the guest VM.
	GuestOSDetails *GuestOSDetails `json:"guestOSDetails,omitempty"`
	// NumberOfApplications - READ-ONLY; Number of applications installed in the guest VM.
	NumberOfApplications *int32 `json:"numberOfApplications,omitempty"`
	// GuestDetailsDiscoveryTimestamp - READ-ONLY; The last time at which the Guest Details was discovered or the error while discovering guest details based discovery of the machine.
	GuestDetailsDiscoveryTimestamp *date.Time `json:"guestDetailsDiscoveryTimestamp,omitempty"`
	// IsGuestDetailsDiscoveryInProgress - READ-ONLY; Whether Refresh Fabric Layout Guest Details has been completed once. Portal will show discovery in progress, if this value is true.
	IsGuestDetailsDiscoveryInProgress *bool `json:"isGuestDetailsDiscoveryInProgress,omitempty"`
	// CreatedTimestamp - READ-ONLY; Timestamp marking machine creation.
	CreatedTimestamp *string `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Timestamp marking last updated on the machine.
	UpdatedTimestamp *string `json:"updatedTimestamp,omitempty"`
	// InstanceUUID - READ-ONLY; On-premise Instance UUID of the machine.
	InstanceUUID *string `json:"instanceUuid,omitempty"`
	// PowerStatus - READ-ONLY; Machine power status.
	PowerStatus *string `json:"powerStatus,omitempty"`
	// BiosSerialNumber - READ-ONLY; Machine BIOS serial number.
	BiosSerialNumber *string `json:"biosSerialNumber,omitempty"`
	// BiosGUID - READ-ONLY; BIOS GUID.
	BiosGUID *string `json:"biosGuid,omitempty"`
	// VMFqdn - READ-ONLY; Machine FQDN.
	VMFqdn *string `json:"vmFqdn,omitempty"`
	// IsDeleted - READ-ONLY; Value indicating whether VM is deleted.
	IsDeleted *bool `json:"isDeleted,omitempty"`
	// Errors - READ-ONLY; Errors for machine.
	Errors *[]HealthErrorDetails `json:"errors,omitempty"`
}

// VMwareNetworkAdapter second level object represented in responses as part of Machine REST resource.
type VMwareNetworkAdapter struct {
	// Label - READ-ONLY; Label of the NIC.
	Label *string `json:"label,omitempty"`
	// NicID - READ-ONLY; NIC Id.
	NicID *string `json:"nicId,omitempty"`
	// MacAddress - READ-ONLY; Mac address of the NIC.
	MacAddress *string `json:"macAddress,omitempty"`
	// IPAddressList - READ-ONLY; IP addresses for the machine.
	IPAddressList *[]string `json:"ipAddressList,omitempty"`
	// NetworkName - READ-ONLY; Network Name.
	NetworkName *string `json:"networkName,omitempty"`
	// IPAddressType - READ-ONLY; Type of the IP address.
	IPAddressType *string `json:"ipAddressType,omitempty"`
}

// VMwareRunAsAccount run as account REST Resource.
type VMwareRunAsAccount struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Run as account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/VMWareSites/RunAsAccounts.
	Type *string `json:"type,omitempty"`
	// Properties - READ-ONLY; Nested properties of Run as account.
	Properties *RunAsAccountProperties `json:"properties,omitempty"`
}

// VMwareRunAsAccountCollection collection of VMware run as accounts.
type VMwareRunAsAccountCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of run as accounts.
	Value *[]VMwareRunAsAccount `json:"value,omitempty"`
	// NextLink - READ-ONLY; Value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// VMwareRunAsAccountCollectionIterator provides access to a complete listing of VMwareRunAsAccount values.
type VMwareRunAsAccountCollectionIterator struct {
	i    int
	page VMwareRunAsAccountCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VMwareRunAsAccountCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMwareRunAsAccountCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VMwareRunAsAccountCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VMwareRunAsAccountCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VMwareRunAsAccountCollectionIterator) Response() VMwareRunAsAccountCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VMwareRunAsAccountCollectionIterator) Value() VMwareRunAsAccount {
	if !iter.page.NotDone() {
		return VMwareRunAsAccount{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VMwareRunAsAccountCollectionIterator type.
func NewVMwareRunAsAccountCollectionIterator(page VMwareRunAsAccountCollectionPage) VMwareRunAsAccountCollectionIterator {
	return VMwareRunAsAccountCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmraac VMwareRunAsAccountCollection) IsEmpty() bool {
	return vmraac.Value == nil || len(*vmraac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmraac VMwareRunAsAccountCollection) hasNextLink() bool {
	return vmraac.NextLink != nil && len(*vmraac.NextLink) != 0
}

// vMwareRunAsAccountCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmraac VMwareRunAsAccountCollection) vMwareRunAsAccountCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !vmraac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmraac.NextLink)))
}

// VMwareRunAsAccountCollectionPage contains a page of VMwareRunAsAccount values.
type VMwareRunAsAccountCollectionPage struct {
	fn     func(context.Context, VMwareRunAsAccountCollection) (VMwareRunAsAccountCollection, error)
	vmraac VMwareRunAsAccountCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VMwareRunAsAccountCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMwareRunAsAccountCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmraac)
		if err != nil {
			return err
		}
		page.vmraac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VMwareRunAsAccountCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VMwareRunAsAccountCollectionPage) NotDone() bool {
	return !page.vmraac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VMwareRunAsAccountCollectionPage) Response() VMwareRunAsAccountCollection {
	return page.vmraac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VMwareRunAsAccountCollectionPage) Values() []VMwareRunAsAccount {
	if page.vmraac.IsEmpty() {
		return nil
	}
	return *page.vmraac.Value
}

// Creates a new instance of the VMwareRunAsAccountCollectionPage type.
func NewVMwareRunAsAccountCollectionPage(cur VMwareRunAsAccountCollection, getNextPage func(context.Context, VMwareRunAsAccountCollection) (VMwareRunAsAccountCollection, error)) VMwareRunAsAccountCollectionPage {
	return VMwareRunAsAccountCollectionPage{
		fn:     getNextPage,
		vmraac: cur,
	}
}

// VMwareSite site REST Resource.
type VMwareSite struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Name of the VMware site.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. Type = Microsoft.OffAzure/VMWareSites.
	Type *string            `json:"type,omitempty"`
	Tags map[string]*string `json:"tags"`
	// ETag - eTag for concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Location - Azure location in which Sites is created.
	Location *string `json:"location,omitempty"`
	// Properties - Nested properties of VMWare site.
	Properties *SiteProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareSite.
func (vms VMwareSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vms.Name != nil {
		objectMap["name"] = vms.Name
	}
	if vms.Tags != nil {
		objectMap["tags"] = vms.Tags
	}
	if vms.ETag != nil {
		objectMap["eTag"] = vms.ETag
	}
	if vms.Location != nil {
		objectMap["location"] = vms.Location
	}
	if vms.Properties != nil {
		objectMap["properties"] = vms.Properties
	}
	return json.Marshal(objectMap)
}

// VMwareSiteUsage vMware site usage.
type VMwareSiteUsage struct {
	autorest.Response `json:"-"`
	// MachineCount - Number of machines discovered in the site.
	MachineCount *int32 `json:"machineCount,omitempty"`
	// RunAsAccountCount - Number of run as accounts in the site.
	RunAsAccountCount *int32 `json:"runAsAccountCount,omitempty"`
	// VCenterCount - Number of vCenters part of the site.
	VCenterCount *int32 `json:"vCenterCount,omitempty"`
}

// WebApplication webApplication in the guest virtual machine.
type WebApplication struct {
	// Name - READ-ONLY; Name of the WebApplication.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Status of the WebApplication.
	Status *string `json:"status,omitempty"`
	// Platform - READ-ONLY; Platform of the WebApplication.
	Platform *string `json:"platform,omitempty"`
	// GroupName - READ-ONLY; GroupName of the WebApplication.
	GroupName *string `json:"groupName,omitempty"`
	// WebServer - READ-ONLY; WebServer of the WebApplication.
	WebServer *string `json:"webServer,omitempty"`
	// ApplicationPool - READ-ONLY; ApplicationPool of the WebApplication.
	ApplicationPool *string `json:"applicationPool,omitempty"`
}
