package textanalyticsapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v2.0/textanalytics"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	DetectLanguage(ctx context.Context, input textanalytics.BatchInput) (result textanalytics.LanguageBatchResult, err error)
	Entities(ctx context.Context, input textanalytics.MultiLanguageBatchInput) (result textanalytics.EntitiesBatchResult, err error)
	KeyPhrases(ctx context.Context, input textanalytics.MultiLanguageBatchInput) (result textanalytics.KeyPhraseBatchResult, err error)
	Sentiment(ctx context.Context, input textanalytics.MultiLanguageBatchInput) (result textanalytics.SentimentBatchResult, err error)
}

var _ BaseClientAPI = (*textanalytics.BaseClient)(nil)
