/*
 * Application Insights JavaScript SDK - Channel, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import { HashCodeScoreGenerator } from "./HashCodeScoreGenerator";
import { ContextTagKeys } from "@microsoft/applicationinsights-common";
var SamplingScoreGenerator = /** @class */ (function () {
    function SamplingScoreGenerator() {
        var _self = this;
        var hashCodeGenerator = new HashCodeScoreGenerator();
        var keys = new ContextTagKeys();
        _self.getSamplingScore = function (item) {
            var score = 0;
            if (item.tags && item.tags[keys.userId]) { // search in tags first, then ext
                score = hashCodeGenerator.getHashCodeScore(item.tags[keys.userId]);
            }
            else if (item.ext && item.ext.user && item.ext.user.id) {
                score = hashCodeGenerator.getHashCodeScore(item.ext.user.id);
            }
            else if (item.tags && item.tags[keys.operationId]) { // search in tags first, then ext
                score = hashCodeGenerator.getHashCodeScore(item.tags[keys.operationId]);
            }
            else if (item.ext && item.ext.telemetryTrace && item.ext.telemetryTrace.traceID) {
                score = hashCodeGenerator.getHashCodeScore(item.ext.telemetryTrace.traceID);
            }
            else {
                // tslint:disable-next-line:insecure-random
                score = (Math.random() * 100);
            }
            return score;
        };
    }
    return SamplingScoreGenerator;
}());
export { SamplingScoreGenerator };
