/*
 * Application Insights JavaScript SDK - Common, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import { dataSanitizeString } from "./DataSanitizer";
import { toISOString } from "@microsoft/applicationinsights-core-js";
import { strNotSpecified } from "../../Constants";
var Envelope = /** @class */ (function () {
    /**
     * Constructs a new instance of telemetry data.
     */
    function Envelope(logger, data, name) {
        var _this = this;
        var _self = this;
        _self.ver = 1;
        _self.sampleRate = 100.0;
        _self.tags = {};
        _self.name = dataSanitizeString(logger, name) || strNotSpecified;
        _self.data = data;
        _self.time = toISOString(new Date());
        _self.aiDataContract = {
            time: 1 /* FieldType.Required */,
            iKey: 1 /* FieldType.Required */,
            name: 1 /* FieldType.Required */,
            sampleRate: function () {
                return (_this.sampleRate === 100) ? 4 /* FieldType.Hidden */ : 1 /* FieldType.Required */;
            },
            tags: 1 /* FieldType.Required */,
            data: 1 /* FieldType.Required */
        };
    }
    return Envelope;
}());
export { Envelope };
