## API Report File for "@microsoft/applicationinsights-common"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { createTraceParent } from '@microsoft/applicationinsights-core-js';
import { _eInternalMessageId } from '@microsoft/applicationinsights-core-js';
import { EnumValue } from '@microsoft/applicationinsights-core-js';
import { findW3cTraceParent } from '@microsoft/applicationinsights-core-js';
import { formatTraceParent } from '@microsoft/applicationinsights-core-js';
import { IChannelControls } from '@microsoft/applicationinsights-core-js';
import { IConfiguration } from '@microsoft/applicationinsights-core-js';
import { ICookieMgr } from '@microsoft/applicationinsights-core-js';
import { ICustomProperties } from '@microsoft/applicationinsights-core-js';
import { IDiagnosticLogger } from '@microsoft/applicationinsights-core-js';
import { IDistributedTraceContext } from '@microsoft/applicationinsights-core-js';
import { IPlugin } from '@microsoft/applicationinsights-core-js';
import { isBeaconsSupported as isBeaconApiSupported } from '@microsoft/applicationinsights-core-js';
import { isSampledFlag } from '@microsoft/applicationinsights-core-js';
import { isValidSpanId } from '@microsoft/applicationinsights-core-js';
import { isValidTraceId } from '@microsoft/applicationinsights-core-js';
import { isValidTraceParent } from '@microsoft/applicationinsights-core-js';
import { ITelemetryItem } from '@microsoft/applicationinsights-core-js';
import { ITraceParent } from '@microsoft/applicationinsights-core-js';
import { parseTraceParent } from '@microsoft/applicationinsights-core-js';

// @public
export interface AIBase {
    baseType: string;
}

// @public
export interface AIData<TDomain> extends AIBase {
    baseData: TDomain;
    baseType: string;
}

// @public (undocumented)
export const AnalyticsPluginIdentifier = "ApplicationInsightsAnalytics";

// @public (undocumented)
export const BreezeChannelIdentifier = "AppInsightsChannelPlugin";

// @public (undocumented)
export class ConfigurationManager {
    // (undocumented)
    static getConfig(config: IConfiguration & IConfig, field: string, identifier?: string, defaultValue?: number | string | boolean): number | string | boolean;
}

// @public (undocumented)
export const ConnectionStringParser: {
    parse: typeof parseConnectionString;
};

// Warning: (ae-forgotten-export) The symbol "ContextTagKeys_base" needs to be exported by the entry point applicationinsights-common.d.ts
//
// @public (undocumented)
export class ContextTagKeys extends ContextTagKeys_base {
    constructor();
}

// @public (undocumented)
export const CorrelationIdHelper: ICorrelationIdHelper;

// @public
export function createDistributedTraceContextFromTrace(telemetryTrace?: ITelemetryTrace, parentCtx?: IDistributedTraceContext): IDistributedTraceContext;

// @public (undocumented)
export function createDomEvent(eventName: string): Event;

// @public
export function createTelemetryItem<T>(item: T, baseType: string, envelopeName: string, logger: IDiagnosticLogger, customProperties?: {
    [key: string]: any;
}, systemProperties?: {
    [key: string]: any;
}): ITelemetryItem;

export { createTraceParent }

// @public (undocumented)
export let CtxTagKeys: ContextTagKeys;

// @public (undocumented)
export class Data<TDomain> implements AIData<TDomain>, ISerializable {
    constructor(baseType: string, data: TDomain);
    aiDataContract: {
        baseType: FieldType;
        baseData: FieldType;
    };
    baseData: TDomain;
    baseType: string;
}

// @public (undocumented)
export function dataSanitizeException(logger: IDiagnosticLogger, exception: any): any;

// @public (undocumented)
export function dataSanitizeId(logger: IDiagnosticLogger, id: string): string;

// @public (undocumented)
export function dataSanitizeInput(logger: IDiagnosticLogger, input: any, maxLength: number, _msgId: _eInternalMessageId): any;

// @public (undocumented)
export function dataSanitizeKey(logger: IDiagnosticLogger, name: any): any;

// @public (undocumented)
export function dataSanitizeKeyAndAddUniqueness(logger: IDiagnosticLogger, key: any, map: any): any;

// @public (undocumented)
export function dataSanitizeMeasurements(logger: IDiagnosticLogger, measurements: any): any;

// @public (undocumented)
export function dataSanitizeMessage(logger: IDiagnosticLogger, message: any): any;

// @public (undocumented)
export function dataSanitizeProperties(logger: IDiagnosticLogger, properties: any): any;

// @public
export const DataSanitizer: IDataSanitizer;

// @public (undocumented)
export const enum DataSanitizerValues {
    MAX_EXCEPTION_LENGTH = 32768,
    MAX_ID_LENGTH = 128,
    MAX_MESSAGE_LENGTH = 32768,
    MAX_NAME_LENGTH = 150,
    MAX_PROPERTY_LENGTH = 8192,
    MAX_STRING_LENGTH = 1024,
    MAX_URL_LENGTH = 2048
}

// @public (undocumented)
export function dataSanitizeString(logger: IDiagnosticLogger, value: any, maxLength?: number): any;

// @public (undocumented)
export function dataSanitizeUrl(logger: IDiagnosticLogger, url: any): any;

// @public
export const DateTimeUtils: IDateTimeUtils;

// @public (undocumented)
export function dateTimeUtilsDuration(start: number, end: number): number;

// @public (undocumented)
export function dateTimeUtilsNow(): number;

// @public (undocumented)
export const DEFAULT_BREEZE_ENDPOINT = "https://dc.services.visualstudio.com";

// @public
export const DisabledPropertyName: string;

// @public (undocumented)
export const DistributedTracingModes: EnumValue<typeof eDistributedTracingModes>;

// @public (undocumented)
export type DistributedTracingModes = number | eDistributedTracingModes;

// @public (undocumented)
export function dsPadNumber(num: number): string;

// @public (undocumented)
export const enum eDistributedTracingModes {
    AI = 0,
    AI_AND_W3C = 1,
    W3C = 2
}

// @public (undocumented)
export class Envelope implements IEnvelope {
    constructor(logger: IDiagnosticLogger, data: AIBase, name: string);
    aiDataContract: any;
    data: AIBase;
    iKey: string;
    name: string;
    sampleRate: number;
    seq: string;
    tags: any;
    time: string;
    ver: number;
}

// @public (undocumented)
export const enum eRequestHeaders {
    // (undocumented)
    requestContextAppIdFormat = 2,
    // (undocumented)
    requestContextHeader = 0,
    // (undocumented)
    requestContextHeaderLowerCase = 8,
    // (undocumented)
    requestContextTargetKey = 1,
    // (undocumented)
    requestIdHeader = 3,
    // (undocumented)
    sdkContextHeader = 6,
    // (undocumented)
    sdkContextHeaderAppIdRequest = 7,
    // (undocumented)
    traceParentHeader = 4,
    // (undocumented)
    traceStateHeader = 5
}

// @public
export const enum eSeverityLevel {
    // (undocumented)
    Critical = 4,
    // (undocumented)
    Error = 3,
    // (undocumented)
    Information = 1,
    // (undocumented)
    Verbose = 0,
    // (undocumented)
    Warning = 2
}

// Warning: (ae-forgotten-export) The symbol "IEventData" needs to be exported by the entry point applicationinsights-common.d.ts
//
// @public (undocumented)
class Event_2 implements IEventData, ISerializable {
    constructor(logger: IDiagnosticLogger, name: string, properties?: any, measurements?: any);
    // (undocumented)
    aiDataContract: {
        ver: FieldType;
        name: FieldType;
        properties: FieldType;
        measurements: FieldType;
    };
    // (undocumented)
    static dataType: string;
    // (undocumented)
    static envelopeType: string;
    measurements: any;
    name: string;
    properties: any;
    ver: number;
}
export { Event_2 as Event }

// Warning: (ae-forgotten-export) The symbol "IExceptionData" needs to be exported by the entry point applicationinsights-common.d.ts
//
// @public (undocumented)
export class Exception implements IExceptionData, ISerializable {
    constructor(logger: IDiagnosticLogger, exception: Error | IExceptionInternal | IAutoExceptionTelemetry, properties?: {
        [key: string]: any;
    }, measurements?: {
        [key: string]: number;
    }, severityLevel?: SeverityLevel, id?: string);
    // (undocumented)
    aiDataContract: {
        ver: FieldType;
        exceptions: FieldType;
        severityLevel: FieldType;
        properties: FieldType;
        measurements: FieldType;
    };
    // (undocumented)
    static CreateAutoException(message: string | Event, url: string, lineNumber: number, columnNumber: number, error: any, evt?: Event | string, stack?: string, errorSrc?: string): IAutoExceptionTelemetry;
    // (undocumented)
    static CreateFromInterface(logger: IDiagnosticLogger, exception: IExceptionInternal, properties?: any, measurements?: {
        [key: string]: number;
    }): Exception;
    static CreateSimpleException(message: string, typeName: string, assembly: string, fileName: string, details: string, line: number): Exception;
    // (undocumented)
    static dataType: string;
    // (undocumented)
    static envelopeType: string;
    // Warning: (ae-forgotten-export) The symbol "IExceptionDetails" needs to be exported by the entry point applicationinsights-common.d.ts
    exceptions: IExceptionDetails[];
    // Warning: (ae-forgotten-export) The symbol "_formatErrorCode" needs to be exported by the entry point applicationinsights-common.d.ts
    //
    // (undocumented)
    static formatError: typeof _formatErrorCode;
    // (undocumented)
    id?: string;
    // (undocumented)
    isManual?: boolean;
    measurements: any;
    // (undocumented)
    problemGroup?: string;
    properties: any;
    severityLevel: SeverityLevel;
    // (undocumented)
    toInterface(): IExceptionInternal;
    ver: number;
}

// @public (undocumented)
export const Extensions: {
    UserExt: string;
    DeviceExt: string;
    TraceExt: string;
    WebExt: string;
    AppExt: string;
    OSExt: string;
    SessionExt: string;
    SDKExt: string;
};

// @public
export const enum FieldType {
    // (undocumented)
    Array = 2,
    // (undocumented)
    Default = 0,
    // (undocumented)
    Hidden = 4,
    // (undocumented)
    Required = 1
}

export { findW3cTraceParent }

export { formatTraceParent }

// @public (undocumented)
export function getExtensionByName(extensions: IPlugin[], identifier: string): IPlugin | null;

// @public (undocumented)
export const HttpMethod = "http.method";

// @public (undocumented)
export interface IAppInsights {
    // (undocumented)
    addTelemetryInitializer(telemetryInitializer: (item: ITelemetryItem) => boolean | void): void;
    getCookieMgr(): ICookieMgr;
    // (undocumented)
    _onerror(exception: IAutoExceptionTelemetry): void;
    // (undocumented)
    startTrackEvent(name: string): void;
    // (undocumented)
    startTrackPage(name?: string): void;
    // (undocumented)
    stopTrackEvent(name: string, properties?: Object, measurements?: Object): void;
    // (undocumented)
    stopTrackPage(name?: string, url?: string, customProperties?: Object): void;
    // (undocumented)
    trackEvent(event: IEventTelemetry, customProperties?: {
        [key: string]: any;
    }): void;
    // (undocumented)
    trackException(exception: IExceptionTelemetry, customProperties?: {
        [key: string]: any;
    }): void;
    // (undocumented)
    trackMetric(metric: IMetricTelemetry, customProperties?: {
        [key: string]: any;
    }): void;
    // (undocumented)
    trackPageView(pageView: IPageViewTelemetry, customProperties?: {
        [key: string]: any;
    }): void;
    // (undocumented)
    trackPageViewPerformance(pageViewPerformance: IPageViewPerformanceTelemetry, customProperties?: {
        [key: string]: any;
    }): void;
    // (undocumented)
    trackTrace(trace: ITraceTelemetry, customProperties?: {
        [key: string]: any;
    }): void;
}

// @public (undocumented)
export interface IApplication {
    build: string;
    ver: string;
}

// @public
export interface IAutoExceptionTelemetry {
    columnNumber: number;
    error: any;
    errorSrc?: string;
    evt?: Event | string;
    lineNumber: number;
    message: string;
    // Warning: (ae-forgotten-export) The symbol "IStackDetails" needs to be exported by the entry point applicationinsights-common.d.ts
    stackDetails?: IStackDetails;
    typeName?: string;
    url: string;
}

// @public (undocumented)
export interface IChannelControlsAI extends IChannelControls {
}

// @public
export interface IConfig {
    accountId?: string;
    addRequestContext?: (requestContext?: IRequestContext) => ICustomProperties;
    ajaxPerfLookupDelay?: number;
    appId?: string;
    autoExceptionInstrumented?: boolean;
    autoTrackPageVisitTime?: boolean;
    autoUnhandledPromiseInstrumented?: boolean;
    convertUndefined?: any;
    cookieDomain?: string;
    cookiePath?: string;
    // (undocumented)
    correlationHeaderDomains?: string[];
    correlationHeaderExcludedDomains?: string[];
    correlationHeaderExcludePatterns?: RegExp[];
    customHeaders?: [{
        header: string;
        value: string;
    }];
    disableAjaxTracking?: boolean;
    disableCookiesUsage?: boolean;
    disableCorrelationHeaders?: boolean;
    disableDataLossAnalysis?: boolean;
    disableExceptionTracking?: boolean;
    disableFetchTracking?: boolean;
    disableFlushOnBeforeUnload?: boolean;
    disableFlushOnUnload?: boolean;
    disableIkeyDeprecationMessage?: boolean;
    disablePageShowEvents?: string[];
    disablePageUnloadEvents?: string[];
    disableTelemetry?: boolean;
    disableXhr?: boolean;
    distributedTracingMode?: DistributedTracingModes;
    emitLineDelimitedJson?: boolean;
    enableAjaxErrorStatusText?: boolean;
    enableAjaxPerfTracking?: boolean;
    enableAutoRouteTracking?: boolean;
    enableCorsCorrelation?: boolean;
    enableDebug?: boolean;
    enableRequestHeaderTracking?: boolean;
    enableResponseHeaderTracking?: boolean;
    enableSessionStorageBuffer?: boolean;
    enableUnhandledPromiseRejectionTracking?: boolean;
    eventsLimitInMem?: number;
    excludeRequestFromAutoTrackingPatterns?: string[] | RegExp[];
    isBeaconApiDisabled?: boolean;
    isBrowserLinkTrackingEnabled?: boolean;
    // @deprecated (undocumented)
    isCookieUseDisabled?: boolean;
    isRetryDisabled?: boolean;
    isStorageUseDisabled?: boolean;
    maxAjaxCallsPerView?: number;
    maxAjaxPerfLookupAttempts?: number;
    maxBatchInterval?: number;
    maxBatchSizeInBytes?: number;
    namePrefix?: string;
    onunloadDisableBeacon?: boolean;
    onunloadDisableFetch?: boolean;
    overridePageViewDuration?: boolean;
    samplingPercentage?: number;
    sdkExtension?: string;
    sessionCookiePostfix?: string;
    sessionExpirationMs?: number;
    sessionRenewalMs?: number;
    // @deprecated (undocumented)
    url?: string;
    userCookiePostfix?: string;
}

// @public (undocumented)
export interface IContextTagKeys {
    readonly applicationBuild: string;
    readonly applicationId: string;
    readonly applicationLayer: string;
    readonly applicationTypeId: string;
    readonly applicationVersion: string;
    // (undocumented)
    readonly cloudDeploymentUnit: string;
    // (undocumented)
    readonly cloudEnvironment: string;
    // (undocumented)
    readonly cloudLocation: string;
    // (undocumented)
    readonly cloudName: string;
    readonly cloudRole: string;
    readonly cloudRoleInstance: string;
    // (undocumented)
    readonly cloudRoleVer: string;
    // (undocumented)
    readonly deviceBrowser: string;
    readonly deviceBrowserVersion: string;
    // (undocumented)
    readonly deviceFriendlyName: string;
    readonly deviceId: string;
    // (undocumented)
    readonly deviceIp: string;
    // (undocumented)
    readonly deviceLanguage: string;
    readonly deviceLocale: string;
    // (undocumented)
    readonly deviceMachineName: string;
    readonly deviceModel: string;
    // (undocumented)
    readonly deviceNetwork: string;
    // (undocumented)
    readonly deviceNetworkName: string;
    readonly deviceOEMName: string;
    // (undocumented)
    readonly deviceOS: string;
    readonly deviceOSVersion: string;
    readonly deviceRoleInstance: string;
    readonly deviceRoleName: string;
    // (undocumented)
    readonly deviceScreenResolution: string;
    readonly deviceType: string;
    // (undocumented)
    readonly deviceVMName: string;
    readonly internalAgentVersion: string;
    readonly internalNodeName: string;
    readonly internalSdkSrc: string;
    readonly internalSdkVersion: string;
    readonly internalSnippet: string;
    readonly locationCity: string;
    readonly locationCountry: string;
    readonly locationIp: string;
    readonly locationProvince: string;
    readonly operationCorrelationVector: string;
    readonly operationId: string;
    readonly operationName: string;
    readonly operationParentId: string;
    // (undocumented)
    readonly operationRootId: string;
    readonly operationSyntheticSource: string;
    readonly sessionId: string;
    readonly sessionIsFirst: string;
    // (undocumented)
    readonly sessionIsNew: string;
    // (undocumented)
    readonly userAccountAcquisitionDate: string;
    readonly userAccountId: string;
    readonly userAgent: string;
    // (undocumented)
    readonly userAnonymousUserAcquisitionDate: string;
    // (undocumented)
    readonly userAuthenticatedUserAcquisitionDate: string;
    readonly userAuthUserId: string;
    readonly userId: string;
    readonly userStoreRegion: string;
}

// @public (undocumented)
export interface ICorrelationConfig {
    addRequestContext?: (requestContext?: IRequestContext) => ICustomProperties;
    ajaxPerfLookupDelay?: number;
    // (undocumented)
    appId?: string;
    // (undocumented)
    correlationHeaderDomains?: string[];
    // (undocumented)
    correlationHeaderExcludedDomains: string[];
    // (undocumented)
    correlationHeaderExcludePatterns?: RegExp[];
    // (undocumented)
    disableAjaxTracking: boolean;
    // (undocumented)
    disableCorrelationHeaders: boolean;
    // (undocumented)
    disableFetchTracking: boolean;
    // (undocumented)
    distributedTracingMode: DistributedTracingModes;
    // (undocumented)
    enableAjaxErrorStatusText?: boolean;
    enableAjaxPerfTracking?: boolean;
    // (undocumented)
    enableCorsCorrelation: boolean;
    // (undocumented)
    enableRequestHeaderTracking?: boolean;
    // (undocumented)
    enableResponseHeaderTracking?: boolean;
    excludeRequestFromAutoTrackingPatterns?: string[] | RegExp[];
    ignoreHeaders?: string[];
    // (undocumented)
    maxAjaxCallsPerView: number;
    maxAjaxPerfLookupAttempts?: number;
}

// @public (undocumented)
export interface ICorrelationIdHelper {
    canIncludeCorrelationHeader(config: ICorrelationConfig, requestUrl: string, currentHost?: string): boolean;
    // (undocumented)
    correlationIdPrefix: string;
    getCorrelationContext(responseHeader: string): string | undefined;
    getCorrelationContextValue(responseHeader: string, key: string): string | undefined;
}

// @public (undocumented)
export interface IDataSanitizer {
    MAX_EXCEPTION_LENGTH: number;
    MAX_ID_LENGTH: number;
    MAX_MESSAGE_LENGTH: number;
    MAX_NAME_LENGTH: number;
    MAX_PROPERTY_LENGTH: number;
    MAX_STRING_LENGTH: number;
    MAX_URL_LENGTH: number;
    // (undocumented)
    padNumber: (num: number) => string;
    // (undocumented)
    sanitizeException: (logger: IDiagnosticLogger, exception: any) => string;
    // (undocumented)
    sanitizeId: (logger: IDiagnosticLogger, id: string) => string;
    // (undocumented)
    sanitizeInput: (logger: IDiagnosticLogger, input: any, maxLength: number, _msgId: _eInternalMessageId) => any;
    // (undocumented)
    sanitizeKey: (logger: IDiagnosticLogger, name: any) => string;
    // (undocumented)
    sanitizeKeyAndAddUniqueness: (logger: IDiagnosticLogger, key: any, map: any) => string;
    // (undocumented)
    sanitizeMeasurements: (logger: IDiagnosticLogger, measurements: any) => any;
    // (undocumented)
    sanitizeMessage: (logger: IDiagnosticLogger, message: any) => string;
    // (undocumented)
    sanitizeProperties: (logger: IDiagnosticLogger, properties: any) => any;
    // (undocumented)
    sanitizeString: (logger: IDiagnosticLogger, value: any, maxLength?: number) => string;
    // (undocumented)
    sanitizeUrl: (logger: IDiagnosticLogger, url: any) => string;
    trim: (str: any) => string;
}

// @public (undocumented)
export interface IDateTimeUtils {
    GetDuration: (start: number, end: number) => number;
    Now: () => number;
}

// Warning: (ae-forgotten-export) The symbol "IPartC" needs to be exported by the entry point applicationinsights-common.d.ts
//
// @public
export interface IDependencyTelemetry extends IPartC {
    // (undocumented)
    correlationContext?: string;
    // (undocumented)
    data?: string;
    // (undocumented)
    duration?: number;
    // (undocumented)
    id: string;
    // (undocumented)
    iKey?: string;
    // (undocumented)
    name?: string;
    // (undocumented)
    responseCode: number;
    // (undocumented)
    startTime?: Date;
    // (undocumented)
    success?: boolean;
    // (undocumented)
    target?: string;
    // (undocumented)
    type?: string;
}

// @public (undocumented)
export interface IDevice {
    deviceClass: string;
    id: string;
    ip: string;
    model: string;
    resolution: string;
}

// @public (undocumented)
export interface IEnvelope extends ISerializable {
    data: any;
    iKey: string;
    name: string;
    sampleRate: number;
    seq: string;
    tags: {
        [name: string]: any;
    };
    time: string;
    ver: number;
}

// @public (undocumented)
export interface IEventTelemetry extends IPartC {
    iKey?: string;
    name: string;
}

// @public (undocumented)
export interface IExceptionInternal extends IPartC {
    // Warning: (ae-forgotten-export) The symbol "IExceptionDetailsInternal" needs to be exported by the entry point applicationinsights-common.d.ts
    //
    // (undocumented)
    exceptions: IExceptionDetailsInternal[];
    // (undocumented)
    id: string;
    // (undocumented)
    isManual: boolean;
    // (undocumented)
    problemGroup: string;
    // (undocumented)
    severityLevel?: SeverityLevel | number;
    // (undocumented)
    ver: string;
}

// @public
export interface IExceptionTelemetry extends IPartC {
    // @deprecated (undocumented)
    error?: Error;
    exception?: Error | IAutoExceptionTelemetry;
    id?: string;
    severityLevel?: SeverityLevel | number;
}

// @public (undocumented)
export interface IInternal {
    agentVersion: string;
    sdkSrc: string;
    sdkVersion: string;
    snippetVer: string;
}

// @public (undocumented)
export interface ILocation {
    ip: string;
}

// @public (undocumented)
export interface IMetricTelemetry extends IPartC {
    average: number;
    iKey?: string;
    max?: number;
    min?: number;
    name: string;
    sampleCount?: number;
    stdDev?: number;
}

// @public (undocumented)
export interface IOperatingSystem {
    // (undocumented)
    name: string;
}

// @public
export interface IPageViewData extends IEventData {
    duration: string;
    id: string;
    url: string;
}

// @public (undocumented)
export interface IPageViewPerformanceTelemetry extends IPartC {
    domProcessing?: string;
    duration?: string;
    name?: string;
    networkConnect?: string;
    perfTotal?: string;
    receivedResponse?: string;
    sentRequest?: string;
    uri?: string;
}

// @public (undocumented)
export interface IPageViewPerformanceTelemetryInternal extends IPageViewPerformanceTelemetry {
    durationMs?: number;
    id?: string;
    isValid?: boolean;
    ver?: string;
}

// @public
export interface IPageViewTelemetry extends IPartC {
    iKey?: string;
    isLoggedIn?: boolean;
    name?: string;
    pageType?: string;
    properties?: {
        duration?: number;
        [key: string]: any;
    };
    refUri?: string;
    uri?: string;
}

// @public (undocumented)
export interface IPageViewTelemetryInternal extends IPageViewTelemetry {
    id?: string;
    ver?: string;
}

// @public (undocumented)
export interface IPropertiesPlugin {
    // (undocumented)
    readonly context: ITelemetryContext;
}

// @public (undocumented)
export interface IRequestContext {
    // (undocumented)
    request?: Request;
    // (undocumented)
    response?: Response | string;
    // (undocumented)
    status?: number;
    // (undocumented)
    xhr?: XMLHttpRequest;
}

// @public (undocumented)
export interface IRequestHeaders {
    requestContextAppIdFormat: string;
    requestContextHeader: string;
    // (undocumented)
    requestContextHeaderLowerCase: string;
    requestContextTargetKey: string;
    requestIdHeader: string;
    sdkContextHeader: string;
    sdkContextHeaderAppIdRequest: string;
    traceParentHeader: string;
    traceStateHeader: string;
}

// @public (undocumented)
export interface ISample {
    // (undocumented)
    isSampledIn(envelope: ITelemetryItem): boolean;
    sampleRate: number;
}

export { isBeaconApiSupported }

// @public (undocumented)
export function isCrossOriginError(message: string | Event, url: string, lineNumber: number, columnNumber: number, error: Error | Event): boolean;

// @public (undocumented)
export interface ISerializable {
    aiDataContract: any;
}

// @public (undocumented)
export interface ISession {
    acquisitionDate?: number;
    id?: string;
    renewalDate?: number;
}

// @public (undocumented)
export function isInternalApplicationInsightsEndpoint(endpointUrl: string): boolean;

export { isSampledFlag }

export { isValidSpanId }

export { isValidTraceId }

export { isValidTraceParent }

// @public (undocumented)
export interface ITelemetryContext {
    appId: () => string;
    readonly application: IApplication;
    readonly device: IDevice;
    getSessionId: () => string;
    readonly internal: IInternal;
    readonly location: ILocation;
    readonly os?: IOperatingSystem;
    readonly session: ISession;
    readonly telemetryTrace: ITelemetryTrace;
    readonly user: IUserContext;
    readonly web?: IWeb;
}

// @public (undocumented)
export interface ITelemetryTrace {
    name?: string;
    parentID?: string;
    traceFlags?: number;
    traceID?: string;
    // @deprecated (undocumented)
    traceState?: ITraceState;
}

export { ITraceParent }

// @public (undocumented)
export interface ITraceState {
}

// @public (undocumented)
export interface ITraceTelemetry extends IPartC {
    iKey?: string;
    message: string;
    severityLevel?: SeverityLevel;
}

// @public (undocumented)
export interface IUrlHelper {
    // (undocumented)
    getAbsoluteUrl: (url: string) => string;
    // (undocumented)
    getCompleteUrl: (method: string, absoluteUrl: string) => string;
    // (undocumented)
    getPathName: (url: string) => string;
    parseFullHost: (url: string, inclPort?: boolean) => string;
    // (undocumented)
    parseHost: (url: string, inclPort?: boolean) => string;
    // (undocumented)
    parseUrl: (url: string) => HTMLAnchorElement;
}

// @public (undocumented)
export interface IUser {
    accountAcquisitionDate: string;
    accountId: string;
    authenticatedId: string;
    config: any;
    id: string;
    isNewUser?: boolean;
    isUserCookieSet?: boolean;
    localId: string;
}

// @public (undocumented)
export interface IUserContext extends IUser {
    // (undocumented)
    clearAuthenticatedUserContext(): void;
    // (undocumented)
    setAuthenticatedUserContext(authenticatedUserId: string, accountId?: string, storeInCookie?: boolean): void;
    // (undocumented)
    update(userId?: string): void;
}

// @public (undocumented)
export interface IUtil {
    addEventHandler: (obj: any, eventNameWithoutOn: string, handlerRef: any, useCapture: boolean) => boolean;
    // @deprecated (undocumented)
    canUseCookies: (logger: IDiagnosticLogger) => any;
    canUseLocalStorage: () => boolean;
    canUseSessionStorage: () => boolean;
    // (undocumented)
    createDomEvent: (eventName: string) => Event;
    // @deprecated (undocumented)
    deleteCookie: (logger: IDiagnosticLogger, name: string) => void;
    // @deprecated (undocumented)
    disableCookies: () => void;
    // (undocumented)
    disableStorage: () => void;
    // (undocumented)
    disallowsSameSiteNone: (userAgent: string) => boolean;
    dump: (object: any) => string;
    generateW3CId: () => string;
    // @deprecated (undocumented)
    getCookie: (logger: IDiagnosticLogger, name: string) => string;
    getExceptionName: (object: any) => string;
    // (undocumented)
    getExtension: (extensions: IPlugin[], identifier: string) => IPlugin | null;
    getIEVersion: (userAgentStr?: string) => number;
    getSessionStorage: (logger: IDiagnosticLogger, name: string) => string;
    getSessionStorageKeys: () => string[];
    getStorage: (logger: IDiagnosticLogger, name: string) => string;
    isArray: (obj: any) => boolean;
    IsBeaconApiSupported: () => boolean;
    isCrossOriginError: (message: string | Event, url: string, lineNumber: number, columnNumber: number, error: Error) => boolean;
    isDate: (obj: any) => obj is Date;
    isError: (obj: any) => obj is Error;
    isInternalApplicationInsightsEndpoint: (endpointUrl: string) => boolean;
    msToTimeSpan: (totalms: number) => string;
    newId: () => string;
    // (undocumented)
    NotSpecified: string;
    random32: () => number;
    removeSessionStorage: (logger: IDiagnosticLogger, name: string) => boolean;
    removeStorage: (logger: IDiagnosticLogger, name: string) => boolean;
    // @deprecated (undocumented)
    setCookie: (logger: IDiagnosticLogger, name: string, value: string, domain?: string) => void;
    setSessionStorage: (logger: IDiagnosticLogger, name: string, data: string) => boolean;
    setStorage: (logger: IDiagnosticLogger, name: string, data: string) => boolean;
    // (undocumented)
    stringToBoolOrDefault: (str: any, defaultValue?: boolean) => boolean;
    // (undocumented)
    toISOStringForIE8: (date: Date) => string;
    trim: (str: any) => string;
}

// @public (undocumented)
export interface IWeb {
    browser: string;
    browserLang: string;
    browserVer: string;
    domain: string;
    isManual: boolean;
    screenRes: string;
    userConsent: boolean;
}

// Warning: (ae-forgotten-export) The symbol "IMetricData" needs to be exported by the entry point applicationinsights-common.d.ts
//
// @public (undocumented)
export class Metric implements IMetricData, ISerializable {
    constructor(logger: IDiagnosticLogger, name: string, value: number, count?: number, min?: number, max?: number, stdDev?: number, properties?: any, measurements?: {
        [key: string]: number;
    });
    // (undocumented)
    aiDataContract: {
        ver: FieldType;
        metrics: FieldType;
        properties: FieldType;
    };
    // (undocumented)
    static dataType: string;
    // (undocumented)
    static envelopeType: string;
    measurements: any;
    // Warning: (ae-forgotten-export) The symbol "DataPoint" needs to be exported by the entry point applicationinsights-common.d.ts
    metrics: DataPoint[];
    properties: any;
    ver: number;
}

// @public
export function msToTimeSpan(totalms: number): string;

// @public (undocumented)
export class PageView implements IPageViewData, ISerializable {
    constructor(logger: IDiagnosticLogger, name?: string, url?: string, durationMs?: number, properties?: {
        [key: string]: string;
    }, measurements?: {
        [key: string]: number;
    }, id?: string);
    // (undocumented)
    aiDataContract: {
        ver: FieldType;
        name: FieldType;
        url: FieldType;
        duration: FieldType;
        properties: FieldType;
        measurements: FieldType;
        id: FieldType;
    };
    // (undocumented)
    static dataType: string;
    duration: string;
    // (undocumented)
    static envelopeType: string;
    id: string;
    measurements: any;
    name: string;
    properties: any;
    url: string;
    ver: number;
}

// Warning: (ae-forgotten-export) The symbol "IPageViewPerfData" needs to be exported by the entry point applicationinsights-common.d.ts
//
// @public (undocumented)
export class PageViewPerformance implements IPageViewPerfData, ISerializable {
    constructor(logger: IDiagnosticLogger, name: string, url: string, unused: number, properties?: {
        [key: string]: string;
    }, measurements?: {
        [key: string]: number;
    }, cs4BaseData?: IPageViewPerformanceTelemetry);
    // (undocumented)
    aiDataContract: {
        ver: FieldType;
        name: FieldType;
        url: FieldType;
        duration: FieldType;
        perfTotal: FieldType;
        networkConnect: FieldType;
        sentRequest: FieldType;
        receivedResponse: FieldType;
        domProcessing: FieldType;
        properties: FieldType;
        measurements: FieldType;
    };
    // (undocumented)
    static dataType: string;
    domProcessing: string;
    duration: string;
    // (undocumented)
    static envelopeType: string;
    id: string;
    measurements: any;
    name: string;
    networkConnect: string;
    perfTotal: string;
    properties: any;
    receivedResponse: string;
    sentRequest: string;
    url: string;
    ver: number;
}

// Warning: (ae-forgotten-export) The symbol "ConnectionString" needs to be exported by the entry point applicationinsights-common.d.ts
//
// @public (undocumented)
export function parseConnectionString(connectionString?: string): ConnectionString;

export { parseTraceParent }

// @public (undocumented)
export const ProcessLegacy = "ProcessLegacy";

// @public (undocumented)
export const PropertiesPluginIdentifier = "AppInsightsPropertiesPlugin";

// Warning: (ae-forgotten-export) The symbol "IRemoteDependencyData" needs to be exported by the entry point applicationinsights-common.d.ts
//
// @public (undocumented)
export class RemoteDependencyData implements IRemoteDependencyData, ISerializable {
    constructor(logger: IDiagnosticLogger, id: string, absoluteUrl: string, commandName: string, value: number, success: boolean, resultCode: number, method?: string, requestAPI?: string, correlationContext?: string, properties?: Object, measurements?: Object);
    // (undocumented)
    aiDataContract: {
        id: FieldType;
        ver: FieldType;
        name: FieldType;
        resultCode: FieldType;
        duration: FieldType;
        success: FieldType;
        data: FieldType;
        target: FieldType;
        type: FieldType;
        properties: FieldType;
        measurements: FieldType;
        kind: FieldType;
        value: FieldType;
        count: FieldType;
        min: FieldType;
        max: FieldType;
        stdDev: FieldType;
        dependencyKind: FieldType;
        dependencySource: FieldType;
        commandName: FieldType;
        dependencyTypeName: FieldType;
    };
    data: string;
    // (undocumented)
    static dataType: string;
    duration: string;
    // (undocumented)
    static envelopeType: string;
    id: string;
    measurements: any;
    name: string;
    properties: any;
    resultCode: string;
    success: boolean;
    target: string;
    type: string;
    ver: number;
}

// @public (undocumented)
export const RequestHeaders: IRequestHeaders & {
    requestContextHeader: "Request-Context";
    requestContextTargetKey: "appId";
    requestContextAppIdFormat: "appId=cid-v1:";
    requestIdHeader: "Request-Id";
    traceParentHeader: "traceparent";
    traceStateHeader: "tracestate";
    sdkContextHeader: "Sdk-Context";
    sdkContextHeaderAppIdRequest: "appId";
    requestContextHeaderLowerCase: "request-context";
    0: "Request-Context";
    1: "appId";
    2: "appId=cid-v1:";
    3: "Request-Id";
    4: "traceparent";
    5: "tracestate";
    6: "Sdk-Context";
    7: "appId";
    8: "request-context";
};

// @public (undocumented)
export const SampleRate = "sampleRate";

// @public
export const SeverityLevel: EnumValue<typeof eSeverityLevel>;

// @public (undocumented)
export type SeverityLevel = number | eSeverityLevel;

// @public (undocumented)
export function stringToBoolOrDefault(str: any, defaultValue?: boolean): boolean;

// @public (undocumented)
export const strNotSpecified = "not_specified";

// @public (undocumented)
export class TelemetryItemCreator {
    static create: typeof createTelemetryItem;
}

// Warning: (ae-forgotten-export) The symbol "IMessageData" needs to be exported by the entry point applicationinsights-common.d.ts
//
// @public (undocumented)
export class Trace implements IMessageData, ISerializable {
    constructor(logger: IDiagnosticLogger, message: string, severityLevel?: SeverityLevel, properties?: any, measurements?: {
        [key: string]: number;
    });
    // (undocumented)
    aiDataContract: {
        ver: FieldType;
        message: FieldType;
        severityLevel: FieldType;
        properties: FieldType;
    };
    // (undocumented)
    static dataType: string;
    // (undocumented)
    static envelopeType: string;
    measurements: any;
    message: string;
    properties: any;
    severityLevel: SeverityLevel;
    ver: number;
}

// @public (undocumented)
export function urlGetAbsoluteUrl(url: string): string;

// @public (undocumented)
export function urlGetCompleteUrl(method: string, absoluteUrl: string): string;

// @public (undocumented)
export function urlGetPathName(url: string): string;

// @public (undocumented)
export const UrlHelper: IUrlHelper;

// @public (undocumented)
export function urlParseFullHost(url: string, inclPort?: boolean): string;

// @public (undocumented)
export function urlParseHost(url: string, inclPort?: boolean): string;

// @public (undocumented)
export function urlParseUrl(url: string): HTMLAnchorElement;

// @public (undocumented)
export const Util: IUtil;

// @public
export function utlCanUseLocalStorage(reset?: boolean): boolean;

// @public (undocumented)
export function utlCanUseSessionStorage(reset?: boolean): boolean;

// @public
export function utlDisableStorage(): void;

// @public
export function utlEnableStorage(): void;

// @public (undocumented)
export function utlGetLocalStorage(logger: IDiagnosticLogger, name: string): string;

// @public (undocumented)
export function utlGetSessionStorage(logger: IDiagnosticLogger, name: string): string;

// @public (undocumented)
export function utlGetSessionStorageKeys(): string[];

// @public (undocumented)
export function utlRemoveSessionStorage(logger: IDiagnosticLogger, name: string): boolean;

// @public (undocumented)
export function utlRemoveStorage(logger: IDiagnosticLogger, name: string): boolean;

// @public (undocumented)
export function utlSetLocalStorage(logger: IDiagnosticLogger, name: string, data: string): boolean;

// @public (undocumented)
export function utlSetSessionStorage(logger: IDiagnosticLogger, name: string, data: string): boolean;

// (No @packageDocumentation comment for this package)

```
