"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var diagnostic_channel_1 = require("diagnostic-channel");
exports.AzureMonitorSymbol = "Azure_Monitor_Tracer";
/**
 * By default, @azure/core-tracing default tracer is a NoopTracer.
 * This patching changes the default tracer to a patched BasicTracer
 * which emits ended spans as diag-channel events.
 *
 * The @opentelemetry/tracing package must be installed to use these patches
 * https://www.npmjs.com/package/@opentelemetry/tracing
 * @param coreTracing
 */
var azureCoreTracingPatchFunction = function (coreTracing) {
    try {
        var BasicTracer = require("@opentelemetry/tracing").BasicTracer;
        var tracerConfig = diagnostic_channel_1.channel.spanContextPropagator
            ? { scopeManager: diagnostic_channel_1.channel.spanContextPropagator }
            : undefined;
        var tracer_1 = new BasicTracer(tracerConfig);
        // Patch startSpan instead of using spanProcessor.onStart because parentSpan must be
        // set while the span is constructed
        var startSpanOriginal_1 = tracer_1.startSpan;
        tracer_1.startSpan = function (name, options) {
            // if no parent span was provided, apply the current context
            if (!options || !options.parent) {
                var parentOperation = tracer_1.getCurrentSpan();
                if (parentOperation && parentOperation.operation && parentOperation.operation.traceparent) {
                    options = __assign({}, options, { parent: {
                            traceId: parentOperation.operation.traceparent.traceId,
                            spanId: parentOperation.operation.traceparent.spanId,
                        } });
                }
            }
            var span = startSpanOriginal_1.call(this, name, options);
            span.addEvent("Application Insights Integration enabled");
            return span;
        };
        tracer_1.addSpanProcessor(new AzureMonitorSpanProcessor());
        tracer_1[exports.AzureMonitorSymbol] = true;
        coreTracing.setTracer(tracer_1); // recordSpanData is not present on BasicTracer - cast to any
    }
    catch (e) { /* squash errors */ }
    return coreTracing;
};
var AzureMonitorSpanProcessor = /** @class */ (function () {
    function AzureMonitorSpanProcessor() {
    }
    AzureMonitorSpanProcessor.prototype.onStart = function (span) {
        // noop since startSpan is already patched
    };
    AzureMonitorSpanProcessor.prototype.onEnd = function (span) {
        diagnostic_channel_1.channel.publish("azure-coretracing", span);
    };
    AzureMonitorSpanProcessor.prototype.shutdown = function () {
        // noop
    };
    return AzureMonitorSpanProcessor;
}());
exports.azureCoreTracing = {
    versionSpecifier: ">= 1.0.0 < 2.0.0",
    patch: azureCoreTracingPatchFunction,
};
function enable() {
    diagnostic_channel_1.channel.registerMonkeyPatch("@azure/core-tracing", exports.azureCoreTracing);
}
exports.enable = enable;