"use strict";
/**********************************************************************
 * Copyright (c) 2023 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevWorkspaceId = void 0;
const process_1 = require("process");
const files_1 = require("./files");
const fs = require("./fs-extra");
const DEVWORKSPACE_ID_MASK = "https://{{che-cluster}}.{{host}}/{{namespace}}/{{workspace-name}}/{{port}}/";
class DevWorkspaceId {
    async configure() {
        console.log("# Setting curent DevWorkspace ID to che-code...");
        if (!process_1.env.DEVWORKSPACE_ID) {
            console.log("  > env.DEVWORKSPACE_ID is not set, skip this step");
            return;
        }
        console.log(`  > apply DevWorkspace ID [${process_1.env.DEVWORKSPACE_ID}]`);
        try {
            await this.update(files_1.FILE_WORKBENCH_WEB_MAIN, DEVWORKSPACE_ID_MASK, process_1.env.DEVWORKSPACE_ID);
        }
        catch (err) {
            console.error(`${err.message} Webviews will not work if CDN disabled.`);
        }
    }
    async update(file, text, newText) {
        const content = await fs.readFile(file);
        const newContent = content.replace(text, newText);
        await fs.writeFile(file, newContent);
    }
}
exports.DevWorkspaceId = DevWorkspaceId;
//# sourceMappingURL=devworkspace-id.js.map