/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
import { V1alpha2DevWorkspace } from '@devfile/api';
import * as k8s from '@kubernetes/client-node';
import { ApiType } from '@kubernetes/client-node';
import { K8SRawResponse, $e } from '../api/k8s-service';
export declare class $f implements $e {
    private a;
    private b;
    private c;
    private d;
    private f;
    constructor();
    sendRawQuery(requestURL: string, opts: any): Promise<K8SRawResponse>;
    makeRequest(URL: string, opts: any): Promise<K8SRawResponse>;
    getConfig(): k8s.KubeConfig;
    makeApiClient<T extends ApiType>(apiClientType: new (server: string) => T): T;
    getCoreApi(): k8s.CoreV1Api;
    getCustomObjectsApi(): k8s.CustomObjectsApi;
    getSecret(labelSelector?: string): Promise<Array<k8s.V1Secret>>;
    replaceNamespacedSecret(name: string, secret: k8s.V1Secret): Promise<void>;
    createNamespacedSecret(secret: k8s.V1Secret): Promise<void>;
    deleteNamespacedSecret(secret: k8s.V1Secret): Promise<void>;
    getDevWorkspace(): Promise<V1alpha2DevWorkspace>;
    getDevWorkspaceName(): string;
    getDevWorkspaceNamespace(): string;
}
