"use strict";
/**********************************************************************
 * Copyright (c) 2023 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.mkdir = exports.isFile = exports.readdir = exports.pathExists = exports.writeFile = exports.readFile = void 0;
/**
 * This is a wrapper to comfortable using `fs` package like `fs-extra`.
 * Why do we need to add the wrapper:
 *   - it allows to get rid of using `fs-extra` package
 *   - it allows to use common `node_modules` directory for launcher and VS Code
 *   - it simplifies writing tests and allows to easily mock this module
 */
const fs = require("fs");
async function readFile(file) {
    return fs.readFileSync(file, "utf8");
}
exports.readFile = readFile;
async function writeFile(file, content) {
    fs.writeFileSync(file, content, "utf8");
}
exports.writeFile = writeFile;
async function pathExists(path) {
    return fs.existsSync(path);
}
exports.pathExists = pathExists;
async function readdir(path) {
    return fs.readdirSync(path);
}
exports.readdir = readdir;
async function isFile(path) {
    return fs.statSync(path).isFile();
}
exports.isFile = isFile;
async function mkdir(path) {
    fs.mkdirSync(path, {
        recursive: true,
    });
}
exports.mkdir = mkdir;
//# sourceMappingURL=fs-extra.js.map