/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
import * as k8s from '@kubernetes/client-node';
import { ApiType } from '@kubernetes/client-node';
import { K8SService, K8SRawResponse } from '../api/k8s-service';
export declare class K8SServiceImpl implements K8SService {
    private kc;
    constructor();
    sendRawQuery(requestURL: string, opts: any): Promise<K8SRawResponse>;
    makeRequest(URL: string, opts: any): Promise<K8SRawResponse>;
    getConfig(): k8s.KubeConfig;
    makeApiClient<T extends ApiType>(apiClientType: new (server: string) => T): T;
}
