const sw=self,VERSION=4,resourceCacheName=`vscode-resource-cache-${VERSION}`,rootPath=sw.location.pathname.replace(/\/service-worker.js$/,""),searchParams=new URL(location.toString()).searchParams,remoteAuthority=searchParams.get("remoteAuthority"),resourceBaseAuthority=searchParams.get("vscode-resource-base-authority"),resolveTimeout=3e4;class RequestStore{constructor(){this.map=new Map,this.requestPool=0}get(e){const s=this.map.get(e);return s&&s.promise}create(){const e=++this.requestPool;let s;const o=new Promise(a=>s=a),r={resolve:s,promise:o};this.map.set(e,r);const c=setTimeout(()=>{if(clearTimeout(c),this.map.get(e)===r)return this.map.delete(e)},resolveTimeout);return{requestId:e,promise:o}}resolve(e,s){const o=this.map.get(e);return o?(o.resolve(s),this.map.delete(e),!0):!1}}const resourceRequestStore=new RequestStore,localhostRequestStore=new RequestStore,unauthorized=()=>new Response("Unauthorized",{status:401}),notFound=()=>new Response("Not Found",{status:404}),methodNotAllowed=()=>new Response("Method Not Allowed",{status:405});sw.addEventListener("message",async t=>{switch(t.data.channel){case"version":{const e=t.source;sw.clients.get(e.id).then(s=>{s&&s.postMessage({channel:"version",version:VERSION})});return}case"did-load-resource":{const e=t.data.data;resourceRequestStore.resolve(e.id,e)||console.log("Could not resolve unknown resource",e.path);return}case"did-load-localhost":{const e=t.data.data;localhostRequestStore.resolve(e.id,e.location)||console.log("Could not resolve unknown localhost",e.origin);return}default:console.log("Unknown message");return}}),sw.addEventListener("fetch",t=>{const e=new URL(t.request.url);if(e.protocol==="https:"&&e.hostname.endsWith("."+resourceBaseAuthority))switch(t.request.method){case"GET":case"HEAD":{const s=e.hostname.slice(0,e.hostname.length-(resourceBaseAuthority.length+1)),o=s.split("+",1)[0],r=s.slice(o.length+1);return t.respondWith(processResourceRequest(t,{scheme:o,authority:r,path:e.pathname,query:e.search.replace(/^\?/,"")}))}default:return t.respondWith(methodNotAllowed())}if(e.origin!==sw.origin&&e.host===remoteAuthority)switch(t.request.method){case"GET":case"HEAD":return t.respondWith(processResourceRequest(t,{path:e.pathname,scheme:e.protocol.slice(0,e.protocol.length-1),authority:e.host,query:e.search.replace(/^\?/,"")}));default:return t.respondWith(methodNotAllowed())}if(e.origin!==sw.origin&&e.host.match(/^(localhost|127.0.0.1|0.0.0.0):(\d+)$/))return t.respondWith(processLocalhostRequest(t,e))}),sw.addEventListener("install",t=>{t.waitUntil(sw.skipWaiting())}),sw.addEventListener("activate",t=>{t.waitUntil(sw.clients.claim())});async function processResourceRequest(t,e){const s=await sw.clients.get(t.clientId);if(!s)return console.error("Could not find inner client for request"),notFound();const o=getWebviewIdForClient(s);if(!o)return console.error("Could not resolve webview id"),notFound();const r=t.request.method==="GET",u=(n,m)=>{if(n.status===304){if(m)return m.clone();throw new Error("No cache found")}if(n.status===401)return unauthorized();if(n.status!==200)return notFound();const g={"Access-Control-Allow-Origin":"*"},h=n.data.byteLength,f=t.request.headers.get("range");if(f){const l=f.match(/^bytes\=(\d+)\-(\d+)?$/g);if(l){const C=Number(l[1]),q=Number(l[2])||h-1;return new Response(n.data.slice(C,q+1),{status:206,headers:{...g,"Content-range":`bytes 0-${q}/${h}`}})}else return new Response(null,{status:416,headers:{...g,"Content-range":`*/${h}`}})}const d={...g,"Content-Type":n.mime,"Content-Length":h.toString()};n.etag&&(d.ETag=n.etag,d["Cache-Control"]="no-cache"),n.mtime&&(d["Last-Modified"]=new Date(n.mtime).toUTCString());const w=new Response(n.data,{status:200,headers:d});return r&&n.etag&&caches.open(resourceCacheName).then(l=>l.put(t.request,w)),w.clone()},c=await getOuterIframeClient(o);if(!c.length)return console.log("Could not find parent client for request"),notFound();let a;r&&(a=await(await caches.open(resourceCacheName)).match(t.request));const{requestId:p,promise:i}=resourceRequestStore.create();for(const n of c)n.postMessage({channel:"load-resource",id:p,scheme:e.scheme,authority:e.authority,path:e.path,query:e.query,ifNoneMatch:a?.headers.get("ETag")});return i.then(n=>u(n,a))}async function processLocalhostRequest(t,e){const s=await sw.clients.get(t.clientId);if(!s)return fetch(t.request);const o=getWebviewIdForClient(s);if(!o)return console.error("Could not resolve webview id"),fetch(t.request);const r=e.origin,u=async i=>{if(!i)return fetch(t.request);const n=t.request.url.replace(new RegExp(`^${e.origin}(/|$)`),`${i}$1`);return new Response(null,{status:302,headers:{Location:n}})},c=await getOuterIframeClient(o);if(!c.length)return console.log("Could not find parent client for request"),notFound();const{requestId:a,promise:p}=localhostRequestStore.create();for(const i of c)i.postMessage({channel:"load-localhost",origin:r,id:a});return p.then(u)}function getWebviewIdForClient(t){return new URL(t.url).searchParams.get("id")}async function getOuterIframeClient(t){return(await sw.clients.matchAll({includeUncontrolled:!0})).filter(s=>{const o=new URL(s.url);return(o.pathname===`${rootPath}/`||o.pathname===`${rootPath}/index.html`||o.pathname===`${rootPath}/index-no-csp.html`)&&o.searchParams.get("id")===t})}

//# sourceMappingURL=https://ticino.blob.core.windows.net/sourcemaps/undefined/core/vs/workbench/contrib/webview/browser/pre/service-worker.js.map
