/**********************************************************************
 * Copyright (c) 2022 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
/**
 * Manage access to env variables defined by a dev workspace
 */
export declare class $ulc {
    /**
     * workspaceId - workspace ID taken from environment variable, always the same at workspace lifecycle
     */
    private readonly a;
    /**
     * workspaceName - workspace name taken from environment variable, always the same at workspace lifecycle
     */
    private readonly b;
    /**
     * workspaceNamespace - workspace namespace taken from environment variable, always the same at workspace lifecycle
     */
    private readonly c;
    /**
     * devWorkspaceFlattenedDevfilePath - environment variable holding the path to the flattened devworkspace template spec
     */
    private readonly d;
    /**
     * projectsRoot - Root directory for projects, default being /projects
     */
    private readonly e;
    /**
     * pluginRegistryURL - Plugin registry public URL
     */
    private readonly f;
    /**
     * dashboardURL - Dashboard URL
     */
    private readonly g;
    constructor();
    getWorkspaceId(): string;
    getWorkspaceName(): string;
    getWorkspaceNamespace(): string;
    getDevWorkspaceFlattenedDevfilePath(): string;
    getProjectsRoot(): string;
    getPluginRegistryURL(): string;
    getDashboardURL(): string;
}
