"use strict";
/**********************************************************************
 * Copyright (c) 2023 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlattenedDevfile = void 0;
const fs = require("./fs-extra");
const process_1 = require("process");
const jsYaml = require("js-yaml");
class FlattenedDevfile {
    async getDevfile() {
        if (!process_1.env.DEVWORKSPACE_FLATTENED_DEVFILE) {
            throw new Error("  > Unable to find flattened devworkspace file, env.DEVWORKSPACE_FLATTENED_DEVFILE is not set");
        }
        if (!this.devfile) {
            const content = await fs.readFile(process_1.env.DEVWORKSPACE_FLATTENED_DEVFILE);
            this.devfile = jsYaml.load(content);
        }
        return this.devfile;
    }
    async getCheCodeEndpoint() {
        var _a, _b;
        const devfile = await this.getDevfile();
        const cheCodeEndpointURI = (_b = (_a = devfile.components
            .find((component) => component.attributes &&
            "che-code-runtime" ===
                component.attributes["app.kubernetes.io/component"])) === null || _a === void 0 ? void 0 : _a.container.endpoints.find((e) => "che-code" === e.name)) === null || _b === void 0 ? void 0 : _b.attributes["controller.devfile.io/endpoint-url"];
        if (!cheCodeEndpointURI) {
            throw new Error(`Failure to find che-code endpoint in ${process_1.env.DEVWORKSPACE_FLATTENED_DEVFILE}`);
        }
        return cheCodeEndpointURI;
    }
    async getProjects() {
        const devfile = await this.getDevfile();
        return devfile.projects;
    }
}
exports.FlattenedDevfile = FlattenedDevfile;
//# sourceMappingURL=flattened-devfile.js.map