"use strict";
/**********************************************************************
 * Copyright (c) 2023 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductJSON = void 0;
const fs = require("./fs-extra");
const PRODUCT_JSON = "product.json";
class ProductJSON {
    async load() {
        const content = await fs.readFile(PRODUCT_JSON);
        this.json = JSON.parse(content);
        return this;
    }
    async save() {
        const serialized = JSON.stringify(this.json, null, "\t");
        await fs.writeFile(PRODUCT_JSON, serialized);
    }
    getWebviewContentExternalBaseUrlTemplate() {
        const url = this.json.webviewContentExternalBaseUrlTemplate;
        if (!url) {
            throw new Error("Failure to find .webviewContentExternalBaseUrlTemplate in product.json.");
        }
        return url;
    }
    setWebviewContentExternalBaseUrlTemplate(url) {
        this.json.webviewContentExternalBaseUrlTemplate = url;
    }
    getExtensionsGalleryServiceURL() {
        const gallery = this.json.extensionsGallery;
        if (!gallery) {
            throw new Error("Failure to find .extensionsGallery.serviceUrl in product.json.");
        }
        const url = gallery.serviceUrl;
        if (!url) {
            throw new Error("Failure to find .extensionsGallery.serviceUrl in product.json.");
        }
        return url;
    }
    setExtensionsGalleryServiceURL(url) {
        let gallery = this.json.extensionsGallery;
        if (!gallery) {
            gallery = {};
            this.json.extensionsGallery = gallery;
        }
        gallery.serviceUrl = url;
    }
    getExtensionsGalleryItemURL() {
        const gallery = this.json.extensionsGallery;
        if (!gallery) {
            throw new Error("Failure to find .extensionsGallery.serviceUrl in product.json.");
        }
        const url = gallery.itemUrl;
        if (!url) {
            throw new Error("Failure to find .extensionsGallery.itemUrl in product.json.");
        }
        return url;
    }
    setExtensionsGalleryItemURL(url) {
        let gallery = this.json.extensionsGallery;
        if (!gallery) {
            gallery = {};
            this.json.extensionsGallery = gallery;
        }
        gallery.itemUrl = url;
    }
}
exports.ProductJSON = ProductJSON;
//# sourceMappingURL=product-json.js.map