"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SidecarComponentsCreator = void 0;
const inversify_1 = require("inversify");
const container_plugin_remote_updater_1 = require("./container-plugin-remote-updater");
/**
 * Generate spec template components for every sidecar of plug-ins
 */
let SidecarComponentsCreator = class SidecarComponentsCreator {
    async create(extensionsWithSidecars) {
        // ok now add sidecar components
        return extensionsWithSidecars.map(entry => {
            // ensure it's max 63 characters
            const sidecarName = (entry.sidecarName || `sidecar-${entry.id.replace(/[^\w\s]/gi, '-')}`).substring(0, 63);
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const attributes = {
                'app.kubernetes.io/part-of': 'che-theia.eclipse.org',
                'app.kubernetes.io/component': 'vscode-extension',
                'che-theia.eclipse.org/vscode-extensions': entry.extensions,
            };
            // add preferences only if there are one
            if (entry.preferences && Object.keys(entry.preferences).length > 0) {
                attributes['che-theia.eclipse.org/vscode-preferences'] = entry.preferences;
            }
            const component = {
                name: sidecarName,
                attributes,
                container: entry.sidecar,
            };
            // add extra stuff
            this.containerPluginRemoteUpdater.update(sidecarName, component.container);
            return component;
        });
    }
};
__decorate([
    inversify_1.inject(container_plugin_remote_updater_1.ContainerPluginRemoteUpdater),
    __metadata("design:type", container_plugin_remote_updater_1.ContainerPluginRemoteUpdater)
], SidecarComponentsCreator.prototype, "containerPluginRemoteUpdater", void 0);
SidecarComponentsCreator = __decorate([
    inversify_1.injectable()
], SidecarComponentsCreator);
exports.SidecarComponentsCreator = SidecarComponentsCreator;
//# sourceMappingURL=sidecar-components-creator.js.map