"use strict";
/**********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerPluginRemoteUpdater = void 0;
const inversify_1 = require("inversify");
let ContainerPluginRemoteUpdater = class ContainerPluginRemoteUpdater {
    update(componentName, container) {
        let env = container.env;
        if (!env) {
            env = [];
            container.env = env;
        }
        env.push({
            name: 'PLUGIN_REMOTE_ENDPOINT_EXECUTABLE',
            value: '/remote-endpoint/plugin-remote-endpoint',
        });
        env.push({
            name: 'THEIA_PLUGINS',
            value: `local-dir:///plugins/sidecars/${componentName}`,
        });
        // next, the volumes
        let volumeMounts = container.volumeMounts;
        if (!volumeMounts) {
            volumeMounts = [];
            container.volumeMounts = volumeMounts;
        }
        volumeMounts.push({
            path: '/remote-endpoint',
            name: 'remote-endpoint',
        });
        volumeMounts.push({
            path: '/plugins',
            name: 'plugins',
        });
    }
};
ContainerPluginRemoteUpdater = __decorate([
    inversify_1.injectable()
], ContainerPluginRemoteUpdater);
exports.ContainerPluginRemoteUpdater = ContainerPluginRemoteUpdater;
//# sourceMappingURL=container-plugin-remote-updater.js.map