"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var DevContainerComponentFinder_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevContainerComponentFinder = void 0;
const inversify_1 = require("inversify");
/**
 * Need to find dev container from main dev workspace or from a template
 */
let DevContainerComponentFinder = DevContainerComponentFinder_1 = class DevContainerComponentFinder {
    async find(devfileContext) {
        // need to find definition
        var _a, _b, _c, _d, _e, _f;
        // first search if we have an optional annotated container
        const annotatedContainers = (_c = (_b = (_a = devfileContext.devWorkspace.spec) === null || _a === void 0 ? void 0 : _a.template) === null || _b === void 0 ? void 0 : _b.components) === null || _c === void 0 ? void 0 : _c.filter(component => component.attributes &&
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            component.attributes[DevContainerComponentFinder_1.DEV_CONTAINER_ATTRIBUTE] === true);
        if (annotatedContainers) {
            if (annotatedContainers.length === 1) {
                return annotatedContainers[0];
            }
            else if (annotatedContainers.length > 1) {
                throw new Error(`Only one container can be annotated with ${DevContainerComponentFinder_1.DEV_CONTAINER_ATTRIBUTE}: true`);
            }
        }
        // search in main devWorkspace (exclude theia as component name)
        const devComponents = (_f = (_e = (_d = devfileContext.devWorkspace.spec) === null || _d === void 0 ? void 0 : _d.template) === null || _e === void 0 ? void 0 : _e.components) === null || _f === void 0 ? void 0 : _f.filter(component => component.container && component.name !== 'theia-ide').filter(
        // we should ignore component that do not mount the sources
        component => component.container && component.container.mountSources !== false);
        // only one, fine, else error
        if (!devComponents || devComponents.length === 0) {
            throw new Error('Not able to find any dev container component in DevWorkspace');
        }
        else if (devComponents.length === 1) {
            return devComponents[0];
        }
        else {
            console.warn(`More than one dev container component has been potentially found, taking the first one of ${devComponents.map(component => component.name)}`);
            return devComponents[0];
        }
    }
};
DevContainerComponentFinder.DEV_CONTAINER_ATTRIBUTE = 'che-theia.eclipse.org/dev-container';
DevContainerComponentFinder = DevContainerComponentFinder_1 = __decorate([
    inversify_1.injectable()
], DevContainerComponentFinder);
exports.DevContainerComponentFinder = DevContainerComponentFinder;
//# sourceMappingURL=dev-container-component-finder.js.map